---
id: 63ec14d1c216aa063f0be4af
title: Step 1
challengeType: 0
dashedName: step-1
demoType: onLoad
---

# --description--

You will be building a shopping cart application. The HTML and CSS are already provided, but you will need to build the JavaScript to make the page interactive.

To start, you will need to get some of your elements from the DOM. Start by using `document.getElementById()` to get the`#cart-container`, `#products-container`, and `#dessert-card-container` elements. Store them in variables named `cartContainer`, `productsContainer`, and `dessertCards`, respectively.

Since these will not change, remember to use `const` to declare them.

# --hints--

You should use `document.getElementById()` to get the `#cart-container` element.

```js
assert.match(code, /document\.getElementById\(\s*('|"|`)cart-container\1\s*\)/);
```

You should assign the `#cart-container` element to a variable named `cartContainer`. Remember to use `const` to declare the variable.

```js
assert.match(code, /const\s+cartContainer\s*=\s*document\.getElementById\(\s*('|"|`)cart-container\1\s*\)/);
```

You should use `document.getElementById()` to get the `#products-container` element.

```js
assert.match(code, /document\.getElementById\(\s*('|"|`)products-container\1\s*\)/);
```

You should assign the `#products-container` element to a variable named `productsContainer`. Remember to use `const` to declare the variable.

```js
assert.match(code, /const\s+productsContainer\s*=\s*document\.getElementById\(\s*('|"|`)products-container\1\s*\)/);
```

You should use `document.getElementById()` to get the `#dessert-card-container` element.

```js
assert.match(code, /document\.getElementById\(\s*('|"|`)dessert-card-container\1\s*\)/);
```

You should assign the `#dessert-card-container` element to a variable named `dessertCards`. Remember to use `const` to declare the variable.

```js
assert.match(code, /const\s+dessertCards\s*=\s*document\.getElementById\(\s*('|"|`)dessert-card-container\1\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>freeCodeCamp Shopping Cart</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <header>
      <h1 class="title">Desserts Page</h1>
    </header>
    <main>
      <button id="cart-btn" type="button" class="btn">
        <span id="show-hide-cart">Show</span> Cart
      </button>
      <div id="cart-container">
        <button class="btn" id="clear-cart-btn">Clear Cart</button>
        <div id="products-container"></div>
        <p>Total number of items: <span id="total-items">0</span></p>
        <p>Subtotal: <span id="subtotal">$0</span></p>
        <p>Taxes: <span id="taxes">$0</span></p>
        <p>Total: <span id="total">$0</span></p>
      </div>
      <div id="dessert-card-container"></div>
    </main>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --black: #000;
  --white: #fff;
  --grey: #3b3b4f;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
}

.title {
  color: var(--light-grey);
  text-align: center;
  margin: 25px 0;
}

#dessert-card-container {
  display: flex;
  flex-direction: column;
  flex-wrap: wrap;
  align-items: center;
}

.dessert-card {
  background-color: var(--light-grey);
  padding: 15px;
  text-align: center;
  border-radius: 15px;
  margin: 20px 10px;
}

.dessert-price {
  font-size: 1.2rem;
}

.btn {
  display: block;
  cursor: pointer;
  width: 100px;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

#cart-btn {
  position: absolute;
  top: 0;
  right: 0;
}

.add-to-cart-btn {
  margin: 30px auto 10px;
}

#cart-container {
  display: none;
  position: absolute;
  top: 60px;
  right: 0;
  background-color: var(--light-grey);
  width: 200px;
  height: 400px;
  border: 8px double var(--black);
  border-radius: 15px;
  text-align: center;
  font-size: 1.2rem;
  overflow-y: scroll;
}

.product {
  margin: 25px 0;
}

.product-count {
  display: inline-block;
  margin-right: 10px;
}

.product-category {
  margin: 10px 0;
}

@media (min-width: 768px) {
  #dessert-card-container {
    flex-direction: row;
  }

  .dessert-card {
    flex: 1 0 21%;
  }

  #cart-container {
    width: 300px;
  }
}
```

```js
--fcc-editable-region--

--fcc-editable-region--
```
