---
id: 67fcd561ae787aba05a9d917
title: Step 3
challengeType: 0
dashedName: step-3
---

# --description--

Within the `form` element, add a `label` element with the text `Search for an item:`. Next, give the `label` an `htmlFor` attribute set to `search`. This will associate the label with an `input` element you'll add next.

Below the `label`, add an `input` element with the `type` and `id` attributes set to `search`. Also, give the `input` a placeholder of `Search...`, and an `aria-describedby` attribute set to `search-description`.

Finally, add a `p` element below the `input`, and give it the text `Type to filter the list below:` and an `id` of `search-description`. This will provide additional context for screen readers.

# --hints--

Your `form` element should contain a `label` element with the text `Search for an item:`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const label = testElem.querySelector('form label');
  assert.exists(label);
  assert.equal(label.textContent.toLowerCase().trim(), 'search for an item:');
```

Your `label` should have an `htmlFor` attribute set to `search`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const label = testElem.querySelector('form label');
  assert.equal(label.getAttribute('for'), 'search');
```

Your `form` element should contain an `input` element with the `type` and `id` attributes set to `search`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const input = testElem.querySelector('form input');
  assert.exists(input);
  assert.equal(input.getAttribute('type'), 'search');
  assert.equal(input.getAttribute('id'), 'search');
```

Your `input` should have a placeholder of `Search...` and an `aria-describedby` attribute set to `search-description`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const input = testElem.querySelector('form input');
  assert.equal(input.getAttribute('placeholder').toLowerCase().trim(), 'search...');
  assert.equal(input.getAttribute('aria-describedby'), 'search-description');
```

Your `form` element should contain a `p` element with the text `Type to filter the list below:`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const p = testElem.querySelector('form p');
  assert.exists(p);
  assert.equal(p.textContent.toLowerCase().trim(), 'type to filter the list below:');
```

Your `p` element should have an `id` of `search-description`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const p = testElem.querySelector('form p');
  assert.equal(p.getAttribute('id'), 'search-description');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Shopping List</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
      src="index.jsx"
    ></script>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <main id="app-container"></main>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { ShoppingList } from "./index.jsx";
      const appContainer = document.getElementById("app-container");
      const root = ReactDOM.createRoot(appContainer);
      root.render(<ShoppingList />);
    </script>
  </body>
</html>

```

```css
:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-orange: #f89808;
  --yellow: #f1be32;
  --golden-yellow: #feac32;
}

*,
*::before,
*::after {
  box-sizing: border-box;
}

body {
  font-family: Arial, sans-serif;
  line-height: 1.5;
  color: var(--dark-grey);
  background-color: var(--dark-grey);
}

main,
.container {
  display: flex;
  flex-direction: column;
  align-items: center;
}

.container {
  background-color: var(--light-grey);
  width: 90%;
  margin: 20px;
  padding: 10px;
}

h1 {
  color: var(--dark-grey);
}

form {
  text-align: center;
}

button {
  cursor: pointer;
}

button {
  cursor: pointer;
  width: 100px;
  margin: 3px;
  color: var(--dark-grey);
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}

button:hover {
  background-image: linear-gradient(#ffcc4c, #f89808);
}

input {
  color: var(--dark-grey);
  margin-left: 5px;
  padding: 3px;
}

li {
  text-align: left;
  margin: 10px 0;
}

.selected-item {
  font-weight: bold;
}

@media (min-width: 425px) {
  .container {
    width: 400px;
  }
}

```

```jsx
const { useState } = React;

export const ShoppingList = () => {
  return (
    <div className="container">
      <h1>Shopping List</h1>
      <form>
      --fcc-editable-region--
      
      --fcc-editable-region--
      </form>
    </div>
  );
};

```
