---
id: 67fcde1677d474ebe61b4f2e
title: Step 6
challengeType: 0
dashedName: step-6
---

# --description--

In the input element, add a `value` attribute and set it to the `query` state variable. This will allow the input field to display the current value of `query`. Also, remember that you need to use curly braces (`{}`) to embed JavaScript expressions like `query` in JSX.

Then, add an `onChange` event handler to the input element. Pass it an anonymous function that takes `e` as an argument, which is the event object. Inside the anonymous function, call `setQuery()` and pass it `e.target.value`. This will update the `query` state variable with the current value of the input field whenever the user types in it.

# --hints--

You should add a `value` attribute to the input element and set it to the `query` state variable.

```js
assert.match(code, /<input[^>]*value={\s*query\s*}[^>]*\/?>/);
```

Your `onChange` event handler should be a function that takes `e` as an argument.

```js
const input = document.querySelector('input');
const key = Object.keys(input).find(key => key.startsWith("__reactProps"));
const reactInput = input[key];
assert.match(reactInput.onChange.toString(), /onChange\s*\(\s*e\s*\)/);
```

Your `onChange` event handler should call `setQuery()` with `e.target.value`.

```js
const input = document.querySelector('input');
const key = Object.keys(input).find(key => key.startsWith("__reactProps"));
const reactInput = input[key];
assert.match(reactInput.onChange.toString(), /setQuery\s*\(\s*e\.target\.value\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Shopping List</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
      src="index.jsx"
    ></script>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <main id="app-container"></main>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { ShoppingList } from "./index.jsx";
      const appContainer = document.getElementById("app-container");
      const root = ReactDOM.createRoot(appContainer);
      root.render(<ShoppingList />);
    </script>
  </body>
</html>

```

```css
:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-orange: #f89808;
  --yellow: #f1be32;
  --golden-yellow: #feac32;
}

*,
*::before,
*::after {
  box-sizing: border-box;
}

body {
  font-family: Arial, sans-serif;
  line-height: 1.5;
  color: var(--dark-grey);
  background-color: var(--dark-grey);
}

main,
.container {
  display: flex;
  flex-direction: column;
  align-items: center;
}

.container {
  background-color: var(--light-grey);
  width: 90%;
  margin: 20px;
  padding: 10px;
}

h1 {
  color: var(--dark-grey);
}

form {
  text-align: center;
}

button {
  cursor: pointer;
}

button {
  cursor: pointer;
  width: 100px;
  margin: 3px;
  color: var(--dark-grey);
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}

button:hover {
  background-image: linear-gradient(#ffcc4c, #f89808);
}

input {
  color: var(--dark-grey);
  margin-left: 5px;
  padding: 3px;
}

li {
  text-align: left;
  margin: 10px 0;
}

.selected-item {
  font-weight: bold;
}

@media (min-width: 425px) {
  .container {
    width: 400px;
  }
}

```

```jsx
const { useState } = React;

const items = [
  "Apples",
  "Bananas",
  "Strawberries",
  "Blueberries",
  "Mangoes",
  "Pineapple",
  "Lettuce",
  "Broccoli",
  "Paper Towels",
  "Dish Soap",
];

export const ShoppingList = () => {
  const [query, setQuery] = useState("");

  return (
    <div className="container">
      <h1>Shopping List</h1>
      <form>
        <label htmlFor="search">Search for an item:</label>
        <input
          id="search"
          type="search"
          placeholder="Search..."
          aria-describedby="search-description"
          --fcc-editable-region--

          --fcc-editable-region--
        /> 
        <p id="search-description">Type to filter the list below:</p>
      </form>
    </div>
  );
};

```
