---
id: 687b3c7a3af0df59b363712e
title: Step 19
challengeType: 20
dashedName: step-19
---

# --description--

When you find a shorter path to a node, you also need to update the actual path taken to reach it.

Inside the same conditional block, update the `paths` list at the neighbor's index to reflect the new, shorter path.

You should assign `paths[node_no]` to be the current path to the `current` node, with the `node_no` (the neighbor) added at the end.

# --hints--

You should update `paths[node_no]` to be the current path plus the neighbor node.

```js
({
    test: () => {
      assert(
        runPython(
          `_Node(_code).find_function("shortest_path").find_for_loops()[0].find_bodies()[0].find_for_loops()[1].find_bodies()[0].find_ifs()[0].find_bodies()[0].find_ifs()[0].find_bodies()[0].has_stmt("paths[node_no] = paths[current] + [node_no]")`
        )
      );
    }
});
```

# --seed--

## --seed-contents--

```py
INF = float('inf')
adj_matrix = [
    [0, 5, 3, INF, 11, INF],
    [5, 0, 1, INF, INF, 2],
    [3, 1, 0, 1, 5, INF],
    [INF, INF, 1, 0, 9, 3],
    [11, INF, 5, 9, 0, INF],
    [INF, 2, INF, 3, INF, 0],
]

def shortest_path(matrix, start_node, target_node=None):
    n = len(matrix)
    distances = [INF] * n
    distances[start_node] = 0
    paths = [[node_no] for node_no in range(n)]
    visited = [False] * n

    for _ in range(n):
        min_distance = INF
        current = -1
        for node_no in range(n):
            if not visited[node_no] and distances[node_no] < min_distance:
                min_distance = distances[node_no]
                current = node_no

        if current == -1:
            break
        visited[current] = True

--fcc-editable-region--
        for node_no in range(n):
            distance = matrix[current][node_no]
            if distance != INF and not visited[node_no]:
                new_distance = distances[current] + distance
                if new_distance < distances[node_no]:
                    distances[node_no] = new_distance

--fcc-editable-region--
```
