---
id: 671fae2d8e402a405a930e44
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

Add an event listener for the `click` event to `scaryStoryBtn` and pass it the `displayStory` function. Then, click your button and see the output in the console.

# --hints--

You should add an event listener for the `click` event to `scaryStoryBtn` passing it the `displayStory` function.

```js
const logArr = [];
const temp = console.log;
console.log = function(...args) {
    for (const arg of args) {
        logArr.push(arg);
    }
};

scaryStoryBtn.click();

console.log = temp;

assert.strictEqual(logArr[0], "You clicked the button");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Storytelling App</title>
    <link rel="stylesheet" href="./styles.css" />
</head>

<body>

<h1>Want to hear a short story?</h1>
    <main class="story-container">
        <div class="btn-container">
            <button class="btn" id="scary-btn">Scary Story</button>
            <button class="btn" id="funny-btn">Funny Story</button>
            <button class="btn" id="adventure-btn">Adventure Story</button>
        </div>
        <p id="result"></p>
    </main>
    <script src="./script.js"></script>
</body>
</html>
```

```js
const storyContainer = document.querySelector(".story-container");

const scaryStoryBtn = document.getElementById("scary-btn");
const funnyStoryBtn = document.getElementById("funny-btn");
const adventureStoryBtn = document.getElementById("adventure-btn");

const resultParagraph = document.getElementById("result");

const storyObj = {
  scary: {
    story: `In the dark woods, a group of friends stumbled upon an old, abandoned cabin. They enter the cabin and awaken something malevolent that had been dormant for centuries.`,
    borderColor: "#ee4b2b",
  },
  funny: {
    story: `During a camping trip, Mark decided to show off his culinary skills by cooking dinner over an open fire. However, his attempt caused him to burn the dinner as well as his eyebrows off.`,
    borderColor: "#f1be32",
  },
  adventure: {
    story: `Lost in the heart of the Amazon rain forest, Sarah and Jake stumbled upon an ancient temple. They braved deadly traps and encountered strange wildlife, all while deciphering cryptic clues left behind by a mysterious civilization.`,
    borderColor: "#acd157"
  },
};


--fcc-editable-region--
function displayStory() {
    console.log("You clicked the button");
}

--fcc-editable-region--
```

```css
*,
*::before,
*::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

:root {
    --dark-grey: #1b1b32;
    --black: #000;
    --white: #fff;
    --golden-yellow: #fecc4c;
    --yellow: #ffcc4c;
    --gold: #feac32;
    --orange: #ffac33;
    --dark-orange: #f89808;
}

body {
    background-color: var(--dark-grey);
    color: var(--white);
}

h1,
#result {
    text-align: center;
}

h1 {
    margin: 10px 0 15px;
}

.story-container {
    margin: auto;
    padding: 10px;
    width: 80%;
    border-style: double;
    border-width: 14px;
    border-color: var(--white);
}

.btn-container {
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
}

@media (min-width: 760px) {
    .btn-container {
        flex-direction: row;
    }
}

#result {
    margin-top: 15px;
    font-size: 1.2rem;
    line-height: 30px;
}

.btn {
    cursor: pointer;
    width: 200px;
    margin: 10px 0 10px 0.5rem;
    color: var(--black);
    background-color: var(--gold);
    background-image: linear-gradient(var(--golden-yellow), var(--orange));
    border-color: var(--gold);
    border-width: 3px;
}

.btn:hover {
    background-image: linear-gradient(var(--yellow), var(--dark-orange));
}
```
