---
id: 671fafbae959c048d82bac8d
title: Step 16
challengeType: 0
dashedName: step-16
---

# --description--

Modify the `scaryStoryBtn` event listener to call the `displayStory` function with the argument `"scary"`. Also, add a `click` event listener to the `funnyStoryBtn`, and `adventureStoryBtn` buttons that call the `displayStory` function with the arguments `"funny"` and `"adventure"` respectively.

With this, you have successfully completed the workshop.

# --hints--

When you click the `scaryStoryBtn`, the `#result` paragraph should display the scary story `"In the dark woods, a group of friends stumbled upon an old, abandoned cabin. They enter the cabin and awaken something malevolent that had been dormant for centuries."` with a border color of `#ee4b2b`.

```js
scaryStoryBtn.click();

function rgbToHex(rgb) {
  const rgbValues = rgb.match(/\d+/g);
  return (
    "#" +
    rgbValues
      ?.map((num) => parseInt(num).toString(16).padStart(2, "0"))
      .join("")
  );
}

const rgbColor = storyContainer.style.borderColor;
const hexColor = rgbToHex(rgbColor);

const expectedStory = "In the dark woods, a group of friends stumbled upon an old, abandoned cabin. They enter the cabin and awaken something malevolent that had been dormant for centuries.";
assert.equal(hexColor.toLowerCase(), "#ee4b2b");
assert.equal(result.textContent.replace(/\s+/g, ' '), expectedStory);
```

When you click the `funnyStoryBtn`, the `#result` paragraph should display the funny story with a border color of `#f1be32`.

```js
funnyStoryBtn.click();

function rgbToHex(rgb) {
  const rgbValues = rgb.match(/\d+/g);
  return (
    "#" +
    rgbValues
      ?.map((num) => parseInt(num).toString(16).padStart(2, "0"))
      .join("")
  );
}

const rgbColor = storyContainer.style.borderColor;
const hexColor = rgbToHex(rgbColor);

const expectedFunnyStory = "During a camping trip, Mark decided to show off his culinary skills by cooking dinner over an open fire. However, his attempt caused him to burn the dinner as well as his eyebrows off.";
assert.equal(hexColor.toLowerCase(), "#f1be32");
assert.equal(result.textContent.replace(/\s+/g, ' '), expectedFunnyStory);
```

When you click the `adventureStoryBtn`, the `#result` paragraph should display the adventure story with a border color of `#acd157`.

```js
adventureStoryBtn.click();

function rgbToHex(rgb) {
  const rgbValues = rgb.match(/\d+/g);
  return (
    "#" +
    rgbValues
      ?.map((num) => parseInt(num).toString(16).padStart(2, "0"))
      .join("")
  );
}

const rgbColor = storyContainer.style.borderColor;
const hexColor = rgbToHex(rgbColor);

const expectedAdventureStory = "Lost in the heart of the Amazon rain forest, Sarah and Jake stumbled upon an ancient temple. They braved deadly traps and encountered strange wildlife, all while deciphering cryptic clues left behind by a mysterious civilization.";
assert.equal(hexColor.toLowerCase(), "#acd157");
assert.equal(result.textContent.replace(/\s+/g, ' '), expectedAdventureStory);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Storytelling App</title>
    <link rel="stylesheet" href="./styles.css" />
</head>

<body>

    <h1>Want to hear a short story?</h1>

    <main class="story-container">
        <div class="btn-container">
            <button class="btn" id="scary-btn">Scary Story</button>
            <button class="btn" id="funny-btn">Funny Story</button>
            <button class="btn" id="adventure-btn">Adventure Story</button>
        </div>
        <p id="result"></p>
    </main>
    <script src="./script.js"></script>

</body>

</html>
```

```js
const storyContainer = document.querySelector(".story-container");

const scaryStoryBtn = document.getElementById("scary-btn");
const funnyStoryBtn = document.getElementById("funny-btn");
const adventureStoryBtn = document.getElementById("adventure-btn");

const resultParagraph = document.getElementById("result");

const storyObj = {
  scary: {
    story: `In the dark woods, a group of friends stumbled upon an old, abandoned cabin. They enter the cabin and awaken something malevolent that had been dormant for centuries.`,
    borderColor: "#ee4b2b",
},
  funny: {
    story: `During a camping trip, Mark decided to show off his culinary skills by cooking dinner over an open fire. However, his attempt caused him to burn the dinner as well as his eyebrows off.`,
    borderColor: "#f1be32",
  },
  adventure: {
    story: `Lost in the heart of the Amazon rain forest, Sarah and Jake stumbled upon an ancient temple. They braved deadly traps and encountered strange wildlife, all while deciphering cryptic clues left behind by a mysterious civilization.`,
    borderColor: "#acd157"
  },
};

function displayStory(genre) {
  if (storyObj.hasOwnProperty(genre)) {
    resultParagraph.textContent = storyObj[genre].story;
    storyContainer.style.borderColor = storyObj[genre].borderColor;
  }
}

--fcc-editable-region--
scaryStoryBtn.addEventListener("click", displayStory);

--fcc-editable-region--

```

```css
*,
*::before,
*::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

:root {
    --dark-grey: #1b1b32;
    --black: #000;
    --white: #fff;
    --golden-yellow: #fecc4c;
    --yellow: #ffcc4c;
    --gold: #feac32;
    --orange: #ffac33;
    --dark-orange: #f89808;
}

body {
    background-color: var(--dark-grey);
    color: var(--white);
}

h1,
#result {
    text-align: center;
}

h1 {
    margin: 10px 0 15px;
}

.story-container {
    margin: auto;
    padding: 10px;
    width: 80%;
    border-style: double;
    border-width: 14px;
    border-color: var(--white);
}

.btn-container {
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
}

@media (min-width: 760px) {
    .btn-container {
        flex-direction: row;
    }
}

#result {
    margin-top: 15px;
    font-size: 1.2rem;
    line-height: 30px;
}

.btn {
    cursor: pointer;
    width: 200px;
    margin: 10px 0 10px 0.5rem;
    color: var(--black);
    background-color: var(--gold);
    background-image: linear-gradient(var(--golden-yellow), var(--orange));
    border-color: var(--gold);
    border-width: 3px;
}

.btn:hover {
    background-image: linear-gradient(var(--yellow), var(--dark-orange));
}
```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Storytelling App</title>
    <link rel="stylesheet" href="./styles.css" />
</head>

<body>
    <h1>Want to hear a short story?</h1>
    <main class="story-container">
        <div class="btn-container">
            <button class="btn" id="scary-btn">Scary Story</button>
            <button class="btn" id="funny-btn">Funny Story</button>
            <button class="btn" id="adventure-btn">Adventure Story</button>
        </div>
        <p id="result"></p>
    </main>
    <script src="./script.js"></script>
</body>
</html>
```

```css
*,
*::before,
*::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

:root {
    --dark-grey: #1b1b32;
    --black: #000;
    --white: #fff;
    --golden-yellow: #fecc4c;
    --yellow: #ffcc4c;
    --gold: #feac32;
    --orange: #ffac33;
    --dark-orange: #f89808;
}

body {
    background-color: var(--dark-grey);
    color: var(--white);
}

h1,
#result {
    text-align: center;
}

h1 {
    margin: 10px 0 15px;
}

.story-container {
    margin: auto;
    padding: 10px;
    width: 80%;
    border-style: double;
    border-width: 14px;
    border-color: var(--white);
}

.btn-container {
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
}

@media (min-width: 760px) {
    .btn-container {
        flex-direction: row;
    }
}

#result {
    margin-top: 15px;
    font-size: 1.2rem;
    line-height: 30px;
}

.btn {
    cursor: pointer;
    width: 200px;
    margin: 10px 0 10px 0.5rem;
    color: var(--black);
    background-color: var(--gold);
    background-image: linear-gradient(var(--golden-yellow), var(--orange));
    border-color: var(--gold);
    border-width: 3px;
}

.btn:hover {
    background-image: linear-gradient(var(--yellow), var(--dark-orange));
}
```

```js
const storyContainer = document.querySelector(".story-container");

const scaryStoryBtn = document.getElementById("scary-btn");
const funnyStoryBtn = document.getElementById("funny-btn");
const adventureStoryBtn = document.getElementById("adventure-btn");
const resultParagraph = document.getElementById("result");

const storyObj = {
  scary: {
    story: `In the dark woods, a group of friends stumbled upon an old, abandoned cabin. They enter the cabin and awaken something malevolent that had been dormant for centuries.`,
    borderColor: "#ee4b2b",
  },
  funny: {
    story: `During a camping trip, Mark decided to show off his culinary skills by cooking dinner over an open fire.
        However, his attempt caused him to burn the dinner as well as his eyebrows off.`,
    borderColor: "#f1be32",
  },
  adventure: {
    story: `Lost in the heart of the Amazon rain forest, Sarah and Jake stumbled upon an ancient temple.
        They braved deadly traps and encountered strange wildlife,
        all while deciphering cryptic clues left behind by a mysterious civilization.`,
    borderColor: "#acd157",
  },
};

function displayStory(genre) {
  if (storyObj.hasOwnProperty(genre)) {
    resultParagraph.textContent = storyObj[genre].story;
    storyContainer.style.borderColor = storyObj[genre].borderColor;
  }
}

scaryStoryBtn.addEventListener("click", () => displayStory("scary"));
funnyStoryBtn.addEventListener("click", () => displayStory("funny"));
adventureStoryBtn.addEventListener("click", () => displayStory("adventure"));
```
