---
id: 680900675ae3d54ee19590ca
title: Step 10
challengeType: 0
dashedName: step-10
---

# --description--

To account for the setter function, you will have to attach a `value` attribute and an `onChange` event to the `select` and a `value` attribute to each of the `option` elements.

That's a long process, right? So the best way to handle this is to have an array of the option values and map over it to create the `option` elements.

A `powerSourceOptions` array has been added at the top of your component. Give it a look.

For now, remove all the options inside the `select` element except for the first one. In the next step you will map over the array.

# --hints--

You should have the first option element in your code.

```js
const optionEl = document?.querySelectorAll("select > option");
assert.equal(optionEl[0]?.textContent, "Select one");
```

You should remove all the option elements apart from the first one.

```js
const optionEls = document?.querySelectorAll("select > option");
assert.lengthOf(optionEls, 1)
```

# --seed--

## --seed-contents--

```html
<!doctype html>
<html>
  <head>
    <meta charset="UTF-8" />
    <title>Superhero Application Form</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.3/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      src="index.jsx"
    ></script>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <div id="root"></div>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { SuperheroForm } from './index.jsx';
      ReactDOM.createRoot(document.getElementById('root')).render(<SuperheroForm />);
    </script>
  </body>
</html>
```

```css
body {
  margin: 0;
  padding: 0;
  min-height: 100vh;
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  background: linear-gradient(30deg, #ff9999 50%, #6699ff 50%)
}

.form-wrap {
  background-color: white;
  width: 400px;
  padding: 20px;
  border: 1px solid black;
  box-shadow: 5px 5px 10px black;
}

.form-wrap h2,
.form-wrap p {
  text-align: center;
}

.form-wrap p {
  position: relative;
  top: -18px;
}

.section {
  display: flex;
  margin-bottom: 30px;
}

.column {
  flex-direction: column;
}

.submit-wrap {
  text-align: center;
}

.submit-btn {
  display: block;
  margin: 0 auto;
  padding: 0.4rem 0.5rem;
  border: 1px solid black
}

.submit-btn:hover {
  cursor: pointer;
  background-color: #f3f3f3;
}

.submit-btn:disabled {
  cursor: not-allowed;
}
```

```jsx
const { useState } = React;

export const SuperheroForm = () => {

  const powerSourceOptions = [
    'Bitten by a strange creature',
    'Radioactive exposure',
    'Science experiment',
    'Alien heritage',
    'Ancient artifact discovery',
    'Other'
  ];

  const [heroName, setHeroName] = useState('');
  const [realName, setRealName] = useState('');
  const [powerSource, setPowerSource] = useState('');
  const [powers, setPowers] = useState([]);

  return (
    <div className='form-wrap'>
      <h2>Superhero Application Form</h2>
      <p>Please complete all fields</p>
      <form>
        <div className='section'>
          <label>
            Hero Name
            <input
              type='text'
              value={heroName}
              onChange={e => setHeroName(e.target.value)}
            />
          </label>
          <label>
            Real Name
            <input
              type='password'
              value={realName}
              onChange={e => setRealName(e.target.value)}
            />
          </label>
        </div>
        <label className='section column'>
          How did you get your powers?
          <select>
          --fcc-editable-region--
            <option value=''>
              Select one
            </option>
            <option>
              Bitten by a strange creature
            </option>
            <option>
              Radioactive exposure
            </option>
            <option>
              Science experiment
            </option>
            <option>
              Alien heritage
            </option>
            <option>
              Ancient artifact discovery
            </option>
            <option>
              Other
            </option>
            --fcc-editable-region--
          </select>
        </label>
      </form>
    </div>
  )
};
```
