---
id: 68148d280ee30e5a567a0e2d
title: Step 15
challengeType: 0
dashedName: step-15
---

# --description--

Remove the `Hello` text inside the `label`, then create an `input` of type `checkbox` and a `value` of `power`.

Finally, display the values from the array next to each checkbox by creating a `span` element just before the closing `label` with a text content of `{power}`.

# --hints--

You should remove the `Hello` text from the `label` element.

```js
assert.notMatch(code, /hello/i)
```

You should create an `input` with its `type` set to `checkbox` and a `value` set to `power` as the first child of the label.

```js
assert.match(code, /<\s*label\s+key\s*=\s*{\s*power\s*}\s*>\s*<\s*input\s+type\s*=\s*("|')checkbox\1\s*value\s*=\s*\{\s*power\s*\}\s*\/>[\s\S]*<\/\s*label\s*>/)
```

You should create a `span` element with `{power}` for its text content as the last child of the label.

```js
assert.match(code, /<\s*label\s+key\s*=\s*{\s*power\s*}\s*>[\s\S]*<\s*span\s*>\s*{\s*power\s*}\s*<\/\s*span\s*>\s*<\/\s*label\s*>/)
```

# --seed--

## --seed-contents--

```html
<!doctype html>
<html>
  <head>
    <meta charset="UTF-8" />
    <title>Superhero Application Form</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.3/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      src="index.jsx"
    ></script>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <div id="root"></div>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { SuperheroForm } from './index.jsx';
      ReactDOM.createRoot(document.getElementById('root')).render(<SuperheroForm />);
    </script>
  </body>
</html>
```

```css
body {
  margin: 0;
  padding: 0;
  min-height: 100vh;
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  background: linear-gradient(30deg, #ff9999 50%, #6699ff 50%)
}

.form-wrap {
  background-color: white;
  width: 400px;
  padding: 20px;
  border: 1px solid black;
  box-shadow: 5px 5px 10px black;
}

.form-wrap h2,
.form-wrap p {
  text-align: center;
}

.form-wrap p {
  position: relative;
  top: -18px;
}

.section {
  display: flex;
  margin-bottom: 30px;
}

.column {
  flex-direction: column;
}

.submit-wrap {
  text-align: center;
}

.submit-btn {
  display: block;
  margin: 0 auto;
  padding: 0.4rem 0.5rem;
  border: 1px solid black
}

.submit-btn:hover {
  cursor: pointer;
  background-color: #f3f3f3;
}

.submit-btn:disabled {
  cursor: not-allowed;
}
```

```jsx
const { useState } = React;

export const SuperheroForm = () => {

  const powerSourceOptions = [
    'Bitten by a strange creature',
    'Radioactive exposure',
    'Science experiment',
    'Alien heritage',
    'Ancient artifact discovery',
    'Other'
  ];

  const powersOptions = [
    'Super Strength',
    'Super Speed',
    'Flight',
    'Invisibility',
    'Telekinesis',
    'Other'
  ];

  const [heroName, setHeroName] = useState('');
  const [realName, setRealName] = useState('');
  const [powerSource, setPowerSource] = useState('');
  const [powers, setPowers] = useState([]);

  return (
    <div className='form-wrap'>
      <h2>Superhero Application Form</h2>
      <p>Please complete all fields</p>
      <form>
        <div className='section'>
          <label>
            Hero Name
            <input
              type='text'
              value={heroName}
              onChange={e => setHeroName(e.target.value)}
            />
          </label>
          <label>
            Real Name
            <input
              type='password'
              value={realName}
              onChange={e => setRealName(e.target.value)}
            />
          </label>
        </div>
        <label className='section column'>
          How did you get your powers?
          <select value={powerSource} onChange={e => setPowerSource(e.target.value)}>
            <option value=''>
              Select one
            </option>
           {powerSourceOptions.map(source => (
             <option key={source} value={source}>
                {source}
              </option>
            ))}
          </select>
        </label>
        <label className='section column'>
          List your powers (select all that apply):
        --fcc-editable-region--
          {powersOptions.map(power => (
            <label key={power}>
              Hello
            </label>
          ))}
        --fcc-editable-region--
        </label>
      </form>
    </div>
  )
};
```
