---
id: 6864df7ec0fc508ac3828ab5
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

From regular CSS, you learned that assigning a display of `grid` to an element does not do anything until you specify the grid rows and columns. That's how it works in Tailwind, too.

In Tailwind, to assign a grid row and grid column, you'd use their respective utility classes like this:

```html
<div class="grid grid-cols-[num] grid-rows-[num]">
  <div>Grid Item</div>
  <div>Grid Item</div>
  <div>Grid Item</div>
</div>
```

Assign the wrapper `div` the utility classes `grid-cols-1` and `md:grid-cols-3`.

The `grid-cols-1` class arranges the three items in a single column, stacking them vertically. On medium and larger screens, `md:grid-cols-3` switches the layout to three columns, displaying the items side by side.

# --hints--

Your `div` element should have the class `grid-cols-1`.

```js
const firstDiv = document.querySelector("div")

assert.isTrue(firstDiv.classList.contains("grid-cols-1"))
```

Your `div` element should have the class `md:grid-cols-3`.

```js
const firstDiv = document.querySelector("div")

assert.isTrue(firstDiv.classList.contains("md:grid-cols-3"))
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Music App Pricing</title>
    <script src="https://cdn.tailwindcss.com"></script>
  </head>
  <body class="bg-gray-100">
    <main>
      <h1 class="mt-8 mb-12 text-center text-3xl md:text-5xl font-semibold text-gray-900">Choose your listening plan</h1>
--fcc-editable-region--
      <div class="grid ">
--fcc-editable-region--
        <div>
          <div>
            <h2>Listener</h2>
            <p>$0<span>/month</span></p>
            <p>
              Start exploring millions of songs with basic features and ads.
            </p>
            <ul>
              <li><span>&#10003;</span>Ad-supported streaming</li>
              <li><span>&#10003;</span>Curated playlists</li>
            </ul>
          </div>
          <a href="#">Start listening</a>
        </div>
        <div>
          <div>Most Popular</div>
          <div>
            <h2>Premium</h2>
            <p>$9.99<span>/month</span></p>
            <p>
              Enjoy the full music experience with unlimited access and
              downloads.
            </p>
            <ul>
              <li><span>&#10003;</span>Ad-free listening</li>
              <li><span>&#10003;</span>Offline playback</li>
              <li><span>&#10003;</span>Unlimited skips</li>
            </ul>
          </div>
          <a href="#">Go Premium</a>
        </div>
        <div>
          <div>
            <h2>Family</h2>
            <p>$14.99<span>/month</span></p>
            <p>
              Enjoy all of the features with a plan for up to 6 family members.
            </p>
            <ul>
              <li>
                <span>&#10003;</span>All Premium features
              </li>
              <li>
                <span>&#10003;</span>Up to 6 accounts
              </li>
              <li>
                <span>&#10003;</span>Individual playlists &
                libraries
              </li>
              <li>
                <span>&#10003;</span>Family Mix playlists
              </li>
            </ul>
          </div>
          <a href="#">Start Family Plan</a>
        </div>
      </div>
    </main>
  </body>
</html>
```
