---
id: 6867cbfbbb4a9f4bc73b01e6
title: Step 49
challengeType: 0
dashedName: step-49
---

# --description--

The markers of the list items need to be spaced out a bit. So, give each `span` in the list items the classes `text-green-700` and `mr-2`.

Also, add the `aria-hidden` attribute to each of the `span` elements.

# --hints--

Your `span` elements should have the class `text-green-700`.

```js
const spanEls = document.querySelectorAll("ul li span")
const familyPlanSpans = [spanEls[5], spanEls[6], spanEls[7], spanEls[8]]

familyPlanSpans.forEach(span => {
  assert.isTrue(span.classList.contains("text-green-700"))
})
```

Your `span` elements should have the class `mr-2`.

```js
const spanEls = document.querySelectorAll("ul li span")
const familyPlanSpans = [spanEls[5], spanEls[6], spanEls[7], spanEls[8]]

familyPlanSpans.forEach(span => {
  assert.isTrue(span.classList.contains("mr-2"))
})
```

Your `span` elements should have the `aria-hidden` attribute.

```js
const spanEls = document.querySelectorAll("ul li span")
const familyPlanSpans = [spanEls[5], spanEls[6], spanEls[7], spanEls[8]]

familyPlanSpans.forEach(span => {
  assert.isTrue(span.hasAttribute("aria-hidden"))
})
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Music App Pricing</title>
    <script src="https://cdn.tailwindcss.com"></script>
  </head>
  <body class="bg-gray-100">
    <main>
      <h1 class="mt-8 mb-12 text-center text-3xl md:text-5xl font-semibold text-gray-900">Choose your listening plan</h1>
      <div class="grid grid-cols-1 md:grid-cols-3 max-w-6xl mx-auto gap-8 mt-16">
        <div class="bg-gray-100 ring-1 ring-gray-300 grid grid-rows-[1fr_auto] rounded-xl p-8 gap-6">
          <div class="grid grid-rows-[auto_auto_auto_1fr] gap-y-2">
            <h2 class="text-lg font-semibold text-indigo-600">Listener</h2>
            <p class="text-4xl font-bold text-gray-900">$0<span class="text-base font-medium text-gray-500">/month</span></p>
            <p>
              Start exploring millions of songs with basic features and ads.
            </p>
            <ul class="mt-6 space-y-2 text-sm text-gray-700">
              <li>
                <span aria-hidden class="text-green-700 mr-2">&#10003;</span>Ad-supported streaming
              </li>
              <li>
                <span aria-hidden class="text-green-700 mr-2">&#10003;</span>Curated playlists
              </li>
            </ul>
          </div>
          <a
            href="#"
            class="block rounded-md bg-indigo-100 px-4 py-2 text-center font-semibold text-indigo-700 hover:bg-indigo-200"
          >
            Start listening
          </a>
        </div>
        <div class="relative bg-gray-950 text-white ring-2 ring-fuchsia-500 p-8 grid grid-rows-[1fr_auto] gap-6 rounded-xl scale-105">
          <div class="absolute -top-3 right-3 bg-gradient-to-r from-fuchsia-500 to-indigo-500 rounded-full px-3 py-1 text-xs font-bold text-white">Most Popular</div>
          <div class="grid grid-rows-[auto_auto_auto_1fr] gap-y-2">
            <h2 class="text-lg font-semibold text-fuchsia-200">Premium</h2>
            <p class="text-4xl font-bold text-white">
              $9.99<span class="text-base font-medium text-fuchsia-300">/month</span>
            </p>
            <p class="text-gray-300">
              Enjoy the full music experience with unlimited access and
              downloads.
            </p>
            <ul class="mt-6 space-y-2 text-sm text-fuchsia-100">
              <li>
                <span aria-hidden class="text-green-500 mr-2">&#10003;</span>Ad-free listening
              </li>
              <li>
                <span aria-hidden class="text-green-500 mr-2">&#10003;</span>Offline playback
              </li>
              <li>
                <span aria-hidden class="text-green-500 mr-2">&#10003;</span>Unlimited skips
              </li>
            </ul>
          </div>
          <a
            href="#"
            class="block rounded-md bg-gradient-to-r from-fuchsia-500 to-indigo-600 text-white hover:from-fuchsia-600 hover:to-indigo-700 px-4 py-2 text-center font-semibold"
          >
            Go Premium
          </a>
        </div>
        <div class="bg-gray-100 ring-1 ring-gray-300 p-8 rounded-xl grid grid-rows-[1fr_auto] gap-6">
          <div class="grid grid-rows-[auto_auto_auto_1fr] gap-y-2">
            <h2 class="text-lg font-semibold text-indigo-600">Family</h2>
            <p class="text-4xl font-bold text-gray-900">
              $14.99<span class="text-base font-medium text-gray-500">/month</span>
            </p>
            <p class="text-gray-600">
              Enjoy all of the features with a plan for up to 6 family members.
            </p>
--fcc-editable-region--
            <ul class="mt-6 space-y-2 text-sm text-gray-700">
              <li>
                <span>&#10003;</span>All Premium features
              </li>
              <li>
                <span>&#10003;</span>Up to 6 accounts
              </li>
              <li>
                <span>&#10003;</span>Individual playlists &
                libraries
              </li>
              <li>
                <span>&#10003;</span>Family Mix playlists
              </li>
            </ul>
--fcc-editable-region--
          </div>
          <a href="#">Start Family Plan</a>
        </div>
      </div>
    </main>
  </body>
</html>
```
