---
id: 67cd5bace629fa219a70aa6d
title: Step 12
challengeType: 0
dashedName: step-12
---

# --description--

Now it is time to use your `handleToggleVisibility` function. 

In prior lessons, you learned about React's Synthetic Event System and how to work with attributes like `onClick` and `onSubmit`.

Remember that you can pass a function reference to an `onClick` attribute like this:

```jsx
function handleClick() {
  console.log("Button clicked!");
}

<button onClick={handleClick}>Click Me</button>;
```

Update your existing `button` element to add an `onClick` attribute and pass in a `handleToggleVisibility` function reference. 

Now, when you click on the button, you will see the visibility of the paragraph text toggle between hidden and shown on the page. 

# --hints--

When the `toggle-button` is clicked, the message `"I love freeCodeCamp!"` should appear on the screen.

```js
  const abuseState = __helpers.spyOn(React, "useState");
  const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src ===  "index.jsx").innerText.replace("_React.useState", "abuseState");

  const exports = {};
  const a = eval(script);

  const s = await __helpers.prepTestComponent(exports.ToggleApp);

  const btn = s.querySelector('#toggle-button');
  assert.exists(btn);
  
  await React.act(async () => {
    const ev = new MouseEvent("click", { bubbles: true, cancelable: true });
    btn.dispatchEvent(ev);
  });

  const alteredStates = abuseState.returns;
  const initialStates = alteredStates.splice(0, abuseState.returns.length / 2);

  const stateChanged = initialStates.some((s, i) => {
    try {
      assert.deepEqual(s[0], alteredStates[i][0]);
      return false; 
    } catch (e) {
      return true; 
    }
  });
 
  const msg = s.querySelector("#message");

  assert.exists(msg)
  assert.equal(msg.textContent, "I love freeCodeCamp!");

  abuseState.restore();
  assert.isTrue(stateChanged);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Toggle Visibility</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { ToggleApp } from "./index.jsx";
    ReactDOM.createRoot(document.getElementById("root")).render(<ToggleApp />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#toggle-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#toggle-button {
  padding: 10px 20px;
  border: none;
  background: #007BFF;
  color: white;
  border-radius: 5px;
  cursor: pointer;
  transition: background 0.3s ease;
}

#toggle-button:hover {
  background: #0056b3;
}

#message {
  margin-top: 20px;
  font-size: 1.125rem;
  color: #333;
}
```

```jsx
const { useState } = React;

export const ToggleApp = () => {
  const [isVisible, setIsVisible] = useState(false);

  const handleToggleVisibility = () => {
    setIsVisible(!isVisible);
  }

  return (
    <div id="toggle-container">
      --fcc-editable-region--
      <button id="toggle-button">Message</button>
      --fcc-editable-region--
      {isVisible && <p id="message">I love freeCodeCamp!</p>}
    </div>
  );
};
```
