const find = require('unist-util-find');
const findAfter = require('unist-util-find-after');
const findAllAfter = require('unist-util-find-all-after');
const between = require('unist-util-find-all-between');
const { findAll } = require('./find-all');

const isMarker = node => {
  if (node.children && node.children[0]) {
    const child = node.children[0];
    return (
      child.type === 'text' &&
      child.value.startsWith('--') &&
      child.value.endsWith('--') &&
      node.type === 'heading'
    );
  }
  return false;
};

function _getSection(tree) {
  return start => {
    if (!start) return [];

    const isEnd = node => {
      return node.depth <= start.depth && isMarker(node);
    };

    const end = findAfter(tree, start, isEnd);

    const targetNodes = end
      ? between(tree, start, end)
      : findAllAfter(tree, start);
    return targetNodes;
  };
}

const startNode = (marker, depth) => ({
  type: 'heading',
  children: [
    {
      type: 'text',
      value: marker
    }
  ],
  ...((typeof depth === 'number' && { depth }) || {})
});

function getSection(tree, marker, depth) {
  const start = find(tree, startNode(marker, depth));
  return _getSection(tree)(start);
}

function getAllSections(tree, marker) {
  const starts = findAll(tree, startNode(marker));
  return starts.map(_getSection(tree));
}

module.exports = { getSection, getAllSections, isMarker };
