# Copyright (c) 2024-2025 MAA_Punish
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
MAA_Punish
MAA_Punish 识别宿舍角色数量
作者:overflow65537
"""

from maa.custom_recognition import CustomRecognition
from typing import Union, Optional
from maa.define import RectType,OCRResult


class IDFMembers(CustomRecognition):

    def analyze(
        self,
        context,
        argv: CustomRecognition.AnalyzeArg,
    ) -> Union[CustomRecognition.AnalyzeResult, Optional[RectType]]:
        image = context.tasker.controller.post_screencap().wait().get()
        # 检查目标数量
        target_score = context.run_recognition("检查目标数量", image)
        # 检查当前数量
        current_score = context.run_recognition("检查当前数量", image)
        if current_score and current_score.hit and target_score and target_score.hit:
            if isinstance(current_score.best_result, OCRResult) and isinstance(target_score.best_result, OCRResult):
                if (
                    current_score.best_result.text.isdigit()
                    and target_score.best_result.text.isdigit()
                ):

                    if int(current_score.best_result.text) == int(
                        target_score.best_result.text
                    ):
                        return CustomRecognition.AnalyzeResult(
                            box=(0, 0, 100, 100), detail={"status":"success"}
                        )
                else:
                    return
        return
