/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.launcher.cli.converter.BuildLayoutConverter;
import org.gradle.launcher.cli.converter.InitialPropertiesConverter;
import org.gradle.launcher.cli.converter.StartParameterConverter;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.tooling.internal.protocol.InternalLaunchable;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

class ProviderStartParameterConverter {
    ProviderStartParameterConverter() {
    }

    private List<TaskExecutionRequest> unpack(List<InternalLaunchable> launchables) {
        ArrayList<TaskExecutionRequest> requests = new ArrayList<TaskExecutionRequest>(launchables.size());
        for (InternalLaunchable launchable : launchables) {
            if (launchable instanceof TaskExecutionRequest) {
                TaskExecutionRequest originalLaunchable = (TaskExecutionRequest)launchable;
                TaskExecutionRequest launchableImpl = DefaultTaskExecutionRequest.of((Iterable)originalLaunchable.getArgs(), (String)originalLaunchable.getProjectPath(), (File)originalLaunchable.getRootDir());
                System.out.println(Thread.currentThread() + " -> UNPACK LAUNCHABLE " + launchable + " TO " + launchableImpl);
                requests.add(launchableImpl);
                continue;
            }
            throw new InternalUnsupportedBuildArgumentException("Problem with provided launchable arguments: " + launchables + ". \nOnly objects from this provider can be built.");
        }
        return requests;
    }

    public StartParameterInternal toStartParameter(ProviderOperationParameters parameters, BuildLayoutResult buildLayout, AllProperties properties) {
        ParsedCommandLine parsedCommandLine;
        StartParameterInternal startParameter = new StartParameterInternal();
        List<InternalLaunchable> launchables = parameters.getLaunchables();
        if (launchables != null) {
            startParameter.setTaskRequests(this.unpack(launchables));
        } else if (parameters.getTasks() != null) {
            startParameter.setTaskNames(parameters.getTasks());
        }
        List<String> arguments = parameters.getArguments();
        StartParameterConverter converter = new StartParameterConverter();
        CommandLineParser parser = new CommandLineParser();
        new InitialPropertiesConverter().configure(parser);
        new BuildLayoutConverter().configure(parser);
        converter.configure(parser);
        try {
            parsedCommandLine = parser.parse(arguments != null ? arguments : Collections.emptyList());
        }
        catch (CommandLineArgumentException e) {
            throw new InternalUnsupportedBuildArgumentException("Problem with provided build arguments: " + arguments + ". \n" + e.getMessage() + "\nEither it is not a valid build option or it is not supported in the target Gradle version.\nNot all of the Gradle command line options are supported build arguments.\nExamples of supported build arguments: '--info', '-p'.\nExamples of unsupported build options: '--daemon', '-?', '-v'.\nPlease find more information in the javadoc for the BuildLauncher class.", (Throwable)e);
        }
        converter.convert(parsedCommandLine, buildLayout, properties, startParameter);
        if (parameters.getBuildLogLevel() != null) {
            startParameter.setLogLevel(parameters.getBuildLogLevel());
        }
        return startParameter;
    }
}

