/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.env;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandSupport;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptStoreSetup;
import io.xpipe.ext.proc.env.u;
import io.xpipe.ext.proc.m;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="shellEnvironment")
@JsonDeserialize(builder=b.class)
public final class s
implements ShellStore,
StatefulDataStore<u> {
    private final String commands;
    private final DataStoreEntryRef<ShellStore> host;
    private final ShellDialect shell;
    private final boolean elevated;
    private final String user;
    private final List<DataStoreEntryRef<ScriptStore>> scripts;
    private final Boolean defaultEnvironment;

    public final Class<u> getStateClass() {
        return u.class;
    }

    public final void checkComplete() {
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
        this.host.checkComplete();
    }

    public final List<DataStoreEntryRef<ScriptStore>> getEffectiveScripts() {
        if (this.scripts != null) {
            return this.scripts.stream().filter(dataStoreEntryRef -> dataStoreEntryRef != null).toList();
        }
        return List.of();
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(this){
            final /* synthetic */ s cl;
            {
                s s3 = s2;
                Objects.requireNonNull(s3);
                this.cl = s3;
            }

            public final ShellControl control(ShellControl shellControl) {
                Object object2;
                ShellControl shellControl2 = shellControl;
                if (this.cl.shell != null) {
                    this.cl.checkCompatibility(shellControl);
                    object2 = this.cl.shell.getDumbMode().getSwitchDialect();
                    shellControl2 = shellControl2.subShell();
                    shellControl2.setDumbOpen(new ShellOpenFunction(){
                        private /* synthetic */ ShellDialect cm;
                        private /* synthetic */ 1 cn;
                        {
                            this.cm = shellDialect;
                            1 v0 = var1_1;
                            Objects.requireNonNull(v0);
                            this.cn = v0;
                        }

                        public final CommandBuilder prepareWithoutInitCommand() {
                            1 v0 = this;
                            return CommandBuilder.of().addAll(shellControl -> {
                                this.cn.cl.checkCompatibility((ShellControl)shellControl);
                                if (v0.cm != null) {
                                    return v0.cm.getLaunchCommand().loginCommand(shellControl.getOsType());
                                }
                                return this.cn.cl.shell.getLaunchCommand().loginCommand(shellControl.getOsType());
                            });
                        }

                        public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                            if (string == null) {
                                throw new NullPointerException("command is marked non-null but is null");
                            }
                            return CommandBuilder.ofString((String)string);
                        }
                    });
                    shellControl2.setTerminalOpen(new ShellOpenFunction(this){
                        private /* synthetic */ 1 cn;
                        {
                            1 v0 = var1_1;
                            Objects.requireNonNull(v0);
                            this.cn = v0;
                        }

                        public final CommandBuilder prepareWithoutInitCommand() {
                            return CommandBuilder.of().addAll(shellControl -> {
                                this.cn.cl.checkCompatibility((ShellControl)shellControl);
                                return this.cn.cl.shell.getLaunchCommand().loginCommand(shellControl.getOsType());
                            });
                        }

                        public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                            if (string == null) {
                                throw new NullPointerException("command is marked non-null but is null");
                            }
                            return CommandBuilder.ofString((String)string);
                        }
                    });
                    shellControl2.setOriginalShellDialect(this.cl.shell);
                } else {
                    shellControl2 = shellControl2.identicalDialectSubShell();
                }
                shellControl2.setUser(this.cl.user);
                shellControl2.setParentSystemAccess(ParentSystemAccess.identity());
                if (this.cl.isElevated()) {
                    shellControl2.elevated(ElevationFunction.elevated(null));
                    if (shellControl instanceof m && (shellControl = (object2 = (m)shellControl).E()) != null) {
                        shellControl2.setOriginalShellDialect((ShellDialect)shellControl);
                    }
                }
                shellControl2.withSourceStore((DataStore)this.cl);
                shellControl2.withShellStateInit((StatefulDataStore)this.cl);
                shellControl2.withShellStateFail((StatefulDataStore)this.cl);
                shellControl2.onInit(object -> {
                    if ((object = object.getOriginalShellDialect().queryVersion(object)) != null) {
                        this.cl.setState((DataStoreState)((u.a)((Object)((Object)((u)this.cl.getState()).toBuilder().shellName((String)object)))).build());
                    }
                });
                ScriptStoreSetup.controlWithScripts((ShellControl)shellControl2, this.cl.getEffectiveScripts(), (boolean)true);
                if (this.cl.commands != null) {
                    shellControl2.withInitSnippet(new ShellTerminalInitCommand(this){
                        private /* synthetic */ 1 cn;
                        {
                            1 v0 = var1_1;
                            Objects.requireNonNull(v0);
                            this.cn = v0;
                        }

                        public final Optional<String> terminalContent(ShellControl shellControl) {
                            return Optional.of(this.cn.cl.commands);
                        }

                        public final boolean canPotentiallyRunInDialect(ShellDialect shellDialect) {
                            return true;
                        }
                    }, true);
                }
                return shellControl2;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)this.cl.host.getStore();
            }
        };
    }

    public final void validate() {
        block7: {
            block6: {
                block5: {
                    if (this.shell == null || this.shell.getDumbMode().supportsAnyPossibleInteraction()) break block6;
                    ShellControl shellControl = ((ShellStore)this.getHost().getStore()).tempControl().start();
                    try {
                        CommandSupport.isInPathOrThrow((ShellControl)shellControl, (String)this.shell.getExecutableName());
                        if (shellControl == null) break block5;
                    }
                    catch (Throwable throwable) {
                        if (shellControl != null) {
                            try {
                                shellControl.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    shellControl.close();
                    break block7;
                }
                return;
            }
            super.validate();
        }
    }

    private void checkCompatibility(ShellControl object) {
        OsType.Any any = object.getOsType();
        if (any != null) {
            this.throwIfUnsupported(any);
            return;
        }
        if ((object = object.getSourceStore()).isPresent() && (object = object.get()) instanceof StatefulDataStore) {
            object = (StatefulDataStore)object;
            if ((object = object.getState()) instanceof SystemState) {
                object = (SystemState)object;
                if ((object = object.getOsType()) != null) {
                    this.throwIfUnsupported((OsType.Any)object);
                }
            }
        }
    }

    private void throwIfUnsupported(OsType.Any any) {
        boolean bl = this.getAvailableDialects(any).contains(this.shell);
        if (!bl) {
            throw (UnsupportedOperationException)ErrorEventFactory.expected((Throwable)new UnsupportedOperationException("Shell type " + this.shell.getDisplayName() + " is not supported for " + any.getName() + " systems"));
        }
    }

    private List<ShellDialect> getAvailableDialects(OsType.Any any) {
        OsType.Any any2 = any;
        Objects.requireNonNull(any2);
        any = any2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Bsd.class, OsType.Linux.class, OsType.MacOs.class, OsType.Solaris.class, OsType.Windows.class}, (OsType.Any)any2, 0)) {
            case 0: {
                OsType.Bsd cfr_ignored_0 = (OsType.Bsd)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.NUSHELL);
            }
            case 1: {
                OsType.Linux cfr_ignored_1 = (OsType.Linux)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.POWERSHELL_CORE, ShellDialects.NUSHELL, ShellDialects.XONSH);
            }
            case 2: {
                OsType.MacOs cfr_ignored_2 = (OsType.MacOs)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.POWERSHELL_CORE, ShellDialects.NUSHELL);
            }
            case 3: {
                OsType.Solaris cfr_ignored_3 = (OsType.Solaris)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.NUSHELL);
            }
            case 4: {
                OsType.Windows cfr_ignored_4 = (OsType.Windows)any;
                return List.of(ShellDialects.CMD, ShellDialects.POWERSHELL, ShellDialects.POWERSHELL_CORE, ShellDialects.NUSHELL);
            }
        }
        return List.of(ShellDialects.SH, ShellDialects.BASH);
    }

    @Generated
    protected s(a<?, ?> a2) {
        this.commands = a2.commands;
        this.host = a2.host;
        this.shell = a2.shell;
        this.elevated = a2.elevated;
        this.user = a2.user;
        this.scripts = a2.scripts;
        this.defaultEnvironment = a2.defaultEnvironment;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final String getCommands() {
        return this.commands;
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public final ShellDialect getShell() {
        return this.shell;
    }

    @Generated
    public final boolean isElevated() {
        return this.elevated;
    }

    @Generated
    public final String getUser() {
        return this.user;
    }

    @Generated
    public final List<DataStoreEntryRef<ScriptStore>> getScripts() {
        return this.scripts;
    }

    @Generated
    public final Boolean getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    @Generated
    public final boolean equals(Object list) {
        if (list == this) {
            return true;
        }
        if (!(list instanceof s)) {
            return false;
        }
        list = (s)((Object)list);
        if (this.isElevated() != ((s)((Object)list)).isElevated()) {
            return false;
        }
        Object object = this.getDefaultEnvironment();
        Object object2 = ((s)((Object)list)).getDefaultEnvironment();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getCommands();
        object2 = ((s)((Object)list)).getCommands();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getHost();
        object2 = ((s)((Object)list)).getHost();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getShell();
        object2 = ((s)((Object)list)).getShell();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getUser();
        object2 = ((s)((Object)list)).getUser();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getScripts();
        list = ((s)((Object)list)).getScripts();
        return !(object == null ? list != null : !object.equals(list));
    }

    @Generated
    public final int hashCode() {
        int n2 = 59 + (this.isElevated() ? 79 : 97);
        Object object = this.getDefaultEnvironment();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getCommands();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHost();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getShell();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getUser();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getScripts();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "ShellEnvironmentStore(commands=" + this.getCommands() + ", host=" + String.valueOf(this.getHost()) + ", shell=" + String.valueOf(this.getShell()) + ", elevated=" + this.isElevated() + ", user=" + this.getUser() + ", scripts=" + String.valueOf(this.getScripts()) + ", defaultEnvironment=" + this.getDefaultEnvironment() + ")";
    }

    @Generated
    public s(String string, DataStoreEntryRef<ShellStore> dataStoreEntryRef, ShellDialect shellDialect, boolean bl, String string2, List<DataStoreEntryRef<ScriptStore>> list, Boolean bl2) {
        this.commands = string;
        this.host = dataStoreEntryRef;
        this.shell = shellDialect;
        this.elevated = bl;
        this.user = string2;
        this.scripts = list;
        this.defaultEnvironment = bl2;
    }

    @Generated
    public static abstract class a<C extends s, B extends a<C, B>> {
        @Generated
        private String commands;
        @Generated
        private DataStoreEntryRef<ShellStore> host;
        @Generated
        private ShellDialect shell;
        @Generated
        private boolean elevated;
        @Generated
        private String user;
        @Generated
        private List<DataStoreEntryRef<ScriptStore>> scripts;
        @Generated
        private Boolean defaultEnvironment;

        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(s s2, a<?, ?> a2) {
            a2.commands(s2.commands);
            a2.host(s2.host);
            a2.shell(s2.shell);
            a2.elevated(s2.elevated);
            a2.user(s2.user);
            a2.scripts(s2.scripts);
            a2.defaultEnvironment(s2.defaultEnvironment);
        }

        @Generated
        public B commands(String string) {
            this.commands = string;
            return this.self();
        }

        @Generated
        public B host(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B shell(ShellDialect shellDialect) {
            this.shell = shellDialect;
            return this.self();
        }

        @Generated
        public B elevated(boolean bl) {
            this.elevated = bl;
            return this.self();
        }

        @Generated
        public B user(String string) {
            this.user = string;
            return this.self();
        }

        @Generated
        public B scripts(List<DataStoreEntryRef<ScriptStore>> list) {
            this.scripts = list;
            return this.self();
        }

        @Generated
        public B defaultEnvironment(Boolean bl) {
            this.defaultEnvironment = bl;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ShellEnvironmentStore.ShellEnvironmentStoreBuilder(commands=" + this.commands + ", host=" + String.valueOf(this.host) + ", shell=" + String.valueOf(this.shell) + ", elevated=" + this.elevated + ", user=" + this.user + ", scripts=" + String.valueOf(this.scripts) + ", defaultEnvironment=" + this.defaultEnvironment + ")";
        }
    }

    @JsonTypeName(value="shellEnvironment")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<s, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final s build() {
            return new s(this);
        }
    }
}

