/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.k8s;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.FixedHierarchyStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.ContextualFileReference;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.proc.k8s.g;
import io.xpipe.ext.proc.k8s.i;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="k8sCluster")
@JsonDeserialize(builder=b.class)
public final class e
implements FixedChildStore,
FixedHierarchyStore,
SelfReferentialStore,
StatefulDataStore<c> {
    private final DataStoreEntryRef<g> cmd;
    private final String contextName;
    private final String namespaceName;
    private final ContextualFileReference configFile;

    public final void checkComplete() {
        Validators.nonNull(this.cmd);
        Validators.isType(this.cmd, g.class);
        Validators.nonNull((Object)this.contextName);
        this.cmd.checkComplete();
    }

    public final i.a commandView(ShellControl shellControl) {
        return new i(shellControl).a(this.configFile, this.contextName, this.namespaceName);
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.configFile, this.contextName, this.namespaceName));
    }

    public final List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() {
        ShellControl shellControl = ((ShellStore)((g)this.getCmd().getStore()).getHost().getStore()).getOrStartSession();
        i.a a2 = new i(shellControl).a(this.configFile, this.contextName, this.namespaceName);
        try {
            if (this.configFile != null && !shellControl.view().fileExists(this.configFile.toAbsoluteFilePath(shellControl))) {
                throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException("Kubeconfig file " + String.valueOf(this.configFile.toAbsoluteFilePath(shellControl)) + " does not exist on host system " + ((g)this.getCmd().getStore()).getHost().get().getName()));
            }
            boolean bl = a2.cj();
            String string = a2.ch();
            DataStoreState dataStoreState = ((c.a)((Object)((c.a)((Object)((c.a)((Object)((c)this.getState()).toBuilder().clusterName(string))).reachable(Boolean.TRUE))).enterprise(bl))).build();
            this.setState(dataStoreState);
            return a2.f((DataStoreEntryRef<e>)this.getSelfEntry().ref());
        }
        catch (Exception exception) {
            DataStoreState dataStoreState = ((c.a)((Object)((c)this.getState()).toBuilder().reachable(Boolean.FALSE))).build();
            this.setState(dataStoreState);
            throw exception;
        }
    }

    @Generated
    protected e(a<?, ?> a2) {
        this.cmd = a2.cmd;
        this.contextName = a2.contextName;
        this.namespaceName = a2.namespaceName;
        this.configFile = a2.configFile;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<g> getCmd() {
        return this.cmd;
    }

    @Generated
    public final String getContextName() {
        return this.contextName;
    }

    @Generated
    public final String getNamespaceName() {
        return this.namespaceName;
    }

    @Generated
    public final ContextualFileReference getConfigFile() {
        return this.configFile;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof e)) {
            return false;
        }
        object = (e)object;
        Object object2 = this.getCmd();
        Object object3 = ((e)object).getCmd();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getContextName();
        object3 = ((e)object).getContextName();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getNamespaceName();
        object3 = ((e)object).getNamespaceName();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getConfigFile();
        object = ((e)object).getConfigFile();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<g> dataStoreEntryRef = this.getCmd();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        String string = this.getContextName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        string = this.getNamespaceName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        string = this.getConfigFile();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "K8sClusterStore(cmd=" + String.valueOf(this.getCmd()) + ", contextName=" + this.getContextName() + ", namespaceName=" + this.getNamespaceName() + ", configFile=" + String.valueOf(this.getConfigFile()) + ")";
    }

    @JsonDeserialize(builder=b.class)
    public static final class c
    extends DataStoreState {
        private final String clusterName;
        private final Boolean reachable;
        private final boolean showNonRunning;
        private final boolean enterprise;

        public final DataStoreState mergeCopy(DataStoreState dataStoreState) {
            dataStoreState = (c)dataStoreState;
            return ((a)((Object)((a)((Object)((a)((Object)((a)((Object)this.toBuilder().clusterName((String)c.useNewer((Object)this.clusterName, (Object)dataStoreState.clusterName)))).showNonRunning(dataStoreState.showNonRunning))).reachable((Boolean)c.useNewer((Object)this.reachable, (Object)dataStoreState.reachable)))).enterprise(dataStoreState.enterprise))).build();
        }

        @Generated
        protected c(a<?, ?> a2) {
            super(a2);
            this.clusterName = a2.clusterName;
            this.reachable = a2.reachable;
            this.showNonRunning = a2.showNonRunning;
            this.enterprise = a2.enterprise;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @Generated
        public final a<?, ?> toBuilder() {
            return new b().$fillValuesFrom(this);
        }

        @Generated
        public final String getClusterName() {
            return this.clusterName;
        }

        @Generated
        public final Boolean getReachable() {
            return this.reachable;
        }

        @Generated
        public final boolean isShowNonRunning() {
            return this.showNonRunning;
        }

        @Generated
        public final boolean isEnterprise() {
            return this.enterprise;
        }

        @Generated
        public final String toString() {
            return "K8sClusterStore.State(clusterName=" + this.getClusterName() + ", reachable=" + this.getReachable() + ", showNonRunning=" + this.isShowNonRunning() + ", enterprise=" + this.isEnterprise() + ")";
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            Object object2 = (c)((Object)object);
            if (!object2.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.isShowNonRunning() != object2.isShowNonRunning()) {
                return false;
            }
            if (this.isEnterprise() != object2.isEnterprise()) {
                return false;
            }
            object = this.getReachable();
            Boolean bl = object2.getReachable();
            if (object == null ? bl != null : !object.equals(bl)) {
                return false;
            }
            object = this.getClusterName();
            object2 = object2.getClusterName();
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof c;
        }

        @Generated
        public final int hashCode() {
            int n2 = super.hashCode();
            n2 = n2 * 59 + (this.isShowNonRunning() ? 79 : 97);
            n2 = n2 * 59 + (this.isEnterprise() ? 79 : 97);
            Object object = this.getReachable();
            n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
            object = this.getClusterName();
            n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
            return n2;
        }

        @Generated
        public static abstract class a<C extends c, B extends a<C, B>>
        extends DataStoreState.DataStoreStateBuilder<C, B> {
            @Generated
            private String clusterName;
            @Generated
            private Boolean reachable;
            @Generated
            private boolean showNonRunning;
            @Generated
            private boolean enterprise;

            @Generated
            protected B $fillValuesFrom(C c2) {
                super.$fillValuesFrom(c2);
                a.$fillValuesFromInstanceIntoBuilder(c2, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(c c2, a<?, ?> a2) {
                a2.clusterName(c2.clusterName);
                a2.reachable(c2.reachable);
                a2.showNonRunning(c2.showNonRunning);
                a2.enterprise(c2.enterprise);
            }

            @Generated
            public B clusterName(String string) {
                this.clusterName = string;
                return (B)this.self();
            }

            @Generated
            public B reachable(Boolean bl) {
                this.reachable = bl;
                return (B)this.self();
            }

            @Generated
            public B showNonRunning(boolean bl) {
                this.showNonRunning = bl;
                return (B)this.self();
            }

            @Generated
            public B enterprise(boolean bl) {
                this.enterprise = bl;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "K8sClusterStore.State.StateBuilder(super=" + super.toString() + ", clusterName=" + this.clusterName + ", reachable=" + this.reachable + ", showNonRunning=" + this.showNonRunning + ", enterprise=" + this.enterprise + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<c, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final c build() {
                return new c(this);
            }
        }
    }

    @Generated
    public static abstract class a<C extends e, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<g> cmd;
        @Generated
        private String contextName;
        @Generated
        private String namespaceName;
        @Generated
        private ContextualFileReference configFile;

        @Generated
        public B cmd(DataStoreEntryRef<g> dataStoreEntryRef) {
            this.cmd = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B contextName(String string) {
            this.contextName = string;
            return this.self();
        }

        @Generated
        public B namespaceName(String string) {
            this.namespaceName = string;
            return this.self();
        }

        @Generated
        public B configFile(ContextualFileReference contextualFileReference) {
            this.configFile = contextualFileReference;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "K8sClusterStore.K8sClusterStoreBuilder(cmd=" + String.valueOf(this.cmd) + ", contextName=" + this.contextName + ", namespaceName=" + this.namespaceName + ", configFile=" + String.valueOf(this.configFile) + ")";
        }
    }

    @JsonTypeName(value="k8sCluster")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<e, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final e build() {
            return new e(this);
        }
    }
}

