/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.proxmox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.xpipe.app.ext.ContainerImageStore;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.PropertiesFormatsParser;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.proxmox.d;
import io.xpipe.ext.proc.proxmox.h;
import io.xpipe.ext.proc.proxmox.o;
import io.xpipe.ext.proc.proxmox.q;
import io.xpipe.ext.proc.vm.e;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class f {
    public static ElevationFunction cd() {
        return ElevationFunction.ifNotRoot((ElevationFunction)ElevationFunction.elevated((String)"proxmox"));
    }

    public static boolean D(ShellControl shellControl) {
        if (shellControl.getOsType() != OsType.LINUX) {
            return false;
        }
        if (shellControl.getSourceStore().map(dataStore -> dataStore instanceof ContainerImageStore).orElse(Boolean.FALSE).booleanValue()) {
            return false;
        }
        String string = shellControl.executeSimpleStringCommand("uname -a");
        if (string.contains("-pve")) {
            return true;
        }
        if (shellControl.view().findProgram("pct").isPresent() && shellControl.view().findProgram("qm").isPresent()) {
            return true;
        }
        return shellControl.getShellDialect().createFileExistsCommand(shellControl, "/usr/sbin/pct").executeAndCheck() && shellControl.getShellDialect().createFileExistsCommand(shellControl, "/usr/sbin/qm").executeAndCheck();
    }

    public static String queryVersion(ShellControl object) {
        object = object.command("pveversion").elevated(f.cd()).readStdoutIfPossible();
        return object.map(string -> string.split(" ")[0]).orElse(null);
    }

    public static void a(ShellControl shellControl, int n2) {
        shellControl.command(CommandBuilder.of().add(new String[]{"qm", "guest", "cmd", "" + n2, "network-get-interfaces"})).elevated(f.cd()).withErrorFormatter(string -> {
            if (string.contains("No QEMU guest agent configured")) {
                return string + "\n\nSee https://pve.proxmox.com/wiki/Qemu-guest-agent for details";
            }
            if (string.contains("QEMU guest agent is not running")) {
                return string + "\n\nIs the VM fully started up yet?";
            }
            return string;
        }).execute();
    }

    public static Optional<String> b(ShellControl object, int n2) {
        object = object.command(CommandBuilder.of().add(new String[]{"qm", "guest", "cmd", "" + n2, "network-get-interfaces"})).elevated(f.cd()).readStdoutOrThrow();
        object = JacksonMapper.getDefault().readTree((String)object);
        if (!object.isArray()) {
            return Optional.empty();
        }
        return StreamSupport.stream(object.spliterator(), false).map(jsonNode2 -> {
            if (!jsonNode2.isObject()) {
                return Optional.empty();
            }
            JsonNode jsonNode3 = (jsonNode2 = (ObjectNode)jsonNode2).get("name");
            if (jsonNode3 != null && "lo".equals(jsonNode3.asText())) {
                return Optional.empty();
            }
            if ((jsonNode2 = jsonNode2.get("ip-addresses")) == null) {
                return Optional.empty();
            }
            if ((jsonNode2 = (JsonNode)StreamSupport.stream(jsonNode2.spliterator(), false).filter(jsonNode -> "ipv4".equals(jsonNode.get("ip-address-type") != null ? jsonNode.get("ip-address-type").asText() : null)).map(jsonNode -> jsonNode.get("ip-address")).filter(jsonNode -> jsonNode != null).findFirst().orElse(null)) != null && "127.0.0.1".equals(jsonNode2.asText())) {
                return Optional.empty();
            }
            return Optional.ofNullable(jsonNode2).map(jsonNode -> jsonNode.asText());
        }).flatMap(Optional::stream).findFirst();
    }

    public static List<DataStoreEntryRef<o>> a(DataStoreEntryRef<h> object2, ShellControl shellControl) {
        if (!f.D(shellControl)) {
            return List.of();
        }
        try (CommandControl commandControl = shellControl.command("qm list").elevated(f.cd()).start();){
            String string2 = commandControl.readStdoutOrThrow();
            object2 = string2.lines().skip(1L).map(string -> string.strip().split("\\s+")).map(object -> {
                String string = object[((String[])object).length - 1];
                String string2 = object[((String[])object).length - 2];
                String string3 = object[((String[])object).length - 3];
                String string4 = object[((String[])object).length - 4];
                String string5 = object[0];
                object = Arrays.stream(object, 1, ((String[])object).length - 4).collect(Collectors.joining(" "));
                return new String[]{string5, object, string4, string3, string2, string};
            }).map(stringArray -> {
                int n2 = Integer.parseInt(stringArray[0]);
                String string = stringArray[1];
                object2 = ((o.a)((e.a)((o.a)((o.a)((o.a)((o.a)((e.a)((o.a)o.builder().install((DataStoreEntryRef<h>)object2)).vmid(n2)).customIp(null)).port(22)).forwardX11(Boolean.FALSE)).additionalOptions(null)).name(string)).identity(IdentityValue.ofBreakout((DataStoreEntry)object2.get()))).build();
                string = DataStoreEntry.createNew((String)string, (DataStore)object2);
                int n3 = f.d(shellControl, n2).orElse(-1);
                object2 = ((q.a)((Object)((Object)((q.a)((Object)((Object)((q.a)((Object)((Object)((q)object2.getState()).toBuilder().running("running".equals(stringArray[2]))))).stateString(DataStoreFormatter.capitalize((String)stringArray[2]))))).vncDisplay(n3 != -1 ? Integer.valueOf(n3) : null)))).build();
                string.setStorePersistentState((DataStoreState)object2);
                string.setOrderIndex(n2);
                return string.ref();
            }).toList();
            return object2;
        }
    }

    public static String c(ShellControl object, int n2) {
        if (((Optional)(object = object.command(CommandBuilder.of().add(new String[]{"qm", "status", "" + n2})).elevated(f.cd()).readStdoutIfPossible())).isEmpty()) {
            return null;
        }
        return ((String)((Optional)object).get()).split(" ", 2)[1];
    }

    public static boolean E(ShellControl object) {
        if (((Optional)(object = object.command("pvesh get /cluster/status --output-format json").elevated(f.cd()).readStdoutIfPossible())).isEmpty()) {
            return false;
        }
        object = JacksonMapper.getDefault().readTree((String)((Optional)object).get());
        if (!object.isArray() || object.size() == 0) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            JsonNode jsonNode = (JsonNode)object.next();
            if ((jsonNode = jsonNode.get("level")) == null || !jsonNode.isTextual() || jsonNode.asText().isEmpty() || jsonNode.asText().equals("c")) continue;
            return true;
        }
        return false;
    }

    public static OptionalInt d(ShellControl object, int n2) {
        try {
            String string = "/etc/pve/local/qemu-server/" + n2 + ".conf";
            object = object.getShellDialect().getFileReadCommand((ShellControl)object, string).elevated(f.cd()).readStdoutOrThrow();
            object = PropertiesFormatsParser.parse((String)object, (String)":");
            object = (String)object.get("args");
            if (object == null) {
                return OptionalInt.empty();
            }
            object = Pattern.compile("-vnc\\s+\\w+:(\\d+)").matcher((CharSequence)object);
            if (!((Matcher)object).find()) {
                return OptionalInt.empty();
            }
            object = ((Matcher)object).group(1);
            return OptionalInt.of(Integer.parseInt((String)object));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void a(ShellControl object, int n2, int n3) {
        String string = "/etc/pve/local/qemu-server/" + n2 + ".conf";
        Object object2 = "-vnc localhost:" + n3;
        String string2 = object.getShellDialect().getFileReadCommand((ShellControl)object, string).elevated(f.cd()).readStdoutOrThrow();
        Object object3 = PropertiesFormatsParser.parse((String)string2, (String)":");
        object2 = (object3 = (String)object3.get("args")) == null ? string2.strip() + "\nargs: " + (String)object2 + "\n" : string2.lines().map(arg_0 -> f.j((String)object2, arg_0)).collect(Collectors.joining("\n")) + "\n";
        object2 = ((String)object2).getBytes(StandardCharsets.UTF_8);
        object = object.getShellDialect().createStreamFileWriteCommand((ShellControl)object, string, (long)((Object)object2).length).elevated(f.cd()).startExternalStdin();
        try {
            ((OutputStream)object).write((byte[])object2);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    public static List<DataStoreEntryRef<d>> b(DataStoreEntryRef<h> object, ShellControl shellControl) {
        if (!f.D(shellControl)) {
            return List.of();
        }
        shellControl = shellControl.command("pct list").elevated(f.cd()).start();
        try {
            String string2 = shellControl.readStdoutOrThrow();
            object = string2.lines().skip(1L).map(string -> string.strip().split("\\s+", 4)).map(stringArray -> {
                int n2 = Integer.parseInt(stringArray[0]);
                String string = ((String[])stringArray).length == 4 ? stringArray[3] : stringArray[2];
                object = ((d.a)((d.a)((d.a)((d.a)d.builder().install((DataStoreEntryRef<h>)object)).vmid(n2)).name(string)).identity(IdentityValue.ofBreakout((DataStoreEntry)object.get()))).build();
                string = DataStoreEntry.createNew((String)string, (DataStore)object);
                object = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)object.getState()).toBuilder().containerState(DataStoreFormatter.capitalize((String)stringArray[1])).running(Boolean.valueOf("running".equals(stringArray[1])))).build();
                string.setStorePersistentState((DataStoreState)object);
                string.setOrderIndex(n2);
                return string.ref();
            }).toList();
            return object;
        }
        finally {
            if (shellControl != null) {
                shellControl.close();
            }
        }
    }

    private static /* synthetic */ String j(String string, String string2) {
        if (string2.startsWith("args:")) {
            return string2 + " " + string;
        }
        return string2;
    }
}

