/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.InternalCacheDataStore;
import io.xpipe.app.ext.LocalStore;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.identity.IdentitySwitchStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.e;
import io.xpipe.ext.proc.ssh.g;
import io.xpipe.ext.proc.ssh.k;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="sshConfigHost")
@JsonDeserialize(builder=b.class)
public final class i
extends e<ShellStoreState>
implements FixedChildStore,
InternalCacheDataStore {
    private final DataStoreEntryRef<k> config;
    private final g.a hostEntry;
    private final IdentityValue identity;
    private final Boolean dontInteractWithSystem;
    private final Boolean forwardX11;

    @Override
    public final boolean isLocalClient() {
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = ((k)this.config.getStore()).getHost();
        return dataStoreEntryRef == null || dataStoreEntryRef.getStore() instanceof LocalStore;
    }

    public final IdentitySwitchStore withIdentity(IdentityValue identityValue) {
        return ((a)this.toBuilder().identity(identityValue)).build();
    }

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    public final boolean isPerUser() {
        return this.identity.isPerUser();
    }

    public final void checkComplete() {
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        Validators.nonNull(this.config);
        Validators.isType(this.config, k.class);
        this.config.checkComplete();
        Validators.nonNull((Object)this.hostEntry);
        this.checkValidGatewayChain();
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.hostEntry.cZ()));
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (i)fixedChildStore.asNeeded();
        return ((a)((a)((a)((a)((a)i.builder().config(this.config)).hostEntry(fixedChildStore.hostEntry)).identity(this.identity != null ? this.identity : fixedChildStore.identity)).dontInteractWithSystem(this.dontInteractWithSystem != null ? this.dontInteractWithSystem : fixedChildStore.dontInteractWithSystem)).forwardX11(this.forwardX11 != null ? this.forwardX11 : fixedChildStore.forwardX11)).build();
    }

    public final boolean isLocal() {
        return this.getConfig() == null || ((k)this.getConfig().getStore()).getHost() == null || DataStorage.get().local().equals((Object)((k)this.getConfig().getStore()).getHost().get());
    }

    @Override
    public final g toConfigHost() {
        if (!this.isLocal()) {
            return null;
        }
        return new g(new g.a(this.hostEntry.cZ(), List.of()));
    }

    @Override
    protected final boolean dontInteractWithSystem() {
        if (this.dontInteractWithSystem != null) {
            return this.dontInteractWithSystem;
        }
        return false;
    }

    @Override
    protected final boolean hasX11Forward() {
        if (!this.isLocal()) {
            return false;
        }
        if (this.hostEntry == null) {
            return false;
        }
        return this.hostEntry.aS("ForwardX11") || this.hostEntry.aS("ForwardX11Trusted");
    }

    @Override
    public final SecretRetrievalStrategy getPassword() {
        SecretRetrievalStrategy secretRetrievalStrategy = this.identity.unwrap().getPassword();
        if (secretRetrievalStrategy != null) {
            return secretRetrievalStrategy;
        }
        return new SecretNoneStrategy();
    }

    @Override
    public final DataStoreEntryRef<NetworkTunnelStore> getTunnelGateway() {
        if (!this.isLocal()) {
            return DataStorage.get().local().ref();
        }
        Object object = this.hostEntry.l("ProxyJump", null);
        if (object == null) {
            return DataStorage.get().local().ref();
        }
        object = DataStorage.get().getStoreChildren(this.config.get()).stream().filter(dataStoreEntry -> dataStoreEntry.getValidity().isUsable()).filter(arg_0 -> i.lambda$getTunnelGateway$1((String)object, arg_0)).findFirst();
        return ((Optional)object).orElse((DataStoreEntry)DataStorage.get().local()).ref();
    }

    @Override
    public final boolean useGatewayWithProxyJump() {
        return this.isLocal();
    }

    @Override
    public final HostAddress getHostAddress() {
        return HostAddress.of((String)this.hostEntry.l("Hostname", this.hostEntry.l("HostName", "localhost")));
    }

    @Override
    public final UsernameStrategy getUser() {
        String string = this.hostEntry.l("User", null);
        if (string != null) {
            return new UsernameStrategy.Fixed(string);
        }
        if (this.identity != null) {
            return this.identity.unwrap().getUsername();
        }
        return new UsernameStrategy.None();
    }

    @Override
    public final int getPort() {
        String string = this.getHostEntry().l("Port", "22");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 22;
        }
    }

    @Override
    protected final ShellControl createBaseShellControl() {
        if (!this.isLocal()) {
            return ((ShellStore)((k)this.getConfig().getStore()).getHost().getStore()).shellFunction().control();
        }
        return super.createBaseShellControl();
    }

    @Override
    protected final CommandBuilder buildBaseCommand() {
        CommandBuilder commandBuilder = CommandBuilder.of();
        commandBuilder.add(shellControl -> {
            FilePath filePath = ((k)this.config.getStore()).getConfigFile() != null ? ((k)this.config.getStore()).getConfigFile().toAbsoluteFilePath(shellControl) : null;
            boolean bl = filePath == null || filePath.equals((Object)g.F(shellControl)) || filePath.equals((Object)g.G(shellControl));
            if (!bl) {
                return CommandBuilder.of().add(g.a(shellControl, filePath)).buildFull(shellControl);
            }
            return null;
        });
        String string = (String)(this.identity.unwrap().getUsername().hasUser() ? this.identity.unwrap().getUsername().retrieveUsername() + "@" : "") + this.hostEntry.cZ();
        commandBuilder.addQuoted(string);
        return commandBuilder;
    }

    @Override
    protected final SshIdentityStrategy getIdentityStrategy() {
        SshIdentityStrategy sshIdentityStrategy = g.a(this.getHostEntry());
        if (sshIdentityStrategy.isPresent()) {
            return sshIdentityStrategy.get();
        }
        sshIdentityStrategy = this.identity.unwrap().getSshIdentity();
        if (sshIdentityStrategy != null) {
            return sshIdentityStrategy;
        }
        return new NoIdentityStrategy();
    }

    @Override
    protected final boolean hasTunnels() {
        if (!this.isLocal()) {
            return false;
        }
        if (this.hostEntry == null) {
            return false;
        }
        return this.hostEntry.aT("LocalForward") || this.hostEntry.aT("RemoteForward") || this.hostEntry.aT("DynamicForward");
    }

    @Generated
    protected i(a<?, ?> a2) {
        super(a2);
        this.config = a2.config;
        this.hostEntry = a2.hostEntry;
        this.identity = a2.identity;
        this.dontInteractWithSystem = a2.dontInteractWithSystem;
        this.forwardX11 = a2.forwardX11;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<k> getConfig() {
        return this.config;
    }

    @Generated
    public final g.a getHostEntry() {
        return this.hostEntry;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final Boolean getDontInteractWithSystem() {
        return this.dontInteractWithSystem;
    }

    @Generated
    public final Boolean getForwardX11() {
        return this.forwardX11;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof i)) {
            return false;
        }
        i i2 = (i)object;
        if (!i2.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getDontInteractWithSystem();
        Object object2 = i2.getDontInteractWithSystem();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getForwardX11();
        object2 = i2.getForwardX11();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getConfig();
        object2 = i2.getConfig();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getHostEntry();
        object2 = i2.getHostEntry();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getIdentity();
        i2 = i2.getIdentity();
        return !(object == null ? i2 != null : !object.equals(i2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof i;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getDontInteractWithSystem();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getForwardX11();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getConfig();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHostEntry();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "SshConfigFileHostStore(super=" + super.toString() + ", config=" + String.valueOf(this.getConfig()) + ", hostEntry=" + String.valueOf(this.getHostEntry()) + ", identity=" + String.valueOf(this.getIdentity()) + ", dontInteractWithSystem=" + this.getDontInteractWithSystem() + ", forwardX11=" + this.getForwardX11() + ")";
    }

    private static /* synthetic */ boolean lambda$getTunnelGateway$1(String string, DataStoreEntry object) {
        object = (i)object.getStore().asNeeded();
        return object.getHostEntry().cZ().equals(string);
    }

    @Generated
    public static abstract class a<C extends i, B extends a<C, B>>
    extends e.a<ShellStoreState, C, B> {
        @Generated
        private DataStoreEntryRef<k> config;
        @Generated
        private g.a hostEntry;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean dontInteractWithSystem;
        @Generated
        private Boolean forwardX11;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(i i2, a<?, ?> a2) {
            a2.config(i2.config);
            a2.hostEntry(i2.hostEntry);
            a2.identity(i2.identity);
            a2.dontInteractWithSystem(i2.dontInteractWithSystem);
            a2.forwardX11(i2.forwardX11);
        }

        @Generated
        public B config(DataStoreEntryRef<k> dataStoreEntryRef) {
            this.config = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B hostEntry(g.a a2) {
            this.hostEntry = a2;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Generated
        public B dontInteractWithSystem(Boolean bl) {
            this.dontInteractWithSystem = bl;
            return (B)this.self();
        }

        @Generated
        public B forwardX11(Boolean bl) {
            this.forwardX11 = bl;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SshConfigFileHostStore.SshConfigFileHostStoreBuilder(super=" + super.toString() + ", config=" + String.valueOf(this.config) + ", hostEntry=" + String.valueOf(this.hostEntry) + ", identity=" + String.valueOf(this.identity) + ", dontInteractWithSystem=" + this.dontInteractWithSystem + ", forwardX11=" + this.forwardX11 + ")";
        }
    }

    @JsonTypeName(value="sshConfigHost")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<i, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final i build() {
            return new i(this);
        }
    }
}

