/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.user;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.core.AppCache;
import io.xpipe.app.core.AppProperties;
import io.xpipe.app.core.AppRestart;
import io.xpipe.app.core.window.AppMainWindow;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.prefs.VaultAuthentication;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.EncryptionToken;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageGroupStrategy;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.JacksonMapper;
import io.xpipe.ext.proc.user.a;
import io.xpipe.ext.proc.user.c;
import io.xpipe.ext.proc.user.g;
import io.xpipe.ext.proc.user.i;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javax.crypto.SecretKey;
import lombok.Generated;

public final class f
implements DataStorageUserHandler {
    private Path cJ;
    private a fD;
    private List<a> fF;
    private final List<a> fG = new ArrayList<a>();
    private boolean fH;
    private VaultAuthentication fI;

    public static f dV() {
        return (f)DataStorageUserHandler.getInstance();
    }

    public final int getUserCount() {
        return this.fF.size();
    }

    public final void init() {
        this.cJ = DataStorage.getStorageDirectory();
        Path path = this.cJ.resolve("users.json");
        boolean bl = Files.exists(path, new LinkOption[0]);
        Object object2 = AppPrefs.get().getLockCrypt();
        if (object2.get() != null && !((String)object2.get()).isBlank()) {
            EncryptionToken encryptionToken = EncryptionToken.builder().token((String)object2.get()).build();
            this.fF = new ArrayList<a>();
            this.fF.add(new a("legacy", c.a.builder().encryptedToken(encryptionToken).build(), null));
        } else if (!bl) {
            this.fF = new ArrayList<a>();
        } else {
            try {
                Object object3 = JacksonMapper.getDefault();
                object2 = new TypeReference<ArrayList<a>>(this){
                    {
                        Objects.requireNonNull(f2);
                    }
                };
                object3 = (ArrayList)object3.readValue(path.toFile(), (TypeReference)object2);
                if (object3 == null) {
                    throw new IOException("Unable to read users file json");
                }
                this.fF = new ArrayList<a>((Collection<a>)object3);
                if (this.fF.stream().anyMatch(a2 -> a2 == null)) {
                    throw new IOException("User list contains null entry");
                }
                if (this.fF.stream().anyMatch(object -> ((a)object).getAuthMethod() == null || (object = ((a)object).getAuthMethod()) instanceof c.a && ((c.a)(object = (c.a)object)).getEncryptedToken() == null)) {
                    throw new IOException("User list contains invalid authentication data");
                }
            }
            catch (IOException iOException) {
                throw new IOException("Unable to read vault users file " + String.valueOf(path) + ". Is it corrupted?", iOException);
            }
        }
        g.ea().g(false);
        if (this.fF.size() > 0) {
            boolean bl2 = this.fF.stream().anyMatch(a2 -> {
                if (a2.getGroupStrategy() == null) {
                    return false;
                }
                try {
                    ((DataStorageGroupStrategy)a2.getGroupStrategy().getValue()).checkComplete();
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            });
            this.fI = bl2 ? VaultAuthentication.GROUP : VaultAuthentication.USER;
        }
    }

    public final void save() {
        if (!this.fH) {
            return;
        }
        Object object = this.cJ.resolve("users.json");
        if (this.fF.size() == 0 && !Files.exists((Path)object, new LinkOption[0])) {
            return;
        }
        ObjectMapper objectMapper = JacksonMapper.getDefault();
        try {
            Files.createDirectories(object.getParent(), new FileAttribute[0]);
            objectMapper.writeValue(object.toFile(), this.fF);
            this.fH = false;
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            ErrorEventFactory.fromThrowable((Throwable)iOException).handle();
            return;
        }
    }

    public final void login() {
        if (this.fF.size() == 0) {
            return;
        }
        if (this.fF.size() > 1 && !LicenseProvider.get().getFeature("team").isSupported()) {
            try {
                LicenseProvider.get().getFeature("team").throwIfUnsupported();
                return;
            }
            catch (LicenseRequiredException licenseRequiredException) {
                LicenseRequiredException licenseRequiredException2 = licenseRequiredException;
                ErrorEventFactory.fromThrowable((Throwable)licenseRequiredException).handle();
                return;
            }
        }
        String string = null;
        if (this.fF.size() == 1) {
            string = this.fF.getFirst().getName();
        } else {
            Object object = AppProperties.get().getLoginTarget();
            if (object != null && ((Optional)(object = this.fF.stream().filter(arg_0 -> f.d((String)object, arg_0)).findFirst())).isPresent()) {
                string = ((a)((Optional)object).get()).getName();
            }
            if (string == null) {
                string = (String)AppCache.getNonNull((String)"lastUser", String.class, () -> null);
            }
        }
        i.e(string, this.fF.size() > 1);
    }

    public final SecretKey getEncryptionKey() {
        if (this.fF.size() == 0) {
            return null;
        }
        if (this.fD == null) {
            return null;
        }
        SecretKey secretKey = this.fD.getAuthMethod().getEncryptionKey();
        return secretKey;
    }

    public final Comp<?> createOverview() {
        Comp<?> comp = g.ea().eb();
        return comp;
    }

    public final OptionsBuilder createGroupStrategyOptions(ObjectProperty<DataStorageGroupStrategy> optionsBuilder) {
        optionsBuilder = g.ea().a((ObjectProperty<DataStorageGroupStrategy>)optionsBuilder);
        return optionsBuilder;
    }

    public final String getActiveUser() {
        if (this.fD != null) {
            return this.fD.getName();
        }
        return null;
    }

    public final VaultAuthentication getVaultAuthenticationType() {
        return this.fI;
    }

    public final void a(a a2) {
        this.fF.remove(a2);
        this.fH = true;
        if (this.fG.remove(a2)) {
            g.ea().g(true);
            return;
        }
        if (a2.equals(this.fD)) {
            this.fD = null;
        }
        if (a2.getName().equals("legacy")) {
            AppPrefs.get().getLockCrypt().set(null);
        }
        AppMainWindow.resetContent();
        DataStorage.get().forceRewrite();
        DataStorage.get().save(false);
        AppRestart.restart();
    }

    public final boolean dW() {
        return this.fF.size() == 1 && this.fF.getFirst().getName().equals("legacy");
    }

    public final boolean a(String string, InPlaceSecretValue inPlaceSecretValue) {
        c c2;
        Optional<a> optional = this.fF.stream().filter(a2 -> a2.getName().equals(string)).findFirst();
        if (optional.isEmpty()) {
            return false;
        }
        if (inPlaceSecretValue == null) {
            return false;
        }
        boolean bl = string.equals("legacy");
        if (bl && (c2 = optional.get().getAuthMethod()) instanceof c.a && ((c.a)(c2 = (c.a)c2)).unlockLegacy(inPlaceSecretValue)) {
            this.fD = optional.get();
            AppCache.update((String)"lastUser", (Object)this.fD.getName());
            return true;
        }
        c c3 = optional.get().getAuthMethod();
        if (c3 instanceof c.a && ((c.a)(c3 = (c.a)c3)).unlock(inPlaceSecretValue)) {
            this.fD = optional.get();
            AppCache.update((String)"lastUser", (Object)this.fD.getName());
            return true;
        }
        return false;
    }

    public final void a(String string, InPlaceSecretValue object, DataStorageGroupStrategy dataStorageGroupStrategy) {
        if (string == null || string.isBlank() || object == null || object.getSecret().length == 0) {
            return;
        }
        if (this.fF.stream().anyMatch(a2 -> a2.getName().equalsIgnoreCase(string))) {
            return;
        }
        object = new a(string, c.a.ofPassword(object), (EncryptedValue.VaultKey<DataStorageGroupStrategy>)EncryptedValue.VaultKey.of((Object)dataStorageGroupStrategy));
        this.fF.add((a)object);
        this.fH = true;
        if (this.fD == null) {
            this.fD = object;
        } else {
            this.fG.add((a)object);
        }
        g.ea().g(true);
        AppCache.update((String)"lastUser", (Object)string);
        this.save();
        if (this.fF.size() == 1 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
            DataStorage.get().save(false);
        }
        if (this.fF.size() == 2 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
            DataStorage.get().save(false);
        }
    }

    public final DataStorageGroupStrategy getGroupStrategy(String object) {
        if (object == null) {
            return null;
        }
        object = this.dY().stream().filter(arg_0 -> f.a((String)object, arg_0)).findFirst().orElse(null);
        if (object == null) {
            return null;
        }
        if ((object = object.getGroupStrategy()) == null) {
            return null;
        }
        try {
            ((DataStorageGroupStrategy)object.getValue()).checkComplete();
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).omit().expected().handle();
            return null;
        }
        return (DataStorageGroupStrategy)object.getValue();
    }

    public final void setCurrentGroupStrategy(DataStorageGroupStrategy dataStorageGroupStrategy) {
        if (this.fD == null) {
            return;
        }
        this.fD.setGroupStrategy((EncryptedValue.VaultKey<DataStorageGroupStrategy>)(this.fD.getGroupStrategy() != null ? this.fD.getGroupStrategy().withValue((Object)dataStorageGroupStrategy) : EncryptedValue.VaultKey.of((Object)dataStorageGroupStrategy)));
        this.fH = true;
    }

    public final void a(InPlaceSecretValue object) {
        if (this.fD == null) {
            return;
        }
        if (object == null) {
            return;
        }
        object = c.a.ofPassword(object);
        this.fD.setAuthMethod((c)object);
        this.fH = true;
        EncryptionToken.invalidateUserToken();
        if (DataStorage.get() != null) {
            DataStorage.get().forceRewrite();
            DataStorage.get().save(false);
        }
    }

    @Generated
    public final a dX() {
        return this.fD;
    }

    @Generated
    public final List<a> dY() {
        return this.fF;
    }

    private static /* synthetic */ boolean a(String string, a a2) {
        return a2.getName().equalsIgnoreCase(string);
    }

    private static /* synthetic */ boolean d(String string, a a2) {
        return a2.getName().equalsIgnoreCase(string);
    }
}

