/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.InputGroupComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.OptionsChoiceBuilder;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.secret.SecretStrategyChoiceConfig;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.base.identity.IdentitySelectComp;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.LocalIdentityStore;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public final class IdentityChoiceBuilder {
    private final ObjectProperty<IdentityValue> identity;
    private final boolean allowCustomUserInput;
    private final boolean requireUserInput;
    private final boolean requirePassword;
    private final boolean keyInput;
    private final boolean requireKeyInput;
    private final boolean allowAgentForward;
    private final String userChoiceTranslationKey;
    private final ObservableValue<String> passwordChoiceTranslationKey;
    private final ObservableValue<DataStoreEntryRef<ShellStore>> fileSystem;

    public IdentityChoiceBuilder(ObjectProperty<IdentityValue> identity, boolean allowCustomUserInput, boolean requireUserInput, boolean requirePassword, boolean keyInput, boolean requireKeyInput, boolean allowAgentForward, String userChoiceTranslationKey, String passwordChoiceTranslationKey) {
        this.identity = identity;
        this.allowCustomUserInput = allowCustomUserInput;
        this.requireUserInput = requireUserInput;
        this.requirePassword = requirePassword;
        this.keyInput = keyInput;
        this.requireKeyInput = requireKeyInput;
        this.allowAgentForward = allowAgentForward;
        this.userChoiceTranslationKey = userChoiceTranslationKey;
        this.passwordChoiceTranslationKey = new ReadOnlyStringWrapper(passwordChoiceTranslationKey);
        this.fileSystem = new ReadOnlyObjectWrapper((Object)DataStorage.get().local().ref());
    }

    public static OptionsBuilder ssh(ObjectProperty<IdentityValue> identity, boolean requireUser) {
        IdentityChoiceBuilder i = new IdentityChoiceBuilder(identity, true, requireUser, true, true, true, true, "identityChoice", "passwordAuthentication");
        return i.build();
    }

    public static OptionsBuilder container(ObjectProperty<IdentityValue> identity) {
        IdentityChoiceBuilder i = new IdentityChoiceBuilder(identity, true, false, false, false, false, false, "customUsername", "customUsernamePassword");
        return i.build();
    }

    public static OptionsBuilder keyAuthChoice(Property<SshIdentityStrategy> identity, SshIdentityStrategyChoiceConfig config) {
        return OptionsChoiceBuilder.builder().allowNull(false).property(identity).customConfiguration((Object)config).available(SshIdentityStrategy.getSubclasses()).transformer(entryComboBox -> {
            ButtonComp button = new ButtonComp(null, (LabelGraphic)new LabelGraphic.IconGraphic("mdi2k-key-plus"), () -> ProcessControlProvider.get().showSshKeygenDialog(null, identity));
            button.descriptor(d -> d.nameKey("generateKey"));
            Comp comboComp = Comp.of(() -> entryComboBox);
            InputGroupComp hbox = new InputGroupComp(List.of(comboComp, button));
            hbox.setMainReference(comboComp);
            return hbox.createRegion();
        }).build().build();
    }

    public OptionsBuilder build() {
        DataStoreEntryRef<IdentityStore> dataStoreEntryRef;
        IdentityValue.InPlace inPlace;
        IdentityValue.InPlace inPlace2;
        IdentityValue.InPlace inPlace3;
        IdentityValue existing = (IdentityValue)this.identity.getValue();
        SimpleStringProperty user = new SimpleStringProperty(existing instanceof IdentityValue.InPlace && (inPlace3 = (IdentityValue.InPlace)existing).unwrap() != null ? inPlace3.unwrap().getUsername().get() : null);
        SimpleObjectProperty pass = new SimpleObjectProperty(existing instanceof IdentityValue.InPlace && (inPlace2 = (IdentityValue.InPlace)existing).unwrap() != null ? inPlace2.unwrap().getPassword() : null);
        SimpleObjectProperty identityStrategy = new SimpleObjectProperty(existing instanceof IdentityValue.InPlace && (inPlace = (IdentityValue.InPlace)existing).unwrap() != null ? inPlace.unwrap().getSshIdentity() : null);
        if (existing instanceof IdentityValue.Ref) {
            IdentityValue.Ref r = (IdentityValue.Ref)existing;
            dataStoreEntryRef = r.getRef();
        } else {
            dataStoreEntryRef = null;
        }
        SimpleObjectProperty ref = new SimpleObjectProperty(dataStoreEntryRef);
        BooleanBinding inPlaceSelected = ref.isNull();
        BooleanBinding refSelected = ref.isNotNull();
        OptionsBuilder passwordChoice = OptionsChoiceBuilder.builder().allowNull(false).property((Property)pass).customConfiguration((Object)SecretStrategyChoiceConfig.builder().allowNone(true).build()).available(SecretRetrievalStrategy.getClasses()).build().build();
        OptionsBuilder options = new OptionsBuilder().nameAndDescription(this.userChoiceTranslationKey).addComp((Comp)new IdentitySelectComp((ObjectProperty<DataStoreEntryRef<IdentityStore>>)ref, (Property<String>)user, (ObservableValue<SecretRetrievalStrategy>)pass, (ObservableValue<SshIdentityStrategy>)identityStrategy, this.allowCustomUserInput), (Property)user).nonNullIf((ObservableValue)inPlaceSelected.and((ObservableBooleanValue)new SimpleBooleanProperty(this.requireUserInput))).name((ObservableValue)Bindings.createStringBinding(() -> AppI18n.get((String)((String)this.passwordChoiceTranslationKey.getValue()), (Object[])new Object[0]), (Observable[])new Observable[]{this.passwordChoiceTranslationKey, AppI18n.activeLanguage()})).description((ObservableValue)Bindings.createStringBinding(() -> AppI18n.get((String)((String)this.passwordChoiceTranslationKey.getValue() + "Description"), (Object[])new Object[0]), (Observable[])new Observable[]{this.passwordChoiceTranslationKey, AppI18n.activeLanguage()})).sub(passwordChoice, (Property)pass).nonNullIf((ObservableValue)inPlaceSelected.and((ObservableBooleanValue)new SimpleBooleanProperty(this.requirePassword))).hide((ObservableValue)refSelected).addProperty((Property)ref);
        SshIdentityStrategyChoiceConfig sshIdentityChoiceConfig = SshIdentityStrategyChoiceConfig.builder().allowAgentForward(this.allowAgentForward).allowKeyFileSync(true).perUserKeyFileCheck(() -> false).fileSystem(this.fileSystem).build();
        if (this.keyInput) {
            options.name("keyAuthentication").description("keyAuthenticationDescription").documentationLink(DocumentationLink.SSH_KEYS).sub(IdentityChoiceBuilder.keyAuthChoice((Property<SshIdentityStrategy>)identityStrategy, sshIdentityChoiceConfig), (Property)identityStrategy).nonNullIf((ObservableValue)inPlaceSelected.and((ObservableBooleanValue)new ReadOnlyBooleanWrapper(this.requireKeyInput))).hide((ObservableValue)refSelected);
        }
        options.bind(() -> {
            EncryptedValue.CurrentKey i;
            EncryptedValue.CurrentKey p;
            if (ref.get() != null) {
                return IdentityValue.Ref.builder().ref((DataStoreEntryRef<IdentityStore>)((DataStoreEntryRef)ref.get())).build();
            }
            String u = user.get();
            boolean useUserKey = DataStorageUserHandler.getInstance().getUserCount() <= 1;
            Object object = p = useUserKey ? EncryptedValue.CurrentKey.of((Object)((SecretRetrievalStrategy)pass.get())) : EncryptedValue.VaultKey.of((Object)((SecretRetrievalStrategy)pass.get()));
            Object object2 = this.keyInput ? (useUserKey ? EncryptedValue.CurrentKey.of((Object)((SshIdentityStrategy)identityStrategy.get())) : EncryptedValue.VaultKey.of((Object)((SshIdentityStrategy)identityStrategy.get()))) : (i = null);
            if (u == null && p == null && i == null) {
                return null;
            }
            return IdentityValue.InPlace.builder().identityStore((LocalIdentityStore)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().username(u)).password((EncryptedValue<SecretRetrievalStrategy>)p)).sshIdentity((EncryptedValue<SshIdentityStrategy>)i)).build()).build();
        }, new Property[]{this.identity});
        return options;
    }

    @Generated
    public static IdentityChoiceBuilderBuilder builder() {
        return new IdentityChoiceBuilderBuilder();
    }

    @Generated
    public ObjectProperty<IdentityValue> getIdentity() {
        return this.identity;
    }

    @Generated
    public boolean isAllowCustomUserInput() {
        return this.allowCustomUserInput;
    }

    @Generated
    public boolean isRequireUserInput() {
        return this.requireUserInput;
    }

    @Generated
    public boolean isRequirePassword() {
        return this.requirePassword;
    }

    @Generated
    public boolean isKeyInput() {
        return this.keyInput;
    }

    @Generated
    public boolean isRequireKeyInput() {
        return this.requireKeyInput;
    }

    @Generated
    public boolean isAllowAgentForward() {
        return this.allowAgentForward;
    }

    @Generated
    public String getUserChoiceTranslationKey() {
        return this.userChoiceTranslationKey;
    }

    @Generated
    public ObservableValue<String> getPasswordChoiceTranslationKey() {
        return this.passwordChoiceTranslationKey;
    }

    @Generated
    public ObservableValue<DataStoreEntryRef<ShellStore>> getFileSystem() {
        return this.fileSystem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentityChoiceBuilder)) {
            return false;
        }
        IdentityChoiceBuilder other = (IdentityChoiceBuilder)o;
        if (this.isAllowCustomUserInput() != other.isAllowCustomUserInput()) {
            return false;
        }
        if (this.isRequireUserInput() != other.isRequireUserInput()) {
            return false;
        }
        if (this.isRequirePassword() != other.isRequirePassword()) {
            return false;
        }
        if (this.isKeyInput() != other.isKeyInput()) {
            return false;
        }
        if (this.isRequireKeyInput() != other.isRequireKeyInput()) {
            return false;
        }
        if (this.isAllowAgentForward() != other.isAllowAgentForward()) {
            return false;
        }
        ObjectProperty<IdentityValue> this$identity = this.getIdentity();
        ObjectProperty<IdentityValue> other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        String this$userChoiceTranslationKey = this.getUserChoiceTranslationKey();
        String other$userChoiceTranslationKey = other.getUserChoiceTranslationKey();
        if (this$userChoiceTranslationKey == null ? other$userChoiceTranslationKey != null : !this$userChoiceTranslationKey.equals(other$userChoiceTranslationKey)) {
            return false;
        }
        ObservableValue<String> this$passwordChoiceTranslationKey = this.getPasswordChoiceTranslationKey();
        ObservableValue<String> other$passwordChoiceTranslationKey = other.getPasswordChoiceTranslationKey();
        if (this$passwordChoiceTranslationKey == null ? other$passwordChoiceTranslationKey != null : !this$passwordChoiceTranslationKey.equals(other$passwordChoiceTranslationKey)) {
            return false;
        }
        ObservableValue<DataStoreEntryRef<ShellStore>> this$fileSystem = this.getFileSystem();
        ObservableValue<DataStoreEntryRef<ShellStore>> other$fileSystem = other.getFileSystem();
        return !(this$fileSystem == null ? other$fileSystem != null : !this$fileSystem.equals(other$fileSystem));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowCustomUserInput() ? 79 : 97);
        result = result * 59 + (this.isRequireUserInput() ? 79 : 97);
        result = result * 59 + (this.isRequirePassword() ? 79 : 97);
        result = result * 59 + (this.isKeyInput() ? 79 : 97);
        result = result * 59 + (this.isRequireKeyInput() ? 79 : 97);
        result = result * 59 + (this.isAllowAgentForward() ? 79 : 97);
        ObjectProperty<IdentityValue> $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        String $userChoiceTranslationKey = this.getUserChoiceTranslationKey();
        result = result * 59 + ($userChoiceTranslationKey == null ? 43 : $userChoiceTranslationKey.hashCode());
        ObservableValue<String> $passwordChoiceTranslationKey = this.getPasswordChoiceTranslationKey();
        result = result * 59 + ($passwordChoiceTranslationKey == null ? 43 : $passwordChoiceTranslationKey.hashCode());
        ObservableValue<DataStoreEntryRef<ShellStore>> $fileSystem = this.getFileSystem();
        result = result * 59 + ($fileSystem == null ? 43 : $fileSystem.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IdentityChoiceBuilder(identity=" + String.valueOf(this.getIdentity()) + ", allowCustomUserInput=" + this.isAllowCustomUserInput() + ", requireUserInput=" + this.isRequireUserInput() + ", requirePassword=" + this.isRequirePassword() + ", keyInput=" + this.isKeyInput() + ", requireKeyInput=" + this.isRequireKeyInput() + ", allowAgentForward=" + this.isAllowAgentForward() + ", userChoiceTranslationKey=" + this.getUserChoiceTranslationKey() + ", passwordChoiceTranslationKey=" + String.valueOf(this.getPasswordChoiceTranslationKey()) + ", fileSystem=" + String.valueOf(this.getFileSystem()) + ")";
    }

    @Generated
    public IdentityChoiceBuilder(ObjectProperty<IdentityValue> identity, boolean allowCustomUserInput, boolean requireUserInput, boolean requirePassword, boolean keyInput, boolean requireKeyInput, boolean allowAgentForward, String userChoiceTranslationKey, ObservableValue<String> passwordChoiceTranslationKey, ObservableValue<DataStoreEntryRef<ShellStore>> fileSystem) {
        this.identity = identity;
        this.allowCustomUserInput = allowCustomUserInput;
        this.requireUserInput = requireUserInput;
        this.requirePassword = requirePassword;
        this.keyInput = keyInput;
        this.requireKeyInput = requireKeyInput;
        this.allowAgentForward = allowAgentForward;
        this.userChoiceTranslationKey = userChoiceTranslationKey;
        this.passwordChoiceTranslationKey = passwordChoiceTranslationKey;
        this.fileSystem = fileSystem;
    }

    @Generated
    public static class IdentityChoiceBuilderBuilder {
        @Generated
        private ObjectProperty<IdentityValue> identity;
        @Generated
        private boolean allowCustomUserInput;
        @Generated
        private boolean requireUserInput;
        @Generated
        private boolean requirePassword;
        @Generated
        private boolean keyInput;
        @Generated
        private boolean requireKeyInput;
        @Generated
        private boolean allowAgentForward;
        @Generated
        private String userChoiceTranslationKey;
        @Generated
        private ObservableValue<String> passwordChoiceTranslationKey;
        @Generated
        private ObservableValue<DataStoreEntryRef<ShellStore>> fileSystem;

        @Generated
        IdentityChoiceBuilderBuilder() {
        }

        @Generated
        public IdentityChoiceBuilderBuilder identity(ObjectProperty<IdentityValue> identity) {
            this.identity = identity;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder allowCustomUserInput(boolean allowCustomUserInput) {
            this.allowCustomUserInput = allowCustomUserInput;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder requireUserInput(boolean requireUserInput) {
            this.requireUserInput = requireUserInput;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder requirePassword(boolean requirePassword) {
            this.requirePassword = requirePassword;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder keyInput(boolean keyInput) {
            this.keyInput = keyInput;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder requireKeyInput(boolean requireKeyInput) {
            this.requireKeyInput = requireKeyInput;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder allowAgentForward(boolean allowAgentForward) {
            this.allowAgentForward = allowAgentForward;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder userChoiceTranslationKey(String userChoiceTranslationKey) {
            this.userChoiceTranslationKey = userChoiceTranslationKey;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder passwordChoiceTranslationKey(ObservableValue<String> passwordChoiceTranslationKey) {
            this.passwordChoiceTranslationKey = passwordChoiceTranslationKey;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder fileSystem(ObservableValue<DataStoreEntryRef<ShellStore>> fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        @Generated
        public IdentityChoiceBuilder build() {
            return new IdentityChoiceBuilder(this.identity, this.allowCustomUserInput, this.requireUserInput, this.requirePassword, this.keyInput, this.requireKeyInput, this.allowAgentForward, this.userChoiceTranslationKey, this.passwordChoiceTranslationKey, this.fileSystem);
        }

        @Generated
        public String toString() {
            return "IdentityChoiceBuilder.IdentityChoiceBuilderBuilder(identity=" + String.valueOf(this.identity) + ", allowCustomUserInput=" + this.allowCustomUserInput + ", requireUserInput=" + this.requireUserInput + ", requirePassword=" + this.requirePassword + ", keyInput=" + this.keyInput + ", requireKeyInput=" + this.requireKeyInput + ", allowAgentForward=" + this.allowAgentForward + ", userChoiceTranslationKey=" + this.userChoiceTranslationKey + ", passwordChoiceTranslationKey=" + String.valueOf(this.passwordChoiceTranslationKey) + ", fileSystem=" + String.valueOf(this.fileSystem) + ")";
        }
    }
}

