/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStateManager;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.control.TextField;
import lombok.Generated;

@JsonTypeName(value="gpgAgent")
@JsonDeserialize(builder=GpgAgentStrategyBuilder.class)
public final class GpgAgentStrategy
implements SshIdentityStrategy {
    private static Boolean supported;
    private final boolean forwardAgent;
    private final String publicKey;

    public static OptionsBuilder createOptions(Property<GpgAgentStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleBooleanProperty forward = new SimpleBooleanProperty(p.getValue() != null && ((GpgAgentStrategy)p.getValue()).isForwardAgent());
        SimpleStringProperty publicKey = new SimpleStringProperty(p.getValue() != null ? ((GpgAgentStrategy)p.getValue()).getPublicKey() : null);
        return new OptionsBuilder().nameAndDescription("forwardAgent").addToggle((Property)forward).nonNull().hide(!config.isAllowAgentForward()).nameAndDescription("publicKey").addComp(new TextFieldComp((Property)publicKey).apply(struc -> ((TextField)struc.get()).setPromptText("ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAIBmhLUTJiP...== Your Comment")), (Property)publicKey).bind(() -> new GpgAgentStrategy(forward.get(), publicKey.get()), new Property[]{p});
    }

    public static boolean isSupported() {
        if (supported != null) {
            return supported;
        }
        try {
            boolean found = LocalShell.getShell().view().findProgram("gpg-connect-agent").isPresent();
            if (!found) {
                supported = false;
                return supported;
            }
        }
        catch (Exception ex) {
            supported = false;
            return supported;
        }
        if (OsType.ofLocal() == OsType.WINDOWS) {
            Path file = AppSystemInfo.ofWindows().getRoamingAppData().resolve("gnupg", new String[]{"gpg-agent.conf"});
            supported = Files.exists(file, new LinkOption[0]);
            return supported;
        }
        Path file = AppSystemInfo.ofCurrent().getUserHome().resolve(".gnupg", new String[]{"gpg-agent.conf"});
        supported = Files.exists(file, new LinkOption[0]);
        return supported;
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        parent.requireLicensedFeature(LicenseProvider.get().getFeature("gpgAgent"));
        if (parent.isLocal()) {
            SshIdentityStateManager.prepareLocalGpgAgent();
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
        builder.environment("SSH_AUTH_SOCK", sc -> {
            if (sc.getOsType() == OsType.WINDOWS) {
                return null;
            }
            String r = sc.executeSimpleStringCommand("gpgconf --list-dirs agent-ssh-socket");
            return r;
        });
    }

    @Override
    public List<KeyValue> configOptions(ShellControl sc) throws Exception {
        Optional<FilePath> file = SshIdentityStrategy.getPublicKeyPath(sc, this.publicKey);
        return List.of(new KeyValue("IdentitiesOnly", file.isPresent() ? "yes" : "no"), new KeyValue("ForwardAgent", this.forwardAgent ? "yes" : "no"), new KeyValue("IdentityFile", file.isPresent() ? file.get().toString() : "none"), new KeyValue("PKCS11Provider", "none"));
    }

    @Generated
    GpgAgentStrategy(boolean forwardAgent, String publicKey) {
        this.forwardAgent = forwardAgent;
        this.publicKey = publicKey;
    }

    @Generated
    public static GpgAgentStrategyBuilder builder() {
        return new GpgAgentStrategyBuilder();
    }

    @Generated
    public boolean isForwardAgent() {
        return this.forwardAgent;
    }

    @Override
    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GpgAgentStrategy)) {
            return false;
        }
        GpgAgentStrategy other = (GpgAgentStrategy)o;
        if (this.isForwardAgent() != other.isForwardAgent()) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForwardAgent() ? 79 : 97);
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GpgAgentStrategy(forwardAgent=" + this.isForwardAgent() + ", publicKey=" + this.getPublicKey() + ")";
    }

    @JsonTypeName(value="gpgAgent")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class GpgAgentStrategyBuilder {
        @Generated
        private boolean forwardAgent;
        @Generated
        private String publicKey;

        @Generated
        GpgAgentStrategyBuilder() {
        }

        @Generated
        public GpgAgentStrategyBuilder forwardAgent(boolean forwardAgent) {
            this.forwardAgent = forwardAgent;
            return this;
        }

        @Generated
        public GpgAgentStrategyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public GpgAgentStrategy build() {
            return new GpgAgentStrategy(this.forwardAgent, this.publicKey);
        }

        @Generated
        public String toString() {
            return "GpgAgentStrategy.GpgAgentStrategyBuilder(forwardAgent=" + this.forwardAgent + ", publicKey=" + this.publicKey + ")";
        }
    }
}

