/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.InputGroupComp;
import io.xpipe.app.comp.base.TextAreaComp;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.platform.ClipboardHelper;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.OptionsChoiceBuilder;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.secret.SecretStrategyChoiceConfig;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.LocalFileTracker;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import lombok.Generated;
import org.kordamp.ikonli.javafx.FontIcon;

@JsonTypeName(value="inPlaceKey")
@JsonDeserialize(builder=InPlaceKeyStrategyBuilder.class)
public final class InPlaceKeyStrategy
implements SshIdentityStrategy {
    private final SecretValue key;
    private final String publicKey;
    private final SecretRetrievalStrategy password;

    public static OptionsBuilder createOptions(Property<InPlaceKeyStrategy> p, SshIdentityStrategyChoiceConfig config) {
        OptionsBuilder options = new OptionsBuilder();
        ObjectProperty key = options.map(p, InPlaceKeyStrategy::getKey, SecretValue::getSecretValue);
        ObjectProperty publicKey = options.map(p, InPlaceKeyStrategy::getPublicKey);
        ObjectProperty keyPasswordProperty = options.map(p, InPlaceKeyStrategy::getPassword);
        OptionsBuilder passwordChoice = OptionsChoiceBuilder.builder().allowNull(false).property((Property)keyPasswordProperty).customConfiguration((Object)SecretStrategyChoiceConfig.builder().allowNone(true).passwordKey("passphrase").build()).available(SecretRetrievalStrategy.getClasses()).build().build();
        Comp publicKeyField = new TextFieldComp((Property)publicKey).apply(struc -> {
            ((TextField)struc.get()).promptTextProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "ssh-... ABCDEF.... (" + AppI18n.get((String)"publicKeyGenerateNotice", (Object[])new Object[0]) + ")", (Observable[])new Observable[]{AppI18n.activeLanguage()}));
            ((TextField)struc.get()).setEditable(false);
        });
        Comp generateButton = new ButtonComp(null, (LabelGraphic)new LabelGraphic.IconGraphic("mdi2c-cog-refresh-outline"), () -> {
            String generated = ProcessControlProvider.get().generatePublicSshKey((SecretValue)InPlaceSecretValue.of((String)((String)key.get())), (SecretRetrievalStrategy)keyPasswordProperty.get());
            if (generated != null) {
                publicKey.set((Object)generated);
            }
        }).descriptor(d -> d.nameKey("generatePublicKey")).disable((ObservableValue)key.isNull().or((ObservableBooleanValue)publicKey.isNotNull()).or((ObservableBooleanValue)keyPasswordProperty.isNull()));
        Comp copyButton = new ButtonComp(null, (Node)new FontIcon("mdi2c-clipboard-multiple-outline"), () -> ClipboardHelper.copyText((String)((String)publicKey.get()))).disable((ObservableValue)publicKey.isNull()).descriptor(d -> d.nameKey("copyPublicKey"));
        InputGroupComp publicKeyBox = new InputGroupComp(List.of(publicKeyField, copyButton, generateButton));
        publicKeyBox.setMainReference(publicKeyField);
        return options.nameAndDescription("inPlaceKeyText").addComp(new TextAreaComp((Property)key).apply(struc -> {
            struc.getTextArea().setPromptText("-----BEGIN ... PRIVATE KEY-----\n\n\n-----END   ... PRIVATE KEY-----\n");
            struc.getTextArea().setPrefRowCount(4);
        }), (Property)key).nonNull().name("keyPassword").description("sshConfigHost.identityPassphraseDescription").sub(passwordChoice, (Property)keyPasswordProperty).nonNull().nameAndDescription("inPlacePublicKey").documentationLink(DocumentationLink.SSH_PUBLIC_KEY).addComp((Comp)publicKeyBox, (Property)publicKey).bind(() -> new InPlaceKeyStrategy((SecretValue)(key.getValue() != null ? InPlaceSecretValue.of((String)((String)key.getValue())) : null), (String)publicKey.get(), (SecretRetrievalStrategy)keyPasswordProperty.getValue()), new Property[]{p});
    }

    @Override
    public void checkComplete() throws ValidationException {
        Validators.nonNull((Object)this.key);
        Validators.nonNull((Object)this.password);
    }

    @Override
    public synchronized void prepareParent(ShellControl parent) throws Exception {
        if (this.key == null) {
            return;
        }
        FilePath file = this.getTargetFilePath(parent);
        if (parent.view().fileExists(file)) {
            return;
        }
        parent.view().touch(file);
        if (parent.getOsType() != OsType.WINDOWS) {
            parent.command(CommandBuilder.of().add(new String[]{"chmod", "600"}).addFile(file)).execute();
        }
        byte[] bytes = (this.key.getSecretValue().lines().collect(Collectors.joining("\n")) + "\n").getBytes(StandardCharsets.UTF_8);
        parent.view().writeRawFile(file, bytes);
        if (parent.getOsType() != OsType.WINDOWS) {
            parent.command(CommandBuilder.of().add(new String[]{"chmod", "400"}).addFile(file)).execute();
        }
        if (parent.isLocal()) {
            LocalFileTracker.deleteOnExit((Path)file.asLocalPath());
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
    }

    @Override
    public List<KeyValue> configOptions(ShellControl sc) {
        return List.of(new KeyValue("IdentitiesOnly", "yes"), new KeyValue("IdentityAgent", "none"), new KeyValue("IdentityFile", "\"" + String.valueOf(this.getTargetFilePath(sc)) + "\""), new KeyValue("PKCS11Provider", "none"));
    }

    @Override
    public SecretRetrievalStrategy getAskpassStrategy() {
        return this.password;
    }

    private FilePath getTargetFilePath(ShellControl sc) {
        FilePath temp = sc.getSystemTemporaryDirectory().join(new String[]{"xpipe-" + Math.abs(Objects.hash(this, AppSystemInfo.ofCurrent().getUser())) + ".key"});
        return temp;
    }

    @Generated
    public static InPlaceKeyStrategyBuilder builder() {
        return new InPlaceKeyStrategyBuilder();
    }

    @Generated
    public SecretValue getKey() {
        return this.key;
    }

    @Override
    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public SecretRetrievalStrategy getPassword() {
        return this.password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InPlaceKeyStrategy)) {
            return false;
        }
        InPlaceKeyStrategy other = (InPlaceKeyStrategy)o;
        SecretValue this$key = this.getKey();
        SecretValue other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        SecretRetrievalStrategy this$password = this.getPassword();
        SecretRetrievalStrategy other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SecretValue $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        SecretRetrievalStrategy $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InPlaceKeyStrategy(key=" + String.valueOf(this.getKey()) + ", publicKey=" + this.getPublicKey() + ", password=" + String.valueOf(this.getPassword()) + ")";
    }

    @Generated
    public InPlaceKeyStrategy(SecretValue key, String publicKey, SecretRetrievalStrategy password) {
        this.key = key;
        this.publicKey = publicKey;
        this.password = password;
    }

    @JsonTypeName(value="inPlaceKey")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class InPlaceKeyStrategyBuilder {
        @Generated
        private SecretValue key;
        @Generated
        private String publicKey;
        @Generated
        private SecretRetrievalStrategy password;

        @Generated
        InPlaceKeyStrategyBuilder() {
        }

        @Generated
        public InPlaceKeyStrategyBuilder key(SecretValue key) {
            this.key = key;
            return this;
        }

        @Generated
        public InPlaceKeyStrategyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public InPlaceKeyStrategyBuilder password(SecretRetrievalStrategy password) {
            this.password = password;
            return this;
        }

        @Generated
        public InPlaceKeyStrategy build() {
            return new InPlaceKeyStrategy(this.key, this.publicKey, this.password);
        }

        @Generated
        public String toString() {
            return "InPlaceKeyStrategy.InPlaceKeyStrategyBuilder(key=" + String.valueOf(this.key) + ", publicKey=" + this.publicKey + ", password=" + String.valueOf(this.password) + ")";
        }
    }
}

