/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.ContextualFileReferenceChoiceComp;
import io.xpipe.app.comp.base.ContextualFileReferenceSync;
import io.xpipe.app.comp.base.InputGroupComp;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.ClipboardHelper;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.OptionsChoiceBuilder;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.secret.SecretStrategyChoiceConfig;
import io.xpipe.app.storage.ContextualFileReference;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import lombok.Generated;
import org.kordamp.ikonli.javafx.FontIcon;

@JsonTypeName(value="file")
@JsonDeserialize(builder=KeyFileStrategyBuilder.class)
public final class KeyFileStrategy
implements SshIdentityStrategy {
    private final ContextualFileReference file;
    private final SecretRetrievalStrategy password;
    private final String publicKey;

    public static String getOptionsNameKey() {
        return "keyFile";
    }

    public static OptionsBuilder createOptions(Property<KeyFileStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleObjectProperty keyPath = new SimpleObjectProperty(p.getValue() != null && ((KeyFileStrategy)p.getValue()).getFile() != null ? ((KeyFileStrategy)p.getValue()).getFile().toAbsoluteFilePath(null) : null);
        p.addListener((observable, oldValue, newValue) -> {
            if (keyPath.get() != null && newValue != null && !ContextualFileReference.of((FilePath)((FilePath)keyPath.get())).equals((Object)newValue.getFile())) {
                return;
            }
            keyPath.setValue(newValue != null && newValue.getFile() != null ? newValue.getFile().toAbsoluteFilePath(null) : null);
        });
        SimpleObjectProperty keyPasswordProperty = new SimpleObjectProperty(p.getValue() != null ? ((KeyFileStrategy)p.getValue()).getPassword() : null);
        SimpleObjectProperty publicKey = new SimpleObjectProperty(p.getValue() != null ? ((KeyFileStrategy)p.getValue()).getPublicKey() : null);
        ContextualFileReferenceSync sync = ContextualFileReferenceSync.of((Path)DataStorage.get().getDataDir().resolve("keys"), file -> file.getFileName().toString(), config.getPerUserKeyFileCheck());
        OptionsBuilder passwordChoice = OptionsChoiceBuilder.builder().allowNull(false).property((Property)keyPasswordProperty).customConfiguration((Object)SecretStrategyChoiceConfig.builder().allowNone(true).passwordKey("passphrase").build()).available(SecretRetrievalStrategy.getClasses()).build().build();
        Comp publicKeyField = new TextFieldComp((Property)publicKey).apply(struc -> {
            ((TextField)struc.get()).promptTextProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "ssh-... ABCDEF.... (" + AppI18n.get((String)"publicKeyGenerateNotice", (Object[])new Object[0]) + ")", (Observable[])new Observable[]{AppI18n.activeLanguage()}));
            ((TextField)struc.get()).setEditable(false);
        });
        Comp generateButton = new ButtonComp(null, (LabelGraphic)new LabelGraphic.IconGraphic("mdi2c-cog-refresh-outline"), () -> ThreadHelper.runFailableAsync(() -> {
            Object contents;
            ShellControl sc = config.getFileSystem() != null ? ((ShellStore)((DataStoreEntryRef)config.getFileSystem().getValue()).getStore()).getOrStartSession() : LocalShell.getShell();
            FilePath path = (FilePath)keyPath.get();
            if (!sc.view().fileExists(path)) {
                return;
            }
            FilePath pubKeyPath = FilePath.of((String)(String.valueOf(path) + ".pub"));
            if (sc.view().fileExists(pubKeyPath)) {
                contents = sc.view().readTextFile(pubKeyPath).strip();
                Platform.runLater(() -> KeyFileStrategy.lambda$createOptions$6(publicKey, (String)contents));
            }
            contents = sc.view().readRawFile(path);
            String generated = ProcessControlProvider.get().generatePublicSshKey((SecretValue)InPlaceSecretValue.of((byte[])contents), (SecretRetrievalStrategy)keyPasswordProperty.get());
            if (generated != null) {
                Platform.runLater(() -> publicKey.set((Object)generated));
            }
        })).descriptor(d -> d.nameKey("generatePublicKey")).disable((ObservableValue)keyPath.isNull().or((ObservableBooleanValue)publicKey.isNotNull()).or((ObservableBooleanValue)keyPasswordProperty.isNull()));
        Comp copyButton = new ButtonComp(null, (Node)new FontIcon("mdi2c-clipboard-multiple-outline"), () -> ClipboardHelper.copyText((String)((String)publicKey.get()))).disable((ObservableValue)publicKey.isNull()).descriptor(d -> d.nameKey("copyPublicKey"));
        InputGroupComp publicKeyBox = new InputGroupComp(List.of(publicKeyField, copyButton, generateButton));
        publicKeyBox.setMainReference(publicKeyField);
        return new OptionsBuilder().name("location").description("locationDescription").addComp((Comp)new ContextualFileReferenceChoiceComp((ObservableValue)(config.getFileSystem() != null ? config.getFileSystem() : new ReadOnlyObjectWrapper((Object)DataStorage.get().local().ref())), (Property)keyPath, (ContextualFileReferenceSync)(config.isAllowKeyFileSync() ? sync : null), List.of(), e -> {
            if (config.getFileSystem() == null) {
                return e.equals((Object)DataStorage.get().local());
            }
            DataStoreEntryRef fs = (DataStoreEntryRef)config.getFileSystem().getValue();
            if (fs == null) {
                return e.equals((Object)DataStorage.get().local());
            }
            return e.equals((Object)fs.get());
        }, false), (Property)keyPath).nonNull().name("keyPassword").description("sshConfigHost.identityPassphraseDescription").sub(passwordChoice, (Property)keyPasswordProperty).nonNull().nameAndDescription("inPlacePublicKey").documentationLink(DocumentationLink.SSH_PUBLIC_KEY).addComp((Comp)publicKeyBox, (Property)publicKey).bind(() -> new KeyFileStrategy(ContextualFileReference.of((FilePath)((FilePath)keyPath.get())), (SecretRetrievalStrategy)keyPasswordProperty.get(), (String)publicKey.get()), new Property[]{p});
    }

    @Override
    public void checkComplete() throws ValidationException {
        Validators.nonNull((Object)this.file);
        Validators.nonNull((Object)this.password);
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        if (this.file == null) {
            return;
        }
        FilePath s = this.file.toAbsoluteFilePath(parent);
        if (s.startsWith("~")) {
            s = s.resolveTildeHome(parent.view().userHome());
        }
        String resolved = parent.getShellDialect().evaluateExpression(parent, s.toString()).readStdoutOrThrow();
        if (!parent.getShellDialect().createFileExistsCommand(parent, resolved).executeAndCheck()) {
            Optional<String> systemName = parent.getSourceStore().flatMap(shellStore -> DataStorage.get().getStoreEntryIfPresent(shellStore, false)).map(e -> DataStorage.get().getStoreEntryDisplayName(e));
            String msg = "Identity file " + resolved + " does not exist" + (String)(systemName.isPresent() ? " on system " + systemName.get() : "");
            throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException(msg));
        }
        if (resolved.endsWith(".ppk")) {
            IllegalArgumentException ex = new IllegalArgumentException("Identity file " + resolved + " is in non-standard PuTTY Private Key format (.ppk), which is not supported by OpenSSH. Please export/convert it to a standard format like .pem via PuTTY");
            ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)ex).expected().link("https://www.puttygen.com/convert-pem-to-ppk"));
            throw ex;
        }
        if (resolved.endsWith(".pub")) {
            throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException("Identity file " + resolved + " is marked to be a public key file, SSH authentication requires the private key"));
        }
        if (parent.getOsType() != OsType.WINDOWS) {
            parent.command(CommandBuilder.of().add(new String[]{"test", "-w"}).addFile(resolved).add(new String[]{"&&", "chmod", "600"}).addFile(resolved).add(new String[]{"||", "chmod", "400"}).addFile(resolved)).executeAndCheck();
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
    }

    @Override
    public List<KeyValue> configOptions(ShellControl sc) {
        return List.of(new KeyValue("IdentitiesOnly", "yes"), new KeyValue("IdentityAgent", "none"), new KeyValue("IdentityFile", "\"" + this.resolveFilePath(sc).toString() + "\""), new KeyValue("PKCS11Provider", "none"));
    }

    @Override
    public SecretRetrievalStrategy getAskpassStrategy() {
        return this.password;
    }

    private FilePath resolveFilePath(ShellControl sc) {
        FilePath s = this.file.toAbsoluteFilePath(sc);
        if (s.startsWith("~")) {
            s = s.resolveTildeHome(FilePath.of((Path)AppSystemInfo.ofCurrent().getUserHome()));
        }
        return s;
    }

    @Generated
    public static KeyFileStrategyBuilder builder() {
        return new KeyFileStrategyBuilder();
    }

    @Generated
    public ContextualFileReference getFile() {
        return this.file;
    }

    @Generated
    public SecretRetrievalStrategy getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyFileStrategy)) {
            return false;
        }
        KeyFileStrategy other = (KeyFileStrategy)o;
        ContextualFileReference this$file = this.getFile();
        ContextualFileReference other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        SecretRetrievalStrategy this$password = this.getPassword();
        SecretRetrievalStrategy other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContextualFileReference $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        SecretRetrievalStrategy $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyFileStrategy(file=" + String.valueOf(this.getFile()) + ", password=" + String.valueOf(this.getPassword()) + ", publicKey=" + this.getPublicKey() + ")";
    }

    @Generated
    public KeyFileStrategy(ContextualFileReference file, SecretRetrievalStrategy password, String publicKey) {
        this.file = file;
        this.password = password;
        this.publicKey = publicKey;
    }

    private static /* synthetic */ void lambda$createOptions$6(SimpleObjectProperty publicKey, String contents) {
        publicKey.set((Object)contents);
    }

    @JsonTypeName(value="file")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class KeyFileStrategyBuilder {
        @Generated
        private ContextualFileReference file;
        @Generated
        private SecretRetrievalStrategy password;
        @Generated
        private String publicKey;

        @Generated
        KeyFileStrategyBuilder() {
        }

        @Generated
        public KeyFileStrategyBuilder file(ContextualFileReference file) {
            this.file = file;
            return this;
        }

        @Generated
        public KeyFileStrategyBuilder password(SecretRetrievalStrategy password) {
            this.password = password;
            return this;
        }

        @Generated
        public KeyFileStrategyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public KeyFileStrategy build() {
            return new KeyFileStrategy(this.file, this.password, this.publicKey);
        }

        @Generated
        public String toString() {
            return "KeyFileStrategy.KeyFileStrategyBuilder(file=" + String.valueOf(this.file) + ", password=" + String.valueOf(this.password) + ", publicKey=" + this.publicKey + ")";
        }
    }
}

