# 云片网短信连接器

云片网短信服务 Logto 官方连接器

**目录**

- [云片网短信连接器](#云片网短信连接器)
  - [开始使用](#开始使用)
  - [在云片网中配置](#在云片网中配置)
    - [创建云片网账号](#创建云片网账号)
    - [获取 API KEY](#获取-api-key)
    - [配置短信模板](#配置短信模板)
  - [在 Logto 中配置](#在-logto-中配置)
  - [注意事项](#注意事项)
  - [参考](#参考)

## 开始使用

云片网是一家通信服务提供商，提供包括短信在内的多种通信服务。云片网 SMS 连接器是由 Logto 团队提供的插件，用于调用云片网的短信服务，帮助 Logto 终端用户通过短信验证码进行注册和登录。

## 在云片网中配置

### 创建云片网账号

访问[云片网官网](https://www.yunpian.com/)，注册账号并完成实名认证。

### 获取 API KEY

1. 登录云片网控制台
2. 进入"账户设置" -> "子账户管理"
3. 找到并复制 API KEY

### 配置短信模板

1. 在云片网控制台中进入"国内短信" -> "签名报备"
2. 创建签名并提交，等待运营商审核通过
3. 在云片网控制台中进入"国内短信" -> "模板报备"，选择"验证码类"
4. 创建验证码类短信模板，确保模板中包含 `#code#` 变量（也可以直接使用`常用模板`申请，加快审核速度）
5. 等待模板审核通过
6. 如果您需要发送国际短信，请重复上述步骤，选择"国际短信" -> "模板报备"并提交

## 在 Logto 中配置

1. 在 Logto 管理控制台中转到"连接器"
2. 找到并点击"云片短信服务"
3. 在配置表单中填入:
   - API KEY: 从云片网获取的 API KEY
   - 短信模板: 按照用途配置相应的模板内容，确保与云片网审核通过的模板内容一致

## 注意事项

1. 短信模板内容必须与云片网审核通过的模板完全一致
2. 短信审核模板中的验证码变量占位符为 `#code#`，模板配置中验证码变量占位符为 `{{code}}`
3. 云片网会自动根据 API KEY 添加默认签名，无需在发送模板内容中包含签名
4. 建议在正式使用前进行测试，确保配置正确

## 参考

- [云片网开发文档](https://www.yunpian.com/official/document/sms/zh_CN/introduction_brief)
- [Logto SMS 连接器指南](https://docs.logto.io/zh-CN/connectors/sms-connectors)
