import { createMockUtils } from '@logto/shared/esm';

const { mockEsmWithActual } = createMockUtils(import.meta.jest);

/** The mock id generated by all id generators. */
export const mockId = 'mockId';

/**
 * Mock all id generators to return the same {@link mockId}. List of id generators:
 *
 * - generateStandardId
 * - generateStandardShortId
 * - generateStandardSecret
 */
export const mockIdGenerators = async () =>
  mockEsmWithActual('@logto/shared', () => ({
    generateStandardId: () => mockId,
    generateStandardShortId: () => mockId,
    generateStandardSecret: () => mockId,
  }));
