const account_center = {
  header: {
    title: 'Центр аккаунта',
  },
  home: {
    title: 'Страница не найдена',
    description: 'Эта страница недоступна.',
  },
  verification: {
    title: 'Проверка безопасности',
    description:
      'Подтвердите, что это вы, чтобы защитить безопасность аккаунта. Пожалуйста, выберите способ подтверждения личности.',
    error_send_failed: 'Не удалось отправить код подтверждения. Попробуйте позже.',
    error_invalid_code: 'Код подтверждения недействителен или истёк.',
    error_verify_failed: 'Не удалось подтвердить. Введите код ещё раз.',
    verification_required: 'Срок действия проверки истёк. Подтвердите личность ещё раз.',
    try_another_method: 'Попробовать другой способ подтверждения',
  },
  password_verification: {
    title: 'Подтвердите пароль',
    description: 'Чтобы защитить аккаунт, введите пароль для подтверждения своей личности.',
    error_failed: 'Проверка не удалась. Проверьте пароль.',
  },
  verification_method: {
    password: {
      name: 'Пароль',
      description: 'Подтвердите свой пароль',
    },
    email: {
      name: 'Код подтверждения по электронной почте',
      description: 'Отправить код подтверждения на вашу почту',
    },
    phone: {
      name: 'Код подтверждения по телефону',
      description: 'Отправить код подтверждения на ваш номер телефона',
    },
  },
  email: {
    title: 'Привязать email',
    description: 'Привяжите свой email, чтобы входить или помочь с восстановлением аккаунта.',
    verification_title: 'Введите код подтверждения email',
    verification_description: 'Код подтверждения отправлен на ваш email {{email_address}}.',
    success: 'Основной email успешно привязан.',
    verification_required: 'Срок действия проверки истёк. Подтвердите личность ещё раз.',
  },
  phone: {
    title: 'Привязать номер телефона',
    description: 'Привяжите номер телефона для входа или восстановления аккаунта.',
    verification_title: 'Введите код подтверждения SMS',
    verification_description: 'Код подтверждения отправлен на ваш телефон {{phone_number}}.',
    success: 'Основной телефон успешно привязан.',
    verification_required: 'Срок действия проверки истёк. Подтвердите личность ещё раз.',
  },
  username: {
    title: 'Установить имя пользователя',
    description: 'Имя пользователя может содержать только буквы, цифры и символы подчеркивания.',
    success: 'Имя пользователя успешно обновлено.',
  },
  password: {
    title: 'Установить пароль',
    description: 'Создайте новый пароль, чтобы защитить свой аккаунт.',
    success: 'Пароль успешно обновлён.',
  },

  code_verification: {
    send: 'Отправить код подтверждения',
    resend: 'Не получили? <a>Отправить код подтверждения ещё раз</a>',
    resend_countdown: 'Не получили?<span> Повторная отправка через {{seconds}} с.</span>',
  },

  email_verification: {
    title: 'Подтвердите свою почту',
    prepare_description:
      'Подтвердите, что это вы, чтобы защитить свой аккаунт. Отправьте код подтверждения на свою почту.',
    email_label: 'Адрес электронной почты',
    send: 'Отправить код подтверждения',
    description: 'Код подтверждения отправлен на {{email}}. Введите код, чтобы продолжить.',
    resend: 'Не получили? <a>Отправить код подтверждения ещё раз</a>',
    resend_countdown: 'Не получили?<span> Повторная отправка через {{seconds}} с.</span>',
    error_send_failed: 'Не удалось отправить код подтверждения. Попробуйте позже.',
    error_verify_failed: 'Не удалось подтвердить. Введите код ещё раз.',
    error_invalid_code: 'Код подтверждения недействителен или истёк.',
  },
  phone_verification: {
    title: 'Подтвердите свой телефон',
    prepare_description:
      'Подтвердите, что это вы, чтобы защитить безопасность аккаунта. Отправьте код подтверждения на свой телефон.',
    phone_label: 'Номер телефона',
    send: 'Отправить код подтверждения',
    description:
      'Код подтверждения отправлен на ваш телефон {{phone}}. Введите код, чтобы продолжить.',
    resend: 'Не получили? <a>Отправить код подтверждения ещё раз</a>',
    resend_countdown: 'Не получили?<span> Повторная отправка через {{seconds}} с.</span>',
    error_send_failed: 'Не удалось отправить код подтверждения. Попробуйте позже.',
    error_verify_failed: 'Не удалось подтвердить. Введите код ещё раз.',
    error_invalid_code: 'Код подтверждения недействителен или истёк.',
  },
  mfa: {
    totp_already_added:
      'Вы уже добавили приложение для аутентификации. Пожалуйста, сначала удалите существующее.',
    totp_not_enabled:
      'Приложение для аутентификации не включено. Пожалуйста, свяжитесь с администратором, чтобы включить его.',
    backup_code_already_added:
      'У вас уже есть активные резервные коды. Пожалуйста, используйте или удалите их перед созданием новых.',
    backup_code_not_enabled:
      'Резервный код не включен. Пожалуйста, свяжитесь с администратором, чтобы включить его.',
    backup_code_requires_other_mfa:
      'Резервные коды требуют предварительной настройки другого метода MFA.',
    passkey_not_enabled: 'Passkey не включен. Свяжитесь с администратором, чтобы включить его.',
  },
  update_success: {
    default: {
      title: 'Обновлено!',
      description: 'Ваша информация была обновлена.',
    },
    email: {
      title: 'Электронная почта обновлена!',
      description: 'Ваш адрес электронной почты был успешно обновлен.',
    },
    phone: {
      title: 'Номер телефона обновлен!',
      description: 'Ваш номер телефона был успешно обновлен.',
    },
    username: {
      title: 'Имя пользователя изменено!',
      description: 'Ваше имя пользователя было успешно обновлено.',
    },

    password: {
      title: 'Пароль изменен!',
      description: 'Ваш пароль был успешно обновлен.',
    },
    totp: {
      title: 'Приложение для аутентификации добавлено!',
      description: 'Ваше приложение для аутентификации было успешно привязано к вашему аккаунту.',
    },
    backup_code: {
      title: 'Резервные коды созданы!',
      description: 'Ваши резервные коды сохранены. Храните их в надежном месте.',
    },
    backup_code_deleted: {
      title: 'Резервные коды удалены!',
      description: 'Ваши резервные коды были удалены из вашего аккаунта.',
    },
    passkey: {
      title: 'Passkey добавлен!',
      description: 'Ваш passkey был успешно привязан к вашему аккаунту.',
    },
    passkey_deleted: {
      title: 'Passkey удалён!',
      description: 'Ваш passkey был удалён из вашего аккаунта.',
    },
    social: {
      title: 'Социальный аккаунт привязан!',
      description: 'Ваш социальный аккаунт был успешно привязан.',
    },
  },
  backup_code: {
    title: 'Резервные коды',
    description:
      'Вы можете использовать один из этих резервных кодов для доступа к своей учетной записи, если у вас возникнут проблемы при двухэтапной проверке другими способами. Каждый код можно использовать только один раз.',
    copy_hint: 'Обязательно скопируйте их и сохраните в надежном месте.',
    generate_new_title: 'Сгенерировать новые резервные коды',
    generate_new: 'Сгенерировать новые резервные коды',
    delete_confirmation_title: 'Удалить резервные коды',
    delete_confirmation_description:
      'Если вы удалите эти резервные коды, вы не сможете использовать их для подтверждения.',
  },
  passkey: {
    title: 'Passkeys',
    added: 'Добавлен: {{date}}',
    last_used: 'Последнее использование: {{date}}',
    never_used: 'Никогда',
    unnamed: 'Безымянный passkey',
    renamed: 'Passkey успешно переименован.',
    add_another_title: 'Добавить другой passkey',
    add_another_description:
      'Зарегистрируйте свой passkey с помощью биометрии устройства, ключей безопасности (например, YubiKey) или других доступных методов.',
    add_passkey: 'Добавить passkey',
    delete_confirmation_title: 'Удалить passkey',
    delete_confirmation_description:
      'Вы уверены, что хотите удалить "{{name}}"? Вы больше не сможете использовать этот passkey для входа.',
    rename_passkey: 'Переименовать passkey',
    rename_description: 'Введите новое имя для этого passkey.',
  },
};

export default Object.freeze(account_center);
