const security = {
  page_title: 'Безопасность',
  title: 'Безопасность',
  subtitle: 'Настройте расширенную защиту от сложных атак.',
  tabs: {
    captcha: 'CAPTCHA',
    password_policy: 'Политика паролей',
    blocklist: 'Черный список',
    general: 'Общие',
  },
  bot_protection: {
    title: 'Защита от ботов',
    description:
      'Включите CAPTCHA для регистрации, входа в систему и восстановления пароля, чтобы блокировать автоматические угрозы.',
    captcha: {
      title: 'CAPTCHA',
      placeholder: 'Выберите поставщика CAPTCHA и настройте интеграцию.',
      add: 'Добавить CAPTCHA',
    },
    settings: 'Настройки',
    enable_captcha: 'Включить CAPTCHA',
    enable_captcha_description:
      'Включите проверку CAPTCHA для регистрации, входа в систему и восстановления пароля.',
  },
  create_captcha: {
    setup_captcha: 'Настройка CAPTCHA',
  },
  captcha_providers: {
    recaptcha_enterprise: {
      name: 'reCAPTCHA Enterprise',
      description:
        'Предложение CAPTCHA уровня предприятия от Google, которое обеспечивает передовое обнаружение угроз и детальную аналитику безопасности для защиты вашего сайта от мошеннических действий.',
    },
    turnstile: {
      name: 'Cloudflare Turnstile',
      description:
        'Альтернатива CAPTCHA от Cloudflare, которая обеспечивает ненавязчивую защиту от ботов, гарантируя при этом беспрепятственный пользовательский опыт без визуальных головоломок.',
    },
  },
  captcha_details: {
    back_to_security: 'Назад к безопасности',
    page_title: 'Детали CAPTCHA',
    check_readme: 'Проверить README',
    options_change_captcha: 'Изменить поставщика CAPTCHA',
    connection: 'Подключение',
    description: 'Настройте соединения с CAPTCHA.',
    site_key: 'Ключ сайта',
    secret_key: 'Секретный ключ',
    project_id: 'ID проекта',
    domain: 'Домен (необязательно)',
    domain_placeholder: 'www.google.com (по умолчанию) или recaptcha.net',
    recaptcha_key_id: 'ID ключа reCAPTCHA',
    recaptcha_api_key: 'API-ключ проекта',
    deletion_description: 'Вы уверены, что хотите удалить этого поставщика CAPTCHA?',
    captcha_deleted: 'Поставщик CAPTCHA успешно удалён',
    setup_captcha: 'Настройка CAPTCHA',
    mode: 'Режим проверки',
    mode_invisible: 'Невидимый',
    mode_checkbox: 'Флажок',
    mode_notice:
      'Режим проверки определяется в настройках ключа reCAPTCHA в Google Cloud Console. Для изменения режима здесь требуется соответствующий тип ключа.',
  },
  password_policy: {
    password_requirements: 'Требования к паролю',
    password_requirements_description:
      'Усильте требования к паролю, чтобы защититься от атак на заполнение учетных данных и атак со слабыми паролями.',
    minimum_length: 'Минимальная длина',
    minimum_length_description:
      'NIST предлагает использовать <a>не менее 8 символов</a> для веб-продуктов.',
    minimum_length_error: 'Минимальная длина должна быть от {{min}} до {{max}} (включительно).',
    minimum_required_char_types: 'Минимальное количество типов символов',
    minimum_required_char_types_description:
      'Типы символов: прописные (A-Z), строчные (a-z), цифры (0-9) и специальные символы ({{symbols}}).',
    password_rejection: 'Отклонение пароля',
    compromised_passwords: 'Отклонить скомпрометированный пароль',
    breached_passwords: 'Сломанные пароли',
    breached_passwords_description: 'Отвергнуть пароли, найденные ранее в базах данных нарушений.',
    restricted_phrases: 'Ограничение низкобезопасных фраз',
    restricted_phrases_tooltip:
      'Ваш пароль должен избегать эти фразы, если не сопровождаются еще 3 или более символами.',
    repetitive_or_sequential_characters: 'Повторяющиеся или последовательные символы',
    repetitive_or_sequential_characters_description: 'Например, "AAAA", "1234" и "abcd".',
    user_information: 'Информация пользователя',
    user_information_description:
      'Например, адрес электронной почты, номер телефона, имя пользователя и т.д.',
    custom_words: 'Пользовательские слова',
    custom_words_description:
      'Персонализируйте слова, специфичные для контекста, без учета регистра, одно на строку.',
    custom_words_placeholder: 'Имя вашей службы, название компании и т. д.',
  },
  sentinel_policy: {
    card_title: 'Блокировка идентификатора',
    card_description:
      'Блокировка доступна всем пользователям с настройками по умолчанию, но вы можете кастомизировать её для большего контроля.\n\nВременно блокируйте идентификатор после нескольких неудачных попыток аутентификации (например, последовательные неправильные пароли или коды подтверждения), чтобы предотвратить доступ методом перебора.',
    enable_sentinel_policy: {
      title: 'Настроить опыт блокировки',
      description:
        'Позволяет настроить максимальное число неудачных попыток входа до блокировки, продолжительность блокировки и возможность немедленного ручного разблокирования.',
    },
    max_attempts: {
      title: 'Максимальное количество неудачных попыток',
      description:
        'Временно заблокируйте идентификатор после достижения максимального количества неудачных попыток входа в час.',
      error_message: 'Максимальное количество неудачных попыток должно быть больше 0.',
    },
    lockout_duration: {
      title: 'Продолжительность блокировки (минуты)',
      description:
        'Блокируйте попытки входа на период после превышения максимального лимита неудачных попыток.',
      error_message: 'Продолжительность блокировки должна быть не менее 1 минуты.',
    },
    manual_unlock: {
      title: 'Ручная разблокировка',
      description:
        'Немедленно разблокируйте пользователей, подтвердив их личность и введя их идентификатор.',
      unblock_by_identifiers: 'Разблокировать по идентификатору',
      modal_description_1:
        'Идентификатор был временно заблокирован из-за нескольких неудачных попыток входа/регистрации. Для обеспечения безопасности доступ восстановится автоматически после окончания продолжительности блокировки.',
      modal_description_2:
        'Ручную разблокировку осуществляйте только в случае подтверждения личности пользователя и уверенности в отсутствии несанкционированных попыток доступа.',
      placeholder:
        'Введите идентификаторы (адрес электронной почты / номер телефона / имя пользователя)',
      confirm_button_text: 'Разблокировать сейчас',
      success_toast: 'Успешно разблокировано',
      duplicate_identifier_error: 'Идентификатор уже добавлен',
      empty_identifier_error: 'Пожалуйста, введите как минимум один идентификатор',
    },
  },
  blocklist: {
    card_title: 'Блокировочный список адресов электронной почты',
    card_description:
      'Контролируйте свою базу пользователей, блокируя адреса электронной почты с высоким риском или нежелательные адреса.',
    disposable_email: {
      title: 'Блокировать временные адреса электронной почты',
      description:
        'Включите, чтобы отклонять любые попытки регистрации с использованием временных или одноразовых адресов электронной почты, что может предотвратить спам и улучшить качество пользователей.',
    },
    email_subaddressing: {
      title: 'Блокировать субадресацию электронной почты',
      description:
        'Включить отклонение любых попыток регистрации с использованием подадресов в электронной почте с плюсом (+) и дополнительными символами (например, user+alias@foo.com).',
    },
    custom_email_address: {
      title: 'Блокировать пользовательские адреса электронной почты',
      description:
        'Добавьте конкретные домены электронной почты или адреса, которые не могут регистрироваться или связываться через пользовательский интерфейс.',
      placeholder:
        'Введите заблокированный адрес электронной почты или домен (например, bar@example.com, @example.com)',
      duplicate_error: 'Адрес электронной почты или домен уже добавлен',
      invalid_format_error:
        'Должен быть действительным адресом электронной почты (bar@example.com) или доменом (@example.com)',
    },
  },
};

export default Object.freeze(security);
