# Accessing C++ Switches In Java

[TOC]

## Introduction

Accessing C++ switches in Java is implemented via a Python script which analyzes
the C++ switches file and spits out the corresponding Java class. The generated
class name will be based upon the switch file name, and the path must be
specified in a comment within the switch file itself.

## Usage

1. Add directives to your C++ switch file

    ```cpp
    // GENERATED_JAVA_PACKAGE: org.chromium.chrome

    // ...snip...

    // Documentation for the following switch.
    const char kSomeSwitch[] = "some-switch";

    // ...snip...
    ```

2. Create a template file
   ```java
    // Copyright {YEAR} The Chromium Authors. All rights reserved.
    // Use of this source code is governed by a BSD-style license that can be
    // found in the LICENSE file.

    // This file is autogenerated by
    //     {SCRIPT_NAME}
    // From
    //     {SOURCE_PATH}, and
    //     {TEMPLATE_PATH}

    package my.java.package

    // Be sure to escape any curly braces in your template by doubling as
    // follows.
    public abstract class MySwitches {{

    {NATIVE_SWITCHES}

    }}
   ```

3. Add a new build target

    ```gn
    import("//build/config/android/rules.gni")

    java_cpp_strings("foo_generated_switch") {
      sources = [
        "//base/android/native_foo_switches.cc",
      ]
      template = "//base/android/java_templates/MySwitches.java.tmpl"
    }
    ```

5. Add the new target to the desired android_library targets srcjar_deps:

    ```gn
    android_library("base_java") {
      srcjar_deps = [
        ":foo_generated_switches",
      ]
    }
    ```

5. The generated file `org/chromium/chrome/NativeFooSwitches.java` would contain:

    ```java
    package org.chromium.chrome;

    public final class NativeFooSwitches {
        // ...snip...

        public static final String SOME_SWITCH = "some-switch";

        // ...snip...
    }
    ```

## Code
* [Generator
code](https://cs.chromium.org/chromium/src/build/android/gyp/java_cpp_strings.py?dr=C&sq=package:chromium)
and
[Tests](https://cs.chromium.org/chromium/src/build/android/gyp/java_cpp_strings_tests.py?dr=C&sq=package:chromium)
* [GN
template](https://cs.chromium.org/chromium/src/build/config/android/rules.gni?sq=package:chromium&dr=C)
