function labelssurf = initLabelssurf(handles)

labelssurf = struct(...
    'name', 'labelssurf', ...
    'pathname',filesepStandard(pwd), ...
    'handles', struct(...
        'surf',[], ...
        'hLighting',[], ...
        'radiobuttonShowLabels',[], ...
        'editTransparency',[], ...
        'menuItemSelectLabelsColormap',[], ...
        'axes',[] ... 
    ), ...
    'mesh',initMesh(),...
    'meshes',{[]},...
    'idxL',[],...
    'colormaps',[],...
    'colormapsIdx',0,...
    'names',{''},...
    'T_2vol',eye(4),...
    'iFaces',[], ...
    'center',[], ...    
    'orientation', '', ...
    'checkCompatability',[], ...
    'isempty',@isempty_loc, ...
    'prepObjForSave',[] ...
);

if exist('handles','var')
    labelssurf.handles.editTransparency = handles.editBrainTransparency;
    set(labelssurf.handles.editTransparency,'enable','off');

    labelssurf.handles.radiobuttonShowLabels = handles.radiobuttonShowLabels;
    set(labelssurf.handles.radiobuttonShowLabels,'enable','off');

    labelssurf.handles.menuItemSelectLabelsColormap = handles.menuItemSelectLabelsColormap;
    set(labelssurf.handles.menuItemSelectLabelsColormap,'enable','off');
    
    labelssurf.handles.axes = handles.axesSurfDisplay;    
end



% --------------------------------------------------------------
function b = isempty_loc(labelssurf)

b = false;
if isempty(labelssurf)
    b = true;
elseif isempty(labelssurf.mesh.vertices) | isempty(labelssurf.mesh.faces)
    b = true;
end

