function [curves, labels] = init_eeg_curves1()

% These are the 19 curves of the 10-5 system. These 19 curves are in turn
% broken down into 42 smaller curves. 
% 
% 1.  'NzCziIz'    
% 2.  'LPACzRPA'    
% 3.  'NzT9'      'T9Iz'     'NzT10'     'T10Iz'    
% 4.  'NFpzT9h'   'T9hOIz'   'NFpzT10h'  'T10hOIz'    
% 5.  'FpzT7'     'T7Oz'     'FpzT8'     'T8Oz' 
% 6.  'AFp7AFpz'  'AFp8AFpz'    
% 7.  'AF7AFz'    'AF8AFz'    
% 8.  'AFF7AFFz'  'AFF8AFFz'    
% 9.  'F7Fz'      'F8Fz'    
% 10. 'FFT7FFCz'  'FFT8FFCz'    
% 11. 'FT7FCz'    'FT8FCz'    
% 12. 'FTT7FCCz'  'FTT8FCCz'    
% 13. 'TTP7CCPz'  'TTP8CCPz'
% 14. 'TP7CPz'    'TP8CPz'    
% 15. 'TPP7CPPz'  'TPP8CPPz'    
% 16. 'P7Pz'      'P8Pz'    
% 17. 'PPO7PPOz'  'PPO8PPOz'    
% 18. 'PO7POz'    'PO8POz'    
% 19. 'POO7POOz'  'POO8POOz'
%
% 

curves = struct(...
    'Nz',init_eeg_curve({'Nz'},{[1,-1], [1,-1], [1,-1]} ), ...
    'Iz',init_eeg_curve({'Iz'},{[1,-1], [1,-1], [1,-1]} ), ...
    'RPA',init_eeg_curve({'RPA'},{[1,-1], [1,-1], [1,-1]} ), ...
    'LPA',init_eeg_curve({'LPA'},{[1,-1], [1,-1], [1,-1]} ), ...
    'Cz',init_eeg_curve({'Cz'},{[1,-1], [1,-1], [1,-1]} ), ...
    'NzCziIz',init_eeg_curve({'NFpz'; 'Fpz'; 'AFpz'; 'AFz'; 'AFFz'; 'Fz'; 'FFCz'; 'FCz'; 'FCCz'; ...
                       'dummy'; 'CCPz'; 'CPz'; 'CPPz'; 'Pz'; 'PPOz'; 'POz'; 'POOz'; 'Oz'; 'OIz'}, ...
                        {[2,4,1], [2,2,1], [1,1,0]} ), ...
    'LPACzRPA',init_eeg_curve({'T9h'; 'T7'; 'T7h'; 'C5'; 'C5h'; 'C3'; 'C3h'; 'C1'; 'C1h'; 'dummy'; ...
                        'C2h'; 'C2'; 'C4h'; 'C4'; 'C6h'; 'C6'; 'T8h'; 'T8'; 'T10h'}, ...
                        {[2,4,1], [2,2,1], [1,1,0]} ), ...
    'NzT9',init_eeg_curve({'N1h'; 'N1'; 'AFp9'; 'AF9'; 'AFF9'; 'F9'; 'FFT9'; 'FT9'; 'FTT9'}, ...
                        {[], [2,2,1], [1,1,0]} ), ...
    'T9Iz',init_eeg_curve({'TTP9'; 'TP9'; 'TPP9'; 'P9'; 'PPO9'; 'PO9'; 'POO9'; 'I1'; 'I1h'}, ...
                        {[], [2,2,1], [1,1,0]} ), ...
    'NzT10',init_eeg_curve({'N2h'; 'N2'; 'AFp10'; 'AF10'; 'AFF10'; 'F10'; 'FFT10'; 'FT10'; 'FTT10'}, ...
                        {[], [2,2,1], [1,1,0]} ), ...
    'T10Iz',init_eeg_curve({'TTP10'; 'TP10'; 'TPP10'; 'P10'; 'PPO10'; 'PO10'; 'POO10'; 'I2'; 'I2h'}, ...
                        {[], [2,2,1], [1,1,0]}), ...
    'NFpzT9h',init_eeg_curve({'NFp1h'; 'NFp1'; 'AFp9h'; 'AF9h'; 'AFF9h'; 'F9h'; 'FFT9h'; 'FT9h'; 'FTT9h'}, ...
                        {[], [], [1,1,0]}), ...
    'T9hOIz',init_eeg_curve({'TTP9h'; 'TP9h'; 'TPP9h'; 'P9h'; 'PPO9h'; 'PO9h'; 'POO9h'; 'OI1'; 'OI1h'}, ...
                        {[], [], [1,1,0]}), ...
    'NFpzT10h',init_eeg_curve({'NFp2h'; 'NFp2'; 'AFp10h'; 'AF10h'; 'AFF10h'; 'F10h'; ...
                        'FFT10h'; 'FT10h'; 'FTT10h'}, ...
                        {[], [], [1,1,0]}), ...
    'T10hOIz',init_eeg_curve({'TTP10h'; 'TP10h'; 'TPP10h'; 'P10h'; 'PPO10h'; 'PO10h'; ...
                       'POO10h'; 'OI2'; 'OI2h'}, ...
                        {[], [], [1,1,0]}), ...
    'FpzT7',init_eeg_curve({'Fp1h'; 'Fp1'; 'AFp7'; 'AF7'; 'AFF7'; 'F7'; 'FFT7'; 'FT7'; 'FTT7'}, ...
                        {[2,4,0], [2,2,1], [1,1,0]}), ...
    'T7Oz',init_eeg_curve({'TTP7'; 'TP7'; 'TPP7'; 'P7'; 'PPO7'; 'PO7'; 'POO7'; 'O1'; 'O1h'}, ...
                        {[4,8,-1], [2,2,1], [1,1,0]}), ...
    'FpzT8',init_eeg_curve({'Fp2h'; 'Fp2'; 'AFp8'; 'AF8'; 'AFF8'; 'F8'; 'FFT8'; 'FT8'; 'FTT8'}, ...
                        {[2,4,0], [2,2,1], [1,1,0]}), ...
    'T8Oz',init_eeg_curve({'TTP8'; 'TP8'; 'TPP8'; 'P8'; 'PPO8'; 'PO8'; 'POO8'; 'O2'; 'O2h'}, ...
                        {[4,8,-1], [2,2,1], [1,1,0]}), ...
    'AFp7AFpz',init_eeg_curve({'AFp5'; 'AFp3'; 'AFp1'}, ...
                        {[], [], [1,1,0]}), ...
    'AFp8AFpz',init_eeg_curve({'AFp6'; 'AFp4'; 'AFp2'}, ...
                        {[], [], [1,1,0]}), ...
    'AF7AFz',init_eeg_curve({'AF7h'; 'AF5'; 'AF5h'; 'AF3'; 'AF3h'; 'AF1'; 'AF1h'}, ...
                        {[], [4,-1], [1,1,0]}), ...
    'AF8AFz',init_eeg_curve({'AF8h'; 'AF6'; 'AF6h'; 'AF4'; 'AF4h'; 'AF2'; 'AF2h'}, ...
                        {[], [4,-1], [1,1,0]}), ...
    'AFF7AFFz',init_eeg_curve({'AFF7h'; 'AFF5'; 'AFF5h'; 'AFF3'; 'AFF3h'; 'AFF1'; 'AFF1h'}, ...
                       {[], [], [1,1,0]}), ...
    'AFF8AFFz',init_eeg_curve({'AFF8h'; 'AFF6'; 'AFF6h'; 'AFF4'; 'AFF4h'; 'AFF2'; 'AFF2h'}, ...
                       {[], [], [1,1,0]}), ...
    'F7Fz',init_eeg_curve({'F7h'; 'F5'; 'F5h'; 'F3'; 'F3h'; 'F1'; 'F1h'}, ...
                        {[4,-1], [2,2,1], [1,1,0]}), ...
    'F8Fz',init_eeg_curve({'F8h'; 'F6'; 'F6h'; 'F4'; 'F4h'; 'F2'; 'F2h'}, ...
                        {[4,-1], [2,2,1], [1,1,0]}), ...
    'FFT7FFCz',init_eeg_curve({'FFT7h'; 'FFC5'; 'FFC5h'; 'FFC3'; 'FFC3h'; 'FFC1'; 'FFC1h'}, ... 
                        {[], [], [1,1,0]}), ...
    'FFT8FFCz',init_eeg_curve({'FFT8h'; 'FFC6'; 'FFC6h'; 'FFC4'; 'FFC4h'; 'FFC2'; 'FFC2h'}, ...
                        {[], [], [1,1,0]}), ...
    'FT7FCz',init_eeg_curve({'FT7h'; 'FC5'; 'FC5h'; 'FC3'; 'FC3h'; 'FC1'; 'FC1h'}, ...
                        {[], [2,2,1], [1,1,0]}), ...
    'FT8FCz',init_eeg_curve({'FT8h'; 'FC6'; 'FC6h'; 'FC4'; 'FC4h'; 'FC2'; 'FC2h'}, ...
                        {[], [2,2,1], [1,1,0]}), ...
    'FTT7FCCz',init_eeg_curve({'FTT7h'; 'FCC5'; 'FCC5h'; 'FCC3'; 'FCC3h'; 'FCC1'; 'FCC1h'}, ...
                        {[], [], [1,1,0]}), ...
    'FTT8FCCz',init_eeg_curve({'FTT8h'; 'FCC6'; 'FCC6h'; 'FCC4'; 'FCC4h'; 'FCC2'; 'FCC2h'}, ...
                        {[], [], [1,1,0]}), ...
    'TTP7CCPz',init_eeg_curve({'TTP7h'; 'CCP5'; 'CCP5h'; 'CCP3'; 'CCP3h'; 'CCP1'; 'CCP1h'}, ...
                        {[], [], [1,1,0]}), ...
    'TTP8CCPz',init_eeg_curve({'TTP8h'; 'CCP6'; 'CCP6h'; 'CCP4'; 'CCP4h'; 'CCP2'; 'CCP2h'}, ...
                        {[], [], [1,1,0]}), ...
    'TP7CPz',init_eeg_curve({'TP7h'; 'CP5'; 'CP5h'; 'CP3'; 'CP3h'; 'CP1'; 'CP1h'}, ...
                        {[], [2,2,1], [1,1,0]}), ...
    'TP8CPz',init_eeg_curve({'TP8h'; 'CP6'; 'CP6h'; 'CP4'; 'CP4h'; 'CP2'; 'CP2h'}, ...
                        {[], [2,2,1], [1,1,0]}), ...
    'TPP7CPPz',init_eeg_curve({'TPP7h'; 'CPP5'; 'CPP5h'; 'CPP3'; 'CPP3h'; 'CPP1'; 'CPP1h'}, ...
                        {[], [], [1,1,0]}), ...
    'TPP8CPPz',init_eeg_curve({'TPP8h'; 'CPP6'; 'CPP6h'; 'CPP4'; 'CPP4h'; 'CPP2'; 'CPP2h'}, ...
                        {[], [], [1,1,0]}), ...
    'P7Pz',init_eeg_curve({'P7h'; 'P5'; 'P5h'; 'P3'; 'P3h'; 'P1'; 'P1h'}, ...
                        {[4,-1], [2,2,1], [1,1,0]}), ...
    'P8Pz',init_eeg_curve({'P8h'; 'P6'; 'P6h'; 'P4'; 'P4h'; 'P2'; 'P2h'}, ...
                        {[4,-1], [2,2,1], [1,1,0]}), ...
    'PPO7PPOz',init_eeg_curve({'PPO7h'; 'PPO5'; 'PPO5h'; 'PPO3'; 'PPO3h'; 'PPO1'; 'PPO1h'}, ...
                        {[], [], [1,1,0]}), ...
    'PPO8PPOz',init_eeg_curve({'PPO8h'; 'PPO6'; 'PPO6h'; 'PPO4'; 'PPO4h'; 'PPO2'; 'PPO2h'}, ...
                        {[], [], [1,1,0]}), ...
    'PO7POz',init_eeg_curve({'PO7h'; 'PO5'; 'PO5h'; 'PO3'; 'PO3h'; 'PO1'; 'PO1h'}, ...
                        {[], [4,-1], [1,1,0]}), ...
    'PO8POz',init_eeg_curve({'PO8h'; 'PO6'; 'PO6h'; 'PO4'; 'PO4h'; 'PO2'; 'PO2h'}, ...
                        {[], [4,-1], [1,1,0]}), ...
    'POO7POOz',init_eeg_curve({'POO5'; 'POO3'; 'POO1'}, ...
                        {[], [], [1,1,0]}), ...
    'POO8POOz',init_eeg_curve({'POO6'; 'POO4'; 'POO2'}, ...
                        {[], [], [1,1,0]}) ...
    );


