
NOTE: This documentation is a work in progress. More detailed documentation will be added in the coming months.


Introduction:
=============
SNIRF is a HDF5-based file format for storing and sharing NIRS data independently of any platform-specific file format such as Matlab. Snirf_homer3 is a standalone implementation in Matlab of a SNIRF reader/writer application that is used by the Homer3. 


Downloading snirf_homer3:
==============================
First download the snirf_homer3 package. Go online to https://github.com/fNIRS/snirf_homer3 and click the green "Clone or download" button on right. Then click "Download ZIP" right below the green button. Once you have downloaded the zip file, unzip it.


Installing snirf_homer3
==============================

1. Open Matlab and in the command window, change the current folder to the snirf_homer3 root folder that you downloaded. In the command window, type

   >> setpaths

This will set all the required matlab search paths for snirf_homer3. Note: this step should be done every time a new Matlab session is started. 

At this point you should be ready to start snirf_homer3 from the Matlab command window. 

2. Running the SNIRF demo:

Run the demos demo_snirf.m and demo_snirf_readfile.m (which should be available on the Matlab command line after running setpaths). They demonstrate how to use SnirfClass reader/writer to save, load and read SNIRF files. Make sure to run demo_snirf before demo_snirf_readfile.m since it expects the snirf files generated by demo_snirf to be present (otherwise it displays a message box stating this if it doesn't find them). The snirf_homer3 project includes sample .nirs files (DataTree/AcquiredData/Snirf/Examples) which the demo converts to .snirf files and then shows how to load them back into memory. 

3. Example 1:

	* Save .nirs file in SNIRF format

    nirs = load('neuro_run01.nirs','-mat');
    snirf1 = SnirfClass(nirs);
    snirf1.Save('neuro_run01.snirf');
    snirf1.Info();

	* Check that the file was saved correctly by looking at	snirf2 contents and comparing with snirf1 contents

    snirf2 = SnirfClass();
    snirf2.Load('neuro_run01.snirf');
    snirf2.Info();

