// Anime4K_Restore_CNN_Soft_UL
// Ported from https://github.com/bloc97/Anime4K/blob/4ba94b179a144200cb6b3052e690fe2ca5c6914c/glsl/Restore/Anime4K_Restore_CNN_Soft_UL.glsl

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME Anime4K_Restore_Soft_4
//!USE MulAdd
//!CAPABILITY FP16

#include "../StubDefs.hlsli"


//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
Texture2D OUTPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex3;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex4;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex5;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex6;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex7;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex8;

//!SAMPLER
//!FILTER POINT
SamplerState sam;


//!PASS 1
//!DESC Conv-4x3x3x3
//!IN INPUT
//!OUT tex1, tex2, tex3
//!BLOCK_SIZE 16
//!NUM_THREADS 64

void Pass1(uint2 blockStart, uint3 threadId) {
	uint2 gxy = (Rmp8x8(threadId.x) << 1) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	
    uint i, j;

	MF3 src[4][4];
	[unroll]
	for (i = 0; i <= 2; i += 2) {
		[unroll]
		for (j = 0; j <= 2; j += 2) {
			float2 tpos = (gxy + uint2(i, j)) * inputPt;
			const MF4 sr = INPUT.GatherRed(sam, tpos);
			const MF4 sg = INPUT.GatherGreen(sam, tpos);
			const MF4 sb = INPUT.GatherBlue(sam, tpos);

			// w z
			// x y
			src[i][j] = MF3(sr.w, sg.w, sb.w);
			src[i][j + 1] = MF3(sr.x, sg.x, sb.x);
			src[i + 1][j] = MF3(sr.z, sg.z, sb.z);
			src[i + 1][j + 1] = MF3(sr.y, sg.y, sb.y);
		}
	}

	[unroll]
	for (i = 1; i <= 2; ++i) {
		[unroll]
		for (j = 1; j <= 2; ++j) {
			uint2 destPos = gxy + uint2(i - 1, j - 1);

			if (i != 1 || j != 1) {
				if (destPos.x >= inputSize.x || destPos.y >= inputSize.y) {
					continue;
				}
			}

			MF4 target1 = { -0.03509807, 0.029998481, -0.08691994, -0.017055636 };
			target1 = MulAdd(src[i - 1][j - 1], MF3x4(-0.23234928, -0.070085905, 0.0040122913, 0.21575761, -0.25936925, -0.20185155, 0.022299573, 0.2812235, -0.11045535, -0.11106335, -0.12113332, -0.49919847), target1);
			target1 = MulAdd(src[i - 1][j], MF3x4(-0.48585954, -0.058959674, 0.11114158, -0.1971666, -0.24872562, 0.2667282, -0.107163996, 0.12475151, -0.027792914, -0.06700173, -0.10966316, 0.09399147), target1);
			target1 = MulAdd(src[i - 1][j + 1], MF3x4(-0.16666615, -0.15644506, 0.048309084, 0.19122206, -0.1522582, 0.15417537, -0.23017146, 0.09460856, 0.074704535, 0.2168164, 0.2077189, -0.29264635), target1);
			target1 = MulAdd(src[i][j - 1], MF3x4(0.3167284, -0.20522436, -0.050071932, -0.036290437, 0.20206359, 0.012589764, -0.1251284, -0.2911492, -0.0006390347, -0.09853893, 0.14406726, 0.33612582), target1);
			target1 = MulAdd(src[i][j], MF3x4(0.13786903, 0.51342535, -0.44004235, -0.23918492, 0.5614157, 0.011565876, 0.5419984, -0.15937872, -0.075360805, 0.018496322, 0.12582661, 0.40117717), target1);
			target1 = MulAdd(src[i][j + 1], MF3x4(0.19644158, 0.12697817, 0.15092115, 0.1963961, -0.03395398, -0.17465135, -0.04086773, 0.09187623, 0.18238129, -0.0063141263, -0.26402372, -0.28761682), target1);
			target1 = MulAdd(src[i + 1][j - 1], MF3x4(-0.010849395, 0.15082607, 0.095264904, -0.038952388, -0.1121466, 0.21590506, 0.029462064, -0.65400773, 0.18295552, 0.2425088, 0.121624336, 0.7189011), target1);
			target1 = MulAdd(src[i + 1][j], MF3x4(0.17197245, -0.04397748, 0.18232836, -0.04471754, 0.071163684, -0.20590816, 0.39706057, -0.5452873, -0.11754515, 0.006909551, 0.018450081, 0.5686299), target1);
			target1 = MulAdd(src[i + 1][j + 1], MF3x4(0.077441245, -0.25645187, -0.19979256, -0.010363122, -0.04312338, -0.08810754, -0.059999906, 0.38630447, -0.11017497, -0.16309647, 0.026156282, -0.35432625), target1);

			MF4 target2 = { 0.6537504, 0.07195351, -0.38729003, -0.0374416 };
			target2 = MulAdd(src[i - 1][j - 1], MF3x4(-0.34123975, 0.06927292, 0.12252625, 0.1038146, 0.15979475, 0.24436772, -0.016088272, -0.22664197, 0.16932374, 0.10719134, -0.16895153, 0.100098394), target2);
			target2 = MulAdd(src[i - 1][j], MF3x4(0.11094869, -0.1379463, -0.53625333, -0.42690855, 0.12101115, -0.004709155, 0.6293494, 0.4763549, 0.030926082, -0.20099613, 0.39174548, 0.31219363), target2);
			target2 = MulAdd(src[i - 1][j + 1], MF3x4(0.08731028, -0.010540878, 0.0757335, -0.1466203, -0.23115048, -0.17813745, 0.17698573, 0.18787299, 0.16219892, 0.10475756, -0.23984352, 0.025724094), target2);
			target2 = MulAdd(src[i][j - 1], MF3x4(0.27665043, 0.4118298, -0.08762915, -0.07885308, 0.05053698, 0.28148478, -0.005842398, 0.15139125, -0.3791668, 0.24871133, 0.18160823, -0.10384939), target2);
			target2 = MulAdd(src[i][j], MF3x4(-0.3206045, -0.22038852, -0.3038138, -0.0482595, -0.26852164, -0.23278148, 0.30639926, 0.2578657, -0.3874695, 0.06441954, 0.00026220892, 0.04361178), target2);
			target2 = MulAdd(src[i][j + 1], MF3x4(-0.17908047, -0.0900835, 0.00652168, -0.038639892, 0.1520494, -0.13204975, -0.020355739, 0.26766944, 0.021308672, -0.31918222, 0.050667368, 0.10367864), target2);
			target2 = MulAdd(src[i + 1][j - 1], MF3x4(-0.112388864, 0.053321466, 0.2691917, 0.26902813, 0.010105532, 0.24898581, -0.13757521, -0.10214595, 0.23615286, -0.09560994, -0.15046176, -0.08853913), target2);
			target2 = MulAdd(src[i + 1][j], MF3x4(-0.36796987, -0.2124952, -0.07535088, 0.13065732, -0.21852261, 0.06934692, -0.013749303, -0.44900006, 0.3352218, 0.090437174, 0.08993535, -0.3050165), target2);
			target2 = MulAdd(src[i + 1][j + 1], MF3x4(0.11873657, 0.13483031, 0.22352207, 0.23666611, 0.18977334, -0.32066482, -0.31396368, -0.5615055, -0.14588253, 0.0121516865, 0.0614425, -0.079611346), target2);

			MF4 target3 = { -0.04453386, 0.06632044, 0.061607827, -0.19856223 };
            target3 = MulAdd(src[i - 1][j - 1], MF3x4(0.16112354, 0.3756035, 0.09619928, 0.17283864, 0.054338567, -0.061197184, -0.10173672, -0.032733057, -0.111913994, -0.28940153, -0.062114924, 0.20520677), target3);
			target3 = MulAdd(src[i - 1][j], MF3x4(0.3500745, 0.467141, -0.101748556, 0.43384346, 0.06712478, -0.43235737, 0.014446082, -0.12634972, -0.07507498, 0.025314584, 0.22664048, 0.22121347), target3);
			target3 = MulAdd(src[i - 1][j + 1], MF3x4(-0.089320965, 0.319314, -0.06869195, -0.2465581, 0.449762, -0.38919032, 0.1562217, 0.05368933, 0.20758076, 0.0659555, -0.109858744, -0.114917934), target3);
			target3 = MulAdd(src[i][j - 1], MF3x4(-0.07451217, 0.2239877, -0.009071173, 0.21869898, 0.042301223, 0.13635477, -0.20052543, 0.26130545, -0.051627826, -0.3429969, 0.093028575, -0.35710186), target3);
			target3 = MulAdd(src[i][j], MF3x4(-0.16129561, -0.31247056, -0.123016216, 0.2122524, -0.2972285, 0.2718142, -0.17284301, 0.44368207, -0.032497104, 0.18240568, -0.28283152, -0.10045272), target3);
			target3 = MulAdd(src[i][j + 1], MF3x4(0.15945031, -0.6797371, 0.3974546, 0.24741851, -0.1340806, 0.41666976, 0.27850744, -0.21406768, 0.096567124, 0.23366652, 0.15648519, -0.07626781), target3);
			target3 = MulAdd(src[i + 1][j - 1], MF3x4(-0.053246673, 0.14282355, -0.114118166, -0.3172004, -0.18055372, -0.3400759, -0.19622837, 0.076828666, 0.29225305, 0.14866155, 0.07959014, -0.041400358), target3);
			target3 = MulAdd(src[i + 1][j], MF3x4(-0.25331625, -0.14193451, 0.04879846, -0.077393495, 0.0104558095, 0.37905747, -0.07880302, -0.09453499, -0.1426901, -0.19738746, -0.28036812, 0.03675319), target3);
			target3 = MulAdd(src[i + 1][j + 1], MF3x4(-0.08954212, -0.47161737, -0.12388452, -0.08005436, 0.04682568, 0.048485547, 0.31411946, -0.31375095, -0.22892538, 0.16906887, 0.16802602, 0.18711087), target3);

			tex1[destPos] = target1;
			tex2[destPos] = target2;
            tex3[destPos] = target3;
		}
	}
}

//!PASS 2
//!DESC Conv-4x3x3x24
//!IN tex1, tex2, tex3
//!OUT tex4, tex5, tex6
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass2(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = tex1.SampleLevel(sam, pos, 0);
	MF4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = tex2.SampleLevel(sam, pos, 0);
	MF4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    MF4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = tex3.SampleLevel(sam, pos, 0);
	MF4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target1 = { -0.17880301, 0.20980668, -0.013683405, -0.015587634 };
	target1 = MulAdd(a1, MF4x4(-0.09962672, -0.09808486, 0.14167309, 0.050132442, 0.10861549, -0.03472704, -0.13705672, -0.029933043, 0.09841877, 0.07278074, -0.017292077, -0.027848938, 0.07552298, 0.076578915, -0.023463586, 0.052939452), target1);
	target1 = MulAdd(b1, MF4x4(0.0010984733, -0.17330085, -0.08229318, -0.2175911, 0.08144593, 0.059445348, -0.15086831, -0.10372944, 0.117648594, -0.12558225, -0.11103407, -0.0701386, -0.05065664, -0.07396901, -0.11938091, 0.039866682), target1);
	target1 = MulAdd(c1, MF4x4(0.15428792, 0.23440446, 0.21962269, 0.2650896, -0.03476033, 0.15719226, -0.12486064, 0.2167058, -0.023046771, -0.20562397, 0.10107006, -0.01569021, 0.16730824, -0.01259593, 0.053364236, -0.04500823), target1);
	target1 = MulAdd(d1, MF4x4(0.030429626, -0.13110232, 0.057990804, 0.011675255, -0.05295247, -0.15326303, 0.22707884, -0.07973966, 0.0439027, -0.13198115, 0.07837125, -0.07131822, 0.05269012, -0.2104038, 0.048907652, -0.020645073), target1);
	target1 = MulAdd(e1, MF4x4(0.0031781355, -0.021097122, -0.26952672, -0.3207644, 0.08375256, -0.14136748, 0.18542029, 0.15215854, 0.091964215, 0.26967737, 0.0587766, -0.07700872, 0.16575423, 0.35469708, -0.0051588053, -0.0006740279), target1);
	target1 = MulAdd(f1, MF4x4(-0.08884001, 0.14041351, 0.17474355, 0.4161406, 0.023943432, 0.003970282, 0.29985484, 0.10266973, -0.25273883, -0.14029191, 0.11345857, 0.31820163, -0.38953283, 0.2583901, 0.009964725, 0.058217626), target1);
	target1 = MulAdd(g1, MF4x4(-0.2032424, -0.07082582, 0.1580928, -0.048965808, 0.2141858, -0.041104354, -0.034682848, -0.15914723, 0.04790725, -0.024282899, 0.07099358, 0.16498338, -0.112657525, -0.0616071, -0.008030092, -0.016227499), target1);
	target1 = MulAdd(h1, MF4x4(0.061936792, 0.21455337, 0.48054412, -0.04828425, 0.010028972, 0.11099989, 0.095458575, -0.19660684, 0.0425463, 0.11828354, -0.124904655, -0.17428195, 0.011525431, -0.124187276, -0.04230918, -0.035113487), target1);
	target1 = MulAdd(i1, MF4x4(0.31514692, 0.08103313, 0.11659174, 0.08965401, -0.1970772, 0.14856051, -0.1938787, -0.16033082, -0.18799798, 0.030507786, -0.16664562, -0.13656873, 0.17780142, -0.25997472, 0.026064966, 0.011898), target1);
	target1 = MulAdd(a2, MF4x4(-0.057235047, -0.27046695, -0.010699785, 0.049249526, 0.047039963, -0.077151395, -0.14362605, 0.06164646, 0.114476524, -0.17911421, -0.08053587, 0.11165565, -0.09624257, 0.025738657, -0.103865884, -0.03431851), target1);
	target1 = MulAdd(b2, MF4x4(0.14757289, -0.011688203, 0.13329901, -0.117047496, 0.0012821602, 0.1926134, -0.20751058, -0.07072285, 0.010413468, 0.056632243, 0.115734495, -0.02967846, -0.03047392, -0.21189988, -0.0011950757, -0.19957498), target1);
	target1 = MulAdd(c2, MF4x4(-0.08746177, -0.12079578, 0.04276918, -0.005454131, 0.11490783, -0.12847133, -0.09437031, -0.30269814, -0.21966903, -0.19212759, 0.02010421, -0.041956432, 0.10274604, -0.29135153, -0.05896102, -0.23609753), target1);
	target1 = MulAdd(d2, MF4x4(0.041169632, -0.1239918, 0.11654365, 0.12085256, -0.16491309, 0.16958053, 0.08106695, 0.017548209, 0.005812545, 0.18601535, -0.26115587, 0.06350569, -0.05120703, 0.288068, -0.10665016, 0.14517978), target1);
	target1 = MulAdd(e2, MF4x4(-0.031448353, 0.10505269, -0.11342215, 0.066149935, -0.11060372, 0.023158634, 0.112362646, -0.12653005, 0.10593459, 0.16429284, 0.105653964, 0.057039205, 0.43216446, 0.40089405, -0.13454677, 0.10088736), target1);
	target1 = MulAdd(f2, MF4x4(0.006024284, -0.085603446, -0.03500259, -0.12583484, 0.037410516, -0.162403, -0.16079305, -0.40704638, -0.02878602, -0.05373755, 0.22466864, -0.18264142, 0.006703932, -0.2611284, 0.12246666, -0.09028182), target1);
	target1 = MulAdd(g2, MF4x4(-0.060709704, -0.10833455, 0.057897534, 0.13747421, 0.023012483, 0.037656587, 0.14315368, -0.016442677, 0.047911663, -0.0069572264, 0.044352237, 0.3486672, -0.21061146, 0.09642802, 0.05590367, -0.060553044), target1);
	target1 = MulAdd(h2, MF4x4(0.04283378, 0.24103515, -0.13148557, 0.010205976, -0.043310534, 0.10729743, 0.038866118, 0.18446185, -0.01657694, 0.1901015, 0.07020068, 0.12353552, 0.038972974, 0.23214848, -0.25911716, -0.019023877), target1);
	target1 = MulAdd(i2, MF4x4(0.12810664, 0.2588679, -0.01086673, -0.028045006, 0.19610372, -0.096308656, 0.0042522033, 0.13961965, 0.11584688, 0.04171374, -0.22028726, -0.24815048, 0.18253902, -0.2803496, 0.04638075, 0.036636963), target1);
	target1 = MulAdd(a3, MF4x4(-0.063880704, -0.1977201, -0.053342164, -0.066917926, -0.11009935, 0.17052847, 0.04694616, 0.07041865, 0.0104053635, 0.17147705, 0.14641339, 0.02914492, 0.02223927, -0.15581869, 0.0073570404, -0.092718706), target1);
	target1 = MulAdd(b3, MF4x4(-0.11074706, 0.09035497, 0.041304804, -0.05657743, 0.02258131, 0.15751973, -0.08892718, 0.09498991, -0.062650494, 0.1528085, 0.08637203, 0.015458079, 0.080385685, 0.0014520894, -0.1777884, -0.022080136), target1);
	target1 = MulAdd(c3, MF4x4(-0.12261772, 0.14604463, -0.30844545, -0.038277622, -0.03465457, -0.14419939, 0.08843366, -0.24528691, 0.08627054, 0.022934042, 0.065465, 0.08992177, 0.13908626, 0.29170883, 0.18499602, 0.44779378), target1);
	target1 = MulAdd(d3, MF4x4(0.2403803, -0.034265775, 0.061548065, -0.2871231, 0.06244344, 0.55960923, 0.10674182, -0.099105835, 0.067223154, -0.016005594, -0.18609367, 0.068283536, 0.16862819, -0.35648894, 0.15355636, -0.21434662), target1);
	target1 = MulAdd(e3, MF4x4(-0.1928663, -0.08712358, 0.010059887, 0.041675188, 0.028285503, 0.27573827, -0.13980475, 0.020420022, 0.08173396, -0.18047802, 0.14453442, 0.1705434, 0.032467145, -0.25624174, -0.091417946, -0.1830734), target1);
	target1 = MulAdd(f3, MF4x4(-0.07378673, 0.0082734935, -0.0031403562, -0.09405621, -0.04572997, -0.47891915, 0.022257643, -0.18141934, -0.15467338, -0.080856316, 0.22424543, 0.1328784, -0.011105831, 0.012753231, -0.18666203, 0.29024994), target1);
	target1 = MulAdd(g3, MF4x4(-0.014239724, 0.17424577, 0.04347437, -0.07241822, -0.0043192226, -0.15224636, -0.12850569, -0.07176244, -0.024936391, 0.1081912, -0.0634437, -0.17714879, 0.06807449, 0.036505345, 0.1765435, -0.06827722), target1);
	target1 = MulAdd(h3, MF4x4(-0.10896065, -0.113828, -0.044186924, 0.083636716, 0.00946172, -0.096768014, 0.1477472, 0.28581375, 0.09928998, -0.03573682, -0.0877059, -0.07456346, -0.094931394, -0.29481927, 0.035076067, -0.030719504), target1);
	target1 = MulAdd(i3, MF4x4(0.06879136, -0.0013524323, -0.015930668, 0.011338774, 0.27078402, -0.036486305, 0.07307458, -0.03654178, -0.1821915, -0.19957519, 0.047258675, -0.012780178, -0.23570615, 0.23241185, -0.049822707, -0.004932543), target1);
	target1 = MulAdd(na1, MF4x4(0.059442203, 0.123758584, -0.0120902015, -0.035207815, -0.3852069, 0.02184997, 0.17941254, -0.060605425, -0.071601346, -0.07984123, -0.043631997, 0.050046816, 0.100848526, -0.1991431, 0.012486262, -0.12679099), target1);
	target1 = MulAdd(nb1, MF4x4(-0.10241958, 0.14548102, 0.17390133, 0.11916023, -0.124270104, -0.016538827, 0.14511214, -0.11671281, -0.21087177, -0.06974753, 0.012906925, 0.13859452, -0.08547768, 0.1567956, -0.2022433, 0.038497575), target1);
	target1 = MulAdd(nc1, MF4x4(0.07510719, -0.12558976, 0.27779973, 0.07905847, -0.005560809, -0.13164681, 0.0026637863, -0.42023313, 0.30791378, 0.0674288, 0.16762452, 0.03776929, 0.054378655, 0.12892224, 0.14568421, 0.057358757), target1);
	target1 = MulAdd(nd1, MF4x4(-0.055342264, 0.17539698, -0.07691367, -0.016426053, -0.10654331, 0.12799862, 0.08000128, -0.026672266, -0.09276648, 0.08326771, -0.07549073, 0.09110558, 0.025476933, 0.23758717, -0.08576679, 0.05389538), target1);
	target1 = MulAdd(ne1, MF4x4(0.13494995, -0.058528826, 0.0859778, 0.36369404, 0.20959967, 0.04463818, -0.10268673, -0.17128421, 0.12091434, -0.23517689, -0.006012021, -0.13097133, 0.07197561, -0.16344362, 0.10873641, 0.08921942), target1);
	target1 = MulAdd(nf1, MF4x4(0.021762112, -0.003690478, 0.36574113, 0.008322902, 0.19321395, 0.04774496, -0.22579306, -0.19404013, 0.06938985, 0.15104407, -0.046889, -0.117904656, -0.14408903, -0.18670367, 0.16157444, -0.103656925), target1);
	target1 = MulAdd(ng1, MF4x4(0.10242334, -0.055725146, -0.21333602, 0.010575543, -0.23961566, 0.0044566356, 0.39897293, 0.08584577, -0.23019423, 0.2032861, -0.18542935, -0.1764838, -0.13681203, -0.07769402, 0.03816189, 0.007777049), target1);
	target1 = MulAdd(nh1, MF4x4(-0.028709, -0.16470426, -0.212036, 0.03143696, 0.27199176, -0.17678891, 0.23327425, 0.12954381, -0.020772377, -0.17467533, 0.13100848, 0.2351719, 0.097517245, 0.050158583, -0.002071869, 0.04241593), target1);
	target1 = MulAdd(ni1, MF4x4(0.07411962, -0.08748965, 0.07468962, -0.22070734, 0.40794817, -0.088459395, 0.32936516, -0.032707095, 0.37608266, 0.027920008, 0.07734025, 0.08530036, 0.10898109, 0.22703189, -0.20785971, -0.06495064), target1);
	target1 = MulAdd(na2, MF4x4(0.29293463, 0.16721301, -0.12183638, -0.03948546, 0.01529436, 0.078094184, -0.025749328, -0.006153496, -0.094414495, 0.22237025, 0.028131692, -0.060007866, 0.034187492, -0.116286926, 0.06509088, -0.048549082), target1);
	target1 = MulAdd(nb2, MF4x4(0.008423889, -0.3957667, -0.049811136, 0.14082848, 0.09263845, -0.16698493, -0.025629787, 0.015054379, 0.028197043, 0.068465285, -0.08725762, 0.036668878, -0.062005505, 0.0764588, -0.054699335, -0.003840703), target1);
	target1 = MulAdd(nc2, MF4x4(0.043419074, -0.20948833, -0.14390363, -0.17659377, -0.065787576, 0.06486438, -0.19382884, 0.08338218, 0.13709012, 0.21116447, -0.24534407, 0.20671941, -0.13327736, 0.2553412, -0.03380571, 0.2106275), target1);
	target1 = MulAdd(nd2, MF4x4(0.32056695, -0.28739846, -0.008697179, -0.3094155, -0.12655911, -0.22508456, 0.046275456, -0.13609526, -0.056746602, -0.13714787, 0.006273007, -0.15033242, 0.19861896, -0.19801322, 0.008556289, 0.053491425), target1);
	target1 = MulAdd(ne2, MF4x4(0.018890936, -0.7917244, -0.014075563, -0.1700778, -0.039983913, 0.028458029, -0.1522347, -0.08251537, -0.013377933, -0.3029727, 0.1349085, -0.16240561, -0.20748827, -0.46068287, 0.00913134, 0.030452987), target1);
	target1 = MulAdd(nf2, MF4x4(-0.05005734, -0.2148053, 0.032070015, 0.14438215, 0.31232053, 0.1401732, -0.26635718, 0.19424468, 0.07584618, 0.10555894, 0.01795741, 0.31067818, 0.054555204, 0.2563484, -0.14635237, -0.10759128), target1);
	target1 = MulAdd(ng2, MF4x4(0.23083898, -0.32226348, 0.19888338, -0.38176686, 0.050134797, -0.0015203251, 0.112237535, 0.14811106, 0.2174096, -0.24344379, -0.13310412, -0.42385107, 0.050850198, -0.27200532, -0.052719057, 0.009228699), target1);
	target1 = MulAdd(nh2, MF4x4(-0.053870313, -0.47212356, 0.085255414, -0.014404558, -0.06817252, -0.0973503, 0.1635136, -0.0033316084, -0.037195005, -0.48788953, 0.08273281, -0.097501226, 0.0600793, -0.21372889, 0.03384461, 0.017936382), target1);
	target1 = MulAdd(ni2, MF4x4(-0.3313351, -0.45776972, 0.0009931794, 0.11343333, 0.033024788, 0.046712194, 0.04782013, 0.064249486, -0.22282073, 0.12655938, 0.19051406, 0.31040603, -0.07731221, 0.17658137, -0.103276245, -0.06792484), target1);
	target1 = MulAdd(na3, MF4x4(0.14607549, 0.1872639, -0.093263544, 0.09774117, -0.11698756, -0.067545414, 0.0023156274, -0.18209848, 0.03853313, -0.2223309, 0.12031081, 0.042545635, -0.034479424, 0.124472, 0.06731187, 0.12712644), target1);
	target1 = MulAdd(nb3, MF4x4(-0.07627082, -0.17452952, -0.33548403, -0.18450926, 0.18033943, -0.12326704, 0.019632008, 0.07248642, -0.16483006, -0.18913946, 0.19646043, 0.40187582, -0.13083674, 0.08671764, 0.15356278, 0.0077914116), target1);
	target1 = MulAdd(nc3, MF4x4(-0.13629752, -0.13993968, 0.2731425, -0.041057866, -0.118738905, 0.21209033, -0.051054828, 0.31168184, -0.16392295, 0.010364939, 0.0857728, 0.024030814, -0.07311749, -0.24349305, -0.20305401, -0.43344042), target1);
	target1 = MulAdd(nd3, MF4x4(0.14196202, -0.04678858, 0.0077786436, 0.072588876, 0.048406214, -0.812405, 0.08031392, -0.1540258, 0.11032359, -0.06004812, -0.32815942, 0.09877014, -0.16591738, 0.4435054, -0.20656855, 0.22537513), target1);
	target1 = MulAdd(ne3, MF4x4(0.09432511, 0.19597436, -0.08628448, -0.21871169, -0.16537306, -0.32272846, 0.13009092, 0.010715842, 0.26118267, 0.22872354, 0.19176646, 0.107038476, 0.1611875, 0.08846044, 0.15163514, 0.008047941), target1);
	target1 = MulAdd(nf3, MF4x4(-0.07396799, -0.03825365, 0.093083926, 0.051318448, 0.2838576, 0.5694332, -0.10403076, 0.19238624, 0.11968883, 0.11856581, -0.119746156, -0.082536116, 0.076429665, -0.02471431, 0.11962365, -0.17637646), target1);
	target1 = MulAdd(ng3, MF4x4(0.07824961, -0.16634372, 0.027028812, -0.074860476, -0.14161688, 0.23795755, 0.02944209, 0.17723913, -0.30600172, -0.23468062, -0.12452985, -0.020646518, -0.0397737, 0.021050548, -0.17934813, 0.13230623), target1);
	target1 = MulAdd(nh3, MF4x4(0.0424831, 0.106492884, -0.03483414, -0.017710585, 0.22700353, 0.20349082, -0.10986577, -0.3389828, -0.21730238, -0.00039746048, 0.07059067, 0.102562755, 0.30204043, 0.21475948, -0.0162173, -0.017118886), target1);
	target1 = MulAdd(ni3, MF4x4(-0.22430925, -0.014225937, 0.094149694, -0.018336432, 0.17596604, 0.14860786, 0.05728594, 0.04178837, 0.1751472, 0.23511195, 0.020594316, 0.11539313, 0.12581828, -0.15684246, 0.02905791, -0.11784082), target1);
	
	MF4 target2 = { 0.07964101, -0.050712653, 0.11978818, 0.122745104 };
	target2 = MulAdd(a1, MF4x4(-0.02899521, -0.05649066, -0.026947228, 0.048783254, -0.14916636, 0.24028979, 0.044600923, -0.045931537, -0.1705095, -0.27147427, 0.16703783, 0.058726057, 0.0032612043, 0.083603844, -0.25704128, 0.13329254), target2);
	target2 = MulAdd(b1, MF4x4(-0.1979236, -0.01025661, -0.019716073, 0.108358726, 0.043820046, 0.1919281, -0.21771714, -0.1133059, -0.061171446, -0.0882054, -0.120655626, -0.11155759, -0.07786948, 0.011810883, 0.14344923, -0.26561305), target2);
	target2 = MulAdd(c1, MF4x4(0.1894701, 0.0239954, -0.119104624, 0.0081936605, -0.090172075, 0.16750605, 0.07118662, -0.068179235, 0.11522273, 0.02271562, 0.09519474, -0.28372973, 0.0015472358, 0.026579062, 0.117233984, -0.4856576), target2);
	target2 = MulAdd(d1, MF4x4(-0.14819643, -0.31534502, -0.13870765, -0.01054195, -0.19450842, 0.10115552, 0.15510698, 0.003614742, -0.07340832, -0.20358734, -0.12068221, 0.1708203, -0.04059514, 0.05221531, 0.1185381, 0.0068877796), target2);
	target2 = MulAdd(e1, MF4x4(-0.2649358, 0.2787165, 0.026068278, 0.05054382, 0.042817205, -0.13016234, 0.0052052587, 0.0671692, 0.10290017, 0.06727616, -0.025898565, -0.03125075, 0.1502351, -0.17578806, -0.07915442, -0.20580369), target2);
	target2 = MulAdd(f1, MF4x4(0.01980342, 0.07163837, -0.10456945, 0.06892928, -0.00022086082, -0.122014746, -0.11635255, -0.050526325, 0.11869723, 0.07118713, 0.10652823, -0.21519308, -0.048316743, -0.09710376, 0.006049279, -0.15725243), target2);
	target2 = MulAdd(g1, MF4x4(0.17198269, -0.04094963, -0.16597614, -0.022672966, -0.021484226, -0.07138965, 0.067678355, 0.010858899, -0.13862544, 0.06384301, -0.03991444, 0.22539167, -0.005830964, -0.093598455, 0.10466667, 0.19629909), target2);
	target2 = MulAdd(h1, MF4x4(0.040208396, -0.0077782017, 0.026934639, -0.08231454, 0.122154236, -0.20185019, -0.04921797, 0.113472804, 0.025262907, 0.30940935, -0.0067619407, 0.011076865, -0.037738938, 0.22040449, -0.091454595, 0.08720387), target2);
	target2 = MulAdd(i1, MF4x4(-0.19777842, 0.15188776, -0.112971924, 0.06551624, 0.21511264, -0.12696353, 0.05734954, 0.038562097, 0.09721514, 0.12184754, 0.098125674, 0.093547106, 0.04148773, -0.007749207, -0.097304046, 0.11741999), target2);
	target2 = MulAdd(a2, MF4x4(-0.05388486, -0.15493694, -0.11779907, -0.063636035, 0.1683663, -0.19863462, 0.079785384, 0.002344284, 0.07419801, -0.18906172, 0.042702213, -0.106039785, -0.11761329, -0.34240028, 0.20399906, 0.19486815), target2);
	target2 = MulAdd(b2, MF4x4(-0.0214746, 0.024925156, 0.071194954, 0.06452649, -0.10890589, -0.08571906, 0.13291912, -0.0013396982, 0.01863436, -0.20824501, 0.054323934, -0.23967488, 0.07283552, -0.28291726, 0.23057762, 0.121263705), target2);
	target2 = MulAdd(c2, MF4x4(0.05597139, 0.07066334, 0.06768875, 0.01599472, -0.00039986568, -0.0053987154, 0.040123407, -0.100022465, -0.013812261, 0.050008554, 0.18786328, 0.0004141, 0.09763033, -0.2487105, 0.11663139, 0.05165497), target2);
	target2 = MulAdd(d2, MF4x4(0.17904039, -0.31834564, -0.0737966, -0.061444905, -0.2252082, 0.00895136, 0.11486605, -0.0037112157, -0.07636511, -0.3503888, -0.04990528, -0.030310752, 0.068686, -0.3136087, -0.004038447, 0.12475536), target2);
	target2 = MulAdd(e2, MF4x4(0.011218902, 0.16498409, -0.19213067, -0.3376179, -0.40268928, 0.009434513, -0.10950616, 0.1186675, -0.11379568, 0.23032996, -0.26904815, 0.30311096, 0.017041026, 0.39546305, -0.2145057, 0.20220405), target2);
	target2 = MulAdd(f2, MF4x4(-0.116564326, 0.16520524, 0.25099444, -0.044852093, 0.04109138, -0.104986876, 0.09234278, -0.077715285, 0.046688464, 0.4072821, 0.021245886, -0.054421954, -0.12993707, 0.13713494, -0.12306372, 0.0076773493), target2);
	target2 = MulAdd(g2, MF4x4(0.0022927783, -0.16100088, 0.0092022745, 0.043600008, -0.012064794, 0.14346212, 0.056605842, 0.04922658, 0.21234164, -0.36939904, -0.35937238, -0.0076974165, -0.033846013, -0.197686, 0.045169946, 0.05321761), target2);
	target2 = MulAdd(h2, MF4x4(-0.12022473, 0.027450195, -0.070633, 0.010465206, -0.23977374, 0.008031643, -0.07748358, -0.12202592, -0.21730833, 0.0059398045, 0.40769234, -1.1242622, -0.06625515, 0.3264613, -0.07954283, 0.09583801), target2);
	target2 = MulAdd(i2, MF4x4(0.008234909, 0.18505827, -0.1273086, 0.23858553, -0.00791922, 0.0122221485, -0.11842601, -0.038017634, 0.03933724, 0.2956, -0.01691444, 0.17929354, 0.015529619, 0.19893076, -0.16288021, 0.05490817), target2);
	target2 = MulAdd(a3, MF4x4(-0.011399029, 0.10798575, 0.046656217, 0.032565042, 0.0119628515, -0.0011125325, 0.31439918, 0.09300187, -0.010849873, -0.060744617, 0.18471423, 0.15607913, -0.045522973, 0.16699308, -0.0722109, -0.024475403), target2);
	target2 = MulAdd(b3, MF4x4(-0.082331106, -0.07089719, 0.1347553, -0.19314262, 0.0032955715, -0.24533619, 0.013174161, 0.15500104, 0.029693194, 0.040375546, -0.0059178416, 0.1092399, -0.112020314, 0.1500148, -0.22925867, -0.019879973), target2);
	target2 = MulAdd(c3, MF4x4(0.1417249, 0.11215587, -0.26791674, 0.14707097, 0.040649403, -0.016661948, 0.15412898, -0.080876425, 0.035228007, 0.047104783, 0.06574109, -0.029853644, 0.05876159, 0.22823593, -0.19034219, 0.03162234), target2);
	target2 = MulAdd(d3, MF4x4(0.2600437, 0.044771086, 0.014325027, 0.163108, 0.060724687, 0.09108473, -0.20747156, 0.0039435104, 0.18791565, -0.11700223, -0.0055135386, -0.024981469, -0.19696075, 0.11015166, -0.004077458, 0.011203278), target2);
	target2 = MulAdd(e3, MF4x4(-0.05348392, 0.11058947, -0.11913848, 0.06359096, -0.13427798, -0.096259184, -0.122564375, 0.16873421, -0.021777656, 0.026404127, -0.19412898, -0.04525696, -0.089521095, -0.04556723, -0.14436369, 0.030330338), target2);
	target2 = MulAdd(f3, MF4x4(-0.077864684, -0.0033614987, -0.053482026, -0.15834975, -0.12657848, 0.16701786, 0.040268235, -0.14463072, 0.01926974, -0.15924485, -0.011547801, -0.18185836, 0.030286407, -0.29259017, -0.0077412864, 0.037985537), target2);
	target2 = MulAdd(g3, MF4x4(0.07485037, 0.19659927, 0.020025307, 0.10442409, -0.19772562, 0.4431493, -0.06422206, -0.045304112, -0.094377324, -0.04861216, 0.0023215367, 0.16513753, -0.1303532, -0.068101294, 0.017007684, 0.097332835), target2);
	target2 = MulAdd(h3, MF4x4(-0.004584652, -0.2661271, 0.0063034855, 0.041456066, 0.11529073, 0.19888161, -0.24943323, -0.054349367, -0.010328835, 0.22214927, -0.20700802, -0.05599532, 0.24972723, -0.08987443, 0.20708983, -0.13030328), target2);
	target2 = MulAdd(i3, MF4x4(0.10159776, 0.047147173, 0.1411316, -0.18355304, 0.07658331, -0.037969157, -0.074841976, 0.09781788, 0.06575143, 0.03210521, 0.058850992, -0.19939986, 0.11218086, -0.10744168, 0.14622156, 0.12941957), target2);
	target2 = MulAdd(na1, MF4x4(0.13577162, 0.10681536, 0.08791653, -0.060445737, -0.19715475, -0.13252279, -0.036850456, -0.009957216, 0.1860376, 0.3743373, -0.14414039, 0.044343796, -0.05038453, -0.034720805, 0.17924316, 0.012001023), target2);
	target2 = MulAdd(nb1, MF4x4(0.007108988, -0.09904293, -0.112725444, 0.031813867, -0.044795662, -0.14910372, 0.1680855, 0.32826513, 0.13105088, 0.11438789, -0.08039976, -1.1030464, 0.020364072, 0.19394659, 0.016075639, -0.22101837), target2);
	target2 = MulAdd(nc1, MF4x4(-0.100025505, -0.06350414, 0.06775572, -0.07832278, 0.093700364, -0.15951614, 0.36111444, -0.20566626, -0.1011544, -0.047608454, -0.07719231, -0.71597475, 0.0048773736, 0.012542508, -0.26781914, -0.3445289), target2);
	target2 = MulAdd(nd1, MF4x4(-0.050355583, 0.3859359, 0.08021888, 0.0031537602, 0.18742213, -0.30617613, -0.27419865, 0.18862267, -0.0011417761, 0.19679208, 0.06357993, -0.11287149, 0.11817958, -0.040369175, -0.055818953, 0.114691235), target2);
	target2 = MulAdd(ne1, MF4x4(-0.24919917, -0.1840669, -0.47709405, 0.020121656, -0.09533757, 0.23901173, -0.08210879, -0.22835779, 0.023564098, -0.1592999, 0.005221987, -0.54973453, -0.039800424, 0.19367874, -0.10306205, -0.21813862), target2);
	target2 = MulAdd(nf1, MF4x4(0.13417694, -0.06470136, -0.07049462, -0.052072115, -0.017625665, 0.108188346, 0.13198936, 0.1975063, -0.22973076, -0.28760132, -0.12961891, -0.08713851, -0.028337657, -0.35775787, 0.33782268, -0.282777), target2);
	target2 = MulAdd(ng1, MF4x4(-0.0796041, 0.16454107, -0.026372116, 0.0788071, 0.044841573, 0.15395795, -0.011288428, -0.03305742, 0.15754524, -0.0043833177, 0.12766863, -0.11310043, -0.023906957, 0.03451837, -0.083479226, 0.03029468), target2);
	target2 = MulAdd(nh1, MF4x4(-0.38791308, -0.120497175, -0.39432266, -0.016802365, 0.031366616, 0.20532085, -0.032990657, -0.004515397, -0.1540265, -0.2327063, 0.088945866, 0.11997355, 0.02506493, -0.11495644, 0.0847286, 0.0048163645), target2);
	target2 = MulAdd(ni1, MF4x4(-0.03319572, -0.26717946, -0.13605991, -0.10878451, 0.19831704, 0.04036457, -0.056414742, 0.15083815, -0.1640081, -0.25487527, -0.096472785, 0.05001906, -0.01256949, 0.07090488, -0.0888089, 0.24414414), target2);
	target2 = MulAdd(na2, MF4x4(-0.10947188, 0.07678741, -0.03716733, 0.10074092, -0.09684673, 0.19135101, 0.06687582, -0.03416071, -0.02605864, 0.18258773, 0.029176971, 0.14626507, 0.16892125, 0.26836056, -0.16163802, 0.0044406173), target2);
	target2 = MulAdd(nb2, MF4x4(0.07490834, -0.16595219, 0.06855593, -0.31601232, 0.2051958, 0.12370633, 0.053092375, -0.09280303, -0.041799355, -0.02180234, -0.0647632, 0.12765023, -0.02619668, 0.35134858, 0.025718898, -0.03524767), target2);
	target2 = MulAdd(nc2, MF4x4(0.051487356, -0.10184706, -0.058444723, 0.23035292, -0.03384644, -0.02926101, 0.24579355, 0.11463481, 0.00077921426, 0.0036189032, -0.04137187, 0.039233316, -0.11595721, 0.012141703, -0.19241674, 0.18287377), target2);
	target2 = MulAdd(nd2, MF4x4(-0.0331477, 0.11774921, 0.1500689, 0.21751022, -0.0391579, -0.026443282, -0.23405433, 0.10924835, 0.010694821, 0.46834385, -0.06344277, -0.027459502, 0.02805852, 0.063863516, -0.052119188, -0.010459627), target2);
	target2 = MulAdd(ne2, MF4x4(-0.19480526, -0.08907801, 0.13466452, -0.58980346, -0.18432151, 0.0025959515, -0.093561575, 0.21850146, -0.025087524, -0.112469815, 0.06425045, -0.017907271, 0.06015287, 0.23375069, 0.046780836, -0.124416254), target2);
	target2 = MulAdd(nf2, MF4x4(0.20069234, 0.073735476, -0.20799713, 0.11896709, -0.08604335, -0.030489137, -0.19158117, 0.07545736, 0.1417471, -0.2885722, -0.04138416, 0.16751918, -0.039241627, -0.29653955, 0.06402645, 0.08477943), target2);
	target2 = MulAdd(ng2, MF4x4(0.13838394, 0.17045505, 0.18386857, -0.06769848, 0.019191446, -0.10590481, 0.14499927, 0.005293376, -0.022189254, 0.45613396, 0.31436417, -0.23309496, 0.085356414, -0.12509619, -0.32398435, -0.06535322), target2);
	target2 = MulAdd(nh2, MF4x4(0.20557566, 0.23378044, 0.16096559, 0.3109223, -0.13988405, -0.056287576, 0.15235564, 0.14485452, 0.025657065, -0.19962808, 0.12487959, -0.53206867, 0.17598459, 0.0012244214, -0.09263318, -0.048799008), target2);
	target2 = MulAdd(ni2, MF4x4(0.031034216, -0.43335876, 0.15115865, -0.22912477, 0.039661117, -0.066167325, -0.0039048253, 0.108036794, -0.07157209, -0.42531285, -0.22807248, -0.070778824, -0.1216781, -0.20621637, 0.09195537, -0.0026917474), target2);
	target2 = MulAdd(na3, MF4x4(0.11940706, -0.13485508, 0.026604721, -0.100989655, -0.14618637, 0.45079112, -0.111106694, 0.23393573, 0.21399105, 0.049563177, -0.10910516, -0.21594371, 0.030558927, -0.17320083, 0.012688248, 0.02913788), target2);
	target2 = MulAdd(nb3, MF4x4(0.052507173, 0.13555464, 0.15568505, -0.13439007, 0.15468787, 0.20109199, 0.09981344, -0.022377115, 0.16711195, 0.1921043, -0.0457788, 0.11962697, 0.12201352, -0.15822104, 0.14560209, 0.11319004), target2);
	target2 = MulAdd(nc3, MF4x4(-0.10677749, -0.037526496, 0.05529873, 0.0014219015, -0.07003492, 0.11616926, -0.2047762, 0.053331498, -0.029710975, 0.099788256, 0.016773999, -0.05440333, -0.07308938, -0.1613098, 0.11157061, -0.06163726), target2);
	target2 = MulAdd(nd3, MF4x4(0.084668584, -0.024195379, 0.10567495, 0.018839711, 0.20675091, 0.064051956, 0.16356891, 0.0763972, 0.04519446, 0.04648411, -0.26651385, -0.32033405, 0.19019292, -0.03760131, 0.057477303, 0.039011493), target2);
	target2 = MulAdd(ne3, MF4x4(0.10785335, -0.005846821, 0.106043994, -0.029447608, -0.17944743, -0.055760577, -0.061553795, -0.0897441, 0.30305168, -0.07138199, -0.038286258, 0.31980807, 0.08745091, 0.08931471, 0.19994807, -0.19448686), target2);
	target2 = MulAdd(nf3, MF4x4(0.05872038, 0.019705178, -0.057756446, 0.032349724, 0.1162347, -0.1494079, 0.04883473, 0.06775521, 0.06246929, 0.18094592, 0.019297523, 0.22078563, -0.10864955, 0.024548724, -0.09518366, -0.049131762), target2);
	target2 = MulAdd(ng3, MF4x4(0.083531916, -0.22589867, 0.15678734, -0.15247858, 0.037808564, -0.3915128, 0.023039397, -0.11101649, -0.024950527, 0.15221989, 0.02177459, -0.0052792793, -0.006660954, 0.103587925, -0.069532864, -0.036814045), target2);
	target2 = MulAdd(nh3, MF4x4(0.042244066, 0.08479697, -0.057882927, 0.036821585, -0.12734346, -0.30277002, 0.17587237, 0.08462706, 0.03041879, -0.07751665, 0.41255432, -0.15170433, -0.094225794, 0.09409663, -0.03903985, -0.17728558), target2);
	target2 = MulAdd(ni3, MF4x4(-0.07648597, -0.021105368, -0.13569473, 0.11226781, 0.0024825619, 0.10949022, -0.033650707, -0.01084071, -0.27865705, -0.050442215, -0.026282378, 0.07449441, -0.033618845, 0.20228988, 0.10323669, -0.2785842), target2);
	
	MF4 target3 = { 0.08639024, -0.11024204, -0.0076959864, 0.053946566 };
	target3 = MulAdd(a1, MF4x4(-0.043845546, -0.051818844, 0.15098971, -0.029770624, 0.105532385, -0.017158495, 0.007995025, 0.01310204, 0.046253394, 0.054963812, -0.07156648, -0.026536593, -0.034585387, -0.03867656, -0.026378985, -0.0503513), target3);
	target3 = MulAdd(b1, MF4x4(0.19067752, 0.077902906, 0.07043644, 0.093124524, -0.088099405, 0.05687826, 0.07339772, 0.25220734, -0.024105951, 0.047068372, -0.15396254, 0.0024811088, 0.05398644, 0.114431, 0.104937814, -0.084533244), target3);
	target3 = MulAdd(c1, MF4x4(-0.06216834, -0.09104735, 0.030077647, -0.109212935, -0.03391817, 0.14209917, 0.06807519, 0.086794056, 0.13323791, -0.16663639, 0.18892457, 0.18872325, 0.098952405, -0.009112314, 0.16958214, 0.14279945), target3);
	target3 = MulAdd(d1, MF4x4(-0.07209618, 0.10666213, 0.10406824, -0.10080884, -0.061229795, -0.070260175, 0.0544128, -0.16189453, -0.07493434, 0.25146472, -0.10089679, -0.16500695, -0.05206539, -0.10650778, 0.08510133, -0.12274426), target3);
	target3 = MulAdd(e1, MF4x4(0.06154247, -0.2779647, -0.39013094, 0.19112335, 0.21914953, 0.174526, -0.2582261, 0.028989773, 0.12516306, 0.024158027, -0.06397669, -0.027443565, 0.01338054, 0.11226658, -0.18691953, 0.03941122), target3);
	target3 = MulAdd(f1, MF4x4(0.06017567, 0.064941615, -0.16408192, 0.14018805, -0.022913788, -0.005578652, 0.056423694, -0.12357743, 0.053335212, -0.10533416, 0.0336598, 0.13383694, 0.13861552, 0.13800743, 0.048778858, 0.20749462), target3);
	target3 = MulAdd(g1, MF4x4(-0.19730464, -0.07471736, -0.08532417, 0.22114716, -0.0655994, 0.014833043, 0.069433905, 0.0126395365, -0.115397535, 0.16183057, -0.0020461925, -0.08379374, 0.066027366, 0.046908997, -0.04298647, -0.039427415), target3);
	target3 = MulAdd(h1, MF4x4(-0.40682083, -0.051349834, -0.058064308, -0.59165514, 0.07769667, -0.0061552664, 0.09866719, 0.09064238, -0.10091702, -0.08237763, -0.0896345, -0.06889367, 0.029332574, -0.067278475, 0.032268777, 0.08217916), target3);
	target3 = MulAdd(i1, MF4x4(-0.16198236, 0.14663215, -0.19844484, 0.12605388, 0.11090156, 0.017791988, -0.058779463, 0.041371945, -0.22293547, -0.015482557, 0.2293464, 0.094193965, -0.26855227, -0.21347573, -0.09075141, -0.13876276), target3);
	target3 = MulAdd(a2, MF4x4(-0.06498589, 0.100892216, -0.13253035, 0.15685925, 0.16823533, 0.16493973, 0.07777784, -0.07706127, 0.050116807, -0.01523585, -0.01661001, 0.020355182, 0.103539385, -0.17436443, 0.15487072, -0.037921157), target3);
	target3 = MulAdd(b2, MF4x4(0.03836789, -0.15199225, 0.11784638, -0.04646745, 0.044564333, 0.22369106, 0.14419034, -0.010723647, -0.0027908115, -0.15769437, 0.14674728, 0.21630915, -0.15577918, 0.083906, -0.076731354, 0.09644861), target3);
	target3 = MulAdd(c2, MF4x4(0.057972, -0.085704334, -0.044770416, -0.08455327, -0.096369885, 0.17715664, 0.0931527, 0.08611585, 0.082069114, -0.21235153, 0.056143392, -0.09681458, -0.15192977, -0.11773526, 0.085406475, -0.054963436), target3);
	target3 = MulAdd(d2, MF4x4(0.04377759, 0.14948493, 0.14370604, 0.121995315, -0.034767535, -0.19136979, 0.20502615, -0.19230005, -0.010331832, 0.24712276, 0.08443175, -0.02108672, -0.05402554, -0.073491514, -0.01772348, -0.04717817), target3);
	target3 = MulAdd(e2, MF4x4(-0.0859936, 0.12129631, 0.4917177, 0.014785702, -0.017697783, 0.20519169, 0.193045, -0.32276052, 0.052729923, 0.20259547, -0.23248449, 0.027868863, 0.06924204, -0.0680142, -0.1510381, -0.0858641), target3);
	target3 = MulAdd(f2, MF4x4(0.0042993063, -0.001888591, -0.19050622, -0.1974649, 0.0028959673, -0.056935344, -0.15306468, -0.037034288, -0.005013645, -0.49978206, -0.2860419, -0.24230668, -0.21625051, 0.124884024, -0.018598353, 0.018011522), target3);
	target3 = MulAdd(g2, MF4x4(-0.00059534056, 0.09819056, -0.10073479, -0.0036862926, 0.018240096, -0.068672635, -0.040024363, -0.002400606, 0.12492032, 0.6830032, -0.103963815, -0.20350884, -0.0731358, 0.122847795, -0.04129241, 0.027231846), target3);
	target3 = MulAdd(h2, MF4x4(0.14632931, 0.056954373, 0.10602974, 0.06899008, 0.028749242, 0.16360262, -0.2776957, -0.13795078, 0.2955775, 0.07387963, 0.18735075, 0.37977517, -0.0032196203, -0.0368105, 0.0007467509, -0.048191283), target3);
	target3 = MulAdd(i2, MF4x4(-0.08740623, -0.14123341, -0.16725405, -0.035077587, 0.16800366, 0.10287269, -0.02063956, -0.02751512, -0.22882652, -0.19836405, -0.07881451, -0.036120445, -0.03052641, -0.19137034, 0.02006256, -0.0003630293), target3);
	target3 = MulAdd(a3, MF4x4(0.21042292, 0.07082529, 0.10551431, -0.17735177, 0.1211633, -0.07301316, 0.08914643, 0.027641036, 0.0716893, 0.009513582, 0.06489754, -0.11262447, -0.006487075, 0.042482372, 0.040942963, 0.026485842), target3);
	target3 = MulAdd(b3, MF4x4(0.07677389, 0.017061912, 0.080698825, -0.02926673, 0.030129844, 0.08797221, -0.042393677, 0.040378265, 0.14051779, -0.01150974, -0.09838748, -0.084651664, 0.13157506, 0.15760668, 0.13706487, 0.017946318), target3);
	target3 = MulAdd(c3, MF4x4(0.21381795, 0.108781934, 0.12417435, 0.04925163, 0.05298279, -0.1352583, 0.085234426, -0.03526282, -0.024876006, 0.0025064421, 0.07016869, 0.084552824, 0.064173326, -0.05621783, 0.0711457, -0.025467668), target3);
	target3 = MulAdd(d3, MF4x4(-0.05810587, 0.0134641845, -0.038737856, 0.07663204, 0.121298246, -0.13257936, 0.004325269, -0.036193457, -0.29106387, -0.106322676, -0.23442906, 0.2862568, -0.18702938, 0.0030504123, -0.037212595, -0.2611213), target3);
	target3 = MulAdd(e3, MF4x4(0.024120133, 0.07321953, 0.038489927, -0.04196367, -0.07796083, 0.33956012, -0.13922311, -0.05377065, -0.070829384, -0.10083194, 0.239536, -0.05901714, 0.26581895, -0.3095538, -0.2922295, 0.052582845), target3);
	target3 = MulAdd(f3, MF4x4(0.02742305, -0.018496662, -0.094728574, 0.06404221, -0.041348618, -0.25715774, -0.1643205, 0.13505833, 0.043563902, -0.12633435, -0.101704225, -0.06851076, -0.10801949, -0.07229803, -0.042177804, 0.15722917), target3);
	target3 = MulAdd(g3, MF4x4(-0.1890737, 0.086372465, 0.19611897, 0.11635388, -0.27176055, 0.113715895, -0.090014786, 0.028875142, -0.054593917, 0.030705186, 0.1435633, 0.061870232, -0.11143878, 0.09881344, 0.097813986, -0.21929547), target3);
	target3 = MulAdd(h3, MF4x4(0.04700684, 0.042240005, -0.27370077, -0.10867852, -0.06256984, -0.08165931, 0.14414817, -0.046392858, 0.06402001, -0.18298607, -0.20697436, -0.035047896, 0.104348354, 0.21140936, 0.08119135, 0.11215284), target3);
	target3 = MulAdd(i3, MF4x4(-0.15503405, -0.0058879172, 0.06903078, 0.10739542, -0.047215104, 0.05061763, -0.1265464, -0.13796777, 0.050830897, -0.06356833, 0.10470089, 0.061785046, -0.054734606, 0.069204785, 0.22219127, 0.14431196), target3);
	target3 = MulAdd(na1, MF4x4(0.0035822908, -0.041718304, -0.06449883, 0.107891634, 0.11240286, 0.2773934, 0.018296933, 0.17229447, -0.038918763, -0.015615794, 0.013606009, -0.15145436, -0.038385842, -0.075797774, 0.074630134, -0.115841195), target3);
	target3 = MulAdd(nb1, MF4x4(-0.35196853, -0.055269916, -0.10619746, 0.036240876, 0.027898792, 0.16981332, -0.08743389, -0.11659183, 0.21521945, 0.14624144, 0.3709361, 0.35440952, 0.05083335, -0.027957644, -0.14189775, 0.041765563), target3);
	target3 = MulAdd(nc1, MF4x4(-0.012040415, 0.03733818, 0.0028794291, 0.085560195, -0.003578092, -2.0037096e-05, 0.018441873, -0.048575614, 0.16403939, 0.26586646, -0.23535033, -0.195904, 0.09343384, 0.16844647, 0.090654954, 0.20447001), target3);
	target3 = MulAdd(nd1, MF4x4(-0.039211, 0.023288574, -0.11278111, 0.24733941, 0.030935412, 0.028505033, -0.054287612, 0.1626191, -0.013604053, -0.40332177, -0.12607175, 0.062430628, 0.020255104, -0.034459837, -0.02045024, 0.13066867), target3);
	target3 = MulAdd(ne1, MF4x4(-0.109611966, 0.036982346, 0.24648234, -0.10601368, -0.046704277, 0.09159354, -0.051051375, 0.27708438, -0.27565628, 0.3181145, 0.0352402, 0.11326822, 0.08464163, 0.0037447016, -0.11625815, -0.27881616), target3);
	target3 = MulAdd(nf1, MF4x4(-0.17009212, -0.14643735, 0.05730069, -0.19120802, 0.06845526, 0.10674906, -0.28353846, -0.12647904, 0.015396511, 0.097950876, 0.009746547, 0.031028407, -0.05640266, -0.04813061, 0.1215167, 0.013483247), target3);
	target3 = MulAdd(ng1, MF4x4(-0.015532973, 0.06836607, -0.15256128, 0.016466603, 0.22348233, 0.13754332, -0.032162182, 0.33556822, 0.17382346, -0.2763521, 0.060414087, 0.0027655934, 0.031628147, 0.08716705, 0.015910214, 0.0672223), target3);
	target3 = MulAdd(nh1, MF4x4(0.4342632, -0.067446776, -0.36212516, 0.027729288, 0.18695018, -0.026150677, -0.048804305, 0.03894249, 0.08076834, -0.024184678, -0.039985072, 0.019538054, -0.12608467, -0.114978395, 0.08024422, -0.009467871), target3);
	target3 = MulAdd(ni1, MF4x4(-0.12950122, -0.04900754, 0.007479547, 0.005553716, -0.011067856, 0.15695909, 0.15179226, 0.13305564, 0.109665506, -0.071129486, -0.29301268, -0.19721518, -0.014072068, 0.110164836, -0.10445084, -0.07427861), target3);
	target3 = MulAdd(na2, MF4x4(0.056494176, 0.10441701, 0.1473454, -0.10962488, -0.024387872, -0.10661404, 0.023665238, -0.014857965, -0.11904774, 0.028333792, -0.018734593, 0.041431252, -0.051380955, 0.08761405, 0.025005583, 0.27504325), target3);
	target3 = MulAdd(nb2, MF4x4(0.12111209, 0.09115707, -0.12130387, 0.037170578, 0.17773823, 0.11543872, -0.0981619, -0.009393771, -0.072751574, 0.12490967, -0.050705448, -0.21641576, -0.0032860835, -0.017348124, -0.039524093, -0.22634275), target3);
	target3 = MulAdd(nc2, MF4x4(-0.026149368, -0.0345828, 0.024678709, 0.073074006, 0.075326554, 0.07688483, -0.06151585, -0.0006315397, -0.11916223, 0.09640916, -0.03452899, 0.0711575, 0.10298667, 0.14983572, -0.029672628, 0.060187414), target3);
	target3 = MulAdd(nd2, MF4x4(0.061185572, 0.025581252, 0.05371412, -0.30638546, 0.064506106, 0.22312112, -0.12822428, 0.050079864, 0.007665535, -0.270618, -0.1205649, 0.066014335, -0.10095298, 0.14537272, 0.07578119, -0.102102645), target3);
	target3 = MulAdd(ne2, MF4x4(0.24163178, -0.14042771, -0.28968832, 0.32306322, -0.08210339, -0.089168124, -0.029958146, 0.23500884, -0.045208763, -0.076190665, -0.048189905, -0.062144633, -0.2209541, -0.118137404, -0.10013809, -0.2633339), target3);
	target3 = MulAdd(nf2, MF4x4(-0.043336965, -0.14818442, 0.3353549, 0.37338758, -0.097953044, 0.08346902, 0.2809552, -0.15042788, 0.052860767, 0.3296333, 0.1520426, 0.013095576, 0.06748028, -0.18191148, 0.1262768, 0.1454165), target3);
	target3 = MulAdd(ng2, MF4x4(0.020386793, -0.05559494, 0.0923228, -0.101281434, 0.07294861, -0.013454893, 0.14446425, -0.18820941, 0.03512501, -0.3100584, 0.07824563, 0.039452225, -0.31067702, -0.0059947846, -0.022850258, -0.03394584), target3);
	target3 = MulAdd(nh2, MF4x4(-0.2551513, 0.07006202, 0.10514115, -0.07164224, -0.15870212, 0.058055036, 0.05213708, -0.14221531, 0.18606052, 0.121992745, 0.005545236, 0.20166458, -0.51196563, 0.13145791, -0.07664502, -0.102140725), target3);
	target3 = MulAdd(ni2, MF4x4(0.013922251, -0.055376403, 0.32802138, 0.13208407, 0.013657613, 0.10752059, 0.036252435, 0.1592283, 0.013641419, 0.09172557, -0.047022454, -0.06487285, -0.010537236, 0.043602772, -0.018355483, 0.061706495), target3);
	target3 = MulAdd(na3, MF4x4(0.034295138, 0.0290897, -0.055937063, 0.030905105, -0.049568217, 0.23283507, -0.09925937, 0.06541922, -0.19225466, -0.37406424, -0.0044630794, 0.12548251, -0.003204782, -0.033718586, -0.12822233, -0.06512161), target3);
	target3 = MulAdd(nb3, MF4x4(0.04231634, 0.033866994, -0.060438603, 0.053806484, -0.043768402, -0.09377961, 0.053774644, -0.05314562, 0.08742594, -0.3595988, 0.05714237, -0.026023258, -0.14470316, -0.17429292, -0.05919939, -0.05714775), target3);
	target3 = MulAdd(nc3, MF4x4(-0.035541177, -0.15197758, -0.03248727, 0.055882126, 0.03910343, 0.14273937, -0.16545315, -0.019183658, 0.067014545, -0.010861471, -0.23015557, -0.3174752, -0.0895981, 0.05603517, -0.10421314, 0.03543782), target3);
	target3 = MulAdd(nd3, MF4x4(0.052712325, 0.15568605, 0.13511989, -0.035405457, 0.09660214, 0.0010066679, 0.0041616405, 0.3261607, -0.07167953, -0.3432988, 0.37812582, 0.08591545, 0.17927478, -0.08654189, 0.076707125, 0.14279753), target3);
	target3 = MulAdd(ne3, MF4x4(-0.056844193, 0.16529651, -0.06650483, -0.08292316, -0.02760633, -0.22888668, -0.19214903, -0.08840017, -0.23843671, -0.6793711, -0.33102167, 0.0064898706, -0.29774654, 0.37099698, 0.42785385, 0.025804019), target3);
	target3 = MulAdd(nf3, MF4x4(-0.11744241, -0.057497155, 0.18884729, 0.024753813, -0.0062507484, 0.33419883, 0.120441675, -0.25218838, -0.042276263, 0.08504629, -0.033582047, 0.07008096, -0.058578875, 0.0392345, 0.11335631, -0.15865934), target3);
	target3 = MulAdd(ng3, MF4x4(-0.04641351, -0.0370654, -0.08322972, -0.11589779, 0.09985797, -0.0747252, 0.0050210473, -0.0737313, 0.34289247, -0.08783692, 0.13673791, 0.05667411, 0.058139045, -0.17664829, -0.16574872, 0.020792067), target3);
	target3 = MulAdd(nh3, MF4x4(-0.17315285, 0.061304655, 0.23295666, 0.004587563, 0.025884068, -0.20429865, -0.17807725, 0.04610146, -0.16748384, 0.03548062, 0.36901402, 0.040421892, 0.0732819, -0.06323222, 0.17438933, 0.10541013), target3);
	target3 = MulAdd(ni3, MF4x4(0.11953197, -0.041181084, -0.05777039, -0.0713763, -0.07250408, 0.00030710385, -0.12310962, 0.05047857, 0.07764678, 0.048569802, -0.07179031, -0.13407484, 0.18644087, -0.08796725, 0.09215986, 0.03264275), target3);

	tex4[gxy] = target1;
	tex5[gxy] = target2;
	tex6[gxy] = target3;
}

//!PASS 3
//!DESC Conv-4x3x3x24
//!IN tex4, tex5, tex6
//!OUT tex1, tex2, tex3
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass3(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = tex4.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = tex4.SampleLevel(sam, pos, 0);
	MF4 f1 = tex4.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = tex5.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = tex5.SampleLevel(sam, pos, 0);
	MF4 f2 = tex5.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    MF4 a3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = tex6.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = tex6.SampleLevel(sam, pos, 0);
	MF4 f3 = tex6.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target1 = { 0.0026275632, -0.111531265, -0.027438803, 0.048715387 };
	target1 = MulAdd(a1, MF4x4(0.2369839, -0.0792359, -0.12919348, 0.002247716, 0.04581234, 0.119436085, -0.039395507, -0.035233624, -0.031238249, 0.068567455, 0.021003028, -0.07353918, -0.12103854, -0.21112324, -0.0063801156, -0.04487009), target1);
	target1 = MulAdd(b1, MF4x4(0.0683294, 0.062320776, -0.024078269, 0.08904798, 0.026528858, -0.041699078, -0.07854327, -0.14078824, 0.060052495, -0.12898798, -0.010206991, -0.10815312, -0.07348112, -0.09190296, 0.16384035, 0.11615318), target1);
	target1 = MulAdd(c1, MF4x4(0.073954284, 0.11315491, -0.08271167, 0.012718058, -0.079351336, -0.12847738, 0.16898601, 0.057100534, -0.007783043, -0.046511702, -0.031176837, 0.09832856, 0.04629018, -0.11481637, 0.27974957, -0.008512578), target1);
	target1 = MulAdd(d1, MF4x4(-0.11174049, -0.06978879, -0.0026527392, 0.09206777, -0.052967362, 0.04242691, -0.028125865, -0.006913773, -0.105203055, 0.012300771, 0.073976465, 0.0597795, 0.12224533, -0.15938343, -0.04735274, -0.13670483), target1);
	target1 = MulAdd(e1, MF4x4(0.069210574, -0.18154296, -0.179752, 0.030308926, 0.21821375, -0.17105243, 0.002948972, 0.1510472, -0.07507222, 0.05799302, 0.22358851, -0.1593742, -0.14097035, -0.14883585, -0.10766054, -0.04192339), target1);
	target1 = MulAdd(f1, MF4x4(0.04092946, -0.056620143, -0.08841022, 0.0820261, 0.12114886, -0.046587184, -0.24642876, 0.20291825, -0.021399742, 0.075130075, 0.08025963, -0.0004831952, -0.20216052, 0.063063756, -0.14950794, -0.016591785), target1);
	target1 = MulAdd(g1, MF4x4(0.001037612, -0.12479094, -0.064145386, 0.03701432, -0.09794906, -0.02047066, -0.0064438935, 0.054445606, 0.017312052, -0.010994496, -0.043534316, -0.03507283, -0.2881326, 0.056422662, 0.45392624, -0.14301568), target1);
	target1 = MulAdd(h1, MF4x4(0.02659516, -0.12523884, -0.045878954, 0.0401728, -0.026269691, 0.23919468, -0.05373766, 0.22576872, 0.15472023, -0.06473123, -0.16314703, -0.007313837, 0.06282956, -0.12448595, 0.32412103, -0.1669555), target1);
	target1 = MulAdd(i1, MF4x4(0.10851828, -0.0019357264, -0.042929318, 0.087208286, 0.08521072, -0.015302626, -0.045136105, -0.07599174, -0.020620871, -0.08058013, 0.04687409, 0.07679515, 0.02748689, -0.04049585, 0.031744577, -0.08941878), target1);
	target1 = MulAdd(a2, MF4x4(-0.053986546, 0.2688435, -0.057546657, -0.11350552, -0.081904754, -0.09276461, -0.13561548, -0.11588968, 0.04355686, -0.29325503, -0.018699612, -0.06769227, -0.015948739, 0.04491891, -0.046178948, 0.02711675), target1);
	target1 = MulAdd(b2, MF4x4(-0.18972659, 0.27545497, -0.034131754, -0.09609413, 0.068409085, 0.13449967, -0.13105616, 0.028345212, -0.035266094, -0.065575354, -0.031779382, -0.14933869, 0.05228527, 0.09356076, -0.047118377, -0.020071832), target1);
	target1 = MulAdd(c2, MF4x4(-0.17382587, 0.15029867, -0.00600536, -0.035180923, 0.025643297, 0.010418448, 0.14726849, -0.05890341, -0.053652834, 0.048409678, 0.2806725, -0.08192519, -0.06738357, 0.07469718, 0.06771393, -0.042583536), target1);
	target1 = MulAdd(d2, MF4x4(0.011517158, 0.09972045, 0.06578792, -0.12352661, 0.05922438, -0.16663863, -0.006771989, -0.038835894, -0.02194692, -0.13857606, 0.023138417, -0.05360372, 0.014272163, 0.08904743, -0.04252727, 0.103002235), target1);
	target1 = MulAdd(e2, MF4x4(-0.008667266, 0.19219917, -0.07475974, -0.2816411, -0.33488217, 0.039849013, 0.017313587, 0.08000436, 0.15055846, 0.015432909, 0.32798117, 0.009342251, -0.23739037, -0.28346112, -0.030122897, -0.18473577), target1);
	target1 = MulAdd(f2, MF4x4(0.22614895, 0.13032585, -0.2176673, -0.3387019, 0.019557813, 0.17496689, 0.030887462, 0.17172079, -0.10533174, 0.0032622286, -0.13369057, -0.039323095, -0.0008841287, 0.121519946, 0.067216426, 0.03257707), target1);
	target1 = MulAdd(g2, MF4x4(-0.0429636, 0.13093638, 0.12012435, -0.034646116, 0.0488735, 0.08784733, 0.03349143, -0.09357028, -0.06089799, 0.022837836, 0.16202758, 0.096765295, 0.009665008, -0.10780318, -0.07340907, 0.018662468), target1);
	target1 = MulAdd(h2, MF4x4(0.0484555, 0.05852715, -0.11502228, -0.2250242, 0.00487918, -0.018516708, -0.024522817, -0.09146677, 0.0006642944, 0.17241697, 0.38606182, -0.23263825, 0.110663734, 0.11034593, -0.0056327246, 0.051475164), target1);
	target1 = MulAdd(i2, MF4x4(-0.014929107, 0.09463201, 0.009869103, -0.17499818, 0.028962199, 0.23815866, 0.060768303, 0.13828199, 0.12261715, 0.096965745, -0.024608571, -0.24542965, 0.025484774, -0.0014874635, -0.009807938, 0.0007101552), target1);
	target1 = MulAdd(a3, MF4x4(-0.101674154, 0.032412667, -0.10450873, -0.00022480187, 0.024635756, -0.1357198, -0.05327909, -0.036563605, 0.07561588, 0.009124707, -0.13368087, 0.042969264, -0.043317486, -0.1518712, -0.008810181, 0.030755859), target1);
	target1 = MulAdd(b3, MF4x4(0.1406038, 0.036187246, -0.06288465, 0.013666562, -0.22509198, 0.054938264, 0.03374708, 0.036942195, -0.054834712, 0.08038173, -0.012174669, -0.05048155, 0.04105839, -0.13010618, 0.029987235, 0.029830217), target1);
	target1 = MulAdd(c3, MF4x4(0.13428736, -0.145587, -0.09359362, 0.08647307, -0.1721466, 0.14161868, 0.06169795, -0.020108147, -0.082708314, -0.0009893128, 0.061197698, 0.015552345, 0.19280085, 0.045152925, -0.13817257, 0.08140578), target1);
	target1 = MulAdd(d3, MF4x4(0.11750963, 0.0146443285, -0.026884248, -0.0006429066, -0.008400631, -0.043018907, -0.07913679, -0.14783737, -0.032443974, -0.08028971, -0.08927282, 0.00809941, 0.0124223465, 0.041715536, -0.06587267, 0.13605455), target1);
	target1 = MulAdd(e3, MF4x4(0.29818505, 0.20918716, -0.13256323, 0.23988591, -0.38704476, -0.05851411, -0.004705456, 0.10221165, -0.08329328, 0.12643409, -0.23133238, 0.036488805, 0.21748522, -0.095220506, -0.012000105, -0.0032247186), target1);
	target1 = MulAdd(f3, MF4x4(-0.119828835, -0.016386732, 0.06939514, 0.08491721, -0.017447483, -0.10812376, -0.015384033, -0.0137153845, -0.14978316, 0.032878425, 0.120704606, 0.07987688, 0.10143365, 0.16894275, -0.09816831, -0.029983638), target1);
	target1 = MulAdd(g3, MF4x4(0.004197231, -0.004475635, 0.02442438, -0.08062267, -0.13645843, -0.063362874, -0.13470308, -4.8972346e-05, 0.04937739, 0.025885701, -0.0626489, 0.06272147, 0.040682197, -0.037275683, -0.07711889, -0.03401893), target1);
	target1 = MulAdd(h3, MF4x4(-0.07601782, -0.044119228, 0.12799697, -0.04923261, -0.07554412, -0.13866402, -0.039769165, 0.0750738, 0.028331043, 0.22329865, -0.078985184, 0.21741354, 0.08896384, 0.02745735, -0.11954973, -0.030984413), target1);
	target1 = MulAdd(i3, MF4x4(0.088372685, -0.04094657, 0.030890986, 0.011887401, 0.101060346, 0.036795005, -0.02541599, 0.11929074, 0.0042294776, -0.09067195, -0.13775113, 0.051152255, -0.011856665, -0.01186073, -0.014405341, -0.06443953), target1);
	target1 = MulAdd(na1, MF4x4(0.1990754, -0.13920973, -0.24694741, 0.20978624, 0.00096705626, -0.09906306, -0.031113537, 0.09064841, -0.005332781, 0.06942478, 0.027275847, 0.14482562, 0.10915609, 0.15485178, 0.09100627, 0.08800073), target1);
	target1 = MulAdd(nb1, MF4x4(0.067276604, -0.15296488, -0.10655601, 0.1007172, 0.06399946, 0.11820019, -0.012255674, -0.04701397, 0.005157013, 0.14800015, -0.005829729, 0.058462787, -0.0034304103, -0.0022002284, 0.088455915, -0.09076621), target1);
	target1 = MulAdd(nc1, MF4x4(-0.0045863236, -0.13443832, -0.02036122, 0.067712225, -0.09286585, 0.15505461, -0.03191861, 0.062198598, -0.014097363, -0.06486533, -0.013725968, 0.09863627, 0.004106804, -0.11001409, -0.1489799, 0.012900801), target1);
	target1 = MulAdd(nd1, MF4x4(0.11722181, 0.024655748, 0.028080126, 0.034889475, -0.02211666, 0.10347594, 0.19828199, -0.052708372, -0.23978107, 0.11193546, 0.015817301, -0.060378563, 0.05506628, 0.017437497, 0.17592382, 0.1566574), target1);
	target1 = MulAdd(ne1, MF4x4(0.011318326, -0.19983633, 0.0542877, -0.08868874, 0.059281945, -0.08321469, -0.45549735, 0.41699305, 0.18566287, -0.22530322, -0.08444872, -0.04485004, -0.13312897, 0.025137378, 0.4283649, -0.22263475), target1);
	target1 = MulAdd(nf1, MF4x4(0.10148392, 0.12450337, -0.032773893, 0.03742288, 0.0059106606, -0.17406113, -0.083701774, -0.010221676, 0.16314605, -0.22251254, -0.13263722, 0.09496533, -0.0020611945, 0.10998006, 0.23540293, 0.12287761), target1);
	target1 = MulAdd(ng1, MF4x4(-0.01097223, 0.043488838, 0.028565591, 0.057649106, 0.04069052, -0.015125962, -0.033889383, -0.039301567, -0.28547964, 0.16771436, 0.064779356, 0.17768629, 0.0977948, -0.12978803, 0.1248975, 0.076509014), target1);
	target1 = MulAdd(nh1, MF4x4(-0.014799843, -0.11454738, 0.0072981194, 0.06956252, -0.119126685, -0.054390237, 0.20148608, 0.055611208, -0.33772695, 0.02875631, 0.15688069, 0.07648471, 0.17330919, -0.10749096, -0.00058184325, -0.16302843), target1);
	target1 = MulAdd(ni1, MF4x4(0.025022479, -0.0510169, -0.054967374, -0.18119891, 0.072380155, 0.13645615, -0.029061519, -0.09392558, 0.0020073708, 0.10373002, 0.08769151, 0.1467629, -0.032814845, -0.22622965, 0.062578805, 0.15869768), target1);
	target1 = MulAdd(na2, MF4x4(0.08132352, -0.057824034, -0.049706902, -0.021799462, 0.027207939, 0.055137623, 0.13588108, -0.06595749, -0.10212913, 0.03328737, 0.07568671, 0.04425169, -0.056393128, 0.08096936, 0.049417946, -0.03110039), target1);
	target1 = MulAdd(nb2, MF4x4(0.16936453, -0.03750322, -0.041140877, -0.08652042, -0.029363338, -0.07450129, 0.102560416, -0.23950958, -0.13059175, 0.21066219, 0.10126263, 0.043688625, 0.12293311, -0.02102107, -0.01415126, -0.08114574), target1);
	target1 = MulAdd(nc2, MF4x4(0.13357115, 0.25130415, -0.008012242, -0.022129368, -0.04116201, 0.19364384, -0.0755634, -0.021590892, 0.014902855, -0.16364469, -0.15113516, 0.021274269, 0.002715793, -0.082595, -0.023225293, -0.0023291293), target1);
	target1 = MulAdd(nd2, MF4x4(-0.047352426, 0.047768887, -0.027633572, -0.048747484, 0.002366812, 0.2123351, -0.03785716, -0.06169537, 0.05152527, -0.097918324, -0.09970387, -0.10696893, 0.14201112, 0.048251197, 0.020989964, -0.12759319), target1);
	target1 = MulAdd(ne2, MF4x4(-0.11691897, 0.11003735, 0.1787839, 0.035897207, -0.068546794, 0.18663177, -0.11768889, 0.0046620993, -0.076647416, -0.008958245, 0.055827506, -0.095377706, 0.051213227, -0.2821711, 0.013320494, 0.1563779), target1);
	target1 = MulAdd(nf2, MF4x4(-0.08324576, 0.3131121, 0.21894962, 0.013974257, -0.05526049, 0.032233212, 0.05284564, -0.2475858, 0.13031252, -0.08124232, -0.010205146, -0.057937223, 0.11874465, -0.013862318, 0.0052336063, 0.04949605), target1);
	target1 = MulAdd(ng2, MF4x4(0.14994349, -0.03296414, -0.23602034, -0.0033256228, 0.008873702, -0.010388283, -0.035780232, 0.011833461, 0.117081955, -0.038984414, 0.074017905, 0.033703547, -0.024258457, 0.09559132, 0.02495569, -0.040010694), target1);
	target1 = MulAdd(nh2, MF4x4(-0.0048430585, 0.17926253, 0.008713498, 0.10879202, 0.019645652, 0.029483858, -0.047485687, -0.042396937, -0.029273199, -0.2432983, -0.1250007, -0.024952445, -0.060036886, 0.014986906, -0.014428253, 0.03334825), target1);
	target1 = MulAdd(ni2, MF4x4(0.11731086, 0.20593153, -0.10197385, -0.011249018, -0.10738923, -0.074847564, -0.006172099, -0.18687822, -0.097578146, -0.07579803, 0.05764291, 0.10152833, -0.14840044, 0.035003513, 0.023365693, 0.04386252), target1);
	target1 = MulAdd(na3, MF4x4(0.2394935, -0.151495, -0.004142306, -0.084381334, -0.06817076, 0.04995128, 0.07523575, -0.019087847, 0.04900443, 0.03855287, -0.047666, -0.010728584, -0.041862275, 0.0092430115, 0.18933049, 0.001247498), target1);
	target1 = MulAdd(nb3, MF4x4(-0.26478, -0.108964734, 0.07654512, -0.18083075, 0.087697916, -0.1985272, 0.12003646, 0.088157, -0.11911801, 0.10562385, 0.08664133, 0.04456427, -0.105021, 0.18528733, 0.034151975, -0.15520982), target1);
	target1 = MulAdd(nc3, MF4x4(0.017519012, -0.012286436, 0.10177459, 0.038459957, -0.22457904, -0.05511256, 0.15413229, 0.1507701, 0.08257404, 0.034750186, -0.15717988, -0.030795097, -0.07657355, -0.33403704, -0.0053621423, -0.06624692), target1);
	target1 = MulAdd(nd3, MF4x4(0.10030682, -0.052044563, -0.049402863, 0.09053447, -0.13081445, 0.0141896, 0.042153686, -0.010219266, -0.06850381, 0.03529716, 0.16374019, 0.06750858, 0.09204821, 0.053093266, -0.024561154, 0.018893644), target1);
	target1 = MulAdd(ne3, MF4x4(-0.21870598, 0.32735768, -0.037454635, -0.062546894, 0.048824597, 0.006229873, 0.0879531, 0.0010694796, 0.1268415, -0.3329151, 0.18059574, 0.027663317, 0.06451952, 0.2059446, -0.14739716, 0.0425968), target1);
	target1 = MulAdd(nf3, MF4x4(-0.02567249, 0.18261379, 0.0078112325, 0.13831526, 0.022516627, 0.18176961, 0.022643182, 0.06482983, 0.32458714, 0.1415256, -0.40462464, -0.24058491, -0.1555331, -0.058481682, 0.08041805, 0.068204984), target1);
	target1 = MulAdd(ng3, MF4x4(0.08099861, -0.042113766, -0.012603856, -0.027247382, -0.09505534, 0.013861726, 0.16544205, -0.034136306, 0.013128467, 0.022156378, 0.021391893, -0.087280534, -0.18957394, -0.072840415, 0.1942784, -0.04479766), target1);
	target1 = MulAdd(nh3, MF4x4(0.13244309, 0.23072438, -0.10388544, 0.055465538, -0.06797261, 0.0813476, 0.03605633, -0.002648387, 0.04333517, 0.1233629, 0.004186724, -0.068296656, -0.076496966, -0.13608767, 0.13116132, -0.067895085), target1);
	target1 = MulAdd(ni3, MF4x4(-0.05193536, -0.057465453, 0.05165806, -0.092361026, -0.21779, -0.08789043, 0.056987524, -0.06524499, 0.02767333, 0.19836798, 0.104195744, -0.091015235, -0.10806183, -0.24305776, 0.12348048, 0.17889297), target1);
	
	MF4 target2 = { -0.0980025, 0.0163943, 0.07015813, -0.04460826 };
	target2 = MulAdd(a1, MF4x4(0.0007129529, -0.23268181, -0.055581614, -0.19489531, -0.119524784, 0.16052821, 0.08242202, 0.1274113, 0.06528547, 0.11359341, -0.13980822, -0.04566708, -0.03624654, -0.08533644, -0.14554873, -0.14973463), target2);
	target2 = MulAdd(b1, MF4x4(-0.010712782, 0.09223229, -0.06977767, 0.031998634, 0.2417462, -0.08404255, -0.067694396, -0.031915385, -0.08493046, -0.12639172, -0.12919787, 0.009066012, 0.027782273, -0.2951646, -0.1300083, -0.0673188), target2);
	target2 = MulAdd(c1, MF4x4(0.1325964, -0.051963683, 0.13291354, 0.02579481, -0.103561625, -0.041789595, 0.040783167, 0.047240548, -0.06668069, 0.020328876, 0.08887853, -0.02963949, -0.11168412, 0.1557154, -0.076105356, -0.1504038), target2);
	target2 = MulAdd(d1, MF4x4(-0.10317256, 0.07854648, 0.16037096, -0.0379184, 0.13046049, -0.024218671, 0.0822899, 0.08198137, 0.0012042717, -0.25853133, 0.046963938, -0.009453239, 0.09634527, -0.009770066, -0.12853295, -0.041695565), target2);
	target2 = MulAdd(e1, MF4x4(0.11125126, 0.09055589, 0.014031054, -0.02255056, -0.10394986, 0.10815357, -0.15813628, -0.01853368, 0.012419031, 0.0020822953, -0.010447686, -0.026241936, -0.03541712, 0.076329805, 0.20895265, 0.003645337), target2);
	target2 = MulAdd(f1, MF4x4(-0.12773241, -0.09765568, -0.14337096, -0.065751396, -0.0084745465, -0.052546956, -0.08200752, -0.08708897, -0.032195702, -0.036496297, 0.17860867, -0.068227254, 0.13200605, -0.13811241, -0.050324995, 0.16204447), target2);
	target2 = MulAdd(g1, MF4x4(-0.014216644, 0.057588127, -0.044320818, 0.062128264, -0.020399947, -0.05649115, -0.11319402, -0.038921937, 0.036813796, 0.5067311, 0.22060235, -0.0055661057, 0.23151882, 0.0050073536, 0.12176585, 0.0038464004), target2);
	target2 = MulAdd(h1, MF4x4(-0.0759528, 0.07477981, -0.06292785, -0.050053917, -0.06312128, -0.21425541, 0.0067035304, -0.06986801, 0.10586866, -0.12749328, -0.097493485, -0.003508852, 0.111684315, 0.18951331, -0.012068376, 0.036257178), target2);
	target2 = MulAdd(i1, MF4x4(-0.15544677, 0.047360703, -0.059747778, 0.0026973744, -0.00072011014, 0.15553303, 0.10704341, -0.02808549, -0.09962682, -0.044461366, -0.014757942, -0.06257519, 0.13504705, 0.030818086, -0.047969542, -0.12272446), target2);
	target2 = MulAdd(a2, MF4x4(0.02756638, 0.03870099, -0.078585416, -0.049957782, -0.16714093, -0.020673685, -0.0029932198, 0.08303188, 0.09362902, -0.32569888, -0.02152779, -0.039258134, -0.0024254394, -0.05215952, 0.103006296, -0.05561939), target2);
	target2 = MulAdd(b2, MF4x4(0.11232395, -0.4204378, -0.02948307, 0.058709357, 0.10122942, -0.01815637, 0.029027436, 0.045725007, -0.0019202912, -0.20451765, -0.06804741, -0.018427953, 0.026046682, -0.02693389, -0.1603317, -0.11198625), target2);
	target2 = MulAdd(c2, MF4x4(0.24319492, 0.114851095, -0.13692874, 0.07721465, 0.020316923, -0.08134961, 0.07356765, -0.054053787, -0.01942671, 0.22095704, 0.00965335, 0.018760502, 0.015964821, 0.086102456, 0.01024545, 0.043060217), target2);
	target2 = MulAdd(d2, MF4x4(0.3332833, -0.03617076, -0.06354161, 0.095067084, 0.20085002, -0.07980238, 0.042980768, 0.016795967, -0.09440837, -0.18057466, -0.062128007, -0.22770254, 0.03636945, 0.0749142, 0.0034359195, -0.024630694), target2);
	target2 = MulAdd(e2, MF4x4(0.18430449, -0.036511928, -0.053284973, 0.023835842, 0.23871118, 0.05792267, -0.0846795, -0.20196451, 0.03506874, 0.22829485, -0.28377455, -0.11413547, -0.10833865, 0.09104711, -0.13071612, 0.17202353), target2);
	target2 = MulAdd(f2, MF4x4(0.19165954, 0.22479524, -0.19884257, 0.08072162, -0.07574742, 0.13766298, -0.25755826, 0.084687516, -0.080061525, 0.25205615, -0.12677447, 0.08576974, 0.02831567, -0.009467821, 0.1970242, 0.20168954), target2);
	target2 = MulAdd(g2, MF4x4(0.0927734, 0.17610501, 0.14182864, 0.18800513, 0.05701441, 0.15469678, 0.11420199, -0.15377665, -0.08189125, -0.30660027, 0.033272292, -0.11340498, -0.08969095, 0.016946664, 0.03424574, -0.007572548), target2);
	target2 = MulAdd(h2, MF4x4(0.23636094, 0.15679167, 0.070221, 0.11989854, -0.18536362, 0.06250143, -0.086411804, 0.0099315215, -0.13320905, 0.2642356, 0.22141577, -0.009068583, -0.06783877, 0.16432028, 0.06672474, -0.051250096), target2);
	target2 = MulAdd(i2, MF4x4(-0.22000717, 0.15731241, 0.13043061, -0.042806733, 0.0031978998, 0.0668276, 0.08608138, 0.10850058, 0.22485662, -0.121448815, -0.014875905, -0.082832925, 0.056386247, -0.29444495, -0.05680645, -0.015010734), target2);
	target2 = MulAdd(a3, MF4x4(0.014549664, -0.0069613485, 0.11311649, 0.05610812, 0.04279884, -0.1020982, -0.03904751, -0.17636296, -0.05201923, 0.14244251, -0.059024896, -0.09463292, -0.09491209, -0.022265568, -0.0002296264, 0.03899329), target2);
	target2 = MulAdd(b3, MF4x4(0.048777632, 0.052673753, 0.13282603, 0.1795813, -0.028372066, 0.10603009, -0.4148765, -0.02000411, 0.053786337, -0.11523432, -0.31676108, -0.03830518, 0.022093901, 0.013758008, 0.106954776, -0.028646056), target2);
	target2 = MulAdd(c3, MF4x4(-0.06699817, -0.1724271, -0.036506936, 0.1153328, 0.015884517, -0.008503094, 0.028359545, -0.012168917, 0.030682955, 0.03541267, -0.03814948, -0.01124931, -0.05933562, -0.014424095, 0.027945189, -0.08810283), target2);
	target2 = MulAdd(d3, MF4x4(0.013294456, 0.19495966, 0.067234084, 0.15800472, 0.051711556, 0.17711255, 0.1140798, 0.10137737, -0.039499275, -0.04602223, -0.07446666, 0.0012073858, -0.08343905, -0.049277645, -0.078486815, -0.14566717), target2);
	target2 = MulAdd(e3, MF4x4(-0.09936533, 0.039390396, 0.13288753, 0.1920324, 0.13764949, -0.05153866, 0.06799814, 0.22350872, 0.27779356, -0.02206339, 0.19484605, -0.07821554, -0.07797821, 0.12577902, -0.084113464, 0.02873002), target2);
	target2 = MulAdd(f3, MF4x4(-0.10784442, -0.25804177, 0.1306632, 0.0046842564, 0.13917917, -0.03910364, 0.06410272, 0.019373003, -0.03459362, 0.080056466, 0.12915988, 0.14360592, 0.19040298, -0.0023102893, -0.04890759, -0.22537242), target2);
	target2 = MulAdd(g3, MF4x4(0.056570116, 0.13121127, -0.069638334, 0.11919738, -0.04740792, -0.16621193, -0.118925, 0.044869807, -0.010641902, -0.051522024, -0.057623643, 0.017528418, -0.07562933, 0.058253985, 0.05989836, 0.032996327), target2);
	target2 = MulAdd(h3, MF4x4(0.091301516, 0.08428476, -0.16445327, 0.11784904, -0.07030389, 0.022161584, -0.02548798, -0.08254805, -0.04188322, 0.24900444, 0.078174226, 0.20630752, -0.05519587, -0.10978986, 0.015350538, -0.12161702), target2);
	target2 = MulAdd(i3, MF4x4(-0.095735274, -0.10423386, -0.036254395, 0.10522458, -0.022615599, 0.085539706, -0.096113354, -0.23468721, 0.050746538, -0.31889522, -0.061264757, 0.11150476, -0.007024875, -0.11553085, -0.019223234, -0.23692535), target2);
	target2 = MulAdd(na1, MF4x4(-0.08454392, 0.21670897, -0.15095642, -0.060052566, 0.045126446, -0.030535553, -0.057765372, -0.027783932, -0.20350753, -0.2959993, 0.28601378, 0.028859718, 0.071787685, -0.027895963, -0.04723786, -0.10217129), target2);
	target2 = MulAdd(nb1, MF4x4(-0.012522398, -0.23370479, -0.019732006, -0.052036785, -0.33242345, 0.02026433, 0.26734874, 0.044760924, -0.09205539, 0.0888652, 0.27825877, -0.08912795, 0.019177845, 0.123587854, -0.10933388, -0.046620987), target2);
	target2 = MulAdd(nc1, MF4x4(-0.059484433, 0.107038036, -0.021947065, 0.03293247, 0.16987476, -0.02623603, -0.019537413, -0.02559007, -0.010399871, -0.028635733, -0.10141786, -0.10065662, -0.09635094, -0.107081525, 0.0060942136, 0.00018589811), target2);
	target2 = MulAdd(nd1, MF4x4(0.063847266, -0.07454534, -0.1174812, -0.14199455, -0.044613797, -0.081642054, 0.035214093, 0.009284773, -0.00707006, 0.28477952, -0.03298465, 0.074021146, -0.04033067, 0.17765698, 0.1553138, 0.08380522), target2);
	target2 = MulAdd(ne1, MF4x4(0.17025755, -0.118484, -0.21803714, -0.28715235, -0.13095933, -0.058834057, -0.18294802, 0.043152038, -0.058910713, 0.028670516, -0.0010361333, -0.025163988, 0.15223087, -0.016097538, -0.09638604, -0.01772858), target2);
	target2 = MulAdd(nf1, MF4x4(0.062441614, -0.016123693, 0.07818185, 0.022483543, -0.029692583, 0.035550565, -0.12624146, -0.04230702, -0.061506867, -0.014386596, 0.0115612615, 0.068888955, 0.067702614, 0.07322066, 0.024701316, -0.04806952), target2);
	target2 = MulAdd(ng1, MF4x4(0.026700316, -0.16510022, 0.050885063, -0.1332475, 0.019049475, -0.008760977, 0.04359399, 0.042262577, -0.05225198, -0.603255, -0.11838725, -0.017602438, -0.23949145, 0.07854026, -0.21954034, -0.07048147), target2);
	target2 = MulAdd(nh1, MF4x4(0.18560836, 0.18485062, -0.008109583, -0.0061953044, 0.067029685, 0.1231515, 0.00463641, -0.031592768, -0.24861142, -0.012609046, 0.14307153, -0.072264954, -0.0067704953, -0.18041459, 0.17362577, -0.06497389), target2);
	target2 = MulAdd(ni1, MF4x4(0.10974998, 0.06757753, 0.0377915, 0.057072945, 0.11128115, 0.0013228649, -0.044957817, -0.020252109, 0.06231163, -0.14761455, -0.027373059, -0.10220075, -0.22065234, -0.09441151, 0.052624665, 0.11956694), target2);
	target2 = MulAdd(na2, MF4x4(0.11292619, -0.10152602, 0.10526179, 0.06337831, 0.116172016, 0.16123155, -0.055104487, 0.13740757, -0.08778325, -0.028898785, -0.019357817, -0.08015077, -0.0066665406, -0.009120153, 0.051283117, 0.04456564), target2);
	target2 = MulAdd(nb2, MF4x4(0.19621657, 0.26922694, 0.03988996, 0.032870032, 0.057292562, 0.024405524, -0.11551687, -0.047686152, 0.13039996, 0.056989953, -0.065783806, 0.00033558672, -0.065978706, -0.00902148, 0.1314761, 0.064695716), target2);
	target2 = MulAdd(nc2, MF4x4(0.20266968, 0.11562562, 0.0044746934, 0.052361086, 0.0009612361, 0.01889979, -0.045194417, 0.085848965, -0.05785333, 0.07915189, 0.09685515, 0.016877603, 0.00037991733, 0.0003345007, -0.03782238, -0.0066707213), target2);
	target2 = MulAdd(nd2, MF4x4(-0.12730233, 0.037978236, 0.13999923, 0.033807464, -0.038275905, 0.012305192, 0.06438087, 0.08611617, 0.07200057, 0.13013837, 0.07331905, -0.0010762423, -0.038951423, -0.027457712, 0.014879732, 0.07803083), target2);
	target2 = MulAdd(ne2, MF4x4(0.12269098, -0.01707025, 0.099231675, 0.16366597, -0.0075668246, -0.12552746, 0.27712014, 0.22933815, 0.14837137, -0.07610271, 0.11374453, 0.026816925, 0.1011783, -0.043783583, -0.18852726, -0.2007988), target2);
	target2 = MulAdd(nf2, MF4x4(0.118183166, -0.45110446, -0.04326608, 0.10598517, 0.09142483, 0.004518412, 0.10789324, 0.18913233, -0.029293153, -0.10852763, 0.15762898, -0.021000696, 0.042484812, 0.030249448, -0.09806746, -0.15705605), target2);
	target2 = MulAdd(ng2, MF4x4(0.026257282, -0.017269222, -0.111170195, 0.12946244, 0.015408065, -0.14137042, -0.035408627, 0.073995374, 0.006271072, 0.14994001, -0.01258022, 0.019418288, 0.118502036, 0.035291567, 0.039203968, 0.018011976), target2);
	target2 = MulAdd(nh2, MF4x4(-0.11994321, 0.037343338, 0.034031454, -0.0947803, 0.2207995, 0.043690477, 0.06692838, 0.18297808, 0.03876948, -0.20762676, -0.13309777, 0.036189202, 0.0058699325, -0.1331377, -0.035574175, -0.091714606), target2);
	target2 = MulAdd(ni2, MF4x4(0.16173537, 0.030811697, -0.07565782, 0.17767896, 0.1574808, -0.0071866834, -0.031369448, 0.11762595, -0.304427, 0.04666128, 0.19467019, 0.13271074, -0.066108644, 0.17788546, 0.09988941, 0.0071199923), target2);
	target2 = MulAdd(na3, MF4x4(-0.07895499, 0.024530848, 0.07610484, 0.14991722, -0.071451046, 0.07360262, -0.10922367, 0.16261177, 0.14607567, -0.29037732, 0.19056098, 0.0017480691, 0.09447392, -0.097536966, -0.15283571, -0.2116911), target2);
	target2 = MulAdd(nb3, MF4x4(-0.090664506, 0.0026753773, -0.19803517, -0.0035921792, 0.08019641, -0.34822193, 0.03115303, -0.11561995, 0.047316786, 0.08521655, 0.30527622, -0.03627345, -0.10390178, 0.13096002, -0.11939941, 0.076553464), target2);
	target2 = MulAdd(nc3, MF4x4(-0.018057704, -0.012385826, -0.048699293, 0.057409126, 0.018623013, -0.13720913, -0.08693412, -0.035308264, 0.0048156027, 0.04298599, 0.20682096, 0.07020018, -0.19156799, -0.099447116, 0.11187527, -0.034651503), target2);
	target2 = MulAdd(nd3, MF4x4(-0.19674721, -6.47493e-05, -0.14616148, -0.16328155, -0.15329379, -0.13080211, -0.095063426, 0.10239187, 0.29591182, 0.061356615, 0.19931474, -0.062333517, 0.111954294, -0.024125673, 0.1727124, -0.100813806), target2);
	target2 = MulAdd(ne3, MF4x4(0.005782909, -0.048647407, 0.20534706, 0.04177472, -0.266937, 0.43962362, 0.03461612, 0.13415751, -0.21391335, -0.023739172, -0.382901, 0.1677018, 0.28375793, -0.10282615, -0.034843605, 0.00698951), target2);
	target2 = MulAdd(nf3, MF4x4(-0.0019446284, 0.07665739, 0.13404883, 0.1467204, -0.0588129, 0.19369206, -0.050641898, 0.018204086, 0.21603708, -0.22462276, -0.07930267, -0.2749562, 0.016131664, 0.2697215, -0.14661922, -0.026748048), target2);
	target2 = MulAdd(ng3, MF4x4(-0.15208562, -0.025413433, -0.031909585, 0.010184482, 0.09441715, 0.045736533, 0.0015301697, 0.055179585, 0.03623536, 0.08788274, 0.090822086, -0.041574936, -0.05593542, 0.013202262, -0.08831654, -0.117966585), target2);
	target2 = MulAdd(nh3, MF4x4(-0.06767938, 0.036391854, 0.024670534, 0.065553516, 0.124412306, -0.18261679, -0.11035609, -0.021725666, 0.06963895, -0.18845208, 0.05664083, -0.28461877, 0.12621799, -0.024473144, 0.060711104, 0.06137061), target2);
	target2 = MulAdd(ni3, MF4x4(0.030836413, -0.28885397, -0.0082618, -0.040858608, 0.121351525, -0.1581085, 0.04491976, 0.15929738, 0.011640548, 0.17567058, 0.18560362, -0.18308444, -0.091114745, -0.03191929, -0.0424641, 0.10603501), target2);
	
	MF4 target3 = { 0.038618144, 0.034658056, 0.04403221, 0.22010419 };
	target3 = MulAdd(a1, MF4x4(-0.044858746, 0.112747766, 0.11743049, -0.04397981, -0.15657529, -0.08594472, -0.077046685, 0.040047225, -0.16525316, 0.118806966, -0.06923664, -0.068862945, 0.13853838, 0.21202816, 0.03315427, 0.02810617), target3);
	target3 = MulAdd(b1, MF4x4(-0.08981965, 0.009795084, -0.17461349, 0.1293042, 0.13288464, -0.011990358, 0.045853514, 0.005478685, -0.039259993, 0.014204771, 0.049636167, -0.031643927, -0.081734784, 0.06592399, -0.075981714, -0.02715899), target3);
	target3 = MulAdd(c1, MF4x4(0.110248916, 0.0064891353, 0.022578653, -0.029814541, 0.12611644, -0.1477485, 0.013158434, -0.029419534, -0.049103256, 0.11351519, -0.07094292, 0.15175463, 0.023724427, -0.04979516, 0.01999463, -0.04911801), target3);
	target3 = MulAdd(d1, MF4x4(-0.072089985, 0.04007664, -0.024550471, -0.0041285334, -0.018247912, 0.046173554, -0.07198727, 0.017499885, -0.001033623, -0.19433345, 0.07760378, 0.049773693, -0.17062156, -0.02818212, 0.34907836, 0.0050598015), target3);
	target3 = MulAdd(e1, MF4x4(-0.06617895, -0.029447488, -0.08041051, 0.10391866, -0.3511068, 0.24072146, -0.07714093, -0.19329752, -0.090364814, -0.114312, -0.14665945, 0.14689237, 0.20671985, 0.015588815, -0.119754635, -0.056320462), target3);
	target3 = MulAdd(f1, MF4x4(-0.027388249, 0.104699664, -0.27179572, -0.02907286, 0.07357054, -0.0068755792, -0.13605821, 0.06462062, -0.093615666, -0.032704853, 0.038318764, -0.076435864, -0.0055633793, 0.046742633, 0.093529075, 0.18353659), target3);
	target3 = MulAdd(g1, MF4x4(0.06082767, 0.085872404, -0.093700096, 0.061194196, 0.06258653, 0.058643147, -0.07235859, -0.092823185, -0.010440827, 0.11255041, 0.0090868175, -0.007858298, 0.148384, -0.05526942, 0.19361623, 0.004099247), target3);
	target3 = MulAdd(h1, MF4x4(-0.06093948, -0.038310055, -0.082474135, -0.010680022, 0.0012025833, -0.092099264, 0.013127829, 0.027141726, 0.09983758, 0.03275215, 0.07185623, -0.19180898, -0.044681955, -0.024202297, -0.3165539, 0.0010588729), target3);
	target3 = MulAdd(i1, MF4x4(-0.060221963, -0.026948337, -0.06574486, 0.011485259, -0.06550075, 0.040276073, 0.025496457, -0.19623038, -0.065990366, -0.025713596, -0.040418267, -0.08788943, 0.076047935, -0.056114316, 0.15456654, -0.07788768), target3);
	target3 = MulAdd(a2, MF4x4(-0.067551315, 0.14745092, -0.054396585, 0.040545028, -0.17049932, 0.07036919, -0.13004121, -0.012877571, -0.09034833, 0.013381427, -0.07020307, 0.13269025, 0.04836113, 0.008816658, 0.06908017, 0.13488075), target3);
	target3 = MulAdd(b2, MF4x4(0.15872127, 0.046130676, 0.059947554, -0.01181087, 0.00031724942, -0.048350845, -0.009036753, -0.11157358, -0.07300833, 0.09947689, 0.20575939, -0.3546566, -0.059859008, 0.029647622, 0.13094904, -0.03154742), target3);
	target3 = MulAdd(c2, MF4x4(0.08560438, 0.1965193, -0.044979937, -0.13631731, 0.16646172, 0.09958199, 0.0074020037, 0.10672716, 0.15015182, 0.041704617, 0.063770875, 0.19410326, 0.008813034, 0.16075528, 0.08517037, 0.28283635), target3);
	target3 = MulAdd(d2, MF4x4(0.12114333, -0.08197629, 0.026583742, -0.060136575, 0.07713845, -0.004285971, 0.16490252, 0.26541123, 0.13636889, 0.14296104, -0.045894254, -0.007115691, 0.037731793, -0.014873664, -0.00571577, -0.009701031), target3);
	target3 = MulAdd(e2, MF4x4(0.2608233, -0.014971803, 0.15469527, 0.18899868, 0.06325761, 0.05273965, -0.021072507, 0.039343588, 0.049740855, 0.30912283, 0.1328661, 0.21406676, 0.013830919, -0.2128574, -0.020829424, 0.22456568), target3);
	target3 = MulAdd(f2, MF4x4(0.0642146, -0.14275537, 0.032388665, -0.12502304, 0.31260416, -0.026139492, 0.11060444, 0.014260357, -0.06373526, 0.15441616, -0.14077063, -0.03819972, 0.023418859, -0.065061435, 0.068000436, -0.10781963), target3);
	target3 = MulAdd(g2, MF4x4(0.039874375, -0.03544748, -0.09499391, -0.021817759, 0.2049574, 0.08219808, 0.044527993, -0.12810238, -0.07313955, -0.3041692, 0.074703164, 0.034242906, -0.08850236, 0.06280731, 0.07377995, 0.10382322), target3);
	target3 = MulAdd(h2, MF4x4(0.04350059, 0.21734618, 0.08675183, -0.055069674, 0.16317086, -0.000833345, -0.061599948, 0.025430895, -0.05566867, -0.07084767, -0.20808282, -0.08088132, -0.08246971, 0.019896548, 0.0011203124, -0.016212555), target3);
	target3 = MulAdd(i2, MF4x4(0.009271706, 0.10609657, 0.046975497, 0.016255897, -0.03132032, -0.026223281, -0.04218519, -0.089583725, 0.0011256885, -0.096725605, 0.13508168, 0.0070396424, 0.071279675, -0.009885292, 0.023429802, 0.04919291), target3);
	target3 = MulAdd(a3, MF4x4(-0.043223884, 0.18723601, 0.059270866, -0.038768277, -0.03307238, 0.045570783, -0.01494598, 0.12532744, -0.0633282, -0.009204529, -0.032864776, -0.012969925, -0.03190685, 0.048798896, 0.033872727, 0.059553478), target3);
	target3 = MulAdd(b3, MF4x4(0.087938786, -0.24108681, 0.14970978, -0.13961543, 0.0891246, 0.015723674, 0.05370719, -0.11110716, -0.00214365, 0.12866165, 0.108206935, 0.027394261, -0.15103427, -0.14690042, 0.035489313, -0.15238154), target3);
	target3 = MulAdd(c3, MF4x4(-0.0800077, -0.23219119, -0.08327999, -0.022596871, -0.021897404, 0.15777653, 0.017139765, 0.28121725, 0.024720678, 0.0976178, 0.078697845, 0.050298456, 0.0918896, -0.1709005, 0.001258526, -0.16952778), target3);
	target3 = MulAdd(d3, MF4x4(0.1855042, -0.1221885, 0.02704022, 0.00095695246, -0.014720871, -0.011397964, 0.009077131, -0.0658526, 0.0753248, -0.018622542, 0.21117687, 0.009595839, -0.014185466, -0.12340562, 0.20756626, 0.1002926), target3);
	target3 = MulAdd(e3, MF4x4(0.03998379, -0.14931168, 0.43595135, -0.18249772, -0.014348168, 0.17039725, -0.54961896, 0.23570935, -0.0961725, -0.08736501, -0.48726758, -0.11515001, -0.03716486, -0.17436725, 0.3894316, -0.012835015), target3);
	target3 = MulAdd(f3, MF4x4(-0.15397331, 0.021657735, -0.054806687, 0.1541452, -0.12548985, 0.0934218, 0.20914574, 0.14777465, -0.0670766, 0.11853072, -0.012987691, -0.020369543, 0.09420477, -0.17689225, 0.109701715, -0.046027176), target3);
	target3 = MulAdd(g3, MF4x4(-0.02231296, 0.14284018, -0.14968887, 0.13387628, 0.06886712, -0.11273641, 0.03278117, -0.13931367, -0.07073904, -0.05791193, 0.0074532703, 0.057605404, -0.007830725, 0.16091831, -0.16650262, 0.1647855), target3);
	target3 = MulAdd(h3, MF4x4(-0.057878133, -0.12752692, -0.12909345, 0.07441648, 0.027899493, -0.018735388, -0.07586787, -0.048344534, -0.11736236, 0.015326167, -0.103591904, -0.17694342, -0.049772773, 0.015765708, -0.1248672, 0.26354307), target3);
	target3 = MulAdd(i3, MF4x4(-0.18220314, 0.0046032136, -0.2081131, 0.03723796, 0.08844814, -0.01369978, 0.053207412, -0.08312182, -0.062071536, -0.067955784, 0.004774782, -0.06925075, -0.059406135, 0.06784051, -0.09814774, -0.11124358), target3);
	target3 = MulAdd(na1, MF4x4(-0.27883962, 0.12152088, -0.24405631, 0.0027260163, 0.19775666, 0.058938242, -0.05956473, -0.10816854, -0.0071739377, -0.4144036, 0.068261996, -0.2445757, -0.23093198, -0.17691095, 0.038170703, -0.013878705), target3);
	target3 = MulAdd(nb1, MF4x4(0.063041806, 0.2538589, -0.11473429, 0.01619935, -0.08354722, -0.04798535, 0.02354034, 0.033864528, -0.055874173, -0.16368376, -0.02903178, -0.12477576, 0.02629324, 0.034359895, 0.08272036, 0.06732605), target3);
	target3 = MulAdd(nc1, MF4x4(-0.15553482, 0.0060790586, -0.05535005, 0.0132087935, -0.03520144, 0.023434987, 0.031604007, -0.09385124, -0.15015934, -0.13401696, -0.005520488, -0.08600875, -0.04346026, -0.07434181, -0.05771243, 0.03339138), target3);
	target3 = MulAdd(nd1, MF4x4(-0.13035898, -0.06444063, -0.12604833, -0.1291162, 0.0002854935, 0.0011192479, 0.03285, -0.0718767, -0.0048345756, 0.23910385, -0.13370244, -0.27723455, 0.2173459, -0.09477723, -0.2785804, -0.089392334), target3);
	target3 = MulAdd(ne1, MF4x4(0.19831544, -0.04623001, 0.11013904, 0.07203301, 0.006143421, -0.059177686, -0.5040003, 0.12711781, 0.18126795, 0.13216637, 0.15124142, 0.0053686183, 0.090513304, 0.10542994, 0.34392425, 0.016424375), target3);
	target3 = MulAdd(nf1, MF4x4(-0.16124019, 0.09191821, -0.04369587, -0.21306747, -0.16233422, 0.031122763, -0.012612568, -0.016409902, -0.09023912, 0.013649212, -0.16627215, -0.05366447, 0.10274318, 0.086314775, 0.08027116, 0.08462481), target3);
	target3 = MulAdd(ng1, MF4x4(-0.14453822, 0.024520764, -0.0071830307, -0.13206398, -0.072472885, -0.10329967, 0.1636545, 0.016468262, -0.013051184, -0.12824146, 0.03824098, -0.22003986, -0.10416448, 0.0039071296, -0.34092218, 0.10734566), target3);
	target3 = MulAdd(nh1, MF4x4(-0.072179504, 0.006203091, -0.018925803, -0.1199396, -0.084528126, 0.094925165, -0.11961369, -0.054626215, -0.117074564, -0.04484073, 0.040342934, 0.13213676, -0.0064397864, 0.10155662, 0.20097142, -0.2804305), target3);
	target3 = MulAdd(ni1, MF4x4(0.087270446, 0.078806184, -0.05655386, 0.06486903, 0.034370087, 0.0036874234, 0.003311713, -0.10504396, 0.028166316, -0.22845218, 0.017909897, -0.2130404, -0.050013334, -0.117276974, -0.06318294, -0.0037857178), target3);
	target3 = MulAdd(na2, MF4x4(0.08871242, 0.075167455, -0.039373945, 0.00051754323, 0.07687967, -0.06586344, -0.15153599, 0.0018507856, -0.017242108, -0.054329462, 0.051372115, 0.0033961546, 0.06248249, -0.06631481, 0.05806025, -0.021996895), target3);
	target3 = MulAdd(nb2, MF4x4(0.09424522, 0.073743, -0.0017127816, 0.0033512171, -0.11385974, 0.014514997, -0.0068160114, 0.12540759, 0.106560245, -0.049447417, 0.111991346, -0.06375654, -0.011610938, -0.024543937, -0.12136444, 0.1091816), target3);
	target3 = MulAdd(nc2, MF4x4(0.2360247, 0.051082112, 0.063963845, -0.19552353, -0.12502095, -0.043954436, -0.029264912, -0.107425205, -0.104991466, 0.1546093, -0.019506395, 0.102938086, -0.054183662, 0.010583785, -0.080395944, -0.08370572), target3);
	target3 = MulAdd(nd2, MF4x4(0.15028444, 0.031050628, 0.04759701, -0.076938786, -0.09843708, 0.013380048, -0.07036618, -0.18517768, -0.24299946, 0.0074256407, 0.12335329, 0.008296356, -0.14130129, 0.089567006, -0.066212654, -0.019249886), target3);
	target3 = MulAdd(ne2, MF4x4(0.21793036, 0.046704203, -0.26442486, 0.036775246, 0.011823214, 0.035270307, 0.27286708, -0.041062694, 0.1929, -0.18686813, 0.033577543, -0.23847485, -0.04342215, 0.20992972, -0.31331903, -0.3476763), target3);
	target3 = MulAdd(nf2, MF4x4(0.2605603, 0.045636464, 0.078897774, -0.02860065, -0.17690817, -0.022998778, -0.078985356, -0.08182311, -0.02665034, 0.051768366, 0.14886487, 0.08579571, 0.13346, -0.10001264, 0.04904008, 0.14541489), target3);
	target3 = MulAdd(ng2, MF4x4(0.106186725, -0.0063438504, 0.07265258, -0.036121733, -0.13984898, 0.003038981, -0.016125364, 0.13680565, -0.057302903, -0.12963718, -0.0030335293, -0.021742221, -0.006363557, -0.101099625, 0.095220365, 0.033486642), target3);
	target3 = MulAdd(nh2, MF4x4(0.094589375, -0.044164203, -0.15519938, -0.02010285, -0.094102144, -0.06617603, -0.06663444, -0.036653996, -0.018485812, 0.04307366, 0.23020254, 0.17289902, 0.11927716, 0.059777882, 0.16321822, -0.17249192), target3);
	target3 = MulAdd(ni2, MF4x4(0.17176881, -0.05145481, 0.058537252, 0.07365525, 0.17615119, -0.0008998237, 0.20070761, 0.08091997, -0.22727549, 0.040356588, -0.19447488, 0.019409144, -0.094837844, 0.029385263, 0.06778661, 0.15896504), target3);
	target3 = MulAdd(na3, MF4x4(-0.11452088, -0.024284642, -0.04490299, -0.020004421, 0.050837193, -0.19884948, 0.0027391468, -0.04909611, 0.10565033, 0.046887845, 0.15566911, -0.04677708, -0.1617592, -0.1090753, 0.021104805, 0.12100669), target3);
	target3 = MulAdd(nb3, MF4x4(0.0796837, 0.2143031, 0.15130435, 0.11013741, 0.02859385, -0.23182273, -0.01307099, 0.17366518, 0.067062154, -0.13214251, -0.0359161, -0.22044878, -0.065245375, -0.12085723, -0.0058068414, -0.05868892), target3);
	target3 = MulAdd(nc3, MF4x4(0.05886354, 0.04594631, 0.0035692437, 0.0043173125, -0.0058938325, -0.12315084, 0.009706764, 0.029205475, 0.02275545, -0.030235367, -0.010946894, -0.1160915, -0.24663799, 0.021396592, -0.08312792, 0.035279196), target3);
	target3 = MulAdd(nd3, MF4x4(-0.18054669, -0.03518381, 0.048470423, -0.0056507597, 0.03240578, 0.12688184, -0.09667544, 0.04029143, 0.03038166, 0.10955508, -0.2918326, -0.08950494, -0.06969353, 0.20913015, 0.13051425, -0.12262561), target3);
	target3 = MulAdd(ne3, MF4x4(0.11774238, 0.107279345, 0.09160909, -0.12901367, -0.063854314, 0.012220096, 0.1428603, -0.03274951, -0.16071229, 0.16923961, 0.09850307, 0.3375513, 0.17089152, 0.1066977, -0.11292511, 0.07839456), target3);
	target3 = MulAdd(nf3, MF4x4(0.06309776, -0.062669575, 0.12810674, -0.22764897, 0.05594526, -0.3354947, -0.271324, -0.1370599, 0.0019311982, -0.20568445, 0.14663076, -0.10399025, -0.11092913, 0.13635515, -0.046688963, 0.18119682), target3);
	target3 = MulAdd(ng3, MF4x4(0.06247405, -0.070577376, -0.049723163, 0.20372438, 0.059769955, -0.15753393, 0.08755224, -0.16705483, 0.043191068, 0.13503598, -0.06549854, -0.08262152, -0.036690235, -0.017480936, 0.0087178415, 0.124511525), target3);
	target3 = MulAdd(nh3, MF4x4(-0.103790514, -0.062080752, -0.04171218, -0.22629078, 0.058754075, 0.010274649, 0.012631916, 0.0884306, 0.10843063, 0.11566254, 0.16639906, -0.05603101, 0.03344291, -0.009285547, 0.22062606, -0.18537858), target3);
	target3 = MulAdd(ni3, MF4x4(-0.010970425, 0.06433602, -0.010908282, 0.21255766, -0.124487005, -0.18626499, 0.017554395, 0.022440141, -0.043080032, 0.13329363, -0.019777333, -0.13920292, -0.057512637, -0.07950961, 0.0008059128, 0.08286962), target3);

	tex1[gxy] = target1;
	tex2[gxy] = target2;
	tex3[gxy] = target3;
}

//!PASS 4
//!DESC Conv-4x3x3x24
//!IN tex1, tex2, tex3
//!OUT tex4, tex5, tex6
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass4(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = tex1.SampleLevel(sam, pos, 0);
	MF4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = tex2.SampleLevel(sam, pos, 0);
	MF4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    MF4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = tex3.SampleLevel(sam, pos, 0);
	MF4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target1 = { -0.034046266, 0.030718531, 0.029500093, -0.007484251 };
	target1 = MulAdd(a1, MF4x4(-0.19656715, 0.073294915, -0.019779518, 0.021025823, 0.15261759, 0.04309221, -0.1493544, 0.049283743, -0.0905334, 0.1813188, -0.0016973419, 0.15697837, 0.13670535, -0.11242918, -0.013915669, -0.13730156), target1);
	target1 = MulAdd(b1, MF4x4(0.04107699, 0.17384163, -0.096351616, 0.04331655, -0.23204431, 0.25804806, -0.04034741, 0.17473252, 0.2747926, -0.04826532, 0.06581498, -0.01747519, 0.16690566, 0.18259898, 0.051713206, -0.11371784), target1);
	target1 = MulAdd(c1, MF4x4(0.09295699, -0.02639465, -0.07067535, -0.055101186, 0.049066454, -0.1348934, -0.010201892, 0.076446265, -0.17203535, 0.094379045, -0.05279342, -0.06568022, 0.019863818, 0.048707128, -0.001194968, 0.08657796), target1);
	target1 = MulAdd(d1, MF4x4(0.075812176, -0.14860412, -0.07091005, 0.027131502, -0.037916575, -0.08786051, 0.12747246, 0.07358627, -0.17530513, 0.01687204, -0.02315926, -0.0475825, 0.10233608, 0.11752665, -0.066707715, -0.02696408), target1);
	target1 = MulAdd(e1, MF4x4(-0.16265862, 0.07163909, 0.029001605, 0.023125717, -0.45108593, 0.31734392, 0.18262424, -0.16254611, -0.13591787, -0.34079695, 0.15933561, -0.11768856, -0.20831986, -0.2617357, -0.06293675, -0.21008867), target1);
	target1 = MulAdd(f1, MF4x4(0.03834222, 0.11669165, -0.14289354, 0.19205377, 0.034326866, 0.11611292, -0.35397327, -0.22060747, -0.004148329, 0.16584732, 0.021622034, -0.026690945, -0.002915367, -0.0025648596, 0.098647386, 0.010004625), target1);
	target1 = MulAdd(g1, MF4x4(0.12951577, -0.12372639, 0.050420888, -0.059468318, 0.06579213, -0.20325322, -0.1699444, 0.019064313, -0.035931777, -0.020957012, 0.0027909358, 0.007493282, 0.0004133846, 0.034073114, -0.038953777, 0.065847114), target1);
	target1 = MulAdd(h1, MF4x4(0.044652946, 0.04014948, -0.11211438, -0.009610841, 0.04416661, 0.007001935, 0.23747365, 0.051566597, 0.08833828, 0.08240841, 0.11842664, -0.053376306, -0.24712811, 0.086317725, 0.0038018306, 0.058020968), target1);
	target1 = MulAdd(i1, MF4x4(-0.14782053, -0.02475428, -0.17784445, -0.024647312, 0.1743018, 0.06606081, 0.056824066, 0.14064185, 0.06063915, -0.04583706, 0.101063475, -0.043567337, -0.07165717, 0.03192861, 0.056516238, -0.011080173), target1);
	target1 = MulAdd(a2, MF4x4(0.15754054, -0.022155577, -0.08209624, -0.0014304873, -0.29201108, 0.08677429, 0.2264655, 0.047244307, -0.048876513, -0.0927597, -0.045443505, 0.20207925, -0.12566972, 0.1404151, -0.024384655, -0.032324787), target1);
	target1 = MulAdd(b2, MF4x4(-0.2863662, 0.08409054, 0.060920034, -0.05120718, 0.20190823, -0.05651237, 0.16887607, 0.0733604, -0.14424925, -0.06001526, 0.030432044, 0.14361487, 0.02771769, 0.030591695, -0.029078443, -0.048318565), target1);
	target1 = MulAdd(c2, MF4x4(0.00791873, -0.09765571, 0.00042280424, 0.09341729, -0.22752157, 0.23591608, 0.0051302435, -0.077698976, 0.10737567, -0.23836324, -0.067966945, 0.2257328, -0.004849654, -0.036767352, 0.13280262, -0.07600507), target1);
	target1 = MulAdd(d2, MF4x4(0.05473653, -0.1915318, -0.00626306, -0.13441068, 0.088244185, -0.31077763, -0.010066507, -0.091302134, 0.11164262, 0.12096589, -0.0605778, 0.1308392, -0.010200418, -0.024670156, 0.09293591, 0.028182708), target1);
	target1 = MulAdd(e2, MF4x4(0.053266037, 0.29016244, 0.19542074, -0.20729323, 0.1344162, -0.21329224, 0.20277289, -0.08846336, -0.114185594, 0.206921, -0.0006008467, 0.0205045, -0.282864, -0.22293371, -0.17658198, 0.20596933), target1);
	target1 = MulAdd(f2, MF4x4(-0.03932726, 0.080170035, -0.07711416, -0.29913354, -0.06824731, -0.061843343, -0.13042153, -0.19094346, -0.11703233, 0.06704312, -0.049862698, 0.1466207, -0.0011674183, 0.080236584, -0.06675328, 0.13961533), target1);
	target1 = MulAdd(g2, MF4x4(-0.022837833, 0.0019198474, 0.0236172, 0.07043625, 0.12661463, 0.001672872, 0.06307569, -0.13343741, 0.17860405, -0.19384168, 0.079231955, 0.032781634, -0.15199795, 0.13594992, 0.070164844, -0.060025793), target1);
	target1 = MulAdd(h2, MF4x4(-0.12844789, -0.025733668, 0.020556241, -0.12541436, 0.14400893, -0.03860052, 0.059304774, -0.1786852, -0.18367065, -0.2374019, 0.1148333, -0.1065858, 0.119285814, 0.016301462, 0.028108267, 0.04623708), target1);
	target1 = MulAdd(i2, MF4x4(-0.12543629, 0.011575056, -0.037424013, 0.09024941, -0.029061148, -0.08703052, -0.0024641235, -0.105915934, -0.044543535, 0.06887956, -0.04743747, -0.05494799, 0.031339128, -0.034284074, -0.121141724, 0.053843208), target1);
	target1 = MulAdd(a3, MF4x4(-0.2666571, 0.09093467, -0.012503428, -0.035125565, 0.032127958, -0.042863887, -0.08649192, -0.015927156, 0.08400246, 0.01662268, 0.034715075, -0.00908548, 0.045443024, -0.06893885, -0.074183375, -0.00844849), target1);
	target1 = MulAdd(b3, MF4x4(0.18397407, -0.10994183, 0.086410955, -0.008634828, -0.02632997, 0.019804388, 0.048724968, 0.18321893, -0.017287457, 0.18407986, -0.08789994, 0.23315573, 0.17696501, 0.021334525, -0.01854696, -0.19259432), target1);
	target1 = MulAdd(c3, MF4x4(-0.17279425, 0.040277172, 0.045758635, 0.112192474, -0.1307268, -0.08761701, -0.17986964, 0.08374649, -0.14858364, 0.09763281, -0.08468596, 0.07319079, 0.035000093, 0.15952845, 0.07624351, -0.06327825), target1);
	target1 = MulAdd(d3, MF4x4(0.08170692, -0.08774166, -0.06705707, 0.0831711, -0.08875457, 0.2449888, -0.14047605, 0.121503554, 0.12618999, 0.02661774, 0.074408755, 0.008565884, 0.0066377656, 0.07707615, 0.0047538104, -0.09728628), target1);
	target1 = MulAdd(e3, MF4x4(-0.07823108, 0.26807916, -0.1287439, 0.122834176, -0.19714594, -0.4942738, 0.10632799, 0.15897664, -0.49854252, -0.53525513, -0.022803375, 0.009074036, 0.11774684, 0.031480465, -0.09894373, -0.021954348), target1);
	target1 = MulAdd(f3, MF4x4(0.12955268, -0.19441509, 0.09120095, 0.011785061, 0.051540542, 0.04758044, 0.04755938, 0.038364667, 0.13298763, 0.10289183, 0.020991595, -0.081097506, 0.034405325, -0.11437959, -0.12480481, -0.065397635), target1);
	target1 = MulAdd(g3, MF4x4(0.014650886, -0.013576367, 0.07512687, -0.12763637, -0.08968091, 0.10528254, -0.0038084937, 0.15035029, -0.012962306, 0.05691601, 0.0812368, -0.03788991, -0.023433529, -0.06713006, -0.11560342, -0.016785484), target1);
	target1 = MulAdd(h3, MF4x4(-0.08841537, -0.06776095, -0.047271274, 0.019514252, -0.015769644, 0.13348323, -0.10441001, 0.11785519, 0.12106464, 0.12203113, 0.12842509, -0.060258504, -0.05513583, -0.11723075, 0.16473113, 0.011207402), target1);
	target1 = MulAdd(i3, MF4x4(0.09194844, 0.090906195, 0.0073818006, -0.2054332, 0.10706456, -0.077387035, -0.10359331, -0.027400512, 0.03793532, -0.14690651, -0.093249865, 0.050878726, -0.050666083, -0.048249774, -0.029831426, -0.005122034), target1);
	target1 = MulAdd(na1, MF4x4(-0.020260984, 0.03831684, 0.03624668, 0.05309828, 0.21425313, 0.04278761, -0.05036095, -0.11595718, -0.040695038, -0.053862657, 0.04097228, -0.14234553, 0.14645652, 0.0005556175, 0.037454158, -0.0834163), target1);
	target1 = MulAdd(nb1, MF4x4(-0.06560231, 0.035083, 0.00515858, -0.078715794, 0.18701494, -0.13166098, 0.039057065, -0.0039464743, -0.060099427, -0.0197617, -0.03425236, -0.034474097, -0.13463692, -0.14687043, -0.07386183, 0.15877718), target1);
	target1 = MulAdd(nc1, MF4x4(-0.17528099, 0.26496586, -0.026784442, 0.02301352, -0.19334768, 0.058255307, 0.084549166, 0.05813938, 0.14634804, 0.021594442, 0.09401384, 0.048137084, -0.027516525, 0.03725506, -0.03902931, -0.05822093), target1);
	target1 = MulAdd(nd1, MF4x4(-0.08095242, -0.0700387, 0.1565957, -0.12318027, 0.0009593411, 0.083975986, -0.1672044, 0.07669263, 0.15444267, -0.2405765, -0.0999547, -0.0113806585, -0.086394556, -0.068187304, 0.022804303, 0.033642158), target1);
	target1 = MulAdd(ne1, MF4x4(0.1742647, -0.1139802, 0.03773566, 0.24217185, 0.14553599, -0.13462967, -0.15343545, -0.07004845, 0.09719264, 0.40018603, 0.012584803, 0.20194948, 0.23837751, 0.14372137, 0.018450642, 0.19864424), target1);
	target1 = MulAdd(nf1, MF4x4(-0.01977227, -0.01629232, -0.11582299, 0.07435107, 0.04089713, -0.013857991, 0.22446491, 0.016065463, -0.042079967, 0.0170577, 0.040578466, -0.038618524, -0.05470756, -0.115140095, -0.065542445, 0.14684047), target1);
	target1 = MulAdd(ng1, MF4x4(-0.037176184, 0.090253, 0.14125483, -0.08512404, -0.051651485, 0.099631414, 0.10343597, -0.0061565666, 0.041628633, 0.09307784, -0.090136886, -0.009559773, -0.03024448, -0.031733215, -0.07797126, 0.055322547), target1);
	target1 = MulAdd(nh1, MF4x4(-0.1050144, -0.03270817, 0.26327172, -0.28404585, -0.03861458, 0.048381314, -0.15304287, -0.0042754454, -0.10290137, -0.24198222, -0.12365528, 0.095550224, 0.15594007, -0.02852183, 0.021433152, 0.007750503), target1);
	target1 = MulAdd(ni1, MF4x4(0.14963464, 0.036146436, 0.06857592, -0.03860567, 0.014884097, 0.07543522, 0.024485901, 0.035711233, -0.003450604, -0.0597103, 0.024015842, -0.001213529, -0.058722682, 0.01725032, -0.12181248, -0.008058613), target1);
	target1 = MulAdd(na2, MF4x4(0.071817815, 0.041531287, 0.014643306, 0.16291411, 0.26480407, -0.17182025, -0.010588466, 0.105062984, 0.030210229, -0.04829373, -0.036531925, 0.047632486, -0.2479769, 0.045298517, 0.13192376, 0.033759), target1);
	target1 = MulAdd(nb2, MF4x4(0.08769319, -0.0032485086, 0.022313096, 0.17629139, -0.29785547, 0.17973061, 0.033340637, 0.15138951, 0.016324213, -0.052774195, 0.03140277, 0.049657557, -0.1042336, -0.048986793, 0.11604845, 0.027282678), target1);
	target1 = MulAdd(nc2, MF4x4(0.06349052, 0.020287551, 0.041792236, -0.064779855, -0.19809574, 0.1296112, -0.31961703, -0.10329236, -0.06304219, 0.1266601, 0.047558576, -0.01599766, -0.0840006, 0.110553645, -0.17114124, -0.092702754), target1);
	target1 = MulAdd(nd2, MF4x4(-0.07258822, 0.33649316, 0.03007162, 0.122297324, -0.0035460228, -0.031201044, 0.12168557, -0.029285375, -0.0809431, -0.12167306, 0.07364419, 0.028837958, -0.0045297747, -0.0601046, 0.01811243, -0.09054316), target1);
	target1 = MulAdd(ne2, MF4x4(-0.25255457, -0.22574474, -0.34320608, 0.11290973, -0.26090237, 0.040196825, 0.13508338, 0.029482007, -0.10183512, -0.08112251, -0.11552506, 0.19293801, 0.3495816, 0.18543391, 0.06588066, -0.04709665), target1);
	target1 = MulAdd(nf2, MF4x4(0.084513545, -0.15674965, -0.0008406949, 0.090281285, 0.2712172, -0.116089135, -0.015765252, -0.117886744, 0.09920849, 0.029833876, -0.095729664, -0.027886158, 0.075155556, -0.046650156, -0.0065415367, -0.010066504), target1);
	target1 = MulAdd(ng2, MF4x4(0.045017265, -0.032798514, 0.015228568, -0.10716174, 0.12533835, -0.18279125, 0.04248092, -0.19403161, -0.037150033, 0.051052798, 0.064987876, -0.0012054371, 0.17646495, -0.08559015, -0.030268986, -0.0110990135), target1);
	target1 = MulAdd(nh2, MF4x4(0.2270626, 0.07908034, 0.10131884, -0.04477681, 0.012331784, -0.0066530495, 0.11152835, -0.011538218, 0.18025607, 0.28347188, -0.061317418, 0.140885, -0.12165267, -0.015358079, -0.1509724, 0.10532319), target1);
	target1 = MulAdd(ni2, MF4x4(0.090888165, 0.051266413, 0.00032922614, 0.10080883, 0.25410557, 0.01401413, -0.08648295, -0.18689357, 0.06347326, -0.12212378, -0.047608927, 0.19060975, 0.030654645, -0.0008587347, 0.056551795, -0.075159475), target1);
	target1 = MulAdd(na3, MF4x4(0.18279178, -0.043672565, -0.045675628, 0.08589114, -0.09798812, 0.13952787, 0.020468095, 0.019159447, -0.037739623, -0.031772856, 0.05684188, -0.0027250764, 0.15689476, -0.048730828, 0.07862422, -0.050529804), target1);
	target1 = MulAdd(nb3, MF4x4(-0.16031522, 0.032964543, -0.04876928, 0.02347113, -0.15290083, -0.2451878, 0.052881993, -0.08540753, -0.07177217, -0.15992549, 0.0651776, -0.08932986, 0.1767438, 0.056059174, -0.0576956, -0.09165988), target1);
	target1 = MulAdd(nc3, MF4x4(0.13147484, -0.0570967, -0.11560189, 0.05509382, -0.0150885545, 0.09640748, 0.014165965, 0.20704748, 0.030164357, -0.1082378, 0.024942307, -0.08219035, 0.124670975, -0.052641235, -0.0226715, -0.027526885), target1);
	target1 = MulAdd(nd3, MF4x4(-0.23702182, 0.23504741, -0.0055127465, -0.05391814, -0.033541497, -0.004652474, 0.018886803, -0.03751877, -0.17091194, 0.023785884, 0.04066812, -0.060029395, -0.041414294, 0.01717907, -0.03250043, 0.06307296), target1);
	target1 = MulAdd(ne3, MF4x4(0.13159078, -0.21431974, 0.18132871, -0.057554632, 0.21089126, 0.2748356, 0.09672305, -0.06376276, 0.533338, 0.44528118, 0.005919547, -0.04472009, 0.057801563, 0.089425854, 0.00619256, -0.1724294), target1);
	target1 = MulAdd(nf3, MF4x4(0.092838384, 0.10023682, 0.024242302, -0.17375132, 0.078034006, -0.19451837, -0.15501493, -0.13293402, -0.18569629, -0.19058825, -0.00096012745, 0.046021726, 0.10088386, 0.08519642, 0.13217524, 0.13243376), target1);
	target1 = MulAdd(ng3, MF4x4(-0.027395649, 0.023635123, -0.010267926, 0.17099325, 0.12437585, -0.1249303, -0.06419651, -0.021422816, 0.17196923, -0.22701795, 0.015808482, -0.14445387, -0.05460773, -0.003828314, -0.18222629, -0.048698075), target1);
	target1 = MulAdd(nh3, MF4x4(-0.013598317, 0.122526735, -0.02577042, 0.08744144, -0.08979224, 0.1286411, -0.05883814, -0.12919591, -0.050816238, -0.15597601, -0.115631886, -0.12070838, 0.11360469, -0.02584839, -0.1560333, 0.011274217), target1);
	target1 = MulAdd(ni3, MF4x4(0.080101736, -0.1330538, 0.021211144, 0.1438211, 0.01772601, 0.11148414, 0.13287805, 0.15081206, -0.012008585, 0.06793454, 0.03773184, -0.032694455, 0.10249589, 0.026878785, -0.12141799, -0.09203301), target1);
	
	MF4 target2 = { -0.03760731, -0.0242485, -0.021933366, 0.027489811 };
	target2 = MulAdd(a1, MF4x4(0.07053637, -0.13757081, 0.083475806, 0.047742493, 0.17072907, 0.03391062, -0.06359729, -0.087144814, 0.13410439, 0.0766006, -0.07466357, 0.020072024, 0.070759356, -0.07371517, -0.002268697, -0.01926168), target2);
	target2 = MulAdd(b1, MF4x4(0.044688217, 0.11774826, -0.042388003, -0.07989108, -0.1972503, 0.050274227, 0.016185008, -0.058738116, -0.19790363, -0.05735989, -0.047189124, -0.14251053, 0.020062871, 0.03521658, 0.08752947, -0.23372267), target2);
	target2 = MulAdd(c1, MF4x4(0.25029907, -0.045921884, 0.09080718, 0.016080718, -0.084881, -0.11112135, 0.06381888, -0.11366214, -0.09134574, 0.078322254, 0.08380223, -0.04663652, 0.079209715, 0.019024234, -0.13660747, 0.014792784), target2);
	target2 = MulAdd(d1, MF4x4(-0.32267445, -0.14074866, -0.07469012, -0.16251983, 0.03330349, 0.11198752, 0.031585973, 0.022867791, 0.018227417, -0.20173706, 0.06353359, 0.20548727, -0.028305814, 0.100267045, 0.10572279, 0.026997928), target2);
	target2 = MulAdd(e1, MF4x4(-0.098945044, 0.05311362, -0.19431336, -0.04678114, -0.4157369, -0.042450808, -0.044422694, 0.12376175, -0.23616472, 0.28038284, 0.14551993, 0.09350881, -0.16741902, -0.038471445, 0.01986414, -0.17471582), target2);
	target2 = MulAdd(f1, MF4x4(0.14448655, -0.019295415, -0.10982297, -0.06357956, 0.2369261, 0.032228198, -0.11679823, -0.05587635, 0.04871467, -0.0137740765, -0.07519058, -0.18964961, -0.026393183, -0.01974549, 0.06976226, -0.016081909), target2);
	target2 = MulAdd(g1, MF4x4(-0.0137074115, -0.079286255, -0.12312942, -0.018789625, -0.013921108, -0.0020071631, -0.054753337, 0.017963797, 0.2555907, 0.032142516, -0.24176246, 0.16440704, -0.017065119, 0.051031727, -0.1010096, -0.034884788), target2);
	target2 = MulAdd(h1, MF4x4(-0.060335524, 0.074403755, -0.03940425, -0.06947243, 0.063064545, 0.0003786891, 0.042550083, 0.014553617, -0.18506478, 0.14322414, 0.09673403, 0.19324619, 0.13711761, 0.14422627, -0.26975414, 0.1770873), target2);
	target2 = MulAdd(i1, MF4x4(0.0749963, -0.0043254187, 0.007601493, 0.044143427, 0.07984297, -0.13162711, -0.0021585606, -0.009246663, 0.20984007, -0.046367027, -0.09268187, 0.14495128, -0.12562644, 0.1836961, -0.009291084, 0.09893831), target2);
	target2 = MulAdd(a2, MF4x4(-0.04764635, 0.0771012, -0.06254785, 0.049306013, -0.1309074, -0.16724089, 0.064103976, 0.029477306, -0.15803875, -0.018528668, 0.008828626, -0.06195826, -0.06321009, -0.08585472, 0.062971294, -0.09935699), target2);
	target2 = MulAdd(b2, MF4x4(0.09090366, 0.035622045, -0.07656447, 0.047136262, -0.12315156, -0.06781894, -0.16850029, -0.08679722, 0.031337507, -0.034778163, -0.0034067088, 0.060668938, 0.025843577, -0.13783671, 0.07269251, -0.016900677), target2);
	target2 = MulAdd(c2, MF4x4(0.0440054, 0.0036595238, 0.008771493, 0.030218529, -0.027555777, -0.06657435, -0.055236634, -0.033271316, -0.13821629, 0.03597882, -0.05062761, -0.053709738, -0.0017135427, -0.030783407, 0.08677211, -0.07123904), target2);
	target2 = MulAdd(d2, MF4x4(0.04535665, 0.10784165, 0.06629595, -0.08122243, -0.039657716, -0.18704408, 0.1423137, -0.042863034, -0.0742858, 0.18767954, 0.0049358946, -0.03671723, -0.26857832, -0.27597806, -0.15875868, -0.06401874), target2);
	target2 = MulAdd(e2, MF4x4(-0.11346384, -0.02552838, 0.15989058, 0.135453, 0.11406132, -0.14827615, -0.034574773, 0.098348685, -0.11900814, -0.017299704, -0.0073399683, 0.28204438, 0.101091795, -0.05411511, -0.25915098, -0.18966594), target2);
	target2 = MulAdd(f2, MF4x4(0.00533059, 0.02730481, -0.037623204, 0.0683161, -0.001293424, 0.048477355, -0.031527296, -0.06233651, -0.08181692, 0.15782121, -0.022148566, 0.023771856, 0.08038705, 0.20726775, -0.049652047, 0.013319854), target2);
	target2 = MulAdd(g2, MF4x4(0.10297071, -0.004163597, -0.054161496, -0.047678668, 0.17382064, -0.07822223, -0.015010763, -0.04397959, 0.016814355, 0.029943537, -0.054495964, 0.025957715, -0.0020466947, -0.05330402, 0.1510799, 0.020855682), target2);
	target2 = MulAdd(h2, MF4x4(-0.068892024, 0.06622253, -0.03464551, 0.058187455, 0.0040488504, 0.04686992, -0.031023791, -0.0217168, 0.27100065, 0.05667408, -0.1947591, 0.016222548, 0.15030278, 0.037999425, 0.18916538, 0.031360295), target2);
	target2 = MulAdd(i2, MF4x4(0.0033874374, 0.16642143, -0.05115266, 0.033188976, 0.15715985, -0.016430153, 0.061355177, -0.03946156, 0.097530834, 0.09636378, -0.0040456597, 0.03355033, 0.08691396, -0.059714377, -2.6330366e-05, 0.07581963), target2);
	target2 = MulAdd(a3, MF4x4(0.009388512, -0.11915495, -0.013311355, 0.037321404, -0.055611674, -0.03687238, 0.04141501, -0.05869542, 0.07016199, 0.09323767, 0.04217543, 0.06623439, 0.03210602, -0.05782674, -0.11002717, -0.0072197197), target2);
	target2 = MulAdd(b3, MF4x4(0.10509906, 0.09556673, 0.12621118, 0.05654386, -0.059508096, 0.05438697, 0.07796531, 0.013211419, 0.117890954, 0.06040751, -0.0016234997, 0.081311926, -0.13193677, 0.06996361, -0.13694339, -0.17900036), target2);
	target2 = MulAdd(c3, MF4x4(-0.053371694, -0.06806307, -0.1518878, 0.033526573, 0.046281144, -0.046205673, -0.034051836, 0.030009115, 0.126423, -0.016593177, -0.039357234, 0.10646578, -0.049523186, 0.031685475, 0.020842545, -0.12438032), target2);
	target2 = MulAdd(d3, MF4x4(0.13840649, 0.09017664, -0.049517624, 0.16685495, -0.08715648, 0.10113574, 0.018099392, 0.060909674, -0.0058692712, 0.045747917, -0.027853733, 0.05472168, 0.11535146, 0.18636864, 0.0723617, -0.014345535), target2);
	target2 = MulAdd(e3, MF4x4(0.2979883, -0.30398092, -0.00448704, 0.034454245, 0.06174734, -0.012045507, 0.23352385, 0.09975292, 0.17575547, -0.013523325, -0.23254701, 0.13217497, -0.20258605, 0.07145199, 0.08916167, -0.16669402), target2);
	target2 = MulAdd(f3, MF4x4(-0.1606433, 0.014213267, 0.046263646, 0.014771279, 0.041478187, -0.023410609, 0.14462134, 0.0359066, -0.14913698, -0.28093338, -0.098434776, 0.14168552, -0.017470809, -0.10474789, -0.019634444, -0.09452941), target2);
	target2 = MulAdd(g3, MF4x4(-0.024310801, 0.039855056, -0.0277722, -0.0049349763, -0.075620376, 0.14836049, 0.16639285, -0.11209939, -0.06530567, -0.059602138, -0.090105936, -0.024020225, 0.03793827, -0.08396542, 0.03918101, 0.031654693), target2);
	target2 = MulAdd(h3, MF4x4(-0.0019075832, -0.06279881, 0.019373834, -0.022848947, -0.19700366, -0.07276809, 0.10826095, 0.030095315, -0.18057819, -0.06393351, -0.023836957, 0.0065463074, 0.13035376, -0.06434109, 0.09293361, 0.03301868), target2);
	target2 = MulAdd(i3, MF4x4(0.013273036, -0.016674511, 0.13465153, -0.10852922, 0.026329456, 0.13648263, 0.09414527, 0.0012146169, -0.04237767, -0.085370585, 0.05478497, -0.009154848, 0.06731204, -0.034912866, 0.022870043, 0.038516387), target2);
	target2 = MulAdd(na1, MF4x4(-0.12806587, 0.108848855, 0.054954138, -0.04903305, 0.06644907, 0.18971404, -0.07503066, -0.04593073, -0.061711293, 0.014664125, 0.11856841, 0.045254968, -0.15008299, -0.074398935, 0.04106602, -0.24396381), target2);
	target2 = MulAdd(nb1, MF4x4(0.038917247, -0.04640616, -0.08809665, 0.11144138, 0.22032888, -0.050760582, -0.014760546, 0.11236783, -0.059079073, 0.06937314, -0.031159066, -0.07186243, -0.20771858, 0.006415583, -0.07267114, 0.056808673), target2);
	target2 = MulAdd(nc1, MF4x4(-0.00423516, 0.099120915, -0.059658743, 0.07284239, -0.062910534, 0.0818146, -0.04679385, 0.18365376, -0.09501989, -0.01619849, -0.060537007, -0.053941406, 0.01753884, 0.030266201, 0.03675036, 0.0021925808), target2);
	target2 = MulAdd(nd1, MF4x4(0.046608146, -0.02341816, 0.07648551, 0.052848052, 0.0039356127, 0.036476433, 0.10236195, -0.032545663, 0.24973582, 0.037997168, 0.058406867, 0.07901572, -0.18169855, -0.005032321, -0.035923317, -0.14367534), target2);
	target2 = MulAdd(ne1, MF4x4(0.16122861, -0.040731397, 0.106095225, 0.0036572781, 0.028426658, 0.20103998, -0.06638636, -0.022662058, 0.050278876, -0.163471, -0.21357286, -0.1825406, -0.050869223, -0.040973462, -0.057061654, 0.2810217), target2);
	target2 = MulAdd(nf1, MF4x4(0.18768045, -0.040844023, -0.057449356, 0.12673363, -0.059018314, -0.030971631, 0.08158004, 0.06946996, -0.23750862, -0.00860647, -0.1003966, 0.034669064, 0.24486068, 0.07178945, -0.018041046, 0.15238568), target2);
	target2 = MulAdd(ng1, MF4x4(-0.2525261, -0.054517742, -0.23935242, -0.101572365, -0.030042917, 0.036003232, -0.122569695, -0.03556264, 0.06506395, -0.062265877, -0.1060633, 0.014838352, 0.108411096, -0.066448584, 0.0512793, 0.09429625), target2);
	target2 = MulAdd(nh1, MF4x4(-0.13627818, -0.10708255, -0.19644266, -0.037392955, -0.045197092, 0.19481973, 0.13070573, -0.060230445, 0.33588138, -0.034298502, -0.11659601, 0.12985578, 0.13320427, -0.11824594, 0.026382592, -0.053538818), target2);
	target2 = MulAdd(ni1, MF4x4(0.048666447, -0.017627062, 0.15464988, -0.045204308, -0.011256204, 0.13558346, -0.11524339, -0.09390041, -0.13328557, 0.0208915, 0.14780544, -0.076561615, 0.16454418, -0.06894578, 0.05620349, 0.023376953), target2);
	target2 = MulAdd(na2, MF4x4(-0.15081851, 0.114050105, -0.20110038, -0.20664425, 0.024320586, 0.07185712, -0.07764587, -0.071572, 0.05626064, -0.033045493, 0.001562899, 0.025873706, -0.124655195, 0.008215636, 0.15243639, -0.004112266), target2);
	target2 = MulAdd(nb2, MF4x4(-0.3066088, 0.03357835, 0.10992364, -0.06900282, -0.018690787, 0.06104214, -0.0041348864, 0.06407149, -0.03204788, 0.014121594, 0.08106938, -0.054475598, -0.265469, -0.14616208, -0.00401253, -0.03055698), target2);
	target2 = MulAdd(nc2, MF4x4(-0.04365304, -0.03965277, -0.03783723, -0.064608894, -0.020902721, -0.14974843, -0.009566472, -0.05167228, 0.05844501, -0.06657627, 0.07489639, -0.033589855, -0.12991743, 0.06972872, -0.06635165, -0.012207249), target2);
	target2 = MulAdd(nd2, MF4x4(-0.18625839, 0.054298103, -0.01828512, -0.11457061, -0.010832592, -0.058104735, -0.19629207, 0.04157041, -0.009692541, -0.14516611, -0.05172281, 0.049974106, 0.056659166, 0.04280708, 0.04385243, 0.010063984), target2);
	target2 = MulAdd(ne2, MF4x4(0.30084208, -0.06846901, -0.026888005, -0.13171686, 0.14192836, 0.04704836, 0.121805556, 0.044525314, 0.083052106, -0.08510613, -0.12172583, -0.30419388, -0.0878148, -0.16297778, 0.2601781, 0.07285239), target2);
	target2 = MulAdd(nf2, MF4x4(0.17655143, 0.030515455, 0.19467549, 0.06786994, 0.12391486, -0.07981, 0.032166053, 0.025423106, 0.03408094, -0.13683012, -0.1334616, -0.06392358, 0.19483057, -0.26500967, -0.09117511, 0.065103196), target2);
	target2 = MulAdd(ng2, MF4x4(-0.09752205, 0.052617133, 0.093155235, 0.036831614, 0.0069967005, -0.010922277, 0.03564152, -0.032540992, 0.08338763, -0.09178083, 0.044856872, -0.03585517, -0.03322978, 0.046807107, -0.08056567, -0.011965988), target2);
	target2 = MulAdd(nh2, MF4x4(0.18745014, -0.036378495, -0.05438124, -0.07421527, 0.19114059, 0.06546488, -0.011771215, 0.023253547, -0.21524692, -0.18299192, 0.16316402, -0.07972637, 0.05902257, -0.073275164, 0.034378335, -0.03623065), target2);
	target2 = MulAdd(ni2, MF4x4(0.11460803, -0.08311417, -0.013590335, 0.03570915, 0.089230955, 0.089890435, 0.020723056, -0.042275555, -0.0369812, -0.26617813, 0.046739977, -0.12200707, 0.14000617, -0.12750666, 0.118415974, -0.07106497), target2);
	target2 = MulAdd(na3, MF4x4(-0.0142673105, 0.2708808, 0.035017774, 0.06703521, 0.029961549, 0.14673132, 0.063695125, -0.02033868, -0.06468242, -0.026121365, -0.0026516293, -0.027388861, -0.08078243, 0.087715834, 0.022955768, -0.02319636), target2);
	target2 = MulAdd(nb3, MF4x4(0.1718002, -0.11518721, -0.0025345646, 0.1238703, -0.18476513, -0.21286273, 0.20789471, 0.01770004, -0.061133858, -0.0626756, 0.055727385, -0.008457355, 0.118455775, 0.10262385, -0.006697552, 0.014359785), target2);
	target2 = MulAdd(nc3, MF4x4(0.09120904, 0.07372497, 0.11044388, -0.03926499, -0.03780375, 0.089837864, -0.09430582, -0.08950114, -0.14755902, -0.03831562, 0.023441203, -0.01944005, 0.04238117, 0.03447587, -0.06003528, 0.044492997), target2);
	target2 = MulAdd(nd3, MF4x4(0.11524887, -0.039266784, 0.066004194, 0.0054254015, 0.05427426, -0.09622213, -0.10315417, -0.050567277, -0.07576602, -0.12929544, -0.047569484, -0.0073220725, -0.19992967, -0.09847938, -0.010317084, -0.06364932), target2);
	target2 = MulAdd(ne3, MF4x4(-0.16610023, 0.2372482, -0.08908623, -0.0074210903, -0.30944943, -0.13369739, -0.14367966, -0.088355504, -0.17537226, -0.027992815, 0.2002623, -0.077625655, 0.43252298, 0.070107736, 0.12366656, 0.04695458), target2);
	target2 = MulAdd(nf3, MF4x4(-0.16442165, -0.115128726, -0.07232464, -0.06728961, -0.28723717, 0.17190668, -0.08351212, -0.0021862125, 0.121666215, 0.21980163, 0.041315466, -0.062825136, 0.19541566, 0.11147719, 0.024110844, 0.03695252), target2);
	target2 = MulAdd(ng3, MF4x4(0.1264344, -0.043413147, -0.0045117373, 0.11031058, 0.14368063, 0.0709618, -0.060608998, 0.12688136, -0.0067742122, -0.036186397, 0.0893928, 0.0054127555, -0.09240343, 0.00012509787, 0.22235379, -0.010589687), target2);
	target2 = MulAdd(nh3, MF4x4(-0.27677822, -0.026975723, 0.1144896, -0.02925077, 0.31745398, 0.030609636, -0.058644157, -0.080246314, 0.16578154, 0.040172495, 0.1331117, -0.02078141, -0.04805901, 0.04640852, 0.10614158, 0.012697342), target2);
	target2 = MulAdd(ni3, MF4x4(-0.11755322, 0.09768716, 0.0012669004, -0.110562816, 0.06637665, 0.02764571, -0.12623487, -0.023209875, 0.12958577, -0.007275613, 0.010377832, -0.0105528, -0.14058565, -0.030191245, 0.025604937, -0.013748175), target2);
	
	MF4 target3 = { 0.15827118, -0.013269078, -0.026832024, -0.007341773 };
	target3 = MulAdd(a1, MF4x4(0.027916895, -0.12058145, -0.083479345, -0.026083047, 0.014759637, -0.07421897, -0.017896682, 0.086924285, -0.05399337, 0.07368837, -0.26842278, 0.09718693, -0.014846767, -0.002766841, 0.06403607, 0.0669811), target3);
	target3 = MulAdd(b1, MF4x4(-0.021020316, -0.21434662, 0.06523966, 0.11869478, -0.21215962, -0.042433035, -0.10847877, -0.10532955, -0.18938127, 0.05224748, 0.02170683, -0.09415175, -0.08846007, -0.18066676, -0.108328596, 0.09838168), target3);
	target3 = MulAdd(c1, MF4x4(-0.0014482798, -0.08546761, 0.053286448, -0.022678297, -0.009113084, -0.09750778, 0.10262376, -0.003133292, 0.026831077, 0.03348051, -0.031860266, 0.053811714, -0.05097466, 0.040436964, -0.063929394, -0.12586603), target3);
	target3 = MulAdd(d1, MF4x4(0.015445512, 0.029696425, -0.15537772, -0.057669863, -0.058116574, 0.188642, -0.289381, -0.03078714, -0.010385, 0.014184904, 0.16890535, -0.02512565, 0.116905816, 0.043889366, -0.027181825, 0.015912583), target3);
	target3 = MulAdd(e1, MF4x4(0.0659837, 0.09219005, -0.085082754, 0.051408056, 0.11564603, 0.038757283, -0.0004551866, 0.06365286, 0.09702758, 0.10664935, 0.34716737, 0.14471847, 0.28146356, -0.00765224, 0.1772403, 0.22182499), target3);
	target3 = MulAdd(f1, MF4x4(-0.08183167, 0.05762959, -0.043376535, -0.16858399, 0.02308398, -0.055296358, 0.07663533, 0.106998175, -0.10704135, -0.02596522, 0.013459359, -0.044283163, 0.07874813, 0.022484714, 0.30442455, 0.071259074), target3);
	target3 = MulAdd(g1, MF4x4(-0.0022170176, 0.022313403, 0.122714184, -0.026881142, 0.08282965, -0.06490924, 0.18938759, 0.0677223, 0.1294088, 0.059372786, -0.110964485, 0.010619735, -0.09610158, -0.022745904, -0.019792024, -0.0034128428), target3);
	target3 = MulAdd(h1, MF4x4(-0.041866794, -0.13008577, 0.110913865, -0.016430711, 0.13772298, 0.06592027, -0.0034176896, -0.032333232, -0.0071776314, 0.031079333, -0.10468204, 0.026052983, -0.025571326, 0.048804965, 0.045641564, -0.035233505), target3);
	target3 = MulAdd(i1, MF4x4(0.035716273, -0.100303516, -0.031205915, -0.031608257, 0.09185616, 0.020499555, -0.16786079, -0.12639952, -0.023970092, 0.08524624, -0.06759015, -0.12429372, -0.0127442675, 0.112773865, -0.26975212, -0.007704992), target3);
	target3 = MulAdd(a2, MF4x4(-0.022916801, -0.09817618, 0.20416892, 0.12702931, -0.012764869, -0.038772803, -0.27769282, -0.034622744, -0.13437684, 0.02120745, -0.1548114, 0.006228885, 0.22984603, -0.2432492, 0.10387287, -0.059412073), target3);
	target3 = MulAdd(b2, MF4x4(0.2363932, -0.11194499, -0.064652696, 0.07116429, -0.14603911, 0.18921274, -0.013249935, 0.13604592, 0.07306857, 0.08511469, -0.061648175, 0.052819334, 0.2016978, -0.13642034, -0.014157929, 0.072210535), target3);
	target3 = MulAdd(c2, MF4x4(-0.18656836, 0.17888299, 0.003892404, -0.048626274, -0.11190575, 0.09419825, 0.1276045, -0.012969808, -0.14728911, 0.17536093, 0.050294712, 0.19381198, -0.06558784, -0.09776518, -0.11414383, -0.1866525), target3);
	target3 = MulAdd(d2, MF4x4(0.15634118, 0.19272068, -0.05068886, -0.030995008, -0.035177864, 0.07032768, 0.116517685, -0.09072261, -0.10217943, -0.09160873, -0.062906645, 0.12504682, -0.09060218, 0.014820002, 0.03459818, -0.108051665), target3);
	target3 = MulAdd(e2, MF4x4(-0.018596219, -0.017673533, -0.006066184, -0.064746305, -0.11017345, -0.09556466, 0.21868086, -0.027287072, -0.11609723, -0.11342597, 0.1788956, 0.035506073, -0.096203305, -0.037712112, 0.14055523, 0.16230235), target3);
	target3 = MulAdd(f2, MF4x4(0.0056694653, -0.045156818, 0.10069355, -0.07291589, -0.048202783, -0.12425812, 0.15425333, -0.052708663, -0.17621729, 0.06338879, 0.1205465, 0.1754123, -0.028028619, 0.11745275, -0.120209925, 0.031073835), target3);
	target3 = MulAdd(g2, MF4x4(-0.058996305, 0.042816967, -0.002514556, -0.0055761277, -0.05223201, -0.17414387, 0.13102455, 0.02741174, -0.0785701, 0.080076955, -0.058584027, 0.034780204, -0.0276381, 0.055405296, -0.09418891, 0.0013168643), target3);
	target3 = MulAdd(h2, MF4x4(-0.03179422, -0.080134, 0.055742502, -0.14085148, -0.0010870491, 0.006537003, -0.0013490077, -0.086607024, 0.057871595, -0.07872675, 0.22251247, -0.052358106, -0.1307614, -0.22731845, -0.06979484, 0.00849211), target3);
	target3 = MulAdd(i2, MF4x4(0.14046812, 0.04020691, -0.032090276, -0.09295882, -0.11624229, -0.10551015, 0.08762072, -0.07726716, -0.1498316, -0.17169969, -0.04618553, 0.14997219, -0.012493408, -0.06838468, 0.10913737, 0.018050432), target3);
	target3 = MulAdd(a3, MF4x4(0.033775266, -0.07618233, 0.11493082, -0.026212664, -0.04540022, 0.026137805, -0.13465577, 0.15029386, 0.07141062, 0.09716221, -0.025410062, 0.032656677, 0.037815653, -0.040112175, 0.11637884, 0.11825522), target3);
	target3 = MulAdd(b3, MF4x4(0.14827983, -0.081768006, -0.05624141, -0.0044099363, 0.032463025, 0.10766071, -0.061944928, -0.15250987, -0.14692347, 0.1010062, 0.1384647, 0.079083905, -0.11822245, -0.054733507, 0.06650751, 0.04349182), target3);
	target3 = MulAdd(c3, MF4x4(-0.0189154, -0.033869926, -0.008463885, -0.1524785, -0.017154029, -0.021163551, 0.045354687, 0.056154214, 0.0996, 0.18220654, -0.02275312, -0.051522568, -0.015781462, -0.14436358, -0.13036303, -0.08281256), target3);
	target3 = MulAdd(d3, MF4x4(0.060433608, 0.025449814, 0.03162007, -0.13456888, -0.02134081, -0.15663207, 0.17289546, 0.0011385656, 0.059484057, 0.052233964, -0.03541694, 0.113927364, -0.0010070644, -0.005570618, 0.12790091, 0.16491406), target3);
	target3 = MulAdd(e3, MF4x4(-0.033132974, -0.098377176, -0.12513644, 0.08796082, -0.0028096333, 0.09346144, -0.18109433, 0.17953019, 0.10331962, -0.111182235, -0.11015705, -0.15538633, -0.015985087, 0.06262592, 0.11767445, 0.04020116), target3);
	target3 = MulAdd(f3, MF4x4(-0.10818913, -0.10614671, -0.0061792796, 0.07901479, -0.0018810411, 0.0026243017, 0.15281977, 0.1715038, -0.017927805, 0.07613347, 0.033450123, -0.23979095, 0.028044673, 0.060702097, 0.019822879, -0.14792976), target3);
	target3 = MulAdd(g3, MF4x4(-0.008551052, -0.03843347, 0.0472157, -0.010416428, -0.01928176, -0.0063839755, 0.03508731, 0.24043478, 0.033645283, -0.11676803, -0.06743783, -0.034164682, -0.014925681, -0.030447507, -0.111160316, -0.034867767), target3);
	target3 = MulAdd(h3, MF4x4(-0.102300785, 0.114739686, -0.007856566, -0.12389364, -0.18574199, 0.06441196, -0.1979763, -0.016671708, -0.09252569, 0.0037067563, -0.0609829, 0.028997343, 0.047285903, -0.018309064, -0.027229104, 0.06743576), target3);
	target3 = MulAdd(i3, MF4x4(-0.055446856, -0.06821513, -0.0059853215, -0.13260886, 0.083104685, -0.11773866, 0.007317027, -0.039318476, -0.0042170533, 0.0121953655, -0.010792958, -0.010249791, 0.007397987, 0.0047044945, 0.049882278, 0.0047567203), target3);
	target3 = MulAdd(na1, MF4x4(0.03465105, 0.062134508, -0.043116115, -0.017247844, -0.04502861, -0.10212199, 0.16550505, 0.016599817, 0.08857375, -0.03961283, 0.13870746, -0.082080655, -0.08469554, -0.18640712, -0.014425766, 0.034508247), target3);
	target3 = MulAdd(nb1, MF4x4(-0.12399076, 0.22634715, -0.13730592, 0.04840304, 0.09450334, -0.065218486, 0.0068855314, -0.049165834, -0.011287574, -0.10739019, -0.00023772087, 0.09688784, 0.10983027, -0.011201701, 0.14466487, -0.21600902), target3);
	target3 = MulAdd(nc1, MF4x4(-0.05468909, 0.050734483, 0.046412308, -0.09749245, 0.05704707, 0.22612362, -0.15571213, 0.06998293, 0.017409045, -0.13634662, -0.020574553, -0.073725305, 0.04699205, -0.08355112, 0.08512415, 0.15568486), target3);
	target3 = MulAdd(nd1, MF4x4(0.10635322, 0.07337078, -0.07432055, 0.004248984, 0.027724393, -0.040500402, 0.196942, 0.041983824, 0.083976634, 0.10290795, -0.3009756, 0.082270764, -0.15817869, -0.027697606, -0.029153766, 0.08529106), target3);
	target3 = MulAdd(ne1, MF4x4(0.14958759, 0.13267447, 0.22206177, -0.17663805, -0.10765967, -0.03566466, 0.04633988, -0.03062237, -0.20792471, -0.002921972, -0.15749575, -0.22428021, -0.23200673, 0.14563684, -0.160325, -0.266424), target3);
	target3 = MulAdd(nf1, MF4x4(-0.13190623, 0.041341502, -0.12777801, -0.055840913, -0.112986885, -0.0021044768, -0.12469129, -0.11046474, -0.03600098, -0.011692557, -0.02686337, -0.17009224, -0.0820219, -0.029119916, -0.111095175, 0.15297051), target3);
	target3 = MulAdd(ng1, MF4x4(0.14414293, 0.02744959, -0.102789834, 0.006705362, -0.030359348, 0.083485864, -0.12009053, -0.02636556, 0.08503298, -0.10867725, 0.09814758, -0.14605886, 0.16700824, -0.0866019, 0.008852153, -0.21706365), target3);
	target3 = MulAdd(nh1, MF4x4(-0.011756063, 0.008039321, 0.03698028, -0.10509595, -0.099564835, 0.009903015, -0.08965568, 0.06633642, 0.10181769, 0.08294756, 0.025898153, -0.098384134, 0.066339396, -0.02191258, 0.03265874, 0.1477094), target3);
	target3 = MulAdd(ni1, MF4x4(-0.22950448, -0.07607528, 0.016735366, 0.083834045, -0.005080134, 0.09744342, -0.105208844, 0.043603517, 0.005231004, -0.023469515, 0.08517984, 0.14299476, 0.0062482157, -0.09623864, 0.097964756, 0.11196982), target3);
	target3 = MulAdd(na2, MF4x4(-0.31986436, 0.02033341, -0.067986034, 0.12729374, -0.0048481217, 0.05469139, 0.16248406, 0.09194327, 0.024411261, 0.051379394, 0.00034975683, -0.021101091, 0.00954231, 0.02220226, -0.32092375, -0.039599743), target3);
	target3 = MulAdd(nb2, MF4x4(-0.23243247, 0.102910504, 0.08704054, -0.16638695, -0.04414702, 0.10768372, 0.06244856, -0.053088184, -0.07190515, 0.025491035, -0.0073894467, -0.06960583, 0.04625048, 0.09757096, -0.014015539, -0.2686573), target3);
	target3 = MulAdd(nc2, MF4x4(0.09618109, -0.04002844, 0.10706359, 0.0021603133, -0.10353008, -0.051047757, 0.22455198, -0.034693047, 0.0572685, -0.055035133, 0.004646706, 0.097952425, 0.14423034, 0.03551641, 0.17294352, 0.18931827), target3);
	target3 = MulAdd(nd2, MF4x4(-0.103451714, -0.14722984, 0.075681895, 0.05237415, -0.11553789, -0.04747042, 0.06682777, -0.094138026, 0.17443697, 0.022166768, -0.033095736, -0.060237505, 0.12380581, -0.0075241313, -0.07084953, -0.036764625), target3);
	target3 = MulAdd(ne2, MF4x4(-0.035672948, -0.06520371, -0.09139108, 0.04217135, -0.117305085, 0.07602235, -0.15833357, 0.056191333, -0.11441557, 0.037268326, -0.028076539, -0.12540102, 0.016748995, 0.034004167, -0.1824477, -0.16126373), target3);
	target3 = MulAdd(nf2, MF4x4(0.06134336, -0.11747715, -0.08211664, 0.08370146, -0.12180083, 0.19250062, -0.054975577, 0.020182844, 0.08444608, -0.06466239, 0.015815528, -0.031805765, -0.0028007699, 0.08060802, 0.15744543, -0.12746236), target3);
	target3 = MulAdd(ng2, MF4x4(0.043641105, -0.07119625, -0.042450625, 0.05739444, 0.018069813, 0.029118251, 0.0061236136, 0.07221804, -0.011486244, -0.041661404, 0.2197789, -0.020237818, 0.15324089, -0.02419463, 0.095150515, -0.048418492), target3);
	target3 = MulAdd(nh2, MF4x4(0.010760071, 0.079417765, -0.038494457, 0.0804348, -0.03777174, -0.2785645, -0.0018691403, -0.009908184, -0.2519993, -0.021114716, -0.075966366, -0.11307284, 0.042725798, 0.02793535, 0.08475073, 0.00719373), target3);
	target3 = MulAdd(ni2, MF4x4(-0.06026802, -0.1285141, -0.015326734, -0.092160225, -0.03740965, -0.10725952, 0.11102985, -0.05550745, 0.07659162, -0.115331456, 0.003444734, -0.054064468, -0.08475641, -0.08501742, -0.24890389, 0.07931074), target3);
	target3 = MulAdd(na3, MF4x4(0.16370693, 0.14513049, -0.13996753, -0.061734002, -0.030769601, 0.057222515, 0.050910987, -0.04650852, -0.054636024, -0.021683916, -0.17012738, 0.020975761, -0.1575395, 0.23097757, -0.20053351, -0.03677814), target3);
	target3 = MulAdd(nb3, MF4x4(0.08665788, 0.11735751, -0.017768439, 0.0068110893, 0.2169534, 0.04611748, -0.05265798, -0.14298616, 0.030219741, 0.0361948, -0.17905854, -0.072263926, -0.12066245, -0.043840945, -0.075282134, 0.062113304), target3);
	target3 = MulAdd(nc3, MF4x4(-0.07236986, 0.12181904, -0.010601836, 0.14551845, -0.073809735, 0.15977979, -0.018897848, 0.036385477, 0.0025911513, 0.026647402, 0.07882444, 0.028249063, 0.009689747, -0.03413688, -0.032440297, 0.060033906), target3);
	target3 = MulAdd(nd3, MF4x4(0.0063548526, -0.05827531, -0.0863922, 0.09530562, -0.007424638, 0.2742968, -0.44429728, 0.1693316, 0.00851462, 0.018132828, -0.014929005, -0.08181229, -0.12771043, -0.15851092, -0.08833768, -0.05561009), target3);
	target3 = MulAdd(ne3, MF4x4(-0.17187662, -0.020507278, -0.00087365095, -0.17611316, -0.13882494, 0.07799683, 0.06299509, -0.33718416, -0.19870155, 0.055342596, 0.1495889, 0.13743624, -0.16251567, -0.02317984, -0.3027063, 0.07310683), target3);
	target3 = MulAdd(nf3, MF4x4(0.07612367, -0.06315094, 0.086967595, -0.17633231, 0.010166444, 0.109485, -0.06876594, 0.19186738, 0.12188993, -0.010759893, 0.0059104343, 0.21518311, -0.14552301, -0.04969499, 0.013590615, -0.0688024), target3);
	target3 = MulAdd(ng3, MF4x4(-0.0505275, 0.05859463, -0.08945146, -0.0057924157, 0.058152966, -0.024229135, 0.031221801, -0.15067945, -0.018535225, 0.13843696, 0.041234065, 0.051733483, -0.10050763, 0.10705917, -0.022969715, 0.03912073), target3);
	target3 = MulAdd(nh3, MF4x4(-0.009000505, -0.11456071, 0.0340094, 0.12444861, 0.07345543, -0.1419509, 0.092182405, 0.056249533, 0.063071616, -0.010534381, 0.056680985, 0.025993576, -0.13020347, 0.066157125, 0.0073951716, -0.027919816), target3);
	target3 = MulAdd(ni3, MF4x4(0.11827389, 0.111768976, 0.024734994, -0.008209825, -0.11939657, 0.049890216, -0.14757815, -0.0018939807, -0.108214505, -0.13791578, 0.06980697, -0.035102874, 0.0068360427, 0.15766092, -0.0094464505, 0.02528075), target3);

	tex4[gxy] = target1;
	tex5[gxy] = target2;
	tex6[gxy] = target3;
}

//!PASS 5
//!DESC Conv-4x3x3x24
//!IN tex4, tex5, tex6
//!OUT tex1, tex2, tex3, tex7
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass5(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = tex4.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = tex4.SampleLevel(sam, pos, 0);
	MF4 f1 = tex4.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = tex5.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = tex5.SampleLevel(sam, pos, 0);
	MF4 f2 = tex5.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    MF4 a3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = tex6.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = tex6.SampleLevel(sam, pos, 0);
	MF4 f3 = tex6.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target1 = { -0.112874866, 0.058437236, -0.011864247, -0.050339766 };
	target1 = MulAdd(a1, MF4x4(0.0858087, -0.091669075, -0.029618878, -0.006829049, 0.05929614, -0.10007056, -0.07165286, -0.044839766, 0.16440393, -0.013165904, 0.16345644, -0.040166497, -0.08533438, 0.033274904, 0.023744298, 0.00462745), target1);
	target1 = MulAdd(b1, MF4x4(-0.012197617, -0.17494427, -0.044840526, 0.09467358, 0.0670941, 0.04051791, 0.031950857, 0.043632418, 0.27560753, -0.18038619, -0.016762096, -0.18554263, -0.07514284, -0.12060545, -0.06567658, 0.095817134), target1);
	target1 = MulAdd(c1, MF4x4(-0.006523474, -0.08222627, -0.0071327686, 0.0019292525, 0.10427757, -0.12537085, 0.04317682, -0.073334634, 0.05154215, -0.091944076, -0.02118822, -0.056948982, -0.13910337, 0.03694039, -0.057772428, -0.04310826), target1);
	target1 = MulAdd(d1, MF4x4(0.06324951, -0.22648853, -0.07255338, 0.017026639, -0.008103722, -0.21415114, -0.26123968, -0.12380067, -0.122654535, -0.072686374, -0.106361255, -0.085339114, -0.032308288, 0.15890516, 0.06622756, -0.023396786), target1);
	target1 = MulAdd(e1, MF4x4(-0.042859413, -0.09672486, -0.25197455, -0.09964709, 0.29545367, -0.031414457, -0.09069656, -0.1515025, 0.0027435324, -0.22244011, -0.028398262, 0.023005402, -0.01898338, -0.044614386, -0.15384883, -0.03421089), target1);
	target1 = MulAdd(f1, MF4x4(0.02024483, -0.0024315433, -0.12607838, -0.06749624, 0.18010019, -0.13433436, 0.023777714, -0.000595795, 0.06660958, 0.0047493204, -0.008804406, -0.01993787, -0.16380167, -0.116379924, -0.08225346, -0.15736714), target1);
	target1 = MulAdd(g1, MF4x4(0.04966525, -0.18904372, 0.0033124757, 0.007581284, 0.04973636, -0.054151382, -0.0019207672, 0.035237975, 0.050646428, 0.054101888, 0.10167154, -0.06646531, -0.1516706, 0.0069144946, -0.11062034, 0.00401821), target1);
	target1 = MulAdd(h1, MF4x4(0.042625226, -0.13069777, -0.16180645, -0.023299642, 0.026805617, -0.05658099, 0.043719705, 0.1092636, 0.12341378, 0.042006955, 0.18066125, 0.16378504, 0.11135436, 0.08376113, 0.031495962, 0.04347884), target1);
	target1 = MulAdd(i1, MF4x4(-0.006632579, -0.08609527, -0.08015572, -0.09973007, 0.0060661826, -0.0025273473, 0.027333017, 0.19469416, 0.115743786, -0.048629977, 0.07540239, 0.060625635, 0.11000561, -0.0005722454, -0.17226484, -0.27114823), target1);
	target1 = MulAdd(a2, MF4x4(0.055690464, -0.02658434, 0.07268652, 0.10016923, -0.16319957, 0.17007092, 0.21633402, 0.20618637, -0.113490485, 0.02199878, 0.0055137747, 0.12215447, -0.09464513, 0.045647286, -0.14000376, 0.073245205), target1);
	target1 = MulAdd(b2, MF4x4(-0.23644187, 0.079229124, 0.15172592, -0.13774072, -0.026849356, -0.021209542, -0.027881218, 0.033904858, 0.038394954, -0.087262556, -0.08262074, -0.031362742, -0.043572012, -0.025324758, -0.030077327, 0.005004752), target1);
	target1 = MulAdd(c2, MF4x4(0.09973582, 0.010234953, -0.08513304, -0.03290182, -0.06016728, -0.14835075, -0.049367975, -0.109585285, 0.1308012, -0.05561698, 0.02354898, 0.013404379, 0.076999895, 0.0965049, -0.08259544, 0.08366891), target1);
	target1 = MulAdd(d2, MF4x4(-0.14182909, 0.08395952, 0.08790292, -0.10685734, 0.20583102, 0.04878629, 0.33621716, 0.022593737, 0.11261521, 0.21141209, 0.20565145, 0.10242992, 0.024171967, 0.0531655, 0.049630456, -0.026225826), target1);
	target1 = MulAdd(e2, MF4x4(-0.24823152, -0.004493935, -0.098093554, 0.024939846, -0.18618853, 0.23347515, 0.3677701, 0.116543904, -0.0123427, -0.023756992, -0.047602683, -0.17058952, 0.255566, -0.16041403, -0.12076221, -0.16564348), target1);
	target1 = MulAdd(f2, MF4x4(-0.013236432, 0.076761626, 0.081881255, 0.09071596, -0.11729648, -0.006444196, 0.10923074, 0.13791469, -0.043651752, -0.18294181, -0.040916644, 0.097785, -0.0028955766, -0.0027983326, 0.073921174, -0.10227346), target1);
	target1 = MulAdd(g2, MF4x4(-0.0018851581, 0.042510424, -0.049210977, 0.054145046, 0.062141296, -0.05751743, -0.1545065, -0.07428518, -0.0012378759, 0.0046147997, 0.05624973, 0.026027879, 0.014657843, 0.03690237, 0.020237725, 0.028257368), target1);
	target1 = MulAdd(h2, MF4x4(-0.0131197, -0.068101935, 0.1810527, -0.16003254, -0.031678617, 0.02635583, 0.028078066, -0.061150465, 0.011311746, -0.13556738, 0.010152058, -0.27962342, -0.06454591, 0.20071113, -0.17109145, 0.24637976), target1);
	target1 = MulAdd(i2, MF4x4(0.010061335, -0.001633492, 0.015894579, 0.11813777, -0.0085875485, 0.16046463, -0.03870673, -0.1573532, 0.007046577, -0.032677893, -0.03055368, 0.16372435, -0.023844553, 0.0414419, 0.024983952, 0.118105516), target1);
	target1 = MulAdd(a3, MF4x4(-0.015675241, 0.06467378, -0.06385561, 0.23119383, 0.19577031, 0.09614502, 0.14291568, 0.0646477, -0.04580087, -0.054257967, 0.0035926772, -0.084984995, 0.07729014, -0.12703735, 0.021946913, -0.13898507), target1);
	target1 = MulAdd(b3, MF4x4(0.04983293, -0.1356944, 0.06499119, 0.18219076, -0.0012843006, 0.017029244, 0.072508365, -0.109151654, 0.20020588, -0.01626167, -0.046852995, -0.15508164, 0.17773204, -0.11779289, 0.16009867, -0.20663622), target1);
	target1 = MulAdd(c3, MF4x4(-0.29108632, -0.10655777, 0.044198614, -0.04410373, -0.04469665, 0.026585957, -0.03942788, 0.15000731, 0.09523267, -0.13746834, 0.04037757, -0.100768045, 0.13844049, 0.015964666, 0.050790466, -0.0692099), target1);
	target1 = MulAdd(d3, MF4x4(-0.06911559, 0.012809353, -0.12680744, -0.048866037, 0.055650793, -0.0578033, -0.098106444, 0.074231684, 0.07584408, -0.06642763, -0.12730137, -0.19599968, 0.057783168, 0.2112361, 0.2594585, -0.005996189), target1);
	target1 = MulAdd(e3, MF4x4(0.14301813, -0.11221026, -0.13259968, -0.094263665, -0.07149053, -0.048891526, -0.032946635, -0.10009779, 0.27363536, 0.14980642, -0.02908678, 0.0047521754, 0.3446896, 0.026126916, 0.36222085, 0.18175994), target1);
	target1 = MulAdd(f3, MF4x4(-0.14227025, -0.043589745, -0.026543979, -0.16103217, -0.15027285, 0.039540008, -0.006172108, -0.10215637, 0.054667268, -0.056833044, -0.041795656, -0.13694401, 0.10057133, -0.13033262, 0.10366755, -0.022725947), target1);
	target1 = MulAdd(g3, MF4x4(0.09428237, 0.013572218, 0.08937405, 0.07288141, -0.11737223, 0.23257263, -0.04531822, 0.13323838, -0.06946843, 0.09392816, 1.8482398e-05, 0.099077396, 0.035169534, -0.25623903, -0.018828487, -0.06300839), target1);
	target1 = MulAdd(h3, MF4x4(-0.026215252, 0.03051006, 0.07113607, -0.12154545, 0.0040449486, -0.123852775, -0.08525913, -0.1901913, 0.017407645, 0.16107552, -0.12645124, -0.017211819, -0.07441704, -0.005858128, -0.011531684, 0.32415336), target1);
	target1 = MulAdd(i3, MF4x4(-0.17503254, -0.0015612559, 0.10169017, 0.019084195, 0.021156454, -0.310495, 0.04608056, 0.10953508, 0.19300106, -0.22451214, 0.03351187, -0.23461004, 0.072505705, 0.015136174, 0.04027726, 0.07976788), target1);
	target1 = MulAdd(na1, MF4x4(0.063301176, -0.05981131, 0.08261184, -0.14083353, -0.03195537, 0.0578306, 0.02804363, -0.20032683, -0.05517824, -0.0757025, -0.19914438, -0.042908937, -0.030248174, -0.25152618, 0.050725143, 0.1369699), target1);
	target1 = MulAdd(nb1, MF4x4(0.1003561, 0.0734191, 0.09896423, -0.08019514, 0.014390224, -0.00054874463, 0.037597846, -0.09500772, 0.09027194, 0.101415, -0.040434603, 0.08962564, -0.22431703, -0.07749036, 0.0013332567, 0.09083244), target1);
	target1 = MulAdd(nc1, MF4x4(0.008767293, 0.024598125, -0.006601763, -0.028163001, -0.024962863, 0.08638626, -0.028004736, -0.08388235, 0.022387464, 0.070822835, -0.022390194, 0.035980027, -0.043976255, -0.13879846, -0.0064368118, 0.1285523), target1);
	target1 = MulAdd(nd1, MF4x4(0.04603082, 0.12994967, 0.081791796, 0.09700837, 0.023545785, 0.06551075, 0.12287056, -0.22250815, -0.16573791, -0.047054622, 0.07907622, -0.031006414, 0.06890266, -0.123863325, 0.067868486, 0.18396272), target1);
	target1 = MulAdd(ne1, MF4x4(0.16980824, 0.015854107, 0.17575637, 0.15477645, -0.09076066, -0.05120928, 0.03070066, 0.11817304, 0.06490148, -0.012875289, 0.006170174, 0.11815885, 0.041828565, -0.17298366, -0.014634091, 0.124265894), target1);
	target1 = MulAdd(nf1, MF4x4(0.06368938, -0.032462507, 0.04960355, -0.04891845, -0.0038693375, 0.12922424, 0.0047689294, -0.08684701, 0.095224895, 0.0020490738, -0.046015333, -0.18551406, 0.07551751, -0.071112834, 0.02344341, 0.04623062), target1);
	target1 = MulAdd(ng1, MF4x4(-0.056204665, 0.013370383, -0.0043938635, 0.000645203, -0.09654348, 0.02182419, 0.0059207743, -0.13559262, 0.06930852, 0.008161434, 0.016864823, 0.11678153, 0.0039051562, -0.07914336, 0.04955842, 0.017483408), target1);
	target1 = MulAdd(nh1, MF4x4(0.010976288, 0.10715081, 0.09279967, 0.020898886, 0.013906253, 0.09519829, -0.033453338, 0.06451083, -0.043613426, -0.009969589, -0.11931571, 0.03572111, 0.0051956573, -0.0647261, -0.07640106, 0.14315592), target1);
	target1 = MulAdd(ni1, MF4x4(0.051365715, 0.05332849, 0.028890109, -0.047791258, 0.088561386, 0.07254739, -0.04627223, -0.066297226, -0.106467545, -0.061747868, -0.04026904, 0.0245163, 0.104035124, 0.0005123147, 0.09572231, 0.23461665), target1);
	target1 = MulAdd(na2, MF4x4(0.025117617, -0.051919132, -0.10238518, 0.0087314, -0.24502674, 0.24725929, 0.020510906, -0.11374982, -0.08788345, 0.14287415, -0.05371828, -0.09765232, 0.089326784, 0.059355933, 0.003667818, 0.007658546), target1);
	target1 = MulAdd(nb2, MF4x4(0.032038644, -0.064910114, -0.041199267, 0.07735183, 0.023076316, 0.2316058, 0.14530785, 0.01587883, 0.17309736, 0.034302652, 0.078950614, 0.07103009, 0.042525988, 0.026763001, 0.03962311, -0.017174084), target1);
	target1 = MulAdd(nc2, MF4x4(-0.045589544, 0.09957158, 0.0106373755, 0.029290373, -0.012066452, 0.107432865, -0.10563313, 0.08964528, 0.081136055, 0.16387793, -0.037766423, 0.083933, -0.0100631835, -0.041015863, 0.020540452, -0.01647507), target1);
	target1 = MulAdd(nd2, MF4x4(0.12199317, -0.078802, -0.14587677, -0.05266387, -0.2739342, -0.07832318, -0.02654562, -0.19134043, -0.15542388, 0.10411293, 0.0068920734, -0.18878813, 0.032211393, 0.15987061, -0.12149388, 0.09021272), target1);
	target1 = MulAdd(ne2, MF4x4(0.017827235, 0.021951806, 0.12995765, -0.1925006, 0.43689772, -0.067384414, -0.12091599, -0.20399235, 0.11603679, 0.26069987, 0.09115632, 0.29782417, -0.37195182, 0.17822702, 0.26410392, 0.22584216), target1);
	target1 = MulAdd(nf2, MF4x4(0.00091769337, -0.10308406, -0.03788696, 0.009829855, 0.07434385, -0.055530947, -0.119265415, 0.03404489, 0.13412294, 0.19281757, -0.21274371, -0.09527358, 0.022169666, 0.06841656, -0.09664997, 0.02376001), target1);
	target1 = MulAdd(ng2, MF4x4(0.02522274, -0.07492225, 0.108729765, -0.084396936, -0.1450858, -0.084260635, 0.036976974, 0.07395254, 0.102778085, -0.04220765, 0.015409228, -0.09215815, 0.033722915, 0.09410213, 0.06759963, 0.03639959), target1);
	target1 = MulAdd(nh2, MF4x4(-0.0129304, 0.049982294, -0.16211604, 0.15442637, -0.00069647084, 0.026756465, -0.06687889, 0.25361556, -0.022950223, 0.123774804, -0.018783078, 0.23009071, 0.08808236, -0.02500049, 0.058831975, -0.059854023), target1);
	target1 = MulAdd(ni2, MF4x4(0.0282501, -0.06622134, -0.03940754, -0.057764836, 0.023595478, 0.12694593, -0.0038103263, 0.1507626, 0.03539641, 0.04670363, -0.07688535, -0.04822336, 0.054404292, -0.07222161, -0.09880846, -0.09190709), target1);
	target1 = MulAdd(na3, MF4x4(0.028638069, 0.032332644, 0.10077746, -0.13334957, -0.068841085, -0.11133997, 0.03466411, -0.10885937, 0.050528128, -0.09258964, -0.07510585, -0.031298082, 0.074979246, 0.02487803, 0.05295848, 0.032633457), target1);
	target1 = MulAdd(nb3, MF4x4(-0.07998351, 0.05691501, 0.036540154, 0.00094257767, -0.15473618, -0.06821505, -0.021972192, 0.22512725, -0.028976573, -0.016970608, -0.07117851, 0.0005293328, 0.18183869, 0.06063047, 0.016248764, 0.10007656), target1);
	target1 = MulAdd(nc3, MF4x4(0.07268518, -0.09155798, -0.002566672, -0.018126441, -0.16046503, 0.048856504, -0.011080104, 0.036383335, 0.08598702, 0.19642924, -0.049759824, 0.07246208, 0.13074261, -0.058662284, 0.03459059, -0.04198155), target1);
	target1 = MulAdd(nd3, MF4x4(0.12882999, -0.021765677, 0.21212584, -0.099195495, -0.105583504, 0.17039305, 0.06333295, 0.090153314, -0.038552936, 0.033885363, 0.04958857, -0.024823477, -0.06625663, -0.013032451, -0.22981462, 0.12724645), target1);
	target1 = MulAdd(ne3, MF4x4(-0.2467723, 0.09133717, 0.08810061, 0.07691946, -0.20903678, 0.08403025, 0.010679062, -0.03956549, -0.011411588, -0.022170769, -0.06298385, -0.10067764, 0.03551502, -0.0736268, -0.109931275, -0.15795651), target1);
	target1 = MulAdd(nf3, MF4x4(0.050697595, -0.012465872, -0.068512246, 0.1556296, -0.17526908, -0.06572342, -0.018147333, 0.026501164, -0.049490303, 0.061885685, 0.02423367, 0.027439872, 0.37354204, -0.09908201, -0.10852779, -0.047961403), target1);
	target1 = MulAdd(ng3, MF4x4(-0.1904858, -0.08803705, -0.15687172, -0.14420407, 0.058089714, 0.103457965, 0.048995994, 0.057829436, -0.05192929, 0.019802462, -0.04511639, -0.0038435445, 0.2194401, -0.043761376, 0.1312272, 0.054326482), target1);
	target1 = MulAdd(nh3, MF4x4(-0.07349653, -0.121248744, 0.057792176, 0.099129215, -0.20087934, -0.031952746, -0.09673813, -0.031076657, -0.03237994, -0.020143004, -0.12516364, 0.007846103, 0.17188387, -0.2825958, 0.07352815, -0.021273587), target1);
	target1 = MulAdd(ni3, MF4x4(0.14606737, 0.04232884, -0.04508154, 0.11619671, -0.14093883, 0.022675866, 0.004869404, -0.1476083, -0.15496063, -0.11994992, -0.07718659, 0.0023026431, 0.012474549, 0.107636444, -0.08887454, 0.23727296), target1);
	
	MF4 target2 = { -0.051753327, -0.07172183, 0.021211471, -0.050325148 };
	target2 = MulAdd(a1, MF4x4(0.016881438, -0.044336118, 0.11502204, -0.10677853, 0.08977789, -0.059579305, 0.109261245, 0.10357805, 0.3364402, 0.14823961, 0.06096494, 0.15078168, -0.11029799, 0.074738294, 0.012435908, -0.0106727), target2);
	target2 = MulAdd(b1, MF4x4(-0.109714404, 0.008750308, 0.1948044, -0.1396421, 0.04144051, -0.12435535, 0.07815825, 0.019051697, -0.07954506, -0.0965191, -0.2027906, 0.17172056, -0.26384082, 0.13519175, 0.04667002, 0.021707565), target2);
	target2 = MulAdd(c1, MF4x4(0.07089612, 0.007484666, 0.104900375, 0.04954983, -0.06030455, -0.12300262, 0.05197505, -0.041572303, 0.009151977, 0.0799586, -0.04780254, -0.13600186, 0.18708369, 0.047879692, 0.040363688, 0.042251408), target2);
	target2 = MulAdd(d1, MF4x4(0.063153245, 0.0050982186, 0.17556845, -0.06571311, -0.03749878, 0.014326615, -0.11032866, -0.27065897, -0.10525074, 0.13344456, -0.16412602, 0.049715474, 0.061313376, -0.24646369, 0.14604661, -0.09024816), target2);
	target2 = MulAdd(e1, MF4x4(-0.026787708, 0.09889526, -0.050714437, -0.18990894, -0.087063104, -0.12555519, -0.0064119035, -0.0066881417, 0.09163732, -0.13423459, -0.05758272, -0.11314744, -0.025565878, 0.078317784, -0.14494383, -0.14658383), target2);
	target2 = MulAdd(f1, MF4x4(0.0110544115, 0.06727031, -0.099965416, 0.059974622, -0.15135513, -0.038787033, 0.07673858, 0.017850239, 0.02383772, -0.1985737, 0.094468035, -0.097836666, 0.19387084, 0.06476367, -0.15316796, 0.023932178), target2);
	target2 = MulAdd(g1, MF4x4(0.009757702, 0.14015986, -0.10496543, -0.044595003, -0.024084711, 0.012144018, 0.0981338, -0.012515983, 0.0060429554, -0.07067267, 0.12682167, -0.11384025, -0.045077007, 0.035177663, -0.06615891, 0.045473646), target2);
	target2 = MulAdd(h1, MF4x4(-0.111679845, 0.026028167, 0.04201027, -0.16000839, 0.037475422, 0.038049795, -0.16249935, 0.02239824, -0.018402468, 0.012291931, -0.07117686, -0.09280776, 0.20392933, -0.02732328, 0.045456327, -0.078981794), target2);
	target2 = MulAdd(i1, MF4x4(0.03066143, -0.0739708, -0.13922189, -0.12682499, -0.1299339, -0.09163088, -0.07340559, -0.050614927, -0.03902327, 0.09319906, 0.23746358, -0.12093768, -0.0071099317, -0.060775675, 0.15018946, -0.013342442), target2);
	target2 = MulAdd(a2, MF4x4(0.07596372, 0.20584284, -0.02217273, 0.2564209, 0.11423146, 0.0098925475, -0.19662452, -0.1313871, 0.08574315, 0.0067099673, -0.08959511, -0.13870555, -0.08032657, 0.013044774, 0.059738085, -0.06106972), target2);
	target2 = MulAdd(b2, MF4x4(-0.017293025, 0.15636088, -0.10619794, 0.108079255, -0.1168585, 0.09589374, -0.08682874, -0.08116015, 0.005083832, -0.15325624, -0.022297598, 0.23929761, -0.024037527, -0.006906145, -0.17204066, 0.003067951), target2);
	target2 = MulAdd(c2, MF4x4(0.036887415, 0.0059498777, -0.04959398, -0.12104261, 0.018237587, 0.07747393, -0.038457148, 0.01900929, 0.06142847, -0.03194083, -0.008666936, -0.13599987, 0.031248135, -0.04247948, 0.10167268, 0.13608082), target2);
	target2 = MulAdd(d2, MF4x4(-0.13198346, 0.1674333, -0.06218637, -0.06692618, 0.12682024, -0.12734371, -0.08660555, 0.22860871, 0.32062, -0.001097262, 0.13959797, -0.0044754874, 0.081532046, -0.026494987, -0.0123374695, 0.026149286), target2);
	target2 = MulAdd(e2, MF4x4(-0.104755685, -0.010431212, -0.031997994, 0.027816107, 0.028212348, 0.06372256, -0.14536087, 0.09018213, 0.01694147, -0.046755623, 0.04764776, 0.057815794, 0.062553786, -0.09214233, 0.040526126, 0.007556779), target2);
	target2 = MulAdd(f2, MF4x4(-0.08911158, 0.07110132, 0.056163214, 0.038952623, 0.10865385, 0.006793654, -0.06653261, 0.18222512, 0.029801054, -0.0811567, 0.12070828, 0.054755576, 0.028518738, -0.016029958, 0.03218924, -0.009337529), target2);
	target2 = MulAdd(g2, MF4x4(0.086197704, -0.015495907, 0.048072338, -0.07199852, 0.082511336, 0.20892009, 0.059752844, 0.105095305, 0.09896605, 0.11799976, 0.061295632, 0.06601205, 0.013666139, -0.015312437, -0.18342482, 0.023882518), target2);
	target2 = MulAdd(h2, MF4x4(-0.013824049, 0.05503347, -0.16911599, 0.008002769, -0.13950597, 0.027708618, 0.25653768, -0.08508614, 0.18204638, -0.06386117, -0.20115016, -0.14755486, 0.05260717, 0.15443258, 0.25847095, -0.10009257), target2);
	target2 = MulAdd(i2, MF4x4(-0.059717122, -0.03435186, -0.10407675, -0.064839795, -0.044192888, -0.036913253, 0.03681877, 0.03697244, -0.09967689, 0.09231582, -0.33624214, -0.023151914, -0.1287868, 0.025817866, 0.053143233, -0.05608657), target2);
	target2 = MulAdd(a3, MF4x4(-0.014672332, 0.06483223, 0.04254691, -0.112299606, 0.23128588, -0.1651168, 0.050003413, 0.04894729, 0.2544582, -0.13577309, -0.0006000951, 0.06801677, 0.09296969, 0.061753552, 0.20265704, 0.257177), target2);
	target2 = MulAdd(b3, MF4x4(-0.14275837, 0.17531338, 0.04749905, -0.0758535, -0.015062751, 0.046983913, -0.1333634, 0.068564706, -0.09043316, -0.31197232, 0.025262894, 0.042436298, -0.0040407367, -0.22480483, 0.041938446, 0.024641208), target2);
	target2 = MulAdd(c3, MF4x4(0.14420901, 0.114887774, -0.11488812, -0.0597554, -0.054847293, 0.05547183, 0.03265681, -0.26890585, 0.03439455, -0.255012, 0.17280143, -0.15793064, -0.078898564, -0.12406215, -0.062780574, 0.10172549), target2);
	target2 = MulAdd(d3, MF4x4(-0.094646096, -0.17374977, -0.0074399756, -0.34635502, 0.07774559, 0.15205993, -0.03449227, -0.06186042, 0.22554572, 0.05784444, 0.12953205, 0.30743182, 0.0064037675, -0.04768125, -0.024676334, -0.038768534), target2);
	target2 = MulAdd(e3, MF4x4(-0.016888129, -0.01739885, -0.100029364, -0.18185234, -0.25301012, -0.057780884, 0.1565648, 0.03068169, -0.11813698, -0.03959661, 0.0833061, 0.15282218, 0.0071316576, -0.07718743, -0.10895751, -0.06739941), target2);
	target2 = MulAdd(f3, MF4x4(0.06317689, 0.18067697, 0.15456977, 0.15414707, -0.17297679, 0.024572203, 0.1171789, 0.07393219, -0.18743253, -0.08222157, 0.11114712, -0.17883265, -0.04287185, -0.09453442, 0.12694365, -0.027343085), target2);
	target2 = MulAdd(g3, MF4x4(-0.06716255, -0.21199013, -0.12669027, 0.21503277, 0.0019133248, 0.0634854, 0.1330296, -0.061205685, 0.29359, 0.17710103, -0.024374757, -0.09792164, -0.18657605, 0.081899285, 0.12585995, 0.025425494), target2);
	target2 = MulAdd(h3, MF4x4(-0.05250748, 0.030909589, 0.1902117, 0.25473362, -0.09742609, 0.053520087, -0.03211081, -0.057595085, 0.12961125, 0.0023426781, -0.013836333, -0.09925751, -0.06785708, 0.08647871, -0.27276617, -0.10692432), target2);
	target2 = MulAdd(i3, MF4x4(0.10256342, -0.0012406971, -0.043700144, 0.18606174, 0.019327404, 0.11292357, -0.15260164, 0.17126434, -0.18879685, -0.16486076, -0.011073295, -0.12524827, -0.008579242, -0.059638925, 0.084539056, -0.117018394), target2);
	target2 = MulAdd(na1, MF4x4(-0.005224277, -0.004213279, -0.0032532548, 0.07730248, 0.09291174, -0.073571384, -0.026436254, 0.03482603, -0.19962324, -0.2610976, 0.020305693, -0.10154568, -0.36644712, 0.051274676, 0.014252039, 0.13887805), target2);
	target2 = MulAdd(nb1, MF4x4(-0.027320823, -0.046729945, -0.026784837, 0.16669074, -0.060943272, 0.033377934, -0.14505643, -0.020337462, 0.16624433, -0.04587067, 0.097641915, 0.081230365, -0.007829853, 0.12665996, -0.14892018, -0.24456674), target2);
	target2 = MulAdd(nc1, MF4x4(-0.08478914, -0.03012501, -0.10310597, -0.11331812, -0.0031645342, 0.14941333, 0.062353395, -0.024058735, -0.0594801, -0.23192395, -0.16746534, 0.06564879, -0.12253713, 0.17433378, -0.0781637, -0.02427467), target2);
	target2 = MulAdd(nd1, MF4x4(-0.02302574, 0.04423824, -0.08400403, 0.09036313, -0.014492948, 0.11002858, 0.18625931, 0.32704633, 0.05124957, -0.068088494, 0.12289486, -0.014215405, -0.13288727, 0.040543802, -0.20918661, 0.073871054), target2);
	target2 = MulAdd(ne1, MF4x4(0.017605199, 0.019553222, -0.08225654, 0.20643222, -0.00022603406, 0.08176717, 0.12868896, 0.124581024, -0.030760515, 0.095257014, -0.22808774, -0.034270126, 0.15100974, -0.3296213, 0.18732856, 0.1324247), target2);
	target2 = MulAdd(nf1, MF4x4(-0.0529032, -0.026973793, -0.05097176, -0.11297454, 0.020022966, -0.018701904, -0.04847294, -0.15029453, -0.06363558, 0.09747056, 0.07460071, -0.03857069, -0.21553952, -0.11073493, -0.213246, 0.0711861), target2);
	target2 = MulAdd(ng1, MF4x4(-0.03162221, 0.001236578, 0.123811916, 0.033390332, -0.037370905, 0.19355269, -0.17827089, 0.014296732, -0.16348897, -0.1319003, -0.16828157, 0.025803383, 0.059980027, 0.110682875, 0.0740905, 0.062085215), target2);
	target2 = MulAdd(nh1, MF4x4(0.045581415, 0.045279585, 0.057199746, -0.02156781, 0.006849691, 0.088090494, 0.0050983853, -0.13634379, -0.027394824, -0.095449656, 0.24879529, -0.096120596, 0.1353526, 0.120924726, -0.18323645, -0.021366404), target2);
	target2 = MulAdd(ni1, MF4x4(-0.09347594, -0.033151172, 0.08154851, -0.043524023, -0.11946553, 0.034201168, 0.29714793, -0.11766968, 0.07862629, -0.022385478, 0.007981411, 0.072274946, -0.07020759, -0.08967969, -0.01748178, -0.050568584), target2);
	target2 = MulAdd(na2, MF4x4(-0.06815112, -0.08195707, -0.018364457, -0.1291466, -0.07578508, -0.026269661, -0.024130398, 0.345771, 0.061061617, 0.00024922745, 0.121253625, 0.1679367, -0.075497314, 0.018176561, -0.016344557, 0.0036648472), target2);
	target2 = MulAdd(nb2, MF4x4(0.04763461, -0.0020346593, -0.02060361, 0.027356124, 0.12256149, -0.10517474, 0.05206596, 0.48938727, 0.24554996, 0.035649568, -0.0020840873, -0.13338771, 0.055847157, 0.08685442, -0.0049057365, 0.119682014), target2);
	target2 = MulAdd(nc2, MF4x4(-0.0009415129, 0.023808502, 0.011839588, 0.1557796, -0.046566915, -0.16340078, 0.057526406, 0.051289674, 0.009036062, -0.033471756, 0.04899847, 0.08597252, 0.009778078, 0.15277503, -0.02124232, -0.13266967), target2);
	target2 = MulAdd(nd2, MF4x4(0.044579845, -0.057439465, -0.0058995294, -0.016733315, -0.026765248, 0.22384825, 0.10160812, -0.24921204, 0.1505643, 0.10299508, -0.022949796, 0.023317415, -0.11803905, -0.010997904, -0.0165606, 0.10949375), target2);
	target2 = MulAdd(ne2, MF4x4(-0.024293665, 0.080889955, 0.065993495, -0.08183072, 0.15339898, -0.10386374, -0.0075264974, -0.45434427, 0.16638929, 0.18546598, -0.15133487, -0.04405705, -0.11456945, 0.023287205, 0.01540089, 0.07659333), target2);
	target2 = MulAdd(nf2, MF4x4(0.05337434, -0.07030085, -0.016662175, -0.025540289, -0.20320894, -0.22829315, 0.0023119978, -0.13647676, 0.14624248, 0.057653934, -0.23686588, -0.22728209, -0.04211661, -0.009623881, -0.013481165, -0.050968897), target2);
	target2 = MulAdd(ng2, MF4x4(-0.10351371, -0.030414786, -0.021908734, 0.10631468, 0.1558724, -0.030323582, -0.12572181, 0.14325237, 0.16137493, 0.053329308, -0.07966373, -0.14599875, 0.06742195, -0.03502627, 0.093494855, -0.016484367), target2);
	target2 = MulAdd(nh2, MF4x4(-0.010210213, -0.07126592, 0.08901449, -0.001978569, -0.0020932974, 0.05631864, -0.07674242, 0.07440119, -0.10262469, 0.06294099, 0.2640596, -0.068250656, 0.039236706, -0.05372906, -0.24834888, -0.027236471), target2);
	target2 = MulAdd(ni2, MF4x4(0.053275097, 0.12541588, 0.057327554, 0.1483746, -0.019743394, -0.004537443, -0.002553759, 0.051015604, 0.15611948, 0.0062136482, 0.15442398, -0.17060183, 0.072183914, 0.030539684, 0.122384906, 0.13613632), target2);
	target2 = MulAdd(na3, MF4x4(-0.081967466, -0.045659952, 0.053518385, 0.038269065, -0.20554744, 0.1022743, -0.16302924, 0.11628324, 0.08677866, -0.016249105, 0.0030073056, 0.029243115, 0.09487045, -0.08571386, -0.108643636, 0.023155121), target2);
	target2 = MulAdd(nb3, MF4x4(0.13383357, -0.14805956, -0.0026678462, 0.096683614, -0.19977921, 0.06789931, 0.11313261, -0.08059509, 0.11312805, 0.02279778, -0.028791273, 0.00220455, 0.1280279, -0.0031435476, 0.027489156, 0.22506006), target2);
	target2 = MulAdd(nc3, MF4x4(-0.17668596, 0.056276754, 0.06092557, 0.06512077, 0.28657347, -0.16558819, -0.032547206, 0.060506567, 0.042512514, 0.012298008, -0.0840555, -0.003036976, -0.065048106, 0.01438789, -0.022174913, -0.04558888), target2);
	target2 = MulAdd(nd3, MF4x4(0.09863285, 0.20795937, 0.022519527, 0.18537116, 0.0392277, -0.0321246, -0.026941739, -0.113379315, -0.066700965, -0.03651247, 0.0571846, -0.030824896, 0.096933104, 0.15837808, -0.0047979183, 0.27915525), target2);
	target2 = MulAdd(ne3, MF4x4(0.102253675, 0.009542945, -0.005872879, 0.16511136, 0.011185962, 0.06349425, 0.015944714, -0.070249364, 0.17597549, -0.0073095546, 0.06678522, -0.048394345, 0.07822778, 0.1582912, 0.029773576, 0.1454936), target2);
	target2 = MulAdd(nf3, MF4x4(-0.064127095, -0.13314691, -0.15525493, -0.12851773, 0.32410213, 0.11451161, -0.16337484, 0.22651163, 0.0670393, -0.010159622, 0.061997004, -0.0028491814, -0.12702557, -0.02556835, -0.030351989, -0.101927444), target2);
	target2 = MulAdd(ng3, MF4x4(-0.10687288, 0.013433122, 0.035762146, -0.07343635, -0.057016056, -0.041276235, -0.08300978, 0.0058231223, 0.014210706, 0.24323368, 0.010536771, 0.037272993, 0.14479576, 0.0013622575, 0.0004501183, 0.17661947), target2);
	target2 = MulAdd(nh3, MF4x4(0.056699157, -0.009144585, -0.20287608, -0.17288777, -0.031525977, -0.014541391, 0.09615033, -0.020868845, -0.06501473, -0.015121819, 0.20430197, -0.04346306, -0.12766391, 0.093933746, -0.027732635, 0.11136926), target2);
	target2 = MulAdd(ni3, MF4x4(-0.08438437, -0.1183074, -0.12171084, -0.016565872, 0.011952218, -0.058289453, 0.13479574, -0.0013566733, 0.20290127, 0.03338366, -0.1634658, 0.11389365, -0.060460836, 0.05049821, -0.14498705, 0.016767675), target2);

	MF4 target3 = { -0.07961375, -0.07668534, 0.030482467, 0.035888318 };
	target3 = MulAdd(a1, MF4x4(-0.20980129, 0.023968311, 0.12840137, 0.10842146, 0.011306613, 0.05415782, 0.039082862, 0.16055544, -0.019953849, -0.038693313, 0.043451615, 0.29995796, -0.04229376, -0.052874412, -0.043818697, 0.12305407), target3);
	target3 = MulAdd(b1, MF4x4(-0.05386288, 0.060217176, 0.115249164, -0.06499263, -0.24467815, -0.038295876, 0.1099765, 0.011418658, -0.037247434, 0.022481795, -0.022084411, 0.08719741, 0.112991996, 0.0038797192, 0.0007742727, -0.12125326), target3);
	target3 = MulAdd(c1, MF4x4(0.14591883, 0.0059707207, 0.10084995, 0.11218308, -0.06853006, 0.056708243, 0.03836111, 0.097718365, -0.03493398, -0.025623012, -0.05587737, -0.08457079, 0.028527644, -0.12509371, 0.10159183, -0.1373413), target3);
	target3 = MulAdd(d1, MF4x4(-0.070879295, 0.12866656, 0.0061003384, 0.2756249, -0.110929534, 0.08008204, 0.103428364, 0.0680596, 0.25671995, -0.20484821, 0.07494457, -0.30119568, -0.0037036634, 0.089072324, 0.08692298, 0.070883), target3);
	target3 = MulAdd(e1, MF4x4(-0.010380239, -0.09510446, -0.082714744, -0.17768058, 0.07806542, 0.031258516, 0.22199117, -0.2503904, -0.35995534, 0.22030926, 0.31575105, 0.00959926, -0.01777953, 0.0140022775, 0.03752933, 0.09948206), target3);
	target3 = MulAdd(f1, MF4x4(-0.041341938, -0.07633474, -0.0198307, -0.0010591226, -0.00981418, 0.054734066, 0.07465484, 0.18272892, -0.081466086, -0.016789936, 0.01381776, 0.19449398, -0.16821295, -0.17434129, -0.03367363, -0.29107878), target3);
	target3 = MulAdd(g1, MF4x4(0.03371505, 0.0015008952, 0.038456205, 0.08681006, 0.06587572, 0.080483936, -0.046148404, 0.00034004613, -0.049788523, -0.014699005, 0.12648652, -0.08964094, -0.04100757, -0.0022513492, -0.045995962, -0.033430565), target3);
	target3 = MulAdd(h1, MF4x4(-0.077466115, 0.055482663, 0.06427869, -0.014551742, -0.03726866, -0.050230574, 0.13511398, -0.14205348, -0.03461195, 0.031386618, 0.0590859, 0.032402404, -0.015786028, 0.086712435, 0.0989059, 0.031410974), target3);
	target3 = MulAdd(i1, MF4x4(-0.034690183, -0.038256433, -0.011660002, 0.0063596303, 0.038892817, 0.11872877, 0.0003016667, 0.08520122, 0.0941757, 0.073596634, 0.08374554, 0.046010435, 0.0181265, -0.15729031, 0.11088375, -0.032952093), target3);
	target3 = MulAdd(a2, MF4x4(-0.026296677, 0.15765159, -0.012793888, 0.0082718665, 0.12780726, -0.0118969055, -0.089828335, -0.24008913, 0.19047114, 0.03790669, 0.10990294, -0.14094876, 0.031807188, 0.044609103, -0.1013979, 0.008491038), target3);
	target3 = MulAdd(b2, MF4x4(0.053833764, 0.26152018, -0.04398908, -0.060880598, -0.028556267, -0.04798034, 0.006057095, -0.19898368, -0.24473669, 0.0472649, 0.15300584, 0.028983278, 0.028763462, -0.017422339, 0.03820097, 0.083550654), target3);
	target3 = MulAdd(c2, MF4x4(0.0082439445, -0.0012358675, -0.013711661, 0.07154783, 0.07983732, -0.015840268, 0.034440894, -0.04973906, -0.18109304, 0.05403726, -0.03891083, -0.016710335, 0.10012702, 0.02470262, 0.0085716015, -0.0851344), target3);
	target3 = MulAdd(d2, MF4x4(0.04101796, 0.060623523, 0.011851002, -0.028376777, -0.025862841, -0.042955548, -0.1211269, -0.13360673, 0.0071736956, -0.18880656, 0.276794, -0.011204949, 0.020503378, 0.0110537205, 0.10886233, -0.003678301), target3);
	target3 = MulAdd(e2, MF4x4(-0.14220405, -0.15436499, -0.13759659, -0.03390728, 0.21921699, -0.003154918, -0.101451315, 0.043704413, -0.12738566, 0.19500181, 0.45843616, 0.065685, -0.20168468, 0.12985173, -0.02569477, 0.17067434), target3);
	target3 = MulAdd(f2, MF4x4(0.032667797, 0.16730979, 0.004677948, -9.4643896e-05, -0.014588183, -0.057854652, 0.013125396, 0.096397184, -0.054806076, 0.010901007, 0.0968573, -0.23783323, 0.08697233, 0.008680743, -0.035573848, -0.004963115), target3);
	target3 = MulAdd(g2, MF4x4(-0.00958006, 0.03317287, -0.01340794, -0.018926572, -0.05369498, -0.03341796, 0.030888261, -0.0010606453, 0.039325304, -0.16673934, 0.06557901, -0.08155623, -0.02527372, -0.17023365, 0.015217776, -0.040017188), target3);
	target3 = MulAdd(h2, MF4x4(-0.015815312, -0.042971406, 0.067791514, -0.08905113, -0.09565908, 0.04346861, -0.06728161, 0.15545414, 0.18861936, -0.031062441, 0.23719235, 0.037903327, 0.07448, 0.035912767, -0.011007527, -0.01686951), target3);
	target3 = MulAdd(i2, MF4x4(0.0177658, 0.058648083, -0.028266283, 0.074122384, -0.114152886, -0.1088884, -0.00045867384, 0.12350585, -0.028705545, 0.07543727, 0.019930601, 0.05765993, 0.030875817, -0.01684014, 0.03873862, -0.29210237), target3);
	target3 = MulAdd(a3, MF4x4(0.13872401, 0.0026290037, 0.120320186, -0.096298255, -0.22042315, -0.024083365, 0.021574842, -0.120338276, -0.030302105, 0.0030427484, -0.048579045, 0.11119769, 0.17029862, -0.03042154, -0.008851885, -0.04858139), target3);
	target3 = MulAdd(b3, MF4x4(0.08693055, 0.0035178792, 0.0072182836, -0.21177882, -0.12236571, -0.041778523, -0.07611475, 0.1860772, -0.07140713, 0.079063386, 0.16111141, 0.10981697, -0.11631706, 0.00499998, 0.03531511, 0.112886176), target3);
	target3 = MulAdd(c3, MF4x4(0.31241155, -0.155902, 0.026360337, 0.11567123, -0.01410306, 0.043105874, 0.06448718, -0.15669721, -0.10699524, 0.14620166, -0.022471936, 0.16952698, -0.0043298705, 0.012148871, -0.06097046, 0.13138528), target3);
	target3 = MulAdd(d3, MF4x4(0.04631855, 0.16682167, -0.08682791, 0.031910088, -0.10863085, -0.05405996, 0.20847258, -0.25902548, -0.21886107, -0.016768524, 0.018900516, 0.016220776, 0.086765796, -0.086313486, 0.061806828, -0.042748976), target3);
	target3 = MulAdd(e3, MF4x4(-0.22026716, -0.060322747, 0.055743527, -0.20811775, 0.15368998, -0.05755373, -0.1723089, 0.053601813, 0.3936026, -0.13520636, 0.13089643, -0.09859593, -0.08306327, 0.12936836, 0.1387318, 0.0221951), target3);
	target3 = MulAdd(f3, MF4x4(0.14327681, -0.19199587, 0.02808416, -0.13307315, 0.12417994, -0.06954055, -0.11516412, -0.16203047, 0.085192114, 0.020538192, -0.10626918, 0.13578235, -0.042099748, 0.17358838, 0.040398534, 0.14976105), target3);
	target3 = MulAdd(g3, MF4x4(-0.053998414, 0.12475386, -0.17873338, -0.06543859, 0.007933435, -0.07924536, -0.00051635655, -0.0015982009, 0.0397255, -0.16369022, 0.03679988, 0.100230515, -0.03289991, 0.043998964, 0.058887206, -0.09575534), target3);
	target3 = MulAdd(h3, MF4x4(-0.0027977703, 0.17769088, -0.104156405, -0.1011918, -0.042667318, 0.19569083, 0.0944246, 0.05381444, 0.27140749, -0.12598918, 0.40728518, -0.16019246, 0.07478889, 0.07995141, -0.055247143, -0.015301875), target3);
	target3 = MulAdd(i3, MF4x4(-0.10702615, 0.08362206, -0.12840238, 0.23424083, -0.11492997, 0.14988491, -0.058391277, -0.012141015, 0.15102027, 0.14370169, 0.04101889, 0.18302867, 0.11423182, 0.026963422, 0.02742905, 0.05555466), target3);
	target3 = MulAdd(na1, MF4x4(0.0170646, -0.040626798, -0.086295746, -0.08303102, 0.07351082, -0.10439346, -0.09158801, 0.143845, 0.016958551, 0.21520329, 0.041720334, -0.11638024, 0.087674506, 0.12561873, -0.21283507, -0.23356001), target3);
	target3 = MulAdd(nb1, MF4x4(-0.011983947, 0.026985325, -0.10494964, 0.045505363, 0.06308739, -0.0132794585, -0.19216236, 0.0044559645, -0.21042153, 0.026115706, -0.08442747, 0.08834091, 0.13262731, -0.06231853, -0.20550017, 0.03952042), target3);
	target3 = MulAdd(nc1, MF4x4(-0.13586617, -0.0021369287, -0.121751934, -0.019784765, 0.03198282, -0.17328545, -0.10135551, -0.0024194748, -0.04619262, 0.21542613, -0.09846654, 0.081278816, 0.16300274, 0.01612674, -0.0033168197, -0.0257739), target3);
	target3 = MulAdd(nd1, MF4x4(0.1674388, 0.01902311, 0.007676536, -0.12779048, 0.18292421, -0.22342151, -0.05965652, 0.14477763, -0.09779103, 0.14098361, -0.16848993, 0.19790487, 0.006252736, 0.22206211, -0.15818825, 0.08966031), target3);
	target3 = MulAdd(ne1, MF4x4(0.17080314, 0.069508895, -0.038767304, 0.18950053, -0.08592572, -0.20979418, -0.21214612, 0.3330128, 0.30952567, -0.107134975, -0.16258, 0.022875668, -0.02457244, -0.12532432, -0.24953507, 0.059734188), target3);
	target3 = MulAdd(nf1, MF4x4(-0.0018491185, 0.033706773, -0.1065624, 0.025152596, -0.016163057, -0.041699793, -0.12381229, -0.025942512, 0.13162622, 0.03565028, 0.029629026, -0.018657705, -0.1921952, 0.101777196, -0.06653633, 0.079698876), target3);
	target3 = MulAdd(ng1, MF4x4(-0.040848907, 0.013372185, -0.061049856, -0.05829793, 0.03286879, -0.23536444, -0.056496553, 0.10049081, 0.0040958193, 0.1146177, 0.05323595, -0.040001456, -0.07206396, 0.052719124, -0.11720367, 0.12925144), target3);
	target3 = MulAdd(nh1, MF4x4(0.08204122, -0.04806825, 0.03865589, -0.016993582, 0.004172861, -0.025698105, -0.01519582, 0.1425758, 0.02170024, 0.105864905, -0.03567325, -0.016229391, 0.22955607, -0.043812234, 0.045955688, 0.07391785), target3);
	target3 = MulAdd(ni1, MF4x4(0.025563411, 0.016936684, 0.054015722, -0.03440089, 0.0448358, 0.012403107, 0.011840847, -0.10125541, 0.03623299, -0.005010518, -0.043322872, -0.17361045, 0.015130423, 0.1813893, 0.0017346571, 0.07948043), target3);
	target3 = MulAdd(na2, MF4x4(-0.027647035, -0.0092600705, -0.05360344, -0.03877652, 0.028799497, 0.002088597, -0.13616459, 0.14142619, -0.26286268, -0.10349014, -0.066500075, 0.009223449, 0.08260629, -0.037491266, 0.019173276, -0.022004724), target3);
	target3 = MulAdd(nb2, MF4x4(0.004824502, -0.114328325, -0.0023743433, 0.027862813, -0.019098494, 0.050463524, -0.11528185, 0.22641957, -0.025532806, 0.007936803, -0.064679936, -0.055090822, 0.07407797, 0.052605998, -0.043648902, -0.16713037), target3);
	target3 = MulAdd(nc2, MF4x4(0.078680634, 0.020991815, 0.008421187, 0.010790185, 0.032945324, 0.13025786, -0.14650385, 0.053448163, -0.0028072142, 0.039515216, 0.1282605, -0.029288173, -0.029804084, -0.13323198, -0.054916043, 0.056681957), target3);
	target3 = MulAdd(nd2, MF4x4(-0.09560204, -0.0669099, 0.005074813, 0.09496971, 0.027659275, -0.2191003, 0.29730386, -0.022740293, -0.025892505, -0.1871456, 0.028785622, -0.12673095, 0.0664705, -0.08389141, -0.089651205, -0.15402664), target3);
	target3 = MulAdd(ne2, MF4x4(0.0063571655, 0.15680969, 0.061591282, 0.03752913, -0.041436892, 0.075064555, 0.20300192, 0.031942736, 0.0804296, -0.22194067, -0.20516422, 0.07361, -0.15353987, 0.25465, 0.008901653, 0.10683235), target3);
	target3 = MulAdd(nf2, MF4x4(-0.006734436, -0.14774522, -0.031374577, -0.1032655, 0.11299578, 0.1205544, 0.11802791, -0.0612094, 0.03863345, 0.09838008, 0.037064772, 0.029507324, -0.051219307, -0.055263996, 0.02356915, -0.16056564), target3);
	target3 = MulAdd(ng2, MF4x4(-0.06996934, -0.015304054, -0.009411581, 0.030309107, 0.10674073, -0.020733232, -0.115811616, 0.031903993, -0.049218595, -0.067377076, 0.26841155, -0.06866156, -0.09156055, -0.10751758, -0.022639344, -0.18830526), target3);
	target3 = MulAdd(nh2, MF4x4(0.020456642, -0.035503354, -0.09457199, 0.05264921, 0.24155058, 0.12630259, -0.045381807, -0.12230558, -0.03225022, 0.04103188, -0.13622516, -0.0040657576, 0.023767322, -0.051124092, 0.09194598, -0.03766687), target3);
	target3 = MulAdd(ni2, MF4x4(-0.016005656, -0.05218363, 0.029727828, -0.1604237, -0.009916855, -0.024033275, -0.14342757, 0.083073266, 0.057055146, -0.013757824, 0.15497124, -0.17284107, 0.05109579, 0.013304962, -0.06706223, 0.06251818), target3);
	target3 = MulAdd(na3, MF4x4(0.06668304, 0.009187671, -0.047118776, 0.07131393, -0.17141497, -0.015085916, 0.004049452, -0.035744824, 0.032192133, 0.15326595, 0.044383276, 0.14035697, -0.090966456, 0.14161377, -0.015315352, 0.11275578), target3);
	target3 = MulAdd(nb3, MF4x4(-0.13508414, 0.0785333, 0.009038879, 0.1607147, 0.22703816, 0.033339903, -0.03727777, -0.31905726, -0.069729164, 0.036481526, -0.025714623, 0.0851529, -0.12554394, 0.105045296, 0.059951913, -0.0604455), target3);
	target3 = MulAdd(nc3, MF4x4(-0.20849659, 0.088841915, -0.1109168, -0.08992707, 0.31967592, 0.005481088, 0.22387522, 0.02098377, -0.0497405, -0.025430094, -0.0043220813, 0.060257867, -0.21568587, 0.067227446, -0.057946377, 0.06617755), target3);
	target3 = MulAdd(nd3, MF4x4(0.076282814, -0.20857447, 0.056654572, -0.014142213, 0.029527945, -0.07234652, -0.094661996, 0.22620171, 0.042960577, 0.013866398, 0.036293183, 0.14942285, 0.076137245, -0.002794117, -0.1168563, -0.0146170305), target3);
	target3 = MulAdd(ne3, MF4x4(0.10552861, -0.15840133, -0.03899879, 0.23962662, 0.04375998, 0.1696087, 0.037471466, -0.2348845, -0.04425561, -0.09243792, -0.12540625, 0.013209438, 0.20652635, 0.28815508, -0.14443508, -0.045806926), target3);
	target3 = MulAdd(nf3, MF4x4(-0.18040875, 0.101635806, 0.022794934, 0.01974664, 0.24168968, -0.09383824, -0.05368557, 0.095760964, -0.03084522, 0.03096591, -0.025146073, -0.15247615, -0.07991138, 0.041957334, 0.13305306, 0.10435218), target3);
	target3 = MulAdd(ng3, MF4x4(-0.12386387, -0.07711658, -0.010701461, -0.15226945, 0.13125682, -0.05067199, 0.05759467, 0.06512925, -0.087202296, -0.09307128, 0.074678324, -0.118310176, 0.013819953, 0.078637935, 0.060606144, 0.024220081), target3);
	target3 = MulAdd(nh3, MF4x4(0.034386832, -0.18846357, -0.039673664, 0.113117084, -0.045039542, -0.10561991, -0.073102295, -0.3002364, 0.03678976, 0.12222279, -0.115726635, 0.07686326, 0.040241316, 0.1602316, 0.09017754, -0.115864284), target3);
	target3 = MulAdd(ni3, MF4x4(0.052414972, 0.033908065, 0.08952466, -0.17085709, 0.006635481, -0.040943716, -0.21519491, 0.04866619, -0.04725049, -0.05258961, -0.014845829, -0.26571122, 0.07195377, 0.20871797, -0.068733044, 0.15962349), target3);

	MF3 target4 = MulAdd(e1, MF4x3(0.053345524, 0.066197485, 0.07259881, 0.05303127, 0.06742834, 0.07375377, 0.094053976, -7.700613e-05, -0.02473139, 0.005308593, 0.03030767, 0.039729137), 0.0);
	target4 = MulAdd(e2, MF4x3(-0.108758785, 0.037586506, 0.065435104, 0.027483977, -0.05654698, -0.076396726, 0.105040714, 0.05024414, 0.021126145, -0.0674868, -0.0055504893, 0.02190656), target4);
	target4 = MulAdd(e3, MF4x3(-0.053890713, 0.0071396744, 0.016984116, -0.045092918, 0.025137635, 0.041979324, -0.03408237, 0.0019260172, 0.005701325, -0.02040999, -0.01315308, -0.00639404), target4);
	target4 = MulAdd(ne1, MF4x3(-0.073155664, -0.06887698, -0.072435565, -0.08694837, -0.05531286, -0.055365037, -0.06690585, -0.00129934, 0.013128711, -0.045931015, 0.017999481, 0.021670034), target4);
	target4 = MulAdd(ne2, MF4x3(0.14758188, -0.052864034, -0.06617946, -0.025215192, 0.005785653, 0.02022865, -0.07359226, -0.034944568, -0.01911832, -0.059109453, 0.0018033485, -0.022261323), target4);
	target4 = MulAdd(ne3, MF4x3(0.079963796, 0.018210623, -0.0025736517, 0.06693135, -0.038985185, -0.04726813, -0.03559407, -0.0083629545, -0.005753532, 0.043954816, -0.022223696, -0.039470144), target4);

	tex1[gxy] = target1;
	tex2[gxy] = target2;
	tex3[gxy] = target3;
	tex7[gxy] = MF4(target4, 1);
}

//!PASS 6
//!DESC Conv-4x3x3x24
//!IN tex1, tex2, tex3, tex7
//!OUT tex4, tex5, tex6, tex8
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass6(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = tex1.SampleLevel(sam, pos, 0);
	MF4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = tex2.SampleLevel(sam, pos, 0);
	MF4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    MF4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = tex3.SampleLevel(sam, pos, 0);
	MF4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target1 = { 0.04207974, -0.22892998, 0.061954536, 0.076551735 };
	target1 = MulAdd(a1, MF4x4(0.09584929, -0.095243275, 0.08022671, 0.075294726, 0.18445255, -0.082423694, -0.097833045, -0.021506732, -0.21379599, -0.023127496, -0.18897046, 0.023956126, -0.060177475, 0.027762169, 0.19984011, -0.20838684), target1);
	target1 = MulAdd(b1, MF4x4(0.012249506, -0.12688737, -0.12119437, 0.10179773, -0.09664198, -0.0030920326, -0.030286502, -0.20217018, 0.34590152, -0.05034654, 0.049923953, -0.043337423, 0.25000378, -0.028680135, 0.16001691, -0.066234544), target1);
	target1 = MulAdd(c1, MF4x4(-0.08372182, -0.089819506, -0.013704554, 0.04556739, -0.114813834, -0.06466441, 0.03785733, -0.0062836753, 0.047535792, 0.06347279, -0.007735239, 0.049881376, 0.20055495, 0.047256388, -0.09947006, 0.0025243685), target1);
	target1 = MulAdd(d1, MF4x4(0.3671971, -0.05361603, -0.12586144, 0.12522058, 0.13843551, -0.06033578, 0.22667646, -0.08870703, 0.01452431, 0.17809536, 0.13784996, 0.15395631, 0.0001755052, 0.30571333, -0.14230241, -0.22773817), target1);
	target1 = MulAdd(e1, MF4x4(-0.27697307, 0.19896318, -0.055979818, -0.27574858, 0.06590851, -0.083754696, 0.26534772, 0.04968563, 0.028200507, 0.11523887, 0.07717626, -0.037011877, 0.013540311, -0.015524421, 0.20788544, 0.16297664), target1);
	target1 = MulAdd(f1, MF4x4(-0.13144116, -0.14546596, 0.10977632, 0.010728187, 0.025761489, -0.018065382, 0.06367839, 0.14230403, 0.12607081, -0.0124253975, 0.31784698, -0.017743418, -0.022748945, 0.05433257, 0.0031092372, -0.031199085), target1);
	target1 = MulAdd(g1, MF4x4(0.21655789, 0.011040414, 0.06492884, 0.0706221, 0.09610853, 0.057776507, 0.009683445, -0.060912937, 0.021881321, -0.19671698, -0.0130090965, -0.013112566, -0.085476145, 0.038455218, -0.0014731084, -0.0831875), target1);
	target1 = MulAdd(h1, MF4x4(0.37602007, 0.0823336, 0.24707538, -0.09009795, -0.017044, -0.12772176, -0.17441119, -0.042144842, 0.09458421, 0.28926283, 0.06927162, -0.06356304, 0.2206176, 0.1834394, -0.055222265, -0.13328971), target1);
	target1 = MulAdd(i1, MF4x4(-0.12759925, -0.1872996, 0.12348925, 0.09169479, 0.2032652, 0.021332331, -0.02606638, -0.30383334, 0.11312311, -0.12563488, 0.07815656, 0.033551723, 0.073155805, 0.022491606, -0.004879681, -0.020566663), target1);
	target1 = MulAdd(a2, MF4x4(-0.0074200626, -0.045258366, -0.11789159, 0.15158547, 0.021973789, 0.013558428, -0.06303165, -0.014261419, -0.005217678, -0.08988565, -0.032385588, -0.16513458, -0.00094591687, 0.105432004, 0.008511094, 0.064075306), target1);
	target1 = MulAdd(b2, MF4x4(-0.11356488, 0.033568926, -0.0035593451, -0.1380603, -0.09776493, 0.16050343, 0.14889094, -0.20236592, -0.13227837, -0.3369538, -0.08290829, -0.102781296, -0.0008081758, 0.25186548, 0.045406237, -0.08264705), target1);
	target1 = MulAdd(c2, MF4x4(0.012680731, 0.045382235, -0.099822015, 0.052455686, -0.017731141, 0.2148587, -0.025351917, 0.031683072, -0.25334007, 0.0181896, -0.0813112, -0.12272559, 0.04371032, 0.065688565, -0.020920211, 0.23614638), target1);
	target1 = MulAdd(d2, MF4x4(0.07416445, -0.1632982, 0.019079927, 0.033240702, 0.13220134, -0.09758509, -0.09742767, 0.0003053599, 0.110648625, -0.06813206, 0.10455032, -0.037899535, -0.03261096, 0.06280864, -0.17577846, -0.279448), target1);
	target1 = MulAdd(e2, MF4x4(0.032076143, 0.00038162203, 0.01970988, -0.040755652, 0.14594907, -0.29632306, 0.18186367, 0.06210379, 0.089618064, -0.20777738, -0.11941431, -0.047921117, 0.069467194, -0.061959818, -0.097263746, 0.20329393), target1);
	target1 = MulAdd(f2, MF4x4(0.13389389, 0.053396456, 0.15672714, 0.1585184, 0.019925753, 0.08114361, 0.1381434, 0.06507304, -0.021846443, -0.040439755, 0.028436588, -0.1502027, -0.01547767, -0.09032624, 0.1101168, -0.044395007), target1);
	target1 = MulAdd(g2, MF4x4(-0.08236856, 0.25564417, 0.15329555, 0.054097474, 0.12049528, -0.076263994, -0.19988477, 0.01916389, 0.097000316, -0.15214846, 0.1360054, -0.0007913522, -0.22950296, 0.0919526, -0.0045635877, 0.16661373), target1);
	target1 = MulAdd(h2, MF4x4(-0.19546251, 0.008113141, -0.08576472, 0.23981415, 0.037918933, -0.106971025, -0.19296011, 0.064365655, -0.1451187, 0.03483461, 0.03271891, -0.001744038, -0.24933495, 0.0021132312, -0.15542698, 0.041852806), target1);
	target1 = MulAdd(i2, MF4x4(0.07619386, 0.17014128, 0.05875971, 0.056373183, 0.077981666, -0.034455027, -0.09977959, 0.019308453, -0.097891875, -0.011260777, 0.009704571, -0.091228284, 0.072402045, 0.1679339, -0.021336546, -0.078355595), target1);
	target1 = MulAdd(a3, MF4x4(-0.10250763, 0.07651088, -0.0131817255, 0.035391405, 0.1545587, -0.005520408, 0.18242277, 0.034118786, -0.0512669, 0.09563292, -0.0063671293, 0.017505696, 0.038793128, -0.23837951, 0.047975145, 0.17773068), target1);
	target1 = MulAdd(b3, MF4x4(-0.0031853304, 0.1552162, 0.16779172, -0.06020084, -0.19057243, -0.13034964, -0.028302211, -0.1005563, -0.025626518, 0.087223954, 0.19338006, -0.06066401, -0.2122666, 0.001640063, 0.033021607, 0.06684525), target1);
	target1 = MulAdd(c3, MF4x4(0.10043514, 0.033739183, 0.01542628, -0.07931681, 0.032161597, 0.16379037, 0.050983094, -0.030686958, 0.19189216, -0.15878248, 0.01945422, -0.02624594, -0.10871623, -0.06925224, 0.020812772, 0.07386481), target1);
	target1 = MulAdd(d3, MF4x4(0.012129095, -0.029043682, -0.054882783, -0.04798959, 0.12916534, -0.012814343, 0.06516883, -0.054208606, 0.2625884, 0.008694777, -0.16992761, -0.041635927, 0.10295491, -0.04496253, 0.14063339, 0.15155916), target1);
	target1 = MulAdd(e3, MF4x4(-0.09972329, -0.2031706, 0.15199123, 0.136278, -0.030424237, 0.01253304, -0.22483149, -0.04429611, -0.0058194255, 0.32650772, -0.13599585, -0.15167284, 0.13211648, 0.06883629, 0.13449487, 0.1419326), target1);
	target1 = MulAdd(f3, MF4x4(0.16303232, -0.12681945, -0.24028221, -0.018534243, 0.048438597, 0.02196457, -0.26033646, 0.11363536, -0.23852448, -0.2250161, 0.054867614, -0.042418674, 0.036863618, 0.16061254, -0.103400566, -0.054900676), target1);
	target1 = MulAdd(g3, MF4x4(0.0018444043, 0.047589947, 0.15244149, 0.026401952, -0.16383879, 0.2288589, -0.067270175, 0.035644963, -0.046972964, -0.079998486, -0.07510886, 0.086569756, 0.088215984, -0.08220123, 0.006012456, -0.081925176), target1);
	target1 = MulAdd(h3, MF4x4(-0.20731804, -0.105194375, 0.1735274, -0.13702598, -0.08078456, -0.08891678, -0.20113394, 0.20032553, 0.23738097, -0.06555696, 0.0073099127, -0.24053259, -0.19441254, 0.044497594, -0.085050255, -0.45097253), target1);
	target1 = MulAdd(i3, MF4x4(-0.015630659, 0.096795596, -0.05207522, -0.021776563, -0.052400976, 0.0060831443, 0.19417833, 0.14141484, -0.031068498, -0.031282816, -0.0053475797, 0.16884208, -0.049706176, -0.117957756, -0.122313395, -0.22831066), target1);
	target1 = MulAdd(na1, MF4x4(-0.13027157, 0.11083156, -0.05295985, -0.13405156, -0.25512117, 0.007962338, -0.19477697, -0.043301556, 0.10253565, -0.12592895, 0.05690188, -0.03008582, -0.08713882, -0.05253795, -0.05898243, 0.07648529), target1);
	target1 = MulAdd(nb1, MF4x4(-0.028103404, 0.107655846, 0.06792543, 0.038461875, -0.17316198, 0.045686997, -0.1318844, 0.1923057, -0.10082274, 0.023855874, 0.014650556, 0.07000885, 0.03179704, -0.17100379, 0.060464893, -0.05120159), target1);
	target1 = MulAdd(nc1, MF4x4(-0.008488711, 0.10152624, -0.08714461, -0.054719266, -0.0132024065, 0.06630249, -0.0070151696, -0.076831385, 0.15455176, 0.065892935, 0.06491651, 0.07013989, -0.016401365, 0.1033902, -0.026735194, 0.09976299), target1);
	target1 = MulAdd(nd1, MF4x4(-0.062281746, 0.11808364, 0.064350896, -0.077770054, -0.10968356, 0.08668185, -0.14066383, 0.020038921, 0.21482739, 0.01405822, -0.05047993, -0.098990895, 0.113971226, -0.07471277, 0.14986148, 0.087345585), target1);
	target1 = MulAdd(ne1, MF4x4(-0.06364801, -0.17296022, -0.17889057, 0.20986524, -0.022308208, -0.13067317, -0.1608613, 0.005560176, 0.18469712, 0.08284309, -0.16637094, -0.1101153, 0.0047913613, 0.085900925, -0.19173592, -0.336121), target1);
	target1 = MulAdd(nf1, MF4x4(0.32434624, -0.11097179, -0.2576656, -0.035399284, 0.12601346, 0.12047275, -0.08445279, -0.22353333, 0.275204, -0.028347714, -0.1910839, -0.105464876, -0.17244552, 0.10430915, 0.07988085, -0.024917416), target1);
	target1 = MulAdd(ng1, MF4x4(-0.38803256, 0.12614547, 0.113965005, -0.05710032, -0.2639457, 0.015134661, 0.018303871, 0.060708337, 0.18753609, 0.025863146, 0.09349249, -0.034619175, 0.078573935, 0.034479834, 0.03612244, -0.08949277), target1);
	target1 = MulAdd(nh1, MF4x4(-0.16215962, -0.030498799, -0.10899874, -0.03440776, -0.015821088, 0.029496742, 0.13228656, -0.16718344, -0.14563835, -0.17501803, -0.004510379, 0.020998359, 0.06548722, -0.13759966, 0.07444127, 0.10629099), target1);
	target1 = MulAdd(ni1, MF4x4(0.0698536, 0.23689122, -0.0060213935, -0.0015028039, 0.039947093, 0.11350835, 0.19953221, 0.08415087, 0.22800536, 0.06906256, -0.06636992, -0.24212533, -0.0023316562, 0.011869679, 0.25965255, -0.012204548), target1);
	target1 = MulAdd(na2, MF4x4(-0.000661378, 0.10967955, 0.058565635, -0.15265211, 0.14624023, -0.03375811, 0.05981829, -0.022552123, 0.070834555, -0.022453807, 0.019191928, 0.08326683, 0.0777132, 0.08895826, 0.023328163, 0.053312927), target1);
	target1 = MulAdd(nb2, MF4x4(0.043799512, 0.12866509, -0.046365067, 0.24239258, -0.11673964, -0.025937054, -0.12636824, 0.100062154, -0.10018257, 0.19266897, 0.06142848, -0.14361443, -0.021221312, -0.30052304, -0.20469959, 0.14677355), target1);
	target1 = MulAdd(nc2, MF4x4(-0.015183433, -0.19820379, -0.15852103, 0.054332163, 0.0071695223, 0.084583715, 0.24957466, -0.051836044, -0.1983422, -0.08417326, 0.08057586, -0.0437153, -0.01875922, -0.09707154, -0.15741958, -0.017708866), target1);
	target1 = MulAdd(nd2, MF4x4(-0.29747635, 0.07556405, -0.024965616, -0.035462193, 0.00015182442, 0.039648414, -0.021202678, 0.048798855, -0.057369143, -0.1613142, 0.023689339, -0.04995168, 0.02980912, -0.052541643, -0.037693493, 0.089918755), target1);
	target1 = MulAdd(ne2, MF4x4(0.13534155, -0.09769345, -0.072239734, 0.06396828, -0.067685336, 0.09630334, -0.060928572, 0.04446791, -0.08296695, 0.09350221, 0.34450835, -0.13325562, 0.017068733, 0.19159698, -0.0142695615, -0.0692556), target1);
	target1 = MulAdd(nf2, MF4x4(0.006079359, 0.12826636, -0.12040495, 0.08986504, 0.07011883, -0.1098471, 0.14756078, -0.29749495, -0.13352399, -0.19821455, 0.088539004, 0.03831198, -0.2940772, 0.19943683, -0.083427206, 0.22637546), target1);
	target1 = MulAdd(ng2, MF4x4(-0.35546607, 0.064483844, -0.19232833, -0.06884708, -0.2744395, 0.015903095, -0.18404284, 0.18437761, -0.072399296, -0.11778013, -0.109648645, 0.038300544, -0.016273083, -0.022765087, -0.18801431, 0.023174742), target1);
	target1 = MulAdd(nh2, MF4x4(-0.047155075, -0.013470263, -0.2142679, -0.07784448, -0.17944333, -0.04802458, -0.059323605, 0.06443357, -0.023670893, -0.32168958, -0.047240417, -0.04732927, 0.22192943, -0.12674028, 0.038099587, 0.047584143), target1);
	target1 = MulAdd(ni2, MF4x4(-0.036675204, -0.2955229, -0.2730817, -0.021219578, -0.22891581, 0.1896148, 0.1885584, 0.020979041, -0.115823194, -0.07042675, -0.042149916, 0.04921666, -0.0054005245, -0.12240402, -0.0031619132, 0.09292424), target1);
	target1 = MulAdd(na3, MF4x4(-0.121177875, 0.022185382, -0.13757537, 0.110018514, 0.04366351, 0.07803729, -0.028073097, -0.070835054, -0.117744304, 0.010936038, 0.0039909417, 0.15176865, 0.14082533, -0.028780727, -0.09623105, -0.17158796), target1);
	target1 = MulAdd(nb3, MF4x4(0.04708067, 0.09987003, -0.0011556224, -0.14066035, 0.18528107, 0.2334141, 0.031397898, 0.05785171, 0.056908704, 0.07767457, 0.10462482, 0.04132479, 0.0121364035, 0.009938317, -0.08584528, -0.067361355), target1);
	target1 = MulAdd(nc3, MF4x4(-0.05410052, -0.0714775, -0.16306542, 0.090159744, -0.161323, -0.047408808, -0.06715019, 0.09986001, 0.2831126, 0.00576967, 0.040771786, -0.08548527, -0.09100255, 0.13035326, 0.012434338, -0.014341014), target1);
	target1 = MulAdd(nd3, MF4x4(-0.1663156, 0.10254592, -0.050546184, 0.11586232, -0.16458654, -0.03840253, 0.20078611, -0.07851566, 0.15138014, -0.112647966, -0.01826464, 0.12073245, -0.08315027, -0.050763886, -0.15038362, -0.1131053), target1);
	target1 = MulAdd(ne3, MF4x4(0.01002309, 0.08847059, -0.20151149, -0.0035132666, -0.23968504, -0.03516418, 0.29592118, 0.064261466, 0.45611492, -0.10594028, 0.110738106, -0.096258715, -0.05207964, -0.05561078, -0.11650712, -0.3685437), target1);
	target1 = MulAdd(nf3, MF4x4(0.20816466, -0.05811231, -0.061693646, 0.07572569, 0.14781217, -0.0070261173, -0.025654003, 0.054483656, 0.057109646, 0.19076158, 0.04684541, 0.1116435, -0.09888648, -0.031974472, 0.19365066, 0.021925794), target1);
	target1 = MulAdd(ng3, MF4x4(0.03929964, 0.07849196, -0.09844016, 0.07695297, 0.14535576, -0.2121029, -0.08024618, -0.012246682, 0.34951916, -0.09691296, 0.03363421, 0.058434267, 0.003874065, 0.14535636, -0.028760154, 0.124139), target1);
	target1 = MulAdd(nh3, MF4x4(-0.0932687, 0.092196085, -0.31407887, 0.1343263, -0.27295715, 0.14278416, 0.08114481, -0.12019184, 0.11957917, -0.113183275, 0.039373737, 0.46590427, 0.13638581, -0.043146584, 0.072187565, 0.25355667), target1);
	target1 = MulAdd(ni3, MF4x4(0.123297654, 0.13584657, 0.07648451, -0.13606457, -0.16890481, 0.01590599, -0.21695235, -0.0694265, -0.2649162, 0.02908455, 0.21927917, 0.010575717, 0.0485126, 0.039509103, 0.28077808, 0.081715904), target1);
	
	MF4 target2 = { 0.0076388572, -0.16117841, -0.21034169, -0.019341651 };
	target2 = MulAdd(a1, MF4x4(-0.017371856, 0.031500984, -0.07871794, 0.07516421, -0.047120046, -0.1499491, 0.03412159, -0.11797919, 0.24790019, -0.19525756, -0.05562878, 0.0328997, 0.21224782, -0.15311961, -0.18679233, -0.021687083), target2);
	target2 = MulAdd(b1, MF4x4(-0.025990961, 0.12443172, 0.0647746, -0.05208365, 0.05024424, -0.15237884, -0.12913004, -0.03974524, 0.1453159, 0.105298564, -0.17882426, 0.15200019, -0.024576407, 0.024749285, -0.114573665, 0.12468399), target2);
	target2 = MulAdd(c1, MF4x4(0.07534002, -0.018443566, -0.07744656, -0.049855288, 0.030816372, -0.011974315, 0.05701086, 0.083947234, -0.16585147, -0.09379088, -0.090112925, -0.110042654, -0.105956376, 0.014653304, 0.041867986, 0.24255139), target2);
	target2 = MulAdd(d1, MF4x4(0.0044792104, -0.029270872, 0.07648775, 0.049905814, 0.014173815, -0.16794622, -0.09707847, 0.12383384, 0.06794641, -0.07997065, -0.51078653, 0.034911633, 0.13010858, -0.23383191, 0.07255915, -0.06692129), target2);
	target2 = MulAdd(e1, MF4x4(0.21879609, -0.017210754, -0.015485283, 0.083878465, -0.26080847, 0.36907044, 0.23289536, -0.038870774, 0.06501928, 0.14246589, -0.08897723, 0.10715434, 0.3482729, 0.16240129, -0.013726439, -0.005958744), target2);
	target2 = MulAdd(f1, MF4x4(-0.11399226, 0.18352379, 0.14817153, -0.20127603, 0.014963564, 0.1103272, -0.07205868, 0.08848388, 0.14840026, 0.018574262, -0.07972405, 0.02918892, 0.18851598, 0.074035265, -0.010895981, -0.034228772), target2);
	target2 = MulAdd(g1, MF4x4(-0.12840563, 0.13339421, -0.042844173, 0.17029236, 0.27274412, -0.05954642, -0.07974038, -0.14359044, -0.12972996, -0.14160097, -0.22879072, 0.17341535, -0.047784876, -0.0024098, -0.066806085, 0.1451525), target2);
	target2 = MulAdd(h1, MF4x4(0.019089594, 0.14139606, -0.16583538, 0.038803227, -0.014393993, -0.06451304, -0.0133141065, -0.22717497, -0.07594741, 0.16408369, -0.0074125547, 0.06459095, -0.13577539, -0.123973124, -0.21311697, 0.06648542), target2);
	target2 = MulAdd(i1, MF4x4(0.2023118, 0.014515263, -0.032675546, 0.01735652, 0.16447331, -0.016542327, -0.17865558, 0.07834224, 0.016872171, -0.12725283, -0.021913532, -0.03262319, -0.11567316, -0.009686028, 0.01897474, -0.00264971), target2);
	target2 = MulAdd(a2, MF4x4(0.02156143, 0.06127393, 0.08751492, -0.0027723024, 0.061267495, 0.22953646, 0.26134068, 0.23994948, -0.05292228, 0.11692952, 0.1014853, -0.013061857, -0.13198215, -0.08740625, 0.08896114, 0.11902029), target2);
	target2 = MulAdd(b2, MF4x4(0.017173437, -0.00088511547, 0.07882701, 0.059980858, -0.06255887, -0.07106743, -0.070686355, -0.111458905, -0.102210574, 0.082739465, 0.25598842, 0.010992033, -0.06413811, -0.03738569, 0.009392029, -0.047789197), target2);
	target2 = MulAdd(c2, MF4x4(-0.23666115, 0.07702853, 0.15348057, 0.081954665, -0.028320765, -0.15108013, -0.06386237, -0.03937426, -0.070428774, 0.046394363, 0.097939745, -0.08086774, 0.06996333, -0.048788365, 0.07915947, 0.05624496), target2);
	target2 = MulAdd(d2, MF4x4(-0.14345141, 0.048822183, -0.2908337, 0.013937969, -0.019703582, -0.41485405, 0.431834, 0.05884408, -0.3067431, 0.10988645, -0.014010137, 0.06143512, 0.24215294, -0.17129561, 0.11282655, 0.19824891), target2);
	target2 = MulAdd(e2, MF4x4(-0.07530577, -0.015041713, -0.11711949, 0.060197067, 0.15375182, 0.5235449, -0.15465264, 0.055295702, -0.12753716, 0.04075088, 0.06649801, -0.08592669, -0.034694944, 0.18401965, -0.031681508, 0.086950384), target2);
	target2 = MulAdd(f2, MF4x4(0.23155743, -0.012697523, -0.19502366, -0.09216853, -0.050312944, -0.003234684, -0.07824935, 0.09000848, -0.1604727, 0.16866255, -0.07226818, -0.04688219, 0.18855634, 0.07053166, 0.06875359, -0.082133405), target2);
	target2 = MulAdd(g2, MF4x4(0.097153, 0.17410621, -0.07209523, 0.031690594, -0.18697138, -0.31457213, 0.12693302, 0.09791562, -0.056750435, 0.17457159, -0.014368028, 0.11140081, 0.14797364, -0.11987443, 0.010138102, -0.24108526), target2);
	target2 = MulAdd(h2, MF4x4(0.08502398, 0.25199497, 0.033161916, 0.11686169, -0.000555042, -0.13222077, 0.019214375, -0.0740864, 0.05422655, -0.0689195, 0.07171115, -0.0063085253, -0.11293817, 0.28714395, 0.08302453, -0.297302), target2);
	target2 = MulAdd(i2, MF4x4(0.0018131305, -0.23274079, 0.28795394, 0.10479223, 0.017336998, 0.10140653, -0.01703538, 0.0018864989, -0.19448972, 0.06781925, 0.0072297496, 0.054331925, -0.056745283, 0.0031926096, 0.08508613, -0.076465875), target2);
	target2 = MulAdd(a3, MF4x4(-0.06579661, -0.074197, -0.07872732, -0.04833768, 0.07948355, 0.10680971, -0.038892176, 0.0026479303, -0.05120215, -0.005223787, 0.013828104, 0.033628467, -0.251052, -0.053964466, -0.04151976, -0.12170088), target2);
	target2 = MulAdd(b3, MF4x4(0.02224381, -0.11401214, 0.049397755, 0.1178245, 0.124475546, -0.014129338, -0.08712223, -0.110995345, 0.027189068, 0.14115846, 0.008039289, -0.077303566, 0.13120183, 0.088576116, 0.19419082, -0.19265574), target2);
	target2 = MulAdd(c3, MF4x4(-0.302041, -0.09488605, 0.10128198, 0.25093108, -0.05749319, -0.1325287, -0.07048078, 0.25168943, 0.24393974, 0.26709494, -0.005166187, -0.0858236, 0.098031975, -0.046012603, -0.025616428, -0.038455524), target2);
	target2 = MulAdd(d3, MF4x4(0.15295, -0.058367014, -0.09462144, -0.004685292, 0.061874785, 0.17379992, 0.10421289, -0.102156416, 0.07116128, 0.09785571, -0.08606482, 0.1615783, -0.10226774, -0.15573122, -0.17567602, 0.12711914), target2);
	target2 = MulAdd(e3, MF4x4(-0.08792466, 0.32314366, -0.040461652, -0.1960407, -0.11285709, -0.14666572, -0.070970505, 0.04230559, -0.05408487, -0.2794681, -0.4155402, 0.26639655, 0.13980015, 0.12434661, -0.02678858, 0.056679014), target2);
	target2 = MulAdd(f3, MF4x4(-0.124382794, 0.018727468, 0.20523487, -0.070906, -0.030757494, -0.10337054, 0.067943715, -0.039035156, 0.035588995, 0.14607283, -0.085760534, 0.19209209, 0.13216998, 0.16539834, 0.010052314, -0.022481022), target2);
	target2 = MulAdd(g3, MF4x4(0.021054843, -0.15636541, 0.011583453, -0.10839945, -0.05794076, -0.053845506, 0.0063711316, 0.09400282, 0.11037196, -0.11023954, 0.07765479, 0.0063296715, -0.100950494, 0.20135373, 0.048100784, 0.1047337), target2);
	target2 = MulAdd(h3, MF4x4(0.019294975, 0.10017591, -0.022420274, -0.024994979, 0.033118278, -0.0335541, -0.099411234, -0.051065058, 0.04019899, -0.09789642, -0.21099539, -0.051657237, 0.0537393, 0.22397718, -0.09253929, 0.0056816903), target2);
	target2 = MulAdd(i3, MF4x4(0.13451837, -0.31405422, -0.02294345, -0.09470789, 0.011980906, -0.29736918, 0.04785323, 0.008854729, 0.0064198305, 0.1608248, -0.0063040988, 0.015922181, 0.058713753, 0.19405961, -0.0074991966, -0.056430623), target2);
	target2 = MulAdd(na1, MF4x4(-0.030276824, 0.051418643, -0.033852484, -0.04178643, -0.09626818, 0.06430078, 0.18420494, 0.21067473, -0.20206925, 0.039089408, -0.20179388, 0.04502135, -0.079114124, -0.18990965, 0.03482791, -0.20353125), target2);
	target2 = MulAdd(nb1, MF4x4(0.12883389, 0.01503085, 0.07740192, -0.021361377, -0.021194257, -0.2965198, 0.038358267, 0.08110664, -0.122530565, 0.002974726, -0.11742695, -0.05976367, 0.011006546, -0.0676137, 0.109357566, -0.09688377), target2);
	target2 = MulAdd(nc1, MF4x4(-0.22074296, 0.019343395, 0.17098527, 0.21736804, -0.15512446, 0.1447234, -0.1344856, 0.051509894, -0.021283794, -0.017791564, -0.023386735, 0.15375026, 0.05583616, -0.22131743, 0.010143341, -0.113710396), target2);
	target2 = MulAdd(nd1, MF4x4(0.12376125, 0.086540736, -0.07823014, -0.11477249, 0.071970075, 0.04002691, 0.09260781, -0.16808367, -0.07891094, -0.28984514, -0.0030400122, 0.20933042, -0.09442383, 0.27100945, 0.03393376, -0.025617108), target2);
	target2 = MulAdd(ne1, MF4x4(-0.041222293, 0.012311568, 0.13222927, 0.15650855, 0.024765523, -0.055989124, -0.02946687, -0.0066036643, -0.12604281, -0.16414027, -0.22830643, 0.0840456, -0.19442934, -0.00939128, -0.005971656, 0.027085181), target2);
	target2 = MulAdd(nf1, MF4x4(-0.23906162, -0.04003579, 0.16445775, 0.2578306, -0.08858488, -0.0009076812, 0.05893361, -0.07622802, 0.07551978, 0.16221073, -0.08075802, -0.066482686, -0.082238205, -0.07318114, -0.02384466, -0.008769857), target2);
	target2 = MulAdd(ng1, MF4x4(0.034418013, -0.04310424, 0.06940784, -0.040061995, -0.196672, 0.059436113, 0.18781166, -0.087357335, 0.17683987, -0.11832282, 0.0704508, -0.080166645, -0.10043135, 0.029797623, 0.045275707, -0.00091474655), target2);
	target2 = MulAdd(nh1, MF4x4(-0.13774432, 0.039946273, 0.010250749, -0.064292066, -0.033921324, 0.086792484, -0.06556751, 0.16063036, 0.040354285, -0.005781792, -0.06043568, 0.0456958, 0.057671502, -0.09200769, 0.05852994, -0.038263924), target2);
	target2 = MulAdd(ni1, MF4x4(0.0722641, -0.15417133, 0.0428391, -0.11669595, -0.15181269, -0.14444157, -0.05888602, -0.04931457, -0.024105387, 0.04452374, -0.19607021, 0.040299945, 0.023721624, 0.009294535, -0.12308105, -0.032013766), target2);
	target2 = MulAdd(na2, MF4x4(0.13982506, 0.008242153, 0.007985137, -0.028785944, -0.045674372, 0.03811196, -0.006431167, 0.042959616, -0.14530565, -0.13717386, 0.15736887, -0.070945315, 0.16792078, -0.057526443, 0.11027599, -0.062423922), target2);
	target2 = MulAdd(nb2, MF4x4(0.33995095, -0.06725867, 0.25568435, -0.1156066, 0.0073083406, 0.09118932, -0.036027674, 0.14834408, 0.0076618423, 0.048706416, -0.11109869, 0.014119505, -0.16117008, 0.055889986, 0.021106627, 0.0494479), target2);
	target2 = MulAdd(nc2, MF4x4(0.058088336, -0.05898053, 0.28952774, 0.06457457, 0.06820624, 0.031307437, 0.040132232, -0.12814572, 0.034467205, 0.16643257, 0.13826352, -0.050465748, -0.082429856, 0.028516805, 0.10005895, -0.17591912), target2);
	target2 = MulAdd(nd2, MF4x4(0.17962062, 0.050080433, 0.115288205, 0.07467281, 0.07438551, 0.111036986, -0.09742873, -0.23408481, -0.09974166, -0.12665741, -0.04540029, -0.03346997, 0.089152135, 0.082195945, 0.28275734, -0.24630727), target2);
	target2 = MulAdd(ne2, MF4x4(0.11799736, -0.06625111, 0.091244, -0.13702978, 0.055218194, -0.031087862, 0.06133677, -0.27246916, -0.15978532, 0.19715077, 0.051257942, 0.036602553, 0.054990616, -0.25717, 0.12677813, -0.0406006), target2);
	target2 = MulAdd(nf2, MF4x4(-0.043816347, -0.3335301, 0.19126506, -0.01086813, 0.075816035, 0.15178275, -0.07246076, -0.19391762, 0.07836278, 0.12452172, 0.09029487, -0.034167152, -0.061805293, -0.08850912, 0.08531079, 0.14093879), target2);
	target2 = MulAdd(ng2, MF4x4(0.120683454, 0.02466898, 0.19501889, -0.047962803, 0.2524244, -0.04647245, 0.23329985, -0.437865, -0.11040008, 0.05536788, 0.094667554, -0.029751923, -0.04589413, -0.24310234, 0.27122453, 0.010039841), target2);
	target2 = MulAdd(nh2, MF4x4(-0.17811799, -0.05787477, 0.10678799, -0.28424516, -0.11051176, -0.0372708, 0.20203365, 0.10050222, -0.1243157, 0.20707713, 0.14385784, 0.025799723, 0.028424745, -0.06201256, -0.1112155, 0.17677756), target2);
	target2 = MulAdd(ni2, MF4x4(-0.06334935, 0.14396226, -0.121362604, -0.30631876, -0.17723008, -0.041447658, 0.03672539, 0.1550316, 0.113435954, 0.13270019, 0.04389676, 0.016865736, 0.0027031328, 0.107943274, -0.08071779, -0.007290789), target2);
	target2 = MulAdd(na3, MF4x4(-0.0327075, -0.02185086, -0.00093145896, -0.009849336, -0.06994606, -0.009004001, -0.2962301, -0.093587525, 0.055827085, 0.15590863, -0.1348263, -0.030768193, 0.1539244, 0.056906786, -0.046778735, 0.1293399), target2);
	target2 = MulAdd(nb3, MF4x4(0.060477, 0.10025322, 0.034794286, -0.15556674, -0.046868246, -0.06774045, -0.0046042744, -0.028093262, -0.14673153, 0.0014603435, -0.17085737, 0.09433877, 0.06585415, -0.17430365, -0.09225927, 0.18637276), target2);
	target2 = MulAdd(nc3, MF4x4(-0.0829445, -0.046446815, 0.01044717, -0.08179017, -0.106227055, -0.07285646, -0.118698135, -0.08691134, -0.19350386, 0.18079466, -0.0896787, -0.0054066014, 0.044900116, -0.07164249, 0.03728663, -0.071337156), target2);
	target2 = MulAdd(nd3, MF4x4(-0.091456026, 0.0829187, 0.2184223, 0.12404674, 0.0535281, -0.0046089985, -0.1367499, 0.14318149, -0.13627648, 0.008214974, -0.035714064, -0.11221228, -0.0848333, 0.054274652, 0.12799235, -0.12235648), target2);
	target2 = MulAdd(ne3, MF4x4(0.015441998, -0.16407311, 0.29637286, 0.15780787, 0.100573234, -0.023377284, 0.19050701, 0.14114772, 0.1021301, 0.30314055, 0.08799963, 0.11630563, -0.28035656, 0.10020031, -0.009994972, -0.16998753), target2);
	target2 = MulAdd(nf3, MF4x4(-0.053246386, 0.15038243, -0.020114498, 0.019207323, -0.4546607, 0.048940018, 0.122429796, 0.14951369, 0.09936216, -0.13126904, -0.15678225, 0.101906285, 0.017061174, -0.17944153, -0.12741113, -0.13633935), target2);
	target2 = MulAdd(ng3, MF4x4(0.11258541, -0.056183632, -0.10542277, 0.048327565, -0.10695888, 0.021128727, -0.0025440033, -0.14460813, -0.2421658, 0.04799532, -0.025316745, 0.111919515, 0.133215, -0.23335934, -0.037506737, -0.12447751), target2);
	target2 = MulAdd(nh3, MF4x4(0.035608087, -0.17302564, 0.07696709, -0.18077038, -0.02534479, 0.035865046, 0.15503906, -0.07042084, 0.37430316, 0.2688597, 0.23763078, 0.26458314, 0.22778325, 0.13661247, 0.032626268, 0.10627844), target2);
	target2 = MulAdd(ni3, MF4x4(-0.14816584, 0.08924656, -0.02333901, 0.0735485, -0.17011848, -0.059921533, 0.045324218, 0.026974149, 0.15702479, 0.0067652813, 0.08584165, 0.09428486, 0.035495974, -0.07220769, -0.0524813, -0.008241412), target2);
	
	MF4 target3 = { 0.11033049, -0.073737, -0.013228117, 0.01553484 };
	target3 = MulAdd(a1, MF4x4(0.051828694, -0.14444938, -0.06172656, -0.092529796, 0.0032331774, 0.0505327, -0.092972204, 0.054304235, 0.04113735, 0.05488947, 0.27173808, 0.008734756, -0.037090253, 0.11106639, 0.1864697, -0.1308939), target3);
	target3 = MulAdd(b1, MF4x4(-0.0292121, 0.09739149, -0.057740077, -0.043211482, 0.00057832256, 0.122456014, 0.14004166, -0.22281875, -0.00958859, 0.012818551, 0.21724443, 0.038053658, 0.11917748, -0.0147661995, 0.15326285, -0.007842389), target3);
	target3 = MulAdd(c1, MF4x4(0.028475946, -0.044710767, 0.120977476, 0.024894554, 0.034071486, 0.002889187, 0.0886379, -0.13210039, 0.0254021, -0.10800576, -0.0154256895, 0.07889771, -0.026208088, -0.1735971, 0.12414827, 0.06541947), target3);
	target3 = MulAdd(d1, MF4x4(0.15367964, -0.016319191, -0.087988645, 0.21592557, -0.13575394, 0.07606312, 0.17890929, 0.06405638, -0.15215087, -0.31830072, -0.070441514, -9.058544e-06, 0.15286519, -0.07961882, 0.0051650982, 0.05743661), target3);
	target3 = MulAdd(e1, MF4x4(0.14879431, 0.09249706, -0.08179524, 0.08862426, -0.04546735, 0.052125804, 0.10511877, -0.036810514, 0.19695859, 0.06919595, -0.041425765, 0.05109113, 0.16108315, -0.0006357406, -0.036482725, -0.000831584), target3);
	target3 = MulAdd(f1, MF4x4(-0.14299406, 0.24442554, 0.08385988, -0.0018431129, 0.025425488, 0.043124236, -0.19599897, 0.2500142, 0.084921256, -0.064991206, -0.04332563, -0.20997004, -0.06825186, 0.11137002, -0.08090301, -0.06958994), target3);
	target3 = MulAdd(g1, MF4x4(-0.17347668, -0.09592853, -0.051422764, -0.15347266, 0.19709691, 0.012748645, 0.11250177, 0.020625748, -0.12617995, -0.09576706, 0.121928014, -0.052528545, 0.06992809, -0.060379576, -0.13869223, -0.05584254), target3);
	target3 = MulAdd(h1, MF4x4(0.040104184, -0.12147194, -0.04430197, 0.13594869, 0.09909328, 0.12928483, -0.2334865, 0.11032421, 0.064912125, -0.010493585, 0.06800239, 0.18326257, 0.019329162, -0.09916547, -0.11674449, 0.03267864), target3);
	target3 = MulAdd(i1, MF4x4(-0.07757802, -0.018029094, 0.029337326, 0.29172876, -0.03394624, 0.02624461, -0.2849472, -0.27765557, -0.04780892, -0.019495687, -0.11718942, -0.03025127, -0.008503852, -0.076533996, -0.02296907, 0.068641014), target3);
	target3 = MulAdd(a2, MF4x4(0.13043757, -0.06434652, -0.0690028, -0.033568893, 0.17211302, -0.029193658, 0.12456035, -0.11193319, -0.0035818655, -0.2563802, -0.12287091, 0.10766433, -0.04711406, -0.08852275, 0.0153720435, -0.14872602), target3);
	target3 = MulAdd(b2, MF4x4(-0.080712505, 0.11759175, -0.11220247, 0.10730683, 0.06418219, 0.00800814, -0.028890526, 0.1441286, 0.03056378, -0.0035148377, -0.120093554, 0.043768104, 0.07286328, -0.021130785, 0.09223498, 0.20331676), target3);
	target3 = MulAdd(c2, MF4x4(-0.09102653, -0.10116414, 0.15046883, 0.28877532, -0.011975523, -0.0068613496, -0.09103339, 0.11455707, 0.007323278, 0.08825653, -0.054251585, -0.14907618, -0.00018906803, -0.08488728, 0.036797076, -0.12455349), target3);
	target3 = MulAdd(d2, MF4x4(0.04010406, 0.024046177, -0.20183066, -0.06970149, -0.10715107, -0.077962436, 0.32845956, -0.2622872, -0.15997723, -0.07157501, -0.09492247, -0.00996072, -0.067652985, -0.16896474, 0.06192714, 0.019690538), target3);
	target3 = MulAdd(e2, MF4x4(-0.10179747, -0.10023532, -0.10475995, -0.15501128, 0.017811656, 0.027858434, -0.11646674, 0.08104398, -0.12454491, 0.032985296, -0.09229711, 0.0909355, 0.0021391874, -0.051617827, -0.11611242, 0.036069512), target3);
	target3 = MulAdd(f2, MF4x4(-0.14753185, -0.020901026, -0.0029391565, -0.14624536, -0.09374949, -0.049715783, 0.1951781, 0.22286539, -0.013287656, 0.0830378, -0.2975549, -0.13074464, -0.010272348, 0.032849077, -0.097859964, -0.1562913), target3);
	target3 = MulAdd(g2, MF4x4(0.14641422, 0.13483211, -0.0438145, 0.08620407, 0.11926978, -0.15772878, 0.17547028, 0.15418763, 0.0097786365, 0.016791794, 0.057482373, -0.0716323, -0.061063405, 0.13135311, 0.1040161, 0.1688627), target3);
	target3 = MulAdd(h2, MF4x4(0.11255645, 0.08840791, 0.07584055, -0.09523696, -0.1154477, -0.085963145, -0.075319275, -0.05898237, -0.14236066, 0.058508113, 0.078278095, 0.07180024, 0.19020182, 0.027219167, -0.11044013, -0.1411698), target3);
	target3 = MulAdd(i2, MF4x4(0.1250712, -0.09155498, 0.11040472, -0.28928515, 0.06875818, -0.07716765, 0.07982134, 0.22709553, 0.08608979, 0.02659528, -0.050615177, -0.054662008, -0.016789312, 0.095084675, -0.20973809, -0.14231291), target3);
	target3 = MulAdd(a3, MF4x4(0.009871057, 0.07234809, -0.061542578, -0.2561031, 0.17938578, 0.059759673, -0.0533506, -0.15160522, -0.06667153, 0.022478178, -0.078531526, 0.01727445, 0.032124806, -0.09959757, -0.08871009, -0.0010295251), target3);
	target3 = MulAdd(b3, MF4x4(-0.07400921, 0.009798935, 0.06958411, -0.14588043, 0.045884695, 0.029824348, -0.08622057, -0.03112675, -0.050385453, 0.12655865, -0.06863022, -0.21982339, -0.06292096, -0.014440884, 0.06755428, -0.114989646), target3);
	target3 = MulAdd(c3, MF4x4(0.054011043, -0.26510096, 0.21961565, 0.05448362, 0.06296498, -0.07182228, -0.09567859, -0.024238275, 0.005022228, 0.1626434, 0.00019249211, 0.073934935, 0.02381926, 0.025067188, -0.10400833, -0.10235642), target3);
	target3 = MulAdd(d3, MF4x4(0.019573225, 0.016258147, 0.014888165, -0.09950712, 0.052801423, 0.18720426, 0.13194256, -0.030186977, -0.052970573, -0.20545387, 0.0477203, 0.12807603, 0.106122404, 0.013091209, 0.037285265, -0.17009702), target3);
	target3 = MulAdd(e3, MF4x4(-0.052872628, 0.0067698397, -0.04057391, -0.10654882, -0.08066677, -0.11518657, 0.063243456, 0.108404346, 0.006817193, -0.08499581, -0.16265164, -0.019080937, 0.27572608, -0.02719708, -0.10466762, 0.006535063), target3);
	target3 = MulAdd(f3, MF4x4(-0.004304222, -0.23885699, 0.0007060991, -0.011653924, -0.058662247, -0.10310051, 0.19861554, -0.124969624, 0.08919569, 0.062485468, -0.07952577, 0.06357056, 0.13038754, -0.10383543, -0.12508194, 0.07526947), target3);
	target3 = MulAdd(g3, MF4x4(0.034628194, -0.1459473, -0.12843482, -0.16211623, 0.18986839, -0.021202087, 0.030887406, 0.16012087, -0.07651755, 0.25390217, 0.100328274, -0.18489215, -0.11211924, -0.18655026, -0.12336867, 0.03715863), target3);
	target3 = MulAdd(h3, MF4x4(0.24926607, -0.12733914, -0.16163528, -0.18980862, 0.026140725, 0.030769283, -0.08602958, -0.011363779, -0.18870075, -0.08782851, -0.019595576, 0.15859611, 0.14101227, -0.23768859, -0.11449071, -0.21400326), target3);
	target3 = MulAdd(i3, MF4x4(-0.014345643, 0.03152331, 0.14303848, 0.068378784, -0.023709042, 0.009476213, 0.03332845, -0.043729182, -0.16312705, 0.18575506, 0.045167383, 0.089232035, 0.12431053, -0.019391764, -0.09807002, -0.19098805), target3);
	target3 = MulAdd(na1, MF4x4(-0.0027074527, 0.08881943, 0.021618785, 0.17202215, -0.023361688, -0.12384613, 0.1257001, 0.034937408, 0.050526705, -0.21945108, -0.23475797, 0.1385765, 0.03910722, 0.08761758, -0.06185295, 0.16879226), target3);
	target3 = MulAdd(nb1, MF4x4(0.01759655, 0.07489585, 0.06413278, -0.16355684, 0.021823732, -0.19263723, -0.021956496, 0.07322703, 0.106124505, 0.17441194, 0.016513938, -0.09815339, -0.12467256, -0.036076445, -0.09139147, -0.09947436), target3);
	target3 = MulAdd(nc1, MF4x4(-0.027052518, -0.059014272, 0.14797378, 0.21370119, 0.033306625, 0.070152596, 0.0052737673, 0.28024423, 0.040666968, -0.069734804, 0.07771406, 0.1577554, 0.03728327, -0.01140819, 0.056443825, -0.08787925), target3);
	target3 = MulAdd(nd1, MF4x4(-0.24540152, 0.0015005039, 0.020643666, -0.3483438, -0.11493903, -0.13617486, -0.0063642715, -0.10733139, 0.12702248, 0.20147271, 0.031689152, 0.07603208, 0.15610643, 0.16600998, -0.041932072, -0.087021336), target3);
	target3 = MulAdd(ne1, MF4x4(0.15945607, -0.019792518, 0.16893104, 0.047684517, -0.08704263, 0.019054385, -0.13532451, 0.07722914, 0.06000842, -0.053279165, -0.041631456, 0.021691417, -0.05814861, 0.0014272713, -0.2269319, 0.0764104), target3);
	target3 = MulAdd(nf1, MF4x4(-0.084321365, -0.2361291, -0.1518955, -0.15901338, -0.06990816, -0.024734944, 0.06835628, -0.21718912, -0.12289749, -0.025446652, -0.15737066, -0.010520588, 0.12629907, -0.06181239, -0.0011575993, -0.004076976), target3);
	target3 = MulAdd(ng1, MF4x4(0.012631871, 0.023027385, 0.0036474608, 0.02950606, -0.13008296, 0.098362945, 0.04146146, 0.17968152, -0.15123938, 0.09731617, -0.014078934, 0.05166318, -0.009141391, 0.08204638, 0.07045137, -0.030674614), target3);
	target3 = MulAdd(nh1, MF4x4(0.109709226, -0.02842136, -0.07762395, -0.010807984, -0.17060421, 0.0826962, 0.03507386, -0.12764347, 0.12828389, -0.051255893, -0.124972954, -0.16426642, -0.15884088, 0.07268723, -0.0030184009, -0.009351197), target3);
	target3 = MulAdd(ni1, MF4x4(-0.05924065, 0.109954804, -0.015081119, -0.30813795, 0.049611736, -0.09356052, 0.14393319, 0.2197319, 0.04127852, -0.083522744, -0.20068535, -0.1432542, 0.061216276, 0.040896352, -0.0010942877, 0.1074572), target3);
	target3 = MulAdd(na2, MF4x4(-0.043747675, -0.09601221, -0.029208777, -0.3020336, -0.18261817, -0.076463126, 0.02404145, 0.021356242, -0.115703, 0.18811412, 0.01355199, -0.18233287, -0.164117, 0.10521931, 0.033724364, 0.045072973), target3);
	target3 = MulAdd(nb2, MF4x4(-0.14719059, -0.12931113, 0.15695307, -0.16798888, 0.062653124, -0.12612487, -0.12454781, -0.084084496, 0.023468291, 0.027891247, 0.0042489907, -0.1077923, -0.005104954, -0.121897295, 0.08160336, 0.23735033), target3);
	target3 = MulAdd(nc2, MF4x4(-0.06651707, -0.15773214, -0.016145034, -0.1297115, -0.05631942, 0.19243148, -0.08536315, -0.2202384, 0.024619251, 0.09842469, -0.060476214, 0.1606162, -0.06982684, 0.27481422, -0.0032873556, -0.055477414), target3);
	target3 = MulAdd(nd2, MF4x4(0.013625612, -0.11602345, 0.13228852, -0.01016997, -0.113034405, 0.12990026, 0.008144483, 0.28583318, 0.0018612862, 0.19464394, 0.06077795, -0.05083094, -0.1419072, 0.30847812, 0.16012973, -0.043837596), target3);
	target3 = MulAdd(ne2, MF4x4(0.25535858, 0.047635876, 0.20499952, 0.14458135, -0.2067339, 0.18970652, 0.18168713, 0.089201, -0.1371205, 0.09543299, -0.048719935, -0.21094483, 0.06297616, -0.14864779, 0.24678773, 0.023468606), target3);
	target3 = MulAdd(nf2, MF4x4(-0.024188349, 0.049452, 0.119040206, 0.19403425, 0.15611161, 0.20774378, -0.10905696, -0.16743217, -0.067075364, 0.02012775, 0.031936057, 0.16447093, -0.14523768, 0.12793602, 0.21358742, 0.1580285), target3);
	target3 = MulAdd(ng2, MF4x4(0.12834404, -0.23567453, 0.0594437, 0.1590165, 0.04364869, 0.092662945, 0.19947445, 0.13371125, -0.030953676, 0.072429836, 0.00064696936, 0.05223404, -0.18505633, -0.038344953, 0.1609896, -0.027951878), target3);
	target3 = MulAdd(nh2, MF4x4(0.1615281, 0.02925065, -0.110526, 0.002472878, 0.15692636, 0.17720695, 0.08651831, -0.2926173, 0.039506726, 0.08039181, -0.125379, -0.112809196, -0.018160323, -0.15315212, 0.05300267, -0.12539586), target3);
	target3 = MulAdd(ni2, MF4x4(0.045024972, -0.026277857, -0.13403505, -0.082753636, -0.014246987, 0.08158673, -0.17446561, -0.12912557, -0.03281638, 0.12861331, -0.048045747, 0.008813668, 0.13716908, -0.1772549, 0.12983966, 0.28312683), target3);
	target3 = MulAdd(na3, MF4x4(0.06964638, 0.0047901543, 0.09235384, 0.24047932, -0.0034995198, 0.1894994, 0.044509877, 0.08263613, 0.22042292, 0.0068810997, -0.08542091, 0.13489819, -0.017957956, -0.049517035, 0.11637685, -0.070710674), target3);
	target3 = MulAdd(nb3, MF4x4(0.005409427, 0.2764383, 0.100069076, 0.0025022945, 0.042582463, -0.07622942, 0.1427979, 0.12527353, 0.07857632, 0.110723145, -0.091726854, 0.18400952, 0.08911038, -0.11033729, 0.025358237, -0.011007877), target3);
	target3 = MulAdd(nc3, MF4x4(0.041533705, -0.038725346, 0.09127384, 0.10426011, -0.02070303, 0.0878809, 0.15809457, -0.009334662, -0.049823076, 0.11527338, -0.06646191, 0.03342348, 0.07330054, 0.011010275, 0.16572441, 0.059434716), target3);
	target3 = MulAdd(nd3, MF4x4(0.01884174, 0.024791235, 0.063296616, -0.042403292, -0.12980534, -0.019906277, -0.18554951, -0.09545456, 0.17291631, 0.22148399, -0.093014, -0.07421902, -0.15626103, -0.13463756, -0.08697246, 0.18189901), target3);
	target3 = MulAdd(ne3, MF4x4(-0.027780509, 0.061554506, 0.18972316, 0.017942533, -0.012191195, 0.047828108, 0.102957085, -0.15932114, -0.13597767, 0.2235027, 0.13829249, 0.11061467, -0.20257929, -0.062691554, 0.06993067, 0.018168231), target3);
	target3 = MulAdd(nf3, MF4x4(0.0038817637, 0.053267647, -0.1002687, -0.1239985, 0.04858564, 0.059892915, -0.10344583, 0.24931516, -0.02322075, -0.07354648, 0.20486975, 0.0147269, 0.09117062, 0.0001810227, 0.0011455072, -0.1166342), target3);
	target3 = MulAdd(ng3, MF4x4(0.026433034, -0.010127757, 0.1411767, 0.12108788, -0.16191758, -0.06574798, -0.027283505, 0.052705772, -0.09186127, -0.05113535, -0.008512441, 0.06438505, 0.07150241, 0.096780665, 0.14615399, 0.043888208), target3);
	target3 = MulAdd(nh3, MF4x4(-0.07171402, 0.053826947, 0.1817855, 0.15776771, 0.020122573, 0.014001945, 0.107657574, 0.06755519, -0.16229364, 0.025698826, 0.19443901, -0.18386869, -0.112747826, 0.19832937, 0.032073986, 0.07755969), target3);
	target3 = MulAdd(ni3, MF4x4(-0.0017903978, 0.017006857, -0.154056, -0.12544118, -0.17143774, 0.11694203, 0.046639796, -0.13699242, 0.1032892, -0.16337542, 0.20032221, 0.30423567, -0.09217524, 0.03736137, 0.06391171, 0.18111771), target3);

	MF3 target4 = tex7.SampleLevel(sam, pos, 0).rgb;
	target4 = MulAdd(e1, MF4x3(0.060458526, -0.0033674864, -0.006985535, -0.013925546, 0.051077038, 0.053856038, -0.033647064, 0.043235198, 0.05311577, 0.0391791, -0.044376004, -0.054064214), target4);
	target4 = MulAdd(e2, MF4x3(0.0069859014, -0.0050665336, -0.010343517, -0.027551029, 0.049856182, 0.058316905, 0.0121670095, -0.013107907, -0.0151846, 0.007648614, -0.0051277154, -0.0053846613), target4);
	target4 = MulAdd(e3, MF4x3(0.06848036, 0.026777437, 0.024801696, -0.08711668, 0.049429595, 0.067019165, -0.09006778, -0.042166695, -0.02230536, -0.048024856, -0.020088708, -0.009932858), target4);
	target4 = MulAdd(ne1, MF4x3(-0.05171447, 0.0029948682, 0.014913949, 0.02287364, -0.042476606, -0.052956346, 0.02762833, -0.044026252, -0.056759696, -0.0519502, 0.047626793, 0.06422155), target4);
	target4 = MulAdd(ne2, MF4x3(-0.0031128856, 0.013134638, 0.021534251, 0.049189907, -0.039677586, -0.057255603, -0.009908353, -0.0013683038, 0.0028079485, 0.0002268831, 0.012356764, 0.009817244), target4);
	target4 = MulAdd(ne3, MF4x3(-0.04058634, -0.01822148, -0.014306331, 0.107378654, -0.04138371, -0.058573496, 0.03701269, -0.009420217, -0.02310707, 0.039931968, 0.001769326, -0.007929419), target4);

	tex4[gxy] = target1;
	tex5[gxy] = target2;
	tex6[gxy] = target3;
	tex8[gxy] = MF4(target4, 1);
}

//!PASS 7
//!DESC Conv-4x3x3x24
//!IN tex4, tex5, tex6, tex8
//!OUT tex1, tex2, tex3, tex7
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass7(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = tex4.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = tex4.SampleLevel(sam, pos, 0);
	MF4 f1 = tex4.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = tex5.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = tex5.SampleLevel(sam, pos, 0);
	MF4 f2 = tex5.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    MF4 a3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = tex6.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = tex6.SampleLevel(sam, pos, 0);
	MF4 f3 = tex6.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target1 = { -0.12162919, -0.00032382424, 0.025486631, -0.09447538 };
	target1 = MulAdd(a1, MF4x4(-0.0041438183, 0.087629646, 0.02373779, -0.008705929, -0.06460613, -0.079614826, 0.20589171, -0.21300887, 0.06673036, -0.14301205, 0.0005478004, 0.10480311, 0.16944528, -0.023095177, -0.04593122, 0.031710908), target1);
	target1 = MulAdd(b1, MF4x4(0.24273445, 0.1350743, -0.050578117, -0.006424492, 0.024859063, 0.017022807, -0.054993033, -0.13135757, -0.11061301, 0.0006009131, -0.012896671, -0.029120278, -0.09564777, -0.15695906, -0.008574818, 0.0022726357), target1);
	target1 = MulAdd(c1, MF4x4(-0.11845177, 0.044411838, -0.02478517, -0.016679568, 0.2842885, 0.05566886, -0.020992488, 0.33000243, -0.045738284, -0.08624307, -0.0029711786, 0.06983461, 0.16860297, -0.08496602, 0.0026587378, 0.1191108), target1);
	target1 = MulAdd(d1, MF4x4(0.08942806, -0.13266312, 0.050555114, 0.044336855, 0.04668655, -0.17912517, 0.09872363, -0.05689603, -0.04764076, 0.09976931, 0.026714336, -0.12177113, 0.10121553, 0.19926491, -0.013922513, -0.062807985), target1);
	target1 = MulAdd(e1, MF4x4(-0.11948707, -0.19019963, -0.09910906, 0.015228854, 0.19573943, 0.18543078, 0.37633705, 0.0899833, -0.058247276, -0.06500262, -0.0968551, 0.3980007, -0.13930885, 0.031145731, 0.18868047, 0.20646492), target1);
	target1 = MulAdd(f1, MF4x4(-0.27454132, 0.037422657, 0.060829625, -0.15062498, 0.22120185, -0.020640798, -0.15796806, 0.30988604, 0.117011115, -0.11581356, -0.105670854, 0.34526885, 0.09709533, -0.1335589, -0.061150175, -0.023490202), target1);
	target1 = MulAdd(g1, MF4x4(-0.0064297495, 0.053259544, 0.061699186, -0.1023013, 0.13206881, 0.08598005, 0.042804673, -0.036392808, -0.022715596, 0.3187674, -0.043576453, 0.089301124, 0.010875903, -0.045669887, 0.13546628, -0.041321605), target1);
	target1 = MulAdd(h1, MF4x4(0.033168443, 0.07130571, -0.06795218, -0.094012216, 0.09050034, -0.16879193, 0.18427128, 0.19835915, 0.014528693, 0.22958101, -0.012955512, 0.14033306, 0.10309811, 0.03351618, -0.100021325, -0.026367364), target1);
	target1 = MulAdd(i1, MF4x4(-0.40170196, -0.10989097, 0.06447425, -0.19903958, 0.030508196, -0.09201532, -0.1493947, -0.0039443234, 0.16646437, -0.004893318, 0.030999044, 0.22652404, -0.1360666, -0.14109057, -0.124136284, -0.07020125), target1);
	target1 = MulAdd(a2, MF4x4(-0.35415915, 0.078341804, -0.20908163, -0.032414813, -0.17489177, -0.10121671, -0.0123754265, -0.0074867755, 0.20203647, 0.2981116, 0.4581744, -0.10773967, -0.14040758, -0.1311706, 0.2421585, -0.05221277), target1);
	target1 = MulAdd(b2, MF4x4(0.32388586, 0.121117495, 0.17030708, -0.09672408, 0.10174964, -0.089880064, -0.053550195, 0.07492085, 0.36688468, 0.39096692, 0.27509093, -0.09113504, 0.18473786, -0.030729344, -0.022813018, -0.07951988), target1);
	target1 = MulAdd(c2, MF4x4(-0.10802985, -0.09921729, -0.083578154, 0.09941307, 0.15204535, 0.0048476397, 0.037141923, 0.072919704, -0.039613035, 0.0011554313, 0.029029889, -0.115339264, -0.2606713, 0.017305905, -0.032651994, -0.1710926), target1);
	target1 = MulAdd(d2, MF4x4(-0.09530024, 0.08035671, -0.094462946, 0.04531403, 0.116854094, -0.039871104, 0.101754196, 0.07071469, -0.09344735, 0.2224399, 0.31438616, -0.1031509, -0.087050706, 0.023629284, 0.30222768, 0.087091036), target1);
	target1 = MulAdd(e2, MF4x4(0.32540318, -0.123871066, 0.09114808, 0.20059493, 0.13602751, -0.294147, 0.028020037, 0.10215196, 0.14379483, -0.08321783, -0.06476323, 0.039079703, 0.11145182, 0.047562934, -0.0320396, 0.17505427), target1);
	target1 = MulAdd(f2, MF4x4(0.117524795, 0.063353635, -0.08187684, -0.02796676, 0.11098208, -0.02517451, 0.052513797, -0.18859608, -0.25639486, 0.17382553, 0.053182043, -0.09802817, -0.08900308, 0.021651518, -0.07654097, -0.111615546), target1);
	target1 = MulAdd(g2, MF4x4(-0.12933804, 0.0012732261, -0.045028616, 0.06224205, -0.00047467486, -0.26893324, 0.14208493, 0.027069936, 0.16365767, 0.30192706, 0.23923144, -0.105405785, -0.0021433597, 0.14549361, 0.05767389, -0.10113342), target1);
	target1 = MulAdd(h2, MF4x4(-0.07045147, 0.13409013, 0.023928098, 0.045560613, 0.103115976, -0.066133045, 0.12823656, -0.01629772, 0.13711633, 0.27451962, 0.12717873, -0.084038205, 0.12807854, 0.110353716, -0.06848678, 0.056276537), target1);
	target1 = MulAdd(i2, MF4x4(0.16927746, 0.111806795, 0.023252549, -0.12235242, 0.15292254, 0.061406262, 0.06284062, -0.11671832, -0.02885994, 0.12882869, -0.048748255, -0.14202079, -0.08404155, 0.03453428, -0.060811, 0.18254602), target1);
	target1 = MulAdd(a3, MF4x4(-0.011917425, 0.023498498, 0.0072831116, -0.05328629, 0.3426947, 0.08741361, 0.35501662, 0.045255594, 0.08008512, -0.002467051, -0.053357143, -0.05487847, 0.15113881, -0.050046794, -0.036305785, 0.06071048), target1);
	target1 = MulAdd(b3, MF4x4(-0.012859317, 0.06900528, -0.08498363, -0.08625659, -0.094864994, -0.04425656, -0.0071134693, 0.07542594, -0.08952303, -0.14963494, 0.115062006, 0.073727705, -0.06841927, 0.030572297, -0.060809616, -0.14095046), target1);
	target1 = MulAdd(c3, MF4x4(0.29680476, -0.070317306, -0.056082696, 0.27471995, 0.109471574, -0.012238972, 0.16928561, -0.12685184, -0.100722544, 0.116650775, 0.054211635, -0.06463175, -0.13047734, -0.070404656, -0.08516014, -0.11477897), target1);
	target1 = MulAdd(d3, MF4x4(0.058439, -0.1555504, -0.096580744, -0.024473842, 0.090628244, 0.04928509, 0.02740108, 0.0077335024, 0.026813101, 0.065165296, -0.059121966, 0.08125537, 0.16700324, -0.16615666, -0.14588222, 0.00048067764), target1);
	target1 = MulAdd(e3, MF4x4(-0.053213652, -0.16659884, -0.09036764, 0.010975479, -0.11077762, 0.11982606, 0.02579046, -0.13114569, 0.17622563, 0.023344778, 0.080385335, -0.08998645, -0.18493009, -0.048734408, 0.010119995, 0.12936613), target1);
	target1 = MulAdd(f3, MF4x4(-0.08402194, -0.16797844, -0.01022614, 0.09084325, 0.24871092, 0.13302508, -0.1210408, -0.04133277, -0.08691682, 0.02221635, 0.12621205, -0.15186077, 0.19762659, -0.10951936, -0.19129583, 0.21391307), target1);
	target1 = MulAdd(g3, MF4x4(-0.1687245, 0.16445398, -0.06853974, -0.086989194, -0.14615493, -0.009716202, -0.088772245, 0.13583103, -0.08530893, -0.09424376, -0.12971476, -0.02487141, -0.1094553, -0.04473294, -0.27410263, 0.043002244), target1);
	target1 = MulAdd(h3, MF4x4(0.03290918, -0.006952538, -0.12306263, 0.027640607, -0.025346387, -0.09620494, 0.116112545, 0.10227404, 0.03813908, 0.16176395, 0.47203362, 0.047157902, -0.10830938, -0.0019050312, 0.3620803, -0.069925636), target1);
	target1 = MulAdd(i3, MF4x4(0.0020446004, 0.16054538, 0.12809694, 0.0069585256, 0.11748204, -0.011759154, -0.12903488, 0.29380128, 0.21712495, 0.068177566, 0.059223883, 0.10227324, 0.3817376, -0.11270308, 0.0073445877, 0.21012813), target1);
	target1 = MulAdd(na1, MF4x4(-0.199299, -0.040114038, -0.15849929, 0.0057354206, 0.19681698, -0.107773945, -0.04031948, 0.12012136, -0.22728048, 0.045971204, -0.12776788, 0.025411135, -0.2745491, -0.113476306, -0.015801609, 0.008725868), target1);
	target1 = MulAdd(nb1, MF4x4(-0.28201059, -0.069104806, 0.015983578, -0.103806704, 0.121411614, -0.09251776, -0.08143648, 0.21460037, -0.07785157, 0.101122744, 0.013448072, -0.023710037, -0.0358346, 0.1328456, -0.02043331, -0.06159447), target1);
	target1 = MulAdd(nc1, MF4x4(0.06781508, -0.072408475, 0.083291575, 0.040496554, 0.04679973, 0.12705597, 0.06562132, -0.04938638, 0.21427007, -0.004967686, -0.08138591, 0.033386033, -0.048481766, 0.076613255, 0.21033032, -0.05062305), target1);
	target1 = MulAdd(nd1, MF4x4(-0.21217471, 0.13806537, 0.04606568, -0.13743265, 0.1806969, -0.085699804, -0.06342818, 0.1660658, -0.0026293355, -0.02128403, -0.0046605268, 0.008235694, -0.1171583, -0.24562967, -0.28818226, 0.12968758), target1);
	target1 = MulAdd(ne1, MF4x4(0.17914222, 0.12522437, -0.14189677, -5.616129e-05, 0.21868588, -0.24404518, -0.12704019, 0.25512457, 0.11127853, 0.043490496, -0.0034969563, -0.1935092, -0.12618113, 0.15022264, 0.10067992, -0.15296605), target1);
	target1 = MulAdd(nf1, MF4x4(0.059839483, -0.07332882, -0.0026434374, 0.22739156, 0.04557501, -0.03867732, 0.21676865, -0.058800567, 0.006406612, -0.011612252, 0.009007284, 0.059830897, 0.1614946, -0.07674529, -0.0385602, 0.39797354), target1);
	target1 = MulAdd(ng1, MF4x4(-0.1981268, -0.1361051, -0.06161995, -0.002189435, -0.0014002474, 0.126129, 0.023376467, 0.09703216, 0.10666224, -0.23168142, -0.018159337, 0.042339746, 0.12584367, -0.011922057, 0.10902402, 0.15436263), target1);
	target1 = MulAdd(nh1, MF4x4(0.0027595635, -0.10197207, -0.034429558, 0.06667168, 0.33573776, -0.099396594, -0.07997797, 0.08387646, 0.0951511, -0.16234699, -0.14867416, 0.00735437, -0.09362014, 0.0664804, 0.27731436, 0.37119982), target1);
	target1 = MulAdd(ni1, MF4x4(0.2548695, 0.028097544, -0.0022558135, 0.026973823, 0.1884029, -0.07246545, 0.21642277, 0.026800772, -0.19520886, -0.0009553605, 0.0062482627, -0.16592918, 0.48447585, 0.086303264, -0.05490935, 0.378503), target1);
	target1 = MulAdd(na2, MF4x4(0.1574428, 0.035142746, 0.079227954, 0.100714244, 0.11136245, 0.11895534, 0.009833678, -0.001039115, -0.069387674, -0.010426503, -0.10678969, 0.101909705, -0.031729374, 0.15894724, -0.23622003, -0.011815657), target1);
	target1 = MulAdd(nb2, MF4x4(-0.17458418, -0.120001495, 0.09203402, -0.002166517, 0.0031753816, 0.12831944, 0.16465144, -0.06330301, -0.24267045, -0.12281286, 0.052246343, 0.02494283, -0.18964235, 0.058346782, 0.0025673895, -0.01121613), target1);
	target1 = MulAdd(nc2, MF4x4(0.115957834, -0.060228895, 0.009079297, -0.040949136, 0.014297083, 0.036444042, 0.12076215, -0.1402084, 0.09574682, -0.06670408, 0.029599207, 0.04741757, 0.01102373, -0.05027519, 0.13449037, -0.099299684), target1);
	target1 = MulAdd(nd2, MF4x4(-0.029986456, -0.045808725, -0.05172542, -0.10101369, 0.03663162, 0.039696075, -0.08842631, -0.117827855, 0.1347963, -0.007392197, -0.05730133, -0.04402969, 0.13403495, 0.28114837, 0.17730127, -0.07764935), target1);
	target1 = MulAdd(ne2, MF4x4(-0.34972468, 0.006863505, -0.068723604, -0.30767044, 0.12904535, 0.0763381, -0.037620995, 0.028365362, -0.08700267, 0.2257665, 0.14819853, -0.16082688, 0.0929386, -0.0062676766, 0.17218679, -0.16327891), target1);
	target1 = MulAdd(nf2, MF4x4(-0.17909175, -0.09134105, -0.0057606776, -0.083825834, 0.1443505, 0.1877781, 0.02841784, 0.1146964, 0.3169764, 0.018749984, 0.19640554, -0.0014817682, -0.27608246, -0.080467306, -0.13688186, -0.06578604), target1);
	target1 = MulAdd(ng2, MF4x4(0.02515703, -0.03203328, 0.06439871, -0.06689986, -0.004256959, 0.17631707, 0.042148568, -0.088977, 0.07314368, -0.18564323, -0.11051338, -0.032011528, 0.3711881, 0.495717, 0.21411352, -0.0066381986), target1);
	target1 = MulAdd(nh2, MF4x4(-0.05550901, 0.06970293, -0.06802052, -0.022730853, 0.0143414615, 0.096654266, -0.045230158, 0.03669965, -0.08298829, -0.1573773, 0.12953721, -0.042050414, 0.04308049, 0.11458007, 0.0072063627, -0.18453878), target1);
	target1 = MulAdd(ni2, MF4x4(-0.16849747, 0.051144414, 0.020992253, -0.09341655, 0.05105659, 0.042700652, -0.06062117, 0.13699457, 0.2397991, -0.009917461, -0.059426248, 0.09855892, -0.28842947, 0.1404379, -0.022812406, -0.23883702), target1);
	target1 = MulAdd(na3, MF4x4(0.10231295, -0.05687462, 0.05454633, 0.1353426, 0.1760176, -0.11181645, -0.31677356, 0.06983046, 0.13605112, 0.17754814, 0.3348445, -0.1652707, -0.061019715, 0.1773025, -0.30495015, 0.11278704), target1);
	target1 = MulAdd(nb3, MF4x4(0.13603285, 0.10336861, -0.023782251, 0.13608527, -0.4052799, 0.14841305, -0.25663885, -0.012108956, 0.28822663, 0.04447834, -0.05276655, -0.18212605, -0.20188917, 0.10997185, 0.06183931, -0.055857945), target1);
	target1 = MulAdd(nc3, MF4x4(-0.2237108, 0.24488361, 0.18851626, -0.07019121, -0.021184865, -0.0499757, 0.026765132, -0.09804875, -0.011333142, -0.108678274, 0.040759776, -0.037615996, 0.14195605, -0.17333975, 0.09601836, 0.14565407), target1);
	target1 = MulAdd(nd3, MF4x4(0.12259593, 0.27562442, 0.24215461, 0.14960998, 0.08186383, -0.010550085, -0.019250091, -0.014648717, 0.14972208, 0.14603175, 0.10073407, -0.1225431, 0.1675907, 0.038280413, -0.06087625, 0.0130648045), target1);
	target1 = MulAdd(ne3, MF4x4(0.30968392, 0.11772451, -0.08816913, 0.12534001, -0.050786596, -0.21509898, -0.04253493, -0.04734682, 0.13719988, -0.09571686, -0.3094301, -0.08568065, -0.10093176, 0.024763435, 0.18954168, -0.227629), target1);
	target1 = MulAdd(nf3, MF4x4(-0.22520582, 0.18443918, 0.14025666, -0.18477283, -0.12125983, 0.010999684, -0.0024025543, 0.24120031, -0.13416757, 0.01567192, -0.013440386, 0.17282273, 0.16098748, -0.02793626, 0.15618294, -0.0131627675), target1);
	target1 = MulAdd(ng3, MF4x4(0.23410907, 0.019564115, -0.0076426617, -0.09377979, -0.47939178, -0.06636784, -0.0011904492, -0.09345677, -0.14794281, 0.25343522, -0.21156238, -0.01817268, 0.12250443, -0.0032213917, -0.19294205, 0.026571818), target1);
	target1 = MulAdd(nh3, MF4x4(-0.066518046, -0.011708588, -0.007350381, -0.16976248, 0.09265956, 0.08236158, 0.12594578, 0.021188073, -0.2299054, -0.12767331, -0.098674, 0.035027504, -0.1722649, -0.15037538, 0.037455063, -0.027518287), target1);
	target1 = MulAdd(ni3, MF4x4(-0.040520877, -0.17789118, 0.0535865, -0.15534161, 0.09352957, 0.11459578, -0.15315403, 0.04562035, -0.0015360791, 0.047871828, -0.021276174, 0.35346803, -0.10936083, 0.057735037, -0.089098595, 0.0057320776), target1);
	
	MF4 target2 = { 0.091157734, 0.06337161, 0.09025765, 0.07787731 };
	target2 = MulAdd(a1, MF4x4(-0.024318032, 0.062261496, 0.028226431, 0.063416876, -0.122350864, -0.0113668, 0.061698295, -0.22892742, -0.21282825, -0.30799037, -0.020646222, -0.21302511, 0.050188534, -0.03943688, -0.078553416, 0.010918215), target2);
	target2 = MulAdd(b1, MF4x4(-0.0064165345, 0.082449056, -0.03667216, 0.026472934, -0.021514278, 0.17880541, 0.39611253, -0.17107382, 0.06770686, -0.053641487, 0.002025645, 0.09812659, -0.07990987, -0.08550891, 0.00025631645, -0.10817648), target2);
	target2 = MulAdd(c1, MF4x4(-0.11507329, -0.06074527, 0.007052484, 0.015466066, 0.0675046, 0.28604895, -0.020563968, 0.04284168, -0.10729741, -0.103069924, 0.028218608, 0.2833194, 0.11628834, -0.06599205, -0.10394839, 0.13991328), target2);
	target2 = MulAdd(d1, MF4x4(0.14225487, 0.08203055, 0.027650036, 0.1459416, -0.013772616, 0.23131026, 0.044769842, 0.27454084, -0.047555555, 0.05384277, -0.09042822, -0.16309428, 0.040359538, 0.19854581, -0.026278, 0.1577506), target2);
	target2 = MulAdd(e1, MF4x4(-0.0091988975, -0.05603158, 0.08112747, 0.014755933, -0.50124913, 0.26424783, 0.1621611, -0.3766593, 0.15138763, 0.08449643, -0.16496105, 0.42882624, -0.010958174, 0.09773749, 0.22436622, -0.09687365), target2);
	target2 = MulAdd(f1, MF4x4(-0.019358287, 0.025669195, 0.290994, 0.02750369, 0.28040195, 0.24038815, 0.08250993, 0.021609074, -0.040725835, -0.19103482, -0.10284562, 0.022636155, 0.050841074, 0.0030245516, -0.23331137, 0.15245193), target2);
	target2 = MulAdd(g1, MF4x4(0.0992156, -0.09854949, 0.075423576, 0.008634914, 0.062402267, -0.22020867, -0.07628636, -0.055416584, -0.10278129, 0.117922865, 0.13292609, -0.011894427, 0.16825698, -0.036205966, 0.1424532, 0.10553304), target2);
	target2 = MulAdd(h1, MF4x4(0.19908716, -0.12244845, 0.01669312, -0.01248478, -0.009518143, -0.08615178, 0.39116043, -0.52616054, 0.11156954, -0.115720086, -0.07697886, 0.23553406, 0.017087052, 0.016129963, 0.24723524, -0.11207272), target2);
	target2 = MulAdd(i1, MF4x4(0.033391032, -0.1495619, -0.09304159, 0.30421168, 0.13344899, -0.31858364, -0.081601165, 0.13551356, 0.032184854, 0.016566517, -0.16247925, 0.034869343, 0.04001544, -0.08231552, -0.18482871, 0.19266751), target2);
	target2 = MulAdd(a2, MF4x4(0.21768865, 0.012509539, -0.16523208, 0.22101055, -0.017112812, 0.12730962, -0.066268146, -0.05613703, 0.021577986, 0.24617495, 0.15244165, -0.08514145, -0.10427943, 0.17322995, 0.25568137, -0.015480765), target2);
	target2 = MulAdd(b2, MF4x4(0.07753385, 0.021704786, 0.23479357, -0.21051238, -0.009220801, 0.20936434, -0.077434614, -0.09195854, -0.34075132, 0.17316882, 0.11968564, -0.021970788, 0.15152359, 0.28213486, 0.07805407, 0.099207774), target2);
	target2 = MulAdd(c2, MF4x4(0.054490507, 0.07500978, -0.08916167, 0.22030471, 0.07036594, 0.1673276, 0.01864345, 0.0027516915, -0.39270175, -0.03433242, -0.17433889, -0.18174602, 0.044357035, -0.04678205, 0.11330789, 0.047382314), target2);
	target2 = MulAdd(d2, MF4x4(0.07965972, -0.2201543, 0.18386759, -0.080045894, 0.04141404, -0.027790288, 0.032212794, -0.021278335, -0.070643224, 0.05221597, -0.06377366, 0.065172255, -0.18978727, 0.092385, -0.17461243, 0.2500567), target2);
	target2 = MulAdd(e2, MF4x4(-0.048105214, 0.43421936, -0.11871231, -0.12232125, 0.06071036, -0.07797472, -0.13819577, -0.14363539, -0.003262046, 0.05031809, -0.103945084, -0.22375908, -0.36861306, 0.25518808, 0.04773121, -0.22608627), target2);
	target2 = MulAdd(f2, MF4x4(-0.094031096, -0.011887294, -0.08532428, 0.112617865, 0.06823757, 0.21326852, 0.109153405, -0.3117106, -0.22819358, 0.123445965, -0.066512406, -0.21115267, -0.080148704, 0.12793726, -0.20465335, -0.104592934), target2);
	target2 = MulAdd(g2, MF4x4(0.045067977, -0.2181705, -0.0677207, 0.13714351, -0.098488234, 0.19015153, -0.09273758, -0.0746141, 0.032907944, -0.006554721, 0.045943078, -0.2017389, -0.07914341, -0.085856505, -0.22186919, -0.049897686), target2);
	target2 = MulAdd(h2, MF4x4(-0.10116989, -0.10004126, 0.09973816, -0.056045264, -0.18085082, 0.105252974, 0.11094914, -0.27471054, 0.20055285, -0.15355913, -0.080244385, -0.07118461, 0.02517136, -0.09862167, 0.22725868, -0.06279268), target2);
	target2 = MulAdd(i2, MF4x4(0.10015747, -0.22263162, -0.014078088, -0.08387323, 0.005140913, 0.03506062, 0.18977262, -0.1479168, -0.03378466, -0.15656684, -0.061233502, -0.21884726, -0.24339373, -0.06372294, 0.12688471, -0.10735916), target2);
	target2 = MulAdd(a3, MF4x4(0.033982676, 0.05078853, -0.1282201, -0.0035882539, 0.08219379, -0.0116551975, 0.22077334, 0.04950106, -0.08306263, -0.03258243, -0.09699666, 0.09209884, 0.24061108, -0.040557686, 0.070444405, 0.28183722), target2);
	target2 = MulAdd(b3, MF4x4(-0.17872535, -0.13406444, -0.034040287, 0.03047437, -0.06435232, -0.24566554, 0.0670411, -0.024581233, -0.107877605, 0.08638364, -0.25626892, 0.044232026, 0.060273834, -0.16846469, 0.43043453, -0.1603817), target2);
	target2 = MulAdd(c3, MF4x4(-0.22682182, 0.15527044, -0.08887372, -0.043433297, 0.028202614, -0.1919475, 0.2581379, -0.28678998, 0.040917493, -0.023046691, 0.20005395, -0.103288084, 0.009493088, -0.018459544, 0.081757404, 0.054610446), target2);
	target2 = MulAdd(d3, MF4x4(-0.022377692, 0.008678131, -0.1065251, 0.2628791, -0.009904344, 0.10677991, -0.040256146, -0.116764925, 0.03182517, 0.11810951, -0.052380614, 0.30170968, 0.2569954, -0.17379415, -0.007437352, -0.13248402), target2);
	target2 = MulAdd(e3, MF4x4(0.1602437, -0.097451374, -0.010258972, 0.12651087, -0.0061891475, 0.078265965, 0.08754248, -0.14903383, -0.07830899, -0.08898991, -0.058010247, 0.23148704, -0.3695693, 0.18824111, -0.07988307, -0.05880814), target2);
	target2 = MulAdd(f3, MF4x4(-0.22253856, 0.26592886, -0.03350701, -0.14712897, -0.12118757, 0.19663027, 0.031479847, -0.1554313, -0.028078854, 0.47659087, 0.12390117, -0.11238944, 0.037422795, -0.049916733, -0.2926893, 0.16435196), target2);
	target2 = MulAdd(g3, MF4x4(0.075061694, -0.24045657, -0.047069702, -0.09982952, 0.2340634, -0.33556157, -0.037818547, 0.15286541, 0.14214562, 0.02267143, 0.09929496, -0.055981826, 0.21834296, -0.19831084, -0.16977312, 0.08182871), target2);
	target2 = MulAdd(h3, MF4x4(0.01741376, 0.08985922, 0.16625583, -0.097267725, 0.17712043, -0.068722576, 0.07060928, 0.09168345, -0.16337997, -0.038742293, -0.04963981, 0.15612502, 0.11807448, -0.08807022, 0.101155974, -0.5563793), target2);
	target2 = MulAdd(i3, MF4x4(-0.27598697, -0.062920116, -0.08726363, -0.12058882, -0.07664108, -0.032059796, -0.25070706, 0.030094638, -0.1160773, 0.19200212, 0.18899699, -0.18259315, 0.24458873, 0.12005026, -0.4616454, 0.27545306), target2);
	target2 = MulAdd(na1, MF4x4(0.15272795, -0.23518732, 0.030445633, 0.088528365, 0.055305615, -0.12609963, 0.15926869, -0.22551426, 0.040562432, 0.124508515, 0.124815956, -0.0953939, 0.14920413, 0.14798881, -0.14428794, 0.37141335), target2);
	target2 = MulAdd(nb1, MF4x4(0.12783955, -0.0540082, 0.014302729, 0.1365942, 0.10768764, -0.16831467, -0.079203665, 0.1425581, 0.019629346, -0.1027023, 0.15957874, -0.29757223, 0.26533285, -0.15765496, 0.35999995, 0.025803005), target2);
	target2 = MulAdd(nc1, MF4x4(0.29036346, 0.26730424, 0.12511441, -0.061552685, -0.16372615, -0.026372833, 0.14069465, -0.24948902, 0.028215056, 0.254545, -0.19650677, 0.09530049, 0.055034224, -0.009660105, 0.39131105, -0.11131454), target2);
	target2 = MulAdd(nd1, MF4x4(-0.0675603, -0.24606612, 0.0658764, -0.04487242, -0.0043948023, 0.04578745, 0.065714814, -0.12173881, 0.06062957, -0.04769831, 0.017330103, -0.074727364, -0.25047338, -0.30126756, -0.0830633, 0.019802446), target2);
	target2 = MulAdd(ne1, MF4x4(0.19933821, 0.08052119, -0.058912043, 0.31624097, 0.18705179, 0.023470681, -0.03783429, -0.04163007, -0.09845593, -0.12975362, 0.2510535, -0.32808807, -0.23654252, 0.3028382, -0.19675751, -0.030597644), target2);
	target2 = MulAdd(nf1, MF4x4(0.09338011, -0.0415115, -0.22497573, -0.0028536345, -0.19024974, -0.1604205, 0.115466096, -0.2525424, -0.063761264, -0.20588842, 0.08622651, -0.00097166066, 0.10169425, 0.252253, -0.06758796, 0.23335451), target2);
	target2 = MulAdd(ng1, MF4x4(-0.04426442, 0.1095582, -0.085856594, 0.13048999, -0.12778096, 0.2613617, -0.045577575, -0.1526907, 0.1257047, -0.111831486, -0.059892397, 0.15280181, -0.12673315, -0.05033893, -0.2930266, -0.46015793), target2);
	target2 = MulAdd(nh1, MF4x4(-0.11951625, 0.03414521, -0.11969193, 0.1869847, 0.111495204, 0.080608666, -0.20057446, 0.10785576, -0.049578592, 0.016259808, 0.0058614444, -0.045524042, 0.0319529, 0.05456559, 0.007678947, 0.33595043), target2);
	target2 = MulAdd(ni1, MF4x4(0.10240467, 0.18299319, 0.05753473, -0.02340504, -0.16686855, 0.21292439, 0.11702374, -0.30564633, -0.024081768, -0.088019624, 0.22313595, -0.06672843, 0.055274762, 0.13347326, -0.030782074, -0.35677573), target2);
	target2 = MulAdd(na2, MF4x4(-0.075412944, -0.11053347, 0.07465402, -0.014327975, -0.13390768, 0.009061153, 0.027920425, -0.005080267, -0.04721174, -0.06812053, -0.08845801, 0.109399185, -0.04021429, 0.03812722, -0.25037023, -0.019478017), target2);
	target2 = MulAdd(nb2, MF4x4(-0.07806179, 0.00493842, -0.02926109, -0.017333046, -0.125423, -0.1364203, 0.09466317, -0.26578787, 0.14311473, -0.0638623, 0.11139706, -0.08727186, -0.06821389, -0.19687861, 0.14772336, -0.10641787), target2);
	target2 = MulAdd(nc2, MF4x4(0.027460072, 0.15687883, -0.17656918, 0.037287217, -0.06293563, -0.03923116, 0.037919715, -0.16810033, 0.26675344, -0.06076212, 0.104115106, 0.0798128, -0.023851654, 0.033833887, -0.030991107, 0.20160522), target2);
	target2 = MulAdd(nd2, MF4x4(-0.058332916, -0.09243659, -0.24664097, -0.13549158, -0.1218952, 0.15865086, -0.1388978, -0.25030297, 0.045538265, 0.04120175, -0.031994786, -0.13400851, 0.007142682, 0.16071808, 0.04225278, 0.20399003), target2);
	target2 = MulAdd(ne2, MF4x4(-0.09599313, -0.15977086, -0.02840129, 0.1264139, -0.0144603, -0.00054464, 0.025552921, -0.09051482, -0.06592454, -0.026247922, -0.06352208, -0.021571407, -0.04439837, -0.07514258, 0.0026004864, 0.23430851), target2);
	target2 = MulAdd(nf2, MF4x4(0.09127431, -0.21962664, 0.029265152, -0.3099013, -0.09579088, 0.023516538, -0.08382231, 0.05348487, 0.17067212, -0.16390987, 0.03691037, 0.01566425, 0.18072702, 0.10966007, 0.22929187, 0.23833585), target2);
	target2 = MulAdd(ng2, MF4x4(0.083102494, 0.18586425, 0.09552713, -0.22502401, 0.10707524, -0.041579556, -0.040507507, -0.07875607, 0.13548316, 0.065970294, -0.09524086, 0.12988009, -0.19841906, -0.016670253, 0.2779514, 0.0039394014), target2);
	target2 = MulAdd(nh2, MF4x4(-0.056897737, -0.022942321, -0.089304574, 0.01799863, -0.031229522, 0.08292495, -0.040067356, -0.09749493, -0.2211719, 0.110088974, 0.05465516, -0.12767765, -0.06458067, -0.17160612, -0.09046756, -0.09943958), target2);
	target2 = MulAdd(ni2, MF4x4(-0.20148912, 0.017609052, 0.2321357, -0.07018911, -0.1311024, 0.007025396, -0.3018123, 0.059590653, 0.02093451, 0.2801181, 0.047305427, -0.04511682, 0.02409926, -0.1167535, -0.051785782, -0.022035388), target2);
	target2 = MulAdd(na3, MF4x4(-0.050354917, -0.070848934, 0.05680098, -0.15274279, 0.017402016, 0.36217922, -0.5604259, 0.07027285, 0.013515239, -0.024368018, 0.15436645, -0.20279783, -0.009300287, 0.07763277, -0.12982416, 0.018808186), target2);
	target2 = MulAdd(nb3, MF4x4(0.06595005, 0.34867665, -0.1158312, -0.11764399, -0.36079824, -0.03821222, -0.019823037, -0.44939035, -0.16058454, 0.0022173142, -0.067403175, 0.094619855, -0.054194376, -0.15860401, 0.031142738, -0.020085743), target2);
	target2 = MulAdd(nc3, MF4x4(0.15504256, -0.22207503, -0.037738267, -0.024344966, 0.22112809, -0.084620684, 0.31442386, -0.17054078, -0.14580488, -0.1475954, 0.014907614, -0.009613608, -0.120833494, 0.024163049, 0.055504505, 0.12984537), target2);
	target2 = MulAdd(nd3, MF4x4(0.03553467, -0.047465023, 0.127075, -0.17350323, 0.17346224, -0.15783796, 0.15583144, 0.01985312, 0.019021586, -0.03840401, 0.19470496, -0.007293492, -0.17917366, -0.15722491, -0.26070598, -0.2573391), target2);
	target2 = MulAdd(ne3, MF4x4(-0.0953191, 0.09084944, 0.25338924, 0.23829061, 0.08905475, -0.02061248, -0.012651722, 0.11955581, 0.239715, -0.2795726, 0.06275163, -0.15498403, -0.042101745, -0.16694753, -0.049197655, 0.06470607), target2);
	target2 = MulAdd(nf3, MF4x4(0.07657325, -0.35392562, -0.055532675, -0.18168893, 0.08006482, 0.12548354, -0.17169037, 0.41884392, 0.047854125, -0.13949591, -0.34051692, 0.18265511, 0.082268566, 0.24420416, -0.049996477, -0.018989688), target2);
	target2 = MulAdd(ng3, MF4x4(-0.16161917, 0.16816078, 0.018195407, 0.16679527, -0.3412548, 0.14028408, 0.17574453, -0.06049301, -0.01611411, -0.046527516, -0.044087164, 0.25788495, 0.13769192, -0.016161619, 0.041910134, 0.042887107), target2);
	target2 = MulAdd(nh3, MF4x4(0.07837116, -0.22945437, -0.05715237, 0.062118188, -0.07539828, 0.22634326, -0.19471732, 0.31986186, 0.15694539, 0.1633341, -0.03029404, 0.056681212, -0.029835409, -0.13129339, 0.19710875, 0.13151285), target2);
	target2 = MulAdd(ni3, MF4x4(0.017191496, 0.33163047, -0.026875576, 0.19212759, 0.27074674, 0.17707312, -0.13339694, 0.10855495, -0.18034323, 0.43113244, -0.33985507, 0.316351, 0.0358167, 0.023788683, 0.13152061, -0.019543748), target2);

	MF4 target3 = { 0.013481283, -0.0006846239, 0.017479934, 0.13998064 };
	target3 = MulAdd(a1, MF4x4(-0.10152706, 0.13643685, 0.050397865, 0.10665431, 0.026328163, 0.1460299, 0.2569912, -0.19533697, 0.03801618, 0.0003496284, 0.18598852, -0.22565664, 0.05281963, -0.034972392, -0.14308542, 0.030370854), target3);
	target3 = MulAdd(b1, MF4x4(-0.004119863, 0.057859607, -0.2119656, 0.14261195, -0.16826284, -0.25717396, -0.041528255, -0.119776234, -0.1013885, 0.16835499, 0.27712375, 0.11540263, 0.13435264, -0.15992326, -0.011525119, -0.052719552), target3);
	target3 = MulAdd(c1, MF4x4(0.015662286, 0.039283197, 0.1298957, 0.14770529, 0.16800109, -0.26307538, -0.043486428, -0.088268735, -0.091123246, -0.02737689, 0.1340816, 0.20996217, 0.108091205, 0.030314112, 0.054512065, 0.012642684), target3);
	target3 = MulAdd(d1, MF4x4(0.06709217, -0.05501374, 0.081222005, 0.089457735, 0.18656515, -0.3077529, 0.047672454, 0.024508892, -0.1351014, -0.39228433, -0.10557932, -0.04361972, -0.11915583, -0.009581473, 0.0063169855, -0.03613457), target3);
	target3 = MulAdd(e1, MF4x4(-0.1854358, -0.17342652, -0.194473, 0.3151401, -0.051769286, -0.3236325, 0.16018392, -0.057727765, 0.16584621, -0.017418258, -0.3128051, 0.07975532, 0.18611333, 0.026310056, 0.02726216, 0.0067486716), target3);
	target3 = MulAdd(f1, MF4x4(-0.110896066, -0.00702464, -0.20931682, 0.24850254, 0.03269825, -0.18380491, 0.032377258, 0.19312768, -0.22545849, 0.20047729, -0.21857505, 0.04958539, -0.012481836, 0.09664499, -0.14021717, -0.011379809), target3);
	target3 = MulAdd(g1, MF4x4(0.029377487, -0.03222012, -0.047782637, 0.15043634, -0.028922928, 0.14329837, 0.070593685, 0.17937078, -0.098229684, -0.017268147, 0.023314565, -0.0373697, 0.086789444, -0.041083477, -0.14991397, 0.1569613), target3);
	target3 = MulAdd(h1, MF4x4(-0.15204531, 0.038198274, -0.04654972, -0.023292607, 0.043118156, -0.1646481, -0.19841586, 0.0921996, -0.020243818, -0.006126642, 0.0073893177, -0.2155937, -0.051742166, -0.12905034, 0.026826771, -0.14480315), target3);
	target3 = MulAdd(i1, MF4x4(0.10036964, 0.1710007, -0.07876652, 0.22185723, -0.07879332, -0.009758965, -0.07071612, 0.091213554, -0.112285696, 0.03389832, -0.028804176, -0.030022187, -0.1688445, 0.11049307, -0.054812532, 0.093897834), target3);
	target3 = MulAdd(a2, MF4x4(-0.12732436, 0.085322656, -0.100760445, 0.18453589, -0.06775451, 0.10935976, 0.17619863, -0.1605919, 0.09963296, -0.15262389, 0.09841437, -0.19519499, -0.07014624, 0.25242952, -0.05024359, 0.087294735), target3);
	target3 = MulAdd(b2, MF4x4(0.015800908, -0.14473227, -0.2478373, 0.053460408, -0.14864206, -0.043255955, 0.11067259, 0.0014784707, 0.12921435, -0.03185401, 0.116656736, -0.03951376, 0.06561661, -0.04718704, -0.10218965, 0.11587745), target3);
	target3 = MulAdd(c2, MF4x4(0.07117372, 0.0109037515, -0.23872098, 0.07710495, 0.0921179, -0.1644194, -0.13181047, -0.057200883, 0.14430603, 0.10133447, 0.28212273, 0.09411812, -0.048196144, 0.0436184, -0.13561143, 0.3184622), target3);
	target3 = MulAdd(d2, MF4x4(-0.18523192, 0.21471006, -0.0448867, 0.014551903, 0.009904246, -0.15023962, 0.004197992, -0.17210527, 0.194157, -0.08507272, 0.20821328, 0.053412434, 0.3099377, 0.119032666, -0.18388903, -0.19600375), target3);
	target3 = MulAdd(e2, MF4x4(0.2807314, 0.2189851, 0.25916493, 0.060228985, -0.0049263136, -0.074992225, -0.15787919, -0.054917946, 0.12066998, -0.21063392, 0.14343189, -0.033192027, -0.010535234, 0.14374483, 0.1522993, -0.07717713), target3);
	target3 = MulAdd(f2, MF4x4(-0.043371633, 0.13011403, -0.0015406794, -0.0128029715, 0.17256962, -0.04676938, 0.15432738, -0.07865593, 0.13326003, -0.20808597, -8.7830034e-05, 0.19136547, -0.1985925, -0.013042362, -0.22718841, -0.06583816), target3);
	target3 = MulAdd(g2, MF4x4(-0.11845248, 0.027589038, 0.10232536, 0.089354545, 0.18008573, 0.061147142, 0.04159389, -0.12027304, 0.1662144, -0.19675921, 0.12992287, -0.10149212, 0.10550842, -0.006124143, 0.19946195, -0.1462058), target3);
	target3 = MulAdd(h2, MF4x4(0.01296488, -0.09644271, -0.05817923, -0.0954995, 0.025634903, -0.10628822, -0.05637768, -0.284114, 0.17925075, 0.01273799, 0.309424, -0.036070596, -0.17971297, -0.35284916, 0.028788334, -0.040968318), target3);
	target3 = MulAdd(i2, MF4x4(-0.14511016, -0.036098864, -0.029634831, -0.081007525, 0.17456302, -0.3121309, -0.005653063, -0.13220096, 0.07959643, 0.13494255, 0.16009367, 0.022134677, -0.06916521, -0.068016514, -0.07418041, -0.106386214), target3);
	target3 = MulAdd(a3, MF4x4(0.0038909556, 0.10399398, -0.047585238, 0.020263152, 0.22357577, 0.20275299, -0.20587234, -0.14618087, -0.06699123, 0.05799765, -0.057206634, 0.070337296, 0.26828194, -0.110529095, -0.039317895, 0.1000372), target3);
	target3 = MulAdd(b3, MF4x4(-0.12016816, -0.1746712, -0.15243006, 0.09121186, 0.17119732, 0.09372113, -0.011121283, 0.01683138, 0.04647735, 0.26708847, -0.045210358, -0.05229348, 0.13961853, -0.23234563, 0.11518522, 0.025384203), target3);
	target3 = MulAdd(c3, MF4x4(0.24803765, -0.12064236, 0.16222163, 0.10242684, 0.35362238, -0.0025835831, 0.10871223, -0.14052986, 0.086918466, 0.003965692, -0.052900802, -0.09219091, -0.097256884, 0.027730078, -0.018556952, 0.029902605), target3);
	target3 = MulAdd(d3, MF4x4(-0.07853819, -0.33072472, -0.01923759, -0.022614414, 0.037449032, 0.0057582236, 0.035095196, -0.10516724, 0.021059662, -0.1803607, -0.072927505, -0.032927528, 0.10600866, 0.2115304, -0.038914077, 0.026641702), target3);
	target3 = MulAdd(e3, MF4x4(-0.046708018, -0.30087915, 0.23972215, 0.051118676, -0.09175249, 0.061564893, -0.0606459, 0.10725062, 0.16634792, 0.15181623, -0.14776988, -0.089753665, 0.09396779, 0.3047946, 0.20602426, -0.10614584), target3);
	target3 = MulAdd(f3, MF4x4(0.16031305, -0.010385087, 0.12137829, 0.013936002, -0.09272479, -0.0462326, 0.14647374, -0.1364509, 0.1020013, 0.07280318, -0.035455197, -0.0074932426, 0.06966262, 0.43025437, 0.14413132, -0.020879302), target3);
	target3 = MulAdd(g3, MF4x4(-0.048381433, 0.055672538, 0.17734092, 0.057804573, -0.064207256, -0.081648245, -0.19108449, -0.027356787, 0.22855555, 0.026296774, 0.051670585, 0.1469678, 0.14372535, -0.019550381, 0.0711832, -0.23015371), target3);
	target3 = MulAdd(h3, MF4x4(0.10270051, 0.03306284, 0.18660016, -0.08794835, 0.022104584, 0.14556691, -0.18290472, -0.004233608, 0.31982687, -0.019705234, -0.18947408, -0.014298402, 0.13134713, -0.22212905, -0.22175267, -0.083559796), target3);
	target3 = MulAdd(i3, MF4x4(0.09405076, -0.094762795, 0.00039714025, -0.033925287, -0.040082168, 0.18154381, -0.091368884, -0.002279935, 0.18112488, -0.16065024, -0.07302534, -0.054364413, -0.027507186, 0.056911435, -0.25985143, 0.19071229), target3);
	target3 = MulAdd(na1, MF4x4(-0.08038882, -0.23933147, 0.091805875, 0.06882283, 0.030006107, -0.19613835, -0.19390447, -0.06947256, -0.15933713, -0.12136816, 0.10496873, 0.20988281, -0.06429982, 0.13831986, -0.12110751, -0.013753183), target3);
	target3 = MulAdd(nb1, MF4x4(-0.03526272, 0.09196733, 0.22100714, -0.034608632, 0.11271489, 0.19354948, -0.08702665, 0.0818318, -0.23144986, -0.39077505, 0.068490066, -0.07049248, -0.15327029, -0.13464752, -0.23453039, -0.007664983), target3);
	target3 = MulAdd(nc1, MF4x4(-0.071974635, -0.09427919, -0.14303383, -0.15694854, -0.0536355, 0.072341934, 0.0919402, -0.032855745, 0.061292388, 0.09840731, 0.035950005, -0.064508714, -0.121800035, -0.18790516, -0.098817684, -0.032492902), target3);
	target3 = MulAdd(nd1, MF4x4(-0.006014576, 0.056944408, -0.04101546, -0.07834956, 0.048266124, 0.013926315, 0.041723326, -0.323333, -0.41566008, 0.3228979, 0.004536671, 0.31018063, -0.32762045, 0.23986395, 0.0941997, 0.32134023), target3);
	target3 = MulAdd(ne1, MF4x4(-0.07315801, -0.04973393, -0.022297578, -0.0803329, -0.006434735, 0.010591334, 0.036642008, 0.099703625, -0.30428717, -0.13702157, 0.05784328, -0.08263622, -0.16771519, 0.012717832, 0.16369238, 0.082922), target3);
	target3 = MulAdd(nf1, MF4x4(0.0001620341, 0.13469625, 0.022239598, -0.045452654, -0.012625867, -0.016001742, -0.13125779, 0.035808936, -0.06057855, -0.23169748, -0.031564385, 0.0035062286, 0.08688842, 0.043959387, 0.045130596, -0.082511395), target3);
	target3 = MulAdd(ng1, MF4x4(-0.083551735, -0.0062169307, -0.071006864, 0.08302828, 0.041814975, -0.17135905, -0.051279463, -0.23531726, -0.07600026, -0.016305951, -0.12496258, 1.6274626e-05, -0.056098733, 0.05471391, -0.16807914, 0.043552015), target3);
	target3 = MulAdd(nh1, MF4x4(0.10614594, 0.055918783, -0.04306798, 0.12271233, -0.053095255, -0.041611873, 0.0658641, -0.17270197, -0.17228878, 0.04906801, 0.025378078, 0.03993686, 0.26168197, -0.0664166, -0.24114749, 0.122338526), target3);
	target3 = MulAdd(ni1, MF4x4(-0.028463805, -0.06832796, -0.042678714, -0.09115425, 0.112060644, -0.11552275, -0.13850841, -0.21241449, -0.025949117, -0.25152782, 0.118504696, -0.0032011967, -0.004659375, 0.14416796, 0.10196362, -0.25900578), target3);
	target3 = MulAdd(na2, MF4x4(-0.014083873, -0.14722492, -0.04869616, -0.0060440497, -0.06496493, -0.080328904, 0.0021304504, -0.071984075, 0.037136473, -0.06741335, 0.047950987, 0.13102819, -0.084352426, 0.021756288, 0.14978755, -0.07930937), target3);
	target3 = MulAdd(nb2, MF4x4(-0.043805413, 0.11554947, 0.08058495, -0.029509902, 0.07255308, -0.11107158, 0.19269472, -0.06936789, -0.056554012, -0.13389792, 0.05822567, -0.080038816, -0.11012767, -0.2594496, 0.013091632, -0.016040247), target3);
	target3 = MulAdd(nc2, MF4x4(0.11076819, 0.29110146, 0.010078737, -0.07397723, 0.017001567, -0.0600932, 0.120115615, -0.1516764, -0.046932317, -0.1531205, -0.041367747, 0.03022747, 0.028425755, -0.09993652, 0.105394356, -0.097724885), target3);
	target3 = MulAdd(nd2, MF4x4(-0.16120721, 0.12060183, -0.051696084, 0.13536309, -0.0629108, 0.20782739, 0.08011087, 0.16132146, -0.17330962, 0.075349055, -0.13367563, 0.0834821, 0.13859299, -0.24726664, 0.1219966, 0.008662899), target3);
	target3 = MulAdd(ne2, MF4x4(-0.06673648, -0.059848122, -0.079399005, 0.07430188, 0.039565083, -0.02646128, 0.06627121, -0.15686277, -0.08100342, 0.211192, 0.11364034, -0.056452975, 0.003068278, -0.09815622, -0.2720423, -0.060945407), target3);
	target3 = MulAdd(nf2, MF4x4(0.10425103, -0.11963076, -0.15664895, -0.008325704, 0.030473476, -0.059397645, 0.08696136, -0.105832994, 0.15845199, -0.0155479815, 0.21866821, -0.24220671, -0.07413551, 0.18748072, 0.15781933, 0.09678578), target3);
	target3 = MulAdd(ng2, MF4x4(-0.105755776, 0.05295692, -0.065712206, -0.055599883, -0.024171222, -0.10882413, -0.019153712, -0.0797682, -0.05841592, 0.027539523, 0.018220939, 0.025832783, 0.10254366, 0.027248384, 0.17515337, 0.13366127), target3);
	target3 = MulAdd(nh2, MF4x4(0.14450707, 0.16593692, 0.10250131, 0.022199351, 0.00025016058, 0.02208959, -0.015518909, 0.03897976, 0.066313244, -0.08834062, -0.06497536, 0.21156809, -0.028999787, 0.1924942, 0.27274308, -0.19622537), target3);
	target3 = MulAdd(ni2, MF4x4(0.06670714, 0.032708794, 0.08869534, -0.1733506, 0.0076623727, 0.12130858, 0.010788659, -0.046009142, 0.09683414, -0.2074643, 0.08545223, 0.0447272, 0.12027344, 0.20864709, 0.17474543, 0.13670264), target3);
	target3 = MulAdd(na3, MF4x4(0.021432638, -0.24760821, 0.12410156, -0.11143068, 0.1870739, 0.0740915, 0.11552895, -0.061147105, -0.037998777, -0.1789209, 0.02577988, -0.1907707, 0.16632228, 0.029018525, 0.016788188, 0.16683672), target3);
	target3 = MulAdd(nb3, MF4x4(0.1736272, 0.052254014, -0.010544911, -0.25163132, -0.021734655, -0.23477079, 0.30037084, -0.024889933, 0.16576701, 0.11785999, -0.19426535, 0.012973521, -0.31330642, -0.12940904, 0.1407924, -0.104257464), target3);
	target3 = MulAdd(nc3, MF4x4(-0.10720734, -0.22007015, 0.06929706, 0.1128352, 0.08878798, -0.74968565, 0.05292707, -0.2015415, -0.22024418, 0.12937216, 0.0077955252, 0.10120546, -0.051692892, -0.4005671, 0.019636473, -0.020149691), target3);
	target3 = MulAdd(nd3, MF4x4(0.43247837, -0.18930417, -0.013568917, -0.079419196, 0.18672904, -0.35622415, 0.25079453, -0.1175358, 0.26581118, 0.008579299, 0.18397655, -0.29648697, -0.15222591, 0.32292458, -0.011576255, -0.030688757), target3);
	target3 = MulAdd(ne3, MF4x4(0.10460517, 0.22705384, -0.11461504, -0.34884137, 0.06710358, 0.07710169, -0.22747318, -0.03428357, -0.12087394, -0.18585229, 0.053487252, -0.15423988, -0.24636437, 0.42574164, -0.20994124, -0.13236474), target3);
	target3 = MulAdd(nf3, MF4x4(-0.15691194, -0.08720117, -0.052925915, -0.16245657, -0.16402285, 0.3253476, 0.1616336, 0.072358444, -0.19095042, 0.21235181, 0.033952657, -0.021103038, 0.1247694, 0.228517, 0.032327496, -0.21903606), target3);
	target3 = MulAdd(ng3, MF4x4(-0.14174855, -0.06494216, 0.13284135, -0.08129453, 0.16482054, 0.110014215, 0.15709473, -0.010275839, -0.22032334, -0.10103909, -0.11650554, -0.17561941, 0.085149735, -0.40727508, 0.12032625, -0.02078777), target3);
	target3 = MulAdd(nh3, MF4x4(-0.27078578, -0.08153653, 0.1757881, 0.11317136, 0.27882257, -0.24042514, -0.08648888, -0.045675088, -0.10128582, -0.04766186, 0.06836051, 0.15924035, 0.04440567, -0.099891834, -0.08893405, 0.05721548), target3);
	target3 = MulAdd(ni3, MF4x4(0.15327021, 0.13603994, 0.17330587, 0.05625383, -0.11157126, -0.08179826, 0.05035325, -0.012668053, 0.04673393, 0.29881957, 0.019924281, -0.06682304, -0.034375366, -0.11446407, 0.055847015, 0.104117975), target3);

	MF3 target4 = tex8.SampleLevel(sam, pos, 0).rgb;
	target4 = MulAdd(e1, MF4x3(0.027129134, 0.01044246, 0.008198051, -0.019978391, 0.014817045, 0.014294805, -0.009071333, -0.018233696, -0.020756468, -0.016967475, -0.010472854, -0.0066578956), target4);
	target4 = MulAdd(e2, MF4x3(0.012473992, -0.019771596, -0.02515739, -0.008238026, 0.026189122, 0.034326296, 0.01735337, -0.021417223, -0.027291182, 0.01815212, -0.012736875, -0.021111157), target4);
	target4 = MulAdd(e3, MF4x3(0.022218483, -0.023485998, -0.03540812, 0.016531168, -0.0033816632, -0.010179393, -0.03181473, -0.0072774286, 0.0014077872, -0.0025735856, -0.015998563, -0.016743565), target4);
	target4 = MulAdd(ne1, MF4x3(-0.01740865, 2.3718083e-05, 0.0032518203, 0.009272118, -0.01676428, -0.019791994, 0.013665012, 0.02245221, 0.022923533, 0.020898446, 0.012111701, 0.009756352), target4);
	target4 = MulAdd(ne2, MF4x3(-0.0043926076, 0.019400991, 0.022581568, 0.003538965, -0.031301565, -0.0345112, -0.02405352, 0.006159623, 0.016130725, -0.0097925, 0.01677507, 0.027652735), target4);
	target4 = MulAdd(ne3, MF4x3(-0.03267886, 0.014923966, 0.027258545, -0.033668566, -0.010421195, -0.0026646685, 0.015094835, -0.0023233194, -0.015871005, -0.01258443, 0.00507582, 0.0053544766), target4);

	tex1[gxy] = target1;
	tex2[gxy] = target2;
	tex3[gxy] = target3;
	tex7[gxy] = MF4(target4, 1);
}

//!PASS 8
//!DESC Conv-4x3x3x24, Conv-3x1x1x120
//!IN INPUT, tex1, tex2, tex3, tex7
//!OUT OUTPUT
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass8(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	
	const uint2 outputSize = GetOutputSize();
	if (gxy.x >= outputSize.x || gxy.y >= outputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = tex1.SampleLevel(sam, pos, 0);
	MF4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = tex2.SampleLevel(sam, pos, 0);
	MF4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    MF4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = tex3.SampleLevel(sam, pos, 0);
	MF4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target1 = { 0.20634188, -0.10455712, -0.031700566, -0.13400781 };
	target1 = MulAdd(a1, MF4x4(-0.013182829, 0.053091962, 0.06549412, 0.09314398, 0.12759157, 0.19831958, -0.0066986284, 0.008724786, -0.008788724, -0.18448268, -0.08061004, -0.122672, 0.039246775, 0.114899494, 0.0053096768, -0.45705518), target1);
	target1 = MulAdd(b1, MF4x4(-0.15435986, 0.12775438, 0.033445876, 0.13065258, -0.034713954, 0.011218427, -0.056961175, -0.028291933, 0.014069658, -0.12902507, 0.09579773, -0.24455607, 0.14417914, 0.05937612, 0.2243551, -0.3940324), target1);
	target1 = MulAdd(c1, MF4x4(0.019673724, 0.20209175, 0.0864056, 0.062125377, -0.032693543, -0.07866025, 0.049098648, 0.09967038, 0.071991436, -0.035584584, 0.08620264, -0.3146151, 0.0016364265, -0.1282453, 0.113696136, -0.09162608), target1);
	target1 = MulAdd(d1, MF4x4(-0.086494565, -0.031322442, -0.0010425163, 0.0043439222, -0.2207718, -0.114754595, -0.04754309, 0.038829442, 0.28012696, 0.01416326, -0.006575263, 0.09800945, 0.20944737, 0.12320554, -0.27976176, 0.042036757), target1);
	target1 = MulAdd(e1, MF4x4(-0.0043551656, -0.034230676, 0.047720857, -0.0913431, 0.25977305, 0.21515612, 0.18708718, -0.004843006, 0.29522216, 0.03641434, -0.096512936, -0.07962972, -0.07454651, -0.2631387, -0.3370317, 0.40316954), target1);
	target1 = MulAdd(f1, MF4x4(0.07995683, -0.17652078, 0.0023912708, -0.02042794, 0.17486735, -0.22842996, -0.06893651, -0.19074234, 0.10076771, 0.11205654, 0.001572062, 0.024552155, -0.00011488878, -0.12493254, -0.29600865, 0.07090882), target1);
	target1 = MulAdd(g1, MF4x4(0.017154403, 0.13125315, 0.11503914, 0.105513334, -0.11673632, -0.034176424, -0.030536361, -0.002248858, -0.11892652, -0.08516513, 0.06950209, 0.17622153, 0.06246307, -0.07698598, 0.2093879, -0.058301486), target1);
	target1 = MulAdd(h1, MF4x4(0.10316161, 0.0072260876, 0.07716615, -0.13834251, -0.010482067, 0.15220478, 0.09262941, 0.08135313, 0.14277095, -0.15209594, -0.15694623, 0.0658977, 0.16643007, -0.04802777, 0.039331965, 0.10639549), target1);
	target1 = MulAdd(i1, MF4x4(0.003941457, 0.096958525, 0.08078122, -0.123746514, 0.05798335, -0.044676617, -0.3084394, 0.1140151, 0.010672668, -0.025900228, -0.06911797, 0.05360162, 0.15696998, 0.07253946, 0.06035546, 0.1159507), target1);
	target1 = MulAdd(a2, MF4x4(0.229298, 0.064096935, 0.16048844, 0.012671015, 0.024478769, 0.063737154, -0.004687863, 0.19364266, -0.19646022, 0.2893255, 0.026786007, 0.069286734, 0.07800188, -0.053994164, 0.052960467, 0.1745522), target1);
	target1 = MulAdd(b2, MF4x4(0.015469714, -0.12314818, 0.5338478, -0.11723986, -0.008365538, -0.10995339, -0.15134127, -0.07830025, 0.07128518, 0.009086638, -0.116382964, -0.16219214, 0.026113646, 0.29649207, -0.33176404, 0.009099685), target1);
	target1 = MulAdd(c2, MF4x4(-0.09291687, 0.09429629, 0.47023576, 0.30382136, 0.022938905, -0.053612467, 0.03914971, 0.07205734, 0.11292842, -0.022005484, 0.17894705, -0.008363797, -0.1682453, 0.0409644, -0.017597, -0.14894786), target1);
	target1 = MulAdd(d2, MF4x4(-0.22093011, 0.050382294, -0.07031792, 0.1064123, 0.09168859, -0.054715537, 0.07824245, 0.0675236, -0.11675646, 0.12587738, 0.33370635, -0.14830373, -0.4392533, -0.23865284, 0.071248956, -0.026170105), target1);
	target1 = MulAdd(e2, MF4x4(-0.048300147, 0.08008235, 0.11813505, -0.09183442, -0.06377392, 0.14087953, 0.07831149, 0.044931732, -0.21497081, 0.026584432, 0.013495652, -0.14503439, 0.007470514, 0.14160597, -0.016141815, -0.31155616), target1);
	target1 = MulAdd(f2, MF4x4(-0.41951287, 0.24024096, 0.19465575, -0.041104067, 0.09810697, 0.14586213, 0.13903797, -0.053057924, -0.14113568, -0.09644958, -0.09866805, -0.07899498, -0.172797, -0.08095462, -0.13160881, -0.0089402525), target1);
	target1 = MulAdd(g2, MF4x4(-0.0807202, -0.37737992, -0.12689668, 0.079181, 0.01577318, -0.11053014, -0.12669973, 0.0071108835, -0.20729698, 0.046471246, -0.12194573, 0.2870874, -0.22770974, 0.09006065, 0.23021267, 0.3112802), target1);
	target1 = MulAdd(h2, MF4x4(-0.17971495, 0.036312122, -0.03444156, 0.041823655, -0.09082372, 0.08112007, 0.049061, -0.0055645844, 0.013843324, -0.01969895, -0.13960351, -0.047275152, -0.043000307, 0.27807096, 0.22880352, 0.106376074), target1);
	target1 = MulAdd(i2, MF4x4(-0.17075665, 0.006126272, -0.2546894, 0.11954845, -0.19607663, 0.048538323, -0.065129414, 0.014257998, 0.038192738, -0.037847996, -0.020429965, 0.025860488, 0.028515143, 0.06738391, 0.072110705, -0.033284377), target1);
	target1 = MulAdd(a3, MF4x4(0.044568866, 0.062475223, -0.0983384, 0.009866407, -0.35514477, -0.030211627, 0.22333166, 0.32969475, -0.109626986, -0.034606833, -0.0576798, -0.17654708, -0.08829175, -0.16896097, -0.1001105, -0.12807782), target1);
	target1 = MulAdd(b3, MF4x4(0.3260804, -0.13558061, 0.04645619, -0.07019992, -0.29856443, 0.053042114, 0.061772786, -0.13687392, -0.16278408, -0.034854803, -0.012278255, -0.098236114, -0.19714803, -0.1252398, 0.52471006, -0.00438923), target1);
	target1 = MulAdd(c3, MF4x4(-0.23780306, 0.0058732736, -0.14263488, 0.014209727, 0.3014817, -0.19334342, 0.14975117, -0.4833427, 0.06679691, -0.068613395, -0.11530229, -0.27387938, 0.060538717, 0.2566434, 0.089476675, 0.20292005), target1);
	target1 = MulAdd(d3, MF4x4(-0.08988664, 0.09974201, -0.06231258, -0.14937639, 0.3109973, -0.062920496, 0.38651597, 0.32825765, -0.019837346, 0.1774624, 0.0721711, 0.01380091, 0.33275485, -0.024928985, -0.07132799, -0.10537747), target1);
	target1 = MulAdd(e3, MF4x4(-0.09355771, -0.018917486, 0.062002532, -0.06821075, 0.0852235, -0.043880213, 0.023216404, -0.034589138, 0.009775594, 0.020386059, -0.19563444, 0.34160665, -0.19108588, -0.36282206, 0.12477205, -0.1635429), target1);
	target1 = MulAdd(f3, MF4x4(0.0660281, -0.004066676, 0.051605884, -0.20489341, 0.45396295, 0.048399396, 0.32993752, 0.5071012, 0.1316449, -0.028571565, -0.1418205, -0.06860564, 0.00832686, 0.10344168, -0.0033388403, -0.21189667), target1);
	target1 = MulAdd(g3, MF4x4(0.03121781, 0.06918902, 0.0073941397, -0.039547186, -0.13978334, 0.36066145, 0.105322905, 0.048246022, -0.064950965, 0.04503515, 0.13340174, -0.30344757, 0.08683505, -0.046188712, -0.17417784, 0.09081479), target1);
	target1 = MulAdd(h3, MF4x4(-0.16948071, 0.0040395157, 0.035707664, -0.079912804, 0.038716394, -0.17475441, -0.36299637, 0.03968082, 0.049196135, -0.1715365, -0.071639955, -0.016410451, 0.09188755, -0.2558949, -0.16094652, 0.07996079), target1);
	target1 = MulAdd(i3, MF4x4(-0.21382907, 0.05636966, -0.06199946, -0.21989174, -0.18922164, 0.37826148, -0.0141571835, 0.024448203, 0.0884536, 0.12374937, 0.18420288, 0.0967765, -0.06720011, 0.069881, -0.0042892518, -0.19172947), target1);
	target1 = MulAdd(na1, MF4x4(-0.08187655, -0.489484, -0.27973574, -0.009521738, 0.18314825, -0.35783502, 0.056075446, 0.1687472, 0.3308614, -0.23036483, 0.0055736783, 0.18089417, -0.01648603, -0.21509576, -0.05315817, 0.2311331), target1);
	target1 = MulAdd(nb1, MF4x4(0.10545252, -0.16682841, 0.46201918, 0.41049242, 0.2867931, -0.10737721, 0.37278366, -0.15247364, 0.32457805, -0.13211884, 0.0282094, 0.32339963, -0.20642634, -0.07769656, -0.11572602, -0.0078001227), target1);
	target1 = MulAdd(nc1, MF4x4(0.049419798, -0.16918461, -0.07071865, -0.23344457, -0.06583399, 0.21428098, 0.13742666, -0.24406539, -0.3166922, 0.04145341, 0.12750438, 0.7016666, -0.072237894, 0.060902767, 0.024233112, 0.1978945), target1);
	target1 = MulAdd(nd1, MF4x4(0.21362431, -0.22586554, -0.13855393, 0.03641023, -0.18417473, 0.13428141, 0.019632103, 0.18459935, -0.25052726, -0.06585735, 0.06470142, -0.1343166, -0.1102426, 0.12908545, -0.03501417, -0.2672359), target1);
	target1 = MulAdd(ne1, MF4x4(0.098094426, -0.40027153, 0.05030102, 0.29116127, -0.07573088, -0.0358284, -0.2436342, 0.00352126, -0.114547156, -0.013960078, -0.20433213, -0.021052646, -0.22285037, 0.028262915, 0.08860262, -0.30081618), target1);
	target1 = MulAdd(nf1, MF4x4(-0.01646094, 0.24261765, 0.33677813, -0.060467284, -0.19734232, 0.1702455, -0.1304959, -0.20504838, -0.3379331, 0.26765183, -0.26516193, 0.27015924, -0.08003835, 0.3141519, 0.29280853, -0.052082997), target1);
	target1 = MulAdd(ng1, MF4x4(0.12277012, -0.46426025, 0.015877785, 0.028895028, -0.12974375, -0.075910136, 0.300476, 0.16338159, -0.012315035, 0.05539739, 0.019287715, -0.2627638, -0.10653122, 0.15327309, 0.116874225, 0.17951632), target1);
	target1 = MulAdd(nh1, MF4x4(0.29410085, -0.17102611, 0.035222203, 0.538198, -0.082762614, -0.13113698, 0.23784018, 0.10809719, 0.10368062, -0.26618072, 0.017677844, -0.5524849, 0.20205925, -0.25295278, -0.08522028, -0.35101673), target1);
	target1 = MulAdd(ni1, MF4x4(-0.24038099, 0.047679562, 0.16125403, 0.12115515, 0.25935376, -0.12338007, 0.28222737, -0.1517331, 0.102381065, 0.02018978, 0.103473715, 0.008457937, 0.075750284, 0.030453209, 0.103425525, -0.11869024), target1);
	target1 = MulAdd(na2, MF4x4(0.027691573, 0.033041246, -0.053919036, 0.021841308, 0.22477351, -0.012002719, -0.088659704, -0.19888699, -0.14622316, 0.07693778, 0.06058014, 0.072771885, -0.09090909, -0.009634639, -0.04093643, -0.0016425458), target1);
	target1 = MulAdd(nb2, MF4x4(0.121816635, 0.06796998, -0.00956044, 0.060272712, 0.0929867, -0.104182824, 0.068678245, -0.0025653015, 0.29900813, -0.121311836, -0.18685773, 0.047214147, -0.002424332, -0.071621366, 0.09782575, 0.069204815), target1);
	target1 = MulAdd(nc2, MF4x4(-0.115039505, -0.013585092, -0.062492177, 0.019942736, -0.22608118, 0.10974841, 0.121345155, 0.048270512, 0.036711007, -0.1555631, 0.3113601, 0.20424883, 0.036948208, 0.023162413, 0.093668364, 0.091156565), target1);
	target1 = MulAdd(nd2, MF4x4(-0.0239057, -0.0074546733, -0.072916195, -0.15032186, 0.11206848, 0.076949894, -0.0719725, 0.057246305, -0.12505415, 0.17029393, 0.059913885, 0.10695817, 0.11587671, 0.009000426, -0.0065819114, 0.112660386), target1);
	target1 = MulAdd(ne2, MF4x4(-0.22613746, 0.010249483, 0.31479695, -0.15589239, 0.21750645, -0.16260515, 0.03900687, 0.31478724, 0.24153055, -0.13562167, -0.13101026, -0.30842167, -0.09156883, -0.08611807, 0.0021150038, 0.19845119), target1);
	target1 = MulAdd(nf2, MF4x4(-0.09328654, 0.065565474, 0.053929932, -0.0614148, 0.10553007, -0.16130202, -0.14184211, -0.0015263067, -0.015361093, -0.20926285, -0.23366193, -0.06125057, -0.071300104, 0.01055638, -0.05240934, 0.06743602), target1);
	target1 = MulAdd(ng2, MF4x4(-0.05055375, 0.085141584, -0.025911124, -0.035443313, -0.1763071, 0.085818924, 0.19284901, -0.006149421, -0.0160643, 0.11941451, 0.20142859, -0.047862962, 0.049561072, 0.06118226, -0.117986836, -0.10885573), target1);
	target1 = MulAdd(nh2, MF4x4(0.0026763107, -0.13232177, 0.040220898, 0.056682535, -0.03708343, 0.22508788, 0.14923818, -0.106249794, 0.035745993, -0.18804651, -0.3110593, -0.20087922, -0.14625967, -0.0653864, -0.061015815, -0.04066649), target1);
	target1 = MulAdd(ni2, MF4x4(0.111738384, -0.104334466, 0.029024106, -0.09726162, 0.2414019, -0.029426873, 0.09094325, 0.027416501, 0.30706093, -0.09682458, -0.19449362, -0.014534671, 0.15952238, -0.033171862, -0.10819316, -0.10238822), target1);
	target1 = MulAdd(na3, MF4x4(0.56843907, -0.18652008, -0.07477079, -0.09572682, 0.004717268, -0.19569749, 0.012557746, -0.16934179, 0.20934415, -0.13695319, -0.085793145, 0.16430594, 0.1280811, -0.035566512, 0.17796053, 0.034620196), target1);
	target1 = MulAdd(nb3, MF4x4(0.10944063, 0.056659624, -0.10928797, -0.48222318, -0.03679725, 0.12002146, 0.06371042, -0.024989901, -0.19508527, 0.35469803, -0.034514666, 0.05471589, -0.008078808, 0.086663045, -0.06641959, 0.14787014), target1);
	target1 = MulAdd(nc3, MF4x4(-0.08401734, 0.065710895, -0.03586741, -0.09523177, -0.11976769, -0.00039887297, -0.11169928, 0.11623861, 0.06338808, 0.1087186, 0.26752025, 0.27731213, 0.042043414, -0.040737793, -0.13757998, 0.03160253), target1);
	target1 = MulAdd(nd3, MF4x4(0.03308292, 0.11817877, 0.04941428, 0.053257942, 0.20836346, -0.3157687, -0.15115938, 0.017689008, -0.08777182, 0.075874984, -0.11381275, 0.15768103, -0.25251803, 0.024785532, -0.1119765, -0.08488973), target1);
	target1 = MulAdd(ne3, MF4x4(0.14967972, 0.08358996, -0.12477746, 0.18376626, -0.11429529, 0.18852599, 0.12402519, 0.13575697, -0.17223327, -0.18583423, 0.08749376, 0.14127673, 0.04728666, 0.13141015, -0.1578823, 0.064156786), target1);
	target1 = MulAdd(nf3, MF4x4(-0.18258065, 0.05539021, -0.08642571, 0.22043483, -0.03830304, 0.10055482, -0.050123304, 0.12830205, -0.4921733, 0.2718683, 0.11772524, -0.07781355, -0.0075595984, 0.060227167, 0.1285977, 0.2978205), target1);
	target1 = MulAdd(ng3, MF4x4(0.19988084, -0.36680242, -0.0095746415, 0.091812566, 0.3152317, -0.075949475, -0.04308324, 0.049759876, 0.02971871, 0.18617181, 0.19829167, 0.17954859, 0.015149219, -0.15809381, 0.10850363, 0.017803097), target1);
	target1 = MulAdd(nh3, MF4x4(0.056506306, 0.15181234, -0.1497428, 0.01186181, 0.02351036, 0.01086669, -0.031891935, 0.01414558, 0.27038968, -0.2806401, -0.14722337, 0.080689445, 0.07039954, -0.054969363, -0.016640754, 0.020795437), target1);
	target1 = MulAdd(ni3, MF4x4(-0.237999, 0.13528651, 0.005025065, -0.01291728, -0.22655746, 0.022678101, 0.07165532, 0.0073296893, 0.084639646, -0.06724732, -0.13105223, 0.10164715, -0.15071161, 0.08882156, -0.016988168, -0.013606533), target1);
	
	MF4 target2 = { 0.15939143, -0.031111173, 0.011407361, 0.04436536 };
	target2 = MulAdd(a1, MF4x4(0.1606533, 0.1120602, 0.427334, -0.056228757, -0.026887462, 0.0858575, 0.0052684247, 0.1645524, 0.021588106, -0.08577256, -0.03301297, -0.087385215, 0.17341405, 0.26737398, 0.04566977, 0.047820427), target2);
	target2 = MulAdd(b1, MF4x4(0.21000437, 0.05300574, 0.060565695, -0.086724475, 0.09684198, 0.12685667, -0.10724282, -0.11021523, 0.048485592, -0.0054517, 0.081800036, -0.099787444, -0.12168391, 0.07623567, 0.09177046, 0.15815327), target2);
	target2 = MulAdd(c1, MF4x4(0.14400747, 0.13797458, 0.11044521, 0.077145234, 0.14364728, 0.10041894, 0.0948857, 0.08613703, 0.030833652, 0.102926254, 0.029892365, -0.09385337, 0.07609406, -0.038274735, 0.22529188, -0.0905732), target2);
	target2 = MulAdd(d1, MF4x4(-0.13334684, -0.083001845, -0.06109816, 0.067442395, 9.6367134e-05, -0.10395697, 0.047389086, 0.07404194, -0.11931296, -0.029852618, -0.08998846, 0.16543494, 0.19911745, -0.014106389, -0.020616226, 0.011981892), target2);
	target2 = MulAdd(e1, MF4x4(-0.20999044, 0.20443644, -0.08602043, -0.06026268, 0.0016786976, -0.15406793, 0.25403517, 0.0038395252, -0.16244787, -0.19482566, -0.113314606, 0.007111468, -0.026472634, 0.08177431, 0.13382603, -0.01771927), target2);
	target2 = MulAdd(f1, MF4x4(-0.14934808, -0.022533301, -0.14221415, -0.096389346, 0.11613694, 0.21117163, 0.22294325, -0.029256172, -0.072161585, -0.09670809, -0.24253419, 0.10479088, 0.20190297, -0.08443066, 0.08334989, 0.2928627), target2);
	target2 = MulAdd(g1, MF4x4(0.030550636, 0.095876954, -0.040062953, 0.024307664, 0.17360783, -0.035755854, -0.20959523, 0.069054864, -0.1061238, -0.26194566, 0.2781827, -0.118610375, -0.09682604, -0.076366246, -0.05720086, -0.08075027), target2);
	target2 = MulAdd(h1, MF4x4(0.15727855, 0.21407695, 0.009924877, -0.0027381582, 0.16699612, 0.017624786, -0.13224785, 0.008606034, -0.05968717, -0.009152095, -0.084314294, -0.14502133, -0.13212982, 0.2531764, -0.09840475, 0.020581203), target2);
	target2 = MulAdd(i1, MF4x4(0.06285324, 0.019129366, 0.15062185, -0.0018203754, 0.025869751, 0.09390758, 0.027623225, 0.09279268, 0.12548098, -0.05622771, 0.024048142, -0.011120709, 0.039858714, 0.022324169, -0.061184626, 0.15133153), target2);
	target2 = MulAdd(a2, MF4x4(0.25750592, -0.0633985, 0.05274334, 0.05652166, -0.13369319, -0.19132645, -0.11266925, 0.05310033, -0.10603932, -0.18876615, -0.23720984, 0.23625968, -0.1460642, -0.16662763, -0.31894067, 0.00010953036), target2);
	target2 = MulAdd(b2, MF4x4(0.021643812, 0.27677965, -0.18880053, -0.085671276, -0.12699273, 0.07259516, -0.09705578, 0.0103639, -0.10424065, 0.2421007, -0.15788709, -0.03597044, -0.03210864, -0.009501378, -0.29830885, 0.18951061), target2);
	target2 = MulAdd(c2, MF4x4(-0.023235895, -0.15663858, -0.097848825, -0.030312262, -0.36207277, -0.044624195, -0.24912846, 0.001322196, -0.012719531, -0.061012562, 0.02297421, -0.083919466, 0.023231668, 0.17829593, -0.20094186, 0.062941045), target2);
	target2 = MulAdd(d2, MF4x4(0.031992577, -0.33281925, 0.24781865, 0.10445937, -0.043928526, -0.0048965504, 0.025098981, -0.02432072, -0.06936203, 0.06697805, -0.03503784, 0.04098378, 0.11242077, -0.47939962, -0.36156863, 0.10633177), target2);
	target2 = MulAdd(e2, MF4x4(-0.360187, 0.15471298, 0.19546136, -0.19344117, 0.19245885, 0.10948706, -0.25480017, -0.117233664, 0.07698171, 0.00455522, 0.016817722, -0.21183428, -0.3989548, -0.0053129625, 0.32735184, -0.25722015), target2);
	target2 = MulAdd(f2, MF4x4(-0.19386199, -0.104854785, 0.2354883, 0.07680881, -0.08103157, 0.19879752, -0.20958872, 0.03404414, 0.2462412, -0.025986584, 0.15228593, 0.082260065, 0.05948899, 0.018289726, 0.26004076, 0.29258958), target2);
	target2 = MulAdd(g2, MF4x4(0.43535206, -0.1665342, -0.078847095, -0.09834152, 0.3344753, 0.14931677, 0.26555872, -0.050443217, 0.1165338, -0.018918963, -0.18268648, -0.08987844, -0.15032545, -0.41353035, 0.04693913, 0.12682211), target2);
	target2 = MulAdd(h2, MF4x4(-0.101665966, -0.2346043, -0.13883743, 0.09837179, 0.11640853, -0.11128404, 0.1264696, 0.13364471, -0.0010915099, 0.32518107, 0.015125061, 0.0014352624, -0.32198808, 0.14844672, 0.045113582, 0.22434932), target2);
	target2 = MulAdd(i2, MF4x4(0.04287463, -0.031287823, 0.07444511, 0.215022, -0.051081534, 0.09054911, 0.094913155, -0.16440862, 0.025819149, -0.035652477, 0.11303366, 0.072897494, 0.15771803, -0.026064822, -0.27329972, 0.3400305), target2);
	target2 = MulAdd(a3, MF4x4(0.15108323, 0.099104606, -0.18490814, 0.282546, -0.39287362, 0.020549994, 0.03981046, -0.38331905, -0.028022572, 0.07132567, 0.054721024, -0.0544467, 0.30145043, 0.07482834, -0.030623315, -0.14339122), target2);
	target2 = MulAdd(b3, MF4x4(-0.19015107, 0.084599644, -0.08060123, -0.13798787, 0.11629986, 0.1486292, 0.22505176, 0.120357476, 0.09555313, -0.012545042, 0.14008446, 0.09553097, -0.13701685, 0.13754234, 0.08133829, 0.0583218), target2);
	target2 = MulAdd(c3, MF4x4(-0.011506865, -0.12886223, 0.32145864, -0.0046038935, -0.15737815, 0.31331423, 0.014334723, 0.13329573, 0.059868217, 0.044668417, 0.41486976, -0.115652, 0.07570654, 0.119870186, -0.04211968, 0.13550858), target2);
	target2 = MulAdd(d3, MF4x4(-0.06290216, -0.09683136, 0.17791402, -0.06173693, -0.5663153, 0.6814847, -0.30665252, -0.015765276, -0.35518414, 0.014619069, 0.0059011583, -0.011811011, -0.12891632, -0.09697547, 0.0122915255, -0.035630453), target2);
	target2 = MulAdd(e3, MF4x4(0.36552843, -0.02239533, 0.31511658, 0.07742532, 0.38120705, -0.34059232, -0.1941228, -0.009505623, -0.057844408, -0.08539643, -0.15442915, 0.047755927, -0.10766272, 0.19164445, -0.04577609, -0.02152571), target2);
	target2 = MulAdd(f3, MF4x4(0.25128686, 0.008428173, -0.2337189, -0.07352831, 0.4192482, 0.03234093, -0.107415706, -0.59545743, 0.08484682, 0.10139428, 0.032704517, -0.03676146, 0.0709341, -0.08012427, -0.17445756, -0.051028527), target2);
	target2 = MulAdd(g3, MF4x4(-0.13946229, 0.14634825, -0.29945642, 0.054991852, -0.19391525, 0.18525685, -0.01332443, 0.19226684, -0.25809357, -0.16726302, -0.08535996, 0.04962988, -0.21382174, -0.27475968, 0.14896728, -0.07398321), target2);
	target2 = MulAdd(h3, MF4x4(0.012350131, -0.15466039, 0.2637539, -0.004446026, -0.23348337, 0.31829268, 0.30077904, -0.26715708, -0.2248632, 0.026697354, -0.13744812, -0.11420962, 0.12333178, 0.20206316, 0.14819679, 0.11332464), target2);
	target2 = MulAdd(i3, MF4x4(-0.1398207, -0.08409686, 0.28911248, -0.17092308, -0.3288522, -0.33649427, 0.08738124, 0.07093669, 0.042545132, 0.056477334, -0.043472584, 0.11007758, -0.001716612, -0.10464193, 0.03468551, 0.18904419), target2);
	target2 = MulAdd(na1, MF4x4(-0.22511648, -0.21305616, -0.20453261, -0.039165854, 0.12624744, -0.24751776, -0.071244866, -0.013594594, 0.050315578, -0.07449747, -0.2612381, 0.16027644, -0.16809192, -0.124898806, -0.038302764, -0.17824896), target2);
	target2 = MulAdd(nb1, MF4x4(-0.011263025, -0.13628832, -0.018516185, -0.02475848, 0.09929525, 0.039110962, -0.12850322, -0.1350285, -0.35264796, -0.021238754, -0.11728184, -0.1417785, 0.2576594, 0.08627893, 0.11525315, -0.12663105), target2);
	target2 = MulAdd(nc1, MF4x4(0.098808385, 0.11969382, -0.09717777, 0.15366855, 0.05112679, -0.0064458046, 0.17321971, -0.11823168, -0.010137996, -0.35834765, 0.22273073, 0.20014246, -0.077788174, -0.10495039, -0.17693104, -0.069975644), target2);
	target2 = MulAdd(nd1, MF4x4(0.058652826, -0.12872136, 0.3963312, -0.15295003, -0.05818842, -0.4533677, 0.20178635, 0.24527496, 0.25999078, -0.37886587, 0.19364087, 0.18344274, 0.22268198, -0.14165895, 0.48145312, -0.23087662), target2);
	target2 = MulAdd(ne1, MF4x4(0.11743857, -0.081544854, -0.19755375, -0.12016749, -0.28253412, -0.04377212, 0.15896732, -0.14978753, -0.25513977, 0.0025451197, 0.41349715, -0.28266567, -0.25201386, 0.54169023, 0.21759638, 0.09750061), target2);
	target2 = MulAdd(nf1, MF4x4(0.2587435, 0.18573955, -0.23956883, 0.021557074, 0.020746572, 0.020505207, 0.08808335, 0.19680786, -0.061584104, -0.24666953, 0.054818455, 0.10405006, -0.24831708, -0.13658181, -0.0833388, 0.24120714), target2);
	target2 = MulAdd(ng1, MF4x4(-0.29441085, 0.03656414, -0.2596772, -0.057041578, 0.1569663, -0.09881767, 0.08505022, -0.01768552, -0.051293768, -0.099874936, -0.05937486, -0.06985686, 0.055836957, 0.12361765, 0.00034758533, -0.16590339), target2);
	target2 = MulAdd(nh1, MF4x4(0.08935089, -0.34096143, -0.06724781, 0.057755265, -0.07378229, 0.19852296, -0.101910785, -0.35927492, -0.27025247, 0.077470385, -0.26122475, 0.1062427, 0.34269986, 0.022384735, -0.19875982, -0.046883546), target2);
	target2 = MulAdd(ni1, MF4x4(-0.023113059, 0.023807336, 0.04232145, 0.12731242, 0.079464786, 0.10940335, -0.1920892, 0.069054574, -0.046453483, -0.1463778, 0.050447907, 0.37861434, 0.19577271, -0.08457038, 0.055992957, 0.0051751668), target2);
	target2 = MulAdd(na2, MF4x4(-0.0143063385, -0.031832237, -0.081230044, 0.15558316, 0.24739249, 0.06730676, 0.022930989, -0.060339663, 0.16502666, 0.0032860334, 0.13078189, -0.13917513, 0.083792515, 0.038169254, 0.26199514, -0.20886219), target2);
	target2 = MulAdd(nb2, MF4x4(-0.07898116, -0.001202372, -0.1436358, -0.013730994, -0.011920493, 0.067917384, -0.032699063, -0.04563186, 0.16329978, 0.13089089, -0.29516026, -0.17357638, 0.02513132, -0.14417541, -0.0026529275, 0.028195161), target2);
	target2 = MulAdd(nc2, MF4x4(0.1278416, -0.0652329, -0.080299005, -0.054219954, 0.15680717, -0.13077177, 0.25564823, 0.10533668, -0.10988264, 0.3860151, -0.18009946, -0.47674116, -0.10072908, 0.041740764, 0.1123633, -0.04076864), target2);
	target2 = MulAdd(nd2, MF4x4(0.20640877, -0.24586456, -0.10259232, 0.111054115, -0.18076079, -0.22535121, -0.29812837, 0.12035098, 0.027053986, -0.10918923, -0.3172506, 0.11992493, -0.006251823, 0.2550944, -0.15903941, -0.12368186), target2);
	target2 = MulAdd(ne2, MF4x4(-0.36056486, 0.25076455, 0.13362978, -0.033405777, -0.32817405, 0.0695707, 0.01829935, -0.08318219, -0.28797764, 0.16128948, 0.14374499, -0.025840933, 0.078341916, 0.13052103, -0.100241534, 0.10946945), target2);
	target2 = MulAdd(nf2, MF4x4(-0.07073338, -0.112097755, 0.22497103, 0.13549447, -0.13218129, -0.22181363, -0.13737568, 0.06865537, -0.45603344, -0.35373682, 0.37757057, 0.1678293, -0.029289875, -0.13187636, 0.12758663, 0.04016698), target2);
	target2 = MulAdd(ng2, MF4x4(0.040351316, -0.05093577, -0.08653635, -0.007213745, -0.3845516, -0.029778607, -0.47889423, 0.12643112, -0.11173547, 0.043787614, 0.2647412, -0.0109354155, -0.0064909635, 0.106970474, 0.11885388, 0.07061224), target2);
	target2 = MulAdd(nh2, MF4x4(0.066118404, 0.1848857, -0.07987121, -0.044921577, -0.0753153, -0.060784195, -0.33154643, 0.116313264, 0.11995535, -0.071781196, -0.24509782, -0.0037734907, 0.037864428, -0.07115049, 0.10189698, 0.13620937), target2);
	target2 = MulAdd(ni2, MF4x4(0.15173467, 0.117787406, -0.07836817, -0.06667758, -0.05646272, 0.33135724, -0.37163886, -0.315246, 0.22709703, 0.10267156, -0.07729526, -0.015280573, -0.015122008, 0.03244177, 0.17766209, -0.04914632), target2);
	target2 = MulAdd(na3, MF4x4(-0.07482478, -0.13012838, -0.15759332, 0.015014935, 0.35088012, 0.007073843, 0.24014178, -0.14308095, 0.12774545, 0.18122073, -0.2547015, 0.13359042, -0.0800425, 0.14722595, -0.24495813, -0.013143742), target2);
	target2 = MulAdd(nb3, MF4x4(-0.15018739, 0.075401075, -0.056287423, -0.21596402, -0.106415406, -0.09301949, 0.124646366, -0.07675658, 0.39950943, -0.36134976, -0.20888598, 0.11607109, 0.107587025, -0.1626161, -0.29592493, 0.01726878), target2);
	target2 = MulAdd(nc3, MF4x4(0.042367462, 0.05787438, -0.091712154, 0.26943466, 0.018607875, -0.06306163, -0.044719845, 0.12169627, -0.0043602907, -0.11714036, -0.41751066, -0.11060246, 0.14270274, 0.105742574, 0.162418, -0.016003838), target2);
	target2 = MulAdd(nd3, MF4x4(-0.059574872, -0.16347532, 0.24761298, 0.0098720435, 0.22380106, -0.06946215, -0.011973621, -0.09775447, -0.108043805, -0.18910232, 0.36019576, -0.21156572, 0.008830671, -0.05479997, 0.31133842, 0.037727185), target2);
	target2 = MulAdd(ne3, MF4x4(-0.1920284, 0.17142658, 0.05467186, -0.0761654, -0.25932217, -0.16042638, 0.2197324, 0.12581502, -0.48400918, 0.5538232, 0.41044307, -0.17291741, -0.18633147, -0.0820574, 0.038112838, -0.18555504), target2);
	target2 = MulAdd(nf3, MF4x4(0.13163397, 0.09845959, -0.21711256, 0.26999414, -0.053519428, -0.029779429, -0.15492497, 0.0993045, -0.16189748, -0.4925058, 0.034618095, 0.085681, 0.16100337, 0.078292616, -0.40945208, -0.15787469), target2);
	target2 = MulAdd(ng3, MF4x4(0.20844188, 0.07127721, 0.032387372, 0.033018872, 0.15301323, -0.055671003, 0.25810188, -0.07723897, 0.17080788, 0.12247039, -0.16662452, -0.06526193, 0.1584067, 0.14825343, 0.16793022, -0.055639073), target2);
	target2 = MulAdd(nh3, MF4x4(0.31691772, 0.03877285, -0.31999993, 0.15607259, -0.014967208, 0.17467377, -0.021213053, 0.05274054, 0.09042282, 0.3026185, -0.19465268, -0.15643322, -0.28652924, -0.12624627, -0.123150274, -0.06579748), target2);
	target2 = MulAdd(ni3, MF4x4(-0.12737115, 0.21119869, 0.021830728, 0.25310937, 0.056086678, -0.10591854, -0.09623413, 0.09552772, 0.0077543957, -0.38552082, 0.105930105, 0.21966095, 0.03846968, -0.18900576, 0.13454477, 0.01323755), target2);

	MF4 target3 = { -0.09157235, -0.025660357, 0.076311104, -0.13737188 };
	target3 = MulAdd(a1, MF4x4(0.009852172, 0.067582026, -0.004946671, 0.10223505, -0.10428496, -0.025925757, -0.1812229, -0.086897664, -0.007505929, 0.11395492, -0.046959464, -0.040778246, -0.05989385, 0.2917696, 0.21723987, 0.104860075), target3);
	target3 = MulAdd(b1, MF4x4(0.014223285, 0.23677638, 0.18793987, 0.1604355, -0.13773453, -0.035079855, 0.1325962, -0.01843488, 0.013658427, -0.039640892, -0.049931083, -0.17938142, -0.20694439, 0.13461684, 0.15713528, 0.061465815), target3);
	target3 = MulAdd(c1, MF4x4(-0.045403525, 0.24799547, 0.073604435, 0.21103963, 0.18720928, -0.06703258, -0.20043622, -0.067137614, -0.19021615, -0.020830747, -0.120527774, 0.20456503, 0.07813807, -0.03798654, 0.04036844, -0.0033802337), target3);
	target3 = MulAdd(d1, MF4x4(0.10385739, -0.06095687, 0.03991638, -0.119761765, 0.14859357, -0.2436967, -0.033547442, 0.06643773, 0.08074919, 0.00819047, 0.046388235, 0.113080844, 0.093403086, -0.25158677, -0.25340363, 0.043133873), target3);
	target3 = MulAdd(e1, MF4x4(0.13219471, -0.01887069, -0.26465404, 0.012883369, -0.15132889, -0.08190286, 0.1886762, -0.121109776, -0.086888224, -0.13945712, 0.10484367, -0.014462356, -0.04274967, -0.27132213, 0.035799675, 0.18913607), target3);
	target3 = MulAdd(f1, MF4x4(-0.09799585, -0.092021905, 0.042374767, -0.040835217, 0.2207681, 0.19816661, 0.2233777, -0.09462879, 0.174727, 0.067035824, 0.25794062, 0.03356712, 0.09257895, 0.03864686, 0.061125953, -0.10119902), target3);
	target3 = MulAdd(g1, MF4x4(-0.06601051, 0.011512823, -0.13370325, 0.0033915695, 0.0060606156, -0.049539644, -0.1075017, -0.17912976, -0.042368136, -0.011520146, 0.06601078, 0.09978972, -0.0129192965, -0.21929637, -0.018458387, -0.010336992), target3);
	target3 = MulAdd(h1, MF4x4(0.09475364, -0.005993277, 0.09861265, -0.03103845, -0.09583529, 0.058791347, 0.3326168, -0.11607132, -0.028693356, 0.11996273, -0.085005276, -0.029005809, -0.29191923, 0.06689837, 0.10442381, -0.024532465), target3);
	target3 = MulAdd(i1, MF4x4(0.0053415983, 0.06602273, 0.2246564, 0.031501666, -0.14868876, -0.0093808025, -0.34579018, -0.030635692, 0.092459954, -0.039631926, -0.0085174255, 0.022645477, 0.07514861, 0.060552113, 0.06597399, 0.0397574), target3);
	target3 = MulAdd(a2, MF4x4(0.0511157, 0.035152495, -0.19926861, -0.063245155, 0.13407591, -0.1288526, 0.23185496, -0.13392815, -0.09297701, -0.2809779, 0.07520502, 0.022971572, -0.08222417, 0.27030075, -0.10483476, 0.16590133), target3);
	target3 = MulAdd(b2, MF4x4(-0.30276665, 0.17359875, -0.06072175, -0.036741048, 0.12927541, -0.11135696, -0.1655047, -0.05786224, -0.10111195, 0.03949635, -0.11618777, -0.0020339678, -0.16504388, 0.21188384, -0.24663985, -0.16005285), target3);
	target3 = MulAdd(c2, MF4x4(-0.18182081, -0.05039593, -0.004631986, -0.03583777, 0.025373073, -0.33103603, -0.12213051, -0.10148533, -0.091509394, -0.13529696, 0.08307632, -0.0025659746, -0.5024331, 0.14926323, 0.05118105, -0.26585025), target3);
	target3 = MulAdd(d2, MF4x4(0.17135173, -0.23068328, 0.16332187, 0.06196188, 0.0034444374, 0.044823382, 0.010302396, 0.06775431, 0.024591392, -0.054694094, -0.048208185, -0.055681854, 0.08873465, -0.14074552, -0.027211398, 0.23973261), target3);
	target3 = MulAdd(e2, MF4x4(-0.12319059, -0.11429906, -0.36435902, 0.19346023, -0.030743172, 0.383669, 0.009289978, 0.0010576686, 0.17045438, -0.007082544, 0.16374406, 0.32419837, 0.15915118, -0.1356684, -0.13062716, -0.15574396), target3);
	target3 = MulAdd(f2, MF4x4(-0.19135374, -0.2005694, -0.0020886995, 0.01221146, -0.40867472, -0.081229836, -0.16124476, 0.08071337, 0.09998693, -0.061099563, 0.13301264, -0.043883327, 0.11045742, -0.2383618, 0.18627192, -0.35225677), target3);
	target3 = MulAdd(g2, MF4x4(0.37673324, 0.34416032, -0.103333436, 0.13149537, 0.006451586, 0.094312094, 0.08832807, 0.09592083, -0.116452016, 0.1066464, -0.115603626, -0.13193515, -0.13174447, -0.18561727, 0.13020653, -0.13364927), target3);
	target3 = MulAdd(h2, MF4x4(-0.1834991, 0.11584597, -0.04156077, -0.12755936, 0.09659385, 0.08903952, 0.31892854, -0.01448324, -0.008864266, -0.039691996, -0.08322731, 0.095220886, -0.090739064, 0.092071235, -0.2817547, -0.29630283), target3);
	target3 = MulAdd(i2, MF4x4(-0.24098976, 0.101338394, -0.28956947, 0.07237588, -0.10666849, 0.13332452, -0.20815872, -0.00023775037, -0.04327956, 0.0029107686, -0.008416182, 0.097931474, -0.37501606, -0.018609088, -0.10432809, -0.034832), target3);
	target3 = MulAdd(a3, MF4x4(-0.08794669, 0.028736163, -0.17888173, -0.06455644, 0.23870508, -0.23358688, 0.072483465, -0.0085282335, -0.12771352, 0.0380899, -0.25210154, -0.010397481, -0.034966666, 0.08883341, -0.22751594, -0.18751557), target3);
	target3 = MulAdd(b3, MF4x4(-0.04474889, 0.098189436, -0.10426362, -0.35184658, 0.043526888, -0.36088315, 0.13278794, 0.39718434, 0.0091220355, 0.0041375947, 0.17093311, 0.21236257, -0.10007804, -0.020010212, 0.111889765, 0.17784196), target3);
	target3 = MulAdd(c3, MF4x4(0.1536085, -0.026586162, 0.12273445, -0.0801658, 0.20678692, -0.11288633, -0.21298888, 0.4272659, -0.027916932, 0.13641946, 0.08454202, 0.15072668, -0.36861306, 0.09071778, -0.23418477, 0.3515129), target3);
	target3 = MulAdd(d3, MF4x4(-0.035221044, -0.05102627, 0.09558761, -0.008040629, -0.028807933, 0.303477, -0.20610638, -0.044902515, -0.19755092, -0.030813612, -0.17718953, -0.17694841, 0.03633824, 0.13118435, 0.029816214, -0.25406656), target3);
	target3 = MulAdd(e3, MF4x4(-0.14495026, 0.12816216, 0.16447757, 0.031679, -0.044026595, 0.19292583, 0.33260253, 0.10592396, 0.035314452, 0.027002327, 0.06259657, 0.20517996, 0.47153056, 0.33924934, 0.20535454, -0.25056842), target3);
	target3 = MulAdd(f3, MF4x4(-0.18414135, 0.19427143, -0.081241705, -0.01675198, -0.006523895, -0.07718575, -0.09325943, -0.08737854, -0.028951872, -0.17328268, -0.08241532, -0.08835567, -0.21019256, 0.16430716, 0.06124939, 0.035649084), target3);
	target3 = MulAdd(g3, MF4x4(0.016590597, -0.0022054093, -0.1470956, -0.08206723, -0.10903706, 0.0064417794, -0.18528567, -0.34366733, -0.06885517, 0.16456494, -0.018355783, 0.17814603, -0.07158972, -0.28178605, -0.20745122, -0.099933885), target3);
	target3 = MulAdd(h3, MF4x4(0.0065370193, -0.3044895, 0.055263646, 0.075996794, 0.024025463, -0.20411102, -0.01592019, -0.18464315, -0.08999649, -0.048265222, -0.08978591, -0.09877855, 0.4285961, -0.32419163, -0.10149259, -0.112745434), target3);
	target3 = MulAdd(i3, MF4x4(0.06848249, -0.11997486, 0.05998702, -0.024274347, 0.31168294, -0.017959671, 0.34084293, -0.34249943, 0.11690563, -0.11239628, 0.2128415, 0.017396145, -0.14399542, -0.13887884, 0.041329246, -0.099762276), target3);
	target3 = MulAdd(na1, MF4x4(0.11233947, 0.22560616, -0.14853792, 0.0025890833, -0.09261338, 0.026878078, -0.13337374, 0.14549397, 0.105454646, 0.20769532, 0.086635984, 0.05085061, 0.16791524, -0.031017043, 0.043081395, 0.18300867), target3);
	target3 = MulAdd(nb1, MF4x4(0.21579266, -0.29286692, -0.05484676, 0.050306555, -0.1338697, 0.173389, -0.31768104, 0.051908243, 0.03826524, 0.48232502, 0.247302, 0.3487058, 0.28926015, 0.09935225, -0.18840632, 0.08882374), target3);
	target3 = MulAdd(nc1, MF4x4(-0.13517806, -0.40837446, -0.14227843, -0.27239424, -0.3059563, 0.063552625, 0.2631879, 0.56351787, 0.22826865, -0.065214194, 0.22837348, -0.4106273, -0.05822978, 0.13954113, 0.13192196, 0.031006072), target3);
	target3 = MulAdd(nd1, MF4x4(0.14163558, -0.13529845, 0.063847534, 0.066068165, 0.041967303, 0.21868911, 0.22319448, 0.00028246938, 0.07615932, -0.3879002, 0.039115347, -0.08572038, -0.24845092, 0.13100919, 0.253391, 0.22104543), target3);
	target3 = MulAdd(ne1, MF4x4(0.15111032, 0.18182786, 0.22756334, -0.008264583, -0.14041592, -0.5454497, -0.5890025, -0.010277932, 0.17194566, -0.14571565, -0.15525545, 0.17403725, 0.09960832, -0.016455285, -0.3584658, 0.3162123), target3);
	target3 = MulAdd(nf1, MF4x4(-0.21418694, 0.20062631, -0.0948598, -0.09684068, 0.13923916, -0.09331503, -0.0857385, 0.21380557, 0.020379147, 0.21428087, 0.07388917, 0.089147344, -0.20121545, -0.023731146, 0.3213483, 0.17458193), target3);
	target3 = MulAdd(ng1, MF4x4(0.10643249, -0.00972507, 0.022902627, 0.29897237, 0.3299111, 0.085025065, 0.21370107, 0.20150943, -0.30700487, -0.1884155, 0.2567519, 0.00021575678, -0.23836862, 0.35121775, 0.13285181, -0.08186422), target3);
	target3 = MulAdd(nh1, MF4x4(0.2257978, -0.044991307, -0.19195051, -0.067948796, -0.119921125, 0.0917341, -0.12133957, -0.0779332, -0.30272362, 0.29493997, -0.1241099, 0.57692826, -0.07721382, 0.23687507, -0.34731215, 0.25507957), target3);
	target3 = MulAdd(ni1, MF4x4(0.45565096, -0.15130155, -0.10940018, -0.44904032, -0.15766421, 0.20778829, 0.21851856, 0.1678922, -0.08152111, 0.1772852, -0.2632565, 0.20217079, -0.014408843, 0.021441357, 0.001290681, 0.036566503), target3);
	target3 = MulAdd(na2, MF4x4(-0.1125441, 0.019155068, 0.17547919, 0.010120996, -0.13596916, 0.06777857, -0.18246579, -0.07407904, 0.052627467, -0.12339828, 0.09181331, -0.039406203, 0.06598462, -0.20432016, 0.081749015, 0.016382169), target3);
	target3 = MulAdd(nb2, MF4x4(-0.036727224, 0.05656203, 0.03722875, -0.19623469, -0.12215404, 0.15154731, 0.14583679, 0.13441144, -0.053393483, 0.3686272, -0.55303735, -0.18231596, -0.077573985, -0.17017044, 0.007368884, 0.06776619), target3);
	target3 = MulAdd(nc2, MF4x4(-0.14654772, 0.0642838, 0.21146652, 0.1479552, 0.056684785, 0.08816999, 0.122986056, 0.025765898, 0.03539519, 0.2605786, 0.13069612, 0.2733717, 0.17476462, 0.04350784, -0.11019324, -0.085290305), target3);
	target3 = MulAdd(nd2, MF4x4(0.070716664, -0.034127012, -0.17524591, -0.01733187, -0.0786243, -0.27215844, 0.14767595, -0.028927185, -0.268044, 0.17461409, 0.18505631, -0.07551577, -0.17443672, 0.33642206, -0.10371784, -0.09501668), target3);
	target3 = MulAdd(ne2, MF4x4(0.41137508, 0.0039632237, -0.46695748, -0.14406478, -0.03359041, -0.26271477, -0.16481699, -0.23792827, -0.004218498, -0.082102485, -0.5725909, -0.19159988, -0.02892404, 0.018914402, 0.12181954, -0.045662787), target3);
	target3 = MulAdd(nf2, MF4x4(0.059361387, -0.06857852, 0.29324803, 0.018895477, 0.5373943, -0.27193475, 0.19632731, 0.07846825, 0.46329513, -0.2541983, 0.3154752, 0.034318704, 0.07056785, 0.09071147, 0.018257828, 0.051888023), target3);
	target3 = MulAdd(ng2, MF4x4(-0.01574486, 0.025618032, 0.013175459, -0.05611416, 0.1575709, -0.26184332, 0.14741376, -0.09205734, 0.15314968, -0.033463627, 0.27498275, -0.036637545, 0.07326095, -0.02758785, -0.008260478, -0.033497095), target3);
	target3 = MulAdd(nh2, MF4x4(-0.043722082, -0.0053890822, -0.006806792, 0.078156926, 0.28195116, -0.19398853, -0.08171706, -0.13839847, -0.2289849, 0.13469638, -0.3921867, -0.12275613, -0.07401059, -0.08434314, 0.080387615, -0.023079267), target3);
	target3 = MulAdd(ni2, MF4x4(-0.18200518, 0.15944996, -0.023199113, 0.03136635, 0.0124006495, -0.30606514, -0.008949306, -0.051349495, -0.039797418, 0.06404064, 0.089617595, 0.08849374, 0.07658024, 0.089631304, -0.021066017, 0.033190813), target3);
	target3 = MulAdd(na3, MF4x4(-0.00024305849, -0.005267714, -0.110663235, -0.1235196, 0.012671297, 0.09886661, 0.2275749, 0.060427323, -0.08923832, 0.06393884, 0.08300952, 0.1602908, 0.08163518, 0.2060279, 0.079629295, 0.09073638), target3);
	target3 = MulAdd(nb3, MF4x4(0.09152832, -0.13788883, -0.0003542848, -0.41267133, 0.06780486, 0.14365548, 0.093432106, -0.14731646, 0.06173505, -0.07698671, 0.13692452, 0.07682172, 0.019543113, -0.07077461, 0.018755287, -0.01956884), target3);
	target3 = MulAdd(nc3, MF4x4(-0.025053086, -0.25834808, 0.27484947, 0.0542093, 0.04252427, 0.11526509, -0.12203397, -0.11198108, -0.122830786, 0.01729993, -0.26451054, 0.08480724, 0.27700573, -0.108406745, 0.21402664, -0.19032313), target3);
	target3 = MulAdd(nd3, MF4x4(-0.01717388, -0.21526851, -0.100241624, -0.33087742, 0.059813473, 0.11764993, 0.046627797, 0.10824857, -0.033078045, -0.07022686, 0.05082029, -0.18696983, 0.06715326, -0.24360675, -0.028528497, 0.03166471), target3);
	target3 = MulAdd(ne3, MF4x4(0.18515922, -0.19291987, -0.18511395, -0.16356386, 0.10254811, -0.14086638, -0.05160376, -0.07413514, -0.17066383, -0.1579425, -0.102077566, -0.0865959, -0.06315448, -0.12120578, -0.24788655, 0.045280393), target3);
	target3 = MulAdd(nf3, MF4x4(-0.23578815, 0.17898968, -0.076395154, -0.068680935, -0.19281612, 0.0008040003, -0.13505532, -0.010227741, 0.35332572, 0.10865026, 0.14042157, -0.07081392, -0.16093336, 0.02813831, -0.1142879, 0.07591385), target3);
	target3 = MulAdd(ng3, MF4x4(-0.10260084, 0.25031334, 0.030233473, 0.18198064, 0.06648322, -0.06662831, 0.29892904, 0.10685262, -0.099214576, 0.20269664, 0.14236231, -0.26043925, 0.17721854, 0.105084695, 0.11604949, 0.07190215), target3);
	target3 = MulAdd(nh3, MF4x4(-0.006627316, -0.075635955, 0.37108654, -0.0919607, -0.12985592, 0.112184614, -0.16726716, -0.03870482, 0.01480095, 0.2044233, -0.051372997, 0.21520257, -0.08743421, 0.13153918, -0.15077852, 0.12159706), target3);
	target3 = MulAdd(ni3, MF4x4(0.009482551, 0.12501961, 0.38921976, -0.1280031, -0.103060484, -0.027821409, 0.0720024, -0.027280543, 0.056729473, 0.048927493, -0.035154913, -0.08341783, 0.23103711, 0.046025522, 0.17039533, -0.014161812), target3);
	
	MF3 result = tex7.SampleLevel(sam, pos, 0).rgb;
	result = MulAdd(e1, MF4x3(0.012708346, 0.014336439, 0.012533707, -0.0019346073, -0.0070978077, -0.009478742, -0.011659758, -0.009855903, -0.008657096, 0.0098037105, 0.010785594, 0.008409619), result);
	result = MulAdd(e2, MF4x3(0.0056228717, 0.013483413, 0.008108323, -0.0013697809, 0.0026797573, 0.0037666177, 0.0130932415, 0.019868238, 0.01968549, 0.011160769, 0.012374028, 0.012855804), result);
	result = MulAdd(e3, MF4x3(0.0011662204, 0.00025071716, 0.0022244148, -0.017808594, -0.013589306, -0.01396329, -0.008117086, -0.0068251803, -0.004963602, -0.0069141523, -0.009125296, -0.008327947), result);
	result = MulAdd(ne1, MF4x3(-0.027597412, -0.02631107, -0.022816146, 0.009350171, 0.013661565, 0.015324706, 0.032538984, 0.02918167, 0.026186563, 0.018760988, 0.024502547, 0.023201061), result);
	result = MulAdd(ne2, MF4x3(0.013216693, 0.00991115, 0.01178417, 0.0076343333, 0.004714098, 0.0074490295, -0.0064893183, -0.014818341, -0.01199717, -0.008334491, -0.009955103, -0.011240684), result);
	result = MulAdd(ne3, MF4x3(-0.013846397, -0.012687341, -0.015767701, -0.0019117722, -0.0072347773, -0.0074835457, 0.013531867, 0.014263165, 0.012797156, 0.008260445, 0.0070536416, 0.0065693366), result);
	result = MulAdd(max(target1, 0), MF4x3(0.0017003485, 0.0021871394, 0.0003407296, 0.0054420815, 0.00801073, 0.008788295, -0.012685104, -0.0150940735, -0.017530257, -0.030698642, -0.030817484, -0.028548386), result);
	result = MulAdd(max(target2, 0), MF4x3(-0.008882145, -0.008943836, -0.007986094, -0.010494911, -0.011511255, -0.00892924, 0.014072905, 0.014985031, 0.011853883, -0.015823284, -0.017817877, -0.01684662), result);
	result = MulAdd(max(target3, 0), MF4x3(0.012270136, 0.011127063, 0.010729208, 0.00027298275, 0.001011805, 0.001318525, 0.0029811305, 0.0029161042, 0.0060088155, 0.00021241597, -0.0013439909, 0.0013205905), result);
	result = MulAdd(max(-target1, 0), MF4x3(-0.03467924, -0.035764243, -0.03348244, 0.023858175, 0.02580526, 0.026217844, -0.016814101, -0.016412167, -0.012021982, -0.0007905926, -0.0019904284, -0.0015143935), result);
	result = MulAdd(max(-target2, 0), MF4x3(0.046779703, 0.04961137, 0.046104047, -0.023665644, -0.022809561, -0.02236428, -0.054706786, -0.056090504, -0.052543454, -0.015520943, -0.01587306, -0.0142722875), result);
	result = MulAdd(max(-target3, 0), MF4x3(0.020273875, 0.020399818, 0.021745082, 0.037485637, 0.039574977, 0.03556703, 0.036673885, 0.04102765, 0.033708427, 0.024422405, 0.027724478, 0.0252598), result);
	result += MF3(-0.0036656514, 0.006677459, 0.007698717);

	result += INPUT.SampleLevel(sam, pos, 0).rgb;
	OUTPUT[gxy] = MF4(result, 1);
}
