// CuNNy 4x16 - https://github.com/funnyplanter/CuNNy

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.


//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME CuNNy-04x16
//!USE MulAdd
//!CAPABILITY FP16

#include "../StubDefs.hlsli"

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH * 2
//!HEIGHT INPUT_HEIGHT * 2
Texture2D OUTPUT;

//!SAMPLER
//!FILTER POINT
SamplerState SP;

//!SAMPLER
//!FILTER LINEAR
SamplerState SL;

//!COMMON
#define O(t, x, y) t.SampleLevel(SP, pos + float2(x, y) * pt, 0)
#define V4 MF4
#define M4 MF4x4

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T0;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T3;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T4;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T5;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T6;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_UNORM
Texture2D T7;

//!PASS 1
//!DESC in (3x16)
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN INPUT
//!OUT T0, T1, T2, T3

#define L0(x, y) V3(O(INPUT, x, y).rgb)
#define V3 MF3
#define M3x4 MF3x4

void Pass1(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 sz = GetInputSize();
	if (gxy.x >= sz.x || gxy.y >= sz.y)
		return;
	float2 pos = (gxy + 0.5) * pt;
	V3 s0_0_0, s0_0_1, s0_0_2, s0_1_0, s0_1_1, s0_1_2, s0_2_0, s0_2_1, s0_2_2;
	V4 r0 = 0.0, r1 = 0.0, r2 = 0.0, r3 = 0.0;
	r0 = V4(1.406e-02, -1.134e-03, -1.611e-02, -2.320e-04);
	r1 = V4(3.087e-02, 1.628e-03, 3.260e-02, 5.064e-03);
	r2 = V4(8.945e-03, 1.333e-01, 1.492e-02, -4.488e-03);
	r3 = V4(2.635e-03, -9.137e-03, -8.033e-01, -1.303e-02);
	s0_0_0 = L0(-1.0, -1.0); s0_0_1 = L0(0.0, -1.0); s0_0_2 = L0(1.0, -1.0);
	s0_1_0 = L0(-1.0, 0.0); s0_1_1 = L0(0.0, 0.0); s0_1_2 = L0(1.0, 0.0);
	s0_2_0 = L0(-1.0, 1.0); s0_2_1 = L0(0.0, 1.0); s0_2_2 = L0(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M3x4(7.157e-03, 1.490e-02, 8.311e-03, -1.157e-03, 6.252e-02, -8.575e-03, 4.185e-02, 1.996e-02, -3.998e-03, -4.913e-03, -2.806e-02, -9.369e-03), r0);
	r1 = MulAdd(s0_0_0, M3x4(-9.445e-05, 5.493e-03, 3.455e-02, -1.350e-02, -4.914e-02, 1.802e-02, -7.098e-02, -2.797e-02, 6.551e-04, -1.144e-02, -7.462e-04, 5.474e-03), r1);
	r2 = MulAdd(s0_0_0, M3x4(1.800e-02, 3.464e-02, -1.416e-02, -8.819e-02, -3.611e-02, 3.967e-02, 5.867e-03, 9.414e-02, -4.628e-02, -1.848e-02, 3.075e-04, -1.116e-02), r2);
	r3 = MulAdd(s0_0_0, M3x4(-7.233e-03, -2.764e-02, -2.142e-02, 2.087e-02, 1.905e-02, -5.868e-02, -4.900e-02, 3.184e-02, 1.831e-03, 4.915e-03, 2.649e-02, -1.217e-02), r3);
	r0 = MulAdd(s0_0_1, M3x4(5.857e-03, 9.514e-03, 1.102e-02, -1.616e-03, -7.543e-02, -1.011e-02, -1.817e-02, -1.148e-02, 1.734e-03, 1.404e-03, -3.328e-03, 9.912e-03), r0);
	r1 = MulAdd(s0_0_1, M3x4(-1.850e-02, 2.933e-01, -6.853e-02, 2.949e-02, -3.841e-02, 6.708e-01, 5.893e-02, 3.614e-01, 9.383e-03, 1.069e-01, 3.493e-03, 1.655e-03), r1);
	r2 = MulAdd(s0_0_1, M3x4(9.473e-02, 4.626e-03, 1.054e-02, -1.005e-01, 2.881e-01, 8.076e-03, 2.435e-02, 1.111e-01, -6.196e-02, -7.233e-03, 7.476e-03, -6.289e-03), r2);
	r3 = MulAdd(s0_0_1, M3x4(6.262e-03, 3.516e-03, 2.109e-02, 8.779e-03, -2.143e-02, 4.856e-02, -4.855e-02, -4.048e-02, 2.852e-03, -1.029e-02, -4.945e-02, -1.199e-02), r3);
	r0 = MulAdd(s0_0_2, M3x4(-1.176e-03, -2.588e-03, -3.174e-02, -6.474e-03, -4.673e-03, -2.921e-05, -2.364e-02, 2.064e-03, 3.611e-03, 3.187e-03, 9.060e-02, 6.318e-04), r0);
	r1 = MulAdd(s0_0_2, M3x4(1.771e-02, 5.698e-03, 1.709e-02, -3.503e-02, 5.520e-03, 3.892e-02, -1.585e-02, -9.999e-03, -7.066e-03, -1.358e-02, -6.007e-04, 2.835e-03), r1);
	r2 = MulAdd(s0_0_2, M3x4(1.550e-02, 3.339e-02, -1.560e-03, -1.513e-02, 7.854e-02, 2.149e-02, -2.321e-03, 7.129e-03, -1.244e-02, 6.597e-04, -5.545e-03, 5.801e-03), r2);
	r3 = MulAdd(s0_0_2, M3x4(-5.756e-03, -9.332e-04, 7.462e-03, -2.783e-02, 1.247e-04, 1.930e-02, -5.367e-02, 6.196e-03, -2.841e-03, -2.488e-03, 3.808e-02, -6.416e-04), r3);
	r0 = MulAdd(s0_1_0, M3x4(3.175e-01, -3.259e-02, 5.764e-03, 3.572e-01, 6.230e-01, 3.457e-02, -2.519e-02, 6.973e-01, 1.037e-01, -2.233e-03, 2.533e-02, 1.058e-01), r0);
	r1 = MulAdd(s0_1_0, M3x4(5.013e-02, 2.124e-03, -3.317e-02, 1.362e-02, 8.784e-02, -3.546e-02, 1.501e-01, -3.481e-02, 1.142e-02, 1.639e-02, 1.085e-02, -5.622e-03), r1);
	r2 = MulAdd(s0_1_0, M3x4(1.018e-01, 1.750e-02, 9.937e-02, 9.039e-01, 1.865e-01, 2.924e-02, -1.143e-02, -8.926e-01, -5.468e-02, -3.759e-02, -1.213e-02, 2.427e-02), r2);
	r3 = MulAdd(s0_1_0, M3x4(-1.728e-02, -2.822e-01, -7.844e-02, -5.404e-02, -5.536e-02, -5.129e-01, 1.272e-02, -4.425e-02, -5.391e-03, -6.419e-02, -2.723e-02, 1.895e-02), r3);
	r0 = MulAdd(s0_1_1, M3x4(-3.135e-01, 1.039e-01, -2.092e-02, -3.584e-01, -6.341e-01, -8.082e-02, -2.023e-02, -6.899e-01, -9.937e-02, -1.752e-02, 1.861e-02, -1.137e-01), r0);
	r1 = MulAdd(s0_1_1, M3x4(-1.899e-01, -2.959e-01, 4.434e-01, 4.040e-02, 4.209e-01, -6.660e-01, -3.923e-01, -1.362e-01, -1.875e-02, -9.937e-02, 7.274e-03, -1.664e-02), r1);
	r2 = MulAdd(s0_1_1, M3x4(-1.285e-02, -3.076e-01, -2.356e-02, 1.420e-02, -1.861e-01, -2.874e-01, -9.692e-02, 7.617e-03, 1.460e-01, 1.130e-01, -1.789e-02, -3.112e-02), r2);
	r3 = MulAdd(s0_1_1, M3x4(-3.037e-01, 2.982e-01, 4.015e-01, -2.343e-01, -5.697e-01, 5.332e-01, 9.464e-01, -5.139e-01, -7.152e-02, 7.354e-02, 4.921e-02, -3.209e-02), r3);
	r0 = MulAdd(s0_1_2, M3x4(2.575e-02, 4.951e-01, 7.005e-02, 7.335e-03, -2.310e-02, -4.872e-01, 2.339e-01, -9.570e-03, 1.262e-03, -1.385e-02, 1.686e-01, 5.026e-03), r0);
	r1 = MulAdd(s0_1_2, M3x4(7.112e-02, -1.259e-02, -4.966e-02, -3.044e-02, -6.528e-02, -3.708e-02, 2.255e-01, 1.337e-02, 1.147e-02, 1.541e-02, 2.419e-04, -5.793e-04), r1);
	r2 = MulAdd(s0_1_2, M3x4(-1.679e-01, 4.385e-02, 4.834e-02, -3.524e-02, -2.842e-01, -1.049e-02, 1.458e-03, 3.501e-02, 4.593e-02, -1.034e-02, 9.453e-03, -2.663e-03), r2);
	r3 = MulAdd(s0_1_2, M3x4(7.414e-03, -8.961e-03, -9.222e-03, -1.505e-03, 7.776e-03, 3.633e-03, -1.130e-01, -3.001e-02, 1.463e-02, -7.014e-03, -6.145e-02, -1.919e-02), r3);
	r0 = MulAdd(s0_2_0, M3x4(5.313e-03, -9.997e-03, -3.144e-02, 1.395e-02, 1.068e-01, 3.945e-05, -4.951e-02, 1.874e-03, -6.101e-03, 1.351e-02, 1.806e-02, -9.222e-03), r0);
	r1 = MulAdd(s0_2_0, M3x4(-2.050e-02, -1.242e-02, 5.457e-03, 1.360e-02, -2.155e-02, 5.849e-03, -4.120e-02, -2.882e-03, -5.776e-03, -5.614e-03, -4.758e-03, 2.753e-03), r1);
	r2 = MulAdd(s0_2_0, M3x4(2.717e-02, 2.725e-02, -9.739e-02, -8.745e-02, 3.573e-02, 2.733e-02, 2.979e-02, 1.004e-01, 9.685e-03, 4.758e-03, -1.871e-03, -1.864e-02), r2);
	r3 = MulAdd(s0_2_0, M3x4(2.245e-02, -1.159e-02, 4.099e-02, -2.380e-02, 2.692e-02, -1.038e-01, -2.480e-02, -3.101e-03, -4.996e-03, 2.104e-03, 1.954e-02, -3.133e-02), r3);
	r0 = MulAdd(s0_2_1, M3x4(-3.370e-02, -7.489e-01, 9.913e-03, -3.727e-03, -2.200e-02, 7.189e-01, 8.426e-02, -1.251e-02, 3.844e-03, 7.860e-03, 1.343e-01, 1.060e-02), r0);
	r1 = MulAdd(s0_2_1, M3x4(2.718e-02, 1.739e-02, -1.048e-01, -6.029e-03, 5.644e-03, 5.693e-03, 1.256e-01, 4.214e-02, 3.031e-03, -6.308e-03, -1.031e-02, 7.556e-03), r1);
	r2 = MulAdd(s0_2_1, M3x4(-8.227e-02, -2.763e-02, 2.261e-01, -7.162e-02, 1.635e-03, 4.283e-02, 9.947e-02, 7.666e-02, 2.887e-02, 7.367e-03, 1.854e-02, -4.228e-03), r2);
	r3 = MulAdd(s0_2_1, M3x4(3.075e-01, 2.363e-02, -6.788e-02, 2.479e-01, 5.996e-01, 4.575e-02, -4.749e-02, 4.628e-01, 6.661e-02, -5.581e-03, -3.518e-02, 6.356e-02), r3);
	r0 = MulAdd(s0_2_2, M3x4(4.938e-03, 1.720e-01, -1.095e-04, -6.701e-03, -1.233e-02, -1.695e-01, -1.677e-01, 3.480e-03, 1.336e-03, 1.412e-02, -7.429e-01, 3.504e-04), r0);
	r1 = MulAdd(s0_2_2, M3x4(3.460e-02, 2.450e-03, -8.434e-02, -1.975e-02, 2.967e-03, -1.477e-04, 9.797e-02, 1.727e-02, 7.965e-03, -1.813e-03, 1.288e-03, -6.565e-04), r1);
	r2 = MulAdd(s0_2_2, M3x4(-1.458e-02, 3.034e-02, 4.005e-03, -4.391e-02, -8.667e-02, 3.182e-04, -7.493e-02, 2.559e-02, -4.620e-02, -4.471e-03, 7.274e-03, 1.621e-02), r2);
	r3 = MulAdd(s0_2_2, M3x4(-6.385e-03, -1.216e-02, 7.528e-03, 1.992e-02, -1.993e-03, 6.777e-03, -2.777e-02, 9.337e-02, -2.772e-03, 1.418e-03, 2.503e-02, 7.394e-03), r3);
	r0 = max(r0, 0.0);
	T0[gxy] = r0;
	r1 = max(r1, 0.0);
	T1[gxy] = r1;
	r2 = max(r2, 0.0);
	T2[gxy] = r2;
	r3 = max(r3, 0.0);
	T3[gxy] = r3;
}

//!PASS 2
//!DESC conv1 (16x16)
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN T0, T1, T2, T3
//!OUT T4, T5, T6, T7

#define L0(x, y) V4(O(T0, x, y))
#define L1(x, y) V4(O(T1, x, y))
#define L2(x, y) V4(O(T2, x, y))
#define L3(x, y) V4(O(T3, x, y))

void Pass2(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 sz = GetInputSize();
	if (gxy.x >= sz.x || gxy.y >= sz.y)
		return;
	float2 pos = (gxy + 0.5) * pt;
	V4 s0_0_0, s0_0_1, s0_0_2, s0_1_0, s0_1_1, s0_1_2, s0_2_0, s0_2_1, s0_2_2, s1_0_0, s1_0_1, s1_0_2, s1_1_0, s1_1_1, s1_1_2, s1_2_0, s1_2_1, s1_2_2;
	V4 r0 = 0.0, r1 = 0.0, r2 = 0.0, r3 = 0.0;
	s0_0_0 = L0(-1.0, -1.0); s0_0_1 = L0(0.0, -1.0); s0_0_2 = L0(1.0, -1.0);
	s0_1_0 = L0(-1.0, 0.0); s0_1_1 = L0(0.0, 0.0); s0_1_2 = L0(1.0, 0.0);
	s0_2_0 = L0(-1.0, 1.0); s0_2_1 = L0(0.0, 1.0); s0_2_2 = L0(1.0, 1.0);
	s1_0_0 = L1(-1.0, -1.0); s1_0_1 = L1(0.0, -1.0); s1_0_2 = L1(1.0, -1.0);
	s1_1_0 = L1(-1.0, 0.0); s1_1_1 = L1(0.0, 0.0); s1_1_2 = L1(1.0, 0.0);
	s1_2_0 = L1(-1.0, 1.0); s1_2_1 = L1(0.0, 1.0); s1_2_2 = L1(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(1.788e-02, 2.205e-01, 2.886e-03, 4.223e-01, 2.034e-01, -3.195e-01, -3.347e-01, -1.427e-01, 1.224e-01, -1.505e-01, -9.164e-02, -4.850e-01, -1.100e-02, -2.660e-01, 6.822e-02, -3.488e-01), r0);
	r1 = MulAdd(s0_0_0, M4(-7.201e-02, -1.380e-01, 3.308e-02, -2.421e-02, 2.715e-02, 2.007e-01, 3.527e-02, -2.437e-02, -1.058e-01, -3.545e-01, -9.836e-02, 1.884e-01, 1.247e-01, 2.260e-01, -3.649e-02, 9.177e-03), r1);
	r2 = MulAdd(s0_0_0, M4(6.776e-02, -3.331e-02, -2.107e-02, 1.116e-01, 1.162e-01, 3.677e-02, -1.374e-01, 1.475e-01, 1.012e-01, -1.307e-02, -1.029e-01, -4.349e-01, -4.044e-02, 2.801e-02, 3.096e-02, -1.280e-01), r2);
	r3 = MulAdd(s0_0_0, M4(-5.518e-02, -3.696e-02, -9.311e-02, 4.086e-02, -1.857e-01, 6.179e-02, 1.553e-01, 3.918e-01, 9.151e-01, 3.935e-02, -1.277e-02, 1.679e-01, 7.160e-02, 6.361e-02, 2.239e-02, 3.312e-02), r3);
	r0 = MulAdd(s0_0_1, M4(1.120e-01, 5.365e-01, -2.755e-02, -1.419e-02, 8.365e-02, 2.276e-01, 1.655e-01, -2.647e-01, 1.794e-02, -1.330e-01, 4.972e-02, -4.486e-02, -3.020e-02, -1.177e+00, 6.891e-02, -3.763e-01), r0);
	r1 = MulAdd(s0_0_1, M4(7.856e-02, 1.100e-01, 1.564e-01, -3.104e-02, 2.918e-01, 1.883e-01, -1.200e-01, 3.592e-01, -4.532e-02, -3.269e-02, -1.160e-01, -2.479e-01, 9.053e-03, 2.405e-01, -8.387e-02, 4.650e-03), r1);
	r2 = MulAdd(s0_0_1, M4(-2.316e-02, 1.846e-02, -6.399e-02, -2.430e-01, -6.203e-02, -6.119e-02, 1.948e-01, -7.786e-02, 4.720e-02, 1.049e-01, -4.580e-02, 2.116e-01, -1.169e-01, -3.922e-02, 2.189e-02, 2.083e-01), r2);
	r3 = MulAdd(s0_0_1, M4(-1.975e-02, 1.009e-01, -2.456e-01, -1.100e-01, -9.144e-02, 8.602e-02, 1.597e-01, 4.604e-02, 1.547e-01, -2.554e-02, 1.091e-01, -1.389e-01, -1.007e-01, -8.373e-02, 1.741e-01, 7.786e-02), r3);
	r0 = MulAdd(s0_0_2, M4(4.151e-02, 6.592e-01, -1.322e-01, 4.623e-01, 8.289e-02, -1.017e-01, 7.299e-03, -4.471e-02, 2.270e-02, 8.943e-02, 7.102e-02, 2.800e-02, -4.870e-02, -8.418e-01, 2.080e-01, -2.627e-01), r0);
	r1 = MulAdd(s0_0_2, M4(1.392e-02, -9.127e-02, 1.173e-01, -1.188e-02, -3.384e-02, -3.122e-02, -4.432e-02, -1.217e-01, 4.255e-03, 9.169e-02, 9.675e-03, -7.991e-03, -1.100e-02, 1.265e-01, -1.179e-01, -2.188e-02), r1);
	r2 = MulAdd(s0_0_2, M4(-1.205e-01, 5.658e-02, 9.979e-02, 5.176e-01, 7.118e-02, 5.188e-02, -6.473e-02, 1.148e-02, -4.085e-02, 1.268e-02, 6.781e-03, 1.673e-02, 1.130e-01, 1.516e-02, -6.337e-02, -5.721e-01), r2);
	r3 = MulAdd(s0_0_2, M4(-2.387e-02, -1.343e-01, -5.973e-02, -1.776e-01, 6.187e-02, 1.114e-02, 6.211e-02, -5.296e-03, 6.409e-02, 4.284e-02, 1.615e-02, -1.827e-02, -4.253e-02, 1.404e-01, 5.407e-03, 1.092e-01), r3);
	r0 = MulAdd(s0_1_0, M4(-3.757e-02, -5.566e-01, 6.740e-01, -3.182e-01, -1.468e-02, 2.081e-01, -2.767e-01, -1.647e-01, 6.650e-02, -1.717e-01, -1.351e-02, -7.040e-02, 4.003e-02, 5.564e-01, -9.491e-01, 2.685e-01), r0);
	r1 = MulAdd(s0_1_0, M4(-6.944e-02, -1.189e-01, 3.454e-02, 1.972e-02, -7.713e-02, -5.943e-01, 1.156e-01, 3.877e-03, -5.640e-02, -5.369e-01, -3.708e-02, -4.546e-02, 9.500e-02, 7.988e-02, -3.280e-02, 3.479e-02), r1);
	r2 = MulAdd(s0_1_0, M4(-2.628e-01, -5.848e-02, -3.017e-02, 2.900e-01, 1.628e-01, 1.317e-02, -4.003e-04, -1.658e-01, 1.968e-01, -2.017e-01, 3.531e-03, -2.102e-01, 3.050e-01, 1.209e-01, 6.500e-02, -2.959e-01), r2);
	r3 = MulAdd(s0_1_0, M4(2.752e-02, 8.765e-02, 1.409e-01, -1.460e-01, 1.673e-01, 8.431e-02, -3.811e-02, 3.285e-02, -1.143e-02, -1.407e-01, 6.435e-02, -1.256e-01, 3.138e-02, -3.065e-02, -1.577e-01, -2.050e-02), r3);
	r0 = MulAdd(s0_1_1, M4(-4.785e-01, -1.996e+00, -9.564e-02, -8.925e-01, 5.598e-02, -1.605e-01, -9.596e-02, 2.212e-01, -7.452e-02, -4.162e-02, -8.838e-02, 6.455e-02, 6.798e-01, -4.194e+00, -3.265e+00, 2.397e-01), r0);
	r1 = MulAdd(s0_1_1, M4(6.663e-02, -5.464e-01, -2.490e-01, 3.779e-01, 5.311e-02, -2.478e-01, -3.091e-02, 1.511e-01, -1.553e-02, 1.489e-02, -1.911e-02, -2.666e-02, -2.072e-02, 4.403e-01, 1.685e-01, -4.537e-01), r1);
	r2 = MulAdd(s0_1_1, M4(3.311e-01, -3.987e-02, 2.136e-01, -5.371e-01, -1.577e-01, 8.782e-02, 1.558e-03, 5.332e-01, -2.526e-01, 6.945e-02, 6.891e-02, -2.276e-03, -4.329e-02, 2.419e-01, -4.696e-03, 6.425e-01), r2);
	r3 = MulAdd(s0_1_1, M4(3.292e-01, 2.587e-01, -6.072e-02, 4.263e-02, -2.036e-02, -1.189e-01, 3.713e-02, -2.456e-01, -8.160e-02, 5.654e-02, -1.618e-02, 1.590e-02, -5.872e-01, -1.659e-01, 2.064e-01, -6.796e-02), r3);
	r0 = MulAdd(s0_1_2, M4(-2.078e-01, 6.931e-01, 6.455e-02, 4.852e-01, 1.422e-02, -7.701e-02, 7.537e-02, 5.240e-02, -3.649e-02, -3.341e-02, -4.295e-02, -1.693e-02, 5.827e-01, -8.372e-01, -2.607e-01, -5.159e-01), r0);
	r1 = MulAdd(s0_1_2, M4(-3.787e-02, -7.057e-02, 3.232e-01, 4.029e-01, 2.048e-02, 6.181e-02, 4.566e-04, 2.973e-02, -2.354e-02, -6.249e-02, 3.777e-03, 5.358e-02, 1.012e+00, 2.174e-01, -2.920e-01, 2.505e-01), r1);
	r2 = MulAdd(s0_1_2, M4(-1.770e-01, -7.771e-02, -6.974e-03, -1.096e+00, -2.672e-02, 1.937e-02, 3.560e-02, -2.055e-02, -2.541e-02, 1.974e-02, 1.742e-02, -1.021e-01, -1.167e+00, 2.741e-01, 3.571e-02, 1.265e+00), r2);
	r3 = MulAdd(s0_1_2, M4(3.816e-01, -3.057e-01, -3.261e-02, 6.758e-02, 2.721e-02, 6.231e-02, 4.165e-02, 1.412e-01, 1.198e-01, 6.042e-02, -9.042e-03, 1.507e-02, -4.577e-01, 1.156e-01, 1.095e-01, -6.893e-04), r3);
	r0 = MulAdd(s0_2_0, M4(-1.170e-02, -1.069e-02, -2.041e-01, -1.212e-01, 2.867e-02, 4.236e-02, 4.693e-02, 6.569e-02, -1.030e-03, 4.134e-03, 1.563e-01, -8.735e-02, 2.977e-02, 3.956e-02, 1.021e-01, -4.915e-03), r0);
	r1 = MulAdd(s0_2_0, M4(-7.992e-02, -9.630e-02, -5.731e-04, -6.216e-02, 4.059e-02, 1.215e-01, -8.239e-03, 4.672e-02, -1.249e-02, 6.660e-02, -1.029e-02, 3.390e-02, 1.101e-01, 2.082e-01, -3.107e-02, 1.053e-01), r1);
	r2 = MulAdd(s0_2_0, M4(3.630e-03, 2.107e-02, 1.947e-02, 3.527e-01, 6.275e-02, -8.310e-03, -2.907e-02, -1.798e-01, -2.168e-01, 6.908e-02, 3.534e-02, 3.211e-02, 2.041e-02, -5.920e-02, -1.734e-02, -3.959e-01), r2);
	r3 = MulAdd(s0_2_0, M4(-2.097e-01, -2.028e-01, 1.014e-01, 5.208e-02, 1.323e-01, 3.837e-02, 3.261e-02, 8.462e-02, -3.384e-02, -7.584e-03, -1.607e-02, -9.186e-03, 2.007e-01, 2.164e-01, -1.616e-01, 1.733e-02), r3);
	r0 = MulAdd(s0_2_1, M4(-8.265e-03, -4.593e-02, -2.472e-01, 2.918e-01, 8.995e-03, -6.153e-02, 1.484e-01, 1.439e-03, -2.052e-02, -7.205e-02, -8.907e-02, -4.459e-02, -3.343e-03, 1.616e-01, -1.050e-01, 4.806e-02), r0);
	r1 = MulAdd(s0_2_1, M4(1.255e-01, 6.081e-01, -1.847e-02, -2.654e-01, -3.821e-02, -1.792e-01, -2.302e-02, 1.364e-01, 1.004e-01, -3.006e-04, -2.543e-02, -2.154e-02, -5.140e-02, -1.564e+00, 7.026e-02, 2.832e-01), r1);
	r2 = MulAdd(s0_2_1, M4(1.539e-01, 1.131e-01, -1.250e-01, 2.580e-01, -1.521e-01, -1.441e-02, 1.562e-02, 6.420e-02, -1.597e-02, 8.342e-02, 2.532e-02, 1.575e-04, -6.713e-02, -2.416e-01, 1.309e-01, -2.142e-01), r2);
	r3 = MulAdd(s0_2_1, M4(-4.146e-01, -5.211e-02, -1.785e-01, -3.507e-02, 1.238e-01, 3.765e-02, 8.861e-02, -1.806e-01, -2.905e-02, -1.528e-02, -4.457e-02, 4.804e-02, 7.107e-01, 4.643e-01, 4.496e-02, -2.635e-02), r3);
	r0 = MulAdd(s0_2_2, M4(4.288e-03, 3.332e-01, 3.487e-02, -7.929e-02, -2.236e-02, 2.853e-02, 2.600e-02, -9.128e-02, 1.197e-02, -1.344e-02, -2.150e-02, -2.676e-02, 5.888e-02, -2.537e-01, 5.843e-02, -5.843e-02), r0);
	r1 = MulAdd(s0_2_2, M4(4.900e-03, 6.538e-01, 6.492e-03, -7.793e-01, 5.391e-02, 1.312e-01, -6.935e-03, 5.686e-03, -1.187e-02, -3.767e-02, -5.301e-03, 7.893e-03, -5.299e-02, -1.202e+00, -7.189e-02, 6.143e-01), r1);
	r2 = MulAdd(s0_2_2, M4(-1.418e-01, 4.670e-02, -1.077e-01, 2.569e-01, -1.776e-02, -3.107e-04, 2.152e-02, 4.620e-02, 1.079e-02, -2.474e-03, -2.722e-02, 5.906e-03, 2.232e-01, -3.032e-01, 1.995e-02, -4.413e-01), r2);
	r3 = MulAdd(s0_2_2, M4(-1.761e-01, -2.278e-01, -5.653e-02, 9.840e-02, -2.643e-02, 9.197e-03, -7.835e-03, -2.857e-03, -2.946e-02, -1.064e-02, 4.362e-03, -5.246e-02, 3.545e-01, 3.456e-01, 1.295e-01, -7.074e-02), r3);
	r0 = MulAdd(s1_0_0, M4(-4.993e-02, 2.047e-01, 5.817e-03, 6.864e-03, 6.335e-02, 7.181e-03, 5.155e-02, -2.781e-01, 3.932e-01, 2.601e-01, 1.913e-01, 2.370e-01, -8.294e-02, -1.792e-01, -5.576e-02, -4.238e-02), r0);
	r1 = MulAdd(s1_0_0, M4(-1.033e-01, -1.395e-01, 1.037e-01, 3.453e-02, -1.706e-02, 3.962e-02, 1.144e-02, 1.684e-02, -1.648e-01, -1.411e-01, -1.047e-01, 1.290e-02, 5.274e-03, -2.678e-02, -1.093e-01, -1.328e-01), r1);
	r2 = MulAdd(s1_0_0, M4(-7.331e-02, 6.674e-03, -1.356e-01, 1.838e-01, -1.793e-02, 3.824e-02, 3.625e-03, 2.822e-02, 1.449e-01, -2.238e-02, 4.559e-02, -4.704e-02, -4.312e-02, -6.242e-03, -6.706e-02, -6.263e-02), r2);
	r3 = MulAdd(s1_0_0, M4(6.303e-02, -7.718e-02, -1.129e-02, 5.382e-01, 3.047e-02, 2.363e-02, -5.092e-02, -3.522e-02, -1.111e-02, 1.211e-02, 1.154e-01, -8.485e-01, 1.069e-03, 1.073e-02, -2.504e-02, 1.798e-01), r3);
	r0 = MulAdd(s1_0_1, M4(-3.989e-01, -1.374e-01, -2.176e-01, -1.258e-01, 1.233e-01, 7.124e-02, 3.437e-02, -4.593e-02, 2.689e-01, -1.160e-01, 1.173e-01, -1.228e-01, -1.664e-01, 9.002e-02, -9.318e-02, -2.302e-01), r0);
	r1 = MulAdd(s1_0_1, M4(1.111e-01, -8.454e-02, 1.202e-01, -2.781e-01, 4.718e-02, 6.377e-02, 1.100e-02, 8.081e-03, -3.971e-02, -1.627e-02, 9.318e-03, -1.891e-01, -6.413e-03, -8.276e-02, 6.843e-02, -1.711e-02), r1);
	r2 = MulAdd(s1_0_1, M4(-2.548e-01, -1.352e-01, 2.068e-01, -4.666e-04, 4.776e-02, -3.383e-02, -2.851e-02, 1.011e-01, -3.917e-02, -8.640e-02, 1.391e-01, -3.802e-01, -2.098e-02, -1.179e-02, 8.600e-02, -1.634e-01), r2);
	r3 = MulAdd(s1_0_1, M4(-2.408e-01, 1.134e-01, -1.465e-01, 7.476e-01, -1.172e-02, -1.506e-02, 2.364e-02, 1.004e-02, 1.266e-01, 8.075e-02, 1.692e-02, -8.509e-01, -8.544e-02, 5.709e-02, -1.098e-01, 1.967e-01), r3);
	r0 = MulAdd(s1_0_2, M4(-2.356e-01, 1.104e-01, -6.447e-02, -1.363e-01, -2.479e-02, -1.096e-01, -4.085e-02, -1.365e-01, 5.432e-02, -2.282e-02, 5.583e-03, -4.026e-05, 1.497e-03, 1.318e-01, -5.163e-02, 3.236e-01), r0);
	r1 = MulAdd(s1_0_2, M4(1.142e-01, -1.009e-02, 1.715e-02, 1.964e-01, -4.364e-03, 1.121e-01, -1.091e-02, 5.330e-02, -5.478e-03, 3.512e-02, -7.683e-03, 6.890e-02, -1.503e-02, -4.837e-02, -5.401e-03, -1.576e-02), r1);
	r2 = MulAdd(s1_0_2, M4(-9.630e-02, 4.349e-02, 4.008e-02, -1.087e-01, 5.170e-02, 3.770e-02, -2.122e-02, -1.665e-02, 1.236e-01, 1.153e-01, -4.062e-02, -9.029e-02, -2.276e-01, 3.961e-02, -2.680e-02, 7.604e-02), r2);
	r3 = MulAdd(s1_0_2, M4(9.642e-02, -2.775e-02, -7.485e-02, 2.815e-01, 3.261e-02, 5.116e-03, -4.167e-02, 4.455e-02, 1.696e-01, 2.301e-02, 3.673e-02, -5.035e-02, 9.058e-02, -2.614e-02, 1.633e-02, -8.473e-02), r3);
	r0 = MulAdd(s1_1_0, M4(-2.910e-01, -1.390e-01, 4.077e-01, -1.005e-01, 4.870e-02, 5.401e-01, -5.858e-02, -9.876e-01, 5.905e-01, 3.892e-01, -9.640e-02, 1.215e-01, -4.347e-02, -3.046e-01, -4.608e-03, -3.377e-01), r0);
	r1 = MulAdd(s1_1_0, M4(1.409e-01, 1.907e-01, 9.375e-02, -4.069e-02, 4.627e-02, -1.421e-01, -6.118e-02, -8.389e-03, -1.271e-01, -4.202e-02, 3.236e-01, 1.808e-01, -8.544e-02, 1.672e-01, -1.792e-01, 4.133e-02), r1);
	r2 = MulAdd(s1_1_0, M4(-1.603e-01, -7.611e-02, -2.435e-02, -4.799e-02, 1.084e-02, 8.606e-02, 2.100e-02, 7.720e-03, -1.179e-01, -5.244e-02, 1.981e-01, 2.171e-01, -7.768e-02, -4.968e-02, -8.753e-02, 4.112e-01), r2);
	r3 = MulAdd(s1_1_0, M4(9.018e-03, -2.268e-03, 4.058e-01, 4.308e-01, 9.977e-02, 1.399e-01, 1.336e-01, 3.760e-02, 7.738e-02, -1.151e-02, -1.266e-01, -7.504e-02, 5.391e-02, -6.939e-02, 1.199e-01, -1.788e-01), r3);
	r0 = MulAdd(s1_1_1, M4(2.244e-01, -2.995e-01, 2.437e-01, 2.565e-01, 2.329e-01, -6.590e-02, 3.115e-01, 9.718e-01, -7.821e-01, -3.917e-01, -8.647e-02, -1.347e-01, 3.259e-02, 2.215e-02, -1.429e-01, 4.307e-01), r0);
	r1 = MulAdd(s1_1_1, M4(-1.248e-02, 1.795e-01, 1.875e-02, -5.574e-02, 1.725e-01, 3.188e-01, 1.961e-01, -1.282e-01, 1.792e-01, 3.603e-01, -3.308e-01, -2.750e-02, -7.465e-02, 2.029e-01, -2.332e-01, 7.252e-02), r1);
	r2 = MulAdd(s1_1_1, M4(4.268e-01, -4.104e-01, -1.738e-01, -2.896e-01, 8.621e-02, -1.492e-01, 1.640e-01, 4.399e-01, -7.638e-01, -5.459e-02, -2.984e-01, 2.875e-01, 2.264e-01, -1.462e-03, -2.459e-01, 4.258e-01), r2);
	r3 = MulAdd(s1_1_1, M4(-7.983e-02, 1.825e-01, -6.268e-02, -9.442e-01, -7.087e-01, -7.251e-02, 2.900e-01, -1.705e-01, 3.997e-02, -2.154e-01, 4.903e-02, 1.114e+00, 1.061e-01, 4.603e-02, 4.391e-01, 4.522e-01), r3);
	r0 = MulAdd(s1_1_2, M4(3.896e-01, 4.771e-01, 2.362e-01, 1.370e-01, -2.130e-02, -1.543e-01, 5.252e-02, 4.703e-01, 2.130e-01, 2.542e-01, 1.870e-01, -7.936e-02, 4.324e-02, -1.922e-01, -1.204e-01, -3.205e-01), r0);
	r1 = MulAdd(s1_1_2, M4(-2.321e-02, -1.767e-01, 1.266e-01, 3.195e-01, -8.089e-02, 3.223e-02, 8.967e-02, 1.602e-01, 7.202e-02, -1.005e-01, 1.071e-01, -2.772e-01, -1.831e-01, 1.080e-01, -3.222e-02, 2.815e-01), r1);
	r2 = MulAdd(s1_1_2, M4(1.244e-01, -3.283e-01, 2.939e-01, 3.782e-01, 5.058e-02, -3.428e-02, 7.557e-03, -2.153e-01, -1.849e-01, -1.252e-01, 9.457e-02, 9.326e-02, -1.958e-01, -1.131e-02, 6.031e-03, 1.186e-01), r2);
	r3 = MulAdd(s1_1_2, M4(-1.450e-01, -1.806e-02, -8.782e-02, -3.611e-01, -1.112e-01, 7.050e-03, -1.125e-01, -6.116e-02, 7.769e-02, 5.958e-02, 1.165e-01, -5.735e-02, -1.691e-01, 2.795e-02, 6.288e-02, 2.508e-01), r3);
	r0 = MulAdd(s1_2_0, M4(1.054e-03, -1.183e-01, -1.109e-01, 1.868e-01, 1.276e-01, -1.411e-01, -4.754e-01, -7.710e-02, 2.912e-02, 4.893e-02, -3.100e-01, -1.850e-01, -3.076e-03, -3.016e-01, 2.920e-01, -1.127e-01), r0);
	r1 = MulAdd(s1_2_0, M4(5.798e-02, 1.538e-01, 6.949e-02, -1.785e-01, -1.481e-01, -1.505e-01, 1.481e-01, 3.261e-02, -1.548e-01, -3.394e-01, 4.677e-02, -1.193e-01, 2.266e-01, 1.043e-02, -3.698e-01, -1.466e-01), r1);
	r2 = MulAdd(s1_2_0, M4(1.683e-01, 2.200e-01, -1.425e-02, 9.899e-02, 1.899e-01, 5.855e-02, -2.828e-02, -1.297e-01, -1.318e-01, 9.850e-02, 1.719e-01, -4.536e-02, -2.443e-01, 1.685e-02, -1.681e-01, -3.148e-01), r2);
	r3 = MulAdd(s1_2_0, M4(6.502e-02, -2.764e-01, 3.466e-01, 1.108e-01, 3.518e-01, 3.188e-02, 8.485e-02, 2.970e-02, -5.964e-02, 2.218e-02, -8.955e-02, 1.563e-02, -2.317e-02, -8.612e-02, -1.207e-02, -2.591e-01), r3);
	r0 = MulAdd(s1_2_1, M4(2.953e-02, -2.084e-02, -2.636e-01, -2.164e-01, -1.254e-01, 1.221e-01, 1.412e-01, -1.345e-01, -2.774e-02, -1.293e-01, 1.134e-02, -1.304e-01, 1.950e-01, 4.513e-01, 1.295e-01, 3.086e-01), r0);
	r1 = MulAdd(s1_2_1, M4(-1.355e-01, 1.618e-01, -1.362e-01, -4.446e-01, 1.281e-01, -8.160e-01, 3.934e-01, -1.507e-01, -1.194e-02, 1.300e-01, 4.904e-03, 3.791e-01, 2.725e-01, -2.901e-01, 5.608e-01, -9.418e-02), r1);
	r2 = MulAdd(s1_2_1, M4(-1.487e-01, 4.373e-01, 2.440e-02, -2.752e-01, -1.603e+00, -3.207e+00, 1.759e-02, 1.743e-01, -2.441e-01, -2.632e-02, 6.329e-02, -6.698e-02, 2.263e+00, -3.160e-01, 9.780e-02, -2.079e-01), r2);
	r3 = MulAdd(s1_2_1, M4(4.553e-01, -1.023e-01, -4.910e-01, -3.909e-01, -2.016e+00, 5.797e-01, 1.948e-01, 2.037e-01, -3.967e-03, 2.289e-01, -1.337e-01, 2.111e-02, 4.741e-02, -8.659e-02, -2.989e-01, -2.803e-01), r3);
	r0 = MulAdd(s1_2_2, M4(8.533e-02, -2.044e-02, -4.864e-03, 6.769e-02, 1.847e-02, -1.191e-01, 1.170e-02, 8.726e-02, -1.165e-01, -9.607e-02, -2.285e-02, 9.167e-02, 4.736e-02, 2.335e-02, -4.710e-02, -9.036e-03), r0);
	r1 = MulAdd(s1_2_2, M4(-9.365e-02, -1.973e-01, -4.525e-02, 4.015e-01, 3.677e-02, -6.580e-02, 2.892e-02, 1.522e-01, 3.631e-02, 1.585e-01, -7.115e-04, -1.668e-01, -1.926e-02, -1.137e-01, 2.623e-03, 2.473e-01), r1);
	r2 = MulAdd(s1_2_2, M4(-1.161e-01, 3.676e-01, 5.508e-02, -6.985e-02, 2.335e-01, 8.693e-02, -1.362e-01, 2.583e-01, 6.999e-02, 1.302e-01, -6.527e-02, -3.703e-03, -6.803e-01, 1.826e-01, 9.836e-02, -2.231e-02), r2);
	r3 = MulAdd(s1_2_2, M4(-7.958e-02, 1.647e-01, 1.773e-01, -2.316e-01, -3.093e-02, -1.469e-01, 8.630e-02, -2.154e-02, -1.678e-01, -8.236e-03, 7.567e-02, 2.113e-01, -2.833e-01, 1.736e-01, -9.790e-02, -2.214e-01), r3);
	s0_0_0 = L2(-1.0, -1.0); s0_0_1 = L2(0.0, -1.0); s0_0_2 = L2(1.0, -1.0);
	s0_1_0 = L2(-1.0, 0.0); s0_1_1 = L2(0.0, 0.0); s0_1_2 = L2(1.0, 0.0);
	s0_2_0 = L2(-1.0, 1.0); s0_2_1 = L2(0.0, 1.0); s0_2_2 = L2(1.0, 1.0);
	s1_0_0 = L3(-1.0, -1.0); s1_0_1 = L3(0.0, -1.0); s1_0_2 = L3(1.0, -1.0);
	s1_1_0 = L3(-1.0, 0.0); s1_1_1 = L3(0.0, 0.0); s1_1_2 = L3(1.0, 0.0);
	s1_2_0 = L3(-1.0, 1.0); s1_2_1 = L3(0.0, 1.0); s1_2_2 = L3(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(-7.915e-03, 2.313e-01, 1.663e-01, 2.901e-01, 2.950e-02, -2.420e-01, -9.986e-02, -1.850e-01, -1.628e-01, -4.619e-02, 1.841e-02, -1.286e-01, 2.895e-02, 5.852e-02, 4.322e-02, -3.607e-02), r0);
	r1 = MulAdd(s0_0_0, M4(-2.329e-02, -1.679e-01, 9.648e-02, -3.971e-02, -3.805e-02, 2.330e-02, -4.859e-03, -3.002e-02, -1.773e-03, 1.279e-01, -1.262e-01, 2.134e-01, -1.408e-02, -6.924e-02, -1.234e-02, -2.436e-03), r1);
	r2 = MulAdd(s0_0_0, M4(-1.410e-02, -6.680e-02, 5.066e-02, -1.010e-01, -5.222e-03, 3.370e-02, -2.072e-02, -1.557e-03, 3.181e-02, 4.461e-02, 9.015e-02, 1.097e-01, -3.886e-02, 1.588e-03, -3.767e-03, 1.778e-03), r2);
	r3 = MulAdd(s0_0_0, M4(-1.159e-01, -7.286e-02, 1.441e-01, 9.811e-02, -3.207e-02, -1.879e-02, -1.785e-02, -9.868e-03, 6.218e-02, -1.400e-01, 1.591e-01, -3.710e-01, -3.213e-03, 6.202e-03, -3.540e-03, -5.158e-03), r3);
	r0 = MulAdd(s0_0_1, M4(-2.540e-02, -1.536e-01, 1.102e-01, 1.243e-01, 3.744e-02, 2.204e-01, -1.632e-01, 2.714e-01, -9.234e-02, 2.456e-01, -1.153e-01, 2.645e-01, -5.233e-02, -1.716e-01, -1.452e-01, -1.102e-01), r0);
	r1 = MulAdd(s0_0_1, M4(-6.021e-02, -4.161e-02, 7.673e-02, 3.739e-02, 2.503e-02, -7.751e-03, 3.178e-02, -1.489e-01, 4.046e-01, -1.050e-01, 3.098e-01, 2.552e-01, 3.713e-02, 8.680e-02, -1.751e-02, -5.720e-02), r1);
	r2 = MulAdd(s0_0_1, M4(-7.295e-02, 5.431e-02, 6.422e-02, -3.336e-01, -1.141e-01, -7.352e-03, 4.670e-02, 1.574e-01, 3.906e-02, -3.211e-01, -1.459e-01, -9.091e-02, -2.846e-02, 6.013e-02, -1.599e-02, 1.274e-01), r2);
	r3 = MulAdd(s0_0_1, M4(9.034e-02, 8.377e-02, -2.708e-02, -6.154e-02, -1.199e-01, 8.904e-03, 1.127e-01, -1.103e-01, -7.303e-02, -1.373e-01, -4.763e-01, -4.225e-01, 5.070e-02, -8.253e-03, 1.210e-03, 1.323e-01), r3);
	r0 = MulAdd(s0_0_2, M4(5.157e-02, 6.418e-02, 1.205e-01, -7.100e-02, -4.041e-02, -1.402e-01, 8.977e-02, -8.210e-02, 1.448e-01, -4.122e-01, -3.547e-02, 1.097e-03, 3.094e-02, 2.710e-03, -6.821e-02, 1.405e-01), r0);
	r1 = MulAdd(s0_0_2, M4(4.528e-02, -2.049e-01, 3.548e-02, -3.209e-03, 4.600e-02, 2.014e-01, -1.952e-02, 5.476e-02, -1.712e-01, -1.112e-01, -7.643e-02, -3.147e-01, 2.594e-03, 9.728e-02, 5.439e-04, -1.572e-01), r1);
	r2 = MulAdd(s0_0_2, M4(1.322e-01, -4.896e-02, 3.055e-02, 6.800e-02, -1.187e-02, -9.182e-03, 2.089e-02, 1.001e-01, -1.363e-02, 1.372e-03, -7.296e-02, -2.705e-01, -1.140e-01, -2.800e-02, 2.638e-02, 2.419e-01), r2);
	r3 = MulAdd(s0_0_2, M4(-4.968e-02, -5.578e-02, 4.635e-02, -1.004e-02, -1.230e-02, -1.782e-03, 1.124e-02, -1.062e-01, -1.861e-01, 4.861e-02, -1.169e-02, -1.337e-02, -1.665e-01, 2.148e-02, 3.667e-02, -2.326e-02), r3);
	r0 = MulAdd(s0_1_0, M4(7.644e-02, -3.188e-01, -1.401e-01, -3.613e-01, 1.067e-01, 2.599e-01, 3.078e-01, 1.362e-01, -1.382e-01, 1.384e-01, -2.454e-02, -3.560e-02, 4.077e-02, 3.274e-02, 4.487e-02, 5.733e-02), r0);
	r1 = MulAdd(s0_1_0, M4(-6.129e-02, 1.563e-01, -8.202e-02, 6.703e-02, -1.114e-02, 1.995e-02, 1.526e-02, -4.406e-02, -1.241e-01, 1.256e-01, 4.497e-02, 1.564e-01, -1.277e-02, 5.890e-03, 8.156e-03, 4.301e-02), r1);
	r2 = MulAdd(s0_1_0, M4(7.849e-02, 6.458e-03, 6.630e-03, -1.635e-01, -3.300e-01, 2.363e-02, 4.198e-02, 9.953e-03, -1.509e-01, -1.157e-01, -2.212e-01, 6.328e-02, 4.215e-02, -2.320e-02, 2.359e-02, -2.224e-02), r2);
	r3 = MulAdd(s0_1_0, M4(1.825e-01, -5.206e-02, 1.159e-01, 9.301e-02, -7.233e-02, -6.685e-03, 2.327e-01, 4.116e-02, 3.053e-01, -1.067e-01, 8.498e-02, 3.195e-01, -5.515e-02, 1.050e-02, -5.171e-03, -7.396e-02), r3);
	r0 = MulAdd(s0_1_1, M4(2.822e-01, 1.341e-01, 1.264e-01, -2.711e-01, -1.322e-01, -2.408e-01, 1.965e-01, -2.900e-01, 1.824e-02, 1.211e-01, 5.013e-02, 4.606e-01, 1.189e-02, -1.960e-01, 2.042e-01, -2.253e-02), r0);
	r1 = MulAdd(s0_1_1, M4(-7.823e-02, 9.734e-02, -5.189e-02, -3.964e-02, -2.510e-01, -3.134e-01, 1.601e-01, 4.233e-01, -5.823e-02, 1.410e-01, -2.728e-01, -5.005e-03, 1.834e-01, 1.057e-01, -4.848e-02, -1.887e-01), r1);
	r2 = MulAdd(s0_1_1, M4(3.289e-02, 5.907e-03, -1.234e-01, -3.292e-01, 1.058e+00, -1.529e-01, 1.042e-01, -4.950e-01, -7.259e-01, 3.606e-01, 3.703e-01, 3.394e-01, -8.607e-02, -1.108e-01, -1.085e-02, -1.360e-01), r2);
	r3 = MulAdd(s0_1_1, M4(-7.514e-02, 9.963e-02, -3.845e-02, 1.092e-01, 3.325e-01, 5.651e-02, -2.316e-01, 2.443e-01, -5.166e-02, 2.589e-02, 1.411e-01, 4.058e-01, -2.861e-01, -4.667e-02, 1.675e-01, -8.307e-02), r3);
	r0 = MulAdd(s0_1_2, M4(4.328e-02, 4.270e-02, -3.197e-02, 4.408e-02, 4.936e-02, -7.399e-02, -1.464e-01, 3.995e-02, -2.276e-02, 1.752e-01, 3.931e-02, -2.522e-02, -3.368e-02, 2.026e-01, 3.148e-01, -5.858e-02), r0);
	r1 = MulAdd(s0_1_2, M4(8.391e-02, -9.627e-02, -4.981e-02, -4.425e-02, 6.787e-02, -1.238e-02, -4.283e-02, -9.281e-02, -1.180e-01, -1.690e-01, 1.373e-01, -4.308e-01, -1.990e-01, -1.212e-02, 8.418e-02, 4.569e-01), r1);
	r2 = MulAdd(s0_1_2, M4(-8.348e-02, -4.996e-05, 2.012e-02, 8.968e-02, -6.598e-02, 1.919e-02, -4.698e-02, 1.563e-01, 1.776e-01, -2.686e-01, -3.378e-01, -2.572e-01, 1.284e+00, -1.245e-01, 4.371e-02, -5.282e-01), r2);
	r3 = MulAdd(s0_1_2, M4(7.637e-02, -1.159e-02, 2.048e-02, 7.349e-02, 9.171e-03, 4.610e-03, 3.335e-02, -2.658e-02, 9.131e-02, 5.050e-02, 1.521e-01, 3.604e-01, -3.753e-02, -6.903e-03, -1.092e-01, -5.029e-02), r3);
	r0 = MulAdd(s0_2_0, M4(-3.441e-03, -1.740e-02, 1.082e-01, 7.345e-02, -8.345e-02, 1.199e-01, 2.092e-01, 1.875e-02, -5.602e-02, -9.517e-02, -1.687e-02, -6.940e-02, -2.861e-02, -2.070e-02, -9.377e-02, -1.605e-02), r0);
	r1 = MulAdd(s0_2_0, M4(-5.354e-02, -1.618e-01, 5.823e-02, -6.546e-02, -5.124e-03, -7.898e-02, 7.217e-02, 1.291e-03, -2.367e-02, -2.240e-01, -6.943e-02, 1.452e-01, 4.003e-03, 1.072e-01, 2.960e-02, 2.991e-02), r1);
	r2 = MulAdd(s0_2_0, M4(-4.223e-02, -6.257e-02, -2.620e-02, 1.205e-02, -9.487e-02, 4.820e-02, 4.449e-02, 1.966e-01, -1.046e-01, 7.834e-02, 1.797e-02, -1.268e-01, -2.750e-02, 2.929e-02, 4.819e-02, 3.435e-02), r2);
	r3 = MulAdd(s0_2_0, M4(4.515e-02, 5.433e-02, -7.239e-02, -1.145e-01, -5.142e-02, 4.777e-02, -1.766e-02, -7.526e-02, -1.771e-01, -4.487e-02, -6.856e-02, 1.872e-02, 4.895e-02, 3.239e-02, -3.676e-02, -2.286e-02), r3);
	r0 = MulAdd(s0_2_1, M4(2.738e-02, -4.071e-02, 1.199e-01, -8.919e-03, 2.352e-02, 8.427e-02, -3.019e-01, -4.260e-02, -1.008e-01, -7.361e-02, 3.589e-02, -1.622e-01, -9.829e-03, -3.717e-03, -1.973e-02, 7.542e-02), r0);
	r1 = MulAdd(s0_2_1, M4(2.026e-02, -1.538e-01, 1.137e-01, 6.923e-02, 1.989e-01, -6.021e-02, -6.470e-02, -1.738e-01, 3.096e-02, 1.238e-01, 1.263e-02, 2.323e-01, -2.715e-03, -1.042e-01, 3.707e-02, -1.106e-01), r1);
	r2 = MulAdd(s0_2_1, M4(-1.520e-01, 1.000e-01, 1.170e-01, -7.272e-02, -4.451e-02, 4.370e-02, -4.981e-02, 1.298e-01, -3.912e-01, 9.328e-02, 1.127e-01, 1.423e-01, 1.909e-01, 1.071e-01, 3.507e-03, 1.416e-01), r2);
	r3 = MulAdd(s0_2_1, M4(-7.993e-02, 1.371e-01, 1.440e-01, 1.744e-02, -2.579e-02, -1.294e-01, 1.339e-02, 7.226e-02, 6.843e-03, 1.007e-01, 3.133e-02, -4.163e-02, 1.564e-01, 6.499e-03, 3.009e-04, 1.653e-01), r3);
	r0 = MulAdd(s0_2_2, M4(-1.552e-02, 3.158e-02, 3.649e-02, 5.150e-02, -2.377e-02, -4.307e-02, 1.686e-02, 1.262e-01, -7.875e-03, -1.444e-01, 7.235e-02, -2.069e-01, 3.733e-02, 7.291e-02, -1.597e-01, -1.178e-02), r0);
	r1 = MulAdd(s0_2_2, M4(-3.115e-03, 3.027e-01, 4.782e-02, 2.884e-02, 2.370e-04, 3.058e-01, 2.475e-03, 3.804e-02, 1.758e-01, 5.791e-02, 1.450e-02, -1.590e-01, 1.848e-02, -2.152e-01, -7.662e-03, 5.295e-02), r1);
	r2 = MulAdd(s0_2_2, M4(1.668e-01, 6.535e-02, 1.100e-02, 2.658e-03, 9.049e-02, 6.109e-04, -1.145e-02, -1.598e-01, 5.134e-02, 2.099e-01, -1.005e-02, 7.956e-03, 3.372e-03, 8.336e-02, -3.307e-02, 1.162e-01), r2);
	r3 = MulAdd(s0_2_2, M4(5.632e-02, 6.188e-02, 2.411e-03, -5.066e-02, -2.540e-02, 6.312e-02, -3.425e-02, -6.262e-03, -7.995e-02, 9.525e-02, -2.053e-02, 1.388e-01, 3.157e-01, 3.314e-03, 5.117e-02, -4.636e-02), r3);
	r0 = MulAdd(s1_0_0, M4(8.590e-02, 6.446e-01, -1.562e-01, 2.913e-01, 5.344e-02, -1.400e-02, -7.898e-02, -4.315e-02, -6.779e-02, -4.896e-02, 1.785e-01, 3.291e-01, 4.195e-02, -2.473e-01, 5.653e-01, -2.298e-01), r0);
	r1 = MulAdd(s1_0_0, M4(3.283e-03, 3.397e-01, 1.421e-01, 8.505e-02, -3.484e-02, -8.960e-02, 1.213e-03, 4.603e-02, -2.324e-02, 1.609e-01, -1.153e-02, -2.822e-02, -4.412e-02, -1.046e-01, -9.889e-02, -8.732e-02), r1);
	r2 = MulAdd(s1_0_0, M4(2.913e-01, -1.222e-01, 3.583e-02, 2.901e-01, 9.858e-03, 1.897e-02, 1.378e-02, 1.777e-02, 9.261e-02, 3.423e-02, -1.856e-02, 1.296e-01, -2.358e-01, 4.279e-02, -4.946e-02, -1.802e-01), r2);
	r3 = MulAdd(s1_0_0, M4(-1.303e-01, 5.682e-02, -8.349e-02, -1.316e-01, 4.387e-03, -1.813e-02, 5.861e-03, -4.724e-02, -7.610e-02, -3.493e-02, 1.158e-01, 8.360e-02, -2.305e-02, -6.356e-02, 4.536e-02, 2.333e-04), r3);
	r0 = MulAdd(s1_0_1, M4(1.886e-01, -2.109e+00, 1.531e-01, 6.373e-01, -1.433e-02, -3.447e-01, -2.173e-01, -6.519e-01, -2.606e-02, 1.638e-02, -9.177e-02, -1.945e-02, 2.009e-01, 1.401e+00, -3.765e-01, -4.028e-01), r0);
	r1 = MulAdd(s1_0_1, M4(-1.465e-01, 2.076e-02, 5.545e-02, -6.316e-03, -4.264e-02, -2.307e-01, -1.870e-01, -3.086e-02, -5.718e-03, -2.829e-02, -3.083e-02, -2.822e-02, 4.843e-02, -2.177e-01, -3.814e-02, 4.116e-02), r1);
	r2 = MulAdd(s1_0_1, M4(-2.086e+00, 1.872e-01, -5.732e-03, -3.458e-01, 1.238e-01, 1.294e-01, 3.202e-02, 5.365e-03, -1.686e-01, -1.087e-01, -1.662e-02, 1.399e-03, -3.471e-01, -3.993e-02, 2.143e-02, 2.669e-01), r2);
	r3 = MulAdd(s1_0_1, M4(-2.883e-01, 3.230e-02, 2.048e-01, 4.064e-01, 1.489e-01, 3.925e-02, 5.505e-04, 4.449e-02, -1.532e-01, 3.364e-02, 5.054e-02, -9.420e-02, 5.333e-01, 6.590e-02, -1.114e-01, 1.348e-01), r3);
	r0 = MulAdd(s1_0_2, M4(1.298e-01, 3.448e-01, 4.583e-02, -3.943e-01, 1.185e-01, 1.880e-01, 4.143e-02, -2.658e-01, 7.347e-02, -6.135e-02, 1.325e-01, 2.322e-02, -1.175e-01, -3.123e-01, -1.407e-01, 5.234e-02), r0);
	r1 = MulAdd(s1_0_2, M4(-1.979e-02, 2.021e-01, -4.016e-02, 2.298e-01, 7.370e-02, 1.988e-01, -8.363e-02, -9.523e-02, 2.068e-02, 1.270e-01, 1.553e-02, 4.099e-02, 6.799e-03, -7.873e-03, 5.223e-03, -1.243e-01), r1);
	r2 = MulAdd(s1_0_2, M4(1.096e-01, -7.746e-02, 4.447e-03, 1.628e-01, 2.117e-02, 3.944e-02, -2.861e-02, 2.252e-01, 8.573e-02, 3.821e-02, 1.955e-02, 8.737e-02, 6.246e-02, 6.978e-02, -7.156e-02, -8.768e-03), r2);
	r3 = MulAdd(s1_0_2, M4(-3.799e-02, 1.227e-01, 1.251e-01, 1.062e-01, 1.091e-01, 6.674e-03, 3.364e-02, 6.860e-02, -1.653e-01, 1.453e-02, 2.911e-02, -4.285e-03, 7.726e-02, -7.650e-02, -1.557e-01, -4.493e-02), r3);
	r0 = MulAdd(s1_1_0, M4(-3.083e-02, 4.518e-01, 3.588e-01, -6.674e-03, -1.361e-02, 1.228e-01, 1.703e-01, 7.338e-02, 3.786e-02, -8.608e-02, 2.132e-01, 1.182e-01, 1.162e-02, -4.454e-01, -2.803e-01, 2.054e-02), r0);
	r1 = MulAdd(s1_1_0, M4(5.440e-02, 2.882e-01, 9.738e-03, -8.764e-02, 3.207e-02, -5.865e-02, 7.816e-02, -9.482e-03, -7.152e-02, 3.287e-02, 3.915e-03, -7.841e-02, 8.568e-02, -2.441e-01, -4.014e-02, 1.348e-01), r1);
	r2 = MulAdd(s1_1_0, M4(-5.256e-03, -1.542e-01, -1.667e-02, 3.608e-01, -7.057e-02, -7.674e-02, 2.369e-02, -7.990e-02, 4.029e-02, -3.501e-02, -4.831e-02, -1.920e-01, -1.186e-01, 8.967e-02, 1.649e-01, -4.230e-01), r2);
	r3 = MulAdd(s1_1_0, M4(-1.430e-01, 1.830e-01, -1.105e-01, -4.369e-02, 1.369e-02, 4.272e-02, -8.044e-03, 1.470e-01, -9.788e-02, -1.499e-01, 2.202e-01, 4.566e-02, -2.410e-01, -9.067e-02, 3.203e-02, -2.609e-02), r3);
	r0 = MulAdd(s1_1_1, M4(1.067e-01, -3.503e-01, -2.760e-02, -1.379e-02, 1.051e-01, 3.311e-01, -7.684e-02, 8.766e-01, -3.458e-02, 2.510e-01, 1.979e-01, -3.646e-02, -1.858e-01, 5.394e-01, 3.106e-01, 2.397e-01), r0);
	r1 = MulAdd(s1_1_1, M4(3.197e-01, -1.500e-01, 2.521e-02, 1.636e-01, -1.033e-01, 2.398e-01, 3.494e-01, 3.679e-02, -1.109e-01, -1.474e-01, 9.027e-02, 4.312e-01, -2.339e-01, 2.027e-01, 1.052e-01, -3.154e-01), r1);
	r2 = MulAdd(s1_1_1, M4(6.006e-01, 1.354e+00, 4.021e-01, -7.664e-01, -1.559e+00, -2.173e-01, -5.332e-02, -4.475e-03, -2.471e-01, 3.819e-02, 1.863e-02, -1.063e+00, 1.016e-01, -5.791e-01, 9.918e-02, 2.343e-01), r2);
	r3 = MulAdd(s1_1_1, M4(6.406e-01, -3.668e-01, 1.679e-02, -1.108e-01, 7.032e-02, -1.184e-01, 1.200e-01, -7.445e-02, 6.042e-02, 4.724e-02, -9.900e-02, 4.694e-02, -2.629e-01, 1.798e-01, -5.048e-03, -1.015e-01), r3);
	r0 = MulAdd(s1_1_2, M4(8.428e-02, 6.548e-02, 3.540e-02, 2.329e-02, 5.127e-02, -1.418e-02, -2.721e-03, 1.628e-01, 5.499e-03, -1.984e-02, 2.535e-02, 6.768e-02, 4.668e-02, -4.796e-02, 7.106e-03, -1.008e-01), r0);
	r1 = MulAdd(s1_1_2, M4(3.981e-03, 1.112e-02, 1.574e-01, 5.762e-01, -1.239e-02, 6.809e-02, -6.896e-02, -3.177e-01, 5.026e-03, -5.891e-02, 1.612e-02, 1.674e-01, -9.108e-02, -9.134e-02, -1.350e-01, -5.646e-01), r1);
	r2 = MulAdd(s1_1_2, M4(-6.782e-02, -2.965e-01, 1.909e-01, -5.972e-01, 6.113e-01, -2.444e-01, 3.964e-01, 3.611e-01, 4.087e-02, -2.058e-02, 6.873e-03, -2.157e-01, 1.006e-01, -3.880e-02, -1.812e-01, 7.580e-01), r2);
	r3 = MulAdd(s1_1_2, M4(2.522e-01, 3.481e-01, -1.088e-01, -3.026e-03, -4.697e-01, 3.947e-01, 3.983e-01, -4.409e-02, 3.814e-02, 5.166e-02, -1.426e-02, 1.209e-02, -1.859e-01, -1.697e-01, -4.793e-03, 6.215e-02), r3);
	r0 = MulAdd(s1_2_0, M4(1.952e-02, 4.982e-02, 1.804e-01, -6.010e-03, -6.692e-03, 1.580e-02, -5.834e-02, 1.424e-02, 2.367e-02, -7.740e-02, -1.878e-01, -4.992e-02, 1.608e-02, -8.000e-02, -2.182e-01, -3.585e-03), r0);
	r1 = MulAdd(s1_2_0, M4(-5.286e-02, 2.543e-02, 4.943e-02, 9.389e-02, 1.554e-02, 1.438e-01, 8.916e-03, -1.562e-02, -1.895e-02, -1.616e-01, -4.114e-02, -2.120e-02, 2.577e-02, 1.606e-01, -3.357e-02, -7.358e-02), r1);
	r2 = MulAdd(s1_2_0, M4(-8.867e-03, -2.777e-02, 4.543e-02, -7.082e-02, 1.417e-02, 8.475e-02, 9.305e-03, 1.021e-01, 1.038e-01, 5.998e-02, -6.058e-02, 2.488e-01, 6.615e-02, 9.113e-03, -1.665e-02, 7.179e-02), r2);
	r3 = MulAdd(s1_2_0, M4(-2.409e-02, 2.611e-02, 5.133e-02, 1.302e-02, 1.205e-02, 3.518e-04, 1.755e-02, -7.916e-02, 2.915e-02, -3.326e-02, -2.580e-02, 2.156e-02, 9.929e-02, -1.622e-03, 1.013e-02, -2.371e-02), r3);
	r0 = MulAdd(s1_2_1, M4(4.767e-02, 7.510e-02, 2.011e-01, 1.847e-01, -4.509e-02, -7.002e-02, 9.189e-02, -1.448e-01, 3.111e-02, 7.032e-02, -2.681e-01, -5.318e-02, -7.030e-02, -8.563e-02, -1.796e-01, -1.251e-01), r0);
	r1 = MulAdd(s1_2_1, M4(-1.271e-01, -9.853e-01, 1.319e-01, 3.567e-02, 3.101e-02, 7.076e-02, -1.236e-01, 3.070e-02, 4.357e-02, -2.898e-02, -1.116e-01, -8.939e-03, 8.357e-02, -2.395e-01, -8.345e-02, -1.808e-02), r1);
	r2 = MulAdd(s1_2_1, M4(-2.497e-01, -1.394e-01, -4.539e-02, 2.409e-01, -7.993e-02, 2.056e-01, 5.284e-02, 9.221e-02, -2.481e-01, -3.402e-02, -1.470e-01, -3.935e-01, 4.913e-01, 1.634e-01, 2.764e-02, -3.063e-01), r2);
	r3 = MulAdd(s1_2_1, M4(3.388e-01, 1.049e-01, 1.624e-01, -3.237e-02, -2.088e-02, -1.193e-01, 1.806e-02, 1.843e-02, 3.467e-01, 1.174e-02, -1.018e-02, 4.780e-02, -3.447e-01, -3.825e-02, -1.192e-01, 8.464e-02), r3);
	r0 = MulAdd(s1_2_2, M4(-1.790e-02, 3.436e-02, -3.892e-02, 2.130e-02, -7.407e-02, -1.502e-01, -5.785e-02, 1.875e-01, 2.017e-02, 3.597e-02, 5.933e-02, 5.028e-03, 4.882e-02, 1.480e-02, 1.415e-01, 1.154e-02), r0);
	r1 = MulAdd(s1_2_2, M4(9.266e-03, 1.369e-02, 1.440e-01, 6.384e-02, 9.747e-02, -1.519e+00, 3.479e-02, 4.290e-01, -3.234e-02, -4.162e-02, -4.677e-02, 5.042e-02, -5.550e-02, -5.337e-02, -1.375e-01, -1.024e-02), r1);
	r2 = MulAdd(s1_2_2, M4(-1.485e-01, -1.891e-01, -3.192e-02, 6.855e-02, 7.573e-02, 2.458e-01, 1.548e-01, -1.058e-01, -9.684e-02, 2.327e-02, -1.933e-02, -2.536e-01, 8.048e-02, 9.276e-02, -2.970e-04, -9.124e-02), r2);
	r3 = MulAdd(s1_2_2, M4(1.393e-01, 6.669e-02, -1.039e-02, -2.546e-02, 4.449e-01, 2.055e-01, 1.818e-01, -1.091e-01, 6.765e-02, -1.250e-02, 1.981e-02, 6.152e-03, -1.239e-02, -5.312e-02, 6.984e-02, 3.254e-02), r3);
	r0 = max(r0, 0.0);
	T4[gxy] = r0;
	r1 = max(r1, 0.0);
	T5[gxy] = r1;
	r2 = max(r2, 0.0);
	T6[gxy] = r2;
	r3 = max(r3, 0.0);
	T7[gxy] = r3;
}

//!PASS 3
//!DESC conv2 (16x16)
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN T4, T5, T6, T7
//!OUT T0, T1, T2, T3

#define L0(x, y) V4(O(T4, x, y))
#define L1(x, y) V4(O(T5, x, y))
#define L2(x, y) V4(O(T6, x, y))
#define L3(x, y) V4(O(T7, x, y))

void Pass3(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 sz = GetInputSize();
	if (gxy.x >= sz.x || gxy.y >= sz.y)
		return;
	float2 pos = (gxy + 0.5) * pt;
	V4 s0_0_0, s0_0_1, s0_0_2, s0_1_0, s0_1_1, s0_1_2, s0_2_0, s0_2_1, s0_2_2, s1_0_0, s1_0_1, s1_0_2, s1_1_0, s1_1_1, s1_1_2, s1_2_0, s1_2_1, s1_2_2;
	V4 r0 = 0.0, r1 = 0.0, r2 = 0.0, r3 = 0.0;
	s0_0_0 = L0(-1.0, -1.0); s0_0_1 = L0(0.0, -1.0); s0_0_2 = L0(1.0, -1.0);
	s0_1_0 = L0(-1.0, 0.0); s0_1_1 = L0(0.0, 0.0); s0_1_2 = L0(1.0, 0.0);
	s0_2_0 = L0(-1.0, 1.0); s0_2_1 = L0(0.0, 1.0); s0_2_2 = L0(1.0, 1.0);
	s1_0_0 = L1(-1.0, -1.0); s1_0_1 = L1(0.0, -1.0); s1_0_2 = L1(1.0, -1.0);
	s1_1_0 = L1(-1.0, 0.0); s1_1_1 = L1(0.0, 0.0); s1_1_2 = L1(1.0, 0.0);
	s1_2_0 = L1(-1.0, 1.0); s1_2_1 = L1(0.0, 1.0); s1_2_2 = L1(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(2.280e-01, 3.142e-02, -2.462e-03, 4.608e-02, 7.106e-02, -2.100e-02, 1.649e-02, 1.485e-01, -8.086e-02, 3.780e-02, 5.362e-03, -1.636e-01, 5.972e-02, -9.601e-02, 9.286e-05, 5.711e-02), r0);
	r1 = MulAdd(s0_0_0, M4(2.583e-02, 8.885e-02, -2.661e-02, -4.298e-02, 2.144e-03, 2.062e-02, -1.093e-01, -1.727e-02, -2.909e-05, -1.012e-03, -1.872e-02, 1.061e-02, -4.150e-03, -8.715e-02, -9.618e-02, -5.593e-03), r1);
	r2 = MulAdd(s0_0_0, M4(3.558e-02, -1.547e-02, 1.493e-02, 7.790e-03, 1.413e-03, -3.225e-02, 3.432e-03, -4.200e-02, 2.047e-01, 6.179e-02, -2.937e-03, 1.832e-02, -6.078e-02, -9.019e-02, -9.351e-03, 7.399e-02), r2);
	r3 = MulAdd(s0_0_0, M4(5.116e-02, -1.153e-02, 1.443e-01, 3.713e-02, 1.998e-02, 1.328e-02, 3.923e-02, 1.057e-02, -1.027e-03, -4.707e-03, -6.323e-02, 3.565e-03, 2.131e-03, -1.062e-02, 3.518e-02, -3.173e-02), r3);
	r0 = MulAdd(s0_0_1, M4(-1.484e-01, -1.541e-01, 2.814e-03, 3.819e-01, 1.554e-01, -2.059e-01, 6.602e-02, 1.415e-01, -6.692e-02, 6.492e-03, -2.031e-02, -6.808e-02, -1.270e-02, -2.721e-01, -3.039e-02, 1.216e-02), r0);
	r1 = MulAdd(s0_0_1, M4(-2.199e-02, 7.055e-02, 8.615e-02, -1.548e-02, 1.180e-02, -4.015e-02, -5.721e-03, 4.297e-02, -6.240e-02, -4.094e-02, 6.776e-02, 3.686e-02, -2.720e-02, -6.631e-02, -8.285e-02, 1.592e-02), r1);
	r2 = MulAdd(s0_0_1, M4(1.647e-02, 2.141e-04, 4.215e-02, 9.833e-02, 4.901e-02, -1.240e-01, -5.741e-03, -3.172e-02, -1.130e-01, 3.738e-02, -1.807e-03, -6.770e-02, 4.715e-02, 3.980e-02, 4.328e-03, 1.543e-02), r2);
	r3 = MulAdd(s0_0_1, M4(-3.302e-02, 5.789e-02, 3.719e-02, 1.009e-01, 2.199e-02, 4.850e-03, -1.706e-02, -4.652e-02, 1.016e-01, -1.855e-03, 8.655e-03, -3.699e-02, 6.966e-02, -3.585e-02, 2.135e-02, 4.408e-02), r3);
	r0 = MulAdd(s0_0_2, M4(2.159e-01, 3.301e-02, 3.838e-02, -1.470e-01, 7.407e-02, -4.257e-01, 2.269e-02, -7.758e-02, 8.055e-03, 2.167e-01, 9.599e-02, 1.603e-01, -1.155e-02, -3.701e-01, 2.037e-01, -8.981e-02), r0);
	r1 = MulAdd(s0_0_2, M4(1.100e-01, 1.579e-02, -2.023e-02, 1.206e-01, -9.749e-03, -2.485e-03, 5.689e-02, 2.210e-02, 2.862e-02, 2.583e-03, -8.139e-02, -2.858e-02, 1.985e-04, -2.318e-02, 3.317e-02, 6.718e-02), r1);
	r2 = MulAdd(s0_0_2, M4(1.694e-01, 1.570e-01, 5.747e-02, -3.600e-02, 7.474e-02, -2.176e-01, -3.144e-03, -5.313e-02, -5.694e-02, 1.064e-02, -2.709e-02, 2.479e-02, -1.070e-02, 8.410e-02, 4.480e-02, 8.410e-02), r2);
	r3 = MulAdd(s0_0_2, M4(-5.769e-02, 1.033e-01, -1.346e-01, 2.584e-02, 7.641e-02, -1.704e-02, -7.507e-02, 1.710e-02, 4.137e-02, -3.601e-02, 7.685e-02, -1.108e-02, -7.248e-02, 5.382e-02, -8.207e-02, 1.480e-02), r3);
	r0 = MulAdd(s0_1_0, M4(-1.472e-01, 2.604e-02, -6.287e-02, -7.379e-02, 1.263e-01, 2.861e-01, 1.141e-01, 9.021e-02, -3.720e-02, -1.220e-02, -5.243e-02, -7.408e-02, -3.370e-02, 1.213e-01, 7.462e-03, 1.406e-01), r0);
	r1 = MulAdd(s0_1_0, M4(6.308e-02, -1.492e-01, -5.474e-02, -1.111e-01, 2.407e-02, -3.634e-02, -1.403e-02, 4.546e-02, -2.537e-02, 5.561e-02, 3.324e-02, 4.848e-04, -1.029e-02, -6.006e-02, -9.211e-02, 3.369e-02), r1);
	r2 = MulAdd(s0_1_0, M4(1.665e-01, 1.751e-01, 1.170e-01, 1.277e-01, -1.208e-01, -1.472e-01, -5.526e-03, -8.476e-02, 3.082e-01, 8.377e-02, 1.124e-02, 1.696e-01, -2.764e-01, 1.004e-01, 3.121e-02, -1.447e-02), r2);
	r3 = MulAdd(s0_1_0, M4(6.341e-02, -4.223e-02, 1.610e-01, 3.409e-01, 1.603e-02, 8.523e-04, -8.531e-02, -4.474e-02, -6.208e-02, -1.200e-03, 1.842e-02, 1.909e-02, -2.392e-02, -2.712e-03, 4.794e-02, 3.430e-02), r3);
	r0 = MulAdd(s0_1_1, M4(-4.092e-01, -2.945e-01, -1.511e-01, 1.619e-01, 5.263e-02, -9.498e-02, 1.792e-01, 2.514e-01, -1.289e-01, 1.890e-01, -9.641e-02, 4.114e-02, 7.318e-02, 4.604e-01, -8.922e-03, 9.630e-02), r0);
	r1 = MulAdd(s0_1_1, M4(2.550e-01, -5.581e-02, 4.011e-01, 3.956e-01, 1.081e-01, -9.588e-02, 1.143e-01, 2.119e-02, 7.353e-02, 3.260e-01, -1.393e-01, -5.796e-02, -1.065e-02, -1.762e-01, -1.121e-01, 1.384e-01), r1);
	r2 = MulAdd(s0_1_1, M4(-3.334e-01, -3.779e-01, 1.381e-02, -3.031e-01, -2.496e+00, -8.652e-02, -1.658e-02, -1.262e-01, 2.896e-02, -2.930e-01, -4.364e-02, 1.345e-01, 3.020e-01, 1.870e-01, 1.555e-02, -4.397e-02), r2);
	r3 = MulAdd(s0_1_1, M4(-6.661e-02, 3.389e-01, -2.642e-01, -1.635e-02, -5.841e-01, -3.159e-02, -4.287e-01, -1.073e-01, -2.357e-01, 5.493e-03, -1.478e-02, -1.329e-01, 1.995e-01, 1.748e-02, -2.418e-01, 9.113e-02), r3);
	r0 = MulAdd(s0_1_2, M4(1.724e-01, 1.077e-02, 1.860e-01, -2.385e-01, 3.181e-02, 2.167e-01, 2.916e-01, -7.652e-01, 6.070e-02, 3.187e-04, -2.547e-01, 2.288e-01, -2.615e-02, 1.088e-01, 3.297e-02, -9.105e-02), r0);
	r1 = MulAdd(s0_1_2, M4(-4.227e-02, -2.839e-03, 1.309e-01, 9.999e-03, -1.452e-01, -5.010e-01, 8.793e-02, 8.763e-02, -2.312e-02, 4.683e-02, -2.672e-01, 2.717e-02, 1.168e-01, -1.420e-01, 2.304e-01, 1.675e-01), r1);
	r2 = MulAdd(s0_1_2, M4(1.441e-01, 1.994e-01, 1.199e-01, -3.137e-01, 1.098e-01, -1.841e-01, -2.059e-02, -8.479e-02, 5.564e-03, -2.068e-01, -5.036e-02, 3.017e-01, 1.137e-01, 3.453e-01, 6.863e-02, 1.715e-01), r2);
	r3 = MulAdd(s0_1_2, M4(-1.548e-01, 8.510e-02, -2.176e-01, 1.976e-02, 1.213e-01, -2.961e-02, -6.145e-02, 3.709e-03, -9.389e-02, -9.352e-02, 3.155e-02, 7.282e-03, -9.098e-02, 8.690e-02, -1.964e-02, -1.956e-02), r3);
	r0 = MulAdd(s0_2_0, M4(-1.114e-01, -3.050e-01, 1.070e-01, 1.127e-01, -7.824e-02, 5.131e-01, 1.794e-01, 8.204e-02, 1.264e-02, -5.176e-02, 1.023e-02, -5.262e-02, -1.675e-01, -1.325e-01, 1.293e-01, -1.025e-01), r0);
	r1 = MulAdd(s0_2_0, M4(-1.220e-01, -6.612e-02, -3.490e-01, 5.973e-02, 1.554e-02, -2.354e-02, -2.801e-02, 1.825e-02, 6.566e-03, -4.009e-02, 4.042e-02, 3.337e-03, -2.712e-02, 5.823e-02, -1.053e-01, 4.315e-02), r1);
	r2 = MulAdd(s0_2_0, M4(-2.881e-02, 1.900e-01, 1.371e-02, -3.080e-02, -1.759e-01, -4.715e-02, 2.872e-02, -1.194e-01, 2.559e-01, 6.663e-02, -5.340e-03, -5.654e-02, -9.719e-02, 1.074e-01, 3.449e-02, -1.134e-01), r2);
	r3 = MulAdd(s0_2_0, M4(2.166e-01, -5.309e-02, 2.362e-01, 2.075e-01, -6.164e-02, 3.953e-03, 3.462e-02, -3.465e-03, 1.313e-01, -1.572e-03, 1.058e-02, 2.683e-03, -2.892e-02, -6.471e-03, 8.554e-02, 5.181e-02), r3);
	r0 = MulAdd(s0_2_1, M4(-2.218e-01, -4.179e-02, 3.306e-01, -2.950e-01, -1.835e-01, 5.368e-01, 2.504e-02, 1.793e-03, 3.879e-02, -2.274e-01, -9.249e-02, 8.690e-03, 1.626e-01, -3.080e-01, 3.783e-01, 1.771e-02), r0);
	r1 = MulAdd(s0_2_1, M4(1.632e-02, -8.989e-02, 6.762e-02, 5.175e-02, -2.761e-02, 5.435e-02, 7.028e-02, -2.191e-02, -1.388e-02, 5.868e-02, 3.038e-01, 2.124e-03, -1.138e-02, 2.939e-01, -3.453e-01, 9.989e-02), r1);
	r2 = MulAdd(s0_2_1, M4(-2.919e-01, 1.957e-01, -1.654e-01, 2.324e-01, 1.255e-01, -2.671e-02, 1.088e-02, -4.908e-01, -1.488e-01, 7.268e-03, 4.454e-02, 4.731e-03, -5.627e-01, 3.291e-01, 8.423e-02, 1.165e-01), r2);
	r3 = MulAdd(s0_2_1, M4(4.184e-02, -2.359e-01, 1.367e-01, 1.006e-01, -7.176e-02, 1.118e-02, 3.253e-02, 3.455e-02, 1.272e-01, 9.400e-04, -1.013e-01, 8.311e-03, 1.553e-02, 4.660e-02, 3.408e-01, 6.423e-02), r3);
	r0 = MulAdd(s0_2_2, M4(3.840e-02, 7.465e-02, -3.264e+00, 9.526e-03, 2.597e-01, -9.349e-02, -1.131e+00, 1.425e-01, -2.407e-01, -1.280e-01, -3.727e+00, -5.581e-02, 1.300e-02, 3.318e-02, -2.885e+00, -3.496e-01), r0);
	r1 = MulAdd(s0_2_2, M4(-5.633e-02, 2.165e-01, -1.426e-01, 2.001e-02, -7.851e-02, 1.510e-01, 7.779e-02, -6.340e-02, 1.203e-02, -1.283e-01, 1.335e-01, 2.722e-02, -8.855e-02, 3.383e-01, -1.326e-01, 7.045e-02), r1);
	r2 = MulAdd(s0_2_2, M4(1.857e-01, 1.231e-02, 7.501e-02, -1.018e-01, 1.272e-01, -8.672e-02, 2.095e-02, 4.763e-03, -7.701e-02, 2.041e-01, -3.214e-02, 4.398e-02, -2.731e-02, -2.775e-02, 1.121e-01, 1.903e-01), r2);
	r3 = MulAdd(s0_2_2, M4(1.491e-03, 5.077e-02, 4.728e-02, 2.788e-02, -1.237e-01, 2.231e-02, -1.617e-01, 2.279e-02, -7.483e-02, -2.528e-02, 3.651e-02, 1.712e-02, -2.524e-02, 8.091e-02, 4.383e-02, 2.816e-03), r3);
	r0 = MulAdd(s1_0_0, M4(-7.686e-02, -3.481e-01, -3.152e-02, -7.432e-02, -1.913e-01, -3.378e-01, -9.900e-02, -2.158e-01, -8.341e-02, 3.135e-01, -4.626e-02, -3.091e-02, 2.195e-01, 4.276e-01, -6.120e-02, -3.233e-03), r0);
	r1 = MulAdd(s1_0_0, M4(-9.103e-02, 1.228e-02, -1.897e-02, 1.287e-03, 3.121e-02, 1.963e-01, 5.236e-02, 1.440e-02, -2.495e-02, -6.195e-02, 2.691e-01, -4.234e-02, 7.690e-02, -2.551e-01, -5.135e-03, 6.949e-02), r1);
	r2 = MulAdd(s1_0_0, M4(2.224e-02, -8.845e-03, -4.026e-02, 9.728e-02, 2.620e-01, -1.631e-02, 1.545e-02, 1.364e-01, 9.611e-02, 1.356e-01, -2.701e-02, 4.155e-02, -1.510e-01, -3.191e-01, 6.144e-03, -2.199e-01), r2);
	r3 = MulAdd(s1_0_0, M4(2.042e-02, -6.616e-02, 2.003e-02, -1.801e-02, 2.265e-02, 4.154e-03, -9.273e-02, 4.277e-02, -2.713e-02, 6.311e-03, -8.037e-02, 7.244e-02, 6.289e-02, 7.369e-02, -6.564e-02, 3.283e-02), r3);
	r0 = MulAdd(s1_0_1, M4(-3.018e-03, -2.610e-03, -1.352e-01, 9.021e-02, -1.387e-01, -1.022e-01, -1.938e-01, 2.289e-01, 3.971e-01, 2.406e-01, 4.941e-02, -6.440e-01, -1.406e-01, 4.368e-01, 2.578e-01, 2.331e-02), r0);
	r1 = MulAdd(s1_0_1, M4(-1.792e-01, -5.655e-02, -7.647e-02, -5.618e-02, -1.442e-02, 2.277e-01, -1.796e-01, -1.135e-02, 1.180e-01, -9.956e-02, -1.983e-02, -3.133e-01, -2.347e-01, -3.083e-01, 1.441e-01, -2.361e-01), r1);
	r2 = MulAdd(s1_0_1, M4(-3.246e-02, -9.400e-02, -8.904e-04, 5.603e-04, -1.505e-01, -1.319e-01, -1.163e-02, 2.687e-01, -1.643e-02, 2.676e-01, 6.052e-02, 8.999e-02, 2.098e-02, -4.754e-02, 1.574e-02, 1.301e-02), r2);
	r3 = MulAdd(s1_0_1, M4(-1.611e-02, -7.260e-02, -1.527e-02, -2.017e-02, -2.146e-01, -1.098e-02, 2.213e-01, -5.715e-02, -3.777e-01, 7.625e-02, 3.949e-02, 1.812e-01, -2.320e-02, -1.631e-03, -1.831e-01, 2.314e-02), r3);
	r0 = MulAdd(s1_0_2, M4(-1.039e-01, 2.959e-01, -7.225e-02, -8.983e-02, 5.290e-02, -5.308e-02, -3.580e-01, 2.129e-01, -4.223e-01, -2.956e-01, -2.818e-01, 2.397e-01, -2.937e-02, -3.087e-01, 2.571e-01, 5.018e-02), r0);
	r1 = MulAdd(s1_0_2, M4(-1.218e-01, 3.328e-02, 8.055e-02, -9.955e-02, -6.173e-03, 1.174e-01, 7.209e-02, -4.482e-02, -8.711e-03, 1.244e-01, -2.585e-01, -3.206e-03, 7.591e-03, -1.188e-01, -2.142e-02, 2.222e-02), r1);
	r2 = MulAdd(s1_0_2, M4(-9.079e-02, -7.165e-02, -7.235e-04, -7.452e-04, 2.899e-02, -2.724e-01, -2.074e-02, -4.439e-02, -2.418e-01, -1.821e-01, 4.355e-02, 4.229e-02, 1.103e-01, 1.977e-02, 7.160e-03, 3.112e-02), r2);
	r3 = MulAdd(s1_0_2, M4(-1.035e-02, 1.803e-03, 2.270e-02, -1.620e-02, -1.765e-01, -1.486e-02, 1.521e-01, 1.109e-03, 2.206e-01, 5.981e-02, 3.007e-01, 2.741e-02, -3.542e-02, 2.117e-02, -1.048e-01, 6.677e-03), r3);
	r0 = MulAdd(s1_1_0, M4(2.833e-01, 1.526e-01, 9.615e-03, 7.240e-02, -1.450e-01, 1.487e-01, -1.011e-01, 1.132e-01, -6.660e-01, -3.701e-01, -8.967e-02, -3.542e-02, 1.090e-01, -3.307e-01, 2.728e-01, 1.396e-01), r0);
	r1 = MulAdd(s1_1_0, M4(7.254e-02, -7.910e-01, -2.198e-01, 2.058e-01, 2.515e-02, 3.350e-01, 4.767e-02, -2.090e-02, 6.193e-02, 1.929e-01, 3.192e-02, -3.747e-02, -6.695e-02, -2.898e-01, 6.692e-03, 5.101e-02), r1);
	r2 = MulAdd(s1_1_0, M4(6.272e-02, -1.390e-01, 1.708e-01, -1.772e-01, 9.386e-02, -8.987e-02, -4.291e-02, 1.260e-01, 4.099e-01, 3.057e-01, -2.180e-02, 5.282e-01, 3.962e-01, 3.479e-01, -1.487e-01, -2.941e-01), r2);
	r3 = MulAdd(s1_1_0, M4(5.034e-01, -1.883e-02, 1.670e-01, 4.383e-01, -1.055e-01, -6.815e-04, 2.050e-02, -6.489e-02, 2.724e-01, 1.467e-02, 1.566e-01, 1.785e-01, -1.632e-01, 1.116e-01, 9.379e-02, 1.456e-02), r3);
	r0 = MulAdd(s1_1_1, M4(2.432e-01, 1.732e-01, 4.013e-01, -5.450e-01, -3.449e-01, -9.121e-01, -2.199e-01, 4.059e-01, 4.539e-01, 2.468e-01, 7.213e-01, 3.945e-01, -1.325e-01, -4.943e-01, -4.045e-01, 4.020e-01), r0);
	r1 = MulAdd(s1_1_1, M4(1.135e-01, 1.381e-01, -1.044e-01, -2.422e-02, 6.422e-02, -4.261e-01, 1.574e-01, -3.901e-02, 2.052e-01, 1.606e-02, 7.140e-02, 3.701e-02, 3.912e-01, 3.001e-01, 2.131e-01, -1.211e-02), r1);
	r2 = MulAdd(s1_1_1, M4(2.718e-01, 3.732e-01, 7.050e-02, -1.744e-01, 1.624e-01, -5.018e-01, -6.169e-02, 1.360e-01, -3.299e-01, 1.384e-01, 3.725e-01, -1.072e+00, 6.911e-02, -9.316e-02, 2.572e-03, 2.722e-01), r2);
	r3 = MulAdd(s1_1_1, M4(-6.149e-03, -8.484e-02, -6.109e-01, -1.479e-01, 7.114e-02, -4.344e-02, -9.807e-02, -1.761e-02, -4.008e-01, -2.751e-01, -4.714e-01, -2.130e-01, -7.189e-02, -6.540e-02, -1.351e-01, -8.754e-04), r3);
	r0 = MulAdd(s1_1_2, M4(-4.611e-02, -2.300e-01, -1.014e-01, 2.198e-01, -1.457e-02, -1.833e-01, 5.132e-01, 1.266e-01, -3.557e-01, 1.384e-01, 4.480e-02, -1.603e-01, 1.259e-01, -1.723e-01, -1.515e-01, -9.154e-02), r0);
	r1 = MulAdd(s1_1_2, M4(4.210e-02, 4.542e-02, -3.155e-01, 5.999e-02, 5.092e-02, 2.433e-01, 2.105e-01, -1.502e-02, -5.115e-02, -3.291e-01, 7.847e-02, -1.062e-01, 8.764e-02, 1.184e-01, 2.572e-01, 1.251e-02), r1);
	r2 = MulAdd(s1_1_2, M4(-6.085e-03, -1.928e-01, 2.929e-03, 2.495e-01, 1.075e-01, 1.064e-01, -2.929e-02, -7.821e-02, -1.967e-01, -3.325e-01, 3.106e-02, -2.939e-01, 1.293e-02, -1.671e-03, -6.286e-03, 4.962e-02), r2);
	r3 = MulAdd(s1_1_2, M4(-8.089e-02, -3.840e-02, 6.262e-02, -2.036e-02, -3.038e-03, -2.870e-02, 8.506e-02, -6.798e-04, 5.988e-02, 7.539e-02, -8.495e-02, 6.169e-02, 3.516e-02, 3.593e-02, -1.288e-01, 1.037e-02), r3);
	r0 = MulAdd(s1_2_0, M4(-2.527e-01, 1.067e-01, 8.143e-02, 6.208e-02, 1.168e-01, -1.435e-01, -3.859e-02, 7.682e-02, 1.753e-01, -1.962e-01, -2.379e-01, -4.696e-02, 1.170e-04, -2.142e-01, -2.481e-01, 4.811e-02), r0);
	r1 = MulAdd(s1_2_0, M4(4.280e-03, 1.342e-01, 8.647e-03, 2.546e-02, 9.705e-03, 9.546e-02, 1.248e-01, -3.375e-04, -3.788e-03, 4.393e-02, 1.146e-01, 2.643e-02, 1.851e-02, 2.695e-01, -2.742e-01, -2.796e-02), r1);
	r2 = MulAdd(s1_2_0, M4(-2.709e-01, -6.158e-02, -1.315e-01, -9.942e-03, 1.914e-01, 2.370e-02, -1.693e-03, 7.007e-02, 2.788e-01, 8.583e-02, -6.406e-02, 6.252e-02, -2.069e-01, 3.121e-02, -5.951e-02, -5.498e-02), r2);
	r3 = MulAdd(s1_2_0, M4(-9.325e-02, -4.407e-02, 1.028e-01, 2.097e-03, -5.347e-02, -1.501e-03, -4.308e-02, -2.126e-02, 1.107e-01, 3.863e-02, 1.420e-01, 8.562e-03, 3.217e-02, 6.485e-02, -3.295e-03, -5.764e-02), r3);
	r0 = MulAdd(s1_2_1, M4(1.958e-01, -2.029e-02, -2.952e-01, 1.676e-01, -3.473e-02, 2.217e-01, -1.873e-01, 1.421e-01, -2.083e-01, -3.320e-01, -5.554e-02, 1.708e-02, 4.722e-02, 4.307e-01, 2.451e-02, -2.193e-02), r0);
	r1 = MulAdd(s1_2_1, M4(-8.282e-04, -1.149e-02, 2.087e-01, -4.887e-02, 5.305e-02, -6.943e-02, -4.340e-02, 8.038e-03, -1.927e-01, 1.286e-01, 1.562e-02, -6.958e-02, -1.355e-01, 3.525e-01, -8.106e-02, -2.704e-02), r1);
	r2 = MulAdd(s1_2_1, M4(8.664e-02, -5.596e-02, -1.393e-02, -2.100e-01, 2.564e-02, 1.111e-01, -5.084e-02, 4.839e-02, -4.504e-02, -4.470e-01, -1.919e-01, -1.663e-02, 1.455e-01, -1.169e-01, -3.447e-02, -7.604e-02), r2);
	r3 = MulAdd(s1_2_1, M4(9.394e-02, 1.569e-02, -1.425e-01, -3.849e-03, -4.399e-02, -3.112e-02, -4.581e-02, -2.139e-02, 1.345e-01, -5.115e-02, -1.803e-01, 7.197e-02, 1.103e-01, 8.618e-02, 1.198e-01, -1.900e-02), r3);
	r0 = MulAdd(s1_2_2, M4(-1.102e-01, -1.470e-01, -9.110e-01, -5.500e-02, 6.512e-02, 3.303e-01, -1.528e+00, 1.891e-01, 1.322e-01, -2.464e-01, -2.174e+00, -1.276e-01, -9.031e-02, 4.774e-01, -5.042e-01, 9.391e-02), r0);
	r1 = MulAdd(s1_2_2, M4(5.834e-04, -1.702e-01, 1.800e-01, 1.247e-02, 2.435e-02, 1.631e-01, -6.398e-02, 1.233e-02, 5.628e-02, -1.423e-01, -8.325e-02, 3.943e-02, -2.369e-02, -3.951e-02, -1.136e-01, -3.916e-02), r1);
	r2 = MulAdd(s1_2_2, M4(-5.348e-02, 6.158e-03, -3.444e-02, -6.165e-03, 4.215e-02, -3.143e-02, -1.861e-02, -6.952e-02, -2.704e-02, 2.006e-01, 7.739e-02, -1.638e-02, 6.479e-02, -1.061e-01, -1.383e-02, 3.070e-02), r2);
	r3 = MulAdd(s1_2_2, M4(9.448e-02, -5.592e-03, -7.127e-02, 8.279e-03, -8.614e-03, -2.051e-02, 7.988e-02, -5.014e-03, -7.301e-02, 9.177e-02, 9.890e-02, -2.659e-02, 1.611e-02, 1.990e-03, 4.416e-02, -6.083e-03), r3);
	s0_0_0 = L2(-1.0, -1.0); s0_0_1 = L2(0.0, -1.0); s0_0_2 = L2(1.0, -1.0);
	s0_1_0 = L2(-1.0, 0.0); s0_1_1 = L2(0.0, 0.0); s0_1_2 = L2(1.0, 0.0);
	s0_2_0 = L2(-1.0, 1.0); s0_2_1 = L2(0.0, 1.0); s0_2_2 = L2(1.0, 1.0);
	s1_0_0 = L3(-1.0, -1.0); s1_0_1 = L3(0.0, -1.0); s1_0_2 = L3(1.0, -1.0);
	s1_1_0 = L3(-1.0, 0.0); s1_1_1 = L3(0.0, 0.0); s1_1_2 = L3(1.0, 0.0);
	s1_2_0 = L3(-1.0, 1.0); s1_2_1 = L3(0.0, 1.0); s1_2_2 = L3(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(-5.439e-02, 1.777e-02, 1.507e-01, -9.701e-03, 4.476e-01, 4.050e-01, 3.056e-03, 1.982e-01, -3.204e-01, -2.280e-01, 2.115e-02, 2.026e-02, 1.257e-02, 4.292e-03, 4.098e-02, 4.258e-02), r0);
	r1 = MulAdd(s0_0_0, M4(4.180e-02, -6.500e-02, 1.202e-01, 4.473e-02, 6.633e-02, -2.159e-01, -4.578e-02, -2.989e-02, -1.423e-01, 2.242e-01, -1.744e-02, 1.969e-01, 1.310e-03, -2.664e-01, -7.148e-02, 2.286e-02), r1);
	r2 = MulAdd(s0_0_0, M4(6.099e-02, -1.015e-01, 3.146e-02, -1.622e-02, -5.136e-01, -3.076e-01, -1.223e-02, -4.179e-01, 4.606e-01, 3.022e-01, -2.563e-02, -2.246e-03, -1.249e-01, -1.349e-01, 3.506e-02, 5.304e-02), r2);
	r3 = MulAdd(s0_0_0, M4(1.412e-02, -2.578e-02, -2.243e-02, 2.627e-02, 1.921e-01, 9.270e-04, -9.447e-03, 2.444e-02, 1.066e-01, -4.838e-02, -2.565e-01, -1.401e-01, 3.926e-01, 4.290e-03, 1.440e-01, 3.210e-02), r3);
	r0 = MulAdd(s0_0_1, M4(-9.123e-02, 9.279e-02, 4.238e-02, -1.106e-01, -2.538e-01, -5.281e-02, 1.982e-01, -4.194e-01, 2.077e-01, 1.020e-01, 2.835e-02, 3.081e-01, 1.624e-01, -4.162e-02, 1.112e-01, -5.419e-01), r0);
	r1 = MulAdd(s0_0_1, M4(-2.521e-01, -1.732e-01, 1.373e-01, -7.158e-02, 2.939e-01, -8.535e-01, 1.226e-01, 2.142e-01, 8.237e-02, 8.452e-01, -2.438e-02, 2.950e-01, 1.583e-01, -7.521e-01, 1.620e-01, 2.660e-02), r1);
	r2 = MulAdd(s0_0_1, M4(4.236e-03, -4.516e-02, 2.029e-02, 1.080e-01, 4.698e-01, 1.600e-01, 4.992e-02, -4.070e-01, -9.925e-02, 8.539e-03, -1.851e-02, -3.237e-01, 2.426e-01, -1.050e-01, 8.035e-02, -1.334e-03), r2);
	r3 = MulAdd(s0_0_1, M4(1.413e-01, 1.221e-02, 8.735e-02, 7.948e-03, 2.261e-01, 1.704e-02, -3.309e-01, 1.179e-02, -2.031e-01, -1.430e-01, -1.080e-01, -6.014e-02, 3.850e-02, 2.434e-02, -1.840e-01, 7.251e-02), r3);
	r0 = MulAdd(s0_0_2, M4(-1.904e-02, 1.221e-01, 3.246e-04, -3.392e-02, 2.072e-02, -1.473e-01, 4.697e-01, -2.385e-01, -2.445e-02, -6.141e-02, -6.388e-01, 3.059e-02, 5.384e-02, 1.105e-01, 7.336e-02, -2.359e-02), r0);
	r1 = MulAdd(s0_0_2, M4(5.987e-02, 8.642e-02, 1.599e-01, -4.973e-02, 2.998e-01, -7.851e-02, -1.220e-01, 5.626e-02, 1.004e-01, 1.722e-01, 3.425e-03, 2.195e-01, 8.065e-03, -1.656e-01, -5.446e-02, -1.062e-02), r1);
	r2 = MulAdd(s0_0_2, M4(-3.194e-02, 1.255e-01, 3.760e-03, -3.072e-02, 9.990e-02, 3.656e-01, -1.192e-02, 8.179e-02, -7.676e-02, -3.561e-01, -6.800e-03, -9.370e-02, 1.120e-02, -8.911e-02, 5.129e-02, 1.675e-01), r2);
	r3 = MulAdd(s0_0_2, M4(-2.947e-02, 3.313e-03, -4.105e-03, -8.660e-03, 7.246e-03, -1.056e-02, -1.233e-01, 3.059e-03, -2.472e-02, -6.738e-02, 1.407e-01, -5.008e-02, -1.096e-01, 7.940e-02, -4.410e-03, 5.010e-02), r3);
	r0 = MulAdd(s0_1_0, M4(1.057e-01, -1.115e-01, -7.645e-02, -1.907e-01, -2.835e-01, 1.890e-01, -8.151e-02, 1.068e-01, 6.663e-01, 4.267e-01, -2.180e-02, 1.489e-01, -1.111e-01, -1.120e-01, 1.651e-01, -5.913e-02), r0);
	r1 = MulAdd(s0_1_0, M4(-1.223e-01, -1.604e-02, 1.099e-04, 7.447e-02, -8.548e-03, -1.139e-01, 3.898e-02, 2.378e-02, 4.109e-02, -1.645e-01, -1.509e-03, 7.657e-02, -6.758e-03, -2.019e-01, -4.742e-01, 1.018e-02), r1);
	r2 = MulAdd(s0_1_0, M4(7.027e-02, -2.108e-01, 4.559e-02, -3.186e-02, -1.241e+00, -1.045e-01, 5.774e-02, -3.618e-02, -3.879e-01, -2.907e-01, 2.905e-02, -2.195e-01, -7.918e-01, -1.512e-02, 8.727e-02, -1.415e-01), r2);
	r3 = MulAdd(s0_1_0, M4(-3.744e-01, -1.761e-02, 4.552e-03, 9.303e-02, -1.353e-01, 3.311e-02, 1.343e-01, 8.245e-02, 2.672e-02, -4.823e-02, -2.003e-01, -8.099e-02, 3.729e-01, 4.647e-02, 1.988e-01, 2.294e-01), r3);
	r0 = MulAdd(s0_1_1, M4(-1.704e-01, -8.971e-01, -1.757e-01, -7.318e-01, -2.032e-01, 2.859e-02, 5.294e-01, -6.965e-01, -8.226e-03, -5.215e-01, 9.419e-02, -6.879e-01, 8.469e-02, 2.090e-01, 4.150e-01, -1.552e-01), r0);
	r1 = MulAdd(s0_1_1, M4(-3.393e-01, -3.321e-01, -1.784e-01, -1.217e-01, -1.492e-01, -1.088e+00, 6.668e-01, 1.185e-01, -3.113e-01, -1.056e+00, -4.715e-01, -1.448e-01, 1.453e-01, -9.657e-02, -2.306e-02, 3.036e-02), r1);
	r2 = MulAdd(s0_1_1, M4(-9.972e-02, -4.916e-01, 5.557e-02, 7.190e-01, 1.709e-01, -4.430e-01, 1.095e-01, -4.056e-01, -4.459e-01, 2.815e-01, -1.750e-01, 6.245e-01, 1.284e-01, 2.062e-02, 3.897e-02, 4.331e-02), r2);
	r3 = MulAdd(s0_1_1, M4(1.355e-01, 5.454e-02, 5.107e-01, 1.101e-01, 1.915e-01, 9.008e-02, -3.960e-02, -2.615e-03, 7.772e-04, 5.605e-01, 4.314e-01, 8.636e-02, 1.681e-01, 1.737e-01, 1.390e-01, 5.993e-03), r3);
	r0 = MulAdd(s0_1_2, M4(3.778e-02, -1.501e-01, -3.730e-01, 1.485e-02, -1.861e-02, 4.432e-01, -1.216e+00, -1.850e-01, -1.915e-02, -3.362e-01, 5.130e-01, -9.577e-02, 1.072e-02, 1.217e-01, 2.352e-01, -1.332e-01), r0);
	r1 = MulAdd(s0_1_2, M4(-5.774e-02, 6.150e-03, -1.632e-02, -2.154e-03, -4.025e-02, -9.589e-02, 2.783e-01, -1.164e-02, -1.245e-01, -7.107e-02, -2.036e-01, 5.330e-02, 2.169e-02, -1.505e-01, 5.756e-02, -2.358e-03), r1);
	r2 = MulAdd(s0_1_2, M4(4.858e-03, -1.539e-03, 6.356e-02, -2.342e-02, 1.040e-01, 1.174e-01, -1.251e-02, -1.152e-01, -2.178e-01, 2.546e-01, -6.018e-02, -5.869e-02, -2.313e-02, -1.942e-02, 4.016e-02, 8.489e-02), r2);
	r3 = MulAdd(s0_1_2, M4(-1.781e-02, 8.478e-02, 1.034e-01, -2.537e-02, -3.185e-02, -3.551e-03, -1.810e-01, 3.551e-02, 1.512e-01, 5.640e-02, 1.384e-01, 6.174e-02, 6.876e-02, 3.329e-02, -4.492e-02, -1.362e-02), r3);
	r0 = MulAdd(s0_2_0, M4(8.440e-02, 2.117e-02, 5.481e-03, 1.646e-01, 6.376e-02, -1.001e-01, -1.456e-01, 8.472e-03, 3.542e-02, 2.861e-01, -4.144e-02, 3.575e-02, 5.383e-02, -2.379e-01, -1.898e-01, -1.239e-02), r0);
	r1 = MulAdd(s0_2_0, M4(9.635e-03, -1.240e-03, 1.887e-01, 4.164e-04, -7.824e-02, 6.568e-02, -1.651e-01, 1.885e-02, 5.339e-02, 4.711e-02, 1.609e-01, 1.399e-02, -3.453e-02, -6.858e-03, -1.305e-01, -1.631e-02), r1);
	r2 = MulAdd(s0_2_0, M4(4.928e-02, 4.800e-03, -6.619e-02, 8.470e-02, -1.313e-01, 1.424e-01, 9.797e-03, -1.051e-01, 1.768e-01, -2.863e-01, 8.473e-02, -9.855e-03, -4.394e-03, -9.101e-02, -2.594e-02, 1.134e-01), r2);
	r3 = MulAdd(s0_2_0, M4(4.716e-02, -2.046e-02, -8.116e-02, -2.400e-02, 4.332e-02, 8.406e-03, 1.609e-02, 1.016e-02, -2.409e-01, 1.077e-02, -9.400e-02, 1.801e-02, 1.090e-01, 1.858e-02, 1.578e-01, 1.383e-02), r3);
	r0 = MulAdd(s0_2_1, M4(-3.159e-01, 2.215e-01, 3.204e-01, 9.484e-02, 1.041e-01, 3.992e-01, 4.580e-01, -1.071e-01, -3.936e-01, -2.133e-01, -3.770e-01, 3.416e-02, -1.173e-01, -1.823e-01, 3.004e-01, 2.693e-03), r0);
	r1 = MulAdd(s0_2_1, M4(4.671e-02, -2.322e-01, -7.296e-02, 2.130e-02, 4.039e-02, 1.037e-01, -1.708e-01, 4.013e-02, 1.413e-03, -1.174e-01, -9.558e-02, -2.381e-02, -9.829e-02, 6.762e-02, 5.491e-02, -2.784e-02), r1);
	r2 = MulAdd(s0_2_1, M4(-1.766e-01, 1.324e-01, -3.613e-02, -2.855e-02, -1.597e-01, 2.114e-01, 6.710e-02, 9.314e-02, 1.037e-01, -2.884e-01, -1.682e-01, 5.015e-02, -4.735e-02, -2.612e-01, 9.903e-02, 8.675e-02), r2);
	r3 = MulAdd(s0_2_1, M4(-8.521e-02, -7.727e-03, -4.053e-02, -1.032e-02, -7.047e-02, 3.691e-02, 1.636e-01, -1.175e-02, 9.428e-02, -5.441e-02, -1.551e-01, -7.342e-03, 9.830e-02, 9.447e-02, 1.617e-01, -5.382e-03), r3);
	r0 = MulAdd(s0_2_2, M4(-1.134e-01, 4.552e-02, 7.210e-01, 1.861e-03, -4.232e-02, 1.901e-01, 2.647e-01, 7.819e-02, -1.985e-02, -1.522e-01, -1.250e+00, -8.809e-02, -9.507e-02, 1.432e-01, 1.696e-01, -2.043e-02), r0);
	r1 = MulAdd(s0_2_2, M4(4.376e-02, 1.446e-01, -5.585e-02, 2.112e-04, -5.650e-03, 1.281e-01, -8.677e-02, 1.648e-02, -2.189e-02, -1.993e-01, 3.170e-02, -1.080e-02, 8.175e-03, 6.475e-02, -9.258e-02, -5.811e-02), r1);
	r2 = MulAdd(s0_2_2, M4(7.938e-03, 7.247e-02, 3.735e-02, -9.595e-02, 3.137e-02, -7.219e-02, -4.011e-03, -3.336e-02, -5.973e-02, 1.572e-01, 7.254e-02, 5.506e-02, 1.473e-02, -6.197e-02, 1.544e-02, 3.858e-02), r2);
	r3 = MulAdd(s0_2_2, M4(3.630e-03, 3.132e-02, 7.179e-02, -8.316e-04, 8.667e-02, 6.933e-03, 1.685e-02, -1.909e-04, -2.101e-02, 4.366e-02, 2.322e-02, 2.210e-02, 1.447e-01, -4.880e-03, -2.599e-02, 9.287e-03), r3);
	r0 = MulAdd(s1_0_0, M4(-7.077e-02, -6.385e-01, -3.985e-02, -2.231e-01, 2.557e-03, 3.125e-01, 2.869e-02, 2.634e-01, -4.825e-03, -4.694e-02, -2.825e-02, -1.905e-02, 1.442e-02, -1.271e-01, -9.093e-03, 7.233e-02), r0);
	r1 = MulAdd(s1_0_0, M4(3.254e-03, 2.971e-01, 6.604e-02, -2.606e-02, -2.296e-02, -3.857e-03, -3.175e-01, -2.964e-02, -9.027e-03, -5.720e-02, -2.999e-02, 1.006e-01, 9.228e-04, 2.062e-02, -5.502e-02, 2.086e-02), r1);
	r2 = MulAdd(s1_0_0, M4(3.024e-01, 6.615e-02, -2.686e-02, 2.071e-01, -9.952e-01, -1.080e-01, -1.089e-02, 8.595e-02, -8.138e-03, 5.162e-02, 1.178e-03, -4.959e-02, 7.486e-02, 2.474e-02, -1.898e-02, 3.268e-02), r2);
	r3 = MulAdd(s1_0_0, M4(-6.032e-02, -1.483e-02, 1.194e-01, -6.519e-02, -4.163e-01, 1.115e-02, -1.216e-01, -1.390e-01, -7.381e-02, -1.787e-02, -1.044e-01, -2.991e-02, -3.084e-02, -1.853e-02, 3.004e-02, -2.781e-02), r3);
	r0 = MulAdd(s1_0_1, M4(-3.077e-01, -8.904e-01, -1.314e-01, 1.106e-01, 2.027e-01, 7.669e-01, 3.160e-02, -7.250e-01, -1.984e-01, -2.983e-01, 4.795e-02, -2.820e-01, 1.991e-02, 7.784e-03, 1.384e-02, 2.293e-01), r0);
	r1 = MulAdd(s1_0_1, M4(-1.778e-01, 4.074e-01, -1.374e-01, -2.032e-02, -2.464e-01, -1.036e+00, -8.059e-02, -2.568e-01, -4.053e-02, -5.805e-02, 6.278e-02, -8.528e-02, -3.503e-02, 2.462e-01, -4.028e-04, -3.574e-02), r1);
	r2 = MulAdd(s1_0_1, M4(-2.457e-01, -5.645e-01, -1.817e-02, 1.575e-01, -3.640e-02, 6.797e-02, -2.167e-02, 1.157e-01, -3.864e-03, 2.287e-02, -7.494e-03, 3.037e-01, -5.356e-02, 2.166e-02, -9.456e-03, 1.226e-01), r2);
	r3 = MulAdd(s1_0_1, M4(8.642e-02, -5.655e-02, 1.733e-01, 2.063e-02, -2.191e-02, -4.658e-02, 7.251e-02, -6.673e-03, 5.390e-02, -1.600e-02, 1.475e-01, 1.990e-02, -4.182e-02, -2.085e-02, 1.674e-02, 3.022e-02), r3);
	r0 = MulAdd(s1_0_2, M4(1.974e-01, 2.295e-01, -6.024e-02, 1.174e-01, -1.469e-01, -4.839e-02, 5.256e-01, -6.768e-02, 1.092e-02, 1.545e-02, -1.109e-03, 1.448e-01, 8.971e-02, -1.223e-01, -4.860e-02, -1.250e-01), r0);
	r1 = MulAdd(s1_0_2, M4(-7.219e-02, -5.047e-02, -1.057e-01, -4.171e-02, -1.517e-01, -1.276e-01, 6.659e-02, -1.197e-01, 5.686e-03, -2.727e-03, -1.735e-01, -6.490e-02, 4.896e-02, -5.248e-02, 4.935e-02, 6.932e-02), r1);
	r2 = MulAdd(s1_0_2, M4(-4.065e-02, -2.037e-01, -3.483e-03, 5.722e-03, -3.006e-02, 1.977e-01, 2.233e-02, -3.754e-02, 2.345e-04, -5.623e-02, -4.366e-02, -8.665e-03, 9.092e-02, 8.524e-02, 1.987e-02, -5.881e-02), r2);
	r3 = MulAdd(s1_0_2, M4(-9.314e-03, -5.720e-03, 2.233e-01, -1.374e-02, 1.307e-01, 2.728e-02, -8.176e-02, 6.542e-03, 2.017e-01, -3.993e-02, 1.888e-01, -2.936e-02, -1.396e-02, 3.284e-02, -8.762e-03, 4.123e-03), r3);
	r0 = MulAdd(s1_1_0, M4(2.478e-01, -1.748e-01, -2.559e-02, -3.932e-02, -1.050e-01, -9.455e-03, -5.573e-02, -2.533e-02, 9.888e-02, -1.518e-01, 2.504e-02, 7.417e-02, 6.114e-02, 3.343e-01, -1.079e-01, 6.703e-02), r0);
	r1 = MulAdd(s1_1_0, M4(-1.402e-02, -1.180e-01, 2.476e-01, -8.373e-02, 1.183e-01, 3.962e-01, -1.367e-01, -4.600e-02, -8.130e-02, 2.371e-02, -2.163e-01, 5.701e-02, 3.190e-02, 1.110e-01, -3.013e-03, -9.681e-03), r1);
	r2 = MulAdd(s1_1_0, M4(3.743e-01, -1.037e-01, 1.345e-02, 2.503e-01, -3.057e-01, 2.153e-01, 4.550e-02, -2.091e-01, -5.390e-01, -1.309e-02, 2.388e-02, -1.124e-01, 1.648e-01, 5.041e-02, 1.447e-02, -3.068e-02), r2);
	r3 = MulAdd(s1_1_0, M4(1.121e-01, -9.779e-03, -5.918e-03, -1.302e-03, -1.807e-01, 2.714e-02, 8.355e-02, -1.543e-01, 3.582e-01, -5.950e-03, 1.247e-01, 3.160e-02, 1.050e-01, 3.090e-02, 2.707e-02, 3.938e-02), r3);
	r0 = MulAdd(s1_1_1, M4(-3.593e-01, 1.335e-01, -3.248e-01, 2.104e-01, 1.245e-01, -4.215e-01, 2.192e-01, -3.057e-01, -3.427e-01, -4.787e-01, 2.124e-01, -3.440e-01, -2.514e-01, -6.916e-01, -2.733e-01, 7.793e-02), r0);
	r1 = MulAdd(s1_1_1, M4(7.776e-02, -1.364e-01, -2.019e-01, -6.066e-02, 1.558e-02, 4.536e-01, 2.117e-01, 8.681e-02, -2.595e-01, -5.405e-01, 3.306e-01, -6.162e-02, 1.242e-01, -1.148e-01, 6.470e-02, 2.050e-01), r1);
	r2 = MulAdd(s1_1_1, M4(-2.463e-02, -1.196e-01, -4.939e-02, 1.063e-01, 3.271e-01, -2.644e-01, 3.185e-01, -2.596e-02, 3.624e-02, 7.035e-02, 2.588e-01, -6.272e-02, -2.074e-01, -3.447e-01, 5.017e-02, -7.279e-02), r2);
	r3 = MulAdd(s1_1_1, M4(-3.404e-02, -4.083e-02, -5.562e-03, -1.151e-02, 5.896e-02, 4.101e-01, -4.424e-01, -1.078e-01, 4.974e-02, 6.054e-02, -2.443e-01, 8.228e-02, -1.626e-01, -1.381e-02, -1.229e-01, 1.684e-01), r3);
	r0 = MulAdd(s1_1_2, M4(1.880e-01, -3.698e-01, -1.253e-01, 5.844e-02, -1.422e-01, -5.347e-02, -6.134e-01, -4.550e-02, 3.001e-01, 2.434e-01, -1.661e-01, 6.991e-02, -9.822e-02, -5.598e-02, 7.314e-02, -1.877e-01), r0);
	r1 = MulAdd(s1_1_2, M4(-5.185e-02, -9.114e-02, -1.097e-02, 1.900e-02, 1.597e-01, -1.645e-01, 1.050e-02, 3.604e-02, -5.123e-02, 2.594e-01, 1.639e-01, -7.794e-02, -5.052e-02, 6.653e-03, 1.405e-01, -1.764e-02), r1);
	r2 = MulAdd(s1_1_2, M4(-1.436e-01, -4.707e-03, -9.243e-03, -2.242e-02, 1.511e-01, 2.225e-01, 8.230e-02, 2.302e-01, 1.115e-01, -2.940e-01, -1.304e-01, -1.323e-01, 1.362e-01, 2.739e-01, 6.803e-02, -8.147e-02), r2);
	r3 = MulAdd(s1_1_2, M4(-1.757e-03, -3.304e-02, 9.897e-02, -6.217e-03, -2.192e-02, 4.032e-02, 4.941e-03, -4.797e-02, -3.045e-01, -9.348e-02, -4.290e-02, 5.602e-02, -1.994e-02, 8.960e-02, -1.896e-01, -5.690e-03), r3);
	r0 = MulAdd(s1_2_0, M4(1.010e-01, 1.307e-01, 5.961e-02, 7.209e-02, 3.567e-02, -9.356e-02, 1.254e-01, 1.578e-02, 2.574e-01, 2.288e-01, 1.769e-01, -6.044e-02, 2.588e-02, 3.322e-02, 7.392e-02, 8.627e-02), r0);
	r1 = MulAdd(s1_2_0, M4(1.281e-03, -8.725e-02, 6.209e-02, -1.187e-02, -3.771e-03, -2.424e-02, 2.348e-03, 1.543e-02, 1.161e-02, -7.101e-02, -1.634e-03, 4.059e-02, -9.637e-02, -1.731e-01, -8.395e-02, 1.486e-02), r1);
	r2 = MulAdd(s1_2_0, M4(2.407e-01, -6.567e-02, -2.124e-02, 1.167e-01, -6.896e-02, 4.644e-02, 1.455e-01, -1.380e-02, -3.118e-02, -8.320e-02, -1.840e-02, 6.041e-02, 8.490e-02, 2.467e-02, -1.129e-03, -9.917e-02), r2);
	r3 = MulAdd(s1_2_0, M4(1.079e-01, -8.434e-03, 1.301e-02, -7.004e-03, 2.272e-03, 1.654e-02, -3.817e-02, 4.507e-02, -1.841e-01, -5.721e-03, -3.049e-01, -1.052e-01, -7.263e-02, 2.643e-02, 6.273e-02, 3.321e-02), r3);
	r0 = MulAdd(s1_2_1, M4(-1.998e-01, -3.448e-02, -1.527e-01, 5.412e-02, 1.891e-01, -2.789e-01, 5.058e-02, -1.082e-01, 3.454e-01, 5.934e-01, 1.992e-02, 4.566e-01, -9.738e-02, 1.763e-01, 8.720e-03, -1.689e-01), r0);
	r1 = MulAdd(s1_2_1, M4(-5.311e-02, -5.084e-02, -1.663e-02, 5.516e-03, 1.626e-01, -4.857e-02, 7.536e-02, 2.496e-02, 9.016e-02, 4.343e-02, -2.691e-01, -2.344e-02, -2.906e-02, -1.571e-02, 1.078e-01, 7.546e-02), r1);
	r2 = MulAdd(s1_2_1, M4(7.994e-03, -1.275e-01, -3.902e-03, 3.948e-02, -5.808e-02, 3.213e-01, 6.704e-02, 1.925e-01, -1.575e-02, -6.553e-02, 1.369e-01, -1.885e-01, -3.608e-01, 2.455e-01, 1.813e-01, -1.138e-01), r2);
	r3 = MulAdd(s1_2_1, M4(-6.442e-03, -8.020e-03, 2.288e-03, -8.178e-03, -8.624e-02, 5.405e-03, 1.398e-01, 1.330e-02, -2.120e-01, -1.425e-02, -6.173e-02, -3.859e-02, -1.362e-01, 1.778e-01, 2.300e-01, 2.638e-02), r3);
	r0 = MulAdd(s1_2_2, M4(9.836e-02, -1.304e-01, -2.335e+00, -8.079e-02, -4.593e-02, -4.969e-02, -9.310e-01, 6.851e-02, 1.901e-01, 3.905e-01, -6.189e-01, 1.031e-01, -1.733e-01, -1.356e-01, -4.830e-01, -6.952e-02), r0);
	r1 = MulAdd(s1_2_2, M4(3.955e-02, -2.908e-02, 6.637e-02, -9.636e-03, -3.698e-02, 2.378e-01, 4.832e-02, 3.689e-02, 3.405e-02, 1.526e-01, 2.056e-02, 1.151e-02, -6.499e-03, 2.894e-01, -8.692e-02, -3.020e-02), r1);
	r2 = MulAdd(s1_2_2, M4(-4.855e-02, 1.619e-01, 4.643e-03, 1.615e-02, 7.112e-02, -8.029e-02, -5.214e-02, -6.577e-03, 5.200e-03, -7.063e-02, 1.059e-03, 2.692e-02, 8.653e-02, 2.038e-02, 7.971e-02, 1.209e-01), r2);
	r3 = MulAdd(s1_2_2, M4(-2.873e-02, -6.840e-03, 9.711e-03, 1.502e-02, 1.001e-01, -3.307e-02, -9.656e-02, -3.028e-03, -1.581e-01, -4.032e-02, 8.018e-02, -1.112e-02, 6.585e-02, 9.010e-02, 3.000e-02, -1.077e-02), r3);
	r0 = max(r0, 0.0);
	T0[gxy] = r0;
	r1 = max(r1, 0.0);
	T1[gxy] = r1;
	r2 = max(r2, 0.0);
	T2[gxy] = r2;
	r3 = max(r3, 0.0);
	T3[gxy] = r3;
}

//!PASS 4
//!DESC conv3 (16x16)
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN T0, T1, T2, T3
//!OUT T4, T5, T6, T7

#define L0(x, y) V4(O(T0, x, y))
#define L1(x, y) V4(O(T1, x, y))
#define L2(x, y) V4(O(T2, x, y))
#define L3(x, y) V4(O(T3, x, y))

void Pass4(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 sz = GetInputSize();
	if (gxy.x >= sz.x || gxy.y >= sz.y)
		return;
	float2 pos = (gxy + 0.5) * pt;
	V4 s0_0_0, s0_0_1, s0_0_2, s0_1_0, s0_1_1, s0_1_2, s0_2_0, s0_2_1, s0_2_2, s1_0_0, s1_0_1, s1_0_2, s1_1_0, s1_1_1, s1_1_2, s1_2_0, s1_2_1, s1_2_2;
	V4 r0 = 0.0, r1 = 0.0, r2 = 0.0, r3 = 0.0;
	s0_0_0 = L0(-1.0, -1.0); s0_0_1 = L0(0.0, -1.0); s0_0_2 = L0(1.0, -1.0);
	s0_1_0 = L0(-1.0, 0.0); s0_1_1 = L0(0.0, 0.0); s0_1_2 = L0(1.0, 0.0);
	s0_2_0 = L0(-1.0, 1.0); s0_2_1 = L0(0.0, 1.0); s0_2_2 = L0(1.0, 1.0);
	s1_0_0 = L1(-1.0, -1.0); s1_0_1 = L1(0.0, -1.0); s1_0_2 = L1(1.0, -1.0);
	s1_1_0 = L1(-1.0, 0.0); s1_1_1 = L1(0.0, 0.0); s1_1_2 = L1(1.0, 0.0);
	s1_2_0 = L1(-1.0, 1.0); s1_2_1 = L1(0.0, 1.0); s1_2_2 = L1(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(9.097e-02, -3.744e-02, -3.505e-02, 1.705e-02, -4.699e-03, 8.763e-02, -1.568e-02, -1.256e-01, -1.244e+00, -6.430e-01, 4.922e-01, -3.867e-02, -4.259e-02, -3.264e-03, -3.341e-03, 3.051e-03), r0);
	r1 = MulAdd(s0_0_0, M4(-1.428e-01, 1.900e-01, -3.829e-02, -7.960e-02, -7.087e-03, 1.133e-01, 2.287e-02, 8.325e-02, 4.024e-01, -7.079e-01, 1.755e-02, 1.590e-01, 1.697e-02, 1.633e-03, 3.076e-02, 1.583e-02), r1);
	r2 = MulAdd(s0_0_0, M4(5.853e-02, -1.431e-01, -2.565e-02, -1.084e-02, -1.600e-01, 6.860e-02, -1.014e-02, -1.435e-03, 6.688e-01, 4.062e-01, 3.923e-01, 1.406e+00, -3.893e-02, 2.888e-02, -1.614e-02, -7.747e-03), r2);
	r3 = MulAdd(s0_0_0, M4(-2.873e-02, -1.380e-02, -3.636e-03, -2.556e-02, -5.715e-02, 2.650e-01, -3.103e-02, -1.687e-02, -6.480e-01, 4.100e-01, 2.043e-01, 4.002e-01, -3.241e-02, -4.483e-02, 2.551e-03, -1.114e-02), r3);
	r0 = MulAdd(s0_0_1, M4(1.400e-01, 2.154e-01, -5.555e-02, -7.147e-02, -4.351e-02, -1.731e-01, -1.074e-02, -9.374e-02, 2.016e-01, 4.375e-02, 1.294e-01, -8.710e-02, -1.478e-02, 9.871e-02, 1.432e-02, 4.114e-02), r0);
	r1 = MulAdd(s0_0_1, M4(-2.030e-01, 1.382e-01, -7.272e-03, 1.460e-01, 1.023e-01, 1.511e-01, -2.482e-02, 2.861e-01, 3.182e-01, 1.179e-01, 4.555e-01, -6.854e-02, -1.228e-01, -2.906e-01, 6.060e-02, 8.605e-03), r1);
	r2 = MulAdd(s0_0_1, M4(5.086e-02, 1.556e-02, -6.340e-02, -1.835e-02, -1.646e-01, 1.917e-01, -1.775e-02, -1.139e-02, -3.772e-01, 8.654e-02, 1.186e-01, -3.941e-02, -1.518e-02, -8.866e-02, 6.665e-02, -3.084e-02), r2);
	r3 = MulAdd(s0_0_1, M4(6.520e-02, 7.109e-02, -1.065e-01, -4.550e-02, 1.047e-01, 2.712e-01, -1.372e-01, -4.612e-02, 5.178e-02, -1.081e-01, 6.427e-02, 1.724e-01, 2.752e-02, 1.063e-01, 5.769e-02, 8.116e-03), r3);
	r0 = MulAdd(s0_0_2, M4(5.548e-02, 1.676e-01, 2.058e-02, -8.797e-02, 1.235e-01, 1.109e-01, -3.789e-02, -7.879e-02, 1.290e-02, -2.472e-02, -1.475e-02, -3.147e-02, -8.194e-02, -6.342e-02, -2.567e-03, -6.204e-02), r0);
	r1 = MulAdd(s0_0_2, M4(-1.198e-02, 6.623e-02, 1.255e-01, 4.527e-02, 6.115e-02, -3.936e-02, -1.029e-01, 7.060e-02, -1.184e-02, -2.708e-02, 8.283e-02, -3.544e-02, -2.605e-02, 1.238e-01, -3.357e-02, 1.231e-01), r1);
	r2 = MulAdd(s0_0_2, M4(-1.300e-02, 4.278e-02, -1.586e-02, 5.755e-02, 2.978e-02, 6.250e-03, -5.091e-02, -8.079e-02, -4.524e-02, -1.853e-02, -2.937e-02, 5.020e-02, -4.454e-02, 5.909e-02, -4.708e-02, -1.836e-02), r2);
	r3 = MulAdd(s0_0_2, M4(4.938e-02, -7.789e-03, -9.914e-02, -5.073e-03, 5.070e-02, 4.383e-02, -1.341e-02, -3.081e-02, -1.635e-03, 5.049e-02, -1.023e-02, -6.776e-03, 2.256e-02, 2.540e-02, -6.145e-03, -2.741e-02), r3);
	r0 = MulAdd(s0_1_0, M4(1.195e-01, 1.295e-01, -5.353e-02, -5.092e-02, -5.432e-02, -1.278e-01, 2.012e-02, 2.427e-01, -3.500e-01, -5.460e-02, 2.856e-01, 4.720e-01, -5.958e-02, 1.803e-02, -2.553e-03, -7.692e-02), r0);
	r1 = MulAdd(s0_1_0, M4(-2.311e-02, 9.693e-02, 6.170e-02, -2.763e-02, -4.291e-02, 1.670e-01, 1.117e-01, 2.218e-02, -3.563e-01, -3.765e-02, -2.467e-01, -1.304e-01, -3.683e-02, -6.218e-03, 4.766e-02, 6.329e-02), r1);
	r2 = MulAdd(s0_1_0, M4(5.811e-02, -2.950e-02, -6.968e-02, 4.826e-02, 2.085e-01, -1.857e-02, 4.517e-02, -3.553e-02, 6.591e-01, 2.745e-01, 4.171e-01, 7.252e-02, -1.055e-01, 4.915e-02, 1.318e-02, -3.486e-03), r2);
	r3 = MulAdd(s0_1_0, M4(-1.109e-01, -1.224e-01, 5.816e-02, -7.154e-02, 2.948e-02, 1.194e-01, -8.965e-02, 6.870e-03, 1.125e-01, 2.397e-01, 1.400e-02, 5.371e-02, -1.183e-01, -1.746e-01, -9.889e-02, 1.992e-02), r3);
	r0 = MulAdd(s0_1_1, M4(-2.620e-01, 2.613e-01, -1.450e-01, -5.047e-02, -6.693e-02, 8.536e-02, 1.433e-01, 2.879e-01, 1.032e-01, 1.424e-01, 1.283e-01, 1.735e-02, 5.120e-02, -4.893e-01, 2.681e-02, -2.310e-01), r0);
	r1 = MulAdd(s0_1_1, M4(3.911e-02, 1.473e-01, -8.891e-03, 2.951e-02, -4.159e-02, -1.164e-01, 9.016e-02, 2.010e-02, -4.567e-03, 8.390e-02, 2.937e-01, -2.063e-01, -1.332e-01, -1.314e-01, -5.456e-02, 7.479e-03), r1);
	r2 = MulAdd(s0_1_1, M4(2.415e-01, -1.249e-01, -4.868e-02, -2.941e-01, 1.440e-01, -3.868e-02, 1.935e-01, -7.886e-02, -1.544e-01, 7.781e-02, 2.898e-01, 1.090e-01, -6.045e-03, -2.646e-01, 3.101e-02, 6.191e-01), r2);
	r3 = MulAdd(s0_1_1, M4(1.079e-01, -1.902e-01, -9.974e-02, -1.474e-01, -1.210e-01, 1.029e-01, 4.750e-02, 1.148e-01, -8.764e-02, 5.579e-02, -4.072e-01, 2.447e-01, 2.752e-02, 4.092e-01, 7.835e-02, 1.368e-01), r3);
	r0 = MulAdd(s0_1_2, M4(2.358e-01, 1.970e-02, 1.040e-01, -6.369e-02, 1.392e-01, 5.113e-02, 8.953e-02, 1.664e-02, -2.687e-02, -4.625e-02, 2.974e-03, -2.333e-02, 2.736e-01, 2.307e-01, -7.117e-03, 1.122e-01), r0);
	r1 = MulAdd(s0_1_2, M4(7.064e-02, 3.661e-01, 1.586e-01, 2.681e-02, 8.529e-02, 1.093e-01, -2.650e-02, 7.250e-02, -1.756e-03, 8.081e-02, -9.232e-02, 1.523e-02, -9.549e-02, -2.148e-01, -1.354e-01, 9.412e-02), r1);
	r2 = MulAdd(s0_1_2, M4(-4.057e-02, -9.272e-02, 3.213e-02, 1.145e-01, -1.868e-02, -2.920e-03, 6.856e-02, -5.715e-03, -3.192e-02, 3.549e-02, 6.533e-03, 3.360e-02, -5.462e-03, 1.632e-01, 2.958e-02, -4.908e-02), r2);
	r3 = MulAdd(s0_1_2, M4(7.843e-02, -7.788e-02, -6.734e-02, 7.397e-02, -2.117e-02, -3.820e-02, -2.562e-02, 5.411e-02, -2.021e-02, -2.325e-02, -4.072e-02, 1.913e-02, 1.360e-01, 2.447e-02, 1.919e-02, -3.717e-02), r3);
	r0 = MulAdd(s0_2_0, M4(7.028e-03, 1.238e-01, 7.583e-04, -9.915e-04, 1.285e-02, 1.032e-01, -2.850e-02, -4.570e-02, -1.145e-01, -4.164e-02, 6.259e-03, 1.093e-01, 3.508e-02, -1.544e-02, -2.219e-02, -6.001e-02), r0);
	r1 = MulAdd(s0_2_0, M4(1.528e-02, 6.267e-02, -1.666e-02, 4.701e-02, -4.517e-03, 1.071e-01, 3.263e-02, -1.811e-02, -9.593e-02, 1.484e-01, 5.956e-02, 3.071e-02, -4.925e-02, 6.963e-02, 1.256e-02, 7.498e-02), r1);
	r2 = MulAdd(s0_2_0, M4(1.366e-01, 1.424e-03, -9.027e-03, 3.738e-02, 5.130e-02, -1.249e-02, -1.276e-02, -7.970e-03, 3.248e-02, 7.498e-02, 7.221e-02, 7.081e-02, -1.047e-01, 5.279e-02, -2.655e-02, 7.406e-03), r2);
	r3 = MulAdd(s0_2_0, M4(1.011e-01, 1.680e-01, 2.701e-02, -1.533e-02, -6.714e-02, 1.672e-02, -9.642e-02, -1.036e-02, 4.010e-02, -1.604e-01, 1.320e-02, 4.202e-02, -4.743e-02, -1.440e-02, -2.535e-02, -2.057e-02), r3);
	r0 = MulAdd(s0_2_1, M4(-4.816e-02, 9.858e-02, -5.760e-02, -2.006e-02, 1.499e-01, -9.001e-02, -1.307e-02, -1.963e-02, -4.578e-02, 3.608e-02, 2.911e-03, -4.393e-02, -7.792e-02, -1.030e-01, 5.471e-03, -1.341e-01), r0);
	r1 = MulAdd(s0_2_1, M4(1.332e-02, 3.082e-02, -1.556e-02, -5.760e-03, -2.085e-02, 1.343e-02, -4.624e-02, -8.281e-02, -3.966e-02, 3.333e-02, 3.973e-02, -1.109e-01, -1.793e-02, -6.935e-03, 6.232e-02, 9.178e-02), r1);
	r2 = MulAdd(s0_2_1, M4(4.480e-02, -1.995e-02, -6.214e-02, -5.335e-02, 8.254e-02, -1.589e-02, -2.030e-02, -6.148e-02, 4.351e-02, -2.300e-02, -5.022e-03, 7.985e-02, 3.454e-02, 2.324e-02, -5.892e-02, 1.728e-01), r2);
	r3 = MulAdd(s0_2_1, M4(4.489e-02, -1.516e-01, -1.492e-01, -1.847e-02, 1.132e-01, 1.361e-01, -9.412e-02, 5.703e-02, -5.236e-02, -1.224e-01, -1.446e-01, 5.384e-02, 6.911e-02, 3.001e-01, 6.671e-02, 5.669e-02), r3);
	r0 = MulAdd(s0_2_2, M4(3.234e-02, 4.297e-03, 3.062e-02, -7.007e-02, -1.101e-01, 4.517e-02, -7.910e-03, -1.245e-01, 2.359e-02, 2.415e-02, 4.934e-03, -2.480e-03, 5.353e-04, 6.186e-02, -1.524e-02, 3.328e-02), r0);
	r1 = MulAdd(s0_2_2, M4(1.803e-02, 1.844e-01, 1.098e-01, -1.109e-01, -6.216e-02, 1.194e-01, -1.140e-02, -1.121e-01, 1.828e-02, 3.466e-02, 9.011e-02, -5.013e-02, -7.881e-02, -1.343e-01, -1.179e-01, 1.149e-01), r1);
	r2 = MulAdd(s0_2_2, M4(-7.520e-02, -3.307e-02, 6.520e-03, 4.070e-03, -1.491e-02, 7.610e-03, -5.475e-02, 2.019e-02, 2.728e-02, 7.747e-04, 1.654e-02, -6.390e-03, 3.227e-02, -2.753e-02, -1.826e-02, -1.643e-02), r2);
	r3 = MulAdd(s0_2_2, M4(-2.383e-02, 2.480e-02, -9.014e-02, 2.936e-02, -1.274e-02, 8.228e-02, 1.345e-02, -6.670e-04, -2.362e-02, 1.216e-02, -2.532e-02, 2.454e-03, -1.948e-01, -2.599e-01, -7.339e-02, 7.715e-04), r3);
	r0 = MulAdd(s1_0_0, M4(-1.147e-02, -2.002e-02, -1.815e-02, -6.712e-02, -7.015e-02, -1.918e-02, 2.340e-02, 4.633e-02, 6.683e-02, -4.341e-02, -2.791e-02, -3.267e-02, 5.151e-03, -4.892e-02, 3.221e-02, 3.616e-02), r0);
	r1 = MulAdd(s1_0_0, M4(1.348e-02, 1.144e-01, 4.187e-02, 9.740e-02, -7.492e-02, -1.032e-01, -1.084e-01, 1.126e-01, -5.621e-02, -4.199e-02, 6.069e-02, -2.907e-02, -2.201e-02, -1.041e-01, -6.289e-02, -5.844e-02), r1);
	r2 = MulAdd(s1_0_0, M4(-5.090e-02, 1.988e-02, -1.406e-02, 3.424e-02, -8.452e-02, 1.194e-01, 3.692e-02, 2.627e-02, -7.265e-02, -2.913e-02, -3.942e-02, 7.050e-03, -8.938e-03, -1.356e-02, 1.287e-02, -1.270e-05), r2);
	r3 = MulAdd(s1_0_0, M4(-5.410e-02, -3.332e-02, 3.753e-02, 7.664e-04, 3.430e-02, 6.753e-02, 9.790e-02, 1.849e-02, 3.963e-02, -2.951e-02, -3.288e-02, -1.347e-02, -1.468e-02, 7.521e-02, 4.090e-02, 3.622e-03), r3);
	r0 = MulAdd(s1_0_1, M4(3.777e-02, -7.901e-02, -4.441e-02, -8.065e-02, 1.837e-02, 6.534e-02, 2.501e-03, -3.498e-02, -1.386e-01, -1.453e-01, 3.630e-02, -5.776e-02, -1.165e-01, 7.841e-02, -1.329e-02, 4.426e-02), r0);
	r1 = MulAdd(s1_0_1, M4(1.994e-01, 7.885e-02, 2.421e-02, 1.196e-01, -1.883e-01, -1.169e-01, 1.919e-02, -9.775e-02, -3.179e-02, -2.647e-01, 9.743e-02, -7.888e-02, -1.821e-01, 5.652e-03, 2.013e-02, 7.931e-02), r1);
	r2 = MulAdd(s1_0_1, M4(-1.812e-01, 1.516e-01, 1.635e-03, -3.786e-02, 1.664e-01, -2.178e-01, 4.250e-02, -9.656e-02, 9.737e-04, -7.837e-02, 2.448e-02, 2.795e-01, 2.115e-01, -8.026e-02, -4.612e-02, 2.430e-02), r2);
	r3 = MulAdd(s1_0_1, M4(1.259e-01, 7.730e-02, 1.317e-02, -2.671e-02, -8.220e-02, -1.367e-01, -2.110e-02, -1.996e-02, -1.250e-01, 1.001e-01, -9.387e-02, 7.484e-02, 1.422e-02, 2.574e-02, -7.156e-02, -2.582e-02), r3);
	r0 = MulAdd(s1_0_2, M4(1.121e-01, 1.441e-01, 1.258e-02, -2.685e-02, 2.944e-02, 2.376e-02, 2.048e-02, -4.639e-02, -1.389e-01, -9.107e-02, -2.903e-02, -1.023e-02, -5.834e-02, -5.515e-02, 1.032e-02, 1.057e-02), r0);
	r1 = MulAdd(s1_0_2, M4(9.165e-02, 6.026e-02, -7.411e-02, 2.471e-02, -1.888e-01, 1.043e-01, 7.206e-02, -6.777e-03, 4.843e-02, 8.425e-02, -4.560e-03, 1.891e-02, -1.255e-01, -8.175e-02, 6.727e-02, -2.795e-02), r1);
	r2 = MulAdd(s1_0_2, M4(-1.597e-02, 4.612e-02, -4.454e-02, -1.639e-03, 2.414e-03, -8.587e-02, 2.386e-02, -1.169e-02, 6.642e-03, 8.896e-03, 7.199e-03, -3.941e-02, 6.533e-02, -3.099e-02, 6.647e-02, -1.812e-02), r2);
	r3 = MulAdd(s1_0_2, M4(2.514e-02, 1.241e-01, 3.635e-02, -1.995e-02, -2.658e-02, 3.721e-02, -3.490e-02, 1.132e-02, 5.989e-02, 1.333e-01, -5.855e-03, -7.150e-03, -1.521e-02, -9.446e-02, -1.244e-02, 2.515e-02), r3);
	r0 = MulAdd(s1_1_0, M4(4.191e-02, -5.113e-02, -5.434e-02, -1.747e-02, -1.095e-02, -7.902e-02, -9.213e-02, -4.968e-02, 6.955e-02, 2.157e-02, -7.202e-02, -1.509e-01, -6.839e-02, 3.097e-03, 1.642e-02, -1.127e-01), r0);
	r1 = MulAdd(s1_1_0, M4(9.448e-02, 2.550e-01, 5.427e-03, 6.264e-02, -9.321e-02, 2.263e-02, 2.451e-02, -7.101e-02, 5.512e-03, -1.641e-02, 6.400e-02, 1.558e-01, 9.242e-02, -1.981e-01, 8.167e-03, -1.470e-02), r1);
	r2 = MulAdd(s1_1_0, M4(4.788e-02, 2.070e-02, -8.120e-02, -1.484e-01, -2.541e-02, -1.637e-01, -4.762e-02, -1.173e-01, -5.531e-02, 5.835e-03, -2.826e-02, -2.274e-02, -2.104e-01, 4.814e-02, -3.946e-02, 6.850e-02), r2);
	r3 = MulAdd(s1_1_0, M4(-8.065e-02, 4.837e-02, -1.448e-01, -8.208e-02, -2.607e-01, -3.130e-01, 6.579e-02, -4.067e-02, -3.235e-02, 4.789e-02, -1.516e-01, -8.872e-02, -1.165e-01, -4.205e-02, 1.421e-01, 2.675e-02), r3);
	r0 = MulAdd(s1_1_1, M4(1.338e-01, 1.077e-01, -6.389e-02, -8.813e-02, -6.846e-02, -6.702e-01, 2.038e-02, -4.843e-01, -1.207e-01, -2.063e-01, -1.997e-02, 6.425e-03, -1.577e-01, -1.313e-01, -5.196e-02, -1.891e-01), r0);
	r1 = MulAdd(s1_1_1, M4(3.997e-01, -2.213e-01, 1.796e-01, -6.560e-02, 1.134e-02, -1.215e-01, 3.450e-01, 1.150e-01, 1.529e-02, 6.890e-02, 6.063e-02, 1.070e-01, 3.590e-01, 2.005e-01, -2.926e-01, 4.124e-01), r1);
	r2 = MulAdd(s1_1_1, M4(3.579e-01, -1.259e-01, -1.013e-01, -2.476e-01, -4.294e-01, -5.259e-02, -1.181e-01, 8.537e-01, 1.702e-01, -4.359e-02, -1.018e-02, -2.408e-02, -5.985e-01, 5.510e-01, -3.003e-02, 5.283e-04), r2);
	r3 = MulAdd(s1_1_1, M4(-2.939e-01, -2.335e-01, 3.946e-02, -6.281e-02, -2.238e-01, 3.358e-01, -8.112e-02, 1.264e-01, -1.245e-01, 8.031e-02, -6.718e-02, -1.349e-02, 4.269e-01, 4.120e-01, 1.481e-01, 7.473e-02), r3);
	r0 = MulAdd(s1_1_2, M4(1.704e-01, 2.341e-01, -5.514e-02, 1.630e-02, -3.880e-01, -4.036e-02, -3.677e-02, -1.358e-01, -7.230e-02, -1.949e-01, 5.907e-03, -6.975e-03, -1.077e-01, -2.125e-01, 8.487e-02, -6.423e-02), r0);
	r1 = MulAdd(s1_1_2, M4(6.125e-02, -1.144e-01, -7.565e-02, -1.138e-01, -4.487e-02, -3.101e-01, 1.472e-01, 1.265e-01, -6.638e-03, 8.450e-02, -5.835e-02, 7.740e-02, 4.801e-02, -5.294e-03, -6.963e-03, 2.346e-02), r1);
	r2 = MulAdd(s1_1_2, M4(1.681e-01, 9.763e-02, -5.565e-02, -7.573e-02, 5.698e-02, -8.562e-02, -3.742e-02, 1.283e-01, 5.876e-02, -1.546e-02, 5.428e-03, 9.513e-03, -3.979e-01, 7.643e-02, 6.860e-02, 9.287e-02), r2);
	r3 = MulAdd(s1_1_2, M4(1.502e-01, 1.005e-01, 1.219e-01, -3.919e-02, 8.083e-02, 6.054e-02, 1.165e-01, -3.724e-02, -3.930e-03, 1.618e-01, -1.141e-01, 1.045e-02, -1.719e-02, -6.709e-02, -1.248e-01, 5.627e-02), r3);
	r0 = MulAdd(s1_2_0, M4(-1.028e-01, 6.475e-02, 1.593e-02, 3.042e-02, -3.316e-02, -2.036e-02, -3.848e-02, -1.050e-01, 1.534e-02, 4.809e-02, -1.319e-02, 2.919e-02, -3.795e-02, -1.341e-01, -2.022e-02, 1.448e-02), r0);
	r1 = MulAdd(s1_2_0, M4(5.460e-02, -2.777e-02, 4.623e-02, 7.754e-03, 2.048e-02, 6.007e-02, 1.248e-02, 3.533e-02, 3.827e-02, 4.928e-02, 5.587e-02, 4.360e-02, -6.844e-02, 2.707e-02, 3.531e-02, 9.174e-02), r1);
	r2 = MulAdd(s1_2_0, M4(1.761e-01, 5.291e-02, 1.098e-02, -6.690e-02, -3.974e-03, -3.873e-02, -3.640e-02, 2.186e-02, 3.011e-03, -2.661e-02, -1.618e-02, -6.887e-02, 5.056e-02, 5.966e-02, -1.095e-02, -9.302e-02), r2);
	r3 = MulAdd(s1_2_0, M4(-1.616e-01, 3.947e-01, -1.140e-01, -4.033e-03, -1.951e-01, 1.082e-01, 1.927e-03, -6.406e-02, -8.847e-02, -4.162e-01, -3.996e-02, -2.189e-02, -3.340e-02, 1.929e-01, -6.431e-02, 5.352e-02), r3);
	r0 = MulAdd(s1_2_1, M4(4.105e-01, 2.018e-01, 1.620e-01, 2.446e-01, 2.217e-02, -5.187e-02, -9.298e-03, -8.181e-02, 4.987e-02, -2.500e-02, -3.292e-02, -5.920e-02, -4.067e-01, -7.347e-02, 2.285e-01, 2.883e-01), r0);
	r1 = MulAdd(s1_2_1, M4(2.213e-01, -1.500e-01, -2.041e-01, -2.418e-01, -2.444e-02, 4.540e-02, 1.327e-01, 9.598e-02, 2.984e-02, 2.240e-02, 6.744e-02, 1.997e-01, -1.500e-01, -1.068e-01, -1.128e-01, 3.124e-02), r1);
	r2 = MulAdd(s1_2_1, M4(1.554e-01, -4.265e-02, 2.800e-01, -1.975e-01, 7.587e-02, -7.151e-02, -5.526e-02, 6.614e-02, -7.321e-02, -3.594e-02, -1.046e-02, 7.965e-02, 2.804e-01, 4.385e-01, 2.420e-01, 1.672e-01), r2);
	r3 = MulAdd(s1_2_1, M4(9.362e-02, 2.031e-01, -1.847e-01, 1.504e-01, -2.602e-02, 2.242e-02, 2.180e-02, -8.180e-02, -1.664e-01, -3.621e-01, -3.297e-02, -3.497e-03, 1.840e-01, -1.969e-01, -3.356e-02, 3.387e-01), r3);
	r0 = MulAdd(s1_2_2, M4(5.393e-02, 5.230e-02, -2.754e-02, 1.632e-02, -1.321e-01, 7.366e-03, -4.148e-03, 5.137e-03, -3.071e-02, 1.110e-02, 4.765e-03, 3.780e-02, -6.115e-02, 1.937e-03, 5.770e-02, -7.134e-02), r0);
	r1 = MulAdd(s1_2_2, M4(7.547e-02, 7.557e-02, -1.245e-01, 9.287e-02, 9.243e-03, -6.865e-02, 4.483e-02, 4.553e-02, 1.561e-02, 4.061e-02, 1.665e-02, 8.132e-03, -4.316e-02, -2.103e-02, 9.584e-02, -9.900e-02), r1);
	r2 = MulAdd(s1_2_2, M4(5.648e-02, -2.244e-03, -1.603e-02, -1.678e-01, -9.880e-03, 1.695e-02, 8.171e-03, 2.166e-02, 7.524e-02, -2.715e-02, 3.089e-02, -1.577e-02, -1.627e-01, 1.345e-01, 2.920e-02, 1.773e-01), r2);
	r3 = MulAdd(s1_2_2, M4(2.641e-02, 9.526e-02, -8.639e-03, -3.137e-02, 2.820e-02, 4.498e-02, 2.246e-02, -1.356e-02, 3.280e-02, -1.588e-01, -1.514e-02, 2.687e-02, -7.580e-02, 1.165e-01, -5.261e-02, 7.296e-02), r3);
	s0_0_0 = L2(-1.0, -1.0); s0_0_1 = L2(0.0, -1.0); s0_0_2 = L2(1.0, -1.0);
	s0_1_0 = L2(-1.0, 0.0); s0_1_1 = L2(0.0, 0.0); s0_1_2 = L2(1.0, 0.0);
	s0_2_0 = L2(-1.0, 1.0); s0_2_1 = L2(0.0, 1.0); s0_2_2 = L2(1.0, 1.0);
	s1_0_0 = L3(-1.0, -1.0); s1_0_1 = L3(0.0, -1.0); s1_0_2 = L3(1.0, -1.0);
	s1_1_0 = L3(-1.0, 0.0); s1_1_1 = L3(0.0, 0.0); s1_1_2 = L3(1.0, 0.0);
	s1_2_0 = L3(-1.0, 1.0); s1_2_1 = L3(0.0, 1.0); s1_2_2 = L3(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(-4.013e-02, 1.058e-01, 1.051e-02, 2.406e-02, -1.761e-01, -3.486e-02, -3.776e-02, -4.016e-02, -2.955e-02, 6.106e-02, 1.499e-03, -2.722e-02, 3.684e-03, 1.705e-02, -2.050e-02, -5.383e-02), r0);
	r1 = MulAdd(s0_0_0, M4(-2.936e-03, 1.105e-02, -1.017e-02, -4.760e-03, -2.075e-03, -2.441e-01, 2.186e-02, 9.494e-02, 6.219e-02, -5.979e-02, 8.295e-03, 1.325e-02, -2.368e-02, -1.636e-01, 5.246e-02, 6.860e-02), r1);
	r2 = MulAdd(s0_0_0, M4(9.202e-02, 5.058e-02, -8.348e-05, -3.231e-02, -4.432e-02, 3.803e-02, -1.180e-02, -6.341e-02, 3.739e-02, 6.333e-02, 1.150e-01, -1.946e-02, -2.817e-02, 3.119e-02, -5.857e-02, -3.882e-02), r2);
	r3 = MulAdd(s0_0_0, M4(3.918e-02, 2.826e-02, 4.301e-03, 1.717e-02, -7.255e-02, 1.972e-02, -5.765e-02, -4.555e-02, 6.577e-02, 3.567e-02, -3.978e-03, 5.309e-02, 2.936e-03, -1.052e-01, -3.410e-02, -2.394e-02), r3);
	r0 = MulAdd(s0_0_1, M4(9.045e-02, -6.946e-02, -2.059e-02, -1.189e-01, -4.478e-01, -3.349e-01, -2.951e-02, -1.343e-01, 2.710e-01, 1.640e-01, 5.714e-02, 5.449e-02, -4.460e-02, -1.227e-01, 1.996e-02, 8.341e-02), r0);
	r1 = MulAdd(s0_0_1, M4(-1.913e-02, 1.795e-01, 5.844e-02, -9.292e-02, 5.107e-02, 2.438e-01, -8.521e-02, 4.268e-01, 2.313e-02, -1.478e-01, -2.378e-01, -2.735e-01, -5.247e-02, -1.927e-01, -4.162e-02, -1.799e-02), r1);
	r2 = MulAdd(s0_0_1, M4(8.298e-02, -1.053e-01, 2.364e-03, 5.385e-02, -2.222e-01, 2.782e-01, -5.746e-02, -3.637e-02, -4.224e-01, 3.922e-02, 1.970e-01, 6.369e-02, -9.476e-02, 6.966e-02, 3.315e-03, 1.100e-01), r2);
	r3 = MulAdd(s0_0_1, M4(-2.069e-02, -1.349e-01, -2.295e-01, 3.759e-03, 1.791e-01, 2.797e-01, -3.337e-02, -4.989e-02, 1.780e-02, -1.511e-01, 2.023e-01, 7.772e-03, 2.724e-02, 5.870e-02, 8.767e-02, 1.843e-02), r3);
	r0 = MulAdd(s0_0_2, M4(-1.039e-01, -7.115e-02, 4.966e-02, -3.634e-02, -8.047e-02, -1.226e-02, -3.031e-02, -6.140e-02, -1.428e-01, -1.294e-01, -7.369e-02, -1.070e-01, -5.131e-02, -4.312e-02, -5.035e-03, 3.518e-02), r0);
	r1 = MulAdd(s0_0_2, M4(-1.148e-01, -2.462e-01, 1.688e-01, -4.188e-03, -2.352e-02, -1.567e-01, 1.376e-01, 1.115e-01, -2.650e-02, -4.380e-02, 6.518e-02, -4.279e-02, -4.091e-02, 9.780e-03, -4.695e-02, -8.761e-02), r1);
	r2 = MulAdd(s0_0_2, M4(4.133e-02, -5.647e-02, 7.139e-02, -3.447e-04, -1.329e-01, 1.250e-01, -4.134e-02, -1.528e-02, -1.743e-01, -1.173e-01, -2.098e-01, -9.969e-02, -2.806e-02, 3.671e-02, -5.097e-03, -9.654e-03), r2);
	r3 = MulAdd(s0_0_2, M4(-2.482e-02, -4.333e-02, -2.240e-02, 2.980e-02, -2.386e-02, 1.608e-01, 2.454e-02, -3.235e-02, -1.668e-02, 4.398e-02, 8.562e-03, -7.038e-02, 5.966e-03, -4.399e-05, 6.111e-02, -4.307e-03), r3);
	r0 = MulAdd(s0_1_0, M4(-5.273e-02, 7.986e-02, 5.412e-02, 1.214e-01, -2.270e-01, 3.109e-02, 4.496e-02, 9.482e-02, -1.122e-01, -2.116e-01, 2.992e-02, 4.544e-04, 3.789e-02, 1.607e-01, 4.407e-02, 1.067e-01), r0);
	r1 = MulAdd(s0_1_0, M4(-3.525e-02, -1.125e-02, 1.978e-04, 1.739e-01, 3.578e-02, -2.433e-01, 1.653e-01, 2.097e-01, -5.270e-02, 4.173e-02, 2.737e-02, -2.482e-02, -3.135e-02, -1.791e-01, 8.565e-02, 1.200e-01), r1);
	r2 = MulAdd(s0_1_0, M4(1.382e-01, 1.313e-01, 5.635e-02, 6.115e-02, 7.347e-02, 1.519e-01, 3.921e-02, -1.171e-02, 1.986e-03, -2.798e-02, 1.900e-02, -6.314e-02, 5.943e-02, 2.056e-01, -1.286e-02, 1.957e-02), r2);
	r3 = MulAdd(s0_1_0, M4(9.209e-02, 1.146e-01, 5.076e-02, 5.316e-02, 1.969e-01, 1.330e-01, 4.239e-02, 3.058e-02, -1.000e-01, -5.856e-03, -2.337e-02, -1.137e-02, 2.144e-01, -1.791e-01, 2.899e-02, 2.580e-02), r3);
	r0 = MulAdd(s0_1_1, M4(5.957e-02, -1.695e-01, -3.677e-02, -2.375e-01, -2.357e-01, -2.202e-01, 1.884e-01, 2.803e-01, -2.024e-01, 1.015e-01, 3.080e-01, 4.166e-01, -8.719e-02, -5.227e-01, -1.541e-01, -1.077e-01), r0);
	r1 = MulAdd(s0_1_1, M4(5.632e-02, 2.654e-01, -2.921e-02, 1.025e-01, 7.251e-02, 7.934e-02, -3.167e-02, 5.402e-01, 8.575e-03, 1.421e-01, 2.922e-02, 1.583e-01, -2.003e-01, -5.332e-01, -5.163e-01, -6.739e-02), r1);
	r2 = MulAdd(s0_1_1, M4(-3.114e-01, -1.508e-01, 1.707e-02, 1.394e-01, 1.987e-01, 2.059e-01, 3.047e-01, 8.533e-03, 5.384e-01, 6.513e-02, 5.441e-01, 3.429e-01, 2.874e-01, -4.018e-01, -2.154e-01, 1.012e-01), r2);
	r3 = MulAdd(s0_1_1, M4(-5.143e-01, 1.464e-02, -2.275e-01, -1.033e-02, 2.081e-01, -2.823e-01, 1.207e-02, 1.451e-01, 1.386e-01, -5.907e-02, -1.042e-01, -4.717e-01, -3.176e-01, -2.441e-02, 1.119e-01, -1.130e-01), r3);
	r0 = MulAdd(s0_1_2, M4(-1.930e-01, -3.209e-01, 9.407e-02, -2.135e-01, 1.249e-01, 1.878e-01, 5.921e-02, 4.135e-02, 9.994e-02, 1.121e-01, 7.551e-02, 4.532e-02, 1.105e-01, 2.966e-02, -3.111e-02, 5.267e-02), r0);
	r1 = MulAdd(s0_1_2, M4(2.988e-02, 9.664e-03, 2.188e-01, -1.538e-02, -8.860e-02, -4.675e-01, -1.370e-01, 1.209e-03, 1.050e-02, 5.433e-02, -2.917e-02, -1.107e-01, -6.422e-02, -1.107e-01, -1.596e-01, -7.003e-02), r1);
	r2 = MulAdd(s0_1_2, M4(1.064e-02, -2.125e-01, 2.143e-02, 6.764e-01, 7.434e-03, 1.851e-01, 1.710e-02, 3.420e-02, -2.872e-01, 1.470e-01, 5.371e-02, -7.160e-02, 1.694e-01, -9.060e-02, -2.549e-02, -6.063e-02), r2);
	r3 = MulAdd(s0_1_2, M4(7.606e-02, -1.681e-01, 1.495e-01, 1.381e-01, 1.592e-02, 3.476e-02, 5.534e-02, 8.082e-03, -1.215e-03, 8.819e-03, -1.419e-01, 1.622e-01, -3.134e-02, 4.110e-03, 1.588e-01, -1.739e-03), r3);
	r0 = MulAdd(s0_2_0, M4(-3.466e-02, -3.468e-02, 1.626e-02, 7.281e-02, -4.159e-02, 1.696e-02, 3.383e-03, 1.098e-02, 3.116e-02, -2.892e-03, 9.303e-03, -1.613e-02, 7.866e-02, 5.400e-03, -6.045e-03, 1.897e-02), r0);
	r1 = MulAdd(s0_2_0, M4(-2.813e-02, -5.484e-02, -3.133e-02, -7.801e-02, -3.140e-02, -1.368e-01, 5.358e-02, 1.130e-01, -2.457e-02, 7.918e-03, -2.564e-02, -8.570e-02, 4.714e-02, 1.470e-01, 2.292e-02, -6.956e-02), r1);
	r2 = MulAdd(s0_2_0, M4(2.696e-02, 5.388e-02, 1.896e-02, 7.579e-03, -3.646e-02, 1.038e-01, -2.051e-02, 4.543e-02, -5.014e-02, -3.358e-02, 1.189e-02, -1.949e-03, 2.929e-02, 5.266e-03, -3.401e-02, -5.044e-02), r2);
	r3 = MulAdd(s0_2_0, M4(6.513e-02, 9.245e-02, 4.385e-02, 1.752e-02, 1.786e-01, 4.045e-02, 4.855e-03, 1.477e-02, -9.103e-02, -1.830e-01, 4.465e-02, 1.053e-02, 1.350e-02, -2.957e-01, 3.116e-02, -5.604e-02), r3);
	r0 = MulAdd(s0_2_1, M4(1.914e-03, 2.209e-01, 2.146e-02, -1.770e-02, -2.436e-01, -2.130e-01, -7.934e-02, -1.812e-01, -6.749e-03, -5.202e-02, 3.861e-02, 3.743e-02, 1.408e-02, 4.850e-02, -1.399e-02, -9.042e-02), r0);
	r1 = MulAdd(s0_2_1, M4(-8.893e-02, -9.465e-02, -4.568e-02, -2.607e-01, -9.659e-02, -3.788e-02, 3.673e-02, -1.928e-02, -3.216e-02, 7.105e-02, 2.790e-02, 3.447e-02, 1.151e-01, -1.382e-01, -6.473e-03, 4.253e-02), r1);
	r2 = MulAdd(s0_2_1, M4(1.893e-01, -1.441e-01, 6.883e-02, -1.693e-02, -1.819e-01, 1.132e-01, -1.410e-01, -2.071e-02, 1.166e-01, 1.604e-02, -1.550e-02, 4.326e-02, -1.312e-01, -7.248e-02, -5.033e-02, 8.915e-02), r2);
	r3 = MulAdd(s0_2_1, M4(-7.318e-03, 3.203e-01, 2.095e-02, 7.610e-02, 1.606e-01, 2.393e-02, 5.408e-02, -3.326e-04, 1.670e-01, 7.168e-02, -1.004e-02, -9.454e-02, -3.760e-01, -2.059e-01, 5.467e-02, -5.593e-02), r3);
	r0 = MulAdd(s0_2_2, M4(8.663e-02, -7.698e-02, -3.734e-02, -1.061e-01, -2.067e-01, -3.466e-02, 2.165e-02, 1.297e-02, -2.122e-02, 3.042e-02, 1.718e-02, 1.455e-02, 9.448e-02, 1.187e-02, 8.725e-04, 2.171e-02), r0);
	r1 = MulAdd(s0_2_2, M4(-7.429e-02, 1.189e-01, -1.334e-03, 1.092e-02, -9.512e-03, -1.141e-01, -3.604e-02, 6.118e-02, -8.374e-02, -4.526e-02, -3.055e-02, -7.537e-02, 2.297e-02, -5.279e-02, 3.676e-02, 4.029e-02), r1);
	r2 = MulAdd(s0_2_2, M4(7.991e-02, -4.816e-02, -8.618e-02, -5.153e-02, -5.281e-02, 1.699e-02, -1.248e-02, 4.090e-02, -4.386e-03, 1.646e-02, -1.046e-02, 4.288e-02, -6.417e-02, -4.338e-02, 2.259e-02, -2.196e-02), r2);
	r3 = MulAdd(s0_2_2, M4(6.582e-03, 1.394e-01, -5.311e-02, -6.643e-02, -1.033e-01, 2.601e-02, 6.445e-03, 1.518e-02, -1.019e-01, -1.577e-01, -8.809e-03, 1.144e-01, -9.752e-03, -7.572e-02, 9.303e-03, -1.885e-02), r3);
	r0 = MulAdd(s1_0_0, M4(-3.485e-04, 6.140e-02, -7.149e-03, -1.958e-02, -1.411e-01, -4.083e-02, -1.199e-02, 2.418e-02, 6.772e-03, -9.788e-02, 2.240e-02, 4.503e-02, -2.978e-02, -5.869e-02, 2.472e-02, -5.867e-03), r0);
	r1 = MulAdd(s1_0_0, M4(7.515e-02, 4.678e-02, 6.643e-03, 1.376e-02, -8.377e-02, 2.381e-02, 4.513e-02, -1.261e-01, -5.769e-02, -8.726e-02, 5.551e-02, 9.493e-03, -4.177e-02, 1.473e-02, -5.493e-02, 1.867e-02), r1);
	r2 = MulAdd(s1_0_0, M4(7.330e-02, 5.062e-02, 9.859e-03, -1.069e-02, 8.612e-02, -1.265e-01, -3.497e-03, 2.185e-02, -3.693e-02, 4.259e-02, 7.584e-03, -6.426e-02, 5.883e-03, -7.007e-02, -7.773e-03, 2.192e-02), r2);
	r3 = MulAdd(s1_0_0, M4(6.627e-02, -5.439e-02, -7.116e-02, 1.239e-02, -6.870e-02, -1.579e-01, -6.022e-02, 5.651e-02, -1.303e-01, 2.707e-02, -6.322e-02, 1.376e-03, -3.485e-03, 1.112e-01, 7.397e-02, -1.011e-02), r3);
	r0 = MulAdd(s1_0_1, M4(1.096e-01, 6.069e-02, 2.209e-02, 5.464e-02, -7.191e-03, -1.557e-03, 1.620e-02, 4.179e-02, -1.321e-01, -4.181e-03, -6.619e-02, -1.460e-01, -1.692e-02, -5.449e-02, 5.371e-02, -3.542e-02), r0);
	r1 = MulAdd(s1_0_1, M4(1.024e-01, 1.057e-01, -2.779e-02, -2.104e-01, 8.741e-02, 1.274e-01, -1.791e-02, -8.855e-02, 2.838e-03, 1.442e-01, -1.892e-01, 2.900e-01, 1.432e-02, 1.495e-01, 2.211e-02, 1.251e-01), r1);
	r2 = MulAdd(s1_0_1, M4(-8.280e-02, -1.353e-01, 5.405e-02, -7.313e-02, 2.408e-01, 4.622e-02, 9.892e-02, -7.437e-03, 1.850e-01, 1.411e-01, -8.526e-02, 1.941e-02, 5.828e-02, 4.358e-02, -9.623e-02, -1.723e-02), r2);
	r3 = MulAdd(s1_0_1, M4(5.864e-04, -1.972e-01, 7.993e-02, 2.974e-02, -9.047e-03, -6.402e-02, -1.371e-01, 7.608e-02, -6.470e-02, 1.140e-01, -1.448e-01, -5.042e-02, -3.997e-02, 2.767e-02, 1.032e-02, -4.382e-02), r3);
	r0 = MulAdd(s1_0_2, M4(2.368e-01, 1.598e-01, 6.325e-02, 1.013e-01, 1.408e-01, 1.028e-01, -3.016e-02, 1.049e-04, -2.566e-02, 6.378e-02, -2.912e-02, -7.464e-02, -2.214e-02, 3.921e-02, -2.946e-02, -4.935e-02), r0);
	r1 = MulAdd(s1_0_2, M4(-7.508e-04, 3.257e-02, 9.399e-02, -1.723e-01, 3.953e-02, -3.994e-02, -1.319e-02, 8.179e-02, 1.083e-01, -5.295e-02, 5.330e-02, 8.503e-02, -1.742e-02, -1.964e-01, 5.347e-02, 5.647e-02), r1);
	r2 = MulAdd(s1_0_2, M4(-7.667e-03, -4.877e-02, 4.748e-02, -4.061e-02, 6.914e-02, 2.637e-02, 4.514e-02, 4.992e-02, 6.762e-02, -2.589e-02, -1.791e-02, -4.611e-02, 6.344e-02, -3.600e-02, -7.706e-02, -1.570e-02), r2);
	r3 = MulAdd(s1_0_2, M4(-7.360e-02, 7.692e-04, 9.638e-02, 4.415e-02, 4.438e-03, -6.185e-03, -8.714e-03, -1.885e-02, 6.390e-02, 4.761e-02, -1.068e-01, -1.282e-02, -4.384e-04, 5.496e-02, 2.183e-04, -2.488e-02), r3);
	r0 = MulAdd(s1_1_0, M4(3.453e-02, 6.687e-03, 2.871e-02, 1.184e-01, 2.683e-02, 6.017e-02, -4.960e-02, -3.875e-02, 6.468e-02, 1.610e-02, 7.354e-02, 9.228e-02, 5.591e-02, 1.205e-01, -6.274e-02, -7.200e-02), r0);
	r1 = MulAdd(s1_1_0, M4(-4.445e-02, 1.967e-01, 2.496e-02, 2.456e-03, 4.640e-02, 9.855e-03, 4.438e-02, 2.169e-01, -2.103e-02, -1.688e-01, -6.812e-02, -6.911e-02, 2.533e-02, -1.004e-01, 5.201e-02, 1.768e-03), r1);
	r2 = MulAdd(s1_1_0, M4(1.271e-01, -2.230e-02, 6.139e-02, -6.215e-02, -1.226e-01, -4.823e-02, -6.779e-02, 1.057e-01, -3.473e-02, -4.230e-02, 3.506e-02, 3.044e-02, -1.427e-01, 7.472e-02, -5.641e-02, 5.384e-02), r2);
	r3 = MulAdd(s1_1_0, M4(-7.152e-03, -1.296e-02, 3.111e-02, 1.279e-02, 2.309e-01, 6.838e-02, -1.641e-01, 6.654e-03, 6.804e-02, -1.499e-01, 2.076e-01, 4.412e-02, 4.791e-02, 3.974e-02, -1.441e-01, 3.268e-02), r3);
	r0 = MulAdd(s1_1_1, M4(1.546e-01, 2.433e-01, 1.579e-01, -5.754e-02, 4.677e-01, 2.083e-01, 7.517e-01, 5.395e-02, -1.123e-01, -2.910e-01, -3.223e-01, 5.989e-02, 2.370e-01, -1.798e-01, 3.270e-03, 6.322e-02), r0);
	r1 = MulAdd(s1_1_1, M4(-7.771e-02, 1.345e-01, -7.636e-02, -8.714e-02, -3.150e-02, -2.600e-01, -4.108e-01, -3.889e-01, -1.275e-01, -4.707e-01, -3.130e-01, 3.292e-01, -5.648e-02, -1.738e-01, -3.354e-01, -6.156e-01), r1);
	r2 = MulAdd(s1_1_1, M4(-7.611e-02, 2.250e-04, 2.747e-01, 7.264e-02, -3.393e-01, -1.327e-01, -4.826e-01, -4.147e-01, 1.477e-01, -2.109e-01, -4.660e-01, -2.244e-01, -2.764e-01, -4.505e-01, 1.850e-01, 3.172e-02), r2);
	r3 = MulAdd(s1_1_1, M4(2.750e-01, 1.242e-01, 1.092e-01, 1.550e-01, -2.466e-01, -3.107e-01, 1.460e-01, 1.826e-01, 1.628e-02, -6.361e-01, 3.408e-01, -3.057e-01, -5.371e-01, -1.563e-01, 6.214e-01, 3.568e-01), r3);
	r0 = MulAdd(s1_1_2, M4(4.179e-01, 3.328e-01, 1.174e-01, -3.259e-02, -1.720e-01, -1.034e-01, -7.183e-03, -6.683e-02, -1.751e-01, -2.145e-01, -8.325e-02, -1.282e-01, -2.981e-01, -2.145e-01, -3.291e-01, 1.933e-03), r0);
	r1 = MulAdd(s1_1_2, M4(8.325e-02, 1.535e-02, -4.083e-02, -4.073e-01, 5.907e-03, 3.140e-02, 1.078e-01, 1.134e-02, -7.904e-02, 9.811e-02, -6.787e-03, 5.720e-02, 1.305e-01, 3.490e-01, 5.391e-01, 1.802e-01), r1);
	r2 = MulAdd(s1_1_2, M4(-9.797e-02, 1.801e-02, -2.199e-02, -6.896e-02, 1.343e-01, -1.583e-02, -5.557e-02, 1.916e-01, 3.970e-02, -1.250e-01, -4.410e-02, 4.138e-02, -1.366e-01, 4.272e-02, 3.554e-01, 2.594e-02), r2);
	r3 = MulAdd(s1_1_2, M4(-1.511e-02, -2.160e-02, -9.431e-03, 3.377e-02, 2.230e-02, 6.255e-02, 5.218e-02, -7.554e-02, -2.489e-02, 2.598e-02, -9.041e-02, 1.953e-02, 1.077e-01, -9.835e-02, -2.246e-01, 1.587e-01), r3);
	r0 = MulAdd(s1_2_0, M4(9.912e-02, -2.447e-02, -3.211e-02, -8.954e-02, -2.588e-03, -6.348e-02, -1.727e-02, 3.060e-02, 2.270e-02, 3.553e-02, -1.289e-02, -7.368e-02, -5.112e-02, 2.145e-02, 7.455e-03, 6.042e-02), r0);
	r1 = MulAdd(s1_2_0, M4(1.347e-02, 8.677e-02, -1.180e-02, -1.135e-01, 2.834e-02, -3.890e-02, 1.258e-02, -8.638e-03, -1.908e-02, -3.231e-02, -1.794e-02, -9.269e-03, 6.004e-04, 4.280e-02, -1.218e-02, 5.696e-02), r1);
	r2 = MulAdd(s1_2_0, M4(-1.731e-02, -1.264e-01, -9.238e-03, -3.629e-03, 2.025e-01, 4.016e-03, 3.091e-02, 6.161e-04, -1.134e-01, -3.282e-02, -5.902e-02, -1.708e-02, 1.243e-01, 5.749e-02, 4.552e-02, 4.176e-03), r2);
	r3 = MulAdd(s1_2_0, M4(-9.854e-02, 3.286e-02, 3.632e-02, 3.448e-03, 1.873e-01, 6.392e-02, -1.088e-01, -4.053e-02, -1.022e-01, -3.167e-01, 6.171e-02, -1.796e-02, 9.452e-02, 7.897e-02, -1.430e-02, -1.788e-02), r3);
	r0 = MulAdd(s1_2_1, M4(-1.328e-02, 4.370e-02, 4.092e-02, 1.897e-01, 2.161e-02, 1.131e-01, -1.138e-01, -5.479e-02, 9.825e-02, -5.633e-02, -4.726e-03, 1.564e-02, -1.518e-01, 4.981e-02, 9.790e-02, 9.092e-02), r0);
	r1 = MulAdd(s1_2_1, M4(5.334e-02, 2.192e-01, -3.800e-02, -1.622e-01, -3.402e-02, -1.635e-02, -4.650e-02, -8.959e-02, -5.496e-02, -6.726e-04, -8.143e-02, -4.552e-02, -1.812e-02, -1.726e-01, 5.704e-02, 1.134e-02), r1);
	r2 = MulAdd(s1_2_1, M4(1.313e-01, -7.491e-02, -1.125e-03, -1.313e-01, -1.655e-01, 4.539e-02, 1.077e-01, -3.386e-03, -6.713e-02, 2.498e-02, -1.169e-01, -5.948e-03, 1.880e-01, -9.624e-02, 1.763e-01, 6.605e-02), r2);
	r3 = MulAdd(s1_2_1, M4(3.541e-01, 7.937e-02, 6.979e-02, 6.121e-02, -3.095e-01, -2.202e-01, -4.228e-02, 4.835e-01, -2.900e-01, -5.476e-01, 1.626e-01, -9.302e-02, -3.489e-01, -3.507e-01, -7.741e-02, 3.139e-02), r3);
	r0 = MulAdd(s1_2_2, M4(1.111e-01, 1.675e-01, 4.655e-02, -9.346e-03, -8.984e-03, -1.072e-02, 2.647e-02, 1.205e-02, -1.274e-01, -7.748e-02, -3.029e-02, -5.672e-02, 3.896e-03, -1.408e-01, -4.966e-03, 3.000e-02), r0);
	r1 = MulAdd(s1_2_2, M4(1.211e-02, 1.057e-01, 6.044e-02, -2.086e-01, 4.963e-02, 7.121e-02, -2.644e-02, -3.163e-02, -3.154e-02, 1.079e-01, 1.090e-01, 7.692e-03, -3.011e-02, -7.279e-02, -7.520e-02, 1.226e-01), r1);
	r2 = MulAdd(s1_2_2, M4(-9.275e-02, -1.003e-01, -1.739e-02, -3.117e-02, 9.882e-02, -6.673e-03, 3.016e-02, -5.315e-02, 1.671e-02, 1.691e-02, -3.770e-02, 7.033e-02, 1.319e-01, 4.568e-02, 1.215e-01, 4.392e-02), r2);
	r3 = MulAdd(s1_2_2, M4(-8.521e-02, -7.011e-02, -1.523e-02, 2.019e-02, 7.121e-02, 6.714e-02, -3.814e-02, -9.032e-02, 8.782e-02, 1.792e-01, 2.576e-02, -4.981e-02, 5.135e-02, 2.176e-02, -6.500e-02, 7.913e-02), r3);
	r0 = max(r0, 0.0);
	T4[gxy] = r0;
	r1 = max(r1, 0.0);
	T5[gxy] = r1;
	r2 = max(r2, 0.0);
	T6[gxy] = r2;
	r3 = max(r3, 0.0);
	T7[gxy] = r3;
}

//!PASS 5
//!DESC conv4 (16x16)
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN T4, T5, T6, T7
//!OUT T0, T1, T2, T3

#define L0(x, y) V4(O(T4, x, y))
#define L1(x, y) V4(O(T5, x, y))
#define L2(x, y) V4(O(T6, x, y))
#define L3(x, y) V4(O(T7, x, y))

void Pass5(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 sz = GetInputSize();
	if (gxy.x >= sz.x || gxy.y >= sz.y)
		return;
	float2 pos = (gxy + 0.5) * pt;
	V4 s0_0_0, s0_0_1, s0_0_2, s0_1_0, s0_1_1, s0_1_2, s0_2_0, s0_2_1, s0_2_2, s1_0_0, s1_0_1, s1_0_2, s1_1_0, s1_1_1, s1_1_2, s1_2_0, s1_2_1, s1_2_2;
	V4 r0 = 0.0, r1 = 0.0, r2 = 0.0, r3 = 0.0;
	s0_0_0 = L0(-1.0, -1.0); s0_0_1 = L0(0.0, -1.0); s0_0_2 = L0(1.0, -1.0);
	s0_1_0 = L0(-1.0, 0.0); s0_1_1 = L0(0.0, 0.0); s0_1_2 = L0(1.0, 0.0);
	s0_2_0 = L0(-1.0, 1.0); s0_2_1 = L0(0.0, 1.0); s0_2_2 = L0(1.0, 1.0);
	s1_0_0 = L1(-1.0, -1.0); s1_0_1 = L1(0.0, -1.0); s1_0_2 = L1(1.0, -1.0);
	s1_1_0 = L1(-1.0, 0.0); s1_1_1 = L1(0.0, 0.0); s1_1_2 = L1(1.0, 0.0);
	s1_2_0 = L1(-1.0, 1.0); s1_2_1 = L1(0.0, 1.0); s1_2_2 = L1(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(-1.641e-02, -7.225e-03, -5.562e-02, 1.047e-02, 2.197e-02, 4.516e-02, 2.183e-02, -1.839e-02, -2.430e-02, -1.719e-02, -1.150e-02, -6.774e-03, -4.675e-02, 1.327e-01, -1.379e-02, 2.767e-02), r0);
	r1 = MulAdd(s0_0_0, M4(2.753e-02, -1.145e-03, -6.568e-02, -2.514e-02, -1.367e-02, 2.778e-03, -3.841e-03, 5.816e-03, 1.581e-02, 1.012e-02, -1.294e-01, 6.812e-02, 6.160e-03, -2.325e-02, 1.599e-02, -9.096e-04), r1);
	r2 = MulAdd(s0_0_0, M4(-1.764e-02, -2.692e-02, 1.291e-02, -5.254e-02, -3.379e-02, 1.300e-04, 3.514e-03, 2.514e-02, 4.182e-02, 5.897e-02, -8.131e-02, 3.408e-01, -1.228e-02, -5.781e-03, 2.842e-02, -3.430e-02), r2);
	r3 = MulAdd(s0_0_0, M4(-9.454e-02, -1.395e-01, 5.914e-02, 4.668e-02, 6.324e-02, 9.106e-02, -1.284e-01, 3.675e-02, -9.727e-02, -6.790e-02, -2.045e-01, -7.105e-02, -3.725e-02, -3.781e-02, 9.008e-02, 3.686e-02), r3);
	r0 = MulAdd(s0_0_1, M4(3.926e-02, -5.036e-02, 6.650e-03, -7.256e-03, -4.027e-02, 2.235e-02, -7.975e-03, 7.449e-02, -9.200e-02, -5.426e-03, -9.193e-02, -1.473e-01, 2.150e-02, 6.186e-02, -4.224e-03, 1.645e-01), r0);
	r1 = MulAdd(s0_0_1, M4(-7.983e-02, -1.085e-02, -5.233e-03, -1.655e-02, 6.430e-02, 2.012e-02, 6.666e-02, 6.275e-02, 1.851e-01, -1.880e-01, -3.412e-01, -1.489e-01, -2.311e-02, -2.216e-02, 4.818e-02, 2.818e-02), r1);
	r2 = MulAdd(s0_0_1, M4(-7.606e-02, 8.869e-04, -1.238e-01, -7.025e-02, 1.669e-01, 4.239e-02, 1.130e-01, 4.373e-03, -1.107e-02, 1.751e-01, 1.551e-01, -6.986e-02, 3.029e-02, -5.354e-03, -7.821e-02, 8.463e-03), r2);
	r3 = MulAdd(s0_0_1, M4(-2.347e-02, -5.229e-02, -3.103e-01, -9.401e-02, -1.625e-01, 4.291e-02, 2.474e-01, 2.914e-02, -2.124e-01, -1.288e-01, 6.827e-02, 4.309e-02, 1.104e-01, 4.353e-02, -2.669e-01, -1.155e-01), r3);
	r0 = MulAdd(s0_0_2, M4(-1.961e-02, 1.615e-02, 8.694e-03, -1.413e-03, 1.803e-02, 2.252e-02, -1.727e-02, 3.038e-02, 5.874e-04, -4.090e-02, 3.333e-02, -2.959e-02, 1.928e-02, 1.828e-02, 1.291e-02, 4.655e-02), r0);
	r1 = MulAdd(s0_0_2, M4(-4.742e-03, -4.790e-02, 1.652e-02, 1.221e-02, -2.435e-02, 4.537e-02, 4.302e-02, 1.779e-02, 9.306e-03, -4.235e-02, -5.840e-03, 1.088e-03, 1.811e-02, 5.451e-02, 6.905e-03, 3.477e-02), r1);
	r2 = MulAdd(s0_0_2, M4(-4.362e-02, 9.430e-03, -3.001e-02, 2.613e-02, -2.612e-02, 5.612e-03, -1.115e-02, -1.261e-03, -3.063e-02, -3.794e-02, 1.471e-02, -2.645e-02, 1.457e-02, 4.907e-02, 2.985e-02, 6.135e-02), r2);
	r3 = MulAdd(s0_0_2, M4(6.093e-02, -1.674e-02, 5.753e-02, -3.178e-02, 2.448e-02, 1.503e-02, -1.078e-01, -1.160e-02, -2.026e-02, 7.544e-02, 5.836e-02, 6.330e-02, -9.540e-02, -8.086e-02, -2.798e-03, -5.278e-02), r3);
	r0 = MulAdd(s0_1_0, M4(-3.715e-01, -2.222e-01, 9.342e-02, -1.712e-02, 7.499e-02, -3.296e-02, -3.675e-02, 3.219e-02, -8.603e-02, -1.866e-01, 4.090e-02, 1.219e-02, 3.981e-02, 1.618e-02, -1.754e-02, -2.514e-02), r0);
	r1 = MulAdd(s0_1_0, M4(-1.287e-01, 1.167e-02, 5.473e-02, 5.183e-02, 3.815e-02, 3.828e-03, 3.997e-02, -4.309e-02, -4.346e-02, -7.409e-03, -1.441e-01, 2.145e-01, 2.047e-02, 1.404e-02, 4.107e-02, -1.160e-02), r1);
	r2 = MulAdd(s0_1_0, M4(4.912e-02, 2.803e-02, 2.285e-02, -1.352e-02, -2.937e-05, -1.597e-02, 6.634e-02, -8.340e-03, -4.309e-02, 6.531e-02, -1.555e-01, 9.476e-03, 5.679e-02, -1.747e-02, 6.666e-02, -6.303e-02), r2);
	r3 = MulAdd(s0_1_0, M4(-6.851e-03, -1.963e-01, -7.412e-02, -3.584e-01, 3.040e-02, 1.960e-01, -1.728e-01, -3.022e-02, -1.972e-02, -1.323e-01, -1.071e-01, -5.279e-02, 1.264e-02, 8.689e-02, 2.006e-02, 8.947e-02), r3);
	r0 = MulAdd(s0_1_1, M4(1.831e-01, 2.745e-01, -3.977e-01, -2.045e-01, -8.519e-03, -1.450e-01, 5.882e-01, -2.310e-01, -9.611e-02, -2.510e-01, 1.596e-01, -1.049e-02, -4.759e-01, 1.068e-01, 1.655e-01, -1.346e-01), r0);
	r1 = MulAdd(s0_1_1, M4(3.669e-01, 2.862e-01, 1.147e-02, -4.736e-01, 1.646e-01, -1.130e-02, 4.552e-01, 7.488e-01, 4.620e-01, -1.802e-01, -2.007e-01, 2.978e-01, -1.169e-01, 3.597e-02, -5.125e-02, 4.968e-02), r1);
	r2 = MulAdd(s0_1_1, M4(-4.283e-02, -3.232e-01, 2.549e-01, -1.710e-01, 1.909e-02, 6.390e-01, -3.460e-01, 2.218e-01, -1.614e-01, 1.733e-02, 3.604e-01, 3.949e-01, 1.470e-01, 3.381e-02, -1.145e-01, -1.007e-01), r2);
	r3 = MulAdd(s0_1_1, M4(-1.579e-01, 1.083e-02, -4.052e-01, -3.537e-02, 2.184e-01, -3.069e-02, 6.158e-01, -1.793e-01, 1.895e-01, 1.032e-01, 2.241e-01, 2.901e-01, 2.006e-01, -4.086e-01, -4.215e-01, -6.605e-01), r3);
	r0 = MulAdd(s0_1_2, M4(-7.767e-02, -3.150e-02, -3.082e-03, 6.582e-03, -2.356e-02, 2.873e-02, -4.796e-03, -4.366e-02, 1.294e-01, 4.773e-02, 7.235e-02, 8.569e-02, -1.068e-02, -6.037e-02, -4.853e-04, -1.368e-01), r0);
	r1 = MulAdd(s0_1_2, M4(-2.632e-02, -1.248e-01, -6.583e-02, 3.665e-02, 9.447e-03, 1.999e-01, 7.656e-02, -2.674e-02, 1.952e-02, 1.131e-01, 3.278e-02, -1.145e-02, 2.530e-02, -7.414e-02, 7.104e-02, -3.779e-02), r1);
	r2 = MulAdd(s0_1_2, M4(9.459e-03, 1.322e-02, -8.015e-02, -4.486e-02, 1.506e-02, -1.167e-02, 1.406e-01, 1.732e-02, -1.162e-02, -5.846e-02, 4.920e-02, 5.239e-02, 6.346e-02, -1.178e-02, -1.666e-01, 7.013e-02), r2);
	r3 = MulAdd(s0_1_2, M4(-4.888e-02, -6.115e-02, 1.082e-01, 1.004e-02, -5.060e-02, 1.158e-01, -1.260e-01, 8.660e-03, 2.402e-01, 1.388e-01, 1.243e-02, 4.025e-02, -2.288e-01, -2.242e-01, -6.619e-02, -8.787e-02), r3);
	r0 = MulAdd(s0_2_0, M4(-8.092e-02, 1.327e-01, -7.244e-02, -6.567e-02, 2.170e-01, -1.294e-01, -2.161e-02, -4.918e-02, -2.326e-01, 2.073e-01, 5.071e-02, 3.749e-02, 1.831e-01, -8.563e-02, -4.232e-02, -7.925e-02), r0);
	r1 = MulAdd(s0_2_0, M4(2.384e-02, 9.045e-03, 1.230e-03, -5.233e-02, 1.971e-02, 1.066e-02, 1.777e-02, 2.732e-02, -1.744e-02, -3.065e-03, -2.023e-02, 1.099e-02, 1.796e-02, 2.826e-02, -2.389e-04, -2.258e-02), r1);
	r2 = MulAdd(s0_2_0, M4(2.277e-02, -3.645e-02, -4.246e-02, 1.050e-02, 1.886e-02, 1.458e-02, 6.773e-03, 2.168e-02, 1.911e-04, 8.969e-04, 2.093e-02, -2.346e-02, 2.700e-03, -1.543e-02, 1.335e-02, -4.722e-02), r2);
	r3 = MulAdd(s0_2_0, M4(-2.561e-01, 8.738e-02, -1.669e-01, 1.646e-01, 3.576e-02, -1.316e-03, -7.332e-02, 2.324e-05, -3.861e-03, -1.294e-01, 5.123e-02, -7.739e-02, -7.377e-02, 8.454e-02, -6.110e-02, 1.166e-01), r3);
	r0 = MulAdd(s0_2_1, M4(-1.980e-01, -5.409e-01, 7.057e-02, 6.333e-02, 4.478e-02, 1.821e-01, 1.200e-02, 1.926e-02, 1.166e-01, 3.079e-01, 9.412e-02, 2.705e-01, -1.726e-01, -2.108e-01, -6.043e-02, -2.439e-01), r0);
	r1 = MulAdd(s0_2_1, M4(-8.376e-02, -5.225e-02, -1.740e-02, 8.996e-02, 2.069e-03, -1.085e-03, 7.980e-02, 1.676e-02, -5.452e-02, 2.200e-02, -7.883e-02, -6.123e-02, 3.291e-02, -5.952e-03, 3.571e-02, 2.787e-02), r1);
	r2 = MulAdd(s0_2_1, M4(2.727e-02, 5.628e-02, 4.582e-03, -3.173e-02, -3.137e-02, 3.283e-02, 4.651e-02, 3.086e-02, 4.526e-02, -3.810e-02, -7.300e-02, -1.528e-01, -3.678e-02, 2.590e-02, 7.252e-02, 2.051e-02), r2);
	r3 = MulAdd(s0_2_1, M4(-1.624e-01, -2.430e-01, -2.671e-03, 6.620e-02, -9.827e-02, -8.309e-02, 2.709e-01, 1.216e-01, 5.089e-02, 3.827e-02, -1.522e-01, -1.440e-01, -1.315e-01, -8.839e-02, 1.135e-01, 1.925e-01), r3);
	r0 = MulAdd(s0_2_2, M4(2.166e-02, -1.255e-01, 1.853e-02, 1.209e-02, 1.224e-01, -3.346e-03, 3.650e-02, 3.324e-02, 6.075e-02, 9.412e-02, -1.096e-02, 3.932e-02, -1.486e-01, -5.604e-02, 4.959e-03, -6.929e-02), r0);
	r1 = MulAdd(s0_2_2, M4(5.629e-04, 1.507e-02, 8.900e-03, 1.315e-02, 6.697e-02, 1.735e-02, 4.389e-02, 1.157e-02, -3.356e-03, -1.789e-03, -1.015e-03, -1.860e-02, 6.668e-03, 2.156e-02, -1.064e-02, 4.123e-03), r1);
	r2 = MulAdd(s0_2_2, M4(1.026e-02, 1.126e-02, 8.635e-03, -4.892e-04, -1.966e-03, 2.240e-02, 6.519e-02, 5.041e-02, 5.712e-03, -2.251e-02, -4.728e-02, -1.082e-01, -3.084e-02, 1.389e-02, 7.739e-02, -3.004e-02), r2);
	r3 = MulAdd(s0_2_2, M4(7.906e-02, 5.764e-03, -1.380e-01, -6.186e-02, 5.137e-02, 6.316e-02, 2.416e-03, 6.811e-02, -5.155e-02, -3.526e-02, 3.461e-02, -6.274e-02, 2.916e-02, 9.118e-02, -2.736e-02, 1.033e-01), r3);
	r0 = MulAdd(s1_0_0, M4(3.699e-02, -2.318e-02, 1.355e-02, -2.273e-02, -2.232e-02, -7.245e-02, 1.468e-03, -4.865e-03, 8.017e-02, -4.624e-02, 3.653e-02, 8.123e-03, -5.542e-02, 1.164e-01, -1.826e-04, -5.815e-03), r0);
	r1 = MulAdd(s1_0_0, M4(-1.925e-02, -1.177e-03, -2.916e-02, -9.340e-03, -1.015e-02, -3.814e-02, 6.618e-03, -1.569e-03, 4.109e-02, 1.033e-02, 4.078e-02, 2.901e-03, 1.343e-03, 1.891e-02, -1.005e-02, 1.255e-02), r1);
	r2 = MulAdd(s1_0_0, M4(-3.383e-02, -6.258e-03, -3.762e-02, 1.210e-02, 2.411e-02, -7.512e-03, 4.169e-03, 4.113e-02, -2.018e-02, 8.957e-03, 3.673e-02, 8.834e-02, 1.810e-02, 1.071e-02, 6.400e-03, -1.769e-03), r2);
	r3 = MulAdd(s1_0_0, M4(8.226e-02, 3.794e-02, -1.062e-01, -2.082e-02, 1.135e-01, -5.417e-02, 8.357e-02, 1.489e-02, 1.120e-01, 2.564e-02, 1.440e-01, -1.528e-02, -8.230e-02, -6.598e-03, -1.266e-01, 2.133e-02), r3);
	r0 = MulAdd(s1_0_1, M4(-6.704e-02, 9.466e-03, -2.634e-02, -5.833e-02, 3.680e-02, -4.672e-02, 1.745e-02, 2.360e-02, -3.089e-02, 1.108e-02, 1.108e-02, -1.545e-02, 2.987e-02, 6.109e-02, -2.007e-02, 6.869e-02), r0);
	r1 = MulAdd(s1_0_1, M4(-3.826e-02, -5.380e-02, -4.576e-02, -6.081e-02, 6.399e-03, 2.237e-02, -3.039e-02, 5.604e-03, 2.399e-02, 5.969e-02, -5.213e-02, -1.302e-02, -4.340e-02, -4.760e-02, -1.063e-02, 4.377e-02), r1);
	r2 = MulAdd(s1_0_1, M4(1.200e-03, -4.212e-02, 4.583e-02, 1.056e-02, -6.711e-02, 1.321e-02, -1.478e-02, 1.084e-03, -3.018e-02, -2.338e-02, 3.008e-02, 2.629e-02, -7.355e-03, 2.024e-02, 2.594e-02, 3.815e-03), r2);
	r3 = MulAdd(s1_0_1, M4(-3.773e-02, -8.481e-02, -6.409e-02, 7.269e-02, 1.050e-01, 6.773e-02, -2.782e-02, -7.338e-02, 9.181e-02, 2.040e-03, 5.197e-02, 6.361e-02, -1.170e-01, -5.680e-02, -7.065e-02, 2.038e-02), r3);
	r0 = MulAdd(s1_0_2, M4(-3.635e-03, 3.864e-03, -6.315e-03, -1.254e-02, 1.813e-02, 2.166e-02, -3.987e-03, 3.137e-02, 3.581e-03, -2.117e-02, 3.161e-03, 1.321e-02, -3.368e-02, -2.567e-02, 1.126e-02, -1.432e-02), r0);
	r1 = MulAdd(s1_0_2, M4(-2.720e-02, -2.034e-02, -5.086e-03, -1.130e-02, -3.337e-02, -5.380e-02, 5.037e-03, -1.047e-02, 1.278e-03, 2.002e-02, 3.821e-02, -2.668e-03, -5.066e-02, -9.047e-03, -2.993e-02, 8.522e-03), r1);
	r2 = MulAdd(s1_0_2, M4(-1.508e-02, -1.898e-02, -4.025e-02, -1.262e-02, -8.587e-03, -1.119e-02, 3.329e-02, 2.588e-02, -1.220e-02, -4.800e-03, 6.977e-03, -2.392e-02, -1.970e-02, 2.263e-02, -7.000e-02, -1.540e-02), r2);
	r3 = MulAdd(s1_0_2, M4(-2.074e-02, -3.303e-02, 3.741e-03, -2.552e-02, -5.864e-03, 4.395e-02, -2.919e-02, 2.830e-02, 3.684e-02, 1.560e-02, 2.046e-02, 1.846e-02, 8.792e-02, -2.957e-02, 1.778e-02, -3.722e-02), r3);
	r0 = MulAdd(s1_1_0, M4(3.922e-02, -3.247e-01, 3.930e-02, -6.459e-02, -1.380e-01, 1.106e-01, 1.022e-02, 2.568e-02, -3.430e-02, 3.893e-01, 1.786e-01, 9.834e-02, -3.703e-02, -3.270e-01, 1.925e-02, -4.135e-02), r0);
	r1 = MulAdd(s1_1_0, M4(-5.362e-02, -6.260e-02, 7.647e-02, -1.853e-02, 2.539e-03, -2.945e-02, -1.193e-01, 1.142e-02, 7.189e-02, 1.321e-02, 2.241e-01, 1.482e-01, -5.725e-02, 3.699e-02, -8.698e-02, 7.088e-02), r1);
	r2 = MulAdd(s1_1_0, M4(1.274e-01, -2.086e-02, -7.501e-02, 8.813e-02, -9.508e-02, -7.558e-03, -7.694e-02, -1.149e-02, 1.046e-01, 1.528e-01, 1.249e-02, 1.499e-01, -5.993e-02, 2.655e-02, 1.715e-02, -9.145e-02), r2);
	r3 = MulAdd(s1_1_0, M4(1.441e-02, -6.323e-02, -2.251e-01, 1.594e-01, -1.396e-01, -5.078e-02, 1.929e-01, 1.448e-01, 2.575e-01, 3.017e-01, 2.275e-01, 1.700e-01, 1.849e-01, -7.135e-02, 6.656e-02, -3.130e-01), r3);
	r0 = MulAdd(s1_1_1, M4(-2.489e-01, -3.354e-01, 1.273e-01, -1.126e-01, 4.839e-02, 2.097e-01, -4.529e-02, 3.131e-03, 1.353e-01, 1.406e-01, -7.418e-03, 5.605e-02, 6.958e-02, -4.293e-04, -1.080e-01, -6.809e-02), r0);
	r1 = MulAdd(s1_1_1, M4(-9.713e-02, 1.718e-01, -2.380e-01, -1.714e-01, 4.526e-02, 1.743e-01, 5.644e-02, -7.809e-02, 1.685e-01, 3.061e-01, -2.261e-01, 1.200e-01, 1.959e-01, -1.153e-01, 1.738e-02, -1.465e-01), r1);
	r2 = MulAdd(s1_1_1, M4(4.477e-01, -1.375e-01, 1.092e-01, -1.209e-01, 3.000e-02, -7.007e-02, 4.736e-01, 1.406e-02, -9.749e-02, 3.505e-02, -2.277e-01, -5.181e-03, 5.933e-02, -9.644e-02, -3.467e-01, -9.038e-02), r2);
	r3 = MulAdd(s1_1_1, M4(6.120e-01, -2.728e-01, -2.721e-01, -1.587e-01, -3.564e-01, 1.369e-01, -4.055e-01, -1.362e-01, -5.530e-02, -7.667e-02, 1.107e-01, -1.749e-01, -5.254e-01, -9.203e-02, -6.270e-01, -1.609e-01), r3);
	r0 = MulAdd(s1_1_2, M4(3.159e-02, -2.459e-02, 1.481e-02, -4.284e-02, -9.918e-02, 4.626e-02, 1.158e-03, -4.064e-02, 3.869e-02, 9.447e-02, -9.356e-03, 3.034e-02, -7.447e-02, 5.891e-02, -5.085e-03, -2.565e-02), r0);
	r1 = MulAdd(s1_1_2, M4(6.429e-02, -1.410e-01, -2.320e-03, -1.913e-02, -7.950e-02, -1.518e-01, -4.136e-02, -2.709e-02, -3.229e-02, 7.016e-02, 3.303e-02, -3.186e-02, -4.840e-02, 7.738e-02, 1.759e-02, -9.987e-03), r1);
	r2 = MulAdd(s1_1_2, M4(-2.807e-03, -1.925e-02, -3.755e-02, -6.271e-03, 2.151e-02, -2.276e-02, -2.803e-01, -1.315e-02, 9.395e-04, -1.586e-03, -1.822e-03, -1.425e-03, -2.873e-02, 1.430e-02, 7.301e-02, 1.946e-02), r2);
	r3 = MulAdd(s1_1_2, M4(6.646e-02, -8.187e-02, 6.505e-02, -5.308e-02, -1.654e-01, -2.071e-01, 7.106e-02, -3.630e-02, 8.426e-02, 1.086e-01, 6.131e-05, 1.784e-02, -2.842e-01, 1.062e-03, 1.208e-02, 3.408e-02), r3);
	r0 = MulAdd(s1_2_0, M4(-1.680e-01, 4.814e-01, 8.117e-03, 1.654e-01, -1.297e-01, -2.369e-02, -3.231e-02, -1.579e-02, 4.050e-01, 1.545e-01, 6.378e-03, -1.026e-01, -1.631e-02, -2.053e-01, -2.748e-02, -9.243e-02), r0);
	r1 = MulAdd(s1_2_0, M4(4.773e-02, -1.593e-02, -2.213e-02, -7.445e-02, -3.433e-02, 1.712e-03, -5.160e-02, -4.737e-02, -1.786e-02, 4.139e-03, 5.407e-02, 6.009e-02, -3.406e-02, 3.044e-02, -9.659e-03, -1.358e-02), r1);
	r2 = MulAdd(s1_2_0, M4(-3.863e-02, -2.915e-02, 3.077e-02, 5.992e-02, 2.254e-02, -6.082e-02, -4.255e-03, 1.589e-02, 4.549e-03, 4.456e-02, 2.868e-02, 1.114e-02, -8.551e-03, -1.352e-02, 3.185e-02, -1.155e-02), r2);
	r3 = MulAdd(s1_2_0, M4(-1.557e-01, -1.509e-01, 1.111e-01, 9.194e-02, 1.197e-01, -1.342e-01, 8.144e-02, -3.063e-02, -7.451e-02, 1.451e-01, 5.204e-02, -6.775e-02, -2.802e-01, 3.831e-02, -3.142e-02, 1.204e-01), r3);
	r0 = MulAdd(s1_2_1, M4(4.757e-02, 2.934e-01, 1.297e-01, 3.274e-01, 1.200e-01, -2.309e-01, 1.303e-01, 1.172e-02, -1.568e-01, -2.576e-02, -9.479e-02, -1.228e-01, -1.665e-01, -7.247e-02, 4.543e-02, 2.206e-02), r0);
	r1 = MulAdd(s1_2_1, M4(-7.530e-02, 4.429e-02, 3.436e-02, 3.490e-02, 3.433e-02, -8.473e-02, 6.050e-02, 5.545e-02, -6.659e-02, 1.509e-02, -1.194e-01, -7.315e-02, -1.306e-02, -1.352e-02, -4.493e-03, -2.411e-03), r1);
	r2 = MulAdd(s1_2_1, M4(-1.646e-02, 3.822e-02, 2.885e-02, -8.326e-02, -1.431e-03, 4.505e-02, -7.201e-02, 6.856e-02, 4.991e-02, -7.058e-02, 3.428e-03, 4.208e-02, -3.666e-02, 5.941e-04, -5.253e-02, -3.316e-02), r2);
	r3 = MulAdd(s1_2_1, M4(-2.134e-01, 1.537e-01, -1.280e-01, 2.330e-01, 3.506e-01, 2.849e-01, -9.974e-02, -6.943e-02, -1.894e-01, -1.274e-01, 4.122e-02, -7.305e-02, 1.488e-01, -1.213e-01, -2.557e-02, -2.339e-01), r3);
	r0 = MulAdd(s1_2_2, M4(-1.470e-01, 4.409e-02, 3.940e-02, 2.340e-02, -1.067e-01, -1.115e-01, -3.405e-02, -7.400e-02, 1.261e-01, 1.835e-02, -1.254e-02, -3.966e-02, 2.601e-02, -8.109e-02, -2.058e-02, 3.551e-04), r0);
	r1 = MulAdd(s1_2_2, M4(4.086e-02, -1.525e-02, -6.762e-02, 1.355e-02, -1.172e-02, 3.255e-02, -4.968e-02, -2.410e-02, 5.172e-03, -1.958e-02, 3.527e-02, -3.205e-02, -8.687e-03, 2.185e-03, 6.981e-03, -9.902e-03), r1);
	r2 = MulAdd(s1_2_2, M4(-8.408e-03, -7.317e-03, 7.105e-02, 5.152e-03, -7.603e-03, -3.845e-02, 9.381e-03, -1.031e-02, 1.907e-02, -5.659e-03, -2.179e-02, 1.926e-02, 3.755e-04, -2.819e-03, -5.655e-02, 7.592e-03), r2);
	r3 = MulAdd(s1_2_2, M4(-1.272e-01, -8.614e-02, -1.310e-01, 1.001e-01, 6.827e-02, -1.092e-01, 1.420e-01, 8.276e-02, -2.791e-02, -3.831e-03, 5.739e-02, 2.390e-03, 1.576e-01, -5.044e-03, -4.320e-02, -5.275e-02), r3);
	s0_0_0 = L2(-1.0, -1.0); s0_0_1 = L2(0.0, -1.0); s0_0_2 = L2(1.0, -1.0);
	s0_1_0 = L2(-1.0, 0.0); s0_1_1 = L2(0.0, 0.0); s0_1_2 = L2(1.0, 0.0);
	s0_2_0 = L2(-1.0, 1.0); s0_2_1 = L2(0.0, 1.0); s0_2_2 = L2(1.0, 1.0);
	s1_0_0 = L3(-1.0, -1.0); s1_0_1 = L3(0.0, -1.0); s1_0_2 = L3(1.0, -1.0);
	s1_1_0 = L3(-1.0, 0.0); s1_1_1 = L3(0.0, 0.0); s1_1_2 = L3(1.0, 0.0);
	s1_2_0 = L3(-1.0, 1.0); s1_2_1 = L3(0.0, 1.0); s1_2_2 = L3(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(7.475e-03, 1.400e-01, -1.357e-02, -1.804e-02, 1.384e-02, -1.141e-01, -1.750e-02, -3.923e-02, -1.072e-02, -1.058e-01, 7.622e-04, -4.998e-02, -4.092e-02, -9.033e-02, -1.374e-03, -2.851e-02), r0);
	r1 = MulAdd(s0_0_0, M4(-1.581e-02, -5.137e-05, -5.576e-02, -1.059e-02, -2.172e-03, -3.061e-02, 1.284e-02, -2.129e-02, -2.332e-02, 7.636e-03, 1.718e-02, -6.378e-03, -7.422e-03, -1.383e-02, -1.690e-02, -3.228e-02), r1);
	r2 = MulAdd(s0_0_0, M4(-6.097e-02, 3.474e-03, -1.545e-02, -3.099e-02, -1.706e-02, -1.198e-02, 2.629e-02, -5.266e-02, 2.086e-02, -2.924e-02, 9.624e-03, -5.179e-02, -4.772e-02, -1.962e-02, -1.427e-02, -1.944e-02), r2);
	r3 = MulAdd(s0_0_0, M4(8.034e-03, -1.998e-03, -7.709e-02, 1.939e-04, 2.303e-02, -1.150e-02, 1.157e-01, -5.576e-02, 6.234e-02, 1.001e-02, 2.299e-02, -1.555e-02, -2.626e-02, -3.946e-02, -6.042e-02, -4.712e-02), r3);
	r0 = MulAdd(s0_0_1, M4(-1.442e-03, 1.415e-01, -1.823e-02, -2.459e-02, -3.742e-02, -1.101e-01, 4.408e-02, -4.676e-02, 1.104e-02, -8.884e-02, 2.008e-02, -1.446e-01, -5.178e-02, -9.323e-02, 3.833e-03, -1.009e-01), r0);
	r1 = MulAdd(s0_0_1, M4(5.875e-02, -8.109e-02, 9.447e-02, 8.567e-02, 4.283e-02, 5.852e-02, 2.898e-02, 1.632e-02, -7.892e-02, 2.925e-02, 4.989e-02, -5.590e-02, -3.786e-02, -4.894e-02, -5.967e-02, -6.204e-02), r1);
	r2 = MulAdd(s0_0_1, M4(-6.120e-02, 7.830e-02, -5.818e-04, 1.609e-02, -1.160e-01, 9.929e-03, -9.957e-02, -9.796e-02, -6.824e-02, -3.723e-02, -1.911e-02, -2.563e-01, -6.014e-02, -1.482e-02, -1.028e-01, -1.743e-01), r2);
	r3 = MulAdd(s0_0_1, M4(-2.055e-01, -5.735e-02, -3.454e-02, 7.252e-02, 1.126e-01, 3.845e-02, 6.612e-02, -1.055e-01, -2.326e-02, -4.113e-02, 4.643e-02, -4.328e-02, 1.050e-01, -8.308e-02, -1.412e-01, -2.270e-01), r3);
	r0 = MulAdd(s0_0_2, M4(-1.404e-02, 1.689e-03, -2.606e-02, 4.693e-02, 3.907e-02, -3.237e-02, -1.974e-02, 7.364e-03, -6.820e-03, -6.518e-02, 3.357e-02, -8.941e-02, 8.955e-03, 6.622e-03, 1.390e-02, -2.353e-02), r0);
	r1 = MulAdd(s0_0_2, M4(-1.084e-01, 6.246e-03, 5.017e-02, 9.422e-03, -4.348e-03, -2.155e-03, 4.956e-03, -4.333e-03, -7.495e-02, -2.427e-02, 4.997e-02, -2.830e-02, -4.382e-02, -8.325e-02, -8.388e-03, -1.004e-03), r1);
	r2 = MulAdd(s0_0_2, M4(-1.134e-02, -3.576e-02, -5.409e-02, 7.308e-02, 4.872e-02, -2.164e-02, -3.111e-02, -2.189e-02, 2.202e-03, -1.444e-01, -1.304e-01, 1.323e-02, -4.694e-03, -2.622e-02, -6.037e-02, 6.563e-02), r2);
	r3 = MulAdd(s0_0_2, M4(4.800e-02, -3.431e-02, -5.712e-02, -2.879e-02, 6.046e-02, -1.308e-02, -8.073e-02, -6.610e-02, 1.944e-01, -2.931e-03, 6.115e-02, 1.887e-02, 3.598e-03, -3.693e-02, -7.314e-03, -4.277e-02), r3);
	r0 = MulAdd(s0_1_0, M4(-1.039e-01, -6.258e-02, 1.552e-02, 1.181e-02, 3.115e-02, 1.698e-01, -3.482e-03, 4.415e-02, -7.026e-03, 9.302e-02, -3.904e-02, 1.709e-02, -5.763e-02, -2.288e-02, -6.591e-02, 8.306e-03), r0);
	r1 = MulAdd(s0_1_0, M4(-3.901e-02, 9.753e-03, -3.821e-02, -4.886e-02, 1.071e-02, -3.912e-03, 4.510e-02, -5.216e-02, 1.227e-02, -3.726e-02, 5.589e-02, -3.371e-02, -4.805e-02, -5.750e-03, -5.934e-02, -8.081e-02), r1);
	r2 = MulAdd(s0_1_0, M4(-1.877e-02, -1.587e-02, -4.095e-02, -9.000e-02, 4.409e-02, -2.281e-02, 6.124e-02, -5.461e-02, -1.209e-02, 5.300e-03, 1.113e-02, 1.123e-01, 6.404e-03, -7.154e-02, 6.369e-03, -8.237e-02), r2);
	r3 = MulAdd(s0_1_0, M4(-8.102e-02, -4.644e-02, -1.478e-01, -1.885e-01, 3.478e-02, 1.585e-01, -1.098e-01, 6.898e-02, 2.009e-01, -7.789e-02, 7.984e-02, -2.656e-02, -2.013e-01, -3.971e-02, -2.349e-01, -1.851e-01), r3);
	r0 = MulAdd(s0_1_1, M4(-7.037e-02, -2.421e-01, -1.623e-01, 8.517e-02, -8.568e-03, 1.140e-01, 6.958e-02, 8.519e-02, 3.210e-01, -6.861e-02, 3.995e-01, 4.585e-01, -1.588e-01, 5.645e-02, 6.570e-03, 8.531e-02), r0);
	r1 = MulAdd(s0_1_1, M4(-1.516e-01, -1.506e-01, -1.042e-01, -1.245e-01, 3.819e-02, -2.074e-02, 2.231e-01, 4.031e-01, 8.857e-02, 2.570e-01, 5.762e-01, 2.655e-02, -2.924e-01, -1.781e-01, -9.205e-02, -8.172e-02), r1);
	r2 = MulAdd(s0_1_1, M4(-7.345e-02, -1.140e-01, -1.845e-01, 8.775e-02, 2.285e-01, 3.330e-01, 1.103e-01, -4.307e-02, -2.321e-02, 3.006e-01, 7.321e-02, 1.270e-01, -2.386e-03, -8.400e-02, -3.540e-01, -3.098e-01), r2);
	r3 = MulAdd(s0_1_1, M4(-6.033e-01, -2.115e-01, -8.909e-01, -3.308e-01, 6.430e-02, -1.555e-02, 6.958e-01, 4.123e-01, 3.456e-01, 6.621e-01, 2.805e-01, 4.594e-01, -3.504e-01, -5.267e-01, -1.876e-01, -4.971e-01), r3);
	r0 = MulAdd(s0_1_2, M4(-4.758e-02, -2.270e-02, 5.660e-02, 5.772e-02, -5.143e-02, 1.145e-01, -1.959e-02, -2.208e-02, 5.082e-02, -3.787e-02, 8.861e-02, 2.086e-01, -7.444e-02, -5.229e-02, 2.298e-02, -4.009e-02), r0);
	r1 = MulAdd(s0_1_2, M4(-1.312e-01, -1.763e-01, -5.171e-02, -6.412e-03, 1.980e-02, 1.514e-02, 9.909e-03, -6.469e-02, 9.720e-02, 9.049e-02, -1.021e-01, 3.283e-02, 1.985e-02, -1.450e-01, -9.741e-02, -1.035e-03), r1);
	r2 = MulAdd(s0_1_2, M4(-2.625e-02, -3.082e-02, -2.677e-01, -5.731e-02, -1.440e-02, -3.428e-02, 4.538e-02, -7.913e-02, -1.072e-01, -3.023e-02, 1.602e-01, -2.271e-01, 5.358e-03, -3.234e-02, -7.604e-02, -1.164e-01), r2);
	r3 = MulAdd(s0_1_2, M4(-1.959e-02, 4.250e-04, 9.731e-02, 8.684e-03, -1.592e-01, 3.224e-02, -1.228e-01, 9.010e-02, 1.489e-01, -7.851e-02, -6.104e-02, -7.180e-02, -2.103e-01, -1.597e-01, -7.157e-02, -4.161e-02), r3);
	r0 = MulAdd(s0_2_0, M4(-4.234e-02, -8.682e-02, -2.462e-02, -3.573e-02, 1.322e-01, 3.913e-04, -4.238e-02, 8.848e-03, -6.387e-03, 2.359e-01, -1.920e-02, 8.034e-02, -1.035e-02, -3.933e-01, -3.235e-02, -8.021e-02), r0);
	r1 = MulAdd(s0_2_0, M4(3.840e-03, 1.352e-03, -2.105e-03, -2.656e-03, -3.403e-02, 1.043e-02, -5.896e-02, -6.173e-02, -2.521e-02, -1.389e-02, -3.423e-02, -2.294e-02, 2.594e-02, 1.686e-02, 4.969e-03, -7.436e-03), r1);
	r2 = MulAdd(s0_2_0, M4(-1.190e-02, -4.011e-03, 1.043e-03, 3.381e-02, -3.051e-02, -3.563e-02, -2.707e-02, -1.005e-01, 1.615e-02, -2.143e-02, -2.654e-02, -5.034e-02, -6.976e-03, -5.134e-03, 2.069e-02, -8.033e-03), r2);
	r3 = MulAdd(s0_2_0, M4(4.873e-02, -2.356e-02, -9.155e-03, -2.016e-02, 5.957e-02, 3.253e-02, -1.213e-01, 5.038e-03, -1.146e-02, 5.071e-02, 7.180e-02, -7.368e-03, -1.125e-01, -1.867e-02, -1.499e-01, 4.140e-02), r3);
	r0 = MulAdd(s0_2_1, M4(-5.958e-01, -1.284e-01, -4.444e-02, 4.382e-02, 2.261e-01, -6.539e-02, 7.983e-02, 3.334e-02, 3.871e-01, 2.210e-01, -3.405e-02, -1.105e-01, -3.880e-01, -2.556e-01, -1.494e-02, -1.900e-01), r0);
	r1 = MulAdd(s0_2_1, M4(9.857e-03, 9.163e-03, -3.208e-02, -2.957e-02, -1.972e-02, -3.050e-02, -5.973e-02, 1.687e-03, 4.410e-02, -1.918e-03, 5.413e-03, -4.037e-03, 1.413e-02, -1.224e-02, 3.299e-02, -9.190e-03), r1);
	r2 = MulAdd(s0_2_1, M4(6.892e-03, -1.559e-02, -4.221e-03, -8.227e-02, -5.969e-02, 5.974e-03, -6.235e-02, -8.813e-02, 3.624e-02, -9.025e-04, 3.553e-02, 1.772e-01, -7.758e-03, 4.385e-03, 9.107e-03, -2.026e-03), r2);
	r3 = MulAdd(s0_2_1, M4(4.183e-02, -1.648e-01, -3.031e-01, -1.574e-03, 1.248e-01, 5.331e-02, 1.937e-01, -1.183e-01, -1.693e-01, 7.304e-02, 1.877e-02, -5.772e-02, -1.382e-01, -1.881e-01, -1.799e-02, 1.549e-01), r3);
	r0 = MulAdd(s0_2_2, M4(8.952e-02, 8.968e-02, -3.454e-02, -8.179e-02, 1.187e-01, -7.390e-02, 6.947e-03, 3.572e-02, -1.612e-01, 7.040e-02, 4.689e-03, 7.359e-02, -3.930e-02, -4.020e-02, 3.364e-04, -1.779e-02), r0);
	r1 = MulAdd(s0_2_2, M4(-3.382e-02, -7.350e-02, -2.930e-02, -2.222e-02, 4.211e-02, 2.228e-02, -2.921e-02, -2.764e-02, -2.671e-02, 3.444e-03, -3.850e-02, -5.555e-03, 1.237e-02, 1.652e-02, -2.837e-02, 1.899e-02), r1);
	r2 = MulAdd(s0_2_2, M4(-9.040e-03, -2.308e-02, -5.253e-02, -6.286e-02, -2.330e-02, -4.083e-02, 3.841e-02, -4.643e-02, 3.017e-02, -2.291e-02, -3.206e-02, 4.059e-04, -2.664e-02, 7.649e-03, 6.274e-02, -5.166e-02), r2);
	r3 = MulAdd(s0_2_2, M4(3.430e-02, -6.176e-02, 1.581e-01, -8.617e-04, 1.458e-01, 8.083e-02, 1.232e-02, -1.438e-02, -1.359e-01, -5.053e-02, -4.574e-02, -1.437e-02, -3.122e-02, 6.758e-02, -2.997e-02, 2.930e-02), r3);
	r0 = MulAdd(s1_0_0, M4(4.516e-03, 3.322e-02, -1.336e-02, 4.358e-02, -3.832e-04, 2.846e-02, -1.181e-03, 2.171e-02, 3.883e-02, 1.886e-02, -2.846e-02, -7.001e-03, 2.267e-03, 2.404e-01, 4.789e-03, 2.263e-02), r0);
	r1 = MulAdd(s1_0_0, M4(1.580e-02, -3.781e-03, -2.367e-02, -1.584e-03, -1.725e-02, -9.538e-03, -1.763e-02, 2.233e-03, -1.556e-02, -1.729e-02, -1.569e-02, -1.941e-02, 4.547e-02, 3.215e-02, 1.953e-02, -9.425e-02), r1);
	r2 = MulAdd(s1_0_0, M4(5.259e-03, -2.713e-03, -3.383e-02, 1.217e-02, -6.164e-03, 4.226e-03, -2.397e-02, 1.510e-02, 1.501e-03, -2.753e-02, -7.540e-03, -2.480e-02, -3.240e-02, -2.712e-02, 1.116e-01, -3.090e-01), r2);
	r3 = MulAdd(s1_0_0, M4(5.725e-02, -5.608e-02, 7.251e-02, 5.217e-02, 7.449e-02, 3.776e-02, 5.677e-02, -6.019e-02, 8.240e-03, -1.515e-02, -2.170e-02, -1.987e-02, -6.569e-03, 9.770e-02, 1.048e-01, 7.300e-02), r3);
	r0 = MulAdd(s1_0_1, M4(-5.060e-02, 9.242e-03, 3.315e-02, -8.397e-03, 3.052e-02, 1.224e-01, -2.343e-02, 7.306e-02, -7.206e-02, -3.569e-02, -6.526e-02, -2.049e-02, 1.034e-01, 3.279e-01, -6.020e-04, 3.096e-01), r0);
	r1 = MulAdd(s1_0_1, M4(-6.475e-02, 2.039e-02, 3.633e-02, -1.054e-01, 3.571e-02, 1.935e-02, 9.520e-03, -2.703e-02, -3.006e-02, -9.050e-03, -7.445e-02, -2.291e-02, -1.906e-01, 5.573e-02, 3.013e-01, 2.066e-01), r1);
	r2 = MulAdd(s1_0_1, M4(-1.090e-02, -6.279e-02, 4.808e-02, -6.830e-02, -2.615e-01, -1.600e-02, -4.426e-02, -2.678e-02, -7.046e-04, -3.974e-02, -2.909e-02, -7.538e-02, 2.218e-01, -1.685e-01, -2.037e-01, 4.014e-01), r2);
	r3 = MulAdd(s1_0_1, M4(3.289e-01, 1.680e-01, 6.413e-02, -1.587e-01, -8.980e-02, 1.460e-02, -5.035e-01, -1.685e-01, -1.530e-01, 7.243e-03, -1.802e-01, 4.528e-04, -2.382e-01, 6.318e-02, -2.854e-02, 1.564e-02), r3);
	r0 = MulAdd(s1_0_2, M4(4.006e-02, 4.402e-02, 3.002e-02, 3.506e-02, -4.006e-02, 3.866e-02, -2.816e-03, -1.824e-02, 2.245e-02, -3.818e-02, -5.564e-03, 7.113e-03, -2.919e-02, 3.529e-02, -1.141e-01, 7.925e-02), r0);
	r1 = MulAdd(s1_0_2, M4(3.335e-01, 1.117e-01, 1.323e-01, 5.353e-02, -8.816e-02, -1.320e-01, -2.348e-02, -3.316e-02, -1.297e-02, 9.254e-03, 1.648e-02, -1.175e-02, 2.193e-02, 5.292e-02, -9.767e-02, -1.045e-02), r1);
	r2 = MulAdd(s1_0_2, M4(7.776e-02, 4.610e-02, 3.847e-01, -6.181e-02, -8.366e-02, -4.886e-02, -3.792e-01, -3.025e-02, -1.120e-03, -4.697e-03, 2.895e-02, 1.087e-02, 7.007e-02, 1.509e-01, 7.305e-02, -3.858e-02), r2);
	r3 = MulAdd(s1_0_2, M4(-2.162e-01, 7.968e-02, 2.636e-01, -1.642e-03, -9.944e-02, -2.925e-01, 1.709e-02, -4.747e-02, -6.499e-03, 1.859e-02, 5.428e-03, -7.895e-02, -2.801e-01, -7.387e-02, -1.392e-01, -5.969e-02), r3);
	r0 = MulAdd(s1_1_0, M4(-8.697e-02, 2.215e-01, 3.259e-02, -2.046e-02, 1.215e-01, -1.380e-02, 8.681e-03, -5.089e-02, -2.768e-02, -3.663e-01, -4.461e-02, -4.016e-02, 1.930e-01, -4.326e-01, 1.540e-02, -8.960e-02), r0);
	r1 = MulAdd(s1_1_0, M4(-3.479e-04, -1.467e-02, 1.034e-03, -1.611e-02, 1.642e-02, 8.182e-03, 4.235e-02, -2.173e-02, -1.002e-02, -2.233e-02, -4.429e-02, -4.871e-02, 4.226e-04, -2.229e-04, 2.008e-03, 5.120e-03), r1);
	r2 = MulAdd(s1_1_0, M4(2.803e-02, -5.570e-03, -2.447e-02, 2.696e-02, 3.896e-02, -1.415e-02, 1.886e-02, 4.637e-02, -2.661e-02, -3.598e-02, 1.755e-03, -4.041e-02, 1.133e-02, 2.152e-02, -3.553e-02, -3.750e-02), r2);
	r3 = MulAdd(s1_1_0, M4(-1.447e-01, -1.660e-02, 1.224e-01, 1.009e-02, -1.281e-01, 5.924e-02, -1.410e-01, 2.213e-01, -1.432e-01, 4.408e-02, -5.599e-02, -3.048e-02, -1.322e-01, 5.811e-02, -6.074e-02, 8.393e-02), r3);
	r0 = MulAdd(s1_1_1, M4(3.161e-01, 2.153e-01, -8.862e-02, 3.823e-02, -2.124e-01, -2.474e-01, -8.670e-02, -1.314e-01, -2.035e-01, -3.719e-01, -1.880e-01, -3.393e-01, -1.964e-01, -3.449e-01, -3.565e-01, -6.387e-01), r0);
	r1 = MulAdd(s1_1_1, M4(1.227e-01, -2.003e-03, 1.284e-01, -6.249e-02, 7.253e-02, 3.052e-02, -5.104e-03, -9.382e-03, -1.812e-01, -9.690e-02, -3.605e-01, -8.621e-02, 6.470e-02, 1.532e-02, 3.350e-01, 9.048e-02), r1);
	r2 = MulAdd(s1_1_1, M4(-2.720e-03, -5.103e-02, 5.590e-02, 2.805e-02, 7.776e-03, -7.253e-03, 1.764e-01, 7.818e-02, -1.440e-01, -7.791e-02, -1.523e-01, -1.851e-01, -1.048e-01, 9.492e-02, 1.528e-01, -1.620e-01), r2);
	r3 = MulAdd(s1_1_1, M4(-4.838e-01, 1.277e-01, 3.431e-01, 3.467e-01, -2.097e-01, -2.514e-01, -1.538e-01, 2.161e-01, -7.397e-01, -6.305e-01, -1.453e-01, -2.998e-01, -1.220e-01, -1.795e-01, -9.733e-02, -4.968e-02), r3);
	r0 = MulAdd(s1_1_2, M4(2.439e-01, -2.270e-01, -7.154e-03, 1.268e-02, -2.635e-01, -5.136e-03, 5.017e-02, 5.398e-02, -5.108e-02, -1.406e-02, 4.618e-02, -4.488e-02, -7.836e-02, -9.523e-02, -1.754e-01, -2.359e-01), r0);
	r1 = MulAdd(s1_1_2, M4(4.254e-01, 1.431e-01, 5.578e-02, -1.207e-01, 5.986e-02, 1.163e-01, 7.261e-02, 2.124e-01, 1.870e-01, 4.064e-01, 3.357e-02, 8.320e-03, -1.421e-01, 6.112e-02, 9.156e-02, -2.906e-02), r1);
	r2 = MulAdd(s1_1_2, M4(-1.531e-02, -7.146e-02, 3.771e-01, -4.788e-02, 3.568e-03, 1.743e-01, 2.186e-01, 3.018e-02, -1.384e-02, 6.109e-03, 3.936e-01, -1.591e-02, 2.912e-02, 9.407e-02, -5.372e-02, 2.000e-01), r2);
	r3 = MulAdd(s1_1_2, M4(1.432e-01, 3.308e-01, -1.127e-02, -2.656e-01, 2.823e-01, -1.254e-03, 2.208e-01, 1.618e-01, -5.069e-02, 2.452e-01, -1.759e-01, 3.603e-02, -9.863e-02, 4.581e-03, 2.639e-02, 2.358e-02), r3);
	r0 = MulAdd(s1_2_0, M4(4.781e-02, -1.807e-01, 1.762e-02, -4.183e-02, -3.793e-02, -9.227e-03, 1.260e-02, 3.070e-02, -2.956e-02, -3.331e-01, 5.445e-03, 2.965e-02, -8.886e-02, 6.161e-02, 8.200e-03, 8.931e-04), r0);
	r1 = MulAdd(s1_2_0, M4(1.678e-02, -9.738e-03, 2.020e-02, 2.440e-02, 1.297e-02, -9.420e-03, 5.019e-03, -6.058e-03, -7.102e-04, -2.432e-03, -1.929e-02, -6.868e-03, 4.158e-04, -6.037e-03, 4.851e-03, 2.878e-03), r1);
	r2 = MulAdd(s1_2_0, M4(2.110e-02, 1.090e-02, 1.113e-02, 5.266e-02, 7.585e-03, 3.660e-03, -6.806e-03, 1.460e-02, -8.141e-03, -1.005e-02, 2.558e-05, 4.299e-02, -5.701e-03, 2.990e-03, 8.225e-03, 2.495e-02), r2);
	r3 = MulAdd(s1_2_0, M4(4.606e-02, 1.149e-02, 8.274e-02, -1.712e-02, 1.926e-01, -4.106e-03, 7.886e-02, -5.877e-03, 1.848e-01, -4.991e-02, -7.041e-02, -8.274e-02, 3.030e-02, -1.455e-02, 7.464e-02, -4.055e-02), r3);
	r0 = MulAdd(s1_2_1, M4(2.011e-01, -5.976e-02, -4.563e-02, -4.085e-02, -2.612e-01, 2.459e-02, 2.242e-02, 8.096e-02, -1.519e-01, -3.071e-01, 4.012e-02, 2.001e-01, 3.024e-02, -3.061e-02, 1.834e-02, 1.168e-01), r0);
	r1 = MulAdd(s1_2_1, M4(-3.901e-02, 9.854e-03, -7.139e-02, -7.513e-02, 4.384e-03, 6.974e-03, -1.039e-02, 1.761e-04, -2.128e-04, -1.492e-02, -2.600e-02, -5.456e-02, -1.318e-02, 1.862e-02, -2.850e-02, -1.924e-02), r1);
	r2 = MulAdd(s1_2_1, M4(-4.489e-04, -5.876e-02, -1.319e-04, -2.154e-02, 5.552e-03, -9.017e-03, 1.626e-02, 9.435e-03, 1.221e-03, -3.392e-02, -6.781e-02, -3.630e-02, 2.097e-02, -1.766e-02, -1.167e-02, -2.995e-02), r2);
	r3 = MulAdd(s1_2_1, M4(-3.820e-02, 1.658e-01, 5.920e-02, -3.328e-02, 9.836e-02, 5.394e-02, 1.121e-01, -9.794e-02, 2.036e-01, 4.968e-02, -2.697e-02, -1.124e-01, 1.933e-02, 1.970e-02, -1.389e-01, 8.811e-03), r3);
	r0 = MulAdd(s1_2_2, M4(8.946e-04, 1.096e-02, -1.506e-02, -5.630e-02, 2.007e-01, 1.969e-02, 2.129e-02, 4.976e-02, 9.351e-02, -4.676e-02, 1.756e-03, 6.513e-02, -5.135e-02, 1.257e-02, -1.107e-02, -3.471e-02), r0);
	r1 = MulAdd(s1_2_2, M4(9.224e-03, 1.790e-02, -1.630e-02, 1.897e-02, -1.144e-02, -3.312e-02, -1.129e-02, -2.413e-03, -3.357e-02, 1.156e-02, 8.024e-03, 3.346e-03, -1.635e-03, -4.530e-02, -1.235e-02, -1.053e-02), r1);
	r2 = MulAdd(s1_2_2, M4(-5.652e-03, 1.568e-02, 6.137e-02, -5.792e-03, 3.454e-02, -1.628e-02, -5.529e-02, 2.012e-02, 4.542e-03, 7.027e-03, -4.358e-02, 1.038e-02, 6.619e-03, -1.169e-02, -2.898e-02, 1.101e-01), r2);
	r3 = MulAdd(s1_2_2, M4(-6.397e-02, -1.553e-02, 6.284e-02, 2.467e-03, 6.271e-02, 4.614e-02, -4.798e-02, -2.377e-02, 1.466e-01, 2.885e-02, -6.588e-03, 4.253e-02, 2.708e-02, -2.060e-02, 2.838e-02, 2.790e-03), r3);
	r0 = max(r0, 0.0);
	T0[gxy] = r0;
	r1 = max(r1, 0.0);
	T1[gxy] = r1;
	r2 = max(r2, 0.0);
	T2[gxy] = r2;
	r3 = max(r3, 0.0);
	T3[gxy] = r3;
}

//!PASS 6
//!DESC out-shuffle (16x12)
//!BLOCK_SIZE 16
//!NUM_THREADS 64
//!IN INPUT, T0, T1, T2, T3
//!OUT OUTPUT

#define L0(x, y) V4(O(T0, x, y))
#define L1(x, y) V4(O(T1, x, y))
#define L2(x, y) V4(O(T2, x, y))
#define L3(x, y) V4(O(T3, x, y))

void Pass6(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = (Rmp8x8(tid.x) << 1) + blockStart;
	uint2 sz = GetOutputSize();
	if (gxy.x >= sz.x || gxy.y >= sz.y)
		return;
	float2 pos = ((gxy >> 1) + 0.5) * pt;
	V4 s0_0_0, s0_0_1, s0_0_2, s0_1_0, s0_1_1, s0_1_2, s0_2_0, s0_2_1, s0_2_2, s1_0_0, s1_0_1, s1_0_2, s1_1_0, s1_1_1, s1_1_2, s1_2_0, s1_2_1, s1_2_2;
	V4 r0 = 0.0, r1 = 0.0, r2 = 0.0;
	s0_0_0 = L0(-1.0, -1.0); s0_0_1 = L0(0.0, -1.0); s0_0_2 = L0(1.0, -1.0);
	s0_1_0 = L0(-1.0, 0.0); s0_1_1 = L0(0.0, 0.0); s0_1_2 = L0(1.0, 0.0);
	s0_2_0 = L0(-1.0, 1.0); s0_2_1 = L0(0.0, 1.0); s0_2_2 = L0(1.0, 1.0);
	s1_0_0 = L1(-1.0, -1.0); s1_0_1 = L1(0.0, -1.0); s1_0_2 = L1(1.0, -1.0);
	s1_1_0 = L1(-1.0, 0.0); s1_1_1 = L1(0.0, 0.0); s1_1_2 = L1(1.0, 0.0);
	s1_2_0 = L1(-1.0, 1.0); s1_2_1 = L1(0.0, 1.0); s1_2_2 = L1(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(-1.004e-02, 1.268e-02, 1.422e-02, 1.665e-02, 1.003e-03, 6.192e-03, 1.611e-03, -1.161e-03, 1.652e-01, -5.010e-03, 1.273e-02, -2.875e-02, 4.161e-02, 4.119e-03, 7.435e-03, -8.209e-03), r0);
	r1 = MulAdd(s0_0_0, M4(-4.053e-02, 1.973e-02, 2.964e-02, 1.326e-02, 1.362e-02, 3.369e-03, -6.045e-03, -8.874e-03, -7.397e-02, 5.089e-03, -1.742e-02, 6.369e-03, -2.461e-02, -1.298e-04, 1.218e-02, -5.301e-03), r1);
	r2 = MulAdd(s0_0_0, M4(-2.208e-02, 1.959e-02, 2.728e-02, 1.328e-02, 8.664e-03, 4.966e-03, -2.127e-03, -3.581e-03, 4.939e-02, 2.762e-03, -8.759e-05, -7.461e-03, 6.366e-03, -3.463e-04, 6.176e-03, -9.190e-03), r2);
	r0 = MulAdd(s0_0_1, M4(2.979e-01, -2.982e-01, -1.577e-02, -1.002e-01, 2.496e-01, 3.685e-02, -1.823e-01, -1.762e-02, -3.070e-01, 1.597e-01, -6.143e-02, 2.009e-02, -2.114e-01, -4.245e-02, -3.096e-02, 1.554e-02), r0);
	r1 = MulAdd(s0_0_1, M4(3.640e-01, -3.545e-01, -6.211e-02, -5.215e-02, 2.956e-01, 3.594e-02, -2.141e-01, -3.576e-02, -1.733e-01, -2.261e-01, -2.186e-02, -2.291e-02, -1.684e-01, -1.636e-01, -3.637e-03, 1.103e-02), r1);
	r2 = MulAdd(s0_0_1, M4(2.998e-01, -3.084e-01, -3.890e-02, -6.867e-02, 2.603e-01, 4.400e-02, -1.925e-01, -2.540e-02, -2.171e-01, -1.869e-02, -2.764e-02, 3.732e-03, -1.939e-01, -1.014e-01, -1.336e-02, 1.426e-02), r2);
	r0 = MulAdd(s0_0_2, M4(-4.039e-03, 4.915e-02, -7.412e-03, 7.153e-02, -1.867e-02, 1.909e-01, -5.238e-02, -1.732e-01, -3.643e-02, -2.979e-01, 1.401e-02, -3.762e-02, -1.296e-02, -1.548e-01, 2.350e-02, -3.596e-03), r0);
	r1 = MulAdd(s0_0_2, M4(-1.871e-02, 4.893e-02, -1.365e-03, 4.432e-02, -1.267e-02, 2.163e-01, -3.744e-02, -1.988e-01, 8.269e-03, 1.788e-02, -2.171e-03, -3.139e-02, 3.703e-03, -2.870e-02, -2.604e-03, 2.821e-03), r1);
	r2 = MulAdd(s0_0_2, M4(-8.744e-03, 5.322e-02, -2.030e-03, 5.066e-02, -1.380e-02, 1.890e-01, -4.211e-02, -1.832e-01, -5.762e-03, -1.223e-01, 7.694e-03, -2.437e-02, -2.320e-03, -9.447e-02, 6.421e-03, -2.418e-03), r2);
	r0 = MulAdd(s0_1_0, M4(-7.853e-03, 5.859e-03, -1.972e-02, -1.514e-02, -6.588e-03, 6.406e-04, -8.644e-03, -9.353e-04, 1.215e-01, -2.025e-02, 1.719e-01, -2.262e-02, -6.103e-02, 4.662e-03, 2.335e-02, 1.275e-03), r0);
	r1 = MulAdd(s0_1_0, M4(-9.859e-04, 1.120e-02, -5.238e-02, -4.448e-03, -7.253e-03, 2.076e-03, 1.600e-03, 3.820e-03, -4.480e-04, 1.353e-02, -5.193e-02, -2.576e-03, -5.464e-04, 1.758e-03, 1.294e-02, -9.923e-03), r1);
	r2 = MulAdd(s0_1_0, M4(-7.281e-04, 1.188e-02, -3.573e-02, -6.660e-03, -4.438e-03, 2.159e-03, -1.708e-03, 3.255e-03, 5.566e-02, -4.250e-03, 5.721e-02, -1.273e-02, -2.723e-02, 5.208e-03, 1.986e-02, -2.325e-03), r2);
	r0 = MulAdd(s0_1_1, M4(-3.559e-03, -2.249e-02, 8.227e-02, 1.071e-01, -5.913e-03, -1.518e-02, 9.063e-03, 2.123e-03, 9.493e-02, 2.124e-01, -3.580e-01, 2.205e-01, -9.253e-02, -1.162e-01, 3.604e-01, 2.686e-01), r0);
	r1 = MulAdd(s0_1_1, M4(-4.645e-03, -3.023e-02, 1.233e-01, 6.271e-02, -1.219e-02, -1.716e-02, 8.412e-03, 4.951e-03, 2.881e-01, 6.324e-02, -1.317e-01, -1.326e-01, -1.274e-01, -4.386e-02, 3.799e-01, 2.666e-01), r1);
	r2 = MulAdd(s0_1_1, M4(-4.944e-03, -2.414e-02, 9.790e-02, 7.098e-02, -1.133e-02, -1.509e-02, 1.257e-02, -1.326e-03, 1.655e-01, 1.211e-01, -2.271e-01, 3.550e-02, -9.406e-02, -7.349e-02, 3.314e-01, 2.499e-01), r2);
	r0 = MulAdd(s0_1_2, M4(-5.433e-03, -1.814e-03, -5.437e-03, -3.936e-02, -6.876e-03, -1.689e-02, 1.337e-02, 2.806e-02, 3.829e-02, -8.765e-02, 5.229e-03, -2.568e-01, 3.401e-02, 6.517e-02, -1.455e-02, 3.408e-02), r0);
	r1 = MulAdd(s0_1_2, M4(-2.054e-03, -4.814e-03, -1.070e-02, -1.353e-02, -6.565e-03, -1.737e-02, 2.317e-02, 4.102e-02, -7.593e-03, 8.439e-02, 5.512e-03, 1.008e-01, 6.961e-04, -3.070e-02, -2.415e-03, 5.842e-02), r1);
	r2 = MulAdd(s0_1_2, M4(-5.188e-03, -3.672e-03, -8.543e-03, -2.601e-02, -4.848e-03, -1.591e-02, 1.740e-02, 3.796e-02, 9.355e-03, -1.150e-02, 4.803e-03, -7.311e-02, 1.548e-02, 2.101e-02, -2.166e-03, 4.166e-02), r2);
	r0 = MulAdd(s0_2_0, M4(-2.937e-03, -2.699e-03, 5.213e-03, 3.087e-03, 8.634e-04, 3.692e-04, -8.696e-04, -1.230e-03, 2.045e-02, 3.540e-03, 6.616e-02, -1.037e-02, -9.965e-03, -1.553e-03, -2.841e-02, 6.177e-03), r0);
	r1 = MulAdd(s0_2_0, M4(-3.560e-03, -1.530e-03, -4.897e-04, 2.963e-03, -3.156e-04, -7.019e-04, -4.349e-03, -1.829e-03, 3.168e-03, 2.477e-03, 6.357e-03, 4.932e-03, -9.437e-04, 6.672e-05, -6.886e-04, -8.661e-04), r1);
	r2 = MulAdd(s0_2_0, M4(-2.654e-03, -1.131e-03, 3.061e-03, 3.880e-03, -5.153e-04, -1.163e-03, -2.923e-03, -1.784e-03, 9.331e-03, 2.525e-03, 3.285e-02, -4.008e-03, -4.681e-03, -8.504e-04, -1.364e-02, 1.436e-03), r2);
	r0 = MulAdd(s0_2_1, M4(-1.176e-03, 2.401e-03, -7.210e-03, -4.414e-03, 3.920e-04, 4.074e-03, -4.163e-03, 1.820e-04, -2.228e-02, 1.665e-02, 9.595e-02, 1.693e-01, 6.012e-03, -9.319e-03, -5.848e-02, -7.561e-02), r0);
	r1 = MulAdd(s0_2_1, M4(-1.133e-03, -2.866e-03, -1.883e-03, -3.280e-03, 9.823e-04, 2.633e-03, -2.234e-03, -3.719e-03, -4.587e-04, 8.403e-03, 1.399e-01, 7.983e-02, -1.846e-03, -6.363e-03, -7.548e-02, -3.821e-02), r1);
	r2 = MulAdd(s0_2_1, M4(-1.263e-03, -1.323e-03, -3.777e-03, -4.151e-03, 2.384e-03, 4.154e-03, -1.898e-03, -5.803e-04, -1.079e-02, 9.122e-03, 9.692e-02, 1.086e-01, 3.145e-03, -5.543e-03, -5.565e-02, -4.896e-02), r2);
	r0 = MulAdd(s0_2_2, M4(-2.368e-03, 1.092e-04, -2.087e-03, 1.201e-03, 3.696e-03, 4.056e-04, -2.559e-04, -6.398e-03, 1.044e-02, -1.100e-03, -4.713e-03, -4.260e-02, -2.140e-03, 9.309e-05, 6.975e-03, 1.464e-02), r0);
	r1 = MulAdd(s0_2_2, M4(-9.231e-04, -5.455e-04, -2.037e-03, -3.532e-03, -6.467e-04, -3.532e-04, 2.616e-04, -1.863e-03, 3.581e-03, 1.384e-02, 1.700e-03, 4.360e-02, -9.289e-04, -7.030e-03, 2.930e-03, -2.242e-02), r1);
	r2 = MulAdd(s0_2_2, M4(-1.323e-03, -6.601e-04, -2.806e-03, -1.442e-03, 9.938e-04, 3.799e-04, 6.880e-05, -3.430e-03, 5.654e-03, 4.994e-03, -3.728e-03, -7.251e-03, -6.759e-04, -1.833e-03, 5.183e-03, 3.562e-04), r2);
	r0 = MulAdd(s1_0_0, M4(1.067e-01, 1.064e-02, -9.063e-03, -1.991e-02, -1.464e-01, 1.634e-03, -2.669e-03, 2.365e-02, -8.442e-02, 6.207e-05, -7.602e-03, 8.206e-03, 1.282e-01, 7.887e-03, 4.575e-03, -3.235e-02), r0);
	r1 = MulAdd(s1_0_0, M4(-2.027e-02, 4.521e-04, -8.274e-03, 3.680e-03, -5.634e-03, 3.615e-03, 6.391e-03, 1.615e-03, -1.456e-02, -1.202e-03, 2.240e-03, 3.401e-03, 7.371e-04, 6.666e-03, -3.679e-03, 9.365e-04), r1);
	r2 = MulAdd(s1_0_0, M4(4.384e-02, 6.352e-03, -7.506e-03, -6.714e-03, -7.447e-02, 9.225e-04, 2.377e-03, 1.087e-02, -4.089e-02, -9.063e-05, 1.087e-03, 3.518e-03, 5.837e-02, 4.967e-03, -1.704e-03, -1.382e-02), r2);
	r0 = MulAdd(s1_0_1, M4(3.105e-02, 1.189e-01, -2.006e-02, 2.241e-02, -1.910e-02, -1.421e-01, 1.133e-02, -1.767e-02, -4.928e-02, -1.756e-01, 9.529e-03, -1.207e-03, 1.392e-01, 1.608e-01, 2.716e-02, 3.624e-02), r0);
	r1 = MulAdd(s1_0_1, M4(-2.021e-02, -9.009e-02, -4.349e-03, 1.652e-02, -1.872e-02, 6.519e-02, -4.739e-03, -9.918e-03, 1.153e-01, 2.586e-02, -5.111e-03, -8.558e-03, 2.471e-02, 3.022e-02, 2.619e-02, 2.620e-03), r1);
	r2 = MulAdd(s1_0_1, M4(5.245e-03, 1.505e-02, -1.126e-02, 1.858e-02, -1.181e-02, -3.251e-02, 3.450e-03, -9.436e-03, 3.327e-02, -6.629e-02, 3.095e-03, 1.543e-03, 6.764e-02, 8.362e-02, 1.680e-02, 1.048e-02), r2);
	r0 = MulAdd(s1_0_2, M4(2.852e-03, 1.756e-03, -7.732e-04, 2.153e-03, -3.785e-03, 2.129e-03, 2.040e-04, -2.192e-03, 3.452e-03, -8.097e-03, 4.310e-03, 7.817e-03, 2.191e-02, 1.899e-01, -1.703e-02, 1.587e-02), r0);
	r1 = MulAdd(s1_0_2, M4(6.241e-03, -1.120e-02, 2.323e-04, 3.808e-03, 6.822e-04, -1.257e-03, 1.309e-04, -3.293e-03, -1.793e-03, 3.333e-02, 3.697e-04, 1.337e-02, -1.422e-02, -5.500e-02, 4.176e-03, 1.072e-02), r1);
	r2 = MulAdd(s1_0_2, M4(3.154e-03, -5.110e-03, -5.701e-04, 1.997e-03, -1.159e-03, -1.273e-04, 3.928e-04, -3.263e-03, -4.427e-03, 4.453e-03, -1.738e-03, 5.407e-03, 1.228e-03, 6.721e-02, -6.214e-03, 8.765e-03), r2);
	r0 = MulAdd(s1_1_0, M4(7.107e-02, -1.213e-02, 1.665e-01, 3.448e-02, -9.596e-02, -5.542e-03, -2.705e-01, -4.676e-02, 3.342e-03, -8.814e-03, -1.077e-01, -2.060e-02, 7.056e-02, -1.879e-02, 1.353e-01, -1.620e-02), r0);
	r1 = MulAdd(s1_1_0, M4(1.597e-01, -8.387e-03, 7.740e-02, -9.432e-04, -2.730e-01, -2.836e-02, -1.665e-01, -1.498e-02, -1.052e-01, -6.273e-03, -9.595e-02, -6.820e-03, 1.544e-02, 1.267e-02, 4.452e-02, 7.309e-03), r1);
	r2 = MulAdd(s1_1_0, M4(1.101e-01, -1.016e-02, 1.121e-01, 1.487e-02, -1.734e-01, -1.352e-02, -2.089e-01, -2.606e-02, -2.997e-02, -2.109e-03, -8.046e-02, -5.588e-03, 3.330e-02, -4.331e-03, 8.079e-02, -5.704e-03), r2);
	r0 = MulAdd(s1_1_1, M4(-2.666e-01, 1.023e-01, 2.864e-02, -2.095e-01, 5.168e-02, 3.975e-01, -2.451e-02, 5.073e-02, 1.997e-01, 1.015e-03, 6.006e-02, -2.914e-01, -3.306e-01, -9.131e-02, -4.190e-01, -1.896e-02), r0);
	r1 = MulAdd(s1_1_1, M4(-1.655e-01, 3.391e-01, -1.467e-02, -3.662e-01, 2.655e-02, 2.261e-01, -6.696e-03, 2.666e-01, 6.039e-02, -1.872e-01, 2.823e-01, -1.392e-01, -1.023e-01, 5.420e-02, 6.333e-03, 3.252e-01), r1);
	r2 = MulAdd(s1_1_1, M4(-1.893e-01, 1.968e-01, 6.027e-03, -2.588e-01, 2.941e-02, 2.822e-01, -1.162e-02, 1.401e-01, 1.135e-01, -7.820e-02, 1.499e-01, -1.963e-01, -1.874e-01, -8.263e-03, -1.890e-01, 1.479e-01), r2);
	r0 = MulAdd(s1_1_2, M4(-9.908e-03, -5.994e-02, -6.173e-03, 1.122e-02, 1.802e-03, -3.177e-03, -2.270e-03, 1.581e-02, 1.657e-02, 1.694e-01, -1.089e-02, 1.601e-02, 6.317e-03, 7.739e-03, 1.035e-02, 4.150e-02), r0);
	r1 = MulAdd(s1_1_2, M4(-9.912e-04, -3.095e-02, -3.423e-03, -1.444e-02, -2.638e-03, -4.483e-03, -1.770e-04, 1.209e-03, 8.403e-03, 5.119e-02, -3.925e-03, 6.751e-02, -1.106e-02, -1.558e-01, -1.131e-02, -1.561e-01), r1);
	r2 = MulAdd(s1_1_2, M4(-2.988e-03, -4.309e-02, -4.810e-03, -1.960e-03, 9.499e-04, -1.540e-03, 2.154e-04, 8.122e-03, 6.489e-03, 9.228e-02, -1.184e-02, 2.628e-02, 2.067e-03, -5.991e-02, -1.384e-04, -4.662e-02), r2);
	r0 = MulAdd(s1_2_0, M4(5.723e-03, 1.760e-03, -1.095e-02, -3.131e-03, -5.622e-03, -3.335e-03, 2.607e-02, 1.063e-02, 4.083e-03, -1.441e-03, 3.182e-02, 3.697e-03, -4.013e-03, 2.450e-03, 2.379e-02, -5.051e-04), r0);
	r1 = MulAdd(s1_2_0, M4(2.916e-03, -2.862e-03, 4.800e-02, 1.229e-02, 5.789e-03, 1.072e-02, -1.086e-01, -3.053e-03, 2.314e-03, 3.017e-04, -3.285e-02, -1.999e-03, 2.850e-03, 2.674e-03, -1.371e-03, -1.186e-03), r1);
	r2 = MulAdd(s1_2_0, M4(4.714e-03, -1.273e-03, 1.571e-02, 3.857e-03, 3.799e-04, 4.525e-03, -3.832e-02, 2.784e-03, 1.533e-03, -8.595e-04, 2.166e-03, 4.686e-04, -4.530e-03, 1.610e-03, 7.018e-03, -1.611e-03), r2);
	r0 = MulAdd(s1_2_1, M4(3.992e-02, 1.054e-02, -3.083e-02, -5.205e-02, -2.951e-02, 1.461e-03, 1.288e-02, 2.241e-01, -2.692e-02, -1.000e-02, 1.062e-01, 6.421e-02, -4.201e-02, -3.221e-02, 3.333e-02, 3.674e-02), r0);
	r1 = MulAdd(s1_2_1, M4(1.176e-02, -3.493e-03, 2.257e-02, 5.164e-02, -3.127e-03, -5.444e-03, 1.444e-02, 3.036e-02, 8.882e-03, 9.690e-03, -3.492e-02, -7.251e-02, 1.800e-03, 1.598e-02, -1.072e-01, -6.677e-02), r1);
	r2 = MulAdd(s1_2_1, M4(1.996e-02, 2.188e-03, -8.121e-03, -3.276e-03, -1.307e-02, -1.221e-03, 1.041e-02, 1.199e-01, -8.511e-03, -4.760e-04, 3.479e-02, 2.108e-03, -1.702e-02, -6.927e-03, -2.517e-02, -1.071e-02), r2);
	r0 = MulAdd(s1_2_2, M4(5.616e-03, 8.098e-03, -1.452e-02, -2.944e-02, 1.328e-03, -3.718e-03, -8.650e-06, -1.776e-02, -1.076e-02, 1.052e-04, 1.837e-02, 1.228e-01, -2.496e-02, -7.436e-04, 8.760e-03, 8.761e-02), r0);
	r1 = MulAdd(s1_2_2, M4(3.215e-04, -5.610e-03, -7.334e-03, 2.798e-03, 3.775e-04, 1.112e-03, -1.469e-03, -1.632e-03, 1.675e-03, -8.123e-04, 8.789e-03, -1.283e-03, 1.028e-02, -9.428e-03, 6.587e-04, -5.762e-02), r1);
	r2 = MulAdd(s1_2_2, M4(1.239e-03, -2.865e-04, -9.675e-03, -1.420e-02, 1.509e-03, -1.457e-03, 1.356e-04, -7.448e-03, -5.003e-03, -3.382e-03, 9.772e-03, 5.164e-02, -4.776e-03, -2.419e-03, 6.755e-03, 2.141e-02), r2);
	s0_0_0 = L2(-1.0, -1.0); s0_0_1 = L2(0.0, -1.0); s0_0_2 = L2(1.0, -1.0);
	s0_1_0 = L2(-1.0, 0.0); s0_1_1 = L2(0.0, 0.0); s0_1_2 = L2(1.0, 0.0);
	s0_2_0 = L2(-1.0, 1.0); s0_2_1 = L2(0.0, 1.0); s0_2_2 = L2(1.0, 1.0);
	s1_0_0 = L3(-1.0, -1.0); s1_0_1 = L3(0.0, -1.0); s1_0_2 = L3(1.0, -1.0);
	s1_1_0 = L3(-1.0, 0.0); s1_1_1 = L3(0.0, 0.0); s1_1_2 = L3(1.0, 0.0);
	s1_2_0 = L3(-1.0, 1.0); s1_2_1 = L3(0.0, 1.0); s1_2_2 = L3(1.0, 1.0);
	r0 = MulAdd(s0_0_0, M4(-6.438e-03, -3.129e-03, 3.253e-03, 3.653e-03, -2.017e-01, -5.363e-04, 2.255e-03, 4.920e-02, 1.602e-02, -5.146e-03, 1.079e-02, -1.125e-03, -6.762e-02, 2.322e-02, -2.198e-02, 2.321e-02), r0);
	r1 = MulAdd(s0_0_0, M4(2.567e-04, 2.390e-03, 2.647e-03, 2.217e-03, 7.122e-02, -7.139e-03, 1.861e-02, -8.215e-03, 8.965e-03, 2.026e-03, 4.022e-03, -3.170e-04, 3.078e-02, 4.808e-03, 2.251e-02, -2.470e-03), r1);
	r2 = MulAdd(s0_0_0, M4(-3.469e-03, 1.316e-04, 2.780e-03, 3.323e-03, -6.790e-02, -6.113e-03, 5.470e-03, 1.591e-02, 9.232e-03, -2.416e-03, 6.094e-03, -1.086e-03, -2.378e-02, 1.293e-02, -4.639e-03, 1.025e-02), r2);
	r0 = MulAdd(s0_0_1, M4(4.665e-03, 1.185e-03, -2.128e-03, -4.327e-03, 4.019e-02, -2.307e-01, 2.951e-02, -4.841e-02, 1.475e-02, 5.783e-02, 2.280e-03, -1.834e-03, 2.427e-01, 6.166e-02, -1.520e-02, -1.941e-02), r0);
	r1 = MulAdd(s0_0_1, M4(-1.962e-03, 2.317e-04, -2.264e-03, -2.183e-03, 2.752e-02, 1.039e-01, 1.454e-02, 1.056e-02, 2.932e-02, 4.871e-02, 4.118e-03, -3.983e-03, -8.914e-02, 2.783e-02, -3.420e-03, 1.517e-02), r1);
	r2 = MulAdd(s0_0_1, M4(1.275e-03, -1.492e-03, -2.466e-03, -3.727e-03, 3.229e-02, -6.187e-02, 1.995e-02, -1.808e-02, 1.547e-02, 4.924e-02, 2.269e-03, -5.053e-03, 7.887e-02, 3.527e-02, -6.271e-03, -2.472e-03), r2);
	r0 = MulAdd(s0_0_2, M4(3.796e-03, 4.292e-03, -1.964e-04, 2.483e-03, 6.634e-03, 2.477e-02, 9.533e-03, 1.168e-02, 2.601e-05, 2.418e-04, 3.323e-04, -2.470e-03, -2.570e-02, 7.300e-02, -5.954e-03, -2.393e-02), r0);
	r1 = MulAdd(s0_0_2, M4(8.873e-06, -3.227e-03, 2.023e-03, 1.632e-03, -1.073e-03, 2.706e-02, -3.603e-03, 1.045e-02, -7.377e-03, 1.082e-02, -1.619e-03, -5.906e-03, 1.631e-02, -3.529e-02, 1.687e-04, -1.408e-04), r1);
	r2 = MulAdd(s0_0_2, M4(1.549e-03, 1.521e-03, 1.642e-03, 2.491e-03, 1.661e-03, 1.834e-02, 2.850e-03, 9.765e-03, -2.417e-03, 6.816e-03, -2.642e-04, -3.060e-03, -3.650e-03, 1.860e-02, -1.705e-03, -8.120e-03), r2);
	r0 = MulAdd(s0_1_0, M4(-3.532e-02, -8.850e-03, -2.402e-02, 1.283e-02, -1.807e-01, 4.574e-02, -1.902e-01, 4.358e-02, 1.814e-02, 1.631e-02, 6.161e-02, -4.501e-03, -7.760e-02, 2.654e-02, -1.223e-01, 2.046e-02), r0);
	r1 = MulAdd(s0_1_0, M4(7.105e-02, -6.195e-03, -1.009e-02, 6.083e-04, 6.307e-02, -1.583e-02, 7.203e-02, -1.340e-02, 9.301e-02, 2.213e-02, 5.842e-02, -1.400e-02, -1.662e-03, -1.457e-02, 2.949e-02, -7.236e-03), r1);
	r2 = MulAdd(s0_1_0, M4(1.914e-02, -3.988e-03, -1.154e-02, 8.803e-03, -5.738e-02, 1.516e-02, -5.701e-02, 1.345e-02, 4.508e-02, 1.623e-02, 5.525e-02, -9.682e-03, -3.580e-02, 5.084e-03, -5.105e-02, 3.810e-03), r2);
	r0 = MulAdd(s0_1_1, M4(2.783e-01, 7.422e-02, 3.727e-02, -3.920e-02, 1.869e-01, 5.431e-02, 5.243e-01, 3.093e-01, 1.884e-01, -5.760e-01, 3.151e-03, 1.622e-01, -8.949e-02, -2.881e-01, 3.975e-01, -1.068e-01), r0);
	r1 = MulAdd(s0_1_1, M4(2.056e-01, 2.725e-01, 1.213e-02, -4.036e-03, -1.935e-01, 6.665e-02, -2.618e-01, 9.070e-02, 1.675e-01, -5.959e-01, 1.328e-02, 1.406e-01, 3.823e-02, 2.397e-02, -7.594e-02, 4.867e-02), r1);
	r2 = MulAdd(s0_1_1, M4(2.241e-01, 1.558e-01, 1.923e-02, -1.903e-02, -1.027e-02, 4.672e-02, 1.234e-01, 1.778e-01, 1.646e-01, -5.387e-01, 1.131e-02, 1.353e-01, -2.764e-02, -1.176e-01, 1.567e-01, -3.678e-02), r2);
	r0 = MulAdd(s0_1_2, M4(1.334e-02, 1.929e-01, -1.202e-02, 2.924e-02, -6.421e-02, -1.978e-01, 9.867e-03, 5.629e-02, 6.940e-03, 6.274e-02, 8.640e-03, -1.737e-02, -3.281e-02, 3.268e-02, -2.201e-02, 2.437e-01), r0);
	r1 = MulAdd(s0_1_2, M4(-3.033e-03, 1.440e-02, 9.754e-04, 9.234e-03, 1.830e-02, -6.172e-03, 1.207e-02, -1.179e-02, 2.750e-03, 4.090e-02, 4.852e-03, 1.537e-02, 3.847e-04, 1.971e-03, 5.628e-03, -5.065e-02), r1);
	r2 = MulAdd(s0_1_2, M4(3.400e-03, 9.692e-02, -5.493e-03, 1.449e-02, -1.667e-02, -8.912e-02, 1.122e-02, 2.570e-02, 2.193e-03, 4.944e-02, 6.592e-03, 1.498e-03, -1.271e-02, 1.869e-02, -7.319e-03, 9.400e-02), r2);
	r0 = MulAdd(s0_2_0, M4(-5.618e-04, -1.863e-03, -1.023e-01, -6.906e-03, -2.175e-02, -7.190e-03, -1.029e-01, 1.037e-02, 6.245e-03, -7.128e-04, 1.608e-02, -1.019e-03, 1.047e-02, -3.112e-03, -9.771e-03, 4.571e-03), r0);
	r1 = MulAdd(s0_2_0, M4(-2.500e-03, -4.053e-03, -1.006e-02, 2.632e-02, -5.412e-03, -7.762e-03, 2.534e-02, -3.852e-03, -2.475e-03, -4.035e-03, 7.104e-02, -1.047e-03, -2.196e-03, -2.269e-03, -3.515e-03, 3.828e-04), r1);
	r2 = MulAdd(s0_2_0, M4(-2.798e-03, -4.837e-03, -5.409e-02, 1.026e-02, -8.384e-03, -6.636e-03, -3.577e-02, 3.961e-03, 1.546e-03, -7.711e-04, 4.453e-02, -4.497e-04, 3.808e-03, -3.207e-03, -5.384e-03, 9.354e-04), r2);
	r0 = MulAdd(s0_2_1, M4(1.463e-02, -4.398e-03, -1.654e-01, -3.337e-01, 7.349e-02, 2.045e-02, -1.479e-01, -2.227e-01, 6.761e-04, 6.156e-03, 1.774e-03, -1.353e-01, 1.211e-02, 3.186e-02, -1.228e-01, -4.846e-02), r0);
	r1 = MulAdd(s0_2_1, M4(-2.042e-03, -5.351e-03, -2.785e-01, -2.646e-01, -5.965e-03, -3.058e-02, 7.056e-02, 5.533e-02, -8.575e-03, 9.911e-03, -3.260e-02, -5.622e-02, -1.021e-02, 1.122e-03, 2.228e-02, 2.659e-02), r1);
	r2 = MulAdd(s0_2_1, M4(7.096e-03, -1.071e-03, -2.102e-01, -2.861e-01, 3.022e-02, -3.165e-03, -3.795e-02, -7.544e-02, -4.214e-03, 7.974e-03, -1.012e-02, -8.911e-02, 2.044e-03, 1.317e-02, -4.482e-02, -8.578e-03), r2);
	r0 = MulAdd(s0_2_2, M4(-2.228e-02, -1.859e-04, 2.460e-02, 8.291e-02, 4.829e-02, 1.483e-02, -3.027e-02, -1.816e-01, -5.299e-03, -5.910e-03, 1.538e-02, 3.918e-02, 1.437e-02, 1.461e-02, -1.933e-02, -6.909e-02), r0);
	r1 = MulAdd(s0_2_2, M4(-2.631e-03, 4.116e-03, 1.764e-02, -4.652e-02, -1.205e-02, 1.407e-02, -1.574e-02, 4.112e-02, -1.371e-03, 3.328e-03, 9.063e-03, 5.020e-04, -5.089e-03, -1.130e-02, 5.609e-03, 1.011e-03), r1);
	r2 = MulAdd(s0_2_2, M4(-1.017e-02, 1.185e-03, 1.872e-02, 1.647e-02, 1.541e-02, 1.327e-02, -1.798e-02, -6.567e-02, -1.809e-03, -9.195e-05, 1.030e-02, 1.898e-02, 4.266e-03, 2.225e-03, -5.055e-03, -2.904e-02), r2);
	r0 = MulAdd(s1_0_0, M4(-2.550e-02, 5.091e-04, 3.334e-03, 3.930e-03, 2.203e-02, 4.908e-04, -1.761e-02, -6.791e-03, -1.041e-02, -7.519e-03, -1.214e-03, 5.281e-03, 8.700e-03, -7.677e-03, -2.182e-03, 3.167e-03), r0);
	r1 = MulAdd(s1_0_0, M4(7.880e-03, -5.141e-03, 9.778e-03, -2.878e-03, 1.800e-02, -5.652e-03, -1.828e-02, -6.327e-03, -2.156e-03, -2.737e-03, -4.828e-03, -9.137e-04, 3.492e-03, -5.653e-03, -6.866e-03, 2.424e-03), r1);
	r2 = MulAdd(s1_0_0, M4(-8.737e-03, -9.925e-04, 5.803e-03, 1.138e-04, 1.668e-02, -4.179e-03, -2.112e-02, -5.565e-03, -7.279e-03, -4.431e-03, -2.735e-03, 1.998e-03, 6.930e-03, -4.098e-03, -1.704e-03, 4.258e-03), r2);
	r0 = MulAdd(s1_0_1, M4(-1.561e-02, -5.126e-02, 2.111e-02, 1.099e-02, 6.784e-03, 4.434e-03, 2.181e-02, -3.423e-03, 1.928e-03, 5.449e-02, 3.754e-03, -9.827e-03, 3.243e-02, 4.915e-02, -1.540e-02, -1.947e-02), r0);
	r1 = MulAdd(s1_0_1, M4(-4.144e-02, 2.721e-03, 1.017e-02, 2.033e-02, -2.459e-02, -1.086e-02, 2.900e-02, -3.421e-03, -1.903e-02, 4.871e-02, 5.432e-03, -1.252e-03, 3.822e-02, 4.675e-02, -2.033e-02, -1.595e-02), r1);
	r2 = MulAdd(s1_0_1, M4(-3.379e-02, -2.796e-02, 9.139e-03, 1.089e-02, -1.014e-02, -1.249e-02, 2.313e-02, -6.400e-03, -1.313e-02, 5.300e-02, 5.733e-03, -3.410e-03, 3.973e-02, 4.653e-02, -1.565e-02, -1.525e-02), r2);
	r0 = MulAdd(s1_0_2, M4(-1.709e-03, -3.888e-04, 3.749e-03, 1.889e-02, -2.049e-03, 2.887e-04, -2.150e-03, -1.285e-02, -4.251e-04, -1.007e-02, 3.971e-03, 8.721e-04, 1.196e-02, 4.608e-03, -2.113e-03, 3.348e-03), r0);
	r1 = MulAdd(s1_0_2, M4(-6.689e-03, -4.213e-02, 6.249e-03, 1.278e-02, -5.518e-04, -6.555e-04, -1.236e-03, -7.863e-03, 8.934e-04, -8.033e-03, 3.571e-03, -2.951e-03, 1.346e-02, 4.828e-03, 3.003e-04, -3.308e-03), r1);
	r2 = MulAdd(s1_0_2, M4(-2.265e-03, -2.263e-02, 4.575e-03, 1.121e-02, 2.247e-03, 4.232e-03, 1.164e-03, -5.619e-03, -2.167e-04, -1.095e-02, 3.656e-03, -4.380e-04, 1.222e-02, 6.273e-03, 6.363e-04, 1.412e-03), r2);
	r0 = MulAdd(s1_1_0, M4(1.577e-02, 1.781e-03, -4.267e-02, 7.289e-03, -1.753e-02, -4.919e-03, 1.186e-02, 2.276e-02, 2.478e-02, -3.955e-03, 5.448e-03, -1.369e-02, -3.318e-04, -3.777e-03, -1.274e-02, -1.587e-02), r0);
	r1 = MulAdd(s1_1_0, M4(-1.385e-03, -2.143e-03, -1.015e-02, 1.353e-02, -1.704e-02, -4.402e-03, 6.804e-03, 2.789e-02, 3.034e-02, -5.129e-03, 1.351e-02, -2.255e-03, -2.218e-02, -1.975e-03, -2.021e-02, 8.941e-05), r1);
	r2 = MulAdd(s1_1_0, M4(4.004e-03, -1.815e-03, -2.952e-02, 8.337e-03, -3.008e-02, -1.187e-02, -2.518e-03, 1.883e-02, 3.186e-02, -3.581e-03, 1.310e-02, -7.500e-03, -1.118e-02, -3.464e-03, -1.436e-02, -7.637e-03), r2);
	r0 = MulAdd(s1_1_1, M4(2.075e-01, 1.823e-01, -2.104e-01, -3.031e-01, 6.919e-02, 4.745e-03, 2.577e-01, -4.189e-01, -3.263e-01, 1.558e-01, -2.251e-01, 3.207e-01, -3.529e-01, -6.909e-02, 2.763e-01, 2.103e-01), r0);
	r1 = MulAdd(s1_1_1, M4(2.280e-01, 1.707e-01, -2.588e-01, -2.744e-01, 1.018e-01, 5.474e-03, 3.099e-01, -4.999e-01, -3.327e-01, 1.891e-01, -2.764e-01, 3.176e-01, -3.816e-01, -9.350e-02, 3.389e-01, 2.038e-01), r1);
	r2 = MulAdd(s1_1_1, M4(2.031e-01, 1.625e-01, -2.183e-01, -2.667e-01, 9.125e-02, 1.031e-03, 2.608e-01, -4.297e-01, -3.018e-01, 1.565e-01, -2.388e-01, 2.900e-01, -3.447e-01, -7.788e-02, 2.822e-01, 1.928e-01), r2);
	r0 = MulAdd(s1_1_2, M4(-1.662e-03, 2.843e-02, -1.402e-03, 1.376e-02, 7.504e-03, 5.855e-03, -6.514e-03, 2.192e-02, 2.474e-02, 4.379e-02, 1.056e-02, -3.479e-02, -3.202e-03, -2.391e-02, 2.906e-03, 1.883e-02), r0);
	r1 = MulAdd(s1_1_2, M4(1.115e-02, 3.235e-02, -1.644e-03, -3.302e-02, -9.341e-04, 1.320e-02, -9.652e-03, 3.873e-02, 1.016e-02, 4.263e-02, 9.917e-03, -2.149e-02, -1.317e-02, -1.885e-02, -3.641e-03, 5.383e-02), r1);
	r2 = MulAdd(s1_1_2, M4(5.598e-03, 3.699e-02, 2.239e-03, -8.101e-03, 5.083e-03, 1.790e-02, -3.740e-03, 4.335e-02, 1.393e-02, 4.068e-02, 1.006e-02, -2.963e-02, -7.864e-03, -2.619e-02, -6.784e-04, 3.503e-02), r2);
	r0 = MulAdd(s1_2_0, M4(-3.263e-03, 3.533e-03, 2.200e-02, 1.389e-03, -3.910e-03, 4.546e-03, -2.472e-02, -3.422e-03, 4.248e-03, -6.435e-04, 1.216e-02, 3.916e-03, 1.246e-03, 9.879e-05, -1.347e-02, -6.114e-04), r0);
	r1 = MulAdd(s1_2_0, M4(2.452e-03, 4.664e-03, 1.372e-02, -5.297e-03, -1.344e-03, 6.733e-03, -1.245e-02, 2.167e-03, -9.286e-04, 7.782e-04, 1.655e-02, 2.166e-03, 2.782e-03, 5.818e-04, -1.947e-02, 3.934e-03), r1);
	r2 = MulAdd(s1_2_0, M4(1.216e-03, 4.256e-03, 1.870e-02, -1.494e-03, -1.727e-03, 3.618e-03, -1.980e-02, -2.073e-03, 4.142e-03, 1.705e-03, 1.805e-02, 5.532e-03, 2.529e-03, 1.313e-03, -1.462e-02, 2.056e-03), r2);
	r0 = MulAdd(s1_2_1, M4(-7.758e-03, -6.337e-03, 2.215e-02, 5.267e-02, -4.955e-03, -1.524e-02, -2.122e-03, 3.507e-04, 1.512e-02, 2.573e-02, -7.046e-02, -3.521e-03, 8.601e-03, 5.231e-03, -5.413e-02, -1.970e-02), r0);
	r1 = MulAdd(s1_2_1, M4(-6.544e-03, -6.510e-03, 3.414e-02, 4.065e-02, -5.162e-03, -9.810e-03, 3.372e-03, 1.295e-02, 4.820e-03, 1.755e-02, -6.812e-02, 1.641e-02, 4.348e-03, 5.625e-03, -6.570e-02, -2.815e-02), r1);
	r2 = MulAdd(s1_2_1, M4(-4.860e-03, -4.474e-03, 3.325e-02, 5.093e-02, -1.495e-03, -1.111e-02, 3.652e-03, 4.700e-03, 9.101e-03, 2.150e-02, -6.213e-02, 7.515e-03, 6.880e-03, 4.125e-03, -6.013e-02, -2.434e-02), r2);
	r0 = MulAdd(s1_2_2, M4(1.142e-04, -7.212e-04, -5.092e-04, -2.046e-03, -3.479e-03, -2.587e-03, 3.393e-03, 8.602e-03, -1.251e-02, -9.360e-03, 1.481e-02, 2.017e-02, -6.208e-03, 4.036e-03, -1.107e-03, 1.123e-03), r0);
	r1 = MulAdd(s1_2_2, M4(8.721e-04, 1.955e-03, -9.949e-04, 7.010e-03, -5.746e-04, -3.210e-04, 2.500e-03, 1.078e-02, -2.390e-03, -2.847e-03, 9.798e-03, 2.431e-03, 3.818e-03, 4.448e-03, -2.957e-03, -1.994e-02), r1);
	r2 = MulAdd(s1_2_2, M4(8.963e-04, 1.964e-03, 2.530e-04, 5.079e-03, -1.868e-04, 1.616e-03, 4.867e-03, 1.541e-02, -6.899e-03, -6.913e-03, 8.981e-03, 1.055e-02, -2.767e-04, 4.561e-03, -1.626e-03, -7.686e-03), r2);
	float2 opt = float2(GetOutputPt()), fpos = (float2(gxy) + 0.5) * opt;
	OUTPUT[gxy + int2(0, 0)] = MF4(saturate(INPUT.SampleLevel(SL, fpos + float2(0.0, 0.0) * opt, 0).rgb + MF3(r0.x, r1.x, r2.x)), 1.0);
	OUTPUT[gxy + int2(1, 0)] = MF4(saturate(INPUT.SampleLevel(SL, fpos + float2(1.0, 0.0) * opt, 0).rgb + MF3(r0.y, r1.y, r2.y)), 1.0);
	OUTPUT[gxy + int2(0, 1)] = MF4(saturate(INPUT.SampleLevel(SL, fpos + float2(0.0, 1.0) * opt, 0).rgb + MF3(r0.z, r1.z, r2.z)), 1.0);
	OUTPUT[gxy + int2(1, 1)] = MF4(saturate(INPUT.SampleLevel(SL, fpos + float2(1.0, 1.0) * opt, 0).rgb + MF3(r0.w, r1.w, r2.w)), 1.0);
}
