const zhHans = {
  common: {
    login: '登录',
    logout: '退出登录',
    accountOptions: '系统设置',
    account: '账户',
    integration: '连接',
    email: '邮箱',
    password: '密码',
    welcome: '欢迎回到 LangBot 👋',
    continueToLogin: '登录以继续',
    loginSuccess: '登录成功',
    loginFailed: '登录失败，请检查邮箱和密码是否正确',
    enterEmail: '输入邮箱地址',
    enterPassword: '输入密码',
    invalidEmail: '请输入有效的邮箱地址',
    emptyPassword: '请输入密码',
    language: '语言',
    helpDocs: '帮助文档',
    featureRequest: '需求建议',
    create: '创建',
    edit: '编辑',
    delete: '删除',
    add: '添加',
    select: '请选择',
    cancel: '取消',
    submit: '提交',
    error: '错误',
    success: '成功',
    save: '保存',
    saving: '保存中...',
    confirm: '确认',
    confirmDelete: '确认删除',
    deleteConfirmation: '你确定要删除这个吗？',
    selectOption: '选择一个选项',
    required: '必填',
    enable: '是否启用',
    name: '名称',
    description: '描述',
    close: '关闭',
    deleteSuccess: '删除成功',
    deleteError: '删除失败：',
    addRound: '添加回合',
    copy: '复制',
    copySuccess: '复制成功',
    copyFailed: '复制失败',
    test: '测试',
    forgotPassword: '忘记密码？',
    loading: '加载中...',
    or: '或',
    loginWithSpace: '通过 Space 登录',
    spaceLoginRecommended: '推荐：使用官方提供的稳定模型 API 和云服务',
    loginLocal: '使用本地账号登录',
    loginWithPassword: '通过密码登录',
    spaceLoginTitle: '通过 Space 登录',
    spaceLoginDescription: '扫描二维码或访问下方链接进行授权',
    spaceLoginUserCode: '您的验证码',
    spaceLoginExpires: '验证码将在 {{seconds}} 秒后过期',
    spaceLoginWaiting: '等待授权中...',
    spaceLoginSuccess: '授权成功',
    spaceLoginFailed: 'Space 登录失败',
    spaceLoginExpired: '验证码已过期，请重试',
    spaceLoginCancel: '取消',
    spaceLoginVisitLink: '访问链接',
    spaceLoginProcessing: '正在通过 Space 登录',
    spaceLoginProcessingDescription: '请稍候，正在完成登录...',
    spaceLoginSuccessDescription: '正在跳转到 LangBot...',
    spaceLoginError: '登录失败',
    spaceLoginNoCode: '缺少授权码',
    backToLogin: '返回登录',
    backToHome: '返回首页',
    spaceAccountCannotChangePassword: 'Space 账户无法在此修改密码',
    theme: '主题',
    changePassword: '修改密码',
    currentPassword: '当前密码',
    newPassword: '新密码',
    confirmNewPassword: '确认新密码',
    enterCurrentPassword: '输入当前密码',
    enterNewPassword: '输入新密码',
    enterConfirmPassword: '确认新密码',
    currentPasswordRequired: '当前密码不能为空',
    newPasswordRequired: '新密码不能为空',
    confirmPasswordRequired: '确认密码不能为空',
    passwordsDoNotMatch: '两次输入的密码不一致',
    changePasswordSuccess: '密码修改成功',
    changePasswordFailed: '密码修改失败，请检查当前密码是否正确',
    apiIntegration: 'API 集成',
    apiKeys: 'API 密钥',
    manageApiIntegration: '管理 API 集成',
    manageApiKeys: '管理 API 密钥',
    createApiKey: '创建 API 密钥',
    apiKeyName: 'API 密钥名称',
    apiKeyDescription: 'API 密钥描述',
    apiKeyValue: 'API 密钥值',
    apiKeyCreated: 'API 密钥创建成功',
    apiKeyDeleted: 'API 密钥删除成功',
    apiKeyDeleteConfirm: '确定要删除此 API 密钥吗？',
    apiKeyNameRequired: 'API 密钥名称不能为空',
    copyApiKey: '复制 API 密钥',
    apiKeyCopied: 'API 密钥已复制到剪贴板',
    noApiKeys: '暂无 API 密钥',
    apiKeyHint: 'API 密钥允许外部系统访问 LangBot 的 Service API',
    webhooks: 'Webhooks',
    createWebhook: '创建 Webhook',
    webhookName: 'Webhook 名称',
    webhookUrl: 'Webhook URL',
    webhookDescription: 'Webhook 描述',
    webhookEnabled: '是否启用',
    webhookCreated: 'Webhook 创建成功',
    webhookDeleted: 'Webhook 删除成功',
    webhookDeleteConfirm: '确定要删除此 Webhook 吗？',
    webhookNameRequired: 'Webhook 名称不能为空',
    webhookUrlRequired: 'Webhook URL 不能为空',
    noWebhooks: '暂无 Webhook',
    webhookHint: 'Webhook 允许 LangBot 将个人消息和群消息事件推送到外部系统',
    actions: '操作',
    apiKeyCreatedMessage: '请复制此 API 密钥。',
    none: '无',
  },
  notFound: {
    title: '页面不存在',
    description:
      '您要查找的页面似乎不存在。请检查您输入的 URL 是否正确，或者返回首页。',
    back: '上一级',
    home: '返回主页',
    help: '查看帮助文档',
  },
  models: {
    title: '模型配置',
    description: '配置和管理可在流水线中使用的模型',
    createModel: '创建对话模型',
    editModel: '编辑模型',
    getModelListError: '获取模型列表失败：',
    modelName: '模型名称',
    modelProvider: '模型提供商',
    modelBaseURL: '基础 URL',
    modelAbilities: '模型能力',
    saveSuccess: '保存成功',
    saveError: '保存失败：',
    createSuccess: '创建成功',
    createError: '创建失败：',
    deleteSuccess: '删除成功',
    deleteError: '删除失败：',
    deleteConfirmation: '你确定要删除这个模型吗？',
    modelNameRequired: '模型名称不能为空',
    modelProviderRequired: '模型供应商不能为空',
    requestURLRequired: '请求URL不能为空',
    apiKeyRequired: 'API Key不能为空',
    keyNameRequired: '键名不能为空',
    mustBeValidNumber: '必须是有效的数字',
    mustBeTrueOrFalse: '必须是 true 或 false',
    requestURL: '请求URL',
    apiKey: 'API Key',
    abilities: '能力',
    selectModelAbilities: '选择模型能力',
    visionAbility: '视觉能力',
    functionCallAbility: '函数调用',
    extraParameters: '额外参数',
    addParameter: '添加参数',
    keyName: '键名',
    type: '类型',
    value: '值',
    string: '字符串',
    number: '数字',
    boolean: '布尔值',
    selectModelProvider: '选择模型供应商',
    modelProviderDescription: '请填写供应商向您提供的模型名称',
    modelManufacturer: '模型厂商',
    aggregationPlatform: '中转平台',
    selfDeployed: '自部署',
    builtin: '内置',
    selectModel: '请选择模型',
    testSuccess: '测试成功',
    testError: '测试失败，请检查模型配置',
    llmModels: '对话模型',
    localProvider: '本地',
    localProviderDescription: '在本地配置和管理的模型',
    spaceProviderDescription: '从您的 Space 账户同步的模型',
    spaceDisabledForLocalAccount: '使用 Space 登录以使用云端模型',
    syncModels: '同步',
    syncSuccess: '同步完成：创建 {{created}} 个，更新 {{updated}} 个',
    syncError: '同步失败：',
    spaceModelReadOnly: 'Space 模型为只读',
    noSpaceModels: '暂无 Space 模型。点击同步按钮从 Space 获取模型。',
    noLocalModels: '暂无本地模型。点击创建按钮添加模型。',
    providerCount: '共 {{count}} 个自定义供应商',
    // 供应商结构新增键
    addModel: '添加模型',
    addLLMModel: '添加对话模型',
    addEmbeddingModel: '添加嵌入模型',
    provider: '供应商',
    existingProvider: '已有供应商',
    newProvider: '新建供应商',
    selectProvider: '选择供应商',
    requester: '供应商类型',
    selectRequester: '选择供应商类型',
    langbotModelsDescription: 'LangBot Space 提供的云端模型',
    credits: '积分',
    loginWithSpace: '通过 Space 登录',
    loginToUseModels: '通过 Space 登录以使用云端模型',
    noModels: '暂无模型',
    editProvider: '编辑供应商',
    addProvider: '添加供应商',
    addProviderHint: '添加自定义供应商以使用其他来源的模型',
    addProviderHintSimple: '添加自定义供应商以使用模型',
    noProviders: '暂无自定义供应商',
    providerName: '供应商名称',
    providerNameRequired: '供应商名称不能为空',
    requesterRequired: '供应商类型不能为空',
    providerSaved: '供应商已保存',
    providerCreated: '供应商已创建',
    providerSaveError: '保存供应商失败：',
    providerDeleted: '供应商已删除',
    providerDeleteError: '删除供应商失败：',
    deleteProviderConfirmation: '你确定要删除这个供应商吗？',
    loadError: '加载数据失败',
    chat: '对话',
    embedding: '嵌入',
    modelsCount: '{{count}} 个模型',
    expandModels: '展开',
    collapseModels: '收起',
  },
  bots: {
    title: '机器人',
    description: '创建和管理机器人，这是 LangBot 与各个平台连接的入口',
    createBot: '创建机器人',
    editBot: '编辑机器人',
    getBotListError: '获取机器人列表失败：',
    botName: '机器人名称',
    botDescription: '机器人描述',
    botNameRequired: '机器人名称不能为空',
    botDescriptionRequired: '机器人描述不能为空',
    adapterRequired: '适配器不能为空',
    defaultDescription: '一个机器人',
    getBotConfigError: '获取机器人配置失败：',
    saveSuccess: '保存成功',
    saveError: '保存失败：',
    createSuccess: '创建成功 请启用或修改绑定流水线',
    createError: '创建失败：',
    deleteSuccess: '删除成功',
    deleteError: '删除失败：',
    deleteConfirmation: '你确定要删除这个机器人吗？',
    platformAdapter: '平台/适配器选择',
    selectAdapter: '选择适配器',
    adapterConfig: '适配器配置',
    bindPipeline: '绑定流水线',
    selectPipeline: '选择流水线',
    selectBot: '请选择机器人',
    botLogTitle: '机器人日志',
    enableAutoRefresh: '开启自动刷新',
    session: '会话',
    yesterday: '昨天',
    earlier: '更久之前',
    dateFormat: '{{month}}月{{day}}日',
    setBotEnableError: '设置机器人启用状态失败',
    log: '日志',
    configuration: '配置',
    logs: '日志',
    webhookUrl: 'Webhook 回调地址',
    webhookUrlCopied: 'Webhook 地址已复制',
    webhookUrlHint:
      '点击输入框自动全选，然后按 Ctrl+C (Mac: Cmd+C) 复制，或点击右侧按钮',
    logLevel: '日志级别',
    allLevels: '全部级别',
    selectLevel: '选择级别',
    levelsSelected: '个级别已选',
  },
  plugins: {
    title: '插件扩展',
    description: '安装和配置用于扩展功能的插件，请在流水线配置中选用',
    createPlugin: '创建插件',
    editPlugin: '编辑插件',
    installed: '已安装',
    marketplace: '插件市场',
    arrange: '编排',
    install: '安装',
    installPlugin: '安装插件',
    onlySupportGithub: '目前仅支持从 GitHub 安装',
    enterGithubLink: '请输入插件的Github链接',
    installing: '正在安装插件...',
    installSuccess: '插件安装成功',
    installFailed: '插件安装失败：',
    searchPlugin: '搜索插件',
    sortBy: '排序方式',
    mostStars: '最多星标',
    recentlyAdded: '最近新增',
    recentlyUpdated: '最近更新',
    noMatchingPlugins: '没有找到匹配的插件',
    loading: '加载中...',
    getPluginListError: '获取插件列表失败:',
    pluginConfig: '插件配置',
    noPluginInstalled: '暂未安装任何插件',
    pluginSort: '插件排序',
    pluginSortDescription:
      '插件顺序会影响同一事件内的处理顺序，请拖动插件卡片排序',
    pluginSortSuccess: '插件排序成功',
    pluginSortError: '插件排序失败：',
    pluginNoConfig: '插件没有配置项。',
    systemDisabled: '插件系统未启用',
    systemDisabledDesc: '尚未启用插件系统，请根据文档修改配置',
    connectionError: '插件系统连接异常',
    connectionErrorDesc: '请检查插件系统配置或联系管理员',
    errorDetails: '错误详情',
    loadingStatus: '正在检查插件系统状态...',
    failedToGetStatus: '获取插件系统状态失败',
    pluginSystemNotReady: '插件系统未就绪，无法执行此操作',
    debugInfo: '调试信息',
    debugInfoTitle: '插件调试信息',
    debugUrl: '调试地址',
    debugKey: '调试密钥',
    noDebugKey: '(未设置)',
    debugKeyDisabled: '未设置调试密钥，插件调试无需认证',
    failedToGetDebugInfo: '获取调试信息失败',
    copiedToClipboard: '已复制到剪贴板',
    deleting: '删除中...',
    deletePlugin: '删除插件',
    cancel: '取消',
    saveConfig: '保存配置',
    saving: '保存中...',
    confirmDeletePlugin: '你确定要删除插件（{{author}}/{{name}}）吗？',
    deleteDataCheckbox: '同时删除插件配置和持久化存储',
    confirmDelete: '确认删除',
    deleteError: '删除失败：',
    close: '关闭',
    deleteConfirm: '删除确认',
    deleteSuccess: '删除成功',
    modifyFailed: '修改失败：',
    componentName: {
      Tool: '工具',
      EventListener: '事件监听器',
      Command: '命令',
      KnowledgeRetriever: '知识检索',
    },
    uploadLocal: '本地上传',
    debugging: '调试中',
    uploadLocalPlugin: '上传本地插件',
    dragToUpload: '拖拽文件到此处上传',
    unsupportedFileType: '不支持的文件类型，仅支持 .lbpkg 和 .zip 文件',
    uploadingPlugin: '正在上传插件...',
    uploadSuccess: '上传成功',
    uploadFailed: '上传失败',
    selectFileToUpload: '选择要上传的插件文件',
    askConfirm: '确定要安装插件 "{{name}}" ({{version}}) 吗？',
    fromGithub: '来自 GitHub',
    fromLocal: '本地安装',
    fromMarketplace: '来自市场',
    componentsList: '组件: ',
    noComponents: '无组件',
    delete: '删除插件',
    update: '更新插件',
    new: '新',
    updateConfirm: '更新确认',
    confirmUpdatePlugin: '你确定要更新插件（{{author}}/{{name}}）吗？',
    confirmUpdate: '确认更新',
    updating: '更新中...',
    updateSuccess: '插件更新成功',
    updateError: '更新失败：',
    saveConfigSuccessNormal: '保存配置成功',
    saveConfigError: '保存配置失败：',
    config: '配置',
    readme: '文档',
    viewSource: '查看来源',
    loadingReadme: '正在加载文档...',
    noReadme: '该插件没有提供 README 文档',
    fileUpload: {
      tooLarge: '文件大小超过 10MB 限制',
      success: '文件上传成功',
      failed: '文件上传失败',
      uploading: '上传中...',
      chooseFile: '选择文件',
      addFile: '添加文件',
    },
    installFromGithub: '来自 GitHub',
    enterRepoUrl: '请输入 GitHub 仓库地址',
    repoUrlPlaceholder: '例如: https://github.com/owner/repo',
    fetchingReleases: '正在获取 Release 列表...',
    selectRelease: '选择 Release',
    noReleasesFound: '未找到 Release',
    fetchReleasesError: '获取 Release 列表失败：',
    selectAsset: '选择要安装的文件',
    noAssetsFound: '该 Release 没有可用的 .lbpkg 文件',
    fetchAssetsError: '获取文件列表失败：',
    backToReleases: '返回 Release 列表',
    backToRepoUrl: '返回仓库地址',
    backToAssets: '返回文件选择',
    releaseTag: 'Tag: {{tag}}',
    releaseName: '名称: {{name}}',
    publishedAt: '发布于: {{date}}',
    prerelease: '预发布',
    assetSize: '大小: {{size}}',
    confirmInstall: '确认安装',
    installFromGithubDesc: '从 GitHub Release 安装插件',
  },
  market: {
    searchPlaceholder: '搜索插件...',
    searchResults: '搜索到 {{count}} 个插件',
    totalPlugins: '共 {{count}} 个插件',
    noPlugins: '暂无插件',
    noResults: '未找到相关插件',
    loadingMore: '加载更多...',
    loading: '加载中...',
    allLoaded: '已显示全部插件',
    install: '安装',
    installConfirm: '确定要安装插件 "{{name}}" ({{version}}) 吗？',
    downloadComplete: '插件 "{{name}}" 下载完成',
    installFailed: '安装失败，请稍后重试',
    loadFailed: '获取插件列表失败，请稍后重试',
    noDescription: '暂无描述',
    notFound: '插件信息未找到',
    sortBy: '排序方式',
    sort: {
      recentlyAdded: '最近新增',
      recentlyUpdated: '最近更新',
      mostDownloads: '最多下载',
      leastDownloads: '最少下载',
    },
    downloads: '次下载',
    download: '下载',
    repository: '代码仓库',
    downloadFailed: '下载失败',
    noReadme: '该插件没有提供 README 文档',
    description: '描述',
    tags: '标签',
    submissionTitle: '您有插件提交正在审核中： {{name}}',
    submissionApproved: '您的插件提交已通过审核： {{name}}',
    submissionRejected: '您的插件提交已被拒绝： {{name}}',
    clickToRevoke: '撤回',
    revokeSuccess: '撤回成功',
    revokeFailed: '撤回失败',
    submissionDetails: '插件提交详情',
    markAsRead: '已读',
    markAsReadSuccess: '已标记为已读',
    markAsReadFailed: '标记为已读失败',
    filterByComponent: '组件',
    allComponents: '全部组件',
    requestPlugin: '请求插件',
    viewDetails: '查看详情',
  },
  mcp: {
    title: 'MCP',
    createServer: '添加 MCP 服务器',
    editServer: '修改 MCP 服务器',
    deleteServer: '删除 MCP 服务器',
    confirmDeleteServer: '你确定要删除此 MCP 服务器吗？',
    confirmDeleteTitle: '删除 MCP 服务器',
    getServerListError: '获取 MCP 服务器列表失败：',
    serverName: '服务器名称',
    serverMode: '连接模式',
    stdio: 'Stdio模式',
    sse: 'SSE模式',
    noServerInstalled: '暂未配置任何 MCP 服务器',
    serverNameRequired: '服务器名称不能为空',
    commandRequired: '命令不能为空',
    urlRequired: 'URL 不能为空',
    timeoutMustBePositive: '超时时间必须是正数',
    command: '命令',
    args: '参数',
    env: '环境变量',
    url: 'URL地址',
    headers: '请求头',
    timeout: '超时时间',
    addArgument: '添加参数',
    addEnvVar: '添加环境变量',
    addHeader: '添加请求头',
    keyName: '键名',
    value: '值',
    testing: '测试中...',
    connecting: '连接中...',
    testSuccess: '测试成功',
    testFailed: '测试失败：',
    testError: '刷新出错',
    refreshSuccess: '刷新成功',
    refreshFailed: '刷新失败：',
    connectionSuccess: '连接成功',
    connectionFailed: '连接失败，请检查URL',
    connectionFailedStatus: '连接失败',
    toolsFound: '个工具',
    unknownError: '未知错误',
    noToolsFound: '未找到任何工具',
    parseResultFailed: '解析测试结果失败',
    noResultReturned: '测试未返回结果',
    getTaskFailed: '获取任务状态失败',
    noTaskId: '未获取到任务ID',
    deleteSuccess: '删除成功',
    deleteFailed: '删除失败：',
    deleteError: '删除失败：',
    saveSuccess: '保存成功',
    saveError: '保存失败：',
    createSuccess: '创建成功',
    createFailed: '创建失败：',
    createError: '创建失败：',
    loadFailed: '加载失败',
    modifyFailed: '修改失败：',
    toolCount: '工具：{{count}}',
    statusConnected: '已打开',
    statusDisconnected: '未打开',
    statusError: '连接错误',
    statusDisabled: '已禁用',
    loading: '加载中...',
    starCount: '星标：{{count}}',
    install: '安装',
    installFromGithub: '从Github安装MCP服务器',
    add: '添加',
    name: '名称',
    nameRequired: '名称不能为空',
    sseTimeout: 'SSE超时时间',
    sseTimeoutDescription: '用于建立SSE连接的超时时间',
    extraParametersDescription: '额外参数，用于配置MCP服务器的特定行为',
    timeoutMustBeNumber: '超时时间必须是数字',
    timeoutNonNegative: '超时时间不能为负数',
    sseTimeoutMustBeNumber: 'SSE超时时间必须是数字',
    sseTimeoutNonNegative: 'SSE超时时间不能为负数',
    updateSuccess: '更新成功',
    updateFailed: '更新失败：',
  },
  pipelines: {
    title: '流水线',
    description: '流水线定义了对消息事件的处理流程，用于绑定到机器人',
    createPipeline: '创建流水线',
    editPipeline: '编辑流水线',
    chat: '对话',
    configuration: '配置',
    debugChat: '对话调试',
    getPipelineListError: '获取流水线列表失败：',
    daysAgo: '天前',
    today: '今天',
    updateTime: '更新于',
    defaultBadge: '默认',
    sortBy: '排序方式',
    newestCreated: '最新创建',
    earliestCreated: '最早创建',
    recentlyEdited: '最近编辑',
    earliestEdited: '最早编辑',
    basicInfo: '基础信息',
    aiCapabilities: 'AI 能力',
    triggerConditions: '触发条件',
    safetyControls: '安全控制',
    outputProcessing: '输出处理',
    nameRequired: '名称不能为空',
    descriptionRequired: '描述不能为空',
    createSuccess: '创建成功 请编辑流水线详细参数',
    createError: '创建失败：',
    saveSuccess: '保存成功',
    saveError: '保存失败：',
    copySuffix: ' Copy',
    deleteConfirmation:
      '你确定要删除这个流水线吗？已绑定此流水线的机器人将无法使用。',
    defaultPipelineCannotDelete: '默认流水线不可删除',
    deleteSuccess: '删除成功',
    deleteError: '删除失败：',
    copyConfirmTitle: '确认复制',
    copyConfirmation:
      '确定要复制这个流水线吗？复制将创建一个包含完整配置的新流水线。',
    extensions: {
      title: '扩展集成',
      loadError: '加载插件列表失败',
      saveSuccess: '保存成功',
      saveError: '保存失败',
      noPluginsAvailable: '暂无可用插件',
      disabled: '已禁用',
      noPluginsSelected: '未选择任何插件',
      addPlugin: '添加插件',
      selectPlugins: '选择插件',
      pluginsTitle: '插件',
      mcpServersTitle: 'MCP 服务器',
      noMCPServersSelected: '未选择任何 MCP 服务器',
      addMCPServer: '添加 MCP 服务器',
      selectMCPServers: '选择 MCP 服务器',
      toolCount: '{{count}} 个工具',
      noPluginsInstalled: '无已安装的插件',
      noMCPServersConfigured: '无已配置的 MCP 服务器',
      selectAll: '全选',
      enableAllPlugins: '启用所有插件',
      enableAllMCPServers: '启用所有 MCP 服务器',
      allPluginsEnabled: '已启用所有插件',
      allMCPServersEnabled: '已启用所有 MCP 服务器',
    },
    debugDialog: {
      title: '流水线对话',
      selectPipeline: '选择流水线',
      sessionType: '会话类型',
      privateChat: '私聊',
      groupChat: '群聊',
      send: '发送',
      reset: '重置对话',
      inputPlaceholder: '发送 {{type}} 消息...',
      noMessages: '暂无消息',
      userMessage: '用户',
      botMessage: '机器人',
      sendFailed: '发送失败',
      resetSuccess: '对话已重置',
      resetFailed: '重置失败',
      loadMessagesFailed: '加载消息失败',
      loadPipelinesFailed: '加载流水线失败',
      atTips: '提及机器人',
      streaming: '流式传输',
      streamOutput: '流式',
      connected: 'WebSocket已连接',
      disconnected: 'WebSocket未连接',
      connectionError: 'WebSocket连接错误',
      connectionFailed: 'WebSocket连接失败',
      notConnected: 'WebSocket未连接，请稍后重试',
      imageUploadFailed: '图片上传失败',
      reply: '回复',
      replyTo: '回复给',
      showMarkdown: '渲染',
      showRaw: '原文',
    },
  },
  knowledge: {
    title: '知识库',
    createKnowledgeBase: '创建知识库',
    editKnowledgeBase: '编辑知识库',
    selectKnowledgeBase: '选择知识库',
    selectKnowledgeBases: '选择知识库',
    addKnowledgeBase: '添加知识库',
    noKnowledgeBaseSelected: '未选择知识库',
    empty: '无',
    editDocument: '文档',
    description: '配置可用于提升模型回复质量的知识库',
    metadata: '元数据',
    documents: '文档',
    kbNameRequired: '知识库名称不能为空',
    kbDescriptionRequired: '知识库描述不能为空',
    embeddingModelUUIDRequired: '嵌入模型不能为空',
    daysAgo: '天前',
    today: '今天',
    kbName: '知识库名称',
    kbDescription: '知识库描述',
    topK: '召回数量',
    topKRequired: '召回数量不能为空',
    topKMax: '召回数量最大值为 30',
    topKdescription: '召回相关文档块的数量，取值范围为 1-30',
    defaultDescription: '一个知识库',
    embeddingModelUUID: '嵌入模型',
    selectEmbeddingModel: '选择嵌入模型',
    embeddingModelDescription: '用于向量化文本，可在模型配置页面配置',
    updateTime: '更新于',
    cannotChangeEmbeddingModel: '知识库创建后不可修改嵌入模型',
    updateKnowledgeBaseSuccess: '知识库更新成功',
    updateKnowledgeBaseFailed: '知识库更新失败',
    documentsTab: {
      name: '名称',
      status: '状态',
      noResults: '暂无文档',
      dragAndDrop: '拖拽文件到此处或点击上传',
      uploading: '上传中...',
      supportedFormats: '支持 PDF、Word、TXT、Markdown、HTML、ZIP 等文档格式',
      uploadSuccess: '文件上传成功！',
      uploadError: '文件上传失败，请重试',
      uploadingFile: '上传文件中...',
      fileSizeExceeded: '文件大小超过 10MB 限制，请分割成较小的文件后上传',
      actions: '操作',
      delete: '删除文件',
      fileDeleteSuccess: '文件删除成功',
      fileDeleteFailed: '文件删除失败',
      processing: '处理中',
      completed: '完成',
      failed: '失败',
    },
    deleteKnowledgeBaseConfirmation:
      '你确定要删除这个知识库吗？此知识库下的所有文档将被删除。',
    retrieve: '检索测试',
    retrieveTest: '检索测试',
    query: '查询',
    queryPlaceholder: '输入查询内容...',
    distance: '距离',
    content: '内容',
    fileName: '文件名',
    noResults: '暂无结果',
    retrieveError: '检索失败',
    builtIn: '内置',
    external: '外部知识库',
    addExternal: '添加外部知识库',
    createExternalSuccess: '外部知识库创建成功',
    updateExternalSuccess: '外部知识库更新成功',
    deleteExternalSuccess: '外部知识库删除成功',
    retriever: '检索器',
    selectRetriever: '选择一个检索器...',
    retrieverConfiguration: '检索器配置',
    retrieverInstallInfo: '您可以从',
    retrieverMarketLink: '此处安装知识检索器插件',
  },
  register: {
    title: '初始化 LangBot 👋',
    description: '这是您首次启动 LangBot',
    adminAccountNote: '您在此处初始化使用的账号将作为管理员账号',
    register: '注册',
    initWithSpace: '通过 Space 初始化',
    spaceRecommended: '推荐：使用官方提供的稳定模型 API 和云服务',
    spaceInfoTip1: 'Space 提供统一的账户鉴权服务，不会上传您的任何敏感信息。',
    spaceInfoTip2:
      '使用 Space 账户登录可使用 LangBot Models 等云服务，您将会获得一定的免费模型调用额度帮助您快速起步。',
    spaceInfoTip3:
      '登录方式不会影响其他功能，您在任何情况下都可以配置使用其他来源的模型。',
    registerLocal: '注册本地账号',
    registerWithPassword: '通过邮箱密码组合注册',
    initSuccess: '初始化成功 请登录',
    initFailed: '初始化失败：',
  },
  resetPassword: {
    title: '重置密码 🔐',
    description: '输入恢复密钥和新的密码来重置您的账户密码',
    recoveryKey: '恢复密钥',
    recoveryKeyDescription:
      '存储在配置文件`data/config.yaml`的`system.recovery_key`中',
    newPassword: '新密码',
    enterRecoveryKey: '输入恢复密钥',
    enterNewPassword: '输入新密码',
    recoveryKeyRequired: '恢复密钥不能为空',
    newPasswordRequired: '新密码不能为空',
    resetPassword: '重置密码',
    resetting: '重置中...',
    resetSuccess: '密码重置成功，请登录',
    resetFailed: '密码重置失败，请检查邮箱和恢复密钥是否正确',
    backToLogin: '返回登录',
  },
  embedding: {
    description: '管理嵌入模型，用于向量化文本',
    createModel: '创建嵌入模型',
    editModel: '编辑嵌入模型',
    getModelListError: '获取嵌入模型列表失败：',
    embeddingModels: '嵌入模型',
    extraParametersDescription:
      '将在请求时附加到请求体中，如 encoding_format, dimensions 等',
  },
  llm: {
    llmModels: '对话模型',
    description: '管理 LLM 模型，用于对话消息生成',
    extraParametersDescription:
      '将在请求时附加到请求体中，如 max_tokens, temperature, top_p 等',
  },
  version: {
    newVersionAvailable: '有新版本可用',
    viewUpdateGuide: '查看更新方式',
    noReleaseNotes: '暂无更新日志',
  },
  account: {
    settings: '账户设置',
    setPassword: '设置密码',
    passwordSetSuccess: '密码设置成功',
    passwordStatus: '本地密码',
    passwordSet: '已设置',
    passwordNotSet: '未设置',
    passwordSetDescription: '您已设置本地密码，可使用邮箱密码登录',
    spaceStatus: 'Space 账户',
    spaceBound: '已绑定',
    spaceNotBound: '未绑定',
    spaceBoundDescription: '已绑定 Space 账户，可使用官方模型 API 和云服务',
    bindSpace: '绑定 Space 账户',
    bindSpaceDescription: '绑定后可使用官方模型 API 和云服务',
    bindSpaceButton: '绑定',
    bindSpaceConfirmTitle: '确认绑定',
    bindSpaceConfirmDescription: '您即将把本地实例绑定到 Space 账户',
    bindSpaceWarning:
      '绑定后，您的登录邮箱将从 {{localEmail}} 更改为 Space 账户的邮箱。',
    bindSpaceSuccess: 'Space 账户绑定成功',
    bindSpaceFailed: '绑定 Space 账户失败',
    bindSpaceInvalidState: '无效的绑定请求，请从账户设置重新发起',
    setPasswordHint: '设置密码后可使用邮箱密码登录',
    spaceEmailMismatch: 'Space登录账号邮箱与本实例账号邮箱不匹配',
  },
};

export default zhHans;
