# 初始化流程规范

需要初始化的内容划分为以下部分

- 普遍应用需要: 应该在启动时异步初始化，初始化完成后才能开始执行应用。
  - OCR
  - ScreenInfo
- 特定应用需要: 在对应 `Application` 的节点里加载，尽量利用游戏画面加载的节点进行初始化。
  - YOLO模型
  - 应用配置
  - 应用运行记录
  - 图片模板
  - 自动战斗配置
  - 游戏数据配置
- UI需要：同上，在切换到特定页面时才进行加载，如果某页面需要加载大量资源，再额外考虑提前异步初始化。
- 其他：不是很必要，做了比没做有用的初始化，在启动时异步初始化，无需关心结果。
  - github proxy 的更新
  - 特定UI需要的提前初始化

## 普遍应用需要

1. 创建 `ZContext`。
2. 异步初始化 `ZContext.init_async`。
3. 运行应用前等待步骤2初始化完成，或超时退出。
4. 应用运行。

## 特定应用需要

1. 运行应用。
2. 初始化 `Application.handle_init`。
3. 执行业务逻辑。

## UI需要

1. 切换到UI界面。
2. 初始化 `on_interface_shown`。
3. 刷新界面。

## 其他

1. 创建 `ZContext`。
2. 异步初始化 `ZContext.init_others`。