from __future__ import annotations

from typing import TYPE_CHECKING

from one_dragon.base.operation.application.application_config import ApplicationConfig
from one_dragon.base.operation.application.application_factory import ApplicationFactory
from one_dragon.base.operation.application_base import Application
from zzz_od.application.commission_assistant import commission_assistant_const
from zzz_od.application.commission_assistant.commission_assistant_app import (
    CommissionAssistantApp,
)
from zzz_od.application.commission_assistant.commission_assistant_config import (
    CommissionAssistantConfig,
)

if TYPE_CHECKING:
    from zzz_od.context.zzz_context import ZContext


class CommissionAssistantAppFactory(ApplicationFactory):

    def __init__(self, ctx: ZContext):
        ApplicationFactory.__init__(
            self,
            app_id=commission_assistant_const.APP_ID,
            app_name=commission_assistant_const.APP_NAME,
        )
        self.ctx: ZContext = ctx

    def create_application(self, instance_idx: int, group_id: str) -> Application:
        return CommissionAssistantApp(self.ctx)

    def create_config(
        self, instance_idx: int, group_id: str
    ) -> ApplicationConfig:
        return CommissionAssistantConfig(
            instance_idx=instance_idx,
            group_id=group_id,
        )
