package com.luohuo.flex.im.domain.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 修改用户名
 *
 * @author nyh
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SummeryInfoDTO {
    @Schema(description = "用户拥有的徽章id列表")
    List<Long> itemIds;
    @Schema(description = "用户id")
    private Long uid;
    @Schema(description = "是否需要刷新")
    private Boolean needRefresh = Boolean.TRUE;
    @Schema(description = "用户昵称")
    private String name;
	@Schema(description = "性别")
	private Integer sex;
	@Schema(description = "Hula号")
	private String account;
    @Schema(description = "用户头像")
    private String avatar;
    @Schema(description = "归属地")
    private String locPlace;
	@JsonIgnore
	@Schema(description = "微信openId")
	private String openId;
	@JsonIgnore
	@Schema(description = "邮箱")
	private String email;
	@Schema(description = "个人简介")
	private String resume;
	@Schema(description = "用户状态")
	private Long userStateId;
    @Schema(description = "佩戴的徽章id")
    private Long wearingItemId;
	@Schema(description = "用户类型")
	private Integer userType;
	@Schema(description = "最后一次上下线时间")
	private LocalDateTime lastOptTime;

	@Schema(description = "gitee用户标识")
	private String giteeId;

	@Schema(description = "github用户标识")
	private String githubId;

	@Schema(description = "gitcode用户标识")
	private String gitcodeId;

	@Schema(description = "是否绑定gitee")
	private Boolean linkedGitee;

	@Schema(description = "是否绑定github")
	private Boolean linkedGithub;

	@Schema(description = "是否绑定gitcode")
	private Boolean linkedGitcode;

	public static SummeryInfoDTO skip(Long uid) {
        SummeryInfoDTO dto = new SummeryInfoDTO();
        dto.setUid(uid);
        dto.setNeedRefresh(Boolean.FALSE);
        return dto;
    }
}
