<p align="center"><img src="https://github.com/marktext/marktext/raw/develop/static/logo-small.png" alt="MarkText" width="100" height="100"></p>

<h1 align="center">MarkText</h1>

<div align="center">
  <a href="https://twitter.com/intent/tweet?via=marktextme&url=https://github.com/marktext/marktext/&text=What%20do%20you%20want%20to%20say%20to%20app?&hashtags=happyMarkText">
    <img src="https://img.shields.io/twitter/url/https/github.com/marktext/marktext.svg?style=for-the-badge" alt="twitter">
  </a>
</div>
<div align="center">
  <strong>:high_brightness: Editor de Markdown de nova geração :crescent_moon:</strong><br>
  Um editor de markdown simples e elegante em código aberto, com foco em performance e usabilidade.<br>
  <sub>Disponível para Linux, macOS and Windows.</sub>
</div>

<br>

<div align="center">
  <!-- Version -->
  <a href="https://marktext.github.io/website">
    <img src="https://badge.fury.io/gh/jocs%2Fmarktext.svg" alt="website">
  </a>
  <!-- License -->
  <a href="LICENSE">
    <img src="https://img.shields.io/github/license/marktext/marktext.svg" alt="LICENSE">
  </a>
  <!-- Build Status -->
  <a href="https://travis-ci.org/marktext/marktext/">
    <img src="https://travis-ci.org/marktext/marktext.svg?branch=master" alt="build">
  </a>
  <a href="https://ci.appveyor.com/project/marktext/marktext/branch/master">
    <img src="https://ci.appveyor.com/api/projects/status/l4gxgydj0i95hmxg/branch/master?svg=true" alt="build">
  </a>
  <!-- Downloads total -->
  <a href="https://github.com/marktext/marktext/releases">
    <img src="https://img.shields.io/github/downloads/marktext/marktext/total.svg" alt="total download">
  </a>
  <!-- Downloads latest release -->
  <a href="https://github.com/marktext/marktext/releases/latest">
    <img src="https://img.shields.io/github/downloads/marktext/marktext/v0.17.1/total.svg" alt="latest download">
  </a>
  <!-- sponsors -->
  <a href="https://opencollective.com/marktext">
    <img src="https://opencollective.com/marktext/tiers/silver-sponsors/badge.svg?label=SilverSponsors&color=brightgreen" alt="sponsors">
  </a>
</div>

<div align="center">
  <h3>
    <a href="https://github.com/marktext/marktext">
      Site
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#features">
      Recursos
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#download-and-installation">
      Downloads
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#development">
      Desenvolvimento
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#contribution">
      Contribuição
    </a>
  </h3>
</div>

<div align="center">
  <sub>Traduções:</sub>
  <a href="zh_cn.md#readme">
    <span>:cn:</span>
  </a>
  <a href="zh_tw.md#readme">
    <span>:taiwan:</span>
  </a>
  <a href="pl.md#readme">
    <span>:poland:</span>
  </a>
  <a href="ja.md#readme">
    <span>:jp:</span>
  </a>
  <a href="french.md#readme">
    <span>:fr:</span>
  </a>
  <a href="tr.md#readme">
    <span>:tr:</span>
  </a>
  <a href="spanish.md#readme">
    <span>:es:</span>
  </a>
  <a href="pt.md#readme">
    <span>:portugal:</span>
  </a>
  <a href="ko.md#readme">
    <span>:kr:</span>
  </a>
</div>

<div align="center">
  <sub>Um Markdown que tem poder. Feito com ❤︎ por
    <a href="https://github.com/Jocs">Jocs</a> e
    <a href="https://github.com/marktext/marktext/graphs/contributors">
      contribuidores.
    </a>
  </sub>
</div>

<br />

<h2 align="center">Apoie o MarkText</h2>

O MarkText é um projeto com licença MIT (projetos de código aberto), e as suas atualizações sempre estarão disponíveis gratuitamente na página de 'Releases' do GitHub. O MarkText ainda está em desenvolvimento e é inseparável de todos os patrocinadores. Espero que você se junte a esse grupo:

- [Torne-se um apoiador ou patrocinador no Patreon](https://www.patreon.com/ranluo) ou [Doe uma vez](https://github.com/Jocs/sponsor.me)
- [Seja um apoiador ou patrocinador no Open Collective](https://opencollective.com/marktext)

##### Qual é a diferença entre Patreon e Open Collective?

**Patreon**: Os fundos serão patrocinados diretamente para Luo Ran (@jocs) que criou o MarkText e continua a mantê-lo.

**Open Collective**: Todas as despesas são transparentes. Os fundos serão usados para o desenvolvimento e manutenção do MarkText, financiando atividades online e offline e adquirindo outros recursos necessários.
Nomes e logotipos de empresas de todos os patrocinadores (do Patreon e do Open Collective) aparecerão no site oficial do MarkText e no seu arquivo README.md.

**Patrocinadores Especiais**

<a href="https://www.dogedoge.com/">
 <img src="https://www.dogedoge.com/assets/new_logo.min.png" width="100" height="100">
</a>

**Patrocinadores Platinum**

<a href="https://opencollective.com/marktext#platinum-sponsors">
 <img src="https://opencollective.com/marktext/tiers/platinum-sponsors.svg?avatarHeight=36&width=600">
</a>

**Patrocinadores Ouro**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/gold-sponsors.svg?avatarHeight=36&width=600">
</a>

**Patrocinadores Prata**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/silver-sponsors.svg?avatarHeight=36&width=600">
</a>

**Patrocinadores Bronze**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/bronze-sponsors.svg?avatarHeight=36&width=600">
</a>

**Apoiadores**

<a href="https://opencollective.com/marktext#backers">
  <img src="https://opencollective.com/marktext/tiers/backer.svg?avatarHeight=36&width=600">
</a>

## Captura de Tela

![](https://github.com/marktext/marktext/raw/develop/docs/marktext.png?raw=true)

## Recursos

- Visualização em tempo real (WYSIWYG) e uma interface limpa e simples para obter uma experiência de escrita sem distrações.
- Suporta o uso de [CommonMark Spec](https://spec.commonmark.org/0.29/), [GitHub Flavored Markdown Spec](https://github.github.com/gfm/) e suporte seletivo para [Pandoc markdown](https://pandoc.org/MANUAL.html#pandocs-markdown).
- Extensões de Markdown, como expressões matemáticas (KaTeX), front matter e emojis.
- Utilize parágrafos e atalhos de estilos para melhorar sua eficiência de escrita.
- Exporta arquivos **HTML** e **PDF**.
- Vários temas, como: **Cadmium Light**, **Material Dark**, etc.
- Vários modos de edição: **Modo Código**, **Modo Escritor** e **Modo Foco**.
- Cole imagens diretamente.

<h4 align="center">:crescent_moon:Temas:high_brightness:</h4>

| Cadmium Light                                     | Dark                                            |
|:-------------------------------------------------:|:-----------------------------------------------:|
| ![](https://github.com/marktext/marktext/raw/develop/docs/themeImages/cadmium-light.png?raw=true)  | ![](https://github.com/marktext/marktext/raw/develop/docs/themeImages/dark.png?raw=truee)         |
| Graphite Light                                    | Material Dark                                   |
| ![](https://github.com/marktext/marktext/raw/develop/docs/themeImages/graphite-light.png?raw=true) | ![](https://github.com/marktext/marktext/raw/develop/docs/themeImages/materal-dark.png?raw=true) |
| Ulysses Light                                     | One Dark                                        |
| ![](https://github.com/marktext/marktext/raw/develop/docs/themeImages/ulysses-light.png?raw=true)  | ![](https://github.com/marktext/marktext/raw/develop/docs/themeImages/one-dark.png?raw=true)     |

<h4 align="center">:smile_cat:Modos de Edição:dog:</h4>

| Código               | Escritor                 | Foco                |
|:--------------------:|:------------------------:|:-------------------:|
| ![](https://github.com/marktext/marktext/raw/develop/docs/source.gif) | ![](https://github.com/marktext/marktext/raw/develop/docs/typewriter.gif) | ![](https://github.com/marktext/marktext/raw/develop/docs/focus.gif) |

## Por que criar outro editor?

1. Eu adoro escrever. Usei muitos editores de markdown, mas ainda não há nenhum que consiga atender totalmente às minhas necessidades. Não gosto de ser incomodado quando escrevo por algum bug insuportável. **MarkText** usa DOM virtual para renderizar páginas, o que tem os benefícios adicionais de ser altamente eficiente e possui código aberto. Desta forma, qualquer pessoa que adora markdown e escrita pode usar MarkText.
2. Conforme mencionado acima, **MarkText** é totalmente gratuito e de código-fonte aberto e será para sempre. Esperamos que todos os amantes do markdown contribuam com seu próprio código e ajudem a desenvolver o **MarkText**, tornando-o um editor de markdown popular.
3. Existem muitos editores de markdown e todos têm seus próprios méritos, alguns têm recursos que outros não. É difícil satisfazer as necessidades de cada pessoa, mas esperamos que **MarkText** seja capaz de satisfazer cada utilizador de Markdown tanto quanto possível. Embora o último **MarkText** ainda não seja perfeito, vamos tentar fazer o melhor que pudermos.

## Download e Instalação

![platform](https://img.shields.io/static/v1.svg?label=Platform&message=Linux-64%20|%20macOS-64%20|%20Win-32%20|%20Win-64&style=for-the-badge)

| ![](https://raw.githubusercontent.com/wiki/ryanoasis/nerd-fonts/screenshots/v1.0.x/mac-pass-sm.png)                                                                                                  | ![](https://raw.githubusercontent.com/wiki/ryanoasis/nerd-fonts/screenshots/v1.0.x/windows-pass-sm.png)                                                                                                          | ![](https://raw.githubusercontent.com/wiki/ryanoasis/nerd-fonts/screenshots/v1.0.x/linux-pass-sm.png)                                                                                                                        |
|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-x64.dmg.svg)](https://github.com/marktext/marktext/releases/download/v0.17.1/marktext-x64.dmg) | [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-setup.exe.svg)](https://github.com/marktext/marktext/releases/download/v0.17.1/marktext-setup.exe) | [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-x86_64.AppImage.svg)](https://github.com/marktext/marktext/releases/download/v0.17.1/marktext-x86_64.AppImage) |

Quer ver os últimos recursos? Por favor consulte o [Histórico de Mudanças](.github/CHANGELOG.md).

#### macOS

Pode baixar o último `marktext-%version%.dmg` indo à [página de versões](https://github.com/marktext/marktext/releases/latest) ou instale o MarkText usando [**homebrew cask**](https://github.com/caskroom/homebrew-cask) (é necessário ter o [Homebrew](https://brew.sh/) instalado).

```bash
brew install --cask mark-text
```

#### Windows

Instale o MarkText utilizando um gerenciador de instalações (`marktext-setup-%version%.exe`) e escolha para instalar para seu usuário ou em toda a máquina.

Caso não quiser fazer isso, pode instalar usando o [Chocolatey](https://chocolatey.org/). Para usar o Chocolatey você precisa de ter instalado [Chocolatey](https://chocolatey.org/install).

```bash
choco install marktext
```

#### Linux

Siga o [Manual de Instalações do Linux](docs/LINUX.md).

#### Outros

Todo o código-fonte para Linux, macOS and Windows pode ser baixado na [página de versões](https://github.com/marktext/marktext/releases/latest). Se não está a conseguir usar nenhuma versão no seu sistema, por favor abra uma [issue](https://github.com/marktext/marktext/issues).

## Desenvolvimento

Se você deseja fazer sua própria build do **MarkText**, dê uma lida no documento de [instruções de build](docs/dev/BUILD.md).

- [Documentação do Usuário](docs/README.md)
- [Documentação do Desenvolvedor](docs/dev/README.md)

Se você ainda possui alguma dúvida sobre **MarkText**, seja bem vindo para abrir uma issue. Ao fazer isso, use o formato padrão encontrado ao abrir uma 'issue'. Claro, se você enviar um PR diretamente, será muito apreciado.

## Integrações

- [Alfred Workflow](http://www.packal.org/workflow/mark-text): Um fluxo de trabalho para o aplicativo Alfred do macOS: Use "mt" para abrir arquivos/pasta com MarkText.

## Contribuição

MarkText está em pleno desenvolvimento, certifique-se de ler o [guia de Contribuição](CONTRIBUTING.md) antes de fazer uma solicitação de PR. Quer adicionar alguns recursos ao MarkText? Consulte nosso [roadmap](https://github.com/marktext/marktext/projects) and open issues.

## Contribuidores

Obrigado a todas as pessoas que já contribuíram para MarkText[[contribuidores](https://github.com/marktext/marktext/graphs/contributors)]

Um agradecimento especial ao @[Yasujizr](https://github.com/Yasujizr) por desenhar nossa Logo.

<a href="https://github.com/marktext/marktext/graphs/contributors"><img src="https://opencollective.com/marktext/contributors.svg?width=890" /></a>

## Licença

[**MIT**](LICENSE).

[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2Fmarktext%2Fmarktext.svg?type=large)](https://app.fossa.io/projects/git%2Bgithub.com%2Fmarktext%2Fmarktext?ref=badge_large)
