from collections.abc import Iterator
from typing import Any, Never

from ._bound_function import BoundFunction
from ._uobject_children import UFunction

class WrappedMulticastDelegate:
    _signature: UFunction

    def __call__(self, *args: Any, **kwargs: Any) -> Any:  # noqa: D417
        """
        Calls all functions bound to this delegate.

        Args:
            The unreal function's args. This has all the same semantics as calling a
            BoundFunction.
        """

    def __contains__(self, value: BoundFunction) -> bool:
        """
        Checks if a function is already bound to this delegate.

        Args:
            value: The function to search for.
        Returns:
            True if the function is already bound.
        """

    def __init__(self, *args: Any, **kwargs: Any) -> Never: ...
    def __iter__(self) -> Iterator[BoundFunction]:
        """
        Creates an iterator over all functions bound to this delegate.

        Returns:
            An iterator over all functions bound to this delegate.
        """

    def __len__(self) -> int:
        """
        Gets the number of functions which are bound to this delegate.

        Returns:
            The number of bound functions.
        """

    def __new__(cls, *args: Any, **kwargs: Any) -> Never: ...
    def __repr__(self) -> str:
        """
        Gets a string representation of this delegate.

        Returns:
            The string representation.
        """

    def _get_address(self) -> int:
        """
        Gets the address of this delegate, for debugging.

        Returns:
            This delegate's address.
        """

    def add(self, value: BoundFunction) -> None:
        """
        Binds a new function to this delegate.

        This has no effect if the function is already present.

        Args:
            value: The function to bind.
        """

    def clear(self) -> None:
        """Removes all functions bound to this delegate."""

    def discard(self, value: BoundFunction) -> None:
        """
        Removes a function from this delegate if it is present.

        Args:
            value: The function to remove.
        """

    def pop(self) -> BoundFunction:
        """
        Removes an arbitrary function from this delegate.

        Throws a KeyError if the delegate has no bound functions.

        Returns:
            The function which was removed.
        """

    def remove(self, value: BoundFunction) -> None:
        """
        Removes a function from this delegate.

        Throws a KeyError if the function is not present.

        Args:
            value: The function to remove.
        """
