/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemLock;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import com.hbm.tileentity.machine.storage.TileEntityMassStorage;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class BlockMassStorage
extends BlockContainer
implements IBlockMulti,
ILookOverlay,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconSide;
    private static boolean dropInv = true;

    public BlockMassStorage() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconTop = new IIcon[4];
        this.iconSide = new IIcon[4];
        this.iconTop[0] = iconRegister.func_94245_a("hbm:mass_storage_top_iron");
        this.iconSide[0] = iconRegister.func_94245_a("hbm:mass_storage_side_iron");
        this.iconTop[1] = iconRegister.func_94245_a("hbm:mass_storage_top_desh");
        this.iconSide[1] = iconRegister.func_94245_a("hbm:mass_storage_side_desh");
        this.iconTop[2] = iconRegister.func_94245_a("hbm:mass_storage_top");
        this.iconSide[2] = iconRegister.func_94245_a("hbm:mass_storage_side");
        this.iconTop[3] = iconRegister.func_94245_a("hbm:mass_storage_top_wood");
        this.iconSide[3] = iconRegister.func_94245_a("hbm:mass_storage_side_wood");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        int meta = this.rectify(metadata);
        return side == 1 ? this.iconTop[meta] : (side == 0 ? this.iconTop[meta] : this.iconSide[meta]);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMassStorage(this.getCapacity(meta));
    }

    public int getCapacity(int meta) {
        return meta == 3 ? 100 : (meta == 0 ? 10000 : (meta == 1 ? 100000 : (meta == 2 ? 1000000 : 0)));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b() instanceof ItemLock || player.func_70694_bm().func_77973_b() == ModItems.key_kit)) {
            return false;
        }
        if (!player.func_70093_af()) {
            TileEntity entity = world.func_147438_o(x, y, z);
            if (entity instanceof TileEntityMassStorage && ((TileEntityMassStorage)entity).canAccess(player)) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            TileEntityLockableBase lockable;
            ItemStack drop = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
            ISidedInventory inv = (ISidedInventory)world.func_147438_o(x, y, z);
            NBTTagCompound nbt = new NBTTagCompound();
            if (inv != null) {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null) continue;
                    NBTTagCompound slot = new NBTTagCompound();
                    stack.func_77955_b(slot);
                    nbt.func_74782_a("slot" + i, (NBTBase)slot);
                }
            }
            if (inv instanceof TileEntityLockableBase && (lockable = (TileEntityLockableBase)inv).isLocked()) {
                nbt.func_74768_a("lock", lockable.getPins());
                nbt.func_74780_a("lockMod", lockable.getMod());
            }
            if (inv instanceof TileEntityMassStorage && nbt.func_150296_c().size() > 0) {
                TileEntityMassStorage storage = (TileEntityMassStorage)inv;
                nbt.func_74768_a("stack", storage.getStockpile());
            }
            if (!nbt.func_82582_d()) {
                drop.field_77990_d = nbt;
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, drop));
        }
        dropInv = false;
        boolean flag = world.func_147468_f(x, y, z);
        dropInv = true;
        return flag;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        ISidedInventory inv = (ISidedInventory)world.func_147438_o(x, y, z);
        if (inv != null && stack.func_77942_o()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                inv.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("slot" + i)));
            }
            if (inv instanceof TileEntityMassStorage) {
                TileEntityMassStorage storage = (TileEntityMassStorage)inv;
                if (stack.field_77990_d.func_74764_b("lock")) {
                    storage.setPins(stack.field_77990_d.func_74762_e("lock"));
                    storage.setMod(stack.field_77990_d.func_74769_h("lockMod"));
                    storage.lock();
                }
                storage.setStockpile(stack.field_77990_d.func_74762_e("stack"));
            }
        }
        super.func_149689_a(world, x, y, z, player, stack);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (dropInv) {
            ISidedInventory sided = (ISidedInventory)world.func_147438_o(x, y, z);
            Random rand = world.field_73012_v;
            if (sided != null) {
                for (int i1 = 0; i1 < sided.func_70302_i_(); ++i1) {
                    ItemStack itemstack;
                    if (i1 == 1 || (itemstack = sided.func_70301_a(i1)) == null) continue;
                    float f = rand.nextFloat() * 0.8f + 0.1f;
                    float f1 = rand.nextFloat() * 0.8f + 0.1f;
                    float f2 = rand.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.field_77994_a > 0) {
                        int j1 = rand.nextInt(21) + 10;
                        if (j1 > itemstack.field_77994_a) {
                            j1 = itemstack.field_77994_a;
                        }
                        itemstack.field_77994_a -= j1;
                        EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                        if (itemstack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                        }
                        float f3 = 0.05f;
                        entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
                        entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
                        entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
                        world.func_72838_d((Entity)entityitem);
                    }
                }
                world.func_147453_f(x, y, z, block);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public Item func_149650_a(int i, Random rand, int j) {
        return null;
    }

    @Override
    public int getSubCount() {
        return 4;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        boolean full;
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityMassStorage)) {
            return;
        }
        TileEntityMassStorage storage = (TileEntityMassStorage)te;
        ArrayList<String> text = new ArrayList<String>();
        String title = "Empty";
        boolean bl = full = storage.type != null;
        if (full) {
            title = storage.type.func_82833_r();
            text.add(String.format(Locale.US, "%,d", storage.getStockpile()) + " / " + String.format(Locale.US, "%,d", storage.getCapacity()));
            double percent = (double)storage.getStockpile() / (double)storage.getCapacity();
            int charge = (int)Math.floor(percent * 10000.0);
            int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
            text.add("&[" + color + "&]" + (double)charge / 100.0 + "%");
        }
        ILookOverlay.printGeneric(event, title, full ? 0xFFFF00 : 65535, full ? 0x404000 : 16448, text);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        if (!stack.func_77942_o()) {
            return;
        }
        ItemStack type = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("slot1"));
        if (type != null) {
            list.add(EnumChatFormatting.GOLD + type.func_82833_r());
            list.add(String.format(Locale.US, "%,d", stack.field_77990_d.func_74762_e("stack")) + " / " + String.format(Locale.US, "%,d", this.getCapacity(stack.func_77960_j())));
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return ((TileEntityMassStorage)world.func_147438_o((int)x, (int)y, (int)z)).redstone;
    }
}

