/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.rail;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.rail.IRailNTM;
import com.hbm.entity.train.EntityRailCarBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.ParticleUtil;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockRailWaypointSystem
extends BlockDummyable
implements IRailNTM {
    public List<RailDef> railDefs = new ArrayList<RailDef>();

    public BlockRailWaypointSystem(Material mat) {
        super(mat);
    }

    public boolean canCross(World world, int x, int y, int z, Vec3 from, Vec3 to, RailDef def) {
        return true;
    }

    @Override
    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    @Override
    public Vec3 getSnappingPos(World world, int x, int y, int z, double trainX, double trainY, double trainZ) {
        return this.snapAndMove(world, x, y, z, trainX, trainY, trainZ, 0.0, 0.0, 0.0, 0.0, new IRailNTM.RailContext());
    }

    @Override
    public Vec3 getTravelLocation(World world, int x, int y, int z, double trainX, double trainY, double trainZ, double motionX, double motionY, double motionZ, double speed, IRailNTM.RailContext info, IRailNTM.MoveContext context) {
        return this.snapAndMove(world, x, y, z, trainX, trainY, trainZ, motionX, motionY, motionZ, speed, info);
    }

    public Vec3 snapAndMove(World world, int x, int y, int z, double trainX, double trainY, double trainZ, double motionX, double motionY, double motionZ, double speed, IRailNTM.RailContext info) {
        int i;
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        }
        int cX = pos[0];
        int cY = pos[1];
        int cZ = pos[2];
        int meta = world.func_72805_g(cX, cY, cZ);
        double moveAngle = Math.atan2(motionX, motionZ) * 180.0 / Math.PI + 90.0;
        Vec3 trainPos = Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        Vec3 train = Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        Vec3 core = Vec3.func_72443_a((double)((double)cX + 0.5), (double)cY, (double)((double)cZ + 0.5));
        ArrayList links = new ArrayList();
        for (RailDef def : this.railDefs) {
            ArrayList<Tuple.Pair<Vec3[], RailDef>> linkList = new ArrayList<Tuple.Pair<Vec3[], RailDef>>();
            links.add(linkList);
            for (int i2 = 0; i2 < def.nodes.size() - 1; ++i2) {
                Vec3 vec1 = this.getPositionFromNode(world, x, y, z, core, def.nodes.get(i2), meta);
                Vec3 vec2 = this.getPositionFromNode(world, x, y, z, core, def.nodes.get(i2 + 1), meta);
                ParticleUtil.spawnDroneLine(world, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec2.field_72450_a - vec1.field_72450_a, vec2.field_72448_b - vec1.field_72448_b, vec2.field_72449_c - vec1.field_72449_c, 0xFF0000);
                linkList.add(new Tuple.Pair<Vec3[], RailDef>(new Vec3[]{vec1, vec2}, def));
            }
        }
        Tuple.Pair closest = null;
        Vec3 startingPos = null;
        List cDef = null;
        double angularDiff = 0.0;
        double linkAngle = 0.0;
        double dist = Double.MAX_VALUE;
        boolean d = true;
        for (List list : links) {
            for (Tuple.Pair link : list) {
                Vec3[] array = (Vec3[])link.getKey();
                Vec3 point = this.getClosestPointOnLink(array[0], array[1], train);
                if (point == null) continue;
                Vec3 delta = point.func_72444_a(train);
                double length = delta.func_72433_c();
                if (!this.canCross(world, cX, cY, cZ, trainPos, point, (RailDef)link.getValue())) continue;
                linkAngle = EntityRailCarBase.generateYaw(array[1], array[0]);
                angularDiff = BobMathUtil.angularDifference(linkAngle, -moveAngle);
                if (angularDiff < -180.0) {
                    angularDiff += 180.0;
                    linkAngle += 180.0;
                    d = false;
                }
                if (angularDiff > 0.0) {
                    angularDiff -= 180.0;
                    linkAngle -= 180.0;
                    d = false;
                }
                if (!(length < dist)) continue;
                closest = link;
                startingPos = point;
                cDef = list;
                dist = length;
            }
        }
        if (closest == null) {
            return Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        }
        double distRemaining = speed;
        boolean engaged = false;
        Vec3 currentPos = startingPos;
        int n = i = d ? 0 : cDef.size() - 1;
        while (d ? i < cDef.size() : i >= 0) {
            block14: {
                Vec3[] array;
                Tuple.Pair link;
                block13: {
                    link = (Tuple.Pair)cDef.get(i);
                    array = (Vec3[])link.getKey();
                    if (engaged) break block13;
                    if (link != closest) break block14;
                    engaged = true;
                }
                Vec3 nextNode = array[d ? 1 : 0];
                Vec3 delta = nextNode.func_72444_a(currentPos);
                if (!this.canCross(world, cX, cY, cZ, currentPos, nextNode, (RailDef)link.getValue())) break;
                double len = delta.func_72433_c();
                if (len >= distRemaining) {
                    info.overshoot = 0.0;
                    double newYaw = EntityRailCarBase.generateYaw(nextNode, currentPos);
                    info.yaw = Math.abs(BobMathUtil.angularDifference(newYaw, moveAngle)) < 45.0 ? (float)newYaw : (float)moveAngle;
                    delta.func_72432_b();
                    return Vec3.func_72443_a((double)(currentPos.field_72450_a - delta.field_72450_a * distRemaining / len), (double)(currentPos.field_72448_b - delta.field_72448_b * distRemaining / len), (double)(currentPos.field_72449_c - delta.field_72449_c * distRemaining / len));
                }
                distRemaining -= len;
                currentPos = nextNode;
            }
            i += d ? 1 : -1;
        }
        info.overshoot = distRemaining;
        info.pos = new BlockPos(currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c);
        return currentPos;
    }

    public Vec3 getClosestPointOnLink(Vec3 pointA, Vec3 pointB, Vec3 pointP) {
        Vec3 ap = Vec3.func_72443_a((double)(pointP.field_72450_a - pointA.field_72450_a), (double)0.0, (double)(pointP.field_72449_c - pointA.field_72449_c));
        Vec3 ab = Vec3.func_72443_a((double)(pointB.field_72450_a - pointA.field_72450_a), (double)0.0, (double)(pointB.field_72449_c - pointA.field_72449_c));
        double dotProd = ap.field_72450_a * ab.field_72450_a + ap.field_72449_c * ab.field_72449_c;
        double magAB = ab.field_72450_a * ab.field_72450_a + ab.field_72449_c * ab.field_72449_c;
        double dist = dotProd / magAB;
        if (dist < 0.0) {
            return pointA;
        }
        if (dist > 1.0) {
            return pointB;
        }
        if (dist < 0.0 || dist > 1.0) {
            return null;
        }
        return Vec3.func_72443_a((double)(pointA.field_72450_a + ab.field_72450_a * dist), (double)(pointA.field_72448_b + (pointB.field_72448_b - pointA.field_72448_b) * dist), (double)(pointA.field_72449_c + ab.field_72449_c * dist));
    }

    public Vec3 getPositionFromNode(World world, int x, int y, int z, Vec3 core, Vec3 node, int meta) {
        float rotation = 0.0f;
        if (meta == 12) {
            rotation = 1.5707964f;
        }
        if (meta == 14) {
            rotation = (float)Math.PI;
        }
        if (meta == 13) {
            rotation = 4.712389f;
        }
        Vec3 copy = Vec3.func_72443_a((double)node.field_72450_a, (double)node.field_72448_b, (double)node.field_72449_c);
        copy.func_72442_b(rotation);
        return core.func_72441_c(copy.field_72450_a, copy.field_72448_b, copy.field_72449_c);
    }

    public class RailDef {
        String name;
        public List<Vec3> nodes = new ArrayList<Vec3>();

        public RailDef(String name) {
            this.name = name;
        }
    }
}

