/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.energymk2.IBatteryItem;
import com.hbm.items.tool.ItemSwordAbility;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemSwordAbilityPower
extends ItemSwordAbility
implements IBatteryItem {
    public long maxPower = 1L;
    public long chargeRate;
    public long consumption;

    public ItemSwordAbilityPower(float damage, double movement, Item.ToolMaterial material, long maxPower, long chargeRate, long consumption) {
        super(damage, movement, material);
        this.maxPower = maxPower;
        this.chargeRate = chargeRate;
        this.consumption = consumption;
        this.func_77656_e(1);
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemSwordAbilityPower) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") + i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemSwordAbilityPower) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemSwordAbilityPower) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") - i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", this.maxPower - i);
            }
            if (stack.field_77990_d.func_74763_f("charge") < 0L) {
                stack.field_77990_d.func_74772_a("charge", 0L);
            }
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSwordAbilityPower) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74763_f("charge");
            }
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", ((ItemSwordAbilityPower)stack.func_77973_b()).maxPower);
            return stack.field_77990_d.func_74763_f("charge");
        }
        return 0L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add("Charge: " + BobMathUtil.getShortNumber(this.getCharge(stack)) + " / " + BobMathUtil.getShortNumber(this.maxPower));
        super.func_77624_a(stack, player, list, ext);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCharge(stack) < this.maxPower;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.maxPower;
    }

    @Override
    protected boolean canOperate(ItemStack stack) {
        return this.getCharge(stack) >= this.consumption;
    }

    @Override
    public long getMaxCharge(ItemStack stack) {
        return this.maxPower;
    }

    @Override
    public long getChargeRate(ItemStack stack) {
        return this.chargeRate;
    }

    @Override
    public long getDischargeRate(ItemStack stack) {
        return 0L;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.dischargeBattery(stack, (long)damage * this.consumption);
    }

    public boolean func_77645_m() {
        return true;
    }
}

