/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IHeatSource;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.BlockDummyable;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.EntityProcessorStandard;
import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.TomSaveData;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeatBoiler
extends TileEntityLoadedBase
implements IBufPacketReceiver,
IFluidStandardTransceiver,
IConfigurableMachine,
IFluidCopiable {
    public int heat;
    public FluidTank[] tanks = new FluidTank[2];
    public boolean isOn;
    public boolean hasExploded = false;
    private AudioWrapper audio;
    private int audioTime;
    public static int maxHeat = 3200000;
    public static double diffusion = 0.1;
    public static boolean canExplode = true;
    ByteBuf buf;
    AxisAlignedBB bb = null;

    public TileEntityHeatBoiler() {
        this.tanks[0] = new FluidTank(Fluids.WATER, 16000);
        this.tanks[1] = new FluidTank(Fluids.STEAM, 1600000);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.buf != null) {
                this.buf.release();
            }
            this.buf = Unpooled.buffer();
            this.buf.writeBoolean(this.hasExploded);
            if (!this.hasExploded) {
                this.setupTanks();
                this.updateConnections();
                this.tryPullHeat();
                int lastHeat = this.heat;
                int light = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (light > 7 && (double)TomSaveData.forWorld((World)this.field_145850_b).fire > 1.0E-5) {
                    this.heat = (int)((double)this.heat + (double)(maxHeat - this.heat) * 5.0E-6);
                }
                this.buf.writeInt(lastHeat);
                this.tanks[0].serialize(this.buf);
                this.isOn = false;
                this.tryConvert();
                this.tanks[1].serialize(this.buf);
                if (this.tanks[1].getFill() > 0) {
                    this.sendFluid();
                }
            }
            this.buf.writeBoolean(this.muffled);
            this.buf.writeBoolean(this.isOn);
            this.networkPackNT(25);
        } else {
            if (this.isOn) {
                this.audioTime = 20;
            }
            if (this.audioTime > 0) {
                --this.audioTime;
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updateVolume(this.getVolume(1.0f));
                this.audio.keepAlive();
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.boiler", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.125f, 10.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBytes(this.buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.hasExploded = buf.readBoolean();
        if (!this.hasExploded) {
            this.heat = buf.readInt();
            this.tanks[0].deserialize(buf);
            this.tanks[1].deserialize(buf);
            this.muffled = buf.readBoolean();
            this.isOn = buf.readBoolean();
        }
    }

    protected void tryPullHeat() {
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * diffusion);
                diff = Math.min(diff, maxHeat - this.heat);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > maxHeat) {
                    this.heat = maxHeat;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    protected void setupTanks() {
        FT_Heatable trait;
        if (this.tanks[0].getTankType().hasTrait(FT_Heatable.class) && (trait = this.tanks[0].getTankType().getTrait(FT_Heatable.class)).getEfficiency(FT_Heatable.HeatingType.BOILER) > 0.0) {
            FT_Heatable.HeatingStep entry = trait.getFirstStep();
            this.tanks[1].setTankType(entry.typeProduced);
            this.tanks[1].changeTankSize(this.tanks[0].getMaxFill() * entry.amountProduced / entry.amountReq);
            return;
        }
        this.tanks[0].setTankType(Fluids.NONE);
        this.tanks[1].setTankType(Fluids.NONE);
    }

    protected void tryConvert() {
        FT_Heatable trait;
        if (this.tanks[0].getTankType().hasTrait(FT_Heatable.class) && (trait = this.tanks[0].getTankType().getTrait(FT_Heatable.class)).getEfficiency(FT_Heatable.HeatingType.BOILER) > 0.0) {
            FT_Heatable.HeatingStep entry = trait.getFirstStep();
            int inputOps = this.tanks[0].getFill() / entry.amountReq;
            int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / entry.amountProduced;
            int heatOps = this.heat / entry.heatReq;
            int ops = Math.min(inputOps, Math.min(outputOps, heatOps));
            this.tanks[0].setFill(this.tanks[0].getFill() - entry.amountReq * ops);
            this.tanks[1].setFill(this.tanks[1].getFill() + entry.amountProduced * ops);
            this.heat -= entry.heatReq * ops;
            if (ops > 0 && this.field_145850_b.field_73012_v.nextInt(400) == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, "hbm:block.boilerGroan", 0.5f, 1.0f);
            }
            if (ops > 0) {
                this.isOn = true;
            }
            if (outputOps == 0 && canExplode) {
                this.hasExploded = true;
                BlockDummyable.safeRem = true;
                for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
                    for (int y = this.field_145848_d + 2; y <= this.field_145848_d + 3; ++y) {
                        for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                            this.field_145850_b.func_147468_f(x, y, z);
                        }
                    }
                }
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                ExplosionVNT xnt = new ExplosionVNT(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d + 2, (double)this.field_145849_e + 0.5, 5.0f);
                xnt.setEntityProcessor(new EntityProcessorStandard().withRangeMod(3.0f));
                xnt.setPlayerProcessor(new PlayerProcessorStandard());
                xnt.setSFX(new ExplosionEffectStandard());
                xnt.explode();
                BlockDummyable.safeRem = false;
            }
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private void sendFluid() {
        for (DirPos pos : this.getConPos()) {
            this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir().getOpposite());
        }
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e, Library.POS_Y)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.heat = nbt.func_74762_e("heat");
        this.hasExploded = nbt.func_74767_n("exploded");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74757_a("exploded", this.hasExploded);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getConfigName() {
        return "boiler";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxHeat = IConfigurableMachine.grab(obj, "I:maxHeat", maxHeat);
        diffusion = IConfigurableMachine.grab(obj, "D:diffusion", diffusion);
        canExplode = IConfigurableMachine.grab(obj, "B:canExplode", canExplode);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:maxHeat").value((long)maxHeat);
        writer.name("D:diffusion").value(diffusion);
        writer.name("B:canExplode").value(canExplode);
    }
}

