/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.albion;

import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerPAQuadrupole;
import com.hbm.inventory.gui.GUIPAQuadrupole;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemPACoil;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.albion.IParticleUser;
import com.hbm.tileentity.machine.albion.TileEntityCooledBase;
import com.hbm.tileentity.machine.albion.TileEntityPASource;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityPAQuadrupole
extends TileEntityCooledBase
implements IGUIProvider,
IParticleUser,
SimpleComponent,
CompatHandler.OCComponent {
    public static final long usage = 100000L;
    public static final int focusGain = 100;
    AxisAlignedBB bb = null;

    public TileEntityPAQuadrupole() {
        super(2);
    }

    @Override
    public long getMaxPower() {
        return 2500000L;
    }

    @Override
    public String getName() {
        return "container.paQuadrupole";
    }

    @Override
    public boolean canParticleEnter(TileEntityPASource.Particle particle, ForgeDirection dir, int x, int y, int z) {
        ForgeDirection beamlineDir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.DOWN);
        BlockPos input = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e).offset(beamlineDir, -1);
        return input.compare(x, y, z) && beamlineDir == dir;
    }

    @Override
    public void onEnter(TileEntityPASource.Particle particle, ForgeDirection dir) {
        ItemPACoil.EnumCoilType type = null;
        int mult = 1;
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.pa_coil) {
            type = (ItemPACoil.EnumCoilType)((Object)EnumUtil.grabEnumSafely(ItemPACoil.EnumCoilType.class, this.slots[1].func_77960_j()));
            int n = mult = type.quadMin > particle.momentum ? 10 : 1;
        }
        if (!this.isCool()) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOCOOL);
        }
        if (this.power < 100000L * (long)mult) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOPOWER);
        }
        if (type == null) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOCOIL);
        }
        if (type != null && type.quadMax < particle.momentum) {
            particle.crash(TileEntityPASource.PAState.CRASH_OVERSPEED);
        }
        if (particle.invalid) {
            return;
        }
        particle.addDistance(3);
        particle.focus(100);
        this.power -= 100000L * (long)mult;
    }

    @Override
    public BlockPos getExitPos(TileEntityPASource.Particle particle) {
        ForgeDirection beamlineDir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.DOWN);
        return new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e).offset(beamlineDir, 2);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
        }
        super.func_145845_h();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite())};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPAQuadrupole(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPAQuadrupole(player.field_71071_by, this);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_pa_quad";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoolant(Context context, Arguments args) {
        return new Object[]{this.coolantTanks[0].getFill(), this.coolantTanks[0].getMaxFill(), this.coolantTanks[1].getFill(), this.coolantTanks[1].getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower(), this.coolantTanks[0].getFill(), this.coolantTanks[0].getMaxFill(), this.coolantTanks[1].getFill(), this.coolantTanks[1].getMaxFill()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getEnergyInfo", "getCoolant", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "getCoolant": {
                return this.getCoolant(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

