/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnegative;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class BobMathUtil {
    public static int min(int ... nums) {
        int smallest = Integer.MAX_VALUE;
        for (int num : nums) {
            if (num >= smallest) continue;
            smallest = num;
        }
        return smallest;
    }

    public static int max(int ... nums) {
        int largest = Integer.MIN_VALUE;
        for (int num : nums) {
            if (num <= largest) continue;
            largest = num;
        }
        return largest;
    }

    public static long min(long ... nums) {
        long smallest = Long.MAX_VALUE;
        for (long num : nums) {
            if (num >= smallest) continue;
            smallest = num;
        }
        return smallest;
    }

    public static long max(long ... nums) {
        long largest = Long.MIN_VALUE;
        for (long num : nums) {
            if (num <= largest) continue;
            largest = num;
        }
        return largest;
    }

    public static float min(float ... nums) {
        float smallest = Float.MAX_VALUE;
        for (float num : nums) {
            if (!(num < smallest)) continue;
            smallest = num;
        }
        return smallest;
    }

    public static float max(float ... nums) {
        float largest = Float.MIN_VALUE;
        for (float num : nums) {
            if (!(num > largest)) continue;
            largest = num;
        }
        return largest;
    }

    public static double min(double ... nums) {
        double smallest = Double.MAX_VALUE;
        for (double num : nums) {
            if (!(num < smallest)) continue;
            smallest = num;
        }
        return smallest;
    }

    public static double max(double ... nums) {
        double largest = Double.MIN_VALUE;
        for (double num : nums) {
            if (!(num > largest)) continue;
            largest = num;
        }
        return largest;
    }

    public static double safeClamp(double val, double min, double max) {
        if ((val = MathHelper.func_151237_a((double)val, (double)min, (double)max)) == Double.NaN) {
            val = (min + max) / 2.0;
        }
        return val;
    }

    public static Vec3 interpVec(Vec3 vec1, Vec3 vec2, float interp) {
        return Vec3.func_72443_a((double)BobMathUtil.interp(vec1.field_72450_a, vec2.field_72450_a, interp), (double)BobMathUtil.interp(vec1.field_72448_b, vec2.field_72448_b, interp), (double)BobMathUtil.interp(vec1.field_72449_c, vec2.field_72449_c, interp));
    }

    public static double interp(double x, double y, float interp) {
        return x + (y - x) * (double)interp;
    }

    public static double interp(double x, double y, double interp) {
        return x + (y - x) * interp;
    }

    public static double getAngleFrom2DVecs(double x1, double z1, double x2, double z2) {
        double upper = x1 * x2 + z1 * z2;
        double lower = Math.sqrt(x1 * x1 + z1 * z1) * Math.sqrt(x2 * x2 + z2 * z2);
        double result = Math.toDegrees(Math.cos(upper / lower));
        if (result >= 180.0) {
            result -= 180.0;
        }
        return result;
    }

    public static double getCrossAngle(Vec3 vel, Vec3 rel) {
        vel.func_72432_b();
        rel.func_72432_b();
        double vecProd = rel.field_72450_a * vel.field_72450_a + rel.field_72448_b * vel.field_72448_b + rel.field_72449_c * vel.field_72449_c;
        double bot = rel.func_72433_c() * vel.func_72433_c();
        double angle = Math.acos(vecProd / bot) * 180.0 / Math.PI;
        if (angle >= 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    public static float remap(float num, float min1, float max1, float min2, float max2) {
        return (num - min1) / (max1 - min1) * (max2 - min2) + min2;
    }

    public static float remap01(float num, float min1, float max1) {
        return (num - min1) / (max1 - min1);
    }

    public static float remap01_clamp(float num, float min1, float max1) {
        return MathHelper.func_76131_a((float)((num - min1) / (max1 - min1)), (float)0.0f, (float)1.0f);
    }

    public static ForgeDirection[] getShuffledDirs() {
        ForgeDirection[] dirs = new ForgeDirection[6];
        ArrayList indices = new ArrayList(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(3);
                this.add(4);
                this.add(5);
            }
        };
        Collections.shuffle(indices);
        for (int i = 0; i < 6; ++i) {
            dirs[i] = ForgeDirection.getOrientation((int)((Integer)indices.get(i)));
        }
        return dirs;
    }

    public static String toPercentage(float amount, float total) {
        return NumberFormat.getPercentInstance().format(amount / total);
    }

    public static String[] ticksToDate(long ticks) {
        int tickDay = 48000;
        int tickYear = tickDay * 100;
        String[] dateOut = new String[3];
        long year = Math.floorDiv(ticks, (long)tickYear);
        byte day = (byte)Math.floorDiv(ticks - (long)tickYear * year, (long)tickDay);
        float time = ticks - ((long)tickYear * year + (long)(tickDay * day));
        time = (float)BobMathUtil.convertScale(time, 0.0, tickDay, 0.0, 10.0);
        dateOut[0] = String.valueOf(year);
        dateOut[1] = String.valueOf(day);
        dateOut[2] = String.valueOf(time);
        return dateOut;
    }

    public static double convertScale(double toScale, double oldMin, double oldMax, double newMin, double newMax) {
        double prevRange = oldMax - oldMin;
        double newRange = newMax - newMin;
        return (toScale - oldMin) * newRange / prevRange + newMin;
    }

    public static double roundDecimal(double num, @Nonnegative int digits) {
        if (digits < 0) {
            throw new IllegalArgumentException("Attempted negative number in non-negative field! Attempted value: " + digits);
        }
        return new BigDecimal(num).setScale(digits, RoundingMode.HALF_UP).doubleValue();
    }

    public static String format(int amount) {
        return String.format(Locale.US, "%,d", amount);
    }

    public static String format(long amount) {
        return String.format(Locale.US, "%,d", amount);
    }

    public static boolean getBlink() {
        return System.currentTimeMillis() % 1000L < 500L;
    }

    public static String getShortNumber(long l) {
        if ((double)l >= Math.pow(10.0, 18.0)) {
            double res = (double)l / Math.pow(10.0, 18.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "E";
        }
        if ((double)l >= Math.pow(10.0, 15.0)) {
            double res = (double)l / Math.pow(10.0, 15.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "P";
        }
        if ((double)l >= Math.pow(10.0, 12.0)) {
            double res = (double)l / Math.pow(10.0, 12.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "T";
        }
        if ((double)l >= Math.pow(10.0, 9.0)) {
            double res = (double)l / Math.pow(10.0, 9.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "G";
        }
        if ((double)l >= Math.pow(10.0, 6.0)) {
            double res = (double)l / Math.pow(10.0, 6.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "M";
        }
        if ((double)l >= Math.pow(10.0, 3.0)) {
            double res = (double)l / Math.pow(10.0, 3.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "k";
        }
        return Long.toString(l);
    }

    public static double squirt(double x) {
        return Math.sqrt(x + 1.0 / ((x + 2.0) * (x + 2.0))) - 1.0 / (x + 2.0);
    }

    public static void setPi(double pi) {
        Field field = ReflectionHelper.findField(Math.class, (String[])new String[]{"PI"});
        try {
            field.setDouble(null, pi);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double angularDifference(double alpha, double beta) {
        double delta = (beta - alpha + 180.0) % 360.0 - 180.0;
        return delta < -180.0 ? delta + 360.0 : delta;
    }

    public static int[] intCollectionToArray(Collection<Integer> in) {
        return BobMathUtil.intCollectionToArray(in, i -> (Integer)i);
    }

    public static int[] intCollectionToArray(Collection<Integer> in, ToIntFunction<? super Object> mapper) {
        return Arrays.stream(in.toArray()).mapToInt(mapper).toArray();
    }

    public static int[] collectionToIntArray(Collection<? extends Object> in, ToIntFunction<? super Object> mapper) {
        return Arrays.stream(in.toArray()).mapToInt(mapper).toArray();
    }

    public static void shuffleIntArray(int[] array) {
        Random rand = new Random();
        for (int i = array.length - 1; i > 0; --i) {
            int r = rand.nextInt(i + 1);
            int temp = array[r];
            array[r] = array[i];
            array[i] = temp;
        }
    }

    public static void reverseIntArray(int[] array) {
        int len = array.length;
        for (int i = 0; i < len / 2; ++i) {
            int temp = array[i];
            array[i] = array[len - 1 - i];
            array[len - 1 - i] = temp;
        }
    }

    public static double sps(double x) {
        return Math.sin(1.5707963267948966 * Math.cos(x));
    }

    public static double sws(double x, double squarination) {
        double s = Math.sin(x);
        return Math.pow(Math.abs(s), 2.0 - squarination) / s;
    }
}

