/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.WorldEvent;

public class OreLayer3D {
    public static int counter = 0;
    public int id;
    long lastSeed;
    NoiseGeneratorPerlin noiseX;
    NoiseGeneratorPerlin noiseY;
    NoiseGeneratorPerlin noiseZ;
    double[][] cacheX;
    double[][] cacheZ;
    double scaleH;
    double scaleV;
    double threshold;
    Block block;
    int meta;
    int dim = 0;
    Map<Integer, Set<ChunkCoordIntPair>> alreadyDecorated = new HashMap<Integer, Set<ChunkCoordIntPair>>();

    public OreLayer3D(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.id = counter++;
    }

    public OreLayer3D setDimension(int dim) {
        this.dim = dim;
        return this;
    }

    public OreLayer3D setScaleH(double scale) {
        this.scaleH = scale;
        return this;
    }

    public OreLayer3D setScaleV(double scale) {
        this.scaleV = scale;
        return this;
    }

    public OreLayer3D setThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.world;
        int cx = event.chunkX;
        int cz = event.chunkZ;
        if (world.field_73011_w == null || world.field_73011_w.field_76574_g != this.dim) {
            return;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(cx, cz);
        Set decoratedChunks = this.alreadyDecorated.computeIfAbsent(world.field_73011_w.field_76574_g, n -> new HashSet());
        if (decoratedChunks.contains(chunkPos)) {
            return;
        }
        decoratedChunks.add(chunkPos);
        if (this.noiseX == null || world.func_72905_C() != this.lastSeed) {
            this.noiseX = new NoiseGeneratorPerlin(new Random(world.func_72905_C() + 101L + (long)this.id), 4);
            this.noiseY = new NoiseGeneratorPerlin(new Random(world.func_72905_C() + 102L + (long)this.id), 4);
            this.noiseZ = new NoiseGeneratorPerlin(new Random(world.func_72905_C() + 103L + (long)this.id), 4);
            this.cacheX = new double[16][65];
            this.cacheZ = new double[16][65];
            this.lastSeed = world.func_72905_C();
        }
        for (int o = 0; o < 16; ++o) {
            for (int y = 64; y > 5; --y) {
                this.cacheX[o][y] = this.noiseX.func_151601_a((double)y * this.scaleV, (double)(cz + 8 + o) * this.scaleH);
                this.cacheZ[o][y] = this.noiseZ.func_151601_a((double)(cx + 8 + o) * this.scaleH, (double)y * this.scaleV);
            }
        }
        for (int ox = 0; ox < 16; ++ox) {
            int x = cx + 8 + ox;
            for (int oz = 0; oz < 16; ++oz) {
                int z = cz + 8 + oz;
                double ny = this.noiseY.func_151601_a((double)x * this.scaleH, (double)z * this.scaleH);
                for (int y = 64; y > 5; --y) {
                    Block target;
                    double nx = this.cacheX[oz][y];
                    double nz = this.cacheX[ox][y];
                    if (!(nx * ny * nz > this.threshold) || !(target = world.func_147439_a(x, y, z)).func_149721_r() || !target.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) continue;
                    world.func_147465_d(x, y, z, this.block, this.meta, 2);
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.alreadyDecorated.put(event.world.field_73011_w.field_76574_g, new HashSet());
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.alreadyDecorated.remove(event.world.field_73011_w.field_76574_g);
    }
}

