/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ILookOverlay;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.EnumUtil;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.world.gen.nbt.INBTBlockTransformable;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class FluidPump
extends BlockContainer
implements INBTBlockTransformable,
ILookOverlay,
IGUIProvider {
    public FluidPump(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFluidPump();
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        if (!player.func_70093_af()) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
                IItemFluidIdentifier id = (IItemFluidIdentifier)player.func_70694_bm().func_77973_b();
                FluidType type = id.getType(world, x, y, z, player.func_70694_bm());
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile instanceof TileEntityFluidPump) {
                    if (!world.field_72995_K) {
                        TileEntityFluidPump pump = (TileEntityFluidPump)tile;
                        pump.tank[0].setTankType(type);
                        pump.func_70296_d();
                        player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
                    }
                    return true;
                }
            }
            if (world.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPump((TileEntityFluidPump)world.func_147438_o(x, y, z));
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityFluidPump)) {
            return;
        }
        TileEntityFluidPump pump = (TileEntityFluidPump)tile;
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + pump.tank[0].getTankType().getLocalizedName() + " (" + pump.tank[0].getPressure() + " PU): " + BobMathUtil.format(pump.bufferSize) + "mB/t" + EnumChatFormatting.RED + " ->");
        text.add("Priority: " + EnumChatFormatting.YELLOW + pump.priority.name());
        if (pump.tank[0].getFill() > 0) {
            text.add(BobMathUtil.format(pump.tank[0].getFill()) + "mB buffered");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public int transformMeta(int meta, int coordBaseMode) {
        return INBTBlockTransformable.transformMetaDeco(meta, coordBaseMode);
    }

    @SideOnly(value=Side.CLIENT)
    public static class GUIPump
    extends GuiScreen {
        protected final TileEntityFluidPump pump;
        private GuiTextField textPlacementPriority;
        private GuiButton buttonPressure;
        private GuiButton buttonPriority;
        private int pressure;
        private int priority;

        public GUIPump(TileEntityFluidPump pump) {
            this.pump = pump;
            this.pressure = pump.tank[0].getPressure();
            this.priority = pump.priority.ordinal();
        }

        public void func_73866_w_() {
            Keyboard.enableRepeatEvents((boolean)true);
            this.textPlacementPriority = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 100, 90, 20);
            this.textPlacementPriority.func_146180_a("" + this.pump.bufferSize);
            this.textPlacementPriority.func_146203_f(5);
            this.buttonPressure = new GuiButton(0, this.field_146294_l / 2 - 50, 100, 90, 20, this.pressure + " PU");
            this.buttonPriority = new GuiButton(1, this.field_146294_l / 2 + 50, 100, 90, 20, this.pump.priority.name());
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            this.func_73731_b(this.field_146289_q, "Throughput:", this.field_146294_l / 2 - 150, 80, 0xA0A0A0);
            this.func_73731_b(this.field_146289_q, "(max. 10,000mB)", this.field_146294_l / 2 - 150, 90, 0xA0A0A0);
            this.textPlacementPriority.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Pressure:", this.field_146294_l / 2 - 50, 80, 0xA0A0A0);
            this.buttonPressure.func_146112_a(this.field_146297_k, mouseX, mouseY);
            this.func_73731_b(this.field_146289_q, "Priority:", this.field_146294_l / 2 + 50, 80, 0xA0A0A0);
            this.buttonPriority.func_146112_a(this.field_146297_k, mouseX, mouseY);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public void func_146281_b() {
            Keyboard.enableRepeatEvents((boolean)false);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("pressure", (byte)this.pressure);
            data.func_74774_a("priority", (byte)this.priority);
            try {
                data.func_74768_a("capacity", Integer.parseInt(this.textPlacementPriority.func_146179_b()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.pump.field_145851_c, this.pump.field_145848_d, this.pump.field_145849_e));
        }

        protected void func_73869_a(char typedChar, int keyCode) {
            super.func_73869_a(typedChar, keyCode);
            if (this.textPlacementPriority.func_146201_a(typedChar, keyCode)) {
                return;
            }
            if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            this.textPlacementPriority.func_146192_a(mouseX, mouseY, mouseButton);
            if (this.buttonPressure.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                ++this.pressure;
                if (this.pressure > 5) {
                    this.pressure = 0;
                }
                this.buttonPressure.field_146126_j = this.pressure + " PU";
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            if (this.buttonPriority.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                ++this.priority;
                if (this.priority >= IEnergyReceiverMK2.ConnectionPriority.values().length) {
                    this.priority = 0;
                }
                this.buttonPriority.field_146126_j = ((Enum)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, this.priority)).name();
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
        }

        public boolean func_73868_f() {
            return false;
        }
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
    public static class TileEntityFluidPump
    extends TileEntityLoadedBase
    implements IFluidStandardTransceiverMK2,
    IControlReceiver,
    SimpleComponent,
    CompatHandler.OCComponent {
        public int bufferSize = 100;
        public FluidTank[] tank;
        public IEnergyReceiverMK2.ConnectionPriority priority = IEnergyReceiverMK2.ConnectionPriority.NORMAL;
        public boolean redstone = false;

        public TileEntityFluidPump() {
            this.tank = new FluidTank[1];
            this.tank[0] = new FluidTank(Fluids.NONE, this.bufferSize);
        }

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                if (this.bufferSize != this.tank[0].getMaxFill()) {
                    int nextBuffer = Math.max(this.tank[0].getFill(), this.bufferSize);
                    this.tank[0].changeTankSize(nextBuffer);
                }
                this.redstone = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                ForgeDirection in = dir.getRotation(ForgeDirection.UP);
                ForgeDirection out = in.getOpposite();
                this.trySubscribe(this.tank[0].getTankType(), this.field_145850_b, this.field_145851_c + in.offsetX, this.field_145848_d, this.field_145849_e + in.offsetZ, in);
                if (!this.redstone) {
                    this.tryProvide(this.tank[0], this.field_145850_b, this.field_145851_c + out.offsetX, this.field_145848_d, this.field_145849_e + out.offsetZ, out);
                }
                this.networkPackNT(15);
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            this.tank[0].writeToNBT(nbt, "t");
            nbt.func_74774_a("p", (byte)this.priority.ordinal());
            nbt.func_74768_a("buffer", this.bufferSize);
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.tank[0].readFromNBT(nbt, "t");
            this.priority = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, nbt.func_74771_c("p")));
            this.bufferSize = nbt.func_74762_e("buffer");
        }

        @Override
        public void serialize(ByteBuf buf) {
            super.serialize(buf);
            this.tank[0].serialize(buf);
            buf.writeByte((int)((byte)this.priority.ordinal()));
            buf.writeInt(this.bufferSize);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            super.deserialize(buf);
            this.tank[0].deserialize(buf);
            this.priority = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, buf.readByte()));
            this.bufferSize = buf.readInt();
        }

        @Override
        public IEnergyReceiverMK2.ConnectionPriority getFluidPriority() {
            return this.priority;
        }

        @Override
        public FluidTank[] getSendingTanks() {
            return this.redstone ? new FluidTank[]{} : this.tank;
        }

        @Override
        public FluidTank[] getReceivingTanks() {
            return this.bufferSize < this.tank[0].getFill() ? new FluidTank[]{} : this.tank;
        }

        @Override
        public FluidTank[] getAllTanks() {
            return this.tank;
        }

        @Override
        public boolean hasPermission(EntityPlayer player) {
            return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
        }

        @Override
        public void receiveControl(NBTTagCompound data) {
            if (data.func_74764_b("capacity")) {
                this.bufferSize = MathHelper.func_76125_a((int)data.func_74762_e("capacity"), (int)0, (int)10000);
            }
            if (data.func_74764_b("pressure")) {
                this.tank[0].withPressure(MathHelper.func_76125_a((int)data.func_74771_c("pressure"), (int)0, (int)5));
            }
            if (data.func_74764_b("priority")) {
                this.priority = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, data.func_74771_c("priority")));
            }
            this.func_70296_d();
        }

        @Override
        @Optional.Method(modid="OpenComputers")
        public String getComponentName() {
            return "ntm_fluid_pump";
        }

        @Callback(direct=true, limit=4)
        @Optional.Method(modid="OpenComputers")
        public Object[] getFluid(Context context, Arguments args) {
            return new Object[]{this.tank[0].getTankType().getUnlocalizedName()};
        }

        @Callback(direct=true, limit=4)
        @Optional.Method(modid="OpenComputers")
        public Object[] getPressure(Context context, Arguments args) {
            return new Object[]{this.tank[0].getPressure()};
        }

        @Callback(direct=true, limit=4)
        @Optional.Method(modid="OpenComputers")
        public Object[] getFlow(Context context, Arguments args) {
            return new Object[]{this.bufferSize};
        }

        @Callback(direct=true, limit=4)
        @Optional.Method(modid="OpenComputers")
        public Object[] getPriority(Context context, Arguments args) {
            return new Object[]{this.getFluidPriority()};
        }

        @Callback(direct=true, limit=4)
        @Optional.Method(modid="OpenComputers")
        public Object[] getInfo(Context context, Arguments args) {
            return new Object[]{this.tank[0].getTankType().getUnlocalizedName(), this.tank[0].getPressure(), this.bufferSize, this.getFluidPriority()};
        }

        @Callback(direct=true, limit=4)
        @Optional.Method(modid="OpenComputers")
        public Object[] setPriority(Context context, Arguments args) {
            int num = args.checkInteger(0);
            switch (num) {
                case 0: {
                    this.priority = IEnergyReceiverMK2.ConnectionPriority.LOWEST;
                    break;
                }
                case 1: {
                    this.priority = IEnergyReceiverMK2.ConnectionPriority.LOW;
                    break;
                }
                case 2: {
                    this.priority = IEnergyReceiverMK2.ConnectionPriority.NORMAL;
                    break;
                }
                case 3: {
                    this.priority = IEnergyReceiverMK2.ConnectionPriority.HIGH;
                    break;
                }
                case 4: {
                    this.priority = IEnergyReceiverMK2.ConnectionPriority.HIGHEST;
                    break;
                }
                default: {
                    return new Object[]{null, "Not a valid Priority."};
                }
            }
            return new Object[]{true};
        }

        @Callback(direct=true, limit=4)
        @Optional.Method(modid="OpenComputers")
        public Object[] setFlow(Context context, Arguments args) {
            int input = args.checkInteger(0);
            if (input > 10000 || input < 0) {
                return new Object[]{null, "Number outside of bounds."};
            }
            this.bufferSize = input;
            return new Object[]{true};
        }

        @Override
        @Optional.Method(modid="OpenComputers")
        public String[] methods() {
            return new String[]{"getPriority", "getPressure", "getFluid", "getFlow", "getInfo", "setPriority", "setFlow"};
        }

        @Override
        @Optional.Method(modid="OpenComputers")
        public Object[] invoke(String method, Context context, Arguments args) throws Exception {
            switch (method) {
                case "getPriority": {
                    return this.getPriority(context, args);
                }
                case "getPressure": {
                    return this.getPressure(context, args);
                }
                case "getFluid": {
                    return this.getFluid(context, args);
                }
                case "getFlow": {
                    return this.getFlow(context, args);
                }
                case "getInfo": {
                    return this.getInfo(context, args);
                }
                case "setPriority": {
                    return this.setPriority(context, args);
                }
                case "setFlow": {
                    return this.setFlow(context, args);
                }
            }
            throw new NoSuchMethodException();
        }
    }
}

