/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class WorldChunkManagerCelestial
extends WorldChunkManager {
    private GenLayer biomeLayer;
    private GenLayer biomeDetailLayer;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);

    public WorldChunkManagerCelestial(BiomeGenLayers layers) {
        this.biomeLayer = layers.biomeLayer;
        this.biomeDetailLayer = layers.biomeDetailLayer;
    }

    public BiomeGenBase func_76935_a(int x, int z) {
        return this.biomeCache.func_76837_b(x, z);
    }

    public float[] func_76936_a(float[] values, int x, int z, int width, int length) {
        IntCache.func_76446_a();
        if (values == null || values.length < width * length) {
            values = new float[width * length];
        }
        int[] biomeIds = this.biomeDetailLayer.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            float f = (float)BiomeGenBase.func_150568_d((int)biomeIds[i]).func_76744_g() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            values[i] = f;
        }
        return values;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float temperature, int y) {
        return temperature;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] biomes, int x, int z, int width, int length) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * length) {
            biomes = new BiomeGenBase[width * length];
        }
        int[] biomeIds = this.biomeLayer.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            biomes[i] = BiomeGenBase.func_150568_d((int)biomeIds[i]);
        }
        return biomes;
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] biomes, int x, int z, int width, int length, boolean flag) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * length) {
            biomes = new BiomeGenBase[width * length];
        }
        if (flag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            BiomeGenBase[] cachedBiomes = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(cachedBiomes, 0, biomes, 0, width * length);
            return biomes;
        }
        int[] biomeIds = this.biomeDetailLayer.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            biomes[i] = BiomeGenBase.func_150568_d((int)biomeIds[i]);
        }
        return biomes;
    }

    public boolean func_76940_a(int x, int z, int size, List biomes) {
        IntCache.func_76446_a();
        int l = x - size >> 2;
        int i1 = z - size >> 2;
        int j1 = x + size >> 2;
        int k1 = z + size >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.biomeLayer.func_75904_a(l, i1, l1, i2);
        for (int j2 = 0; j2 < l1 * i2; ++j2) {
            BiomeGenBase biomeGenBase = BiomeGenBase.func_150568_d((int)aint[j2]);
            if (biomes.contains(biomeGenBase)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition func_150795_a(int x, int z, int size, List biomes, Random rand) {
        IntCache.func_76446_a();
        int l = x - size >> 2;
        int i1 = z - size >> 2;
        int j1 = x + size >> 2;
        int k1 = z + size >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.biomeLayer.func_75904_a(l, i1, l1, i2);
        ChunkPosition chunkposition = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[k2]);
            if (!biomes.contains(biomegenbase) || chunkposition != null && rand.nextInt(j2 + 1) != 0) continue;
            chunkposition = new ChunkPosition(l2, 0, i3);
            ++j2;
        }
        return chunkposition;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public static class BiomeGenLayers {
        private GenLayer biomeLayer;
        private GenLayer biomeDetailLayer;

        public BiomeGenLayers(GenLayer biomeLayer, GenLayer biomeDetailLayer, long seed) {
            this.biomeLayer = biomeLayer;
            this.biomeDetailLayer = biomeDetailLayer;
            biomeLayer.func_75905_a(seed);
            biomeDetailLayer.func_75905_a(seed);
        }
    }
}

