/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.mapgen;

import com.hbm.dim.noise.NoiseCaveGenerator;
import com.hbm.util.BobMathUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class MapGenGreg
extends MapGenCaves {
    public Block stoneBlock = Blocks.field_150348_b;
    private double[] caveNoise;
    private float[] biomeWeightTable;
    private NoiseCaveGenerator noiseCaves;
    public NoiseGeneratorOctaves noiseGen6;
    private NoiseGeneratorOctaves field_147431_j;
    private NoiseGeneratorOctaves field_147432_k;
    private NoiseGeneratorOctaves interpolationNoise;
    private double[] interpolationNoises;
    private double[] lowerInterpolatedNoises;
    private double[] upperInterpolatedNoises;
    private double[] depthNoises;

    public void func_151539_a(IChunkProvider c, World w, int chunkX, int chunkZ, Block[] blocks) {
        if (this.field_75039_c != w) {
            this.caveNoise = new double[825];
            this.biomeWeightTable = new float[25];
            this.field_147431_j = new NoiseGeneratorOctaves(this.field_75038_b, 16);
            this.field_147432_k = new NoiseGeneratorOctaves(this.field_75038_b, 16);
            this.interpolationNoise = new NoiseGeneratorOctaves(this.field_75038_b, 8);
            this.noiseGen6 = new NoiseGeneratorOctaves(this.field_75038_b, 16);
            this.noiseCaves = new NoiseCaveGenerator(this.field_75038_b);
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    float f;
                    this.biomeWeightTable[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
                }
            }
        }
        this.field_75039_c = w;
        this.field_75038_b.setSeed(w.func_72905_C());
        int k = this.field_75040_a;
        long l = this.field_75038_b.nextLong();
        long i1 = this.field_75038_b.nextLong();
        for (int j1 = chunkX - k; j1 <= chunkX + k; ++j1) {
            for (int k1 = chunkZ - k; k1 <= chunkZ + k; ++k1) {
                long l1 = (long)j1 * l;
                long i2 = (long)k1 * i1;
                this.field_75038_b.setSeed(l1 ^ i2 ^ w.func_72905_C());
                this.func_151538_a(w, j1, k1, chunkX, chunkZ, blocks);
            }
        }
        this.generateNoiseCaves(chunkX, chunkZ, blocks);
    }

    private void generateNoiseCaves(int chunkX, int chunkZ, Block[] blocks) {
        this.generateNoiseCavesNoise(chunkX, chunkZ);
        for (int noiseX = 0; noiseX < 4; ++noiseX) {
            int ix0 = noiseX * 5;
            int ix1 = (noiseX + 1) * 5;
            for (int noiseZ = 0; noiseZ < 4; ++noiseZ) {
                int ix0z0 = (ix0 + noiseZ) * 33;
                int ix0z1 = (ix0 + noiseZ + 1) * 33;
                int ix1z0 = (ix1 + noiseZ) * 33;
                int ix1z1 = (ix1 + noiseZ + 1) * 33;
                for (int noiseY = 0; noiseY < 32; ++noiseY) {
                    double x0z0 = this.caveNoise[ix0z0 + noiseY];
                    double x0z1 = this.caveNoise[ix0z1 + noiseY];
                    double x1z0 = this.caveNoise[ix1z0 + noiseY];
                    double x1z1 = this.caveNoise[ix1z1 + noiseY];
                    double x0z0Add = (this.caveNoise[ix0z0 + noiseY + 1] - x0z0) * 0.125;
                    double x0z1Add = (this.caveNoise[ix0z1 + noiseY + 1] - x0z1) * 0.125;
                    double x1z0Add = (this.caveNoise[ix1z0 + noiseY + 1] - x1z0) * 0.125;
                    double x1z1Add = (this.caveNoise[ix1z1 + noiseY + 1] - x1z1) * 0.125;
                    for (int pieceY = 0; pieceY < 8; ++pieceY) {
                        double z0 = x0z0;
                        double z1 = x0z1;
                        double z0Add = (x1z0 - x0z0) * 0.25;
                        double z1Add = (x1z1 - x0z1) * 0.25;
                        for (int pieceX = 0; pieceX < 4; ++pieceX) {
                            int index = pieceX + noiseX * 4 << 12 | noiseZ * 4 << 8 | noiseY * 8 + pieceY;
                            int idAdd = 256;
                            index -= idAdd;
                            double densityAdd = (z1 - z0) * 0.25;
                            double density = z0 - densityAdd;
                            for (int pieceZ = 0; pieceZ < 4; ++pieceZ) {
                                int y;
                                double d;
                                density += densityAdd;
                                if (!(d < 0.0) || (y = noiseY * 8 + pieceY) <= 0 || blocks[index += idAdd] == Blocks.field_150357_h) continue;
                                blocks[index] = null;
                            }
                            z0 += z0Add;
                            z1 += z1Add;
                        }
                        x0z0 += x0z0Add;
                        x0z1 += x0z1Add;
                        x1z0 += x1z0Add;
                        x1z1 += x1z1Add;
                    }
                }
            }
        }
    }

    private void generateNoiseCavesNoise(int chunkX, int chunkZ) {
        int cx = chunkX * 4;
        int cz = chunkZ * 4;
        this.depthNoises = this.noiseGen6.func_76305_a(this.depthNoises, cx, cz, 5, 5, 200.0, 200.0, 0.5);
        this.interpolationNoises = this.interpolationNoise.func_76304_a(this.interpolationNoises, cx, 0, cz, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.lowerInterpolatedNoises = this.field_147431_j.func_76304_a(this.lowerInterpolatedNoises, cx, 0, cz, 5, 33, 5, 684.412, 684.412, 684.412);
        this.upperInterpolatedNoises = this.field_147432_k.func_76304_a(this.upperInterpolatedNoises, cx, 0, cz, 5, 33, 5, 684.412, 684.412, 684.412);
        BiomeGenBase[] biomes = null;
        biomes = this.field_75039_c.func_72959_q().func_76937_a(biomes, cx - 2, cz - 2, 10, 10);
        int i = 0;
        int j = 0;
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                float scale = 0.0f;
                float depth = 0.0f;
                float weight = 0.0f;
                double lowestScaledDepth = 0.0;
                BiomeGenBase biome0 = biomes[x + 2 + (z + 2) * 10];
                for (int x1 = -2; x1 <= 2; ++x1) {
                    for (int z1 = -2; z1 <= 2; ++z1) {
                        BiomeGenBase biome = biomes[x + x1 + 2 + (z + z1 + 2) * 10];
                        float depthHere = biome.field_76748_D;
                        float scaleHere = biome.field_76749_E;
                        float weightHere = this.biomeWeightTable[x1 + 2 + (z1 + 2) * 5] / (depthHere + 2.0f);
                        if (biome.field_76748_D > biome0.field_76748_D) {
                            weightHere /= 2.0f;
                        }
                        scale += scaleHere * weightHere;
                        depth += depthHere * weightHere;
                        weight += weightHere;
                        lowestScaledDepth = Math.min(lowestScaledDepth, (double)biome.field_76748_D);
                    }
                }
                scale /= weight;
                depth /= weight;
                scale = scale * 0.9f + 0.1f;
                depth = (depth * 4.0f - 1.0f) / 8.0f;
                double depthNoise = this.depthNoises[j] / 8000.0;
                if (depthNoise < 0.0) {
                    depthNoise = -depthNoise * 0.3;
                }
                if ((depthNoise = depthNoise * 3.0 - 2.0) < 0.0) {
                    if ((depthNoise /= 2.0) < -1.0) {
                        depthNoise = -1.0;
                    }
                    depthNoise /= 1.4;
                    depthNoise /= 2.0;
                } else {
                    if (depthNoise > 1.0) {
                        depthNoise = 1.0;
                    }
                    depthNoise /= 8.0;
                }
                ++j;
                double scaledDepth = depth;
                double scaledScale = scale;
                scaledDepth += depthNoise * 0.2;
                scaledDepth = scaledDepth * 8.5 / 8.0;
                double terrainHeight = 8.5 + scaledDepth * 4.0;
                double startLevel = 56.0 + lowestScaledDepth * 20.0;
                int sub = (int)(startLevel / 8.0);
                for (int y = 0; y < 33; ++y) {
                    double falloff = ((double)y - terrainHeight) * 12.0 * 128.0 / 256.0 / scaledScale;
                    if (falloff < 0.0) {
                        falloff *= 4.0;
                    }
                    double lowerNoise = this.lowerInterpolatedNoises[i] / 512.0;
                    double upperNoise = this.upperInterpolatedNoises[i] / 512.0;
                    double interpolation = (this.interpolationNoises[i] / 10.0 + 1.0) / 2.0;
                    double noise = MathHelper.func_151238_b((double)lowerNoise, (double)upperNoise, (double)interpolation) - falloff;
                    if (y > 29) {
                        double lerp = (float)(y - 29) / 3.0f;
                        noise = noise * (1.0 - lerp) + -10.0 * lerp;
                    }
                    double caveNoise = this.noiseCaves.sample(noise, y * 8, chunkZ * 16 + z * 4, chunkX * 16 + x * 4);
                    this.caveNoise[i] = caveNoise = BobMathUtil.clampedLerp(caveNoise, lowestScaledDepth * -30.0 + 20.0, (double)(y - sub + 2) / 2.0);
                    ++i;
                }
            }
        }
    }

    protected void digBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        BiomeGenBase biome = this.field_75039_c.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
        Block top = biome.field_76752_A;
        Block filler = biome.field_76753_B;
        Block block = data[index];
        if (block == this.stoneBlock || block == filler || block == top) {
            if (y < 2) {
                data[index] = Blocks.field_150356_k;
            } else {
                data[index] = null;
                if (foundTop && data[index - 1] == filler) {
                    data[index - 1] = top;
                }
            }
        }
    }
}

