/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.moho;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockOre;
import com.hbm.config.SpaceConfig;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.main.StructureManager;
import com.hbm.world.gen.nbt.JigsawPiece;
import com.hbm.world.gen.nbt.JigsawPool;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.gen.nbt.SpawnCondition;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGeneratorMoho
implements IWorldGenerator {
    public WorldGeneratorMoho() {
        NBTStructure.registerStructure(SpaceConfig.mohoDimension, new SpawnCondition("moho_base"){
            {
                this.spawnWeight = 4;
                this.minHeight = 52;
                this.maxHeight = 63;
                this.sizeLimit = 64;
                this.rangeLimit = 64;
                this.startPool = "start";
                this.pools = new HashMap<String, JigsawPool>(){
                    {
                        this.put("start", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("moho_core", StructureManager.moho_core){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                            }
                        });
                        this.put("default", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("moho_corner_lab", StructureManager.moho_corner_lab){
                                    {
                                        this.heightOffset = -14;
                                    }
                                }, 2);
                                this.add(new JigsawPiece("moho_corner_heffer", StructureManager.moho_corner_heffer){
                                    {
                                        this.heightOffset = -17;
                                    }
                                }, 2);
                                this.add(new JigsawPiece("moho_corner_extension", StructureManager.moho_corner_extension){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("moho_corner_empty", StructureManager.moho_corner_empty){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                                this.fallback = "fallback";
                            }
                        });
                        this.put("room", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("moho_room_tape", StructureManager.moho_room_tape){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("moho_room_reception", StructureManager.moho_room_reception){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("moho_room_kitchen", StructureManager.moho_room_kitchen){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                                this.fallback = "room";
                            }
                        });
                        this.put("fallback", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("moho_fall", StructureManager.moho_corner_cap){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                            }
                        });
                        this.put("snorkel", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("moho_snorkel", StructureManager.moho_snorkel){
                                    {
                                        this.heightOffset = -11;
                                    }
                                }, 1);
                            }
                        });
                    }
                };
            }
        });
        NBTStructure.registerNullWeight(SpaceConfig.mohoDimension, 20);
        BlockOre.addValidBody(ModBlocks.ore_mineral, SolarSystem.Body.MOHO);
        BlockOre.addValidBody(ModBlocks.ore_shale, SolarSystem.Body.MOHO);
        BlockOre.addValidBody(ModBlocks.ore_glowstone, SolarSystem.Body.MOHO);
        BlockOre.addValidBody(ModBlocks.ore_fire, SolarSystem.Body.MOHO);
        BlockOre.addValidBody(ModBlocks.ore_australium, SolarSystem.Body.MOHO);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == SpaceConfig.mohoDimension) {
            this.generateMoho(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateMoho(World world, Random rand, int i, int j) {
        Block b;
        int meta = CelestialBody.getMeta(world);
        Block stone = ((WorldProviderCelestial)world.field_73011_w).getStone();
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.mineralSpawn, 10, 12, 32, ModBlocks.ore_mineral, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 14, 12, 5, 30, ModBlocks.ore_glowstone, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherPhosphorusSpawn, 6, 8, 64, ModBlocks.ore_fire, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 8, 4, 0, 24, ModBlocks.ore_australium, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 1, 12, 8, 32, ModBlocks.ore_shale, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 10, 32, 0, 128, ModBlocks.basalt, 0, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 16, 6, 16, 64, ModBlocks.ore_basalt, 0, ModBlocks.basalt);
        DungeonToolbox.generateOre(world, rand, i, j, 12, 8, 8, 32, ModBlocks.ore_basalt, 1, ModBlocks.basalt);
        DungeonToolbox.generateOre(world, rand, i, j, 8, 9, 8, 48, ModBlocks.ore_basalt, 2, ModBlocks.basalt);
        DungeonToolbox.generateOre(world, rand, i, j, 2, 4, 0, 24, ModBlocks.ore_basalt, 3, ModBlocks.basalt);
        DungeonToolbox.generateOre(world, rand, i, j, 8, 10, 16, 64, ModBlocks.ore_basalt, 4, ModBlocks.basalt);
        for (int k = 0; k < 2; ++k) {
            int x = i + rand.nextInt(16) + 8;
            int z = j + rand.nextInt(16) + 8;
            int d = 16 + rand.nextInt(96);
            for (int y = d - 5; y <= d; ++y) {
                b = world.func_147439_a(x, y, z);
                if (world.func_147439_a(x, y + 1, z) != Blocks.field_150350_a || b != ModBlocks.moho_stone && b != ModBlocks.moho_regolith) continue;
                world.func_147449_b(x, y, z, ModBlocks.geysir_nether);
                world.func_147449_b(x + 1, y, z, Blocks.field_150424_aL);
                world.func_147449_b(x - 1, y, z, Blocks.field_150424_aL);
                world.func_147449_b(x, y, z + 1, Blocks.field_150424_aL);
                world.func_147449_b(x, y, z - 1, Blocks.field_150424_aL);
                world.func_147449_b(x + 1, y - 1, z, Blocks.field_150424_aL);
                world.func_147449_b(x - 1, y - 1, z, Blocks.field_150424_aL);
                world.func_147449_b(x, y - 1, z + 1, Blocks.field_150424_aL);
                world.func_147449_b(x, y - 1, z - 1, Blocks.field_150424_aL);
            }
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 32; y < 128; ++y) {
                    int ox = i + x + 8;
                    int oz = j + z + 8;
                    b = world.func_147439_a(ox, y, oz);
                    if (b == Blocks.field_150353_l && world.func_147439_a(ox, y - 1, oz) == Blocks.field_150350_a) {
                        world.func_147465_d(ox, y - 1, oz, (Block)Blocks.field_150356_k, 0, 0);
                        world.func_147471_g(ox, y - 1, oz);
                        continue;
                    }
                    if (b != ModBlocks.volcano_core) continue;
                    world.func_147465_d(ox, y, oz, ModBlocks.volcano_core, 1, 0);
                    world.func_147471_g(ox, y, oz);
                }
            }
        }
    }
}

